const FRAMEBRXC = {

};

window.ADMINBRXC = {
    globalSettings: {
        generalCats: [],
        keyboardShortcuts: {
        },
        disableIDStyles: false,
        integrations:{
        },
        elements : [],
        styleControls: [],
    },
    vue: document.querySelector('.brx-body').__vue_app__,
    vueGlobalProp: document.querySelector('.brx-body').__vue_app__.config.globalProperties,
    vueState: document.querySelector('.brx-body').__vue_app__.config.globalProperties.$_state,
    cssVariables: [],
    cssVariablesHints: [],
    nestableElements: [],
    helpers: {
        bpIcons: function(device){
            let svg = '<span class="bricks-svg-wrapper"><svg version="1.1" viewBox="0 0 30 30" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" class="bricks-svg"><path d="M27.744,2.5h-25.488c-0.968,0 -1.756,0.788 -1.756,1.755v17.489c0,0.968 0.788,1.755 1.756,1.755h12.244v3h-5.5c-0.276,0 -0.5,0.224 -0.5,0.5c0,0.276 0.224,0.5 0.5,0.5h12c0.276,0 0.5,-0.224 0.5,-0.5c0,-0.276 -0.224,-0.5 -0.5,-0.5h-5.5v-3h12.244c0.968,0 1.756,-0.788 1.756,-1.755v-17.489c0,-0.967 -0.788,-1.755 -1.756,-1.755Zm-1.244,18h-23v-15h23v15Z" fill="currentColor"></path></svg></span>';
            if( device === "laptop") {
                svg = '<span class="bricks-svg-wrapper"><svg version="1.1" viewBox="0 0 512 512" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" class="bricks-svg"><path d="M80.14,400c-17.7503,0 -32.14,-14.3897 -32.14,-32.14v-239.72c0,-17.7503 14.3897,-32.14 32.14,-32.14h351.72c17.7503,0 32.14,14.3897 32.14,32.14v239.72c0,17.7503 -14.3897,32.14 -32.14,32.14Z" stroke-width="32" stroke="currentColor" fill="none" stroke-linejoin="round"></path><path fill="currentColor" stroke="currentColor" stroke-linecap="round" stroke-width="32" d="M16,416h480"></path></svg></span>';
            }
            if( device === "tablet-landscape") {
                svg = '<span class="bricks-svg-wrapper"><svg version="1.1" viewBox="0 0 512 512" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" class="bricks-svg"><g transform="matrix(1,0,0,1,0,512)"><path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="32" d="M128,496c-26.5094,0 -48,-21.4906 -48,-48v-384c0,-26.5094 21.4906,-48 48,-48h256c26.5094,0 48,21.4906 48,48v384c0,26.5094 -21.4906,48 -48,48Z" transform="matrix(6.12323e-17,-1,1,6.12323e-17,0,0)"></path></g></svg></span>';
            }
            if( device === "tablet-portrait") {
                svg = '<span class="bricks-svg-wrapper"><svg version="1.1" viewBox="0 0 512 512" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" class="bricks-svg"><path d="M128,496c-26.5094,0 -48,-21.4906 -48,-48v-384c0,-26.5094 21.4906,-48 48,-48h256c26.5094,0 48,21.4906 48,48v384c0,26.5094 -21.4906,48 -48,48Z" stroke-linecap="round" stroke-width="32" stroke="currentColor" fill="none" stroke-linejoin="round"></path></svg></span>';
            }
            if( device === "phone-landscape") {
                svg = '<span class="bricks-svg-wrapper"><svg version="1.1" viewBox="0 0 512 512" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" class="bricks-svg"><g transform="matrix(1,0,0,1,0,512)"><path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="32" d="M176,496c-26.5094,0 -48,-21.4906 -48,-48v-384c0,-26.5094 21.4906,-48 48,-48h160c26.5094,0 48,21.4906 48,48v384c0,26.5094 -21.4906,48 -48,48Z" transform="matrix(6.12323e-17,-1,1,6.12323e-17,0,0)"></path></g><path d="M16,336v-24l9.23706e-14,1.20797e-06c-6.67141e-07,-4.41828 3.58172,-8 8,-8v0h-6.99382e-07c8.83656,3.86258e-07 16,-7.16344 16,-16v-64v0c0,-8.83656 -7.16344,-16 -16,-16v0h-3.49691e-07c-4.41828,-1.93129e-07 -8,-3.58172 -8,-8c0,0 0,-2.84217e-14 0,-2.84217e-14v-24" stroke-linecap="round" stroke-width="32" stroke="currentColor" fill="none" stroke-linejoin="round"></path></svg></span>';
            }
            if( device === "phone-portrait") {
                svg = '<span class="bricks-svg-wrapper"><svg version="1.1" viewBox="0 0 512 512" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" class="bricks-svg"><g stroke-linecap="round" stroke-width="32" stroke="currentColor" fill="none" stroke-linejoin="round"><path d="M176,496c-26.5094,0 -48,-21.4906 -48,-48v-384c0,-26.5094 21.4906,-48 48,-48h160c26.5094,0 48,21.4906 48,48v384c0,26.5094 -21.4906,48 -48,48Z"></path><path d="M176,16h24l-3.49691e-07,7.10543e-15c4.41828,-1.93129e-07 8,3.58172 8,8v0l1.7053e-13,2.41593e-06c1.33428e-06,8.83656 7.16345,16 16,16h64l-6.99382e-07,-1.42109e-14c8.83656,3.86258e-07 16,-7.16344 16,-16v0l1.13687e-13,1.20797e-06c-6.67141e-07,-4.41828 3.58172,-8 8,-8h24"></path></g></svg></span>';
            }
            return svg;
        },
        // Get keys settings divided by pseudo
        stylesByPseudo: function(settings){
            const arr = {};
            const hasPseudo = []
            const pseudos = ADMINBRXC.vueState.pseudoClasses;
            pseudos.forEach(pseudo => {
                const nestedArr = Object.keys(settings).filter(key => key && ADMINBRXC.helpers.isCSSControlKey(key.split(':')[0]) && key.includes(pseudo));
                nestedArr.forEach(el => hasPseudo.push(el));
                arr[pseudo.replace(':', '')] = nestedArr
            })
            arr['no-pseudo'] = Object.keys(settings).filter(key => key && ADMINBRXC.helpers.isCSSControlKey(key.split(':')[0]) && !hasPseudo.includes(key));
            return arr;
        },
        // Get unique keys settings divided by pseudo and
        uniqueKeysByPseudo: function(settings){
            arr = ADMINBRXC.helpers.stylesByPseudo(settings);
            for(const row of Object.keys(arr)){
                const newArr = arr[row].map(property => property.split(":")[0]);
                arr[row] = [...new Set(newArr)];
            }
            return arr;
        },
        // Global Colors
        isGlobalColorsTabActive: function(){
            if (Object.values(ADMINBRXC.globalSettings.themeSettingsTabs).includes("global-colors")) return true;
            return false;
        },
        // CSS Variables
        isCSSVariablesTabActive: function(option){
            if (Object.values(ADMINBRXC.globalSettings.themeSettingsTabs).includes("css-variables")) return true;
            return false;
        },
        // Classes & Styles
        isClassesAndStylesTabActive: function(option){
            if (Object.values(ADMINBRXC.globalSettings.themeSettingsTabs).includes("classes-and-styles")) return true;
            return false;
        },
        // Builder Tweaks
        isBuilderTweaksTabActive: function(option){
            if (Object.values(ADMINBRXC.globalSettings.themeSettingsTabs).includes("builder-tweaks")) return true;
            return false;
        },
        // AI
        isAIActive: function(){
            if (Object.values(ADMINBRXC.globalSettings.themeSettingsTabs).includes("ai") ) return true;
            return false;
        },
        // Custom Elements
        isCustomElements: function(option){
            if (ADMINBRXC.helpers.isBuilderTweaksTabActive('elements') && Object.values(ADMINBRXC.globalSettings.defaultElementFeatures).includes(option) ) return true;
            return false;
        },
        isCSSControlKey: function(key){
            if(ADMINBRXC.CSScontrolKeys.includes(JSON.parse(JSON.stringify(key.split(":")[0]))) && !ADMINBRXC.excludedControlKeyFromCSS.includes(JSON.parse(JSON.stringify(key.split(":")[0])))){
                return true;
            }
            return false;
        },
        isClassActive: function(){
            const activeClass = ADMINBRXC.vueState.activeClass;
            if (typeof activeClass === "undefined" 
            || !activeClass.hasOwnProperty('id') 
            || !ADMINBRXC.vueState.activeElement.settings.hasOwnProperty('_cssGlobalClasses') 
            || !Array.isArray(ADMINBRXC.vueState.activeElement.settings._cssGlobalClasses) 
            || ADMINBRXC.vueState.activeElement.settings._cssGlobalClasses.indexOf(activeClass.id) === -1) return false;
            return true;
        },
        getTemplateType: function(){
            const templateType = ADMINBRXC.vueState.templateType;
            if(templateType === "section" || templateType === "archive" || templateType === "error" || templateType === "popup" || templateType === "search" || !ADMINBRXC.vueState.hasOwnProperty(templateType)){
                return "content";
            } else {
                return templateType;
            }
        },
        clampBuilder: function(baseFont, minWidthPx, maxWidthPx, minFontSize, maxFontSize) {
 
            const minWidth = minWidthPx / baseFont;
            const maxWidth = maxWidthPx / baseFont;
         
            const slope = (maxFontSize - minFontSize) / (maxWidth - minWidth);
            const yAxisIntersection = -minWidth * slope + minFontSize;
            
            function formatNumber(num) {
                const formattedNum = num.toFixed(3).replace(/\.?0+$/, '');
                return formattedNum;
            }
            const unit = ADMINBRXC.globalSettings.generalCats.clampUnit ? ADMINBRXC.globalSettings.generalCats.clampUnit: 'vw';
         
            return `clamp(${ formatNumber(minFontSize / baseFont)  }rem, ${ formatNumber(yAxisIntersection / baseFont)  }rem + ${ formatNumber(slope / baseFont * 100) }${unit}, ${ formatNumber(maxFontSize / baseFont) }rem)`;
         },
         isElementActive: function(){
            if(ADMINBRXC.vueState.activePanel !== "element" || !typeof ADMINBRXC.vueState.activeElement === "object") return false;
            return true;
         },
         isValidCSSClassName: function(className) {
            if (!/^[a-zA-Z_\-]/.test(className)) {
              return false;
            }
          
            if (!/^[a-zA-Z0-9_\-\s]*$/.test(className)) {
              return false;
            }
          
            return true;
        },
        createClassCategory: function(name){
            if(!name) return;
            if(ADMINBRXC.helpers.getClassCategoryIdByName(name.toLowerCase()) !== false) ADMINBRXC.vueGlobalProp.$_showMessage('ABORT: Category already exists!');
            ADMINBRXC.vueState.globalClassesCategories.push({
                id: ADMINBRXC.vueGlobalProp.$_generateId(),
                name: name,
            })
            ADMINBRXC.populateClassCategories();
            // if(!ADMINBRXC.states.hasOwnProperty('classManagerCategories')) ADMINBRXC.states.classManagerCategories = ['All'];
            // const index = ADMINBRXC.states.classManagerCategories.findIndex(element => {
            //     return element.toLowerCase() === name.toLowerCase();
            //  });
            // if(index !== -1) return;
            // const tempCat = ADMINBRXC.states.classManagerCategories;
            // tempCat.splice(0,2);
            // tempCat.push(name);
            // tempCat.sort((a, b) => a.localeCompare(b, undefined, {sensitivity: 'base'}))
            // ADMINBRXC.states.classManagerCategories = ['All', 'Uncategorized'].concat(tempCat);
        },
        checkClassName: function(classname, list = false){
            let format = classname.replaceAll('<span class="brxc_changes">', '');
            format = format.replaceAll('</span>', '')
            if(Array.from(ADMINBRXC.vueState.globalClasses).find(el => el && el.name === `${format}`)){
                if (list) return ADMINBRXC.helpers.checkClassName(`${classname}<span class="brxc_changes">-new</span>`, list);
                return ADMINBRXC.helpers.checkClassName(`${classname}-new`, list);
            } else {
                return `${classname}`;
            }
        },
        isFramework(id){
            if(id && id.startsWith('acss')) return true;
            return false;
        },
        isElementQueryLoop(id){
            const obj = ADMINBRXC.vueGlobalProp.$_getElementObject(id);
            if(obj.settings.hasOwnProperty('hasLoop') && obj.settings.hasLoop === true) return true;
            return false;
        },
        setPrefix: function(name, type, isFramework){
            let prefix = '';
            type === "colors" ? prefix = ADMINBRXC.globalSettings.generalCats.globalColorsPrefix : prefix = ADMINBRXC.globalSettings.generalCats.globalPrefix;
            if(prefix === '' || name.startsWith(prefix) || isFramework) return name;
            return `${prefix}-${name}`;
        },
        escapeHtmlSpecialChars: function(input) {
            const entityMap = {
                '&': '&amp;',
                '<': '&lt;',
                '>': '&gt;',
                '"': '&quot;',
                "'": '&#39;',
                '/': '&#47;',
                '`': '&#96;',
                '!': '&#33;',
                '@': '&#64;',
                '#': '&#35;',
                '$': '&#36;',
                '%': '&#37;',
                '^': '&#94;',
                '*': '&#42;',
                '(': '&#40;',
                ')': '&#41;',
                '+': '&#43;',
                '=': '&#61;',
                '{': '&#123;',
                '}': '&#125;',
                '[': '&#91;',
                ']': '&#93;',
                '|': '&#124;',
                '\\': '&#92;',
                ':': '&#58;',
                ';': '&#59;',
                ',': '&#44;',
                '.': '&#46;',
                '?': '&#63;',
                '~': '&#126;'
            };
        
            return input.replace(/[&<>"'\/`!@#$%^*()+=\{\}\[\]|\\:;,.<>?~]/g, (char) => entityMap[char]);
        },
        formatForClasses: function(input){
            return input.trim().replaceAll(/[^a-zA-Z0-9_-]+/g, '-').toLowerCase();
        },
        checkBreakpointFormat: function(property){
            const bpSettings = Array.from(ADMINBRXC.vueState.breakpoints).find(el => el && el.key === ADMINBRXC.vueState.breakpointActive);
            if(bpSettings.key !== "desktop"){
                property += `:${bpSettings.key}`;
            }
            return property;
        },
        isVarActiveOnPage: function(colorRaw){
            // content
            const contentType = ADMINBRXC.helpers.getTemplateType();
            const content = ADMINBRXC.vueState[contentType];
            let string = (content) ? JSON.stringify(content) : '';

            // check if colorRaw is active
            if(string.includes(colorRaw)) return true;

            // theme settings
            const themeSettings = ADMINBRXC.vueState.themeStyleSettings;
            string = (themeSettings) ? JSON.stringify(themeSettings) : '';

            // check if colorRaw is active
            if(string.includes(colorRaw)) return true;

            // active classes
            let cls = [];
            string = "";
            if (Array.isArray(content) && content.length > 0) {
                cls = content.reduce((accumulator, el) => {
                    if (
                        el.settings.hasOwnProperty('_cssGlobalClasses') &&
                        Array.isArray(el.settings._cssGlobalClasses) &&
                        el.settings._cssGlobalClasses.length > 0
                    ) {
                        accumulator.push(...el.settings._cssGlobalClasses);
                    }
                    return accumulator;
                }, cls);
            }
            cls = [...new Set(cls)];
            if(cls.length > 0){
                cls.forEach(el =>{
                    string += JSON.stringify(ADMINBRXC.vueGlobalProp.$_getGlobalClass(el));
                })
            }

            // check if colorRaw is active
            if(string.includes(colorRaw)) return true;

            return false;
        },
        setCursorToLastRowMinusOne: function(codeMirror) {
            const lineCount = codeMirror.lineCount();
            if(!lineCount) return;
            const lastLine = lineCount - 2;
            const getLine = codeMirror.getLine(lastLine);
            if(!getLine) return;
            const lastCh = getLine.length;
            codeMirror.setCursor({ line: lastLine, ch: lastCh });
        },
        replaceRWithRoot: function (codeMirror, event) {
            const self = this;
            const cursor = codeMirror.getCursor();
            const lineContent = codeMirror.getLine(cursor.line);
            const cursorPos = cursor.ch;
            const currentWord = codeMirror.getRange(...Object.values(codeMirror.findWordAt(cursor)))

            // r = %root%
            if (cursorPos > 0 && lineContent[cursorPos - 1].toLowerCase() === 'r') {
                event.preventDefault();
                const pos = (lineContent[cursorPos - 1] === "R") ? ' {\n\t\n}' : '';
                
                codeMirror.replaceRange(`%root%${pos}`, { line: cursor.line, ch: cursorPos - 1 }, cursor);

                if((lineContent[cursorPos - 1] === "R")){
                    const newCursor = {
                        line: cursor.line + 1,
                        ch: cursorPos,
                    };
                    
                    codeMirror.setCursor(newCursor);
                }
                
                return;
            }

            // rh = %root%:hover
            if (cursorPos > 1 && lineContent[cursorPos - 2].toLowerCase() === 'r' && lineContent[cursorPos - 1] === 'h') {
                event.preventDefault();
                const pos = (lineContent[cursorPos - 2] === "R") ? ' {\n\t\n}' : '';

                codeMirror.replaceRange(`%root%:hover${pos}`, { line: cursor.line, ch: cursorPos - 2 }, cursor);

                if((lineContent[cursorPos - 2] === "R")){
                    const newCursor = {
                        line: cursor.line + 1,
                        ch: cursorPos,
                    };
                    
                    codeMirror.setCursor(newCursor);
                }

                return;
            }

            // rb = %root%::before
            if (cursorPos > 1 && lineContent[cursorPos - 2].toLowerCase() === 'r' && lineContent[cursorPos - 1] === 'b') {
                event.preventDefault();
                const pos = (lineContent[cursorPos - 2] === "R") ? ' {\n\t\n}' : '';

                codeMirror.replaceRange(`%root%::before${pos}`, { line: cursor.line, ch: cursorPos - 2 }, cursor);

                if((lineContent[cursorPos - 2] === "R")){
                    const newCursor = {
                        line: cursor.line + 1,
                        ch: cursorPos,
                    };
                    
                    codeMirror.setCursor(newCursor);
                }

                return;
            }

            // ra = %root%::after
            if (cursorPos > 1 && lineContent[cursorPos - 2].toLowerCase() === 'r' && lineContent[cursorPos - 1] === 'a') {
                event.preventDefault();
                const pos = (lineContent[cursorPos - 2] === "R") ? ' {\n\t\n}' : '';

                codeMirror.replaceRange(`%root%::after${pos}`, { line: cursor.line, ch: cursorPos - 2 }, cursor);

                if((lineContent[cursorPos - 2] === "R")){
                    const newCursor = {
                        line: cursor.line + 1,
                        ch: cursorPos,
                    };
                    
                    codeMirror.setCursor(newCursor);
                }
                
                return;
            }

            // rf = %root%:focus
            if (cursorPos > 1 && lineContent[cursorPos - 2].toLowerCase() === 'r' && lineContent[cursorPos - 1] === 'f') {
                event.preventDefault();
                const pos = (lineContent[cursorPos - 2] === "R") ? ' {\n\t\n}' : '';

                codeMirror.replaceRange(`%root%:focus${pos}`, { line: cursor.line, ch: cursorPos - 2 }, cursor);

                if((lineContent[cursorPos - 2] === "R")){
                    const newCursor = {
                        line: cursor.line + 1,
                        ch: cursorPos,
                    };
                    
                    codeMirror.setCursor(newCursor);
                }
                
                return;
            }

            // rcf = %root%:first-child
            if (cursorPos > 2 && lineContent[cursorPos - 3].toLowerCase() === 'r' && lineContent[cursorPos - 2] === 'c' && lineContent[cursorPos - 1] === 'f') {
                event.preventDefault();
                const pos = (lineContent[cursorPos - 3] === "R") ? ' {\n\t\n}' : '';

                codeMirror.replaceRange(`%root%:first-child${pos}`, { line: cursor.line, ch: cursorPos - 3 }, cursor);

                if((lineContent[cursorPos - 3] === "R")){
                    const newCursor = {
                        line: cursor.line + 1,
                        ch: cursorPos,
                    };
                    
                    codeMirror.setCursor(newCursor);
                }
                
                return;
            }

            // rcl = %root%:last-child
            if (cursorPos > 2 && lineContent[cursorPos - 3].toLowerCase() === 'r' && lineContent[cursorPos - 2] === 'c' && lineContent[cursorPos - 1] === 'l') {
                event.preventDefault();
                const pos = (lineContent[cursorPos - 3] === "R") ? ' {\n\t\n}' : '';

                codeMirror.replaceRange(`%root%:last-child${pos}`, { line: cursor.line, ch: cursorPos - 3 }, cursor);

                if((lineContent[cursorPos - 3] === "R")){
                    const newCursor = {
                        line: cursor.line + 1,
                        ch: cursorPos,
                    };
                    
                    codeMirror.setCursor(newCursor);
                }
                
                return;
            }

            //rc1 = %root%:nth-child(1)
            if (currentWord.length > 2 && currentWord[0].toLowerCase() === "r" && currentWord[1].toLowerCase() === "c") {
                event.preventDefault();
                const pos = (lineContent[cursorPos - 3] === "R") ? ' {\n\t\n}' : '';
                const word = codeMirror.findWordAt(cursor);

                codeMirror.replaceRange(`%root%:nth-child(${currentWord.substring(2)})${pos}`,word.anchor, word.head);

                if((currentWord[0] === "R")){
                    const newCursor = {
                        line: cursor.line + 1,
                        ch: cursorPos,
                    };
                    
                    codeMirror.setCursor(newCursor);
                }
                
                return;
            }

            // rtf = %root%:first-of-type
            if (cursorPos > 2 && lineContent[cursorPos - 3].toLowerCase() === 'r' && lineContent[cursorPos - 2] === 't' && lineContent[cursorPos - 1] === 'f') {
                event.preventDefault();
                const pos = (lineContent[cursorPos - 3] === "R") ? ' {\n\t\n}' : '';

                codeMirror.replaceRange(`%root%:first-of-type${pos}`, { line: cursor.line, ch: cursorPos - 3 }, cursor);

                if((lineContent[cursorPos - 3] === "R")){
                    const newCursor = {
                        line: cursor.line + 1,
                        ch: cursorPos,
                    };
                    
                    codeMirror.setCursor(newCursor);
                }
                
                return;
            }

            // rtl = %root%:last-of-type
            if (cursorPos > 2 && lineContent[cursorPos - 3].toLowerCase() === 'r' && lineContent[cursorPos - 2] === 't' && lineContent[cursorPos - 1] === 'l') {
                event.preventDefault();
                const pos = (lineContent[cursorPos - 3] === "R") ? ' {\n\t\n}' : '';

                codeMirror.replaceRange(`%root%:last-of-type${pos}`, { line: cursor.line, ch: cursorPos - 3 }, cursor);

                if((lineContent[cursorPos - 3] === "R")){
                    const newCursor = {
                        line: cursor.line + 1,
                        ch: cursorPos,
                    };
                    
                    codeMirror.setCursor(newCursor);
                }
                
                return;
            }

            //rt1 = %root%:nth-of-type(1)
            if (currentWord.length > 2 && currentWord[0].toLowerCase() === "r" && currentWord[1].toLowerCase() === "t") {
                event.preventDefault();
                const pos = (currentWord[0] === "R") ? ' {\n\t\n}' : '';
                const word = codeMirror.findWordAt(cursor);

                codeMirror.replaceRange(`%root%:nth-of-type(${currentWord.substring(2)})${pos}`,word.anchor, word.head);

                if((currentWord[0] === "R")){
                    const newCursor = {
                        line: cursor.line + 1,
                        ch: cursorPos,
                    };
                    
                    codeMirror.setCursor(newCursor);
                }
                
                return;
            }

            //@media queuries
            if (currentWord.length > 1 && currentWord[0].toLowerCase() === "q" && currentWord[1].toLowerCase() === "c") {
                event.preventDefault();
                const mq = (ADMINBRXC.vueGlobalProp.$_isMobileFirst._value) ? 'min' : 'max';
                const word = codeMirror.findWordAt(cursor);
                const content = (currentWord[0] === "Q") ? '\n\t%root% {\n\t\t\n\t}\n' : '\n\t\n';
                const pos = (currentWord[0] === "Q") ? 2 : 1;

                codeMirror.replaceRange(`@media screen and (${mq}-width: ${ADMINBRXC.vueState.previewWidth}px) {${content}}`,word.anchor, word.head);

                const newCursor = {
                    line: cursor.line + pos,
                    ch: cursorPos,
                };
                
                codeMirror.setCursor(newCursor);
                return;

            } else if(currentWord.length > 1 && currentWord[0].toLowerCase() === "q"){
                event.preventDefault();
                const mq = (ADMINBRXC.vueGlobalProp.$_isMobileFirst._value) ? 'min' : 'max';
                const word = codeMirror.findWordAt(cursor);
                const content = (currentWord[0] === "Q") ? '\n\t%root% {\n\t\t\n\t}\n' : '\n\t\n';
                const pos = (currentWord[0] === "Q") ? 2 : 1;

                codeMirror.replaceRange(`@media screen and (${mq}-width: ${currentWord.substring(1)}) {${content}}`,word.anchor, word.head);

                const newCursor = {
                    line: cursor.line + pos,
                    ch: cursorPos,
                };
                
                codeMirror.setCursor(newCursor);
                return;
            }
        },
        saveChanges: function(cat){
            if(Array.isArray(ADMINBRXC.vueState.unsavedChanges) && !ADMINBRXC.vueState.unsavedChanges.includes(cat)) ADMINBRXC.vueState.unsavedChanges.push(cat);
        },
        createTarget: function (target){
            const bpSettings = Array.from(ADMINBRXC.vueState.breakpoints).find(el => el && el.key === ADMINBRXC.vueState.breakpointActive);
            if(bpSettings.key !== "desktop"){
                target += `:${bpSettings.key}`;
            }
            return target;
        },
        createTargetWithPseudo: function (target){
            const bpSettings = Array.from(ADMINBRXC.vueState.breakpoints).find(el => el && el.key === ADMINBRXC.vueState.breakpointActive);
            if(bpSettings.key !== "desktop"){
                target += `:${bpSettings.key}`;
            }
            if(ADMINBRXC.vueState.pseudoClassActive !== ''){
                target += ADMINBRXC.vueState.pseudoClassActive;
            }
            return target;
        },
        checkHigherBreakpoint: function(target, type){
            const currentBp = Array.from(ADMINBRXC.vueState.breakpoints).find(el => el && el.key === ADMINBRXC.vueState.breakpointActive);
            let indexBp = ADMINBRXC.vueState.breakpoints.indexOf(currentBp);
            let obj;
            type === "element" ? obj = ADMINBRXC.vueState.activeElement : obj = ADMINBRXC.vueState.activeClass;
            if (!obj || !obj.hasOwnProperty('settings')) return false;

            function checkBp(index){
                if(index - 1 === -1) return false;
                const key = ADMINBRXC.vueState.breakpoints[index - 1].key;
                const finalTarget = key === "desktop" ? target : `${target}:${key}`;
                if(obj.settings.hasOwnProperty(finalTarget)) {
                    return finalTarget;
                } else {
                    return checkBp(index - 1);
                }
            }
            return checkBp(parseInt(indexBp));

        },
        setActiveItem: function(selectors, event){
            const li = document.querySelectorAll(selectors);
            if(!li || li.length < 1) return; 
            li.forEach(el => {
                el.classList.remove('active');
            })
            event.target.classList.add('active');
        },
        themeHasVariables: function(){
            if(ADMINBRXC.vueState.themeStyleSettings && ADMINBRXC.vueState.themeStyleSettings.hasOwnProperty('general') && ADMINBRXC.vueState.themeStyleSettings.general.hasOwnProperty('_cssVariables')) return true;
            return false;
        },
        createThemeVariable: function(){
            if(!ADMINBRXC.vueState.themeStyleSettings.hasOwnProperty('general')) ADMINBRXC.vueState.themeStyleSettings.general = {};
            if(!ADMINBRXC.vueState.themeStyleSettings.general.hasOwnProperty('_cssVariables')) ADMINBRXC.vueState.themeStyleSettings.general._cssVariables = [];
        },
        getComponentClasses: function(tempClasses = [], id){
            const obj = ADMINBRXC.vueGlobalProp.$_getElementObject(id);
            if(obj.settings.hasOwnProperty('_cssGlobalClasses') && Array.isArray(obj.settings._cssGlobalClasses) && obj.settings._cssGlobalClasses.length > 0){
                obj.settings._cssGlobalClasses.forEach(el => {
                    if(!tempClasses.includes(el)) tempClasses.push(el);
                })
            }
            if(obj.hasOwnProperty('children') && Array.isArray(obj.children) && obj.children.length > 0){
                obj.children.forEach(el =>{
                    ADMINBRXC.helpers.getComponentClasses(tempClasses, el);
                })
            }

            return JSON.parse(JSON.stringify(tempClasses));
        },
        getComponentElements: function(content = [], id){
            const obj = ADMINBRXC.vueGlobalProp.$_getElementObject(id);
            content.push(obj);
            if(obj.hasOwnProperty('children') && Array.isArray(obj.children) && obj.children.length > 0){
                obj.children.forEach(el =>{
                    ADMINBRXC.helpers.getComponentElements(content, el);
                })
            }

            return content;
        },
        hasGlobalClass: function(id){
            const el = ADMINBRXC.vueGlobalProp.$_getElementObject(id);
            if(el && el.settings.hasOwnProperty('_cssGlobalClasses') && Array.isArray(el.settings._cssGlobalClasses) && el.settings._cssGlobalClasses.length > 0) return true;
            return false;
        },
        removeTrailingNewlines: function(String) {
            const pattern = /\n+$/;
            return String.replace(pattern, '');
        },
        keyMatchBreakpoint: function(key, bpKey){
            if(bpKey === "desktop"){
                let found = false;
                ADMINBRXC.vueState.breakpoints.forEach(el => {
                    if(el.key !== "desktop" && key.indexOf(`:${el.key}`) > -1) found = true;
                })

                if(found){
                    return false;
                } else {
                    return true;
                }
            } else {
                if(key.indexOf(`:${bpKey}`) > -1) return true;
            }
            
            return false;
        },

        keyMatchPseudo: function(key, pseudo){
            if(pseudo === ""){
                let found = false;
                ADMINBRXC.vueState.pseudoClasses.forEach(el => {
                    if(el !== "" && key.indexOf(`${el}`) > -1) found = true;
                })

                if(found){
                    return false;
                } else {
                    return true;
                }
            } else {
                if(key.indexOf(`${pseudo}`) > -1) return true;
            }
            
            return false;
        },
        getClassKeysFromGlobalSettings: function(classesIds) {
            let classesKeys = [];
            
            classesIds.forEach((id) => {
                const globalClass = ADMINBRXC.vueGlobalProp.$_getGlobalClass(id);
    
                if (typeof globalClass !== "undefined" && globalClass.hasOwnProperty("settings")) {
                    const settings = globalClass.settings;
    
                    for (const key in settings) {
                        if (key.startsWith("_") && settings[key] !== "") classesKeys.push(key);
                    }
                }
            });
            
            return [...new Set(classesKeys)];
        },
        easeInQuad: function(x){
            return x * x;
        },
        rgbStringToArray: function(rgbString){
            const rgbValues = rgbString.match(/\d+/g);
            return rgbValues.map(Number);
        },
        getElementTag: function(obj){
            let tag;
            if(!bricksData.elements[obj.name]) return false;
            if(typeof obj !== "undefined" && obj.name === "button" && obj.settings.hasOwnProperty('link') && typeof obj.settings.link === "object"){
                tag = "a";
            } else if (typeof obj !== "undefined" && obj.name === "image" && obj.hasOwnProperty('settings') && !obj.settings.hasOwnProperty('tag') ) {
                tag = "img";
            } else if (typeof obj !== "undefined" && obj.name === "code" && obj.hasOwnProperty('settings') && obj.settings.hasOwnProperty('noRoot') && obj.settings.noRoot === true) {
                tag = "none"
            } else if (typeof obj !== "undefined" && obj.hasOwnProperty('settings') && obj.settings.hasOwnProperty('tag') && obj.settings.tag === "custom" && obj.settings.hasOwnProperty('customTag')) {
                tag = obj.settings.customTag
            } else if (typeof obj !== "undefined" && obj.hasOwnProperty('settings') && obj.settings.hasOwnProperty('tag')) {
                tag = obj.settings.tag
            } else {
                if(!bricksData.elements[obj.name].hasOwnProperty('tag')) return;
                tag = bricksData.elements[obj.name].tag
            }
            return tag;
        },
        getClassCategoryNameById: function(id){
            const obj = Array.from(ADMINBRXC.vueState.globalClassesCategories).find(el => el && el.id === id);
            if(!obj) return false;
            return obj.name;
        },
        getClassCategoryObjById: function(id){
            const obj = Array.from(ADMINBRXC.vueState.globalClassesCategories).find(el => el && el.id === id);
            if(!obj) return false;
            return obj;
        },
        getClassCategoryIdByName: function(name){
            const obj = Array.from(ADMINBRXC.vueState.globalClassesCategories).find(el => el && el.name === name);
            if(!obj) return false;
            return obj.id;
        },
        getClassCategoryObjByName: function(name){
            const obj = Array.from(ADMINBRXC.vueState.globalClassesCategories).find(el => el && el.name === name);
            if(!obj) return false;
            return obj;
        },
        getQueryCategoryNameById: function(id){
            const obj = Array.from(ADMINBRXC.globalSettings.generalCats.queryManagerCats).find(el => el && el.id === id);
            if(!obj) return false;
            return obj.name;
        },
        getQueryCategoryObjById: function(id){
            const obj = Array.from(ADMINBRXC.globalSettings.generalCats.queryManagerCats).find(el => el && el.id === id);
            if(!obj) return false;
            return obj;
        },
        getQueryCategoryIdByName: function(name){
            const obj = Array.from(ADMINBRXC.globalSettings.generalCats.queryManagerCats).find(el => el && el.name === name);
            if(!obj) return false;
            return obj.id;
        },
        getQueryCategoryObjByName: function(name){
            const obj = Array.from(ADMINBRXC.globalSettings.generalCats.queryManagerCats).find(el => el && el.name === name);
            if(!obj) return false;
            return obj;
        },
        convertToPhpArrowFunction: function(jsonString) {
            const jsonObject = JSON.parse(jsonString);
            const indentedPhpString = JSON.stringify(jsonObject, null, 4)
                //.replace(/\{/g, '[')  // Replace { with [
                .replace(/(?<!")\{/g, '[')
                .replace(/\}(?!\")/g, ']')
                //.replace(/\}/g, ']')  // Replace } with ]
                .replace(/"([^"]+)":/g, '"$1" =>');

            return `return ${indentedPhpString};`;
        }
    },
    debounceTimer: null,
    populateCSSVariables: function () {
        const self = this;
        const x = document.querySelector('#bricks-builder-iframe').contentWindow;
        let temp = Array.from(x.document.styleSheets)
            .filter(
                sheet =>
                    sheet && sheet.href === null || sheet.href.startsWith(window.location.origin)
            )
            .reduce(
                (acc, sheet) =>
                    (acc = [
                        ...acc,
                        ...Array.from(sheet.cssRules).reduce(
                            (def, rule) =>
                                (def =
                                    rule.selectorText && rule.selectorText.includes(":root")
                                        ? [
                                            ...def,
                                            ...Array.from(rule.style).filter(name =>
                                                name && name.startsWith("--") && !name.startsWith("--builder")
                                            )
                                        ]
                                        : def),
                            []
                        )
                    ]),
                []
            );

    
        // Include inline CSS variables defined on the :root element
        const rootElement = x.document.querySelector(":root");
        if (rootElement) {
            Array.from(rootElement.style).forEach(variable => {
                if (variable.startsWith("--") && !variable.startsWith("--builder")) {
                    temp.push(variable);
                }
            });
        }
        temp = [...new Set(temp)];
        self.cssVariables = Array.from(temp.sort()).map(el => `var(${el})`);
    },
    
    states:{
        // Class Manager
        classManagerType: 'global',
        classManagerFilterLocked: false,
        classManagerFilterActive: false,
        classManagerFilterStyle: false,
        classManagerSearch: '',
        classManagerActiveClass: '',
        classManagerMaxClasses: 50,
        // Bulk Actions
        classManagerActiveCategory: 'All',
        classManagerisAIopen: false,
        classManagerBulkActionType: 'Rename',
        classManagerBulkActionTargetContain: '',
        classManagerBulkActionTargetExclude: '',
        classManagerBulkActionTargetGroup: 'All',
        classManagerBulkActionLock: 'All',
        classManagerBulkActionHasStyles: 'All',
        classManagerBulkActionIsActive: 'All',
        classManagerBulkActionOld: '',
        classManagerBulkActionNew: '',
        classManagerBulkActionPrefix: '',
        classManagerBulkActionSuffix: '',
        classManagerBulkActionNewGroup: '',
        classManagerBulkAssignElements: true,
        classManagerBulkRemoveOldClass: false,
        classManagerBulkDeleteOldClass: false,
        // Class Converter
        classConverterBasename: '',
        classConverterDelimiter: '__',
        classConverterCategory: false,
        classConverterCopyStyles: true,
        classConverterEraseStyles: false, 
    },
    globalClasses: () => {
        let globalClasses = [];
        if(typeof bricksData["loadData"] !== "undefined" && bricksData["loadData"].hasOwnProperty("globalClasses")){
            bricksData["loadData"]["globalClasses"].forEach(el =>{
                globalClasses.push(el['name']);
            })
        }
        return globalClasses;
    },
    loremSentences: [
        'Lorem ipsum dolor sit amet, consectetur adipiscing elit.',
        'Integer nec odio. Praesent libero uctus non, massa.',
        'Sed cursus ante dapibus diam. Sed nisi.',
        'Nulla quis sem at nibh elementum imperdiet.',
        'Duis sagittis ipsum. Praesent mauris himenaeos.',
        'Fusce nec tellus sed augue semper porta.',
        'Vestibulum lacinia arcu eget nulla per conubia.',
        'Class aptent taciti sociosqu ad litora torquent.',
        'Curabitur sodales ligula in libero euismod in, nibh.',
        'Sed dignissim lacinia nunc nostra, per inceptos.',
        'Curabitur tortor pellentesque nibh aenean quam.',
        'In scelerisque sem at dolor maecenas mattis.',
        'Sed convallis tristique sem mauris massa.',
        'Proin ut ligula vel nunc egestas porttitor.',
        'Morbi lectus risus, iaculis vel, suscipit quis.',
        'Fusce ac turpis quis ligula lacinia aliquet.',
        'Mauris ipsum mam nec ante Nulla facilisi adipiscing diam.',
        'Nulla metus metus, ullamcorper vel, tincidunt sed.',
        'Quisque volutpat condimentum velit ante quis turpis.',
        'Class aptent taciti sociosqu ad litora torquent per conubia.',
        'Sed lacinia, urna non tincidunt mattis, tortor neque.',
        'Ut fringilla. Suspendisse potenti a cursus ipsum.',
        'Nunc feugiat mi a tellus consequat imperdiet.',
        'Vestibulum sapien. Proin quam. Etiam ultrices.',
        'Suspendisse in justo eu magna luctus suscipit.',
    ],
    CSScontrolKeys: [],
    excludedControlKeyFromCSS: [
        '_cssGlobalClasses',
        '_conditions',
        '_interactions',
        '_cssClasses',
        '_cssId',
        '_attributes'
    ],
    fields: {
        CSSVariabe : {
            includedFields: [
                'div[data-control="number"]',
                {
                    selector: 'div[data-control="text"]',
                    hasChild: [
                        '#_backdropFilter',
                        '#_pointerEvents',
                        '#_aspectRatio',
                        '#_perspectiveOrigin',
                        '#_cssTransition',
                        '#_transformOrigin',
                        '#_flexBasis',
                        '#_overflow',
                        '#_gridTemplateColumns',
                        '#_gridTemplateRows',
                        '#_gridAutoColumns',
                        '#_gridAutoRows',
                        '#_objectPosition',
                        '[id^="raw-"]'
                    ]
                }
            ],
            excludedFields: [
                // Query loop
                '.control-query',
                // Slider
                'div[data-controlkey="start"]',
                'div[data-controlkey="perPage"]',
                'div[data-controlkey="perMove"]',
                'div[data-controlkey="speed"]',
            ],
        },
        loremIpsum : {
            includedFields: [
                'div[data-control="textarea"]',
                {
                    selector:
                        '[data-controlkey="text"] div[data-control="text"][type="text"],[data-controlkey="title"] div[data-control="text"][type="text"], [data-controlkey="fields"] div[data-control="text"][type="text"], [data-controlkey="prefix"] div[data-control="text"][type="text"], [data-controlkey="suffix"] div[data-control="text"][type="text"], [data-controlkey="logoText"] div[data-control="text"][type="text"], [data-controlkey="actionText"] div[data-control="text"][type="text"], [data-controlkey="titleCustom"] div[data-control="text"][type="text"], [data-control-key="text"] div[data-control="text"][type="text"], [data-control-key="title"] div[data-control="text"][type="text"], [data-control-key="subtitle"] div[data-control="text"][type="text"], [data-control-key="name"] div[data-control="text"][type="text"], [data-control-key="buttonText"] div[data-control="text"][type="text"]',
                    hasChild: '.dynamic-tag-picker-button',
                }
            ],
            excludedFields: [
                '.control-query',
                'div[data-control="conditions"]',
                'div[data-control="interactions"]',
                '#transition',
                'div[data-controlkey="speed"]',
                '[data-controlkey="shortcode"]',
                'div[data-control-key="format"]',
                '[data-controlkey="_cssSuperPowerCSS"]',
            ],
        },
        openAI : {
            includedFields: [
                'div[data-control="textarea"]',
                {
                    selector:
                        '[data-controlkey="text"] div[data-control="text"][type="text"], [data-controlkey="title"] div[data-control="text"][type="text"], [data-controlkey="fields"] div[data-control="text"][type="text"], [data-controlkey="prefix"] div[data-control="text"][type="text"], [data-controlkey="suffix"] div[data-control="text"][type="text"], [data-controlkey="logoText"] div[data-control="text"][type="text"], [data-controlkey="actionText"] div[data-control="text"][type="text"], [data-controlkey="titleCustom"] div[data-control="text"][type="text"], [data-control-key="text"] div[data-control="text"][type="text"], [data-control-key="title"] div[data-control="text"][type="text"], [data-control-key="subtitle"] div[data-control="text"][type="text"], [data-control-key="name"] div[data-control="text"][type="text"], [data-control-key="buttonText"] div[data-control="text"][type="text"]',
                    hasChild: '.dynamic-tag-picker-button',
                }
            ],
            excludedFields: [
                '.control-query',
                'div[data-control="conditions"]',
                'div[data-control="interactions"]',
                '#transition',
                'div[data-controlkey="speed"]',
                '[data-controlkey="shortcode"]',
                'div[data-control-key="format"]',
                '[data-controlkey="_cssSuperPowerCSS"]',
            ],
        },
        colorsOnHover : {
            includedFields: [
                'ul.color-palette.grid > li.color',
            ],
            excludedFields: [
            ],
        },
        classesOnHover : {
            includedFields: [
                'div.bricks-control-popup > div.css-classes > ul:nth-of-type(2) > li > div.actions',
            ],
            excludedFields: [
            ],
        }
    },
    aihistory:[
    ],
    qry: (el) => {
        return document.querySelector(el);
    },
    qryAll: (els) => {
        return document.querySelectorAll(els);
    },
    initAcc: (elem, option) => {
        document.addEventListener('click', (e) => {
            if (!e.target.matches(elem + ' .brxc-accordion-btn')) return;
            else {
                if (!e.target.parentElement.classList.contains('active')) {
                    if (option == true) {
                        var elementList = document.querySelectorAll(elem + ' .brxc-accordion-container');
                        Array.prototype.forEach.call(elementList, (e) => {
                        e.classList.remove('active');
                        });
                    }
                    e.target.parentElement.classList.add('active');
                } else {
                    e.target.parentElement.classList.remove('active');
                }
            }
        });
    },
    minimizeModal: function(overlay){
        const inner = document.querySelector(`${overlay} .brxc-overlay__inner`);
        (inner.classList.contains('brxc-large')) ? inner.classList.remove('brxc-large') : '';
        inner.classList.add('brxc-medium');
    },
    maximizeModal: function(icon, overlay){
        const modal = document.querySelector(overlay);
        const inner = document.querySelector(`${overlay} .brxc-overlay__inner`);
        const icons = modal.querySelectorAll('.brxc-overlay__resize-icons i')
        const btn  = modal.querySelector('.brxc-overlay__close-btn')
        modal.classList.remove(...['sidebar', 'left', 'right']);
        inner.style.width = '';
        btn.style.left = '';
        btn.style.right = '';
        if(icon.classList.contains('active')) {
            icons.forEach(el => el.classList.remove('active'));
            inner.classList.remove('brxc-large');
            inner.classList.add('brxc-medium')
        } else {
            icons.forEach(el => el.classList.remove('active'));
            icon.classList.add('active');
            inner.classList.add('brxc-large');
            inner.classList.remove('brxc-medium')
        }
    },
    rightSidebarModal: function(icon, overlay){
        const self = this;
        const modal = document.querySelector(overlay);
        const inner = modal.querySelector(`.brxc-overlay__inner`);
        const btn  = modal.querySelector('.brxc-overlay__close-btn')
        const icons = modal.querySelectorAll('.brxc-overlay__resize-icons i')
        modal.classList.remove(...['sidebar', 'left', 'right']);
        inner.style.width = '';
        btn.style.left = '';
        btn.style.right = '';
        if(icon.classList.contains('active')) {
            icons.forEach(el => el.classList.remove('active'));
            const max = modal.querySelector('.brxc-overlay__resize-icons .fa-window-maximize');
            (inner.classList.contains('brxc-large')) ? max.classList.add('active') : '';
            return;
        };
        icons.forEach(el => el.classList.remove('active'));

        self.calculatePanelWidth('right', inner, btn);
        modal.classList.add(...['sidebar', 'right']);
        icon.classList.add('active');

    },
    calculatePanelWidth: function(position, inner, btn){
        if(position === 'left'){
            const panel = document.querySelector('#bricks-panel');
            const width = window.getComputedStyle( panel ,null).getPropertyValue('width');
            inner.style.width = width;
            btn.style.left = `calc(${width} + 8px)`;
        } else if(position === 'right') {
            const panel = document.querySelector('#bricks-structure');
            const width = window.getComputedStyle( panel ,null).getPropertyValue('width');
            inner.style.width = width;
            btn.style.right = `calc(${width} + 16px)`;
        }
    },
    leftSidebarModal: function(icon, overlay){
        const self = this;
        const modal = document.querySelector(overlay);
        const inner = modal.querySelector(`.brxc-overlay__inner`);
        const btn  = modal.querySelector('.brxc-overlay__close-btn')
        const icons = modal.querySelectorAll('.brxc-overlay__resize-icons i')
        modal.classList.remove(...['sidebar', 'left', 'right']);
        inner.style.width = '';
        btn.style.left = '';
        btn.style.right = '';
        if(icon.classList.contains('active')) {
            icons.forEach(el => el.classList.remove('active'));
            const max = modal.querySelector('.brxc-overlay__resize-icons .fa-window-maximize');
            (inner.classList.contains('brxc-large')) ? max.classList.add('active') : '';
            return;
        }
        icons.forEach(el => el.classList.remove('active'));
        self.calculatePanelWidth('left', inner, btn);
        modal.classList.add(...['sidebar', 'left']);
        icon.classList.add('active');

    },
    autocomplete: function(inp, arr, type, ignorePreview = false) {
        const self = this;
        var currentFocus = 0;
        if (inp.dataset.autocomplete === "true") return;
        inp.setAttribute("data-autocomplete", "true");
        inp.addEventListener("keyup", function(e) {
            if (e.keyCode == 40 || e.keyCode == 38 || e.keyCode == 13) return;
            var a, b, i, j, ul, val = this.value;
            closeAllLists();
            if (!val) { return false;}
            currentFocus = -1;
            a = document.createElement("DIV");
            a.setAttribute("id", this.id + "autocomplete-list");
            a.setAttribute("class", "autocomplete-items bricks-control-popup bottom");
            this.parentNode.appendChild(a);
            ul = document.createElement("ul");
            a.appendChild(ul);
            for (i = 0, j = 0; i < arr.length; i++) {
              if (arr[i].toUpperCase().includes(val.toUpperCase())) {
                j++
                b = document.createElement("li");
                b.innerHTML += arr[i];
                b.innerHTML += "<input type='hidden' value='" + arr[i] + "'>";
                b.addEventListener("click", function(e) {
                    inp.value = this.getElementsByTagName("input")[0].value;
                    const event = new Event('input', {
                        bubbles: true,
                        cancelable: true,
                    });
                    inp.dispatchEvent(event);
                    closeAllLists();
                });
                if (Object.values(self.globalSettings.classFeatures).includes("autocomplete-variable-preview-hover") && ignorePreview === false){
                    let isMouseMoving = false;
                    b.addEventListener("mousemove", function(e) {
                        isMouseMoving = true;
                    });
                    b.addEventListener("mouseleave", function(e) {
                        setTimeout(() => {
                            inp.value = inp.dataset.autocompleteInitial;
                            const event = new Event('input', {
                                bubbles: false,
                                cancelable: true,
                            });
                            
                            inp.dispatchEvent(event);
                            inp.removeAttribute('data-autocomplete-initial');
                        },0)
                    });
                    b.addEventListener("mouseenter", function(e) {
                        setTimeout(() => {
                            inp.setAttribute('data-autocomplete-initial', inp.value);
                            if (isMouseMoving === false) return; 
                            inp.value = this.getElementsByTagName("input")[0].value;
                            const event = new Event('input', {
                                bubbles: false,
                                cancelable: true,
                            });
                            
                            inp.dispatchEvent(event);
                            isMouseMoving = false;
                        },0)
                        
                    });
                }
               
                ul.appendChild(b);
              }
            }
            if(j === 0){
                closeAllLists();
            }
        });

        inp.addEventListener("keydown", function(e){
            var x = document.getElementById(inp.id + "autocomplete-list");
            if (!x) return;
            x = x.getElementsByTagName("li");
            if (e.key == "ArrowDown") {
              currentFocus++;
              addActive(x);
              const active = Array.from(x).find(el => el && el.classList.contains('selected'));
              const value = active.querySelector('input[type="hidden"]').value;
              inp.value = value;
              const event = new Event('input', {
                bubbles: false,
                cancelable: true,
              });
            
              inp.dispatchEvent(event);

            } else if (e.key == "ArrowUp") { 
              currentFocus--;
              addActive(x);
              const active = Array.from(x).find(el => el && el.classList.contains('selected'));
              const value = active.querySelector('input[type="hidden"]').value;
              inp.value = value;
              const event = new Event('input', {
                bubbles: false,
                cancelable: true,
              });
            
              inp.dispatchEvent(event);

            } else if (e.key == "Enter") {
              e.preventDefault();
              if (currentFocus > -1) {
                if (x) x[currentFocus].click();
              }
            } else if (e.key == "Tab" || e.key == "Escape") {
                closeAllLists();
            }
        })

        function addActive(x) {
          if (!x) return false;
          removeActive(x);
          if (currentFocus >= x.length) currentFocus = 0;
          if (currentFocus < 0) currentFocus = (x.length - 1);
          x[currentFocus].classList.add("selected");
        }
        function removeActive(x) {
          for (var i = 0; i < x.length; i++) {
            x[i].classList.remove("selected");
          }
        }
        function closeAllLists(elmnt,tab) {
          var x = document.getElementsByClassName("autocomplete-items");
          for (var i = 0; i < x.length; i++) {
            if (tab || (elmnt != x[i] && elmnt != inp)) {
            x[i].parentNode.removeChild(x[i]);
          }
        }
      }

      document.addEventListener("click", function (e) {
          closeAllLists(e.target, false);
      });
    },
    debounce: (fn, threshold) => {
        var timeout;
        threshold = threshold || 200;
        return function debounced() {
            clearTimeout(timeout);
            var args = arguments;
            var _this = this;
        
            function delayed() {
                fn.apply(_this, args);
            }
            timeout = setTimeout(delayed, threshold);
        };
    },
    randomize: (length) => {
        let result = '';
        const characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
        const charactersLength = characters.length;
        let counter = 0;
        while (counter < length) {
          result += characters.charAt(Math.floor(Math.random() * charactersLength));
          counter += 1;
        }
        return result;
    },
    openModal: function(target, id, focus = false, closeActiveModals = true){
        const self = this;

        // Close open modals
        if(closeActiveModals){
            const openModals = document.querySelectorAll('.brxc-overlay__wrapper.active');
            if(openModals && openModals.length > 0){
                openModals.forEach(el => el.classList.remove('active'));
            }
        }

        // Open Modal
        const wrapper = document.querySelector(id);
        wrapper.classList.add('active');

        document.addEventListener('keydown', function(e) {
            (e.key === "Escape") ? self.closeModal(target, target.target, id) : '';
        });
        if(focus) focus.focus()

        // Resize
        const inner = wrapper.querySelector(`.brxc-overlay__inner`);
        const btn = wrapper.querySelector('.brxc-overlay__close-btn')
        inner.style.width = '';
        btn.style.left = '';
        btn.style.right = '';
        if (wrapper.classList.contains('left')) {
            self.calculatePanelWidth('left', inner, btn)
        } else if(wrapper.classList.contains('right')) {
            self.calculatePanelWidth('right', inner, btn)
        } 

        // Refresh panels
        const activePanel = wrapper.querySelector('.brxc-overlay__pannels-wrapper');
        if(activePanel){
            activePanel.style.display = "none";
            setTimeout(()=> {activePanel.style.display = "flex"}, 0);
        }
    },
    variablePopulateGroups: function(){
        const self = this;
        content = '';
        let arr = self.helpers.isCSSVariablesTabActive('theme-variables') && self.helpers.themeHasVariables() ? self.globalSettings.defaultVariables.concat(self.vueState.themeStyleSettings.general._cssVariables.sort((a, b) => a.order - b.order)) : self.globalSettings.defaultVariables;
        if(!arr || !Array.isArray(arr) || arr.length < 1) return

        arr = Array.from(arr).filter(el => el && el.type !== "custom");
        if(!arr || !Array.isArray(arr) || arr.length < 1) return;

        const groups = Array.from(new Set(arr.map(item => item && item.hasOwnProperty('group') && item.group)));
        if(!groups || !Array.isArray(groups) || groups.length < 1) return;

        groups.forEach(group => {
            const variables = Array.from(arr).filter(el => el && el.group === group);
            
            content += `<label class="brxc-input__label has-tooltip">${group}`;
            content += `<div class="show-in-manager" data-balloon="Show in CSS Variable Manager" data-balloon-pos="right" data-balloon-length="medium" onclick="ADMINBRXC.openVariableCategory('${group}')"><i class="fas fa-eye"></i></div>`;
            content += `</label>`;
            content += `<div class="brxc-overlay__action-btn-wrapper isotope-container">`;
            if (variables && variables.length > 0){
                variables.forEach((variable, index) => {
                    let balloon = false;
                    if(variable.hasOwnProperty('type') && variable.type === "static" && variable.hasOwnProperty('value')) balloon = variable.value;
                    if(variable.hasOwnProperty('type') && variable.type === "clamp" && variable.hasOwnProperty('min') && variable.hasOwnProperty('max')) balloon = `${variable.min} to ${variable.max} (px)`;
                    const name = `var(--${self.helpers.setPrefix(self.helpers.formatForClasses(variable.name), 'variables', false)})`;
                    const global = self.globalSettings.defaultVariables.find(el => el.id === variable.id) ? true : false;
                    
                    content += `<div class="brxc-overlay__action-btn isotope-selector ${global ? 'global' : 'theme'}" data-variable="${name}"${balloon ? ` data-balloon="${balloon}" data-balloon-pos="top"` : ''}>${variable.name}${!global ? '<span class="type-indicator"></span>' : ''}</div>`;
                    if(self.helpers.isCSSVariablesTabActive('theme-variables') && index === variables.length - 1){
                        content += `<div class="add-new-variable" data-group="${group}" data-balloon="Add a new theme variable" data-balloon-pos="top"><i class="fas fa-plus"></i></div>`;
                    }
                })
            }
            content += `</div>`
        })

        return content;
            
    },
    openVariableModal: function(target, id, focus = false){
        const self = this;
        const wrapper = document.querySelector(id);
        wrapper.classList.add('active');

        document.addEventListener('keydown', function(e) {
            (e.key === "Escape") ? self.closeModal(target, target.target, id) : '';
        });
        if(focus) focus.focus()

        // Resize
        const inner = wrapper.querySelector(`.brxc-overlay__inner`);
        const btn = wrapper.querySelector('.brxc-overlay__close-btn')
        inner.style.width = '';
        btn.style.left = '';
        btn.style.right = '';
        if (wrapper.classList.contains('left')) {
            self.calculatePanelWidth('left', inner, btn)
        } else if(wrapper.classList.contains('right')) {
            self.calculatePanelWidth('right', inner, btn)
        } 
        
        // Refresh panels
        const activePanel = wrapper.querySelector('.brxc-overlay__pannels-wrapper');
        activePanel.style.display = "none";
        setTimeout(()=> {activePanel.style.display = "flex"}, 0);


        // Populate the groups

        const canvas = document.querySelector('#brxcVariablePickrAT');
        if(canvas){
            content = self.variablePopulateGroups();
            canvas.innerHTML = content;
        }

        

        // Add Listeners

        const btns = wrapper.querySelectorAll('#brxcVariableOverlay .brxc-overlay__action-btn');

        if(btns.length < 1) return;

        const initialValue = target.value;

        btns.forEach(btn => {
            let wasClicked = false;
            if (target.value === btn.dataset.variable){
                btn.classList.add('active');
            }
            btn.onmouseleave = () => {
                // Only perform these actions if the button was not clicked.
                if (!wasClicked) {
                    target.value = initialValue;
                    const event = new Event('input', {
                        bubbles: true,
                        cancelable: true,
                    });
                    target.dispatchEvent(event);
                }
                // Reset the wasClicked flag
                wasClicked = false;
            };
        
            btn.onmouseenter = () => {
                const dataset = btn.dataset.variable;
                target.value = dataset;
                const event = new Event('input', {
                    bubbles: true,
                    cancelable: true,
                });
        
                target.dispatchEvent(event);
            };
        
            btn.onclick = () => {
                // Set the wasClicked flag to true
                wasClicked = true;
                
                const dataset = btn.dataset.variable;
                target.value = dataset;
                const event = new Event('input', {
                    bubbles: true,
                    cancelable: true,
                });
                
                target.dispatchEvent(event);
                self.closeModal(target, target.target, id);
            }
        });

        // Input new variable

        const newVariables = wrapper.querySelectorAll('.add-new-variable');
        newVariables.forEach(variable => {
            variable.addEventListener('click', (e) => {
                self.setaddVariableFromPicker(e, target, id);
            })
        })

        self.setIsotope('#brxcVariableOverlay .brxc-overlay__pannel-1');
    },
    openVariableCategory: function(group){
        const self = this;
        self.cssVariablesStates.activeCategory = group;
        self.setCSSVariableManager(true);
        self.openModal(false, "#brxcCSSVariableManagerOverlay");
    },
    plainClassesStates: {
        searchTerm: '',
        searchGroup: '',
    },
    openPlainClassesModal: function(target, classes, id, focus = false){
        const self = this;
        self.plainClassesStates.searchTerm = '';
        self.plainClassesStates.searchGroup = '';
        const wrapper = document.querySelector(id);
        const mostUsedCanvas = document.querySelector('#plainClassesMostUsedCanvas');
        const searchOptions = document.querySelector('#plainClassesSearchOptionsCanvas');
        const cm = document.querySelector('#brxcPlainClassesOverlay .CodeMirror').CodeMirror;
        let finalClasses = [];
        if(self.vueState.activeElement.settings.hasOwnProperty('_cssGlobalClasses')) {
            self.vueState.activeElement.settings._cssGlobalClasses.forEach(cls => {
                const obj = Array.from(self.vueState.globalClasses).find(el => el && el.id === cls);
                if(!obj) return;
                finalClasses.push(obj.name);
            })
        } 
        // const finalClasses = []
        // classes.forEach(el => {
        //     finalClasses.push(el.textContent.replace('.',''));
        // });
        const existingClasses = finalClasses.join(' ');
        cm.setValue(existingClasses);
        wrapper.classList.add('active');

        document.addEventListener('keydown', function(e) {
            (e.key === "Escape") ? self.closeModal(target, target.target, id) : '';
        });
        
        // Most used Classes;
        let content = '<div class="brxc-overlay__action-btn-wrapper">';
        const mostUsedClasses = self.mostUsedClasses();
        if(mostUsedClasses.length === 0){
            content += `<div class="no-result">No class used on this page yet.</div>`;
        } else {
            mostUsedClasses.slice(0, 20).forEach((cls, index) => {
                if(index === 19){
                    content += `<div class="load-more">+${mostUsedClasses.length - 20} more</div>`
                } else {
                    const obj = self.vueGlobalProp.$_getGlobalClass(cls);
                    if(!obj) return;
                    content += `<div class="brxc-overlay__action-btn${finalClasses.includes(obj.name) ? ' active' : ''}" data-value="${obj.name}">.${obj.name}</div>`;
                }
            })
        }
        
        content += "</div>";
        mostUsedCanvas.innerHTML = content;

        // Search options

        if(typeof self.vueState.globalClassesCategories !== "undefined"){
            let clsCategories = Array.from(self.vueState.globalClassesCategories).map(el => el && el.name);
            content = '';
            
            content += '<select class="brxc-plain-class-select"><option value="">All</option>';
            if(clsCategories.length > 0){
                clsCategories.forEach(cat => {
                    content += `<option value="${self.helpers.getClassCategoryIdByName(cat)}">${cat}</option>`;
                })
            }
            content += '</select>';
            
            searchOptions.innerHTML = content;
        }

        // reset values
        const searchCanvas = document.querySelector('#plainClassesSearchResultsCanvas');
        searchCanvas.innerHTML = '';

        
        // Event Listeners
        const btns = mostUsedCanvas.querySelectorAll('.brxc-overlay__action-btn');
        btns.forEach(btn => {
            btn.addEventListener('click', () => {
                const value = btn.dataset.value;
                const existing = cm.getValue();
                cm.setValue(`${existing} ${value}`);
            })
        })

        const searchTerm = document.querySelector('#plainClassesSearchWrapper input');
        searchTerm.value = '';
        searchTerm.addEventListener('keyup', () => {
            self.plainClassesStates.searchTerm = searchTerm.value;
            self.plainClassesSearchResult(cm);
        })
        const searchGroup = document.querySelector('#plainClassesSearchOptionsCanvas select');
        if(searchGroup){
            searchGroup.addEventListener('change', () => {
                self.plainClassesStates.searchGroup = searchGroup.value;
                self.plainClassesSearchResult(cm);
            })
        }

        setTimeout(() => {
            focus.focus();
            focus.setCursor(focus.lineCount(), 0);
        }, 50)

    },

    plainClassesSearchResult: function(cm){
        const self = this;
        let globalClasses = self.vueState.globalClasses;
        const existingClasses = cm.getValue().split(' ');
        const canvas = document.querySelector('#plainClassesSearchResultsCanvas');
        if(self.plainClassesStates.searchTerm !== ''){
            globalClasses = Array.from(globalClasses).filter(el => el && el.name.includes(self.plainClassesStates.searchTerm))
        }
        if(self.plainClassesStates.searchGroup !== ''){
            globalClasses = Array.from(globalClasses).filter(el => el && el.category && el.category === self.plainClassesStates.searchGroup)
        }

        let content = '<div class="brxc-overlay__action-btn-wrapper m-top-16">';
        globalClasses.slice(0, 20).forEach((obj, index) => {
            if(index === 19){
                content += `<div class="load-more">+${globalClasses.length - 20} more</div>`
            } else {
                content += `<div class="brxc-overlay__action-btn${existingClasses.includes(obj.name) ? ' active' : ''}" data-value="${obj.name}">.${obj.name}</div>`;
            }
        })
        content += "</div>";
        canvas.innerHTML = content;

        // Event Listeners
        const btns = canvas.querySelectorAll('.brxc-overlay__action-btn');
        btns.forEach(btn => {
            btn.addEventListener('click', () => {
                const value = btn.dataset.value;
                const existing = cm.getValue();
                cm.setValue(`${existing} ${value}`);
            })
        })

        
    },
    openAIModal: function(prefix, global = false, target, id){
        const self = this;

        if (global === false){
            // Completion
            const chatMore = document.querySelector('#brxcopenAIOverlay #' + prefix + 'ChatMore');
            const existingInsertBtn = document.querySelector('#brxcopenAIOverlay #' + prefix + 'InsertContent');
            const existingReplaceBtn = document.querySelector('#brxcopenAIOverlay #' + prefix + 'ReplaceContent');
            if(existingInsertBtn) existingInsertBtn.remove();
            if(existingReplaceBtn) existingReplaceBtn.remove();
            chatMore.insertAdjacentHTML(
                'afterend',
                '<div id="' + prefix + 'InsertContent" class="brxc-overlay__action-btn"><span>Insert Content</span></div><div id="' + prefix + 'ReplaceContent" class="brxc-overlay__action-btn primary"><span>Replace Content</span></div>'
            );

            const insertBtn = document.querySelector('#brxcopenAIOverlay #' + prefix + 'InsertContent');
            insertBtn.addEventListener('click', () =>{
                const value = document.querySelector('#brxcopenAIOverlay input[name="openai-results"]:checked + label .message.assistant').textContent;
                target.value += value.replaceAll(/\n/g,'<br>');
                const event = new Event('input', {
                    bubbles: true,
                    cancelable: true,
                });
                target.dispatchEvent(event);
                self.closeModal(target, target.target, id);
                self.vueGlobalProp.$_showMessage('AI Content Inserted');
            })
            const replaceBtn = document.querySelector('#brxcopenAIOverlay #' + prefix + 'ReplaceContent');
            replaceBtn.addEventListener('click', () =>{
                const value = document.querySelector('#brxcopenAIOverlay input[name="openai-results"]:checked + label .message.assistant').textContent;
                target.value = value.replaceAll(/\n/g,'<br>');
                const event = new Event('input', {
                    bubbles: true,
                    cancelable: true,
                });
                target.dispatchEvent(event);
                self.closeModal(target, target.target, id);
                self.vueGlobalProp.$_showMessage('AI Content Inserted');
            })

            // Edit
            const editTextArea = document.querySelector('#brxcopenAIOverlay #' + prefix + 'EditText');
            const editbtnwrapper = document.querySelector('#brxcopenAIOverlay #' + prefix + 'InsertEditContentWrapper')
            const existingInsertEditBtn = document.querySelector('#brxcopenAIOverlay #' + prefix + 'InsertEditContent');
            const existingReplaceEditBtn = document.querySelector('#brxcopenAIOverlay #' + prefix + 'ReplaceEditContent');
            if(existingInsertEditBtn) existingInsertEditBtn.remove();
            if(existingReplaceEditBtn) existingReplaceEditBtn.remove();
            editTextArea.value = target.value.replaceAll('<br>', '\n');
            editbtnwrapper.innerHTML += '<div id="' + prefix + 'InsertEditContent" class="brxc-overlay__action-btn"><span>Insert Content</span></div>';
            editbtnwrapper.innerHTML += '<div id="' + prefix + 'ReplaceEditContent" class="brxc-overlay__action-btn primary"><span>Replace Content</span></div>';
            const insertEditBtn = document.querySelector('#brxcopenAIOverlay #' + prefix + 'InsertEditContent');
            insertEditBtn.addEventListener('click', () =>{
                const value = document.querySelector('#brxcopenAIOverlay input[name="openai-edit-results"]:checked + label .message.assistant').textContent;
                target.value += value.replaceAll(/\n/g,'<br>');
                const event = new Event('input', {
                    bubbles: true,
                    cancelable: true,
                });
                target.dispatchEvent(event);
                self.closeModal(target, target.target, id);
                //self.showMessage('AI Content Inserted')
                self.vueGlobalProp.$_showMessage('AI Content Inserted');
            })
            const replaceEditBtn = document.querySelector('#brxcopenAIOverlay #' + prefix + 'ReplaceEditContent');
            replaceEditBtn.addEventListener('click', () =>{
                const value = document.querySelector('#brxcopenAIOverlay input[name="openai-edit-results"]:checked + label .message.assistant').textContent;
                target.value = value.replaceAll(/\n/g,'<br>');
                const event = new Event('input', {
                    bubbles: true,
                    cancelable: true,
                });
                target.dispatchEvent(event);
                self.closeModal(target, target.target, id);
                //self.showMessage('AI Content Inserted')
                self.vueGlobalProp.$_showMessage('AI Content Inserted');
            })
        }

        // Open modal
        const wrapper = document.querySelector(id);
        wrapper.classList.add('active');
        document.addEventListener('keydown', function(e) {
            (e.key === "Escape") ? self.closeModal(target, target.target, id) : '';
        });
    },
    openExtendClassModal: function(target,id){
        const self = this;
        const select = document.querySelector('#brxcExtendModal #brxc-extendcategoryOptions');
        select.value = self.vueState.activeElement.name;
        const wrapper = document.querySelector(id);
        wrapper.classList.add('active');
        document.addEventListener('keydown', function(e) {
            (e.key === "Escape") ? self.closeModal(target, target.target, id) : '';
        });
    },
    openFindReplaceModal: function(target,global, id){
        const self = this;
        const wrapper = document.querySelector(id);
        const posRadios = document.querySelectorAll('#brxcFindReplaceModal [name=brxc-findreplacePosition]');
        const select = document.querySelector('#brxcFindReplaceModal #brxc-findreplacecategoryOptions');
        const alert = document.querySelector('#brxcFindReplaceModal .alert');

        if (global){
            select.value = 'all';
            const pageRadio = document.querySelector('#brxcFindReplaceModal #brxc-findreplace-page');
            pageRadio.dispatchEvent(new MouseEvent('click'));
            posRadios.forEach(radio => {
                radio.setAttribute('disabled', true);
            })
            alert.classList.add('active');

        } else {
            select.value = self.vueState.activeElement.name;
            const SiblingRadio = document.querySelector('#brxcFindReplaceModal #brxc-findreplace-siblings');
            SiblingRadio.dispatchEvent(new MouseEvent('click'));
            posRadios.forEach(radio => {
                radio.removeAttribute('disabled');
            })
            alert.classList.remove('active');
        }
        wrapper.classList.add('active');
        document.addEventListener('keydown', function(e) {
            (e.key === "Escape") ? self.closeModal(target, target.target, id) : '';
        });
    },
    generateGlobalClass: function(prefix,name, cat, id = false){
        const self = this;
        const newId = id !== false ? id : self.vueGlobalProp.$_generateId();
        const obj = {
            id: prefix + newId,
            name: name,
            settings: {},
        }
        if(cat && typeof self.vueState.globalClassesCategories !== "undefined"){
            if(self.helpers.getClassCategoryIdByName(cat)){
                obj.category = self.helpers.getClassCategoryIdByName(cat);
            } else {
                const catId = self.vueGlobalProp.$_generateId();
                self.vueState.globalClassesCategories.push({
                    id: catId,
                    name: cat,
                })
                obj.category = catId;
            }
        }
        self.vueState.globalClasses.push(obj)
        self.populateClassCategories();

        return id;
    },
    importedClasses: function(){
        const self = this;
        let settingsHaveChanged = false;
        let existingClassesId = [];
        const globalClasses = self.vueState.globalClasses;
        const importedClasses = self.globalSettings.importedClasses;
        if (importedClasses.length > 0){
            importedClasses.forEach(e => {
                globalClasses.forEach((item) => { 
                    if (item.name === e) { 
                        existingClassesId.push({id: item.id,name: item.name});
                    }
                }); 
            })

            const importedClassesToCreate = importedClasses.filter(str => str && !existingClassesId.some(obj => obj && obj.hasOwnProperty('name') && obj.name === str));
            if (importedClassesToCreate.length > 0){
                importedClassesToCreate.forEach( e => {
                    self.generateGlobalClass('brxc_imported_',e,false);
                    settingsHaveChanged = true;

                })
            }
        }

        //Remove classes

        for (let i = 0; i < globalClasses.length; i++) { 
            const obj = globalClasses[i]; 
            const isImported = obj.id.includes('brxc_imported');  
            const isIncluded = importedClasses.includes(obj.name);
            if (isImported && isIncluded) {
                continue;
            } 
            if (isImported && !isIncluded) { 
                self.vueState.globalClasses.splice(i, 1);
                settingsHaveChanged = true;
                i--; 
            }
        }

        // Update DB
        if (settingsHaveChanged === true) {
            self.helpers.saveChanges('globalClasses');
            self.helpers.saveChanges('globalClassesLocked');
        }
    },
    importedGrids: function(){
        const self = this;
        let settingsHaveChanged = false;
        let existingClassesId = [];
        const globalClasses = self.vueState.globalClasses;
        const grids = self.globalSettings.gridClasses;
        if (grids.length > 0){
            grids.forEach(e => {
                globalClasses.forEach((item) => { 
                    if (item.name === e) { 
                        existingClassesId.push({id: item.id,name: item.name});
                    }
                }); 
            })

            const gridsToCreate = grids.filter(str => str && !existingClassesId.some(obj => obj && obj.hasOwnProperty('name') && obj.name === str));
            if (gridsToCreate.length > 0){
                gridsToCreate.forEach( e => {
                    self.generateGlobalClass('brxc_grid_', e, false);
                    settingsHaveChanged = true;
                })
            }
        }
        
        //Remove classes

        for (let i = 0; i < globalClasses.length; i++) { 
            const obj = globalClasses[i]; 
            const isGrid = obj.id.includes('brxc_grid_');  
            const isIncluded = grids.includes(obj.name); 
            if (isGrid && isIncluded) {
                continue;
            } 
            if (isGrid && !isIncluded) { 
                self.vueState.globalClasses.splice(i, 1);
                settingsHaveChanged = true;
                i--; 
            }
        }

        // Update DB
        if (settingsHaveChanged === true) {
            self.helpers.saveChanges('globalClasses');
            self.helpers.saveChanges('globalClassesLocked');
        }

        
    },
    savePlainClasses: function(target,classes) {
        const self = this;
        let finalClasses = []
        let newClasses = [];
        const globalClasses = self.vueState.globalClasses;
        if (classes) {
           newClasses = classes.split(/\s+/).filter(word => word.trim() !== '').filter((value, index, array) => array.indexOf(value) === index);
        }
  
        if (newClasses.length > 0){
            newClasses.forEach(e => {
                const existingClass = Array.from(globalClasses).find(el => el && el.hasOwnProperty('id') && el.hasOwnProperty('name') && el.name === e);
                if(existingClass) {
                    finalClasses.push(existingClass.id);
                    return;
                }

                const id = self.vueGlobalProp.$_generateId();
                self.generateGlobalClass('', e, false, id);
                finalClasses.push(id)
            })
        }
        self.vueState.activeElement.settings._cssGlobalClasses = [...new Set(finalClasses)];

        setTimeout(self.closeModal(target, target.target, '#brxcPlainClassesOverlay'), 300);
        self.vueGlobalProp.$_showMessage('Classes updated!');
    },
    resetClasses: function(target){
        const self = this;
        self.savePlainClasses(target, '');
        if (typeof self.vueState.activeElement.settings !== "undefined" && self.vueState.activeElement.settings.hasOwnProperty('_cssGlobalClasses')) delete self.vueState.activeElement.settings._cssGlobalClasses;
        self.closeModal(target, target.target, '#brxcPlainClassesOverlay');
        self.vueGlobalProp.$_showMessage('Classes reset successfully!');
    },
    mostUsedClasses: function(){
        const self = this;

        const counts = {};
        const contentType = self.helpers.getTemplateType();
        const contentArray = Array.from(self.vueState[contentType])
        const inputArray = [].concat(...contentArray.filter(el => el.settings.hasOwnProperty('_cssGlobalClasses')).map(el => [...el.settings._cssGlobalClasses]));
        
        inputArray.forEach((element) => {
            counts[element] = (counts[element] || 0) + 1;
        });

        const sortedArray = inputArray.sort((a, b) => counts[b] - counts[a]);

        return [...new Set(sortedArray)];
    },
    closeModal: (event, target, id, closeAllBtns = false) => {
        if( event.target !== target ) {
            return;
        }
        const wrapper = document.querySelector(id);
        wrapper.classList.remove('active');
        if(closeAllBtns === true) return;
        if( id === "#brxcVariableOverlay"){
            const btns = wrapper.querySelectorAll('.brxc-overlay__action-btn.active');
            btns.forEach(btn => { btn.classList.remove('active');})
        }
        

    },
    addLorem: function(target, btn) {
        const self = this;
        let used = parseInt(btn.dataset.used);
        let tempArr;
        let arr;
        (self.globalSettings['loremIpsumtype'] === 'human') ? tempArr = ADMINBRXC.globalSettings.customDummyContent.split('\n') : tempArr = ADMINBRXC.loremSentences;
        (used === tempArr.length) ? arr = tempArr : arr = tempArr.slice(used);
        
        target.value = `${target.value} ${arr[0]}`;
        
        (used === tempArr.length) ? btn.setAttribute('data-used', 1) : btn.setAttribute('data-used', used + 1);
        const event = new Event('input', {
            bubbles: true,
            cancelable: true,
        });
          
        target.dispatchEvent(event);
    },
    completionAPIRequest: function(prefix, global, overlay, target, history, n, json, type){
        const self = this;
        jQuery.ajax({
            type: 'POST',
            url: openai_ajax_req.ajax_url,
            data: {
                action: 'openai_ajax_function',
                nonce: openai_ajax_req.nonce
            },
            success: function(response) {
                const post = async () => {
                    const rawResponse = await fetch('https://api.openai.com/v1/chat/completions', {
                      method: 'POST',
                      headers: {
                          'Content-Type': 'application/json',
                          'Authorization' : 'Bearer '+ response,
                        },
                      body: JSON.stringify(json)
                    });
                    const content = await rawResponse.json();
                    console.log(content);
                    if(content.error){
                        self.insertErrorMessage(prefix, global, overlay, content.error.message);
                        target.classList.remove('disable');
                    } else {
                        for(i=0; i<n;i++){
                            if(type === "chat"){
                                self.insertAIResponse(prefix, global, overlay, content.choices[i].message.content.trim(), i);
                            } else if(type === "edit"){
                                self.insertAIEditResponse(prefix, global, overlay, content.choices[i].message.content.trim(), i);
                            } else if(type === "code"){
                                self.insertAICodeResponse(prefix, global, overlay, content.choices[i].message.content.trim(), i);
                            }
                        }
                        target.classList.remove('disable');
                        history['assistant'] = content;
                        self.aihistory.push(history);
                    }
                };
                post();
            },
            error: function(response){
                console.log('Something went wrong with the OpenAI AJAX request: ' + response);
                target.classList.remove('disable');
            }
        });

    },
    whisperAPIRequest: function(prefix, global, overlay, target, history, language, temp, audioBlob, ext, callback){
        const self = this;

        const formData = new FormData();
        formData.append('file', audioBlob, `audio.${ext}`);
        formData.append('model', 'whisper-1');
        formData.append('language', language);
        formData.append('temp', temp);

        jQuery.ajax({
            type: 'POST',
            url: openai_ajax_req.ajax_url,
            data: {
                action: 'openai_ajax_function',
                nonce: openai_ajax_req.nonce
            },
            success: function(response) {
                const post = async () => {
                    const rawResponse = await fetch('https://api.openai.com/v1/audio/transcriptions', {
                    method: 'POST',
                    headers: {
                        'Authorization' : 'Bearer '+ response,
                        },
                    body: formData
                    });
                    const content = await rawResponse.json();
                    console.log(content);
                    if(content.error){
                        self.insertErrorMessage(prefix, global, overlay, content.error.message);
                        target.classList.remove('disable');
                    } else {
                        callback(content.text);
                        target.classList.remove('disable');
                        history['assistant']['text'] = content.text;
                        self.aihistory.push(history);
                    }
                };
                post();
            },
            error: function(response){
                console.log('Something went wrong with the OpenAI AJAX request: ' + response);
                target.classList.remove('disable');
            }
        });

    },
    generateAudioTranscription: function(prefix, target, global, overlay, language, temp){
        const self = this;
        const fileInput = document.querySelector('#brxcTTSInput');
        let history = [];

        target.classList.add('disable');
        function handleFileInput() {
            if (fileInput.files.length > 0) {
                const audioFile = fileInput.files[0];
                const filename = audioFile.name
                let last_dot = filename.lastIndexOf('.')
                let ext = filename.slice(last_dot + 1)
        
                // Read the contents of the selected file as a Blob
                const reader = new FileReader();
        
                reader.onload = function (loadEvent) {
                    const audioBlob = new Blob([loadEvent.target.result], { type: audioFile.type });

                    // API Request
                    history['user'] = {
                        date: Date.now(),
                        type: 'audio',
                        language: language,
                        temperature: temp,
                        message: 'Requested Audio Transcription.',
                    }  
                    history['assistant'] = {
                        text: '',
                    } 
                    self.whisperAPIRequest(prefix, global, overlay, target, history, language, temp, audioBlob, ext,  function (transcription) {
                        // Handle the transcription result, e.g., display it on the UI
                        const canvas = document.querySelector('#brxcTTSCanvas');
                        let content =  `<div class="brxc-ai-response-wrapper remove-on-reset">
                                            <input type="radio" id="brxc3SIfHu" name="global-openai-results">
                                            <label for="brxc3SIfHu" class="brxc-input__label">
                                                <p>OpenAI Assistant</p>
                                                <pre name="global-openai-prompt-response" class="message assistant" id="global-openaiPromptResponse">
                                                    <code>${transcription}</code>
                                                </pre>
                                            </label>
                                        </div>`;
                        canvas.innerHTML = content;
                    });
                };
        
                reader.readAsArrayBuffer(audioFile);
            }
        }
        handleFileInput()
    },
    getAIResponse: function(prefix, target, global = false, overlay, voiceTones, customToneVal, temp = 0, maxTokens = 15, n = 1, topP = 1, pres = 0, freq = 0, model){
        const self = this;
        target.classList.add('disable');
        let message = [];
        let history = [];
        let tones = [];
        let tone = '';
        if (voiceTones.length > 0){
            if(customToneVal && Array.from(voiceTones).filter(el => el && el.dataset.tone == 'custom').length > 0 && voiceTones.length === 1){
                tone = customToneVal;
            } else {
                let customTone = '';
                if(customToneVal && Array.from(voiceTones).filter(el => el && el.dataset.tone == 'custom').length > 0){
                    customTone = ' ' + customToneVal;
                };
                Array.from(voiceTones).filter(el => {
                    if (el.dataset.tone != 'custom'){
                        tones.push(el.dataset.tone);
                    }
                });
                tone = 'Adjust the tone of the text to be ' + tones.join(" and ") + '.' + customTone;
            }
            message.push({"role": "system", "content": tone});
        }
        const fmessages = document.querySelectorAll(overlay + ' .brxc-overlay__pannel.completion .message');
        fmessages.forEach(fmessage => {
            if(fmessage.classList.contains('user')){
                message.push({"role": "user", "content": fmessage.value});
            } else {
                message.push({"role": "assistant", "content": fmessage.textContent});
            }
        })
        history['user'] = {
                date: Date.now(),
                type: 'completion',
                system: tone,
                message: message[message.length - 1].content,
                maxTokens: maxTokens,
                choices: n,
                temperature: temp,
                top_p: topP,
                presence_penalty: pres,
                frequency_penalty: freq,
        }

        let json = {
            "model": model, 
            "messages": message,
            "max_tokens": maxTokens,
        };

        if (n != 1) json.n = n;
        if (temp != 1) json.temperature = Number.parseFloat(temp);
        if (topP != 1) json.top_p = Number.parseFloat(topP);
        if (pres != 0) json.presence_penalty = Number.parseFloat(pres);
        if (freq != 0) json.frequency_penalty = Number.parseFloat(freq);

        self.completionAPIRequest(prefix, global, overlay, target, history, n, json, 'chat');
    },
    getEditAIResponse: function(prefix, target, global = false, overlay, voiceTones, customToneVal, temp = 0, maxTokens, n = 1, topP = 1, pres = 0, freq = 0, model){
        const self = this;
        target.classList.add('disable');
        const instruction = document.querySelector(overlay + ' .brxc-overlay__pannel.edit .instruction').value;
        let message = [];
        let history = [];
        let tones = [];
        let tone = 'You are an helpful assistant.';
        if (voiceTones.length > 0){
            Array.from(voiceTones).filter(el => {
                if (el.dataset.tone != 'custom'){
                    tones.push(el.dataset.tone);
                }
            });
            tone += 'Adjust the tone of the text to be ' + tones.join(" and ") + '.';
        }
        message.push({"role": "system", "content": tone});

        const fmessages = document.querySelectorAll(overlay + ' .brxc-overlay__pannel.edit .message');
        fmessages.forEach(fmessage => {
            if(fmessage.classList.contains('user')){
                message.push({"role": "user", "content": `Here is the content: "${fmessage.value}". Here are the instructions: "${instruction}."`});
            } else if (fmessage.classList.contains('assistant')){
                message.push({"role": "assistant", "content": fmessage.textContent});
            }
        })
        history['user'] = {
                date: Date.now(),
                type: 'completion',
                system: tone,
                message: message[message.length - 1].content,
                maxTokens: maxTokens,
                choices: n,
                temperature: temp,
                top_p: topP,
                presence_penalty: pres,
                frequency_penalty: freq,
        }

        let json = {
            "model": model, 
            "messages": message,
            "max_tokens": maxTokens,
        };

        if (n != 1) json.n = n;
        if (temp != 1) json.temperature = Number.parseFloat(temp);
        if (topP != 1) json.top_p = Number.parseFloat(topP);
        if (pres != 0) json.presence_penalty = Number.parseFloat(pres);
        if (freq != 0) json.frequency_penalty = Number.parseFloat(freq);

        self.completionAPIRequest(prefix, global, overlay, target, history, n, json, 'edit');
    },
    getImageAIResponse: function(prefix, target,global = false, overlay, n = 1, size = "256x256"){
        const self = this;
        target.classList.add('disable');
        const prompt = document.querySelector(overlay + ' .brxc-overlay__pannel.image .message.input').value;
        let history = [];
        history['user'] = {
            date: Date.now(),
            type: 'images',
            message: prompt,
            choices: parseInt(n),
            sizes: size,
        }
        const api = () => {
            jQuery.ajax({
                type: 'POST',
                url: openai_ajax_req.ajax_url,
                data: {
                    action: 'openai_ajax_function',
                    nonce: openai_ajax_req.nonce
                },
                success: function(response) {
                    const post = async () => {
                        const rawResponse = await fetch('https://api.openai.com/v1/images/generations', {
                          method: 'POST',
                          headers: {
                              'Content-Type': 'application/json',
                              'Authorization' : 'Bearer '+ response,
                            },
                          body: JSON.stringify({
                            "prompt": prompt,
                            "n": n,
                            "size": size,
                            "response_format": "b64_json"
                            })
                        });
                        const content = await rawResponse.json();
                        console.log(content);
                        if(content.error){
                            self.insertErrorMessage(prefix, global, overlay, content.error.message);
                            target.classList.remove('disable');
                        } else {
                            self.insertAIImagesResponse(prefix, global, overlay, content.data, n);
                            target.classList.remove('disable');
                            history['assistant'] = content;
                            self.aihistory.push(history);
                        }
                    };
                    post();
                },
                error: function(response){
                    console.log('Something went wrong with the OpenAI ImageAJAX request: ' + response);
                    target.classList.remove('disable');
                }
            });
        }
        api();
    },
    getCodeAIResponse: function(prefix, target, global = false, overlay, temp = 0, maxTokens, n = 1, topP = 1, pres = 0, freq = 0, model){
        const self = this;
        target.classList.add('disable');
        //const input = "/* Write The following request using CSS only (No HTML, Javavascript, SCSS or SASS). The request: " + document.querySelector(overlay + ' .brxc-overlay__pannel.code .input').value + " */";
        let history = [];
        let message = [{"role": "system", "content": "You are an helpful assistant and a CSS Expert. You just write vanilla CSS codes only (No HTML, Javavascript). Your entire response need to be valid CSS code, because the result is automatically inserted in CSS stylesheet."}];
        const fmessages = document.querySelectorAll(overlay + ' .brxc-overlay__pannel.code .message');
        fmessages.forEach(fmessage => {
            if(fmessage.classList.contains('user')){
                message.push({"role": "user", "content": `/* The following request is meant to be pasted in a CSS file AS IT, so comment any text accordingly. Here is the request: ${fmessage.value} */`});
            }
        })
        history['user'] = {
            date: Date.now(),
            type: 'code',
            message: message[message.length - 1].content,
            maxTokens: 4000,
            choices: n,
            temperature: temp,
            top_p: topP,
            presence_penalty: pres,
            frequency_penalty: freq,
        }

        let json = {
            "model": model, 
            "messages": message,
            "max_tokens": maxTokens,
        };

        if (n != 1) json.n = n;
        if (temp != 1) json.temperature = Number.parseFloat(temp);
        if (topP != 1) json.top_p = Number.parseFloat(topP);
        if (pres != 0) json.presence_penalty = Number.parseFloat(pres);
        if (freq != 0) json.frequency_penalty = Number.parseFloat(freq);

        self.completionAPIRequest(prefix, global, overlay, target, history, n, json, 'code');
    },
    insertErrorMessage: function(prefix, global, overlay, response){
        const self = this;
  
        const wrapper = document.querySelector(overlay + ' .brxc-overlay__error-message-wrapper');
        let inner = `<div class="brxc-ai-response-wrapper remove-on-reset">`;
        inner += `<div name="${prefix}-prompt-response" class="error-message" id="${prefix}ErrorMsg"><i class="bricks-svg ti-close" onClick="this.parentElement.parentElement.remove()"></i>OpenAI API returned an error with the following message: "${response}"</div></div>`;

        wrapper.innerHTML = inner;
        
    },
    saveAIImagetoMediaLibrary: function(target,imageUrl) {
        target.classList.add('disable');
        const api = () => {
            jQuery.ajax({
                type: 'POST',
                url: openai_ajax_req.ajax_url,
                data: {
                    action: 'openai_save_image_to_media_library',
                    image_url: imageUrl,
                    nonce: openai_ajax_req.nonce
                },
                success: function(response) {
                    target.classList.remove('disable');
                    target.textContent = 'Image saved successfully!';
                    setTimeout(() => {
                            target.textContent = 'Save to Media Library';
                    }, 1000)
                },
                error: function(response) {
                    target.classList.remove('disable');
                    target.textContent = 'Error - Something went wrong!';
                    setTimeout(() => {
                            target.textContent = 'Save to Media Library';
                    }, 1000)
                },
            });
        }
        api();
    },
    downloadAIImage: function (src){
        const a = document.createElement("a");
        a.href = src;
        a.download = "AI-Image.png";
        a.click();
        a.remove();
    },
    resizeResourceImg: function(target){
        const panel = target.closest('.brxc-overlay__pannel');
        const img = panel.querySelector('.brxc-overlay__img img');
        img.style.scale = parseFloat(target.value);
    },
    movePanel: (wrapper, value) => {
        wrapper.style.transform = 'translateX(' + value + ')';
    },
    insertAIResponse: function (prefix, global, overlay, response, n){
        const self = this;
        const randClass = self.randomize(6);
        const wrapper = document.querySelector(overlay + ' .brxc-overlay__pannel.completion #' + prefix + 'InsertContentWrapper')
        const generateWrapper = document.querySelector(overlay + ' .brxc-overlay__pannel.completion #' + prefix + 'GenerateContentWrapper');
        generateWrapper.classList.toggle('active');
        let inner = `<div class="brxc-ai-response-wrapper remove-on-reset"><input type="radio" id="brxc${randClass}" name="openai-results"><label for="brxc${randClass}" class="brxc-input__label">`;
        if (n === 0 ) {
            inner += "<p>OpenAI Assistant</p>";
        }
        inner += `<pre name="${prefix}-prompt-response" class="message assistant" id="${prefix}PromptResponse"><code>${response}</code></pre></label></div>`;

        wrapper.insertAdjacentHTML(
            'beforebegin',
            inner
        );
        const radios = document.querySelectorAll('input[name="openai-results"]')
        radios[radios.length - 1].checked = true;
    },
    insertAIEditResponse: function (prefix, global, overlay, response, n){
        const self = this;
        const randClass = self.randomize(6);
        const wrapper = document.querySelector(overlay + ' .brxc-overlay__pannel.edit #' + prefix + 'InsertEditContentWrapper');
        const generateWrapper = document.querySelector(overlay + ' .brxc-overlay__pannel.edit #' + prefix + 'GenerateEditContentWrapper');
        generateWrapper.classList.toggle('active');
        let inner = `<div class="brxc-ai-response-wrapper remove-on-reset"><input type="radio" id="brxc${randClass}" name="${prefix}-edit-results"><label for="brxc${randClass}" class="brxc-input__label">`;
        if (n === 0 ) {
            inner += "<p>OpenAI Assistant</p>";
        }
        inner += `<pre name="${prefix}-prompt-response" class="message assistant" id="${prefix}PromptResponse"><code>${response}</code></pre></label></div>`;
        wrapper.insertAdjacentHTML(
            'beforebegin',
            inner
        );
        const radios = document.querySelectorAll('input[name="' + prefix + '-edit-results"]')
        radios[radios.length - 1].checked = true;
    },
    insertAIImagesResponse: function (prefix, global, overlay, response, n){
        const self = this;
        const wrapper = document.querySelector(overlay + ' .brxc-overlay__pannel.image #' + prefix + 'InsertImagesContentWrapper')
        const generateWrapper = document.querySelector(overlay + ' .brxc-overlay__pannel.image #' + prefix + 'GenerateImagesContentWrapper');
        generateWrapper.classList.toggle('active');
        inner = `<div class="brxc-ai-response-wrapper remove-on-reset">
                 <label class="brxc-input__label">OpenAI Assistant</label>
                 <div class='brxc__img-wrapper'>`;
        for(i = 0; i<n; i++){
            const randClass = self.randomize(6);
            inner += `<input type="radio" id="brxc${randClass}" name="${prefix}-images-results">
                  <label for="brxc${randClass}" class="brxc-input__label">
                    <img src="data:image/png;base64,${response[i].b64_json}" alt="" class="brxc__image" />
                  </label>`;         
        }
        inner += "</div></div>";
        wrapper.insertAdjacentHTML(
            'beforebegin',
            inner
        );
        const radios = document.querySelectorAll('input[name="' + prefix + '-images-results"]')
        radios[radios.length - 1].checked = true;
    },
    insertAICodeResponse: function (prefix, global, overlay, response, n){
        const self = this;
        const randClass = self.randomize(6);
        const generateWrapper = document.querySelector(overlay + ' .brxc-overlay__pannel.code #' + prefix + 'GenerateCodeContentWrapper');
        generateWrapper.classList.toggle('active');
        let inner = `<div class="brxc-ai-response-wrapper remove-on-reset"><input type="radio" id="brxc${randClass}" name="${prefix}-code-results"><label for="brxc${randClass}" class="brxc-input__label">`;
        if (n === 0 ) {
            inner += "<p>OpenAI Assistant</p>";
        }
        inner += `<div name="${prefix}-prompt-response" class="message assistant" id="${prefix}PromptResponse"><textarea>${response}</textarea></div></label></div>`;
        const wrapper = document.querySelector(overlay + ' .brxc-overlay__pannel.code #' + prefix + 'InsertCodeContentWrapper');
        wrapper.insertAdjacentHTML(
            'beforebegin',
            inner
        );
        const textarea = document.querySelector(`label[for="brxc${randClass}"] textarea`);
        self.setNewCodeMirror(textarea);
        const radios = document.querySelectorAll('input[name="' + prefix + '-code-results"]')
        radios[radios.length - 1].checked = true;
    },
    pasteAICode: function(generatedCode){
        const pageCSSLabel = document.querySelector('#brxcCSSOverlay #global-code-openai-page')
        const pageCSS = document.querySelector('#brxcCSSOverlay #brxcPageCSSWrapper .CodeMirror');
        const pageCSSValue = pageCSS.CodeMirror.getValue();
        const finalCode = pageCSSValue + "\n" + generatedCode;
        pageCSS.CodeMirror.setValue(finalCode);
        pageCSSLabel.dispatchEvent(new Event('click'));
        pageCSSLabel.checked = true;
    },
    chatMoreAIResponse: function (prefix, global = false, overlay){
        const wrapper = document.querySelector(overlay + ' #' + prefix + 'InsertContentWrapper')
        wrapper.insertAdjacentHTML(
            'beforebegin',
            `<label for="${prefix}PromptText" class="brxc-input__label remove-on-reset">User Prompt (Required)</label><textarea name="${prefix}-prompt-text" id="${prefix}PromptText" class="${prefix}-prompt-text message user remove-on-reset" placeholder="Type your prompt text here..." cols="30" rows="3" spellcheck="false"></textarea>`
        );
        const container = document.querySelector(overlay + ' .brxc-overlay__pannel.completion')
        const btns = document.querySelector(overlay + ' .brxc-overlay__pannel.completion #' + prefix + 'GenerateContentWrapper')
        btns.classList.toggle('active');
        container.insertBefore(btns, wrapper);

    },
    resetAIresponses: (resets, removes, generate) => {
        resets.forEach(reset => {reset.value = ''});
        removes.forEach(el => {el.remove()});
        const generateWrapper = generate;
        generateWrapper.classList.add('active');
    },
    toggleCustomToneVoice: (prefix, custom) => {
        let input = document.querySelector('#' + prefix + 'System');
        if ( custom.checked==true ) {
            input.style.display = 'block';
        } else {
            input.style.display = 'none';
        }

    },
    toggleRadioVisibility: function(){
        const radios = document.querySelectorAll('[name="brxc-extend-styles"]');
        const target = document.querySelector('#brxc-extend-css-property');
        const eraseClass = document.querySelector('#brxc-extend-erase-classes');
        radios.forEach(radio => {
            radio.addEventListener('change', () =>{
                const radio = document.querySelector('#brxc-extend-style');
                (radio.checked == true) ? target.style.display = 'block' : target.style.display = 'none';
                (radio.checked == true) ? eraseClass.style.display = 'none' : eraseClass.style.display = 'block';
            })
        })

    },
    mounAIHistory: function(prefix, overlay){
        const self = this;

        const canvas = document.querySelector(overlay + ' .brxc-overlay__pannel.history .brxc-canvas');

        if (self.aihistory.length === 0) return canvas.innerHTML = "<p class='brxc__no-record'>No records yet. Please come back here after you generated some AI content.</p>"
        // wrapper
        canvas.classList.remove('empty');
        let inner = '<div class="isotope-wrapper--late" data-gutter="20" data-filter-layout="fitRows" style="--col:1">';
        //search
        inner += '<div class="brxc-overlay__search-box"><input type="search" class="iso-search" name="typography-search" placeholder="Type here to filter the history list" data-type="textContent"><div class="iso-search-icon"><i class="bricks-svg ti-search"></i></div><div class="iso-reset"><i class="bricks-svg ti-close"></i></div></div>';
        //container
        inner += '<div class="isotope-container">';
        if(self.aihistory.length < 1) return;
        const rtf = new Intl.RelativeTimeFormat('en', { numeric: 'auto' });
        for(let i=0; i<self.aihistory.length; i++){
            const diff = self.aihistory[i]['user']['date'] - Date.now();
            let unit = "second";
            let divider = 1000;
            if (diff / 1000 < -59) {
                unit = "minute";
                divider = 60000;
            }
            if (diff / 1000 / 60 < -59) {
                unit = "hour";
                divider = 3600000;
            }
            if (diff / 1000 / 60 / 60 < -23) {
                unit = "day";
                divider = 86400000;
            }
            const time = rtf.format(Math.round(diff / divider), unit);
            inner += `
            <div class="brxc-ai-response-wrapper isotope-selector brxc-isotope__col">
                <input type="radio" id="brxcHistoryUser${i}" name="openai-results">
                <label for="brxcHistoryUser${i}" class="brxc-input__label">
                    <div class="brxc-history__header-wrapper">
                        <div class="brxc-history__header-wrapper--left">
                            <span><i class="fas fa-user"></i>You <span class="brxc__light">(${time})</span></span>
                        </div>
                        <div class="brxc-history__header-wrapper--right">`;
                            if(self.aihistory[i]['user']['type']){
                                inner += `
                                <div class="brxc-history__header-block" data-balloon="Category" data-balloon-pos="top">
                                    <i class="bricks-svg fas fa-tag"></i>
                                    <span>${self.aihistory[i]['user']['type']}</span>
                                </div>`;
                            }
                            if(self.aihistory[i]['user']['choices']){
                                inner += `
                                <div class="brxc-history__header-block" data-balloon="Choices" data-balloon-pos="top">
                                    <i class="bricks-svg fas fa-list-ul"></i>
                                    <span>${self.aihistory[i]['user']['choices']}</span>
                                </div>`;
                            }
                            if (self.aihistory[i]['user']['maxTokens']){
                                inner += `<div class="brxc-history__header-block" data-balloon="Max Tokens" data-balloon-pos="top">
                                    <i class="bricks-svg fas fa-traffic-light"></i>
                                    <span>${self.aihistory[i]['user']['maxTokens']} tokens</span>
                                </div>`;
                            }
                            if (typeof self.aihistory[i]['assistant']['usage'] != 'undefined'){
                                if(self.aihistory[i]['assistant']['usage']['prompt_tokens']){
                                inner += `<div class="brxc-history__header-block" data-balloon="Tokens used" data-balloon-pos="top">
                                    <i class="bricks-svg fas fa-dollar-sign"></i>
                                    <span>${self.aihistory[i]['assistant']['usage']['prompt_tokens']} tokens</span>
                                </div>`;
                                }
                            }
                        inner +=`</div>
                    </div>`;
                    
                    inner +=` <div name="${prefix}-prompt-response" class="message assistant">${self.aihistory[i]['user']['message']}</div>`;
                    
                inner +=`</label>`;
                if(self.aihistory[i]['user']['instruction']){
                    inner += `
                    <input type="radio" id="brxcHistoryInstruction${i}" name="openai-results">
                    <label for="brxcHistoryInstruction${i}" class="brxc-input__label">
                        <div name="${prefix}-prompt-response" class="message assistant">${self.aihistory[i]['user']['instruction']}</div>
                    </label>`;
                }
            inner += `</div>`;
            inner += '<div class="brxc-ai-response-wrapper isotope-selector brxc-isotope__col">';
            if(typeof self.aihistory[i]['assistant']['choices'] != 'undefined'){  
                for(let j=0; j<self.aihistory[i]['assistant']['choices'].length; j++){
                    
                    inner += `
                        <input type="radio" id="brxcHistoryAssistant${i + "c" +  j}" name="openai-results">
                        <label for="brxcHistoryAssistant${i + "c" +  j}" class="brxc-input__label">
                            <div class="brxc-history__header-wrapper">
                                <div class="brxc-history__header-wrapper--left">`
                                if(j===0) inner +=`<span><i class="fas fa-robot"></i>AI assistant <span class="brxc__light">(${time})</span></span>`;
                                inner +=`</div>
                                <div class="brxc-history__header-wrapper--right">`;
                                    if(j===0 && self.aihistory[i]['user']['temperature']){
                                        inner += `
                                        <div class="brxc-history__header-block" data-balloon="Temperature" data-balloon-pos="top">
                                            <i class="bricks-svg fas fa-temperature-empty"></i>
                                            <span>${self.aihistory[i]['user']['temperature']}</span>
                                        </div>`;
                                    }
                                    if(j===0 && self.aihistory[i]['user']['top_p']){
                                        inner += `
                                        <div class="brxc-history__header-block" data-balloon="Top Probability" data-balloon-pos="top">
                                            <i class="bricks-svg fas fa-arrow-up-1-9"></i>
                                            <span>${self.aihistory[i]['user']['top_p']}</span>
                                        </div>`;
                                    }
                                    if(j===0 && self.aihistory[i]['user']['presence_penalty']){
                                        inner += `
                                        <div class="brxc-history__header-block" data-balloon="Presence Penalty" data-balloon-pos="top">
                                            <i class="bricks-svg fas fa-signal"></i>
                                            <span>${self.aihistory[i]['user']['presence_penalty']}</span>
                                        </div>`;
                                    }
                                    if(j===0 && self.aihistory[i]['user']['frequency_penalty']){
                                        inner += `
                                        <div class="brxc-history__header-block" data-balloon="Frequency Penalty" data-balloon-pos="top">
                                            <i class="bricks-svg fas fa-wave-square"></i>
                                            <span>${self.aihistory[i]['user']['frequency_penalty']}</span>
                                        </div>`;
                                    }
                                    if (j===0 && typeof self.aihistory[i]['assistant']['usage'] != 'undefined' && self.aihistory[i]['assistant']['usage']['completion_tokens']){
                                        inner += `
                                        <div class="brxc-history__header-block" data-balloon="Tokens used" data-balloon-pos="top">
                                            <i class="bricks-svg fas fa-dollar-sign"></i>
                                            <span>${self.aihistory[i]['assistant']['usage']['completion_tokens']} tokens</span>
                                        </div>`;
                                    }
                                    inner += `</div>
                            </div>`;
                            if(self.aihistory[i]['user']['type'] === "completion" || self.aihistory[i]['user']['type'] === "code" || self.aihistory[i]['user']['type'] === "edit"){
                                inner += `<div name="${prefix}-prompt-response" class="message assistant">${self.aihistory[i]['assistant']['choices'][j]['message']['content'].trim()}</div>`;
                            } else {
                                inner += `<div name="${prefix}-prompt-response" class="message assistant">${self.aihistory[i]['assistant']['choices'][j]['text'].trim()}</div>`;
                            }
                        inner += '</label>';
                    
                }
            }
            if(self.aihistory[i]['user']['type'] === "images"){
                inner += `
                <input type="radio" id="brxcHistoryAssistant${i}" name="openai-results">
                <label for="brxcHistoryAssistant${i}" class="brxc-input__label">
                <div class="brxc-history__header-wrapper">
                    <div class="brxc-history__header-wrapper--left">
                        <span>AI assistant <span class="brxc__light">(${time})</span></span>
                    </div>
                </div>
                <div name="${prefix}-prompt-response" class="message assistant">I successfully generated ${self.aihistory[i]['user']['choices']} image(s)</div>`;
            }
            if(self.aihistory[i]['user']['type'] === "audio"){
                inner += `
                <input type="radio" id="brxcHistoryAssistant${i}" name="openai-results">
                <label for="brxcHistoryAssistant${i}" class="brxc-input__label">
                <div class="brxc-history__header-wrapper">
                    <div class="brxc-history__header-wrapper--left">
                        <span>AI assistant <span class="brxc__light">(${time})</span></span>
                    </div>`;
                    if(self.aihistory[i]['user']['temperature']){
                        inner += `
                        <div class="brxc-history__header-wrapper--right">
                            <div class="brxc-history__header-block" data-balloon="Temperature" data-balloon-pos="top">
                                <i class="bricks-svg fas fa-temperature-empty"></i>
                                <span>${self.aihistory[i]['user']['temperature']}</span>
                            </div>
                        </div>`;
                    }
                inner += `</div>
                <div name="${prefix}-prompt-response" class="message assistant">${self.aihistory[i]['assistant']['text']}</div>`;
            }
            inner += '</div>';
        }
        //end of container and wrapper
        inner += '</div></div>';

        canvas.innerHTML = inner;


        let filterRes = true;
        let filterSearch = true;
        let qsRegex
        let isotopeGutter;
        let isotopeLayoutHelper;
        const isotopeWrappers = document.querySelectorAll(overlay + ' .isotope-wrapper--late')
        isotopeWrappers.forEach(wrapper => {
            const isotopeContainers = wrapper.querySelectorAll('.isotope-container');
            isotopeContainers.forEach(isotopeContainer => {
                const isotopeSelector = wrapper.querySelectorAll('.isotope-selector');
                const isoSearch = wrapper.querySelector('input[type="search"].iso-search');
                const isoSearchType = isoSearch.dataset.type;
                const isoSearchReset = wrapper.querySelector('.iso-reset');
                if (wrapper.dataset.gutter) {
                    isotopeGutter = parseInt(wrapper.dataset.gutter);
                    wrapper.style.setProperty('--gutter', isotopeGutter + 'px');
                    isotopeSelector.forEach(elm => elm.style.paddingBottom = isotopeGutter + 'px');
                } else {
                    isotopeGutter = 0;
                };

                if (wrapper.dataset.filterLayout) {
                    isotopeLayoutHelper = wrapper.dataset.filterLayout;
                } else {
                    isotopeLayoutHelper = 'fitRows';
                };
                

                // init Isotope
                const isotopeOptions = {
                    itemSelector: '.isotope-selector',
                    layoutMode: isotopeLayoutHelper,
                    transitionDuration: 0,
                    filter: function(itemElem1, itemElem2) {
                        const itemElem = itemElem1 || itemElem2;
                        if(isoSearchType === "textContent") {
                            return qsRegex ? itemElem.textContent.match(qsRegex) : true;
                        } else {
                            filterSearch = qsRegex ? itemElem.getAttribute('title').match(qsRegex) : true;
                            return filterRes;
                        }
                    },
                };


                // Set the correct layout
                switch (isotopeLayoutHelper) {
                    case 'fitRows':
                    isotopeOptions.fitRows = {
                        gutter: isotopeGutter
                    };
                    break;
                    case 'masonry':
                    isotopeOptions.masonry = {
                        gutter: isotopeGutter
                    };
                    break;
                }

                // Search Filter
                const iso = new Isotope(isotopeContainer, isotopeOptions);
                
                if (isoSearch) {
                    isoSearch.addEventListener('keyup', self.debounce(() => {
                        qsRegex = new RegExp(isoSearch.value, 'gi');
                        iso.arrange();
                    }, 100));
                }
                if (isoSearchReset) {
                    isoSearchReset.onclick = () => {
                        isoSearch.value = '';
                        const clickEvent = new Event('keyup');
                        isoSearch.dispatchEvent(clickEvent);
                    }
                }



            })
            
        })
    },
    initGridGuide: function() {
        const self = this;
        const x = document.querySelector('#bricks-builder-iframe').contentWindow;
        const xGridWrapper = document.createElement('section');
        xGridWrapper.classList.add(...['brxc-grid-guide__wrapper','brxe-section']);
        const xGridContainer = document.createElement('div');
        xGridContainer.classList.add('brxe-container');
        const div = '<div></div>';
        xGridContainer.innerHTML += div.repeat(12);
        xGridWrapper.appendChild(xGridContainer);
        x.document.body.after(xGridWrapper);
    },
    gridGuideActive: false,
    toggleTopbarIconState: function(cls, state){
        const self = this;
        const btn = document.querySelector(`#bricks-toolbar li${cls}`);
        if(!btn) return;
        state === true ? btn.classList.add('enabled') : btn.classList.remove('enabled');
    },
    gridGuide: function() {
        const self = this;
        const x = document.querySelector('#bricks-builder-iframe').contentWindow;
        let xGridWrapper = x.document.querySelector('.brxc-grid-guide__wrapper')
        self.gridGuideActive === true ? self.gridGuideActive = false : self.gridGuideActive = true;
        self.gridGuideActive === true ? xGridWrapper.classList.add('active') : xGridWrapper.classList.remove('active');
        self.toggleTopbarIconState('.grid-guide', self.gridGuideActive);
    },
    setGridGuideOptions: function(item){
        const self = this;
        item.classList.contains('open') ? item.classList.remove('open') : item.classList.add('open');
        if(item.classList.contains('open')){
            const wrapper = document.createElement('div');
            wrapper.setAttribute('id', 'brxc-grid-guide-options__wrapper');
            let content = '';
            content += `<ul><div class="header"><span class="title">Grid Guide Options</span><span class="bricks-svg-wrapper save" data-balloon="Save" data-balloon-pos="top"><i class="fas fa-floppy-disk"></i></span><span class="bricks-svg-wrapper close" data-balloon="Close" data-balloon-pos="top"><svg version="1.1" viewBox="0 0 512 512" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" class="bricks-svg"><path d="M400,145.49l-33.49,-33.49l-110.51,110.51l-110.51,-110.51l-33.49,33.49l110.51,110.51l-110.51,110.51l33.49,33.49l110.51,-110.51l110.51,110.51l33.49,-33.49l-110.51,-110.51l110.51,-110.51Z" fill="currentColor"></path></svg></span></div>`;
            content += `<li class="head"><div class="empty"></div><span class="title-col">Columns</span><span class="title-gap">Gap</span><span class="title-color">Color</span></li>`;
            self.vueState.breakpoints.forEach(bp => {
                let data = self.globalSettings.generalCats.gridGuide;
                if(!data) data = [{device: bp.key, col: 12, gap: "2rem", color: "#ff000024"}];
                const obj = data.find(el => el.device === bp.key);
                content += `<li data-device="${bp.key}">
                                <div class="input-grid-guide-device" data-balloon="${bp.label}" data-balloon-pos="top-left">${self.helpers.bpIcons(bp.icon)}</div>
                                <input type="number" min="1" max="12" value="${obj.col}"class="input-grid-guide col">
                                <input type="text" value="${obj.gap}" class="input-grid-guide gap">
                                <div class="input-grid-guide color-wrapper"><div style="background-color:${obj.color}" class="input-grid-guide color" data-color="${obj.color}"></div></div>
                            </li>`
            })
            content += `</ul>`
            wrapper.innerHTML = content
            const toolbar = document.querySelector('.brx-body.main')
            toolbar.appendChild(wrapper)
        } else{
            const wrapper = document.querySelector('#brxc-grid-guide-options__wrapper');
            wrapper?.remove();
            return;
        }

        // Close popup
        const wrapper = document.querySelector('#brxc-grid-guide-options__wrapper');
        const close = wrapper?.querySelector('.close');
        close?.addEventListener('click', () => {
            wrapper?.remove();
            item.classList.remove('open')
        })

        // Save
        const save = wrapper?.querySelector('.save');
        save?.addEventListener('click', () => {
            self.saveGridGuide();
        })

        // Color Picker
        const colors = wrapper.querySelectorAll('.input-grid-guide.color');
        colors.forEach(el => {
            let picker = new ColorPicker(el, el.dataset.color);
            el.addEventListener('colorChange', self.debounce((event) => {
                const color = event.detail.color.hsla;
                el.setAttribute('data-color', color);
                self.generateGridGuideArr();
                self.generateGridGuideCSS();
            }, 100))
        })

        // generate css
        const inputs = wrapper.querySelectorAll('input');
        inputs.forEach(input => {
            input.addEventListener('input', () => {
                self.generateGridGuideArr();
                self.generateGridGuideCSS();
            })
        })
        
    },
    saveGridGuide: function(){
        const self = this;
        const obj = self.globalSettings.generalCats.gridGuide;
        jQuery.ajax({
            url: openai_ajax_req.ajax_url,
            data: {
                action: 'save_grid_guide_ajax_function',
                grid: obj, 
                nonce: openai_ajax_req.nonce
            },
            method: "POST",
            success: function(data) {
                self.vueGlobalProp.$_showMessage('Grid options saved successfully!')
            },
            error: function(data) {
                self.vueGlobalProp.$_showMessage('Something went wrong - Grid options not saved.')
            }
        });
    },
    generateGridGuideArr: function(){
        const self = this;
        const wrapper = document.querySelector('#brxc-grid-guide-options__wrapper');
        if(!wrapper) return;
        const rows = wrapper.querySelectorAll('li:not(.head)');
        const arr = [];
        
        rows.forEach(row => {
            const col = row.querySelector('input[type="number"]').value;
            const gap = row.querySelector('input[type="text"]').value;
            const color = row.querySelector('.input-grid-guide.color').dataset.color;
            arr.push({
                device: row.dataset.device,
                col: col,
                gap: gap,
                color: color,
            })
        })
        self.globalSettings.generalCats.gridGuide = arr;
        return arr;
    },
    generateGridGuideCSS: function(){
        const self = this;
        let css = '';
        let arr = self.globalSettings.generalCats.gridGuide;

        // Default values
        if(!arr){
            arr = [];
            self.vueState.breakpoints.forEach(bp => {
                arr.push({
                    device: bp.key,
                    col: 12,
                    gap: "2rem",
                    color: "#ff000024",
                })
            })
            self.globalSettings.generalCats.gridGuide = JSON.stringify(arr);
        }
        if(typeof self.globalSettings.generalCats.gridGuide === "string") self.globalSettings.generalCats.gridGuide = JSON.parse(self.globalSettings.generalCats.gridGuide);
        arr = self.globalSettings.generalCats.gridGuide;
        self.vueState.breakpoints.forEach((bp,index) => {
            const item = arr.find(el => el && el.device === bp.key)
            if(index === 0){
                css += `.brxc-grid-guide__wrapper>.brxe-container {
                    grid-template-columns: repeat(${item.col},1fr);
                    gap: ${item.gap};
                }
                .brxc-grid-guide__wrapper.active>.brxe-container>div {
                    background-color: ${item.color};
                }`;
            } else {
                const media = self.vueGlobalProp.$_isMobileFirst._value ? 'min' : 'max';
                const mediaValue = self.vueState.breakpoints[index].width;
                css += ` @media screen and (${media}-width: ${mediaValue}px){
                    .brxc-grid-guide__wrapper>.brxe-container {
                        grid-template-columns: repeat(${item.col},1fr);
                        gap: ${item.gap};
                    }
                    .brxc-grid-guide__wrapper.active>.brxe-container>div {
                        background-color: ${item.color};
                    }
                }`;
            }
        })
        const x = document.querySelector('#bricks-builder-iframe').contentWindow;
        let xStylesheet = x.document.querySelector('#brxc-grid-guide-css');
        if(!xStylesheet){
            const el = document.createElement('style');
            el.id = 'brxc-grid-guide-css';
            const xHead = x.document.head;
            xHead.appendChild(el);
        }
        xStylesheet = x.document.querySelector('#brxc-grid-guide-css');
        xStylesheet.innerHTML = css;
    },
    xCodeActive: false,
    XCode: function() {
        const self = this;
        const x = document.querySelector('#bricks-builder-iframe').contentWindow;
        const els = x.document.querySelectorAll('body main *, body footer *, body header *, body .brx-popup.builder *');
        self.xCodeActive === true ? self.xCodeActive = false : self.xCodeActive = true;
        if(self.xCodeActive){
            els.forEach(el=> {
                el.classList.add('x-mode-enabled');
            })
        } else {
            els.forEach(el=> {
                el.classList.remove('x-mode-enabled');
            })
        }
        self.toggleTopbarIconState('.x-mode', self.xCodeActive);
    },
    contrastActive: false,
    contrast: function() {
        const self = this;
        const x = document.querySelector('#bricks-builder-iframe').contentWindow;
        self.contrastActive === true ? self.contrastActive = false : self.contrastActive = true;
        if(self.contrastActive){
            contrast.check();
        } else {
            const failedEls = x.document.querySelectorAll('.brxc-contrast-failed');
            failedEls.forEach(el => el.classList.remove('brxc-contrast-failed'))
        }
        self.toggleTopbarIconState('.constrast', self.contrastActive);
    },
    darkmodeActive: false,
    darkMode: function (){
        const self = this;
        self.darkmodeActive === true ? self.darkmodeActive = false : self.darkmodeActive = true;
        self.colorStates.colorManagerMode === 'light' ? self.colorStates.colorManagerMode = 'dark' : self.colorStates.colorManagerMode = 'light';
        self.generateColorCSS();
        self.generateBuilderCSS();
        self.setColorManager();
        const x = document.querySelector('#bricks-builder-iframe').contentWindow;
        //x.document.body.classList.toggle('brxc-dark');
        const html = x.document.documentElement;
        (html && self.colorStates.colorManagerMode === 'light') ? html.setAttribute('data-theme', 'light') : html.setAttribute('data-theme', 'dark')
        self.toggleTopbarIconState('.darkmode', self.darkmodeActive);

    },
    addMenuItemtoToolbar: (classes, balloonText, balloonPosition, onClickFunction, iconHTML, toolbar, insertBeforeEl) => {
        const li = document.createElement('li');
        li.classList.add(classes);
        li.setAttribute('data-balloon', balloonText);
        li.setAttribute('data-balloon-pos', balloonPosition);
        li.setAttribute('onClick',onClickFunction)
        const span = document.createElement('span');
        span.classList.add('bricks-svg-wrapper');
        span.innerHTML += iconHTML;
        li.appendChild(span);
        toolbar.insertBefore(li,insertBeforeEl);
    },
    addIconToFields: (tag, classes, attrArr, balloonText, balloonPosition, onClickFunction, dataUsed, htmlEl, target, appendMethod) => {
        const li = document.createElement(tag);
        li.classList.add(...classes.split(' '));
        li.setAttribute('data-balloon', balloonText);
        li.setAttribute('data-balloon-pos',balloonPosition);
        if(attrArr && attrArr.length > 0){
            attrArr.forEach(attr => {
                const label = attr[0];
                const value = attr[1];
                li.setAttribute(label, value);
            })
        }
        // if (attr) li.setAttribute(attr, attrValue);
        li.setAttribute('onclick', onClickFunction);
        (dataUsed === true) ? li.setAttribute('data-used', 0) : '';
        li.innerHTML = htmlEl;
        if(appendMethod === 'after'){
            target ? target.after(li) : console.log('No target to append child.') ;
        } else if (appendMethod === 'before'){
            target ? target.before(li) : console.log('No target to append child.') ;
        } else if (appendMethod === 'child'){
            target ? target.appendChild(li) : console.log('No target to append child.') ;
        } 
    },
    addDynamicVariableIcon: function() {
        const self = this;
        setTimeout(() => {
            self.fields['CSSVariabe']['includedFields'].forEach(field => {
                let elements;
                if (typeof field === 'string') {
                    elements = Array.from(document.querySelectorAll(field));
                } else {
                    // Get elements with the selector
                    const filteredElements = Array.from(document.querySelectorAll(field.selector));
        
                    // Check if they have any of the specified child elements
                    elements = filteredElements.filter(el =>
                        el && field.hasChild.some(child => child && el.querySelector(child))
                    );
                }
        
                const wrappers = elements.filter(
                    item => item && !item.parentNode.closest(self.fields['CSSVariabe']['excludedFields'])
                );
                if (wrappers.length < 1) return;
                wrappers.forEach(wrapper => {
                    const modal = wrapper.querySelector('.brxc-toggle-modal');
                    if (modal) return;
                    self.addIconToFields(
                        'div',
                        'brxc-toggle-modal',
                        false,
                        'Select CSS Variable',
                        'top-right',
                        'ADMINBRXC.openVariableModal(event.target.nextElementSibling, "#brxcVariableOverlay", document.querySelector("#brxcVariableOverlay input.iso-search") )',
                        false,
                        "<span>v</span>",
                        wrapper.querySelector("input[type='text']"),
                        'before'
                    );
                });
            });
        }, 100);
    },
    strictEditorState: false,
    setStrictEditorView: function() {
        const self = this;
        if(!self.helpers.isElementActive()) return;
        if(self.strictEditorState !== true || self.vueState.activePanelTab !== "content") {
            const existingCSS = document.querySelector('#brxcFullAccessStyles');
            if(existingCSS) existingCSS.remove();
            const icons = document.querySelectorAll('.brxc-toggle-strict-editor');
            icons.forEach(icon => icon.remove())
            return;
        };
        setTimeout(() => {
            const controls = self.vueGlobalProp.$_getElementConfig(self.vueState.activeElement.name).controls;
            const existingCSS = document.querySelector('#brxcFullAccessStyles');
            if(!existingCSS){
                const style = document.createElement('style');
                style.id = 'brxcFullAccessStyles';
                style.innerHTML =`[data-controlkey]{position: relative;}.control-inner:not(.control-inner .control-inner) > *:not(.has-setting, .brxc-toggle-strict-editor), .control > .description{margin-left: 22px;}`;
                document.head.appendChild(style);
            }
            for(const key of Object.keys(controls)){
                if(controls[key].tab === "content" && !controls[key].hasOwnProperty('css')) {
                    const target = document.querySelector(`#bricks-panel-element [data-controlkey="${key}"] .control:not(.control-separator) .control-inner`);
                    if(!target) continue;
                    const icon = target.querySelector('.brxc-toggle-strict-editor');
                    if (icon) icon.remove();
                    const isFullAccess = controls[key].hasOwnProperty('fullAccess') && controls[key].fullAccess === true ? true : false
                    const toggle = isFullAccess === true ? `<div><i class="fas fa-toggle-off"></i></div>` : `<div><i class="fas fa-toggle-on"></i></div>`;
                    const balloon = isFullAccess === true ? 'Control disabled in Strict Editor View' : 'Control enabled in Strict Editor View';
                    self.addIconToFields(
                        'div',
                        'brxc-toggle-strict-editor',
                        false,
                        balloon,
                        'top-left',
                        'ADMINBRXC.toggleFullAccess(this)',
                        false,
                        toggle,
                        target,
                        'child'
                    );
                }
            }
        }, 100)     
    },
    toggleFullAccess: function(target){
        const self = this;
        const ctrlKey = target.closest('[data-controlkey]').dataset.controlkey;
        const name = self.vueState.activeElement.name;
        const control = self.vueGlobalProp.$_getElementConfig(name).controls[ctrlKey];
        const newValue = control.hasOwnProperty('fullAccess') && control.fullAccess === true ? 'false' : 'true';
        newValue === 'true' ? control.fullAccess = true : delete control.fullAccess;
        self.saveFullAccessBuilder(name, ctrlKey, newValue);
        self.vueState.rerenderControls = Date.now();

    },
    saveFullAccessBuilder: function(name, key, value){
        const self = this;
        if(!self.globalSettings.generalCats.hasOwnProperty('fullAccess')) self.globalSettings.generalCats.fullAccess = {};
        if(!self.globalSettings.generalCats.fullAccess.hasOwnProperty(name)) self.globalSettings.generalCats.fullAccess[name]= {};
        self.globalSettings.generalCats.fullAccess[name][key] = value;
    },
    saveFullAccessOptions: function(){
        const self = this;
        const obj = self.globalSettings.generalCats.fullAccess;
        jQuery.ajax({
            url: openai_ajax_req.ajax_url,
            data: {
                action: 'save_full_access_ajax_function',
                fullAccess: obj,
                nonce: openai_ajax_req.nonce
            },
            method: "POST",
            success: function(data) {
                self.vueGlobalProp.$_showMessage('Strict Editor settings saved successfully!')
            },
            error: function(data) {
                self.vueGlobalProp.$_showMessage('Something went wrong - Strict Editor settings not saved.')
            }
        });
    },
    autoformatControlValues: function(){
        const self = this;
        const controls = document.querySelectorAll('[data-controlkey]')
        controls.forEach(control => {
            if(self.helpers.isCSSControlKey(control.dataset.controlkey) !== true) return; 
            const inputs = control.querySelectorAll('input[type="text"]');
            if(inputs.length < 1) return;
            inputs.forEach(input => {
                input.addEventListener('blur', () => {
                    self.autoformat(input, control);
                    const evt = new Event('input');
                    input.dispatchEvent(evt);
                })
            })
            
        })
    },
    autoformat: function(input, control){
        const self = this;
        
            let values, operators;
            let rootFontSize;
            if (typeof self.vueState.themeStyleSettings === "object" && self.vueState.themeStyleSettings.hasOwnProperty("typography")) {
                const typographyHTML = self.helpers.checkBreakpointFormat('typographyHtml');
                if( self.vueState.themeStyleSettings.typography.hasOwnProperty(typographyHTML) ) {
                    rootFontSize = parseFloat(self.vueState.themeStyleSettings.typography[typographyHTML].replace('%','')) / 100;
                } else{
                    rootFontSize = 0.625;
                } 
            } else {
                rootFontSize = 0.625;
            }

            // Autoclose Brackets for Variables
            if(Object.values(self.globalSettings.autoFormatFunctions).includes("close-var-bracket")){
                values = input.value.split(' ');
                for (let i = 0; i < values.length; i++) {
                    const value = values[i];
                    if (value.includes('var(') && !(value.endsWith(')') || value.endsWith(')!important'))) {
                        values[i] = `${value})`;
                    }
                }
                input.value = values.join(' ');
            }

            // Var()
            if(Object.values(self.globalSettings.autoFormatFunctions).includes("var")){
                values = input.value.split(' ');
                for (let i = 0; i < values.length; i++) {
                    const value = values[i];
                    if (!value.includes('var(') && value.includes('--') && !(value.endsWith(')') || value.endsWith(')!important'))) {
                        values[i] = `${value.replace('--', 'var(--')})`;
                    }
                }
                input.value = values.join(' ');
            }

            // Px to rem
            if(Object.values(self.globalSettings.autoFormatFunctions).includes("px-to-rem")){
                if(input.value.includes('r:') ){
                    values = input.value.split(' ');
                    for (let i = 0; i < values.length; i++) {
                        if(values[i].includes("r:") ){
                            const valueToConvert = values[i].split(':')[1].replace('px','');
                            values[i] = `${(valueToConvert / (16 * rootFontSize)).toFixed(3).toString().replace(/(\.[0-9]*[1-9])0+$|\.0*$/, '$1')}rem`;
                        }
                    }
                    input.value = values.join(' ');
                }
            }

            // Min()
            if(Object.values(self.globalSettings.autoFormatFunctions).includes("min")){
                if(input.value.includes(' < ') ){
                    values = input.value.split(' ');
                    for (let i = 0; i < values.length; i++) {
                        if(values[i] === "<" && values[i-1] && values[i+1]){
                            const min = values[i-1];
                            const max = values[i+1];
                            values[i] = `min(${min},${max})`;
                            values[i-1] = '';
                            values[i+1] = '';
                        }
                    }
                    input.value = values.join(' ').replace(/ min\(([^)]*)\) /g, "min($1)");
                }
            }

            // Max()
            if(Object.values(self.globalSettings.autoFormatFunctions).includes("max")){
                if(input.value.includes(' > ') ){
                    values = input.value.split(' ');
                    for (let i = 0; i < values.length; i++) {
                        if(values[i] === ">" && values[i-1] && values[i+1]){
                            const min = values[i-1];
                            const max = values[i+1];
                            values[i] = `max(${min},${max})`;
                            values[i-1] = '';
                            values[i+1] = '';
                        }
                    }
                    input.value = values.join(' ').replace(/ max\(([^)]*)\) /g, "max($1)");
                }  
            }
            
            // Calc()
            const excludedControls = ['_gridItemColumnSpan', '_gridItemRowSpan'];
            if(Object.values(self.globalSettings.autoFormatFunctions).includes("calc") && (control === "custom" || !excludedControls.includes(control.dataset.controlkey))){
                operators = [' + ',' - ',' * ',' / '];
                function formatCalc(expression) {
                    const containsOperator = operators.some(operator => operator && expression.includes(operator));
                    if (expression.startsWith('calc(') || expression.startsWith('clamp(') ) {
                    return expression;
                    }

                    if (containsOperator) {
                    return `calc(${expression})`;
                    }
                
                    return expression;
                }

                input.value = formatCalc(input.value);
            }
            

            // Clamp()
            if(Object.values(self.globalSettings.autoFormatFunctions).includes("clamp")){
                if(input.value.includes('|') && typeof parseInt(input.value.split('|')[0]) === "number" && typeof parseInt(input.value.split('|')[1]) === "number"){
                    const arr = input.value.split('|');
                    const minSize = parseInt(arr[0]);
                    const maxSize = parseInt(arr[1]);
                    const baseFont = 16 * rootFontSize;
                    const minVW = self.globalSettings.generalCats.minViewportWidth ? parseFloat(self.globalSettings.generalCats.minViewportWidth) : 360;
                    const maxVW = self.globalSettings.generalCats.maxViewportWidth ? parseFloat(self.globalSettings.generalCats.maxViewportWidth) : 1400;
                    const minWidthPx = (arr[2] && typeof parseInt(arr[2]) === "number") ? parseInt(arr[2]) : minVW;
                    const maxWidthPx = (arr[3] && typeof parseInt(arr[3]) === "number") ? parseInt(arr[3]) : maxVW;
                    input.value = self.helpers.clampBuilder(baseFont, minWidthPx, maxWidthPx, minSize, maxSize);
                }
            }
            
    },
    setTextShortcutsWrapper: function(){
        const self = this;
        const panel = document.querySelector("#bricks-panel-element");

        if(
            self.vueState.activePanel === "element"
            && self.vueState.activePanelTab === "content"
            && (
                Object.values(self.globalSettings.elementFeatures).includes("lorem-ipsum") // lorem
                || self.helpers.isAIActive() && self.globalSettings.isAIApiKeyEmpty === "0" // AI
            )
        ){
            setTimeout(() => {
                self.fields['loremIpsum']['includedFields'].forEach(field => {
                    let elements;
                    if (typeof field === 'string') {
                        elements = Array.from(document.querySelectorAll(field));
                    } else {
                        const filteredElements = Array.from(document.querySelectorAll(field.selector));
                        elements = filteredElements.filter(el =>
                            el && el.querySelector(field.hasChild)
                        );
                    }
        
                    const wrappers = elements.filter(
                        item => item &&
                            !item.parentNode.querySelector(self.fields['loremIpsum']['excludedFields']) &&
                            !item.parentNode.closest(self.fields['loremIpsum']['excludedFields'])
                    );
                    if (wrappers.length < 1) return;
                    let padding = 30;
                    if (Object.values(self.globalSettings.elementFeatures).includes("lorem-ipsum")) padding += 25;
                    if (self.helpers.isAIActive() && self.globalSettings.isAIApiKeyEmpty === "0") padding += 25;
                    wrappers.forEach(wrapper => {
                        if(!wrapper.querySelector('.brxc-icon-wrapper')){
                            const div = document.createElement('DIV');
                            div.classList.add('brxc-icon-wrapper');
                            wrapper.appendChild(div);
                            const input = wrapper.querySelector('input');
                            if (input) input.style.paddingRight = `${padding}px`;
                        } 
                        
                    })
                })
            }, 50)
        }
    },
    addDynamicLoremIcon: function() {
        const self = this;
        setTimeout(() => {
            self.fields['loremIpsum']['includedFields'].forEach(field => {
                let elements;
                if (typeof field === 'string') {
                    elements = Array.from(document.querySelectorAll(field));
                } else {
                    // Get elements with the selector
                    const filteredElements = Array.from(document.querySelectorAll(field.selector));
    
                    // Check if they have the specified child element
                    elements = filteredElements.filter(el =>
                        el && el.querySelector(field.hasChild)
                    );
                }
    
                const wrappers = elements.filter(
                    item => item &&
                        !item.parentNode.querySelector(self.fields['loremIpsum']['excludedFields']) &&
                        !item.parentNode.closest(self.fields['loremIpsum']['excludedFields'])
                );
                if (wrappers.length < 1) return;
                wrappers.forEach(wrapper => {
                    //setTimeout(() => {
                        const inputs = wrapper.querySelectorAll('.brxc-toggle-lorem');
                        if (inputs.length > 0) return;
                        const textWrapper = wrapper.querySelector('.brxc-icon-wrapper')
                        if (!textWrapper) return;
                        self.addIconToFields(
                            'div',
                            'brxc-toggle-lorem',
                            false,
                            'Add Dummy Content',
                            'top-right',
                            'ADMINBRXC.addLorem(event.target.parentElement.parentElement.querySelector("textarea,input"), this)',
                            true,
                            "<div class='lorem-wrapper'><div class='lorem-line lorem-line-1'></div><div class='lorem-line lorem-line-2'></div><div class='lorem-line lorem-line-3'></div>",
                            textWrapper,
                            'child'
                        );
                    //},10)
                });
            });
        }, 55);
    },
    addDynamicAIIcon: function() {
        const self = this;
        setTimeout(() => {
            self.fields['openAI']['includedFields'].forEach(field => {
                let elements;
                if (typeof field === 'string') {
                    elements = Array.from(document.querySelectorAll(field));
                } else {
                    // Get elements with the selector
                    const filteredElements = Array.from(document.querySelectorAll(field.selector));
    
                    // Check if they have the specified child element
                    elements = filteredElements.filter(el =>
                        el && el.querySelector(field.hasChild)
                    );
                }
    
                const wrappers = elements.filter(
                    item => item &&
                        !item.parentNode.querySelector(self.fields['openAI']['excludedFields']) &&
                        !item.parentNode.closest(self.fields['openAI']['excludedFields'])
                );
                if (wrappers.length < 1) return;
                wrappers.forEach(wrapper => {
                    const inputs = wrapper.querySelectorAll('.brxc-toggle-ai');
                    if (inputs.length > 0) return;
                    const textWrapper = wrapper.querySelector('.brxc-icon-wrapper')
                    if (!textWrapper) return;
                    self.addIconToFields(
                        'div',
                        'brxc-toggle-ai',
                        false,
                        'Add AI Content',
                        'top-right',
                        'ADMINBRXC.openAIModal("openai",false,event.target.parentElement.parentElement.querySelector("textarea,input"), "#brxcopenAIOverlay" )',
                        false,
                        "<div class='ai-wrapper'><span class='ai-text'>AI</span></div>",
                        textWrapper,
                        'child'
                    );
                });
            });
        }, 60);
    },
    addSpacingIcon: function(){
        const self = this;
        setTimeout(() => {
            const controls = document.querySelectorAll('.control.control-spacing');
            if(controls.length < 1) return;
            controls.forEach(control => {
                const linkIcon = control.querySelector('.link-all');
                if(!linkIcon) return;
                const wrapper = linkIcon.parentElement;
                const existingIcon = wrapper.querySelector('.brxc-toggle-spacing');
                if(existingIcon) return;
                self.addIconToFields(
                    'div',
                    'brxc-toggle-spacing',
                    false,
                    'Expand Fields',
                    'top-right',
                    'ADMINBRXC.expandSpacingControls(event)',
                    false,
                    "<div class='ai-wrapper'><i class='fas fa-arrows-left-right'></i></div>",
                    wrapper,
                    'child'
                );
                if(self.globalSettings.defaultSpacingControls) control.classList.add('expanded');
            });
        }, 60)
    },
    expandSpacingControls: function(event){
        const control = event.target.closest('.control-spacing');
        if (!control) return;
        control.classList.contains('expanded') ? control.classList.remove('expanded') : control.classList.add('expanded');
    },
    headerIconsState: function(){
        const self = this;
        if(!self.helpers.isElementActive()) return;

        const action = document.querySelector('#bricks-panel-element .actions');
        const activeElSettings = (self.helpers.isClassActive()) ? self.vueState.activeClass.settings :  self.vueState.activeElement.settings;
        const isActive = (string, obj) => {
            for (const key in obj) {
                if (JSON.parse(JSON.stringify(key)).indexOf(string) !== -1) {
                  return true;
                }
            }
            return false;
        }
        const states = ['hover', 'before', 'active', 'focus', 'after'];
        states.forEach(state => {
            const item = action.querySelector(`.brxc-header-icon.brxc-header-icon__${state}`);
            if(!item) return;
            item.classList.remove('highlight');
            if(isActive(`:${state}`, activeElSettings)) item.classList.add('highlight');
        })

        //css Icon
        const cssIcon = action.querySelector(`.brxc-header-icon.brxc-header-icon__css-shortcut`);
        if(!cssIcon) return;
        cssIcon.classList.remove('highlight');

        let hasSettings = false;
        for(const key of Object.keys(activeElSettings)){
            if(key.startsWith('_cssCustom')) hasSettings = true;
        }
        if(hasSettings) cssIcon.classList.add('highlight');

    },
    addPanelHeaderIcons: function(){
        const self = this;
        if(!self.helpers.isElementActive()) return;

        // Const
        const wrapper = document.querySelector('#bricks-panel-inner #bricks-panel-header ul.actions')
        if (!wrapper) return;

        const icons = wrapper.querySelectorAll('li.brxc-header-icon');
        const extendIcon = wrapper.querySelector('.brxc-header-icon__extend');
        const findReplaceIcon = wrapper.querySelector('.brxc-header-icon__find-replace');
        const cssIcon = wrapper.querySelector('.brxc-header-icon__css-shortcut');
        const styleOverviewIcon = wrapper.querySelector('.brxc-header-icon__style-overview');
        const openClassIcon = wrapper.querySelector('.brxc-header-icon__show-class-manager');
        const goToParentIcon = wrapper.querySelector('.brxc-header-icon__parent');
        const pseudoState = self.vueState.pseudoClassActive;

        // Remove Icons
        if(openClassIcon) openClassIcon.remove();
        if(goToParentIcon) goToParentIcon.remove();

        // Active State
        icons.forEach(icon => {
            icon.classList.remove('active');
            icon.dataset.balloon === pseudoState ? icon.classList.add('active') : '';
        });

        // Extend Styles & Classes
        if (!extendIcon && Object.values(self.globalSettings.elementShortcutIcons).includes("extend-classes")) {
            wrapper ? self.addIconToFields('li','brxc-header-icon brxc-header-icon__extend', false, 'Extend Classes & Styles', 'bottom-right', 'ADMINBRXC.openExtendClassModal(event,"#brxcExtendModal")', true, '<span class="bricks-svg-wrapper"><svg xmlns="http://www.w3.org/2000/svg" class="bricks-svg" viewBox="0 96 960 960"><path d="M145 1022v-95h670v95H145Zm337-125L311 726l58-59 72 72V413l-72 72-58-59 171-171 172 171-59 59-72-72v326l72-72 59 59-172 171ZM145 225v-95h670v95H145Z"/></svg></span>', wrapper, 'child') : '';
        }

        // Find & replace
        if (!findReplaceIcon && Object.values(self.globalSettings.elementShortcutIcons).includes("find-and-replace")) {
            wrapper ? self.addIconToFields('li','brxc-header-icon brxc-header-icon__find-replace', false, 'Find & Replace Styles', 'bottom-right', 'ADMINBRXC.openFindReplaceModal(event,false, "#brxcFindReplaceModal")', true, '<span class="bricks-svg-wrapper"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 96 960 960" class="bricks-svg"><path xmlns="http://www.w3.org/2000/svg" d="M138 484q18-110 103.838-182T440 230q75 0 133 30.5t98 82.5v-98h72v239H503v-71h100q-27-42-70.5-65T440 325q-72.187 0-130.093 43.5Q252 412 234 484h-96Zm674 492L615 780q-34 27-78 43.5T440.217 840Q367 840 308.5 813 250 786 209 734v93h-72V588h240v71H271q28.269 41.15 72.541 64.075Q387.812 746 440 746q72.102 0 127.444-44.853T642 588h96q-5 33-19 65.5T684 713l197 196-69 67Z"/></svg></span>', wrapper, 'child') : '';
        }

        
        // Pseudo Icons
        if(Object.values(self.globalSettings.elementShortcutIcons).includes("pseudo-shortcut") && self.globalSettings.shortcutsIcons.length > 0){
            if (Object.values(self.globalSettings.shortcutsIcons).includes('hover')){
                if(!self.vueState.pseudoClasses.includes(':hover')) self.vueState.pseudoClasses.push(':hover')
                const hoverIcon = document.querySelector('#bricks-panel-inner #bricks-panel-header ul.actions .brxc-header-icon__hover');
                if (!hoverIcon) {
                    self.addIconToFields('li','brxc-header-icon brxc-header-icon__hover', false, ':hover', 'bottom-right', 'ADMINBRXC.setHeaderState("li.brxc-header-icon__hover", ":hover");', true, '<span class="bricks-svg-wrapper"><i class="fas fa-arrow-pointer"></i></span>', wrapper, 'child');
                }
            }
            if (Object.values(self.globalSettings.shortcutsIcons).includes('before')){
                if(!self.vueState.pseudoClasses.includes(':before')) self.vueState.pseudoClasses.push(':before')
                const beforeIcon = document.querySelector('#bricks-panel-inner #bricks-panel-header ul.actions .brxc-header-icon__before');
                if (!beforeIcon) {
                    self.addIconToFields('li','brxc-header-icon brxc-header-icon__before', false, ':before', 'bottom-right', 'ADMINBRXC.setHeaderState("li.brxc-header-icon__before", ":before");', true, '<span class="bricks-svg-wrapper"><svg class="bricks-svg" viewBox="0 0 24 24"><path d="M5 20h14v-2H5v2zM19 9h-4V3H9v6H5l7 7 7-7z"></path></svg></span>', wrapper, 'child');
                }
            }
            if (Object.values(self.globalSettings.shortcutsIcons).includes('after')){
                if(!self.vueState.pseudoClasses.includes(':after')) self.vueState.pseudoClasses.push(':after')
                const afterIcon = document.querySelector('#bricks-panel-inner #bricks-panel-header ul.actions .brxc-header-icon__after');
                if (!afterIcon) {
                    self.addIconToFields('li','brxc-header-icon brxc-header-icon__after', false, ':after', 'bottom-right', 'ADMINBRXC.setHeaderState("li.brxc-header-icon__after", ":after");', true, '<span class="bricks-svg-wrapper"><svg class="bricks-svg" viewBox="0 0 24 24"><path d="M5 20h14v-2H5v2zM19 9h-4V3H9v6H5l7 7 7-7z"></path></svg></span>', wrapper, 'child');
                }
            }
            if (Object.values(self.globalSettings.shortcutsIcons).includes('active')){
                if(!self.vueState.pseudoClasses.includes(':active')) self.vueState.pseudoClasses.push(':active')
                const activeIcon = document.querySelector('#bricks-panel-inner #bricks-panel-header ul.actions .brxc-header-icon__active');
                if (!activeIcon) {
                    self.addIconToFields('li','brxc-header-icon brxc-header-icon__active', false, ':active', 'bottom-right', 'ADMINBRXC.setHeaderState("li.brxc-header-icon__active", ":active");', true, '<span class="bricks-svg-wrapper"><i class="fas fa-toggle-on"></span>', wrapper, 'child');
                }
            }
            if (Object.values(self.globalSettings.shortcutsIcons).includes('focus')){
                if(!self.vueState.pseudoClasses.includes(':focus')) self.vueState.pseudoClasses.push(':focus')
                const focusIcon = document.querySelector('#bricks-panel-inner #bricks-panel-header ul.actions .brxc-header-icon__focus');
                if (!focusIcon) {
                    self.addIconToFields('li','brxc-header-icon brxc-header-icon__focus', false, ':focus', 'bottom-right', 'ADMINBRXC.setHeaderState("li.brxc-header-icon__focus", ":focus");', true, '<span class="bricks-svg-wrapper"><i class="fas fa-crosshairs"></span>', wrapper, 'child');
                }
            }
        }

        // CSS Shortcut
        if(!cssIcon && Object.values(self.globalSettings.elementShortcutIcons).includes("css-shortcut")){
            wrapper ? self.addIconToFields('li','brxc-header-icon brxc-header-icon__css-shortcut', false, 'Element\s CSS', 'bottom-right', 'ADMINBRXC.cssShortcut()', true, '<span class="bricks-svg-wrapper"><i class="fab fa-css3-alt"></i></span>', wrapper, 'child') : '';
        }

        // Style Overview
        if (!styleOverviewIcon && Object.values(self.globalSettings.elementShortcutIcons).includes("style-overview-shortcut")) {
            wrapper ? self.addIconToFields('li','brxc-header-icon brxc-header-icon__style-overview', false, 'Open in Style Overview', 'bottom-right', `ADMINBRXC.setStyleOverview("no-pseudo");ADMINBRXC.setStyleOverviewCSS();ADMINBRXC.openModal(false, "#brxcStyleOverviewOverlay", document.querySelector("#brxcStyleOverviewOverlay input[type=search]"));`, true, '<span class="bricks-svg-wrapper"><i class="fas fa-table-list"></span>', wrapper, 'child') : '';
        }

        // Open in Class Manager
        if (self.helpers.isClassActive() && Object.values(self.globalSettings.elementShortcutIcons).includes("class-manager-shortcut")) {
            self.addIconToFields('li','brxc-header-icon brxc-header-icon__show-class-manager', false, 'Show Class in Manager', 'bottom-right', `ADMINBRXC.openClassInManager('${self.vueState.activeClass.id}')`, true, '<span class="bricks-svg-wrapper"><i class="ion-md-options"></span>', wrapper, 'child');
        }

        // Go to Parent
        if (Object.values(self.globalSettings.elementShortcutIcons).includes("parent-shortcut") && typeof self.vueState.activeElement !== "undefined" && self.vueState.activeElement.hasOwnProperty('parent') && self.vueState.activeElement.parent != 0) {
            self.addIconToFields('li','brxc-header-icon brxc-header-icon__parent', false, 'Go to Parent Element', 'bottom-right', 'ADMINBRXC.goToParentElement()', true, '<span class="bricks-svg-wrapper"><i class="fas fa-arrow-turn-up"></span>', wrapper, 'child');
        }
    },
    openClassInManager: function(classId){
        const self = this;
        self.states.classManagerActiveClass = classId;
        const obj = self.vueGlobalProp.$_getGlobalClass(classId);
        obj.hasOwnProperty('category') && obj.category ? self.states.classManagerActiveCategory = obj.category : self.states.classManagerActiveCategory = 'All';
        self.openClassManager("global");
    },
    cssShortcut: function(){
        const self = this;
        self.vueState.activePanelTab = "style";
        setTimeout(() => self.vueState.activePanelGroup = "_css", 10);
    },
    goToParentElement: function(){
        const self = this;
        if(!self.helpers.isElementActive()) return;
        self.vueState.activeId = self.vueState.activeElement.parent;
    },
    setHeaderState: function(target, text) {
        const self = this;
        if(!self.helpers.isElementActive()) return;
        const icons = document.querySelectorAll('#bricks-panel-header ul.actions li')
        const icon = document.querySelector('#bricks-panel-header ' + target);

        // If icon is active
        if (icon.classList.contains('active')){
            self.vueState.pseudoClassPopup = false;
            icons.forEach(li => li.classList.remove('active'));
            return;
        }

        // If Icon is inactive
        icons.forEach(li => li.classList.remove('active'));
        icon.classList.add('active');
        const pseudoList = self.vueState.pseudoClasses;
        let isPseudoMatching = false;
        for(var i=0; i<pseudoList.length; i++) {
            if(pseudoList[i].indexOf(text)!=-1) {
                isPseudoMatching = true;
            }
        }
        if (isPseudoMatching === true){
            self.vueState.pseudoClassPopup = true;
            self.vueState.pseudoClassActive = text
        }
    },
    setDynamicColorOnHover: function(){
        const self = this;

        if(!self.helpers.isElementActive()) return;

        const activeEl = self.vueState.activeElement;
        if(!activeEl || !activeEl.hasOwnProperty('settings')) return;

        function setColor(actives) {
            const controls = [['typography', 'color'], ['background', 'backgroundColor'], ['border', 'borderColor']];
        
            self.fields['colorsOnHover']['includedFields'].forEach(field => {
                const colors = document.querySelectorAll(field);
        
                colors.forEach(color => {
                    color.addEventListener('mouseenter', () => {
                        controls.forEach(control => {
                            const closestControl = color.closest(`[data-control=${control[0]}]`);
                            if (closestControl) {
                                const rgb = window.getComputedStyle(color.childNodes[0], null).getPropertyValue('background-color');
                                applyColor(actives, control[1], rgb);
                            }
                        });
                    });
        
                    color.addEventListener('mouseleave', () => {
                        controls.forEach(control => {
                            const closestControl = color.closest(`[data-control=${control[0]}]`);
                            if (closestControl) {
                                applyColor(actives, control[1], '');
                            }
                        });
                    });
                });
            });
        }
        
        function applyColor(actives, property, value) {
            if (Array.isArray(actives)) {
                actives.forEach(active => {
                    active.style[property] = value;
                });
            } else {
                actives.style[property] = value;
            }
        }

        // Multi edit
        if(self.multiSelectStates.ids.length > 0) {
            const objs = self.multiSelectStates.ids.map(el => FRAMEBRXC.vueGlobalProp.$_getElementNode(self.vueGlobalProp.$_getElementObject(el)));
            setTimeout(()=> setColor(objs),0)
        
        // Single value
        } else {
            const active = FRAMEBRXC.vueGlobalProp.$_getElementNode(self.vueState.activeElement);
            if(!active) return;
            setTimeout(()=> setColor(active),0)
        }
    },
    setDynamicClassOnHover: function () {
        const self = this;
        const x = document.querySelector('#bricks-builder-iframe').contentWindow;
        
        if (!self.helpers.isElementActive() || !self.vueState.showElementClasses) {
          const previewStyle = x.document.querySelector('#at-preview-global-classes');
          if (previewStyle) {
            previewStyle.remove();
          }
          return;
        }
        
        const activeEl = self.vueState.activeElement;
        if (!activeEl || !activeEl.hasOwnProperty('settings')) {
          return;
        }

        const previewStyle = x.document.querySelector('#at-preview-global-classes') || document.createElement('style');
        previewStyle.id = 'at-preview-global-classes';
        
        const globalClasses = self.vueState.globalClasses;
        
        if (!Array.isArray(globalClasses) || globalClasses.length < 1) {
            if (previewStyle.parentNode) {
                previewStyle.parentNode.removeChild(previewStyle);
            } 
        
            return;
        }
        
        const filteredClasses = globalClasses.filter(el => el && el.hasOwnProperty('settings') && Object.keys(el.settings).length > 0);
        
        if (filteredClasses.length > 0) {
            
            let css = '';
            filteredClasses.forEach(cls => {
                let tempCSS = self.vueGlobalProp.$_generateCss("globalClass", cls, [self.vueState.activeElement.name]);
                css += tempCSS;
            });

            previewStyle.innerHTML = css;
            x.document.head.appendChild(previewStyle);
        } else if (previewStyle.parentNode) {
            previewStyle.parentNode.removeChild(previewStyle);
        }

        function previewClass(actives, singleClass, clsName){
            singleClass.onmouseenter = () => {
                actives.forEach(active => {
                    active.classList.add(clsName);
                })
            };
            
            singleClass.onmouseleave = () => {
                actives.forEach(active => {
                    active.classList.remove(clsName);
                })
            };
            
            singleClass.onclick = () => {
                actives.forEach(active => {
                    active.classList.remove(clsName);
                })
            };
           
            
        }

        setTimeout(() => {
            const actives = self.multiSelectStates.ids.length > 0 ? self.multiSelectStates.ids.map(el => FRAMEBRXC.vueGlobalProp.$_getElementNode(self.vueGlobalProp.$_getElementObject(el))) : [FRAMEBRXC.vueGlobalProp.$_getElementNode(self.vueState.activeElement)];
            
            const titleArr = document.querySelectorAll('div.bricks-control-popup > div.css-classes > h6');
            if (titleArr.length < 1) {
                return;
            }
            
            const title = titleArr[titleArr.length - 1];
            
            if (!title) {
                return;
            }
            
            const ul = title.nextElementSibling;
            const globalClasses = ul.querySelectorAll('li');
            
            globalClasses.forEach(singleClass => {
                const cls = singleClass.querySelector('.name');
                
                if (!cls) {
                    return;
                }
                
                const clsName = cls.textContent.substring(1);
                
                if (!clsName) {
                    return;
                }
                
                previewClass(actives, singleClass, clsName)
            });
        }, 0);
    
            
    },

    setIsotope: function(selector) {
        const self = this;
        let filterRes = true;
        let filterSelector = "*";
        let filterSearch = true;
        let qsRegex
        let isotopeGutter;
        let isotopeLayoutHelper;
        const base = document.querySelector(selector);
        if(!base) return;
        const isotopeWrappers = base.querySelectorAll('.isotope-wrapper')
        if(!isotopeWrappers || isotopeWrappers.length < 1) return;
        isotopeWrappers.forEach(wrapper => {
            const isotopeContainers = wrapper.querySelectorAll('.isotope-container');
            if(!isotopeContainers || isotopeContainers.length < 0) return;

            isotopeContainers.forEach(isotopeContainer => {
                const isotopeSelector = wrapper.querySelectorAll('.isotope-selector');
                const isoSearch = wrapper.querySelector('input[type="search"].iso-search');
                const isoSearchType = isoSearch.dataset.type;
                const isoSearchReset = wrapper.querySelector('.iso-reset');
                if (wrapper.dataset.gutter) {
                    isotopeGutter = parseInt(wrapper.dataset.gutter);
                    wrapper.style.setProperty('--gutter', isotopeGutter + 'px');
                    isotopeSelector.forEach(elm => elm.style.paddingBottom = isotopeGutter + 'px');
                } else {
                    isotopeGutter = 0;
                };

                if (wrapper.dataset.filterLayout) {
                    isotopeLayoutHelper = wrapper.dataset.filterLayout;
                } else {
                    isotopeLayoutHelper = 'fitRows';
                };
                

                // init Isotope
                const isotopeOptions = {
                    itemSelector: '.isotope-selector',
                    layoutMode: isotopeLayoutHelper,
                    transitionDuration: 0,
                    filter: function(itemElem1, itemElem2) {
                        const itemElem = itemElem1 || itemElem2;
                        if(isoSearchType === "textContent") {
                            return qsRegex ? itemElem.textContent.match(qsRegex) : true;
                        } else {
                            filterSearch = qsRegex ? itemElem.getAttribute('title').match(qsRegex) : true;
                            filterRes = filterSelector != '*' ? itemElem.dataset.filter.includes(filterSelector) : true;
                            return filterSearch && filterRes;
                        }
                    },
                };


                // Set the correct layout
                switch (isotopeLayoutHelper) {
                    case 'fitRows':
                    isotopeOptions.fitRows = {
                        gutter: isotopeGutter
                    };
                    break;
                    case 'masonry':
                    isotopeOptions.masonry = {
                        gutter: isotopeGutter
                    };
                    break;
                }

                // Search Filter
                const iso = new Isotope(isotopeContainer, isotopeOptions);
                
                if (isoSearch) {
                    isoSearch.addEventListener('keyup', self.debounce(() => {
                        qsRegex = new RegExp(isoSearch.value, 'gi');
                        iso.arrange();
                    }, 100));
                }
                if (isoSearchReset) {
                    isoSearchReset.onclick = () => {
                        isoSearch.value = '';
                        const clickEvent = new Event('keyup');
                        isoSearch.dispatchEvent(clickEvent);
                    }
                }

                // Buttons Filters
                const filtersElem = wrapper.querySelectorAll(".filterbtn");
                if (filtersElem.length > 0) {
                    filtersElem.forEach(elem => elem.addEventListener("click", function (event) {
                        event.preventDefault();
                        var filterValue = event.target.getAttribute("data-filter");
                        filterSelector = filterValue;
                        iso.arrange();
                    }));
                };

                const radioButtonGroup = (buttonGroup) => {
                    buttonGroup.addEventListener("click", function (event) {
                    filtersElem.forEach(btn => btn.classList.remove("active"));
                    event.target.classList.add("active");
                    });
                };

                for (var i = 0, len = filtersElem.length; i < len; i++) {
                    var buttonGroup = filtersElem[i];
                    radioButtonGroup(buttonGroup);
                };

                // Hide if empty
                iso.on('arrangeComplete', (event) => {
                    if (event.length === 0 ) {
                        isotopeContainer.style.display = "none";
                        (isotopeContainer.previousElementSibling) ? isotopeContainer.previousElementSibling.style.display = "none" : '';
                    } else {
                        isotopeContainer.style.display = "flex";
                        (isotopeContainer.previousElementSibling) ? isotopeContainer.previousElementSibling.style.display = "flex" : '';
                    }
                })



            })
            
        })
    },
    openInnerWindow: (wrapper) => {
        wrapper.classList.toggle('inner');
    },
    setInnerContent: (el) => {
        const imgCanvas = document.querySelector('#brxcResourcesOverlay .brxc-overlay__pannel-2 .brxc-overlay__img');
        const titleCanvas = document.querySelector('#brxcResourcesOverlay .brxc-overlay__pannel-2 .brxc-overlay__header-title');
        const srcImg = el.childNodes[1].src;
        const titleText = el.getAttribute('title');
        imgCanvas.innerHTML = '<img src="' + srcImg + '" class="inner__img">';
        titleCanvas.textContent = titleText;
    },
    copytoClipboardSimple: function(text, successMsg) {
        const self = this;
        if (window.isSecureContext && navigator.clipboard) {
           navigator.clipboard.writeText(text);
           self.vueGlobalProp.$_showMessage(successMsg)
        } else {
            self.unsecuredCopyToClipboardSimple(text, successMsg);
        }
     },
     unsecuredCopyToClipboardSimple: function(text, successMsg) {
        const self = this;
        const textArea = document.createElement("textarea");
        textArea.value = text;
        document.body.appendChild(textArea);
        textArea.focus({
           preventScroll: true
        });
        textArea.select();
        try {
           document.execCommand('copy');
           self.vueGlobalProp.$_showMessage(successMsg);
        } catch (err) {
            alert('Unable to copy to clipboard - Use a secure environment.')
        }
        document.body.removeChild(textArea);
     },
    copytoClipboard: function(btn,target, copytext, resestText) {
        const self = this;
        if (window.isSecureContext && navigator.clipboard) {
           navigator.clipboard.writeText(target);
           btn.textContent = copytext;
           setTimeout(() => {
                btn.textContent = resestText;
           }, 1000)
        } else {
            self.unsecuredCopyToClipboard(btn,target,copytext, resestText);
        }
     },
     unsecuredCopyToClipboard: (btn,text,copytext, resestText) => {
        const textArea = document.createElement("textarea");
        textArea.value = text;
        document.body.appendChild(textArea);
        textArea.focus({
           preventScroll: true
        });
        textArea.select();
        try {
           document.execCommand('copy');
           btn.textContent = copytext;
           setTimeout(() => {
                btn.textContent = resestText;
           }, 1000)
        } catch (err) {
            alert('Unable to copy to clipboard - Use a secure environment.')
        }
        document.body.removeChild(textArea);
     },
    codeMirrorOptions: (textarea) => {
        let builderTheme;
        (typeof bricksData["loadData"] !== "undefined" && bricksData["loadData"].hasOwnProperty("globalClasses") && bricksData["loadData"]['globalSettings'].hasOwnProperty("builderMode") && bricksData['loadData']['globalSettings']['builderMode'] === 'light') ? builderTheme = 'default' : builderTheme = 'one-dark';
        const obj = {
            value: '',
            mode: "css",
            theme: builderTheme,
            readOnly: false,
            styleActiveLine: true,
            tabSize: 2,
            lineNumbers: true,
            lineWrapping: !0,
            autoRefresh: !0,
            autofocus: true,
            suppressErrorLogging: !1,
            autoCloseBrackets: true,
            matchBrackets: true,
            selfContain: true,
            comment: true,
            extraKeys: { Tab: "emmetExpandAbbreviation", Esc: "emmetResetAbbreviation", Enter: "emmetInsertLineBreak" },
        };
        if(textarea !== false) obj.value = textarea.value;
        return obj;
    },
    setCodeMirror: function() {
        const self = this;
        const customCSS = document.querySelector("#brxcCustomCSS");
        const customGlobalCSS = document.querySelector("#brxcCustomGlobalCSS");
        const PlainClasses = document.querySelector("#plainClassesInput");
        let pageCSS = self.vueState.pageSettings.customCss;
        let globalCSS = self.vueState.globalSettings.customCss;

        const codemirrors = document.querySelectorAll("#brxcCSSOverlay.brxc-overlay__wrapper .brxc-codemirror__imported")
        if (customCSS && pageCSS) {
            customCSS.innerHTML = pageCSS
        } else if(customCSS){
            customCSS.innerHTML = '';
        }
        if (customGlobalCSS && globalCSS) {
            customGlobalCSS.innerHTML = globalCSS;
        } else if (customGlobalCSS){
            customGlobalCSS.innerHTML = '';
        }

        CodeMirror.hint.anyword = function (editor) {
            var list = self.globalClasses();
            var cursor = editor.getCursor();
            var currentLine = editor.getLine(cursor.line);
            var start = cursor.ch;
            var end = start;
            var reg = /[\w\-$]+/;
            while (end < currentLine.length && reg.test(currentLine.charAt(end))) ++end;
            while (start && reg.test(currentLine.charAt(start - 1))) --start;
            var curWord = start != end && currentLine.slice(start, end);
            var regex = new RegExp('^' + curWord, 'i');
            var result = {
                list: (!curWord ? list : list.filter(function (item) {
                    return item.match(regex);
                })).sort(),
                from: CodeMirror.Pos(cursor.line, start),
                to: CodeMirror.Pos(cursor.line, end)
            };

            return result;
        }
        const cssHinter = CodeMirror.hint.css;

        const cssVariablesCache = new Map();

        CodeMirror.hint.css = function (editor) {
            const cursor = editor.getCursor();
            const token = editor.getTokenAt(cursor);
            const currentLine = editor.getLine(cursor.line);
            let start = cursor.ch;
            let end = start;
            const rex = /[\w\-$!]+/; // a pattern to match any characters in our hint "words"
            // Our hints include function calls, e.g. "trap.getSource()"
            // so we search for word charcters (\w) and periods.
            // First (and optional), find end of current "word" at cursor...
            while (end < currentLine.length && rex.test(currentLine.charAt(end))) ++end;
            // Find beginning of current "word" at cursor...
            while (start && rex.test(currentLine.charAt(start - 1))) --start;
            // Grab the current word, if any...
            const curWord = start !== end && currentLine.slice(start, end);
            // Get the default results object from the JavaScript hinter...
            const dflt=cssHinter(editor);
            // If the default hinter didn't hint, create a blank result for now...
            const result = dflt || {list: []};
            // Set the start/end of the replacement range...
            result.to=CodeMirror.Pos(cursor.line, end);
            result.from=CodeMirror.Pos(cursor.line, start);
            var inner = CodeMirror.innerMode(editor.getMode(), token.state);
            // Add our custom hintWords to the list, if they start with the curWord...
            if(["prop","parens","at","params"].includes(inner.state.state)){

                // Check the cache for CSS variables
                let cssVariables = cssVariablesCache.get(curWord);

                if (cssVariables === undefined) {
                    cssVariables = self.cssVariables.filter(variable => variable && variable.includes(curWord));
                    cssVariablesCache.set(curWord, cssVariables);
                }
                
                result.list = result.list.concat(cssVariables);

                for(let i = 0; i < result.list.length; i++){
                    h = result.list[i];
                    if((typeof h === "string")){
                        result.list[i] = {
                            "text": `${h}`,
                            "displayText": h
                        }
                    }
                }
            } else {
                for(let i = 0; i < result.list.length; i++){
                    h = result.list[i];
                    if((typeof h === "string")){
                        result.list[i] = {
                            "text": `${h}: `,
                            "displayText": h
                        }
                    }
                }
            }

            result.list.sort((a, b) => {
                const textA = a.text.replace(':', '').toLowerCase();
                const textB = b.text.replace(':', '').toLowerCase();
            
                if (textA < textB) {
                    return -1;
                }
                if (textA > textB) {
                    return 1;
                }
                return 0;
            });
            
            return result;
            
        }

        CodeMirror.commands.autocomplete = self.debounce(function(cm) {
            var doc = cm.getDoc();
            var POS = doc.getCursor();
            var mode = CodeMirror.innerMode(cm.getMode(), cm.getTokenAt(POS).state).mode.name;
            if (mode == 'css' || mode === "myMode" || mode === "sass") {
                cm.showHint(
                    {
                        hint: CodeMirror.hint.css,
                        completeSingle: false,
                    }
                )
            } else if(mode == 'text/x-markdown') {
                cm.showHint(
                    {
                        hint: CodeMirror.hint.anyword,
                        completeSingle: false,
                    }
                )
            } else if(mode == 'cssVariables') {
                cm.showHint(
                    {
                        hint: CodeMirror.hint.cssVariables,
                        completeSingle: true,
                    }
                )
            }
        }, 300);

        [customCSS, customGlobalCSS, PlainClasses, ...codemirrors].forEach(textarea => {
            if (!textarea) return;
            const myCodeMirror = CodeMirror(function(elt) {
                textarea.parentNode.replaceChild(elt, textarea);
            }, self.codeMirrorOptions(textarea));

            if(textarea === customCSS){
                const pageSettings = self.vueState.pageSettings;
                let keyupDebounce;

                myCodeMirror.setOption('autoCloseBrackets', "[]{}''\"\"");
                
                myCodeMirror.on('change', () => {
                    clearTimeout(keyupDebounce);
                    keyupDebounce = setTimeout(() => {
                        const newValue = myCodeMirror.getValue();
            
                        if (newValue === "") {
                            setTimeout(() => delete pageSettings['customCss'], 10);
                            if(self.globalSettings.classFeatures.advancedCSSEnableSass) setTimeout(() => delete pageSettings['customSass'], 10);
                        } else {
                            if(self.globalSettings.classFeatures.advancedCSSEnableSass){
                                const dataOptions = { indent_size: 2, space_in_empty_paren: false }
                                Sass.compile( newValue, function(result) {
                                if (result.status === 0) {
                                    pageSettings['customCss'] = css_beautify(result.text, dataOptions);
                                    pageSettings['customSass'] = newValue;
                                }
                            });
                            } else {
                                pageSettings['customCss'] = newValue;
                            }
                        }
                    }, 100);
                });
                myCodeMirror.on("keydown", function (cm, event) {
                    if (!cm.state.completionActive &&
                        ((event.key >= '0' && event.key <= '9') ||    // Digits 0-9
                         (event.key >= 'a' && event.key <= 'z') ||    // Letters a-z
                         event.key === '(' || event.key === '!' ||    // Opening parenthesis (
                         event.key === '-') &&                        // Dash
                        !event.metaKey && !event.altKey && event.key !== '{' && event.key !== '}' &&
                        !event.ctrlKey) {
                        CodeMirror.commands.autocomplete(cm, null, { completeSingle: false });
                    }

                    if(event.metaKey && event.shiftKey && event.key === "7" ){
                        cm.toggleComment();
                    }

                    if (event.key === 'Tab') {
                        self.helpers.replaceRWithRoot(myCodeMirror, event)
                    }
                
                });
                
            } else if(textarea === customGlobalCSS){
                const globalSettings = self.vueState.globalSettings;
                let keyupDebounce;

                myCodeMirror.setOption('autoCloseBrackets', "[]{}''\"\"");
                
                myCodeMirror.on('change', () => {
                    clearTimeout(keyupDebounce);
                    keyupDebounce = setTimeout(() => {
                        const newValue = myCodeMirror.getValue();
            
                        if (newValue === "") {
                            setTimeout(() => delete globalSettings['customCss'], 10);
                            if(self.globalSettings.classFeatures.advancedCSSEnableSass) setTimeout(() => delete globalSettings['customSass'], 10);
                        } else {
                            if(self.globalSettings.classFeatures.advancedCSSEnableSass){
                                const dataOptions = { indent_size: 2, space_in_empty_paren: false }
                                Sass.compile( newValue, function(result) {
                                if (result.status === 0) {
                                    globalSettings['customCss'] = css_beautify(result.text, dataOptions);
                                    globalSettings['customSass'] = newValue;
                                }
                            });
                            } else {
                                globalSettings['customCss'] = newValue;
                            }
                        }
                    }, 100);
                })




                myCodeMirror.on("keydown", function (cm, event) {
                    if (!cm.state.completionActive &&
                        ((event.key >= '0' && event.key <= '9') ||    // Digits 0-9
                         (event.key >= 'a' && event.key <= 'z') ||    // Letters a-z
                         event.key === '(' || event.key === '!' ||    // Opening parenthesis (
                         event.key === '-') &&                        // Dash
                        !event.metaKey && !event.altKey && event.key !== '{' && event.key !== '}' &&
                        !event.ctrlKey) {
                        CodeMirror.commands.autocomplete(cm, null, { completeSingle: false });
                    }

                    if(event.metaKey && event.shiftKey && event.key === "7" ){
                        cm.toggleComment();
                    }

                    if (event.key === 'Tab') {
                        self.helpers.replaceRWithRoot(myCodeMirror, event)
                    }
                });
            } else if(textarea === PlainClasses){
                document.querySelector('#brxcPlainClassesOverlay .CodeMirror').CodeMirror.getMode().name = "text/x-markdown";
                myCodeMirror.setOption('lineNumbers', false);
                myCodeMirror.setOption('autoCloseBrackets', false);
                myCodeMirror.setOption('matchBrackets', false);
                myCodeMirror.setOption('gutters', false);
                myCodeMirror.setOption('highlightSelectionMatches', false);
                myCodeMirror.setOption("placeholder",'Type your classes here...');
                myCodeMirror.on("keydown", function (cm, event) {
                    if (!cm.state.completionActive &&
                        ((event.key >= '0' && event.key <= '9') ||    // Digits 0-9
                         (event.key >= 'a' && event.key <= 'z') ||    // Letters a-z
                         event.key === '-') &&                        // Dash
                        !event.metaKey && !event.altKey && event.key !== '{' && event.key !== '}' &&
                        !event.ctrlKey) {
                        CodeMirror.commands.autocomplete(cm, null, { completeSingle: false });
                    }
                });
                myCodeMirror.on("beforeChange", function(cm, changeObj) {
                    var typedNewLine = changeObj.origin == '+input' && typeof changeObj.text == "object" && changeObj.text.join("") == "";
                    if (typedNewLine) {
                        return changeObj.cancel();
                    }
                
                    var pastedNewLine = changeObj.origin == 'paste' && typeof changeObj.text == "object" && changeObj.text.length > 1;
                    if (pastedNewLine) {
                        var newText = changeObj.text.join(" ");
                        return changeObj.update(null, null, [newText]);
                    }
                
                    return null;
                });
            } else {
                myCodeMirror.options['readOnly'] = true;
            }

        });
        (self.helpers.isBuilderTweaksTabActive()) ? self.switchCodePanels() : '';
    },
    setNewCodeMirror: function(target){
        const self = this;
        const myCodeMirror = CodeMirror(function(elt) {
            target.parentNode.replaceChild(elt, target);
        }, self.codeMirrorOptions(target));
    },
    addRootTag: function(event, closest){
        const self = this;
        const target = event.target;
        const controlKey = target.closest(closest);
        if(!controlKey) return;
        const cm = controlKey.querySelector('.CodeMirror[data-type="at"]')
        if(!cm) return;

        const value = cm.CodeMirror.getValue();
        const result = (value === '') ? '%root% {\n\t\n}' : value + '\n\n%root% {\n\t\n}';
        cm.CodeMirror.setValue(result);

        cm.CodeMirror.focus();
        self.helpers.setCursorToLastRowMinusOne(cm.CodeMirror);
    },
    beautifyCSS: function(event,closest){
        const self = this;
        const target = event.target;
        const controlKey = target.closest(closest);
        if(!controlKey) return;
        const cm = controlKey.querySelector('.CodeMirror[data-type="at"]')
        if(!cm) return;

        const objTarget = self.helpers.createTarget('_cssCustom');

        // Return Value
        const dataOptions = { indent_size: 2, space_in_empty_paren: false }
        const result = css_beautify(cm.CodeMirror.getValue(), dataOptions);
        cm.CodeMirror.setValue(result);

        const finalSelector = (typeof self.vueState.activeClass !== "object" || Object.keys(self.vueState.activeClass).length < 1) ? (self.vueState.activeElement.settings.hasOwnProperty('_cssId')) ? `#${self.vueState.activeElement.settings._cssId}` : `#brxe-${self.vueState.activeElement.id}` : `.${self.vueState.activeClass.name}`;

        if(self.helpers.isClassActive()){
            self.vueState.activeClass.settings[objTarget] = self.vueGlobalProp.$_replaceCustomCssRoot('%root%', finalSelector, result);
        } else {
            self.vueState.activeElement.settings[objTarget] = self.vueGlobalProp.$_replaceCustomCssRoot('%root%', finalSelector, result);
        }

    },
    exportScopedVariables: function(event, closest){
        const self = this;
        const target = event.target;
        const controlKey = target.closest(closest);
        if(!controlKey) return;
        const cm = controlKey.querySelector('.CodeMirror[data-type="at"]')
        if(!cm) return;

        function extractCssVariables(cssText) {
            const variableRegex = /--[\w-]+/g;
            const matches = cssText.match(variableRegex);
            return [...new Set(matches)] || [];
        }

        const variables = extractCssVariables(cm.CodeMirror.getValue());
        
        if(variables.length < 1){
            return self.vueGlobalProp.$_showMessage('Abort - No variables found!');
        }

        const objTarget = self.helpers.createTarget('_scopedVariables');
        const finalArr = [];

        variables.forEach(variable => {
            finalArr.push({
                id: self.vueGlobalProp.$_generateId(),
                title: variable,
                cssVarValue: '',
            })
        })

        if(self.helpers.isClassActive()){
            self.vueState.activeClass.settings[objTarget] = finalArr;
        } else {
            self.vueState.activeElement.settings[objTarget] = finalArr;
        }

        //self.vueState.rerenderControls = Date.now();
        return self.vueGlobalProp.$_showMessage('CSS variables correctly exported to the Scoped Variables Repeater!');
    },
    commentCode: function(event,closest){
        const target = event.target;
        const controlKey = target.closest(closest);
        if(!controlKey) return;
        const cm = controlKey.querySelector('.CodeMirror[data-type="at"]')
        if(!cm) return;
        cm.CodeMirror.toggleComment();
    },
    addComponentSelectors: function(event,closest){
        const self = this;
        const target = event.target;
        const controlKey = target.closest(closest);
        if(!controlKey) return;
        const cm = controlKey.querySelector('.CodeMirror[data-type="at"]')
        if(!cm) return;

        // Function
        const dataOptions = { indent_size: 2, space_in_empty_paren: false };
        let existingSelector = [];
        let selector = false;

        const objTarget = self.helpers.createTarget('_cssCustom');

        function createSelector(obj,existingSelector){
            if (obj.settings.hasOwnProperty('_cssGlobalClasses') && Array.isArray(obj.settings._cssGlobalClasses) && obj.settings._cssGlobalClasses.length > 0) {
                const unlocked = [];
                const locked = [];
                obj.settings._cssGlobalClasses.forEach(el => {
                    (self.vueGlobalProp.$_isLocked(el)) ? locked.push(el) : unlocked.push(el);
                });
                const ids = (unlocked.length > 0) ? unlocked : locked;
                if (ids.length > 0) {
                    let classes = [] 
                    ids.forEach(id => {
                        classes.push(self.vueGlobalProp.$_getGlobalClass(id).name);
                    })
                    selector = `.${classes.join('.')}`;
                } else {
                    selector = false;
                }
            } else {
                selector = `#${self.vueGlobalProp.$_getElementId(obj)}`;
            } 
            if(selector === false || existingSelector.includes(selector)) return "";
            existingSelector.push(selector);
            return `${selector}{\n\t\n}\n\n`;
        }

        let css = "";

        function checkChildren(obj, first){
            if(first === true) existingSelector = [];
            css += createSelector(obj,existingSelector);
            if(obj.children.length < 1) return;
            obj.children.forEach(child =>{
                checkChildren(self.vueGlobalProp.$_getElementObject(child), false);
            })
        }

        checkChildren(self.vueState.activeElement, true);
        const finalSelector = (typeof self.vueState.activeClass !== "object" || Object.keys(self.vueState.activeClass).length < 1) ? (self.vueState.activeElement.settings.hasOwnProperty('_cssId')) ? `#${self.vueState.activeElement.settings._cssId}` : `#brxe-${self.vueState.activeElement.id}` : `.${self.vueState.activeClass.name}`;
        const calculatedValue = self.vueGlobalProp.$_replaceCustomCssRoot(finalSelector, '%root%', css)

        // Return Value
        const value = cm.CodeMirror.getValue();
        const result = (value === '') ? calculatedValue : value + `\n\n${calculatedValue}`;
        cm.CodeMirror.setValue(result);

        if(self.helpers.isClassActive()){
            self.vueState.activeClass.settings[objTarget] = self.vueGlobalProp.$_replaceCustomCssRoot('%root%', finalSelector, result);
        } else {
            self.vueState.activeElement.settings[objTarget] = self.vueGlobalProp.$_replaceCustomCssRoot('%root%', finalSelector, result);
        }

        cm.CodeMirror.focus();
        self.helpers.setCursorToLastRowMinusOne(cm.CodeMirror);
    },
    superPowerStates: {
        fullScreen: true,
    },
    setSuperPowerCSS: function(){
        const self = this;
        
        if(!self.helpers.isElementActive() || (self.showControlSearch === false && self.vueState.activePanelTab !== "style") || (self.vueState.showControlSearch === false && self.vueState.activePanelGroup !== "_css") || self.vueState.showInteractions === true || self.vueState.showConditions === true) return;
    
        const panel = document.querySelector('#bricks-panel');

        // Mount CM
        setTimeout(() => {
            const elmntTarget = panel.querySelector('[data-controlkey="_cssSuperPowerCSS"]');
            if(!elmntTarget) return;

            const textAreaTarget = elmntTarget.querySelector('textarea')
            const description = elmntTarget.querySelector('.description');

            if(elmntTarget && textAreaTarget){
                self.mountSuperPowerCSSCM(textAreaTarget, false);
                if(description) self.addFullSizeCSSState();

            } else if(elmntTarget){
                const observer = new MutationObserver(() => {
                    const textAreaTarget = elmntTarget.querySelector('textarea')
                    if (!textAreaTarget) {
                        return;
                    }
                    
                    self.mountSuperPowerCSSCM(textAreaTarget, observer);
    
                    const description = elmntTarget.querySelector('.description');
                    if(description) self.addFullSizeCSSState();
                })
                observer.observe(elmntTarget, { subtree: true, childList: true });
    
            }
        }, 125)
    },
    mountSuperPowerCSSCM: function(textAreaTarget, observer){
        const self = this;
        if(textAreaTarget.dataset.mounted === "true") return;
        textAreaTarget.setAttribute("data-mounted", "true");
        const options = self.codeMirrorOptions(false);
        options.readOnly = false;
        options.styleActiveLine = true;
        options.autoCloseBrackets = true;
        options.matchBrackets = true;
        options.selfContain = true;
        self.vueState.showControlSearch === true ? options.autofocus = false : options.autofocus = true;
        options.search = { bottom: false };
        const MyCM = CodeMirror.fromTextArea(textAreaTarget, options)
        MyCM.getWrapperElement().setAttribute("data-type", "at");
        MyCM.setOption('gutters', []);
        self.updateSuperPowerCSS(MyCM);

        self.addIconsToSuperpowerCSS();
        self.populateCSSVariables();
        self.addListenersToSuperPowerCSS(MyCM, textAreaTarget);
        MyCM.execCommand("goDocEnd");
        if(observer) observer.disconnect();

    },
    addIconsToSuperpowerCSS: function(){
        const self = this;
        const controlKey = document.querySelector('[data-controlkey="_cssSuperPowerCSS"]');
        let action = '';
        let existing = '';
        (controlKey) ? existing = controlKey.querySelector('.CodeMirror[data-type="at"]') : existing = false;
        (controlKey) ? action = controlKey.querySelector('.brxc-action') : action = false;
        (existing && !action) ? existing.insertAdjacentHTML('beforeBegin', '<div class="brxc-action"></div>') : '';
        action = controlKey.querySelector('.brxc-action')
        if(action){
            const iconRoot = controlKey.querySelector('.brxc-toggle-root');
            if(!iconRoot){
                self.addIconToFields(
                    'div',
                    'brxc-toggle-root',
                    false,
                    'Add %root% {}',
                    'top-right',
                    'ADMINBRXC.addRootTag(event,`[data-controlkey="_cssSuperPowerCSS"]`)',
                    true,
                    `<span class="bricks-svg-wrapper"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 48 48" class="brxc__svg-path"><path d="M28.5 40v-3h6q1.05 0 1.775-.725Q37 35.55 37 34.5v-5q0-1.85 1.125-3.3 1.125-1.45 2.875-2v-.4q-1.75-.5-2.875-1.975T37 18.5v-5q0-1.05-.725-1.775Q35.55 11 34.5 11h-6V8h6q2.3 0 3.9 1.6t1.6 3.9v5q0 1.05.725 1.775Q41.45 21 42.5 21H44v6h-1.5q-1.05 0-1.775.725Q40 28.45 40 29.5v5q0 2.3-1.6 3.9T34.5 40Zm-15 0q-2.3 0-3.9-1.6T8 34.5v-5q0-1.05-.725-1.775Q6.55 27 5.5 27H4v-6h1.5q1.05 0 1.775-.725Q8 19.55 8 18.5v-5q0-2.3 1.6-3.9T13.5 8h6v3h-6q-1.05 0-1.775.725Q11 12.45 11 13.5v5q0 1.85-1.125 3.325T7 23.8v.4q1.75.55 2.875 2T11 29.5v5q0 1.05.725 1.775Q12.45 37 13.5 37h6v3Z"></path></svg></span>`,
                    action,
                    'child'
                );
            }

            // Comment
            const iconComment = controlKey.querySelector('.brxc-toggle-comment');
            if(!iconComment){
                self.addIconToFields(
                    'div',
                    'brxc-toggle-comment',
                    false,
                    'Comment Selected Code',
                    'top-right',
                    'ADMINBRXC.commentCode(event,`[data-controlkey="_cssSuperPowerCSS"]`)',
                    true,
                    `<span class="bricks-svg-wrapper"><i class="fas fa-eye"></i></span>`,
                    action,
                    'child'
                );
            }

            //Bem selectors
            const iconBem = controlKey.querySelector('.brxc-toggle-bem');
            if(!iconBem){
                self.addIconToFields(
                    'div',
                    'brxc-toggle-bem',
                    false,
                    'Add Component Selectors',
                    'top-right',
                    'ADMINBRXC.addComponentSelectors(event,`[data-controlkey="_cssSuperPowerCSS"]`)',
                    true,
                    `<span class="bricks-svg-wrapper"><i class="fas fa-list"></i></span>`,
                    action,
                    'child'
                );
            }

            //Beautify code
            const iconBeautify = controlKey.querySelector('.brxc-toggle-beautify');
            if(!iconBeautify){
                self.addIconToFields(
                    'div',
                    'brxc-toggle-beautify',
                    false,
                    'Beautify CSS',
                    'top-right',
                    'ADMINBRXC.beautifyCSS(event,`[data-controlkey="_cssSuperPowerCSS"]`)',
                    true,
                    `<span class="bricks-svg-wrapper"><i class="fas fa-broom"></i></span>`,
                    action,
                    'child'
                );
            }

            //Beautify code
            const iconScopedVariables = controlKey.querySelector('.brxc-toggle-scoped-variables');
            if(!iconBeautify && Object.values(self.globalSettings.classFeatures).includes("scoped-variables")){
                self.addIconToFields(
                    'div',
                    'brxc-toggle-scoped-variables',
                    false,
                    'Export Scoped Variables',
                    'top-right',
                    'ADMINBRXC.exportScopedVariables(event,`[data-controlkey="_cssSuperPowerCSS"]`)',
                    true,
                    `<span class="bricks-svg-wrapper"><i class="fas fa-square-root-variable"></i></span>`,
                    action,
                    'child'
                );
            }

            // Full size
            const iconFullSize = controlKey.querySelector('.brxc-toggle-fullsize');
            if(!iconFullSize){
                let balloon = self.superPowerStates.fullScreen === false ? 'Hide Shortcuts sheatsheet' : 'Show Shortcuts sheatsheet';
                let icon = self.superPowerStates.fullScreen === false ? `<svg version="1.1" viewBox="0 0 16 16" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" class="bricks-svg"><g fill="currentColor" fill-rule="evenodd"><path d="M2,8l5.32907e-15,7.54979e-08c-4.16963e-08,-0.276142 0.223858,-0.5 0.5,-0.5h11l-2.18557e-08,8.88178e-16c0.276142,-1.20706e-08 0.5,0.223858 0.5,0.5c1.20706e-08,0.276142 -0.223858,0.5 -0.5,0.5h-11l-2.78181e-08,-3.55271e-15c-0.276142,-4.49893e-08 -0.5,-0.223858 -0.5,-0.5Zm6,-1.5l-2.18557e-08,-8.88178e-16c0.276142,1.20706e-08 0.5,-0.223858 0.5,-0.5v-4.5v0c0,-0.276142 -0.223858,-0.5 -0.5,-0.5c-0.276142,0 -0.5,0.223858 -0.5,0.5v4.5l5.32907e-15,7.54979e-08c4.16963e-08,0.276142 0.223858,0.5 0.5,0.5Z"></path><path d="M10.354,3.854l2.23014e-08,-2.2245e-08c0.195509,-0.195015 0.195909,-0.511597 0.000893739,-0.707106c-0.000297551,-0.000298304 -0.000595479,-0.000596232 -0.000893784,-0.000893784l-2,-2l4.41373e-09,4.4249e-09c-0.195015,-0.195509 -0.511597,-0.195909 -0.707106,-0.000893793c-0.000298304,0.000297551 -0.000596232,0.000595479 -0.000893784,0.000893784l-2,2l-2.1107e-09,2.1107e-09c-0.195509,0.195509 -0.195509,0.512491 4.22141e-09,0.708c0.195509,0.195509 0.512491,0.195509 0.708,-4.22141e-09l1.646,-1.647l1.646,1.647l-3.52833e-08,-3.53726e-08c0.195015,0.195509 0.511597,0.195909 0.707106,0.000893854c0.000298304,-0.000297551 0.000596233,-0.000595479 0.000893784,-0.000893784Zm-2.354,5.646h-2.18557e-08c0.276142,-1.20706e-08 0.5,0.223858 0.5,0.5v4.5v0c0,0.276142 -0.223858,0.5 -0.5,0.5c-0.276142,0 -0.5,-0.223858 -0.5,-0.5v-4.5l5.32907e-15,7.54979e-08c-4.16963e-08,-0.276142 0.223858,-0.5 0.5,-0.5Z"></path><path d="M10.354,12.146l2.23014e-08,2.2245e-08c0.195509,0.195015 0.195909,0.511597 0.000893739,0.707106c-0.000297551,0.000298304 -0.000595479,0.000596232 -0.000893784,0.000893784l-2,2l4.41373e-09,-4.4249e-09c-0.195015,0.195509 -0.511597,0.195909 -0.707106,0.000893793c-0.000298304,-0.000297551 -0.000596232,-0.000595479 -0.000893784,-0.000893784l-2,-2l-2.1107e-09,-2.1107e-09c-0.195509,-0.195509 -0.195509,-0.512491 4.22141e-09,-0.708c0.195509,-0.195509 0.512491,-0.195509 0.708,4.22141e-09l1.646,1.647l1.646,-1.647l-3.52833e-08,3.53726e-08c0.195015,-0.195509 0.511597,-0.195909 0.707106,-0.000893854c0.000298304,0.000297551 0.000596233,0.000595479 0.000893784,0.000893784Z"></path></g></svg>` : `<svg version="1.1" viewBox="0 0 16 16" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" class="bricks-svg"><g fill="currentColor" fill-rule="evenodd"><path d="M2,8l5.32907e-15,7.54979e-08c-4.16963e-08,-0.276142 0.223858,-0.5 0.5,-0.5h11l-2.18557e-08,8.88178e-16c0.276142,-1.20706e-08 0.5,0.223858 0.5,0.5c1.20706e-08,0.276142 -0.223858,0.5 -0.5,0.5h-11l-2.78181e-08,-3.55271e-15c-0.276142,-4.49893e-08 -0.5,-0.223858 -0.5,-0.5Zm6,-7h-2.18557e-08c0.276142,-1.20706e-08 0.5,0.223858 0.5,0.5v4.5v0c0,0.276142 -0.223858,0.5 -0.5,0.5c-0.276142,0 -0.5,-0.223858 -0.5,-0.5v-4.5l5.32907e-15,7.54979e-08c-4.16963e-08,-0.276142 0.223858,-0.5 0.5,-0.5Z"></path><path d="M10.354,3.646l2.23014e-08,2.2245e-08c0.195509,0.195015 0.195909,0.511597 0.000893739,0.707106c-0.000297551,0.000298304 -0.000595479,0.000596232 -0.000893784,0.000893784l-2,2l4.41373e-09,-4.4249e-09c-0.195015,0.195509 -0.511597,0.195909 -0.707106,0.000893793c-0.000298304,-0.000297551 -0.000596232,-0.000595479 -0.000893784,-0.000893784l-2,-2l-2.1107e-09,-2.1107e-09c-0.195509,-0.195509 -0.195509,-0.512491 4.22141e-09,-0.708c0.195509,-0.195509 0.512491,-0.195509 0.708,4.22141e-09l1.646,1.647l1.646,-1.647l-3.52833e-08,3.53726e-08c0.195015,-0.195509 0.511597,-0.195909 0.707106,-0.000893854c0.000298304,0.000297551 0.000596233,0.000595479 0.000893784,0.000893784Zm-2.354,11.354h-2.18557e-08c0.276142,1.20706e-08 0.5,-0.223858 0.5,-0.5v-4.5v0c0,-0.276142 -0.223858,-0.5 -0.5,-0.5c-0.276142,0 -0.5,0.223858 -0.5,0.5v4.5l5.32907e-15,7.54979e-08c4.16963e-08,0.276142 0.223858,0.5 0.5,0.5Z"></path><path d="M10.354,12.354l2.23014e-08,-2.2245e-08c0.195509,-0.195015 0.195909,-0.511597 0.000893739,-0.707106c-0.000297551,-0.000298304 -0.000595479,-0.000596232 -0.000893784,-0.000893784l-2,-2l4.41373e-09,4.4249e-09c-0.195015,-0.195509 -0.511597,-0.195909 -0.707106,-0.000893793c-0.000298304,0.000297551 -0.000596232,0.000595479 -0.000893784,0.000893784l-2,2l-2.1107e-09,2.1107e-09c-0.195509,0.195509 -0.195509,0.512491 4.22141e-09,0.708c0.195509,0.195509 0.512491,0.195509 0.708,-4.22141e-09l1.646,-1.647l1.646,1.647l-3.52833e-08,-3.53726e-08c0.195015,0.195509 0.511597,0.195909 0.707106,0.000893854c0.000298304,-0.000297551 0.000596233,-0.000595479 0.000893784,-0.000893784Z"></path></g></svg>`;
                self.addIconToFields(
                    'div',
                    'brxc-toggle-fullsize',
                    false,
                    balloon,
                    'top-right',
                    'ADMINBRXC.addFullSizeCSS(this)',
                    true,
                    icon,
                    action,
                    'child'
                );
            }
            // Full screen
            const iconFullScreen = controlKey.querySelector('.brxc-toggle-fullscreen');
            if(!iconFullScreen){
                self.addIconToFields(
                    'div',
                    'brxc-toggle-fullscreen',
                    false,
                    'Fullscreen',
                    'top-right',
                    'ADMINBRXC.addFullScreenCSS(event,`[data-controlkey="_cssSuperPowerCSS"]`)',
                    true,
                    `<span class="bricks-svg-wrapper"><i class="fas fa-display"></i></span>`,
                    action,
                    'child'
                );
            }
            
            //Collapse
            const iconCollapse = controlKey.querySelector('.brxc-toggle-collapse');
            if(!iconCollapse){
                let balloon = self.vueState.isPanelExpanded ? 'Collapse' : 'Expand';
                let icon = self.vueState.isPanelExpanded ? `<svg version="1.1" viewBox="0 0 512 512" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" class="bricks-svg"><path d="M217.9,256l127.1,-127c9.4,-9.4 9.4,-24.6 0,-33.9c-9.4,-9.4 -24.6,-9.3 -34,0l-144,143.9c-9.1,9.1 -9.3,23.7 -0.7,33.1l144.6,144.9c4.7,4.7 10.9,7 17,7c6.1,0 12.3,-2.3 17,-7c9.4,-9.4 9.4,-24.6 0,-33.9l-127,-127.1Z" fill="currentColor"></path></svg>` : `<svg version="1.1" viewBox="0 0 512 512" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" class="bricks-svg"><path d="M294.1,256l-127.1,-127c-9.4,-9.4 -9.4,-24.6 0,-33.9c9.4,-9.3 24.6,-9.3 34,0l144,143.9c9.1,9.1 9.3,23.7 0.7,33.1l-144.6,144.9c-4.7,4.7 -10.9,7 -17,7c-6.1,0 -12.3,-2.3 -17,-7c-9.4,-9.4 -9.4,-24.6 0,-33.9l127,-127.1Z" fill="currentColor"></path></svg>`; 
                self.addIconToFields(
                    'div',
                    'brxc-toggle-collapse',
                    false,
                    balloon,
                    'top-right',
                    'ADMINBRXC.addResizeCSS(this)',
                    true,
                    icon,
                    action,
                    'child'
                );
            }
        }
    },
    addFullSizeCSSState: function(){
        const self = this;
        if(!self.helpers.isElementActive() || self.vueState.activePanelTab !== "style" || self.vueState.activePanelGroup !== "_css" ) return;
        
        const description = document.querySelector('body[data-superpower-css="true"] #bricks-panel-element [data-controlkey="_cssSuperPowerCSS"] .description');
        if(!description) return;
        self.superPowerStates.fullScreen === true ? description.style.display = "none" : description.style.display = "block";
    },
    addFullSizeCSS: function(target){
        const self = this;
        self.superPowerStates.fullScreen === true ? self.superPowerStates.fullScreen = false : self.superPowerStates.fullScreen = true;
        let balloon = self.superPowerStates.fullScreen === false ? 'Hide Shortcuts sheatsheet' : 'Show Shortcuts sheatsheet';
        let icon = self.superPowerStates.fullScreen === false ? `<svg version="1.1" viewBox="0 0 16 16" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" class="bricks-svg"><g fill="currentColor" fill-rule="evenodd"><path d="M2,8l5.32907e-15,7.54979e-08c-4.16963e-08,-0.276142 0.223858,-0.5 0.5,-0.5h11l-2.18557e-08,8.88178e-16c0.276142,-1.20706e-08 0.5,0.223858 0.5,0.5c1.20706e-08,0.276142 -0.223858,0.5 -0.5,0.5h-11l-2.78181e-08,-3.55271e-15c-0.276142,-4.49893e-08 -0.5,-0.223858 -0.5,-0.5Zm6,-1.5l-2.18557e-08,-8.88178e-16c0.276142,1.20706e-08 0.5,-0.223858 0.5,-0.5v-4.5v0c0,-0.276142 -0.223858,-0.5 -0.5,-0.5c-0.276142,0 -0.5,0.223858 -0.5,0.5v4.5l5.32907e-15,7.54979e-08c4.16963e-08,0.276142 0.223858,0.5 0.5,0.5Z"></path><path d="M10.354,3.854l2.23014e-08,-2.2245e-08c0.195509,-0.195015 0.195909,-0.511597 0.000893739,-0.707106c-0.000297551,-0.000298304 -0.000595479,-0.000596232 -0.000893784,-0.000893784l-2,-2l4.41373e-09,4.4249e-09c-0.195015,-0.195509 -0.511597,-0.195909 -0.707106,-0.000893793c-0.000298304,0.000297551 -0.000596232,0.000595479 -0.000893784,0.000893784l-2,2l-2.1107e-09,2.1107e-09c-0.195509,0.195509 -0.195509,0.512491 4.22141e-09,0.708c0.195509,0.195509 0.512491,0.195509 0.708,-4.22141e-09l1.646,-1.647l1.646,1.647l-3.52833e-08,-3.53726e-08c0.195015,0.195509 0.511597,0.195909 0.707106,0.000893854c0.000298304,-0.000297551 0.000596233,-0.000595479 0.000893784,-0.000893784Zm-2.354,5.646h-2.18557e-08c0.276142,-1.20706e-08 0.5,0.223858 0.5,0.5v4.5v0c0,0.276142 -0.223858,0.5 -0.5,0.5c-0.276142,0 -0.5,-0.223858 -0.5,-0.5v-4.5l5.32907e-15,7.54979e-08c-4.16963e-08,-0.276142 0.223858,-0.5 0.5,-0.5Z"></path><path d="M10.354,12.146l2.23014e-08,2.2245e-08c0.195509,0.195015 0.195909,0.511597 0.000893739,0.707106c-0.000297551,0.000298304 -0.000595479,0.000596232 -0.000893784,0.000893784l-2,2l4.41373e-09,-4.4249e-09c-0.195015,0.195509 -0.511597,0.195909 -0.707106,0.000893793c-0.000298304,-0.000297551 -0.000596232,-0.000595479 -0.000893784,-0.000893784l-2,-2l-2.1107e-09,-2.1107e-09c-0.195509,-0.195509 -0.195509,-0.512491 4.22141e-09,-0.708c0.195509,-0.195509 0.512491,-0.195509 0.708,4.22141e-09l1.646,1.647l1.646,-1.647l-3.52833e-08,3.53726e-08c0.195015,-0.195509 0.511597,-0.195909 0.707106,-0.000893854c0.000298304,0.000297551 0.000596233,0.000595479 0.000893784,0.000893784Z"></path></g></svg>` : `<svg version="1.1" viewBox="0 0 16 16" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" class="bricks-svg"><g fill="currentColor" fill-rule="evenodd"><path d="M2,8l5.32907e-15,7.54979e-08c-4.16963e-08,-0.276142 0.223858,-0.5 0.5,-0.5h11l-2.18557e-08,8.88178e-16c0.276142,-1.20706e-08 0.5,0.223858 0.5,0.5c1.20706e-08,0.276142 -0.223858,0.5 -0.5,0.5h-11l-2.78181e-08,-3.55271e-15c-0.276142,-4.49893e-08 -0.5,-0.223858 -0.5,-0.5Zm6,-7h-2.18557e-08c0.276142,-1.20706e-08 0.5,0.223858 0.5,0.5v4.5v0c0,0.276142 -0.223858,0.5 -0.5,0.5c-0.276142,0 -0.5,-0.223858 -0.5,-0.5v-4.5l5.32907e-15,7.54979e-08c-4.16963e-08,-0.276142 0.223858,-0.5 0.5,-0.5Z"></path><path d="M10.354,3.646l2.23014e-08,2.2245e-08c0.195509,0.195015 0.195909,0.511597 0.000893739,0.707106c-0.000297551,0.000298304 -0.000595479,0.000596232 -0.000893784,0.000893784l-2,2l4.41373e-09,-4.4249e-09c-0.195015,0.195509 -0.511597,0.195909 -0.707106,0.000893793c-0.000298304,-0.000297551 -0.000596232,-0.000595479 -0.000893784,-0.000893784l-2,-2l-2.1107e-09,-2.1107e-09c-0.195509,-0.195509 -0.195509,-0.512491 4.22141e-09,-0.708c0.195509,-0.195509 0.512491,-0.195509 0.708,4.22141e-09l1.646,1.647l1.646,-1.647l-3.52833e-08,3.53726e-08c0.195015,-0.195509 0.511597,-0.195909 0.707106,-0.000893854c0.000298304,0.000297551 0.000596233,0.000595479 0.000893784,0.000893784Zm-2.354,11.354h-2.18557e-08c0.276142,1.20706e-08 0.5,-0.223858 0.5,-0.5v-4.5v0c0,-0.276142 -0.223858,-0.5 -0.5,-0.5c-0.276142,0 -0.5,0.223858 -0.5,0.5v4.5l5.32907e-15,7.54979e-08c4.16963e-08,0.276142 0.223858,0.5 0.5,0.5Z"></path><path d="M10.354,12.354l2.23014e-08,-2.2245e-08c0.195509,-0.195015 0.195909,-0.511597 0.000893739,-0.707106c-0.000297551,-0.000298304 -0.000595479,-0.000596232 -0.000893784,-0.000893784l-2,-2l4.41373e-09,4.4249e-09c-0.195015,-0.195509 -0.511597,-0.195909 -0.707106,-0.000893793c-0.000298304,0.000297551 -0.000596232,0.000595479 -0.000893784,0.000893784l-2,2l-2.1107e-09,2.1107e-09c-0.195509,0.195509 -0.195509,0.512491 4.22141e-09,0.708c0.195509,0.195509 0.512491,0.195509 0.708,-4.22141e-09l1.646,-1.647l1.646,1.647l-3.52833e-08,-3.53726e-08c0.195015,0.195509 0.511597,0.195909 0.707106,0.000893854c0.000298304,-0.000297551 0.000596233,-0.000595479 0.000893784,-0.000893784Z"></path></g></svg>`;
        target.setAttribute('data-balloon', balloon);
        target.innerHTML = icon;
        const description = target.closest('.control-inner').nextElementSibling;
        description && self.superPowerStates.fullScreen === true ? description.style.display = "none" : description.style.display = "block";
    },
    addResizeCSS: function(target){
        const self = this;
        self.vueState.isPanelExpanded === true ? self.vueState.isPanelExpanded = false : self.vueState.isPanelExpanded = true;
        let balloon = self.vueState.isPanelExpanded ? 'Collapse' : 'Expand';
        let icon = self.vueState.isPanelExpanded ? `<svg version="1.1" viewBox="0 0 512 512" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" class="bricks-svg"><path d="M217.9,256l127.1,-127c9.4,-9.4 9.4,-24.6 0,-33.9c-9.4,-9.4 -24.6,-9.3 -34,0l-144,143.9c-9.1,9.1 -9.3,23.7 -0.7,33.1l144.6,144.9c4.7,4.7 10.9,7 17,7c6.1,0 12.3,-2.3 17,-7c9.4,-9.4 9.4,-24.6 0,-33.9l-127,-127.1Z" fill="currentColor"></path></svg>` : `<svg version="1.1" viewBox="0 0 512 512" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" class="bricks-svg"><path d="M294.1,256l-127.1,-127c-9.4,-9.4 -9.4,-24.6 0,-33.9c9.4,-9.3 24.6,-9.3 34,0l144,143.9c9.1,9.1 9.3,23.7 0.7,33.1l-144.6,144.9c-4.7,4.7 -10.9,7 -17,7c-6.1,0 -12.3,-2.3 -17,-7c-9.4,-9.4 -9.4,-24.6 0,-33.9l127,-127.1Z" fill="currentColor"></path></svg>`; 
        target.setAttribute('data-balloon', balloon);
        target.innerHTML = icon;
    },
    addFullScreenCSS: function(event, closest){
        const self = this;
        const target = event.target;
        const controlKey = target.closest(closest);
        if(!controlKey) return;
        controlKey.classList.toggle('full-screen');

    },
    addListenersToSuperPowerCSS: function(MyCM) {
        const self = this;
        const target = self.helpers.createTarget('_cssCustom');
        const targetSass = self.helpers.createTarget('_cssCustomSass');
    
        // Selector
        let selector = '';
        let isActiveClass = false;
        let activeEl = false;
        let activeEl2 = false;
        
        const contentType = self.helpers.getTemplateType();
        const contentArray = Array.from(self.vueState[contentType])
        const globalClassesArray = Array.from(self.vueState.globalClasses);
        
        console.log(self.helpers.isClassActive())
        if (!self.helpers.isClassActive()) {
            selector = self.vueState.activeElement.settings.hasOwnProperty('_cssId') ? `#${self.vueState.activeElement.settings._cssId}` : `#brxe-${self.vueState.activeElement.id}`;
            activeEl = contentArray.find(e => e && e.hasOwnProperty('id') && e.id === self.vueState.activeElement.id);
        } else {
            isActiveClass = true;
            selector = `.${self.vueState.activeClass.name}`;
            activeEl = globalClassesArray.find(e => e && e.hasOwnProperty('id') && e.id === self.vueState.activeClass.id);
            activeEl2 = self.vueState.activeClass;
        }
    
        // Debounce the keyup event handling
        let keyupDebounce;
    
        MyCM.on("keydown", function (cm, event) {
            
            if (!cm.state.completionActive &&
                ((event.key >= '0' && event.key <= '9') ||    // Digits 0-9
                    (event.key >= 'a' && event.key <= 'z') ||    // Letters a-z
                    event.key === '(' || event.key === '!' ||    // Opening parenthesis (
                    event.key === '-') &&                        // Dash
                !event.metaKey && !event.altKey && event.key !== '{' && event.key !== '}' &&
                !event.ctrlKey) {
                CodeMirror.commands.autocomplete(cm, null, { completeSingle: false });
            }

            if(event.metaKey && event.shiftKey && event.key === "7" ){
                cm.toggleComment();
            }

            if (event.key === 'Tab') {
                self.helpers.replaceRWithRoot(MyCM, event)
                
            }
        })
    
        MyCM.on("keyup", function(cm) {
            clearTimeout(keyupDebounce);
    
            keyupDebounce = setTimeout(() => {
                const newValue = self.vueGlobalProp.$_replaceCustomCssRoot('%root%', selector, cm.getValue());
    
                if (newValue === "") {
                    setTimeout(() => delete activeEl.settings[target], 10);
                    if(activeEl2) setTimeout(() => delete activeEl2.settings[target], 10);
                    if(self.globalSettings.superPowerCSSEnableSass) setTimeout(() => delete activeEl.settings[targetSass], 10);
                } else {
                    if(self.globalSettings.superPowerCSSEnableSass){
                        const dataOptions = { indent_size: 2, space_in_empty_paren: false }
                        Sass.compile( newValue, function(result) {
                        if (result.status === 0) {
                            const vanillaCSS = css_beautify(result.text, dataOptions);
                            activeEl ? activeEl.settings[target] = vanillaCSS : '';
                            activeEl2 ? activeEl2.settings[target] = vanillaCSS : '';
                            activeEl ? activeEl.settings[targetSass] = newValue : '';
                        }
                    });
                    } else {
                        activeEl ? activeEl.settings[target] = newValue : '';
                        activeEl2 ? activeEl2.settings[target] = newValue : '';
                    }
                    if (isActiveClass) self.helpers.saveChanges('globalClasses');
                }
            }, 100);
        });
    },
    updateSuperPowerCSS: function(MyCM){
        const self = this;
        const activeEl = self.helpers.isClassActive() ? self.vueState.activeClass : self.vueState.activeElement;
        
        if(!activeEl || !activeEl.hasOwnProperty('settings')) return;
        let selector = '';
        if(self.helpers.isClassActive()){
            selector = `.${self.vueState.activeClass.name}`;
        } else {
            selector = self.vueState.activeElement.settings.hasOwnProperty('_cssId') ? `#${self.vueState.activeElement.settings._cssId}` : `#brxe-${self.vueState.activeElement.id}`;
        }
        
        let target = self.globalSettings.superPowerCSSEnableSass && activeEl.settings.hasOwnProperty('_cssCustomSass') ? self.helpers.createTarget('_cssCustomSass') : self.helpers.createTarget('_cssCustom');
        const settings = (activeEl.settings.hasOwnProperty(target)) ? activeEl.settings[target] : '';
        MyCM.setValue(self.vueGlobalProp.$_replaceCustomCssRoot(selector, '%root%', settings));
    },
    switchCodePanels: function() {
        const self = this;
        const labels = document.querySelectorAll('#brxcCSSOverlay.brxc-overlay__wrapper .brxc-overlay__panel-switcher-wrapper > [data-code]');
        const colRight = document.querySelector('#brxcCSSOverlay.brxc-overlay__wrapper #brxcCSSColRight');
        const panels = colRight.querySelectorAll('.brxc-overlay-css__wrapper');
        if(panels[0]) panels[0].classList.add('active');
        labels.forEach(label => {
            label.onclick = () => {
                labels.forEach(label => {label.classList.remove('active')})
                panels.forEach(panel => {panel.classList.remove('active')})
                label.classList.add('active');
                const attr = label.dataset.code;
                const panel = colRight.querySelector('[data-code="'+ attr +'"]');
                panel.classList.add('active');
                const editor= panel.querySelector('.CodeMirror');
                if (editor) editor.CodeMirror.refresh();
                self.movePanel(document.querySelector('#brxcCSSOverlay .brxc-overlay__pannels-wrapper'), label.dataset.transform);

            };
        })
    },
    lastElementId: '',
    forceClassStlyes: function (){
        const self = this;
        if(!self.helpers.isElementActive()) return;

        const panel = document.querySelector('#bricks-panel-element');
        if(!panel) return;

        const contentControls = panel.querySelectorAll('.bricks-panel-controls ul.controls li');
        if(contentControls.length > 0){
            const name = self.vueState.activeElement.name;
            contentControls.forEach(el => {
                const data = el.dataset.controlkey;
                if(bricksData.elements[name].controls[data] && bricksData.elements[name].controls[data].hasOwnProperty('css')) el.style.display = "block";
            })
        }
        const tabs = panel.querySelector('ul#bricks-panel-tabs');
        if (!tabs) return;

        if (self.helpers.isClassActive() || (self.globalSettings.classFeatures.lockIdWithClasses === "1" && !self.helpers.hasGlobalClass(self.vueState.activeElement.id) ) ) {
            self.vueState.brxc.showLock = false;
            self.lastElementId = '';
        } else if (self.lastElementId !== self.vueState.activeElement.id){
            self.vueState.brxc.showLock = true
            self.lastElementId = self.vueState.activeElement.id;
        }
        const styleTab = tabs.querySelectorAll('li')[1];
        const icon = panel.querySelector('.disabled-style-icon');
        (icon) ? icon.remove() : '';

        panel.setAttribute("data-has-class", "true")
        styleTab.classList.remove('brxc-style-tab-disabled')

        //if state brxc.showLock is true
        if(self.vueState.brxc.showLock === true) {
            if(contentControls.length > 0){
                const name = self.vueState.activeElement.name;
                contentControls.forEach(el => {
                    const data = el.dataset.controlkey;
                    if(bricksData.elements[name].controls[data] && bricksData.elements[name].controls[data].hasOwnProperty('css')) el.style.display = "none";
                })
            }
            panel.removeAttribute("data-has-class");
            self.vueState.activePanelTab = "content";
            styleTab.classList.add('brxc-style-tab-disabled')
            self.addIconToFields('div','disabled-style-icon', false, 'Click to unlock styling on ID level', 'top-right', false, false,  '<span class="bricks-svg-wrapper"><i class="fas fa-lock"></span>', tabs, 'child');
            const icon = panel.querySelector('.disabled-style-icon')
            icon.addEventListener('click', () =>{
                self.vueState.brxc.showLock = false;
                icon.remove();
            })

        }

    },
    openClassContextualMenu: function(){
        const self = this;
        const menu = document.querySelector('#brxc-class-context-menu');
        const menuCanvas = document.querySelector('#brxc-class-context-menu-canvas');
        const icon = document.querySelector('.class-contextual-menu-icon');
        const shortcutPrefix = self.vueState.isMac ? 'CTRL + CMD' : 'CTRL + SHIFT';
        let content = '';
        function isRootComponent(){
            if(self.vueState.activeElement.settings.hasOwnProperty('classConverterComponent') && self.vueState.activeElement.settings.classConverterComponent === true){
                return true;
            } 
            return false;
        }
        let globalContent = `<li class="sep"></li>
                                <li onclick="ADMINBRXC.openPlainClassesModal(event,document.querySelectorAll(&quot;#bricks-panel-element-classes ul.element-classes li span.name&quot;), &quot;#brxcPlainClassesOverlay&quot;, document.querySelector(&quot;#brxcPlainClassesOverlay .CodeMirror&quot;).CodeMirror )">
                                    <span class="label">Plain Classes</span>
                                    <span class="shortcut">${shortcutPrefix} + ${self.globalSettings.keyboardShortcuts.plainClasses}</span>
                                </li>
                                <li onclick="ADMINBRXC.openFindReplaceModal(event,false, &quot;#brxcFindReplaceModal&quot;)">
                                    <span class="label">Find &amp; Replace Styles</span>
                                    <span class="shortcut">${shortcutPrefix} + ${self.globalSettings.keyboardShortcuts.findAndReplace}</span>
                                </li>
                                <li onclick="ADMINBRXC.setStyleOverview(&quot;no-pseudo&quot;);ADMINBRXC.setStyleOverviewCSS();ADMINBRXC.openModal(false, &quot;#brxcStyleOverviewOverlay&quot;, document.querySelector(&quot;#brxcStyleOverviewOverlay input[type=search]&quot;));">Style Overview</li>`
        globalContent += `<li onclick="ADMINBRXC.setClassConverter();ADMINBRXC.openModal(false, &quot;#brxcClassConverterOverlay&quot;)" ;'=""><span class="label">Class Converter</span><div class="buttons"><span class="action" data-balloon="${isRootComponent() ? 'Disable Root Component' : 'Enable Root Component'}" data-balloon-pos="top" onclick="event.stopPropagation();ADMINBRXC.rootClassComponentToggle()"><i class="fas fa-toggle-${isRootComponent() ? 'on' : 'off'}"></i></span></div></li>`;
        if(!self.helpers.isClassActive()){
            function isElementHidden(){
                const activeEl = self.vueState.activeElement;
                if(typeof activeEl === "undefined" || !activeEl.hasOwnProperty('settings') || !activeEl.settings.hasOwnProperty('_display') || activeEl.settings._display !== "none") {
                    return false;
                }
                return true;
            }
            content += `<ul>`
            content += isElementHidden() ? `<li onclick="ADMINBRXC.showElement()">Show Element</li>` : `<li onclick="ADMINBRXC.hideElement()">Hide Element</li>`;
            content += `<li class="sep"></li>
                    <li onclick="ADMINBRXC.exportIDStylestoClass()">Export ID Styles to Class</li>
                    <li onclick="ADMINBRXC.openExtendClassModal(event,&quot;#brxcExtendModal&quot;)">Extend Classes &amp; Styles</li>
                    <li class="sep"></li>
                    <li onclick="ADMINBRXC.copyAllClasses()">Copy All Classes</li>
                    <li onclick="ADMINBRXC.pasteAllClasses()">Paste All Classes</li>
                    <li onclick="ADMINBRXC.resetAllClasses()"class="delete">Reset All Classes</li>
                    <li class="sep"></li>
                    <li onclick="ADMINBRXC.openClassManager(&quot;component&quot;);">Component Class Manager</li>`
            content += globalContent;
            content += `</ul>`;
        } else {
            content += `
                <ul>
                    <li onclick="ADMINBRXC.importIDStylestoClass()">Import ID Styles to Class</li>
                    <li onclick="ADMINBRXC.openExtendClassModal(event,&quot;#brxcExtendModal&quot;)">Extend Classes &amp; Styles</li>
                    <li class="sep"></li>
                    <li onclick="ADMINBRXC.cloneClass()">Clone Class</li>
                    <li onclick="ADMINBRXC.copytoClipboardSimple('${self.vueState.activeClass.name}','${self.vueState.activeClass.name} successfully copied to clipboard')">Copy ${self.vueState.activeClass.name} to Clipboard</li>
                    <li onclick="ADMINBRXC.removeCurrentClass('${self.vueState.activeClass.id}', true)">Remove Class from Element</li>
                    <li onclick="ADMINBRXC.deleteCurrentClass('${self.vueState.activeClass.id}')"class="delete">Delete Class</li>
                    <li class="sep"></li>
                    <li onclick="ADMINBRXC.copyAllClasses()">Copy All Classes</li>
                    <li onclick="ADMINBRXC.pasteAllClasses()">Paste All Classes</li>
                    <li onclick="ADMINBRXC.resetAllClasses()"class="delete">Reset All Classes</li>
                    <li class="sep"></li>
                    <li onclick="ADMINBRXC.openClassInManager('${self.vueState.activeClass.id}')">
                        <span class="label">Open Class in Global Class Manager</span>
                        <span class="shortcut">${shortcutPrefix} + ${self.globalSettings.keyboardShortcuts.classManager}</span>
                    </li>
                    <li onclick="ADMINBRXC.openClassManager(&quot;component&quot;);">Component Class Manager</li>`
            content += globalContent;
            content += `</ul>`;

        }
        
        menuCanvas.innerHTML = content;
        const rect = icon.getBoundingClientRect();
        menu.style.top = `${rect.top}px`;
        menu.style.left = `${rect.left}px`;
        menu.classList.add('show');

        // Listeners
        const x = document.querySelector('#bricks-builder-iframe').contentWindow;
        function openMenu() {
            window.addEventListener('click', windowClickListener);
            x.document.addEventListener('click', windowClickListener);
        }
        
        function closeMenu() {
            window.removeEventListener('click', windowClickListener);
            x.document.removeEventListener('click', windowClickListener);
            menu.classList.remove('show');

        }
        
        function windowClickListener(event) {
            closeMenu();
        }
        openMenu();
    },
    copiedAllClasses: null,
    copyAllClasses: function(){
        const self = this;
        if(!Array.isArray(self.vueState.activeElement.settings._cssGlobalClasses) || self.vueState.activeElement.settings._cssGlobalClasses.length < 1) return self.vueGlobalProp.$_showMessage('Abort - No Global Class found!');
        self.copiedAllClasses = self.vueState.activeElement.settings._cssGlobalClasses;
        self.vueGlobalProp.$_showMessage('Global Classes correctly copied!');
        self.vueState.rerenderControls = Date.now();
    },
    pasteAllClasses: function(){
        const self = this;
        if(!Array.isArray(self.copiedAllClasses)){
            return self.vueGlobalProp.$_showMessage('Abort - No Global Classes have been copied!');
        } 
        if(!Array.isArray(self.vueState.activeElement.settings._cssGlobalClasses)) self.vueState.activeElement.settings._cssGlobalClasses = [];
        self.vueState.activeElement.settings._cssGlobalClasses = [...new Set(self.vueState.activeElement.settings._cssGlobalClasses.concat(self.copiedAllClasses))];
        self.vueGlobalProp.$_showMessage('Global Classes correctly pasted!');
        self.vueState.rerenderControls = Date.now();
    },
    resetAllClasses: function(){
        const self = this;
        if(!Array.isArray(self.vueState.activeElement.settings._cssGlobalClasses || self.vueState.activeElement.settings._cssGlobalClasses < 1 )) return self.vueGlobalProp.$_showMessage('Abort - No Global Classes found!');
        delete self.vueState.activeElement.settings._cssGlobalClasses;
        self.vueGlobalProp.$_showMessage('Global Classes correctly removed!');
        self.vueState.rerenderControls = Date.now();
    },
    removeCurrentClass: function(id, message){
        const self = this;
        const index = self.vueState.activeElement.settings._cssGlobalClasses.indexOf(id);
        self.vueState.activeElement.settings._cssGlobalClasses.splice(index, 1);
        message === true ? self.vueGlobalProp.$_showMessage('Global Class correctly removed!') : '';
        self.vueState.rerenderControls = Date.now();
    },
    deleteCurrentClass: function(id){
        const self = this;

        // Remove Class from all elements
        const templateType = self.helpers.getTemplateType();
        const filteredEls = Array.from(self.vueState[templateType]).filter(el => el && el.settings.hasOwnProperty('_cssGlobalClasses') && Array.isArray(el.settings._cssGlobalClasses) && el.settings._cssGlobalClasses.includes(id));
        if(filteredEls && filteredEls.length > 0){
            filteredEls.forEach(element => {
                const index = element.settings._cssGlobalClasses.indexOf(id);
                element.settings._cssGlobalClasses.splice(index, 1);
            })
        }

        // Remove Global Class
        const activeClass = Array.from(self.vueState.globalClasses).find(el => el.id === id);
        if(!activeClass) return self.vueGlobalProp.$_showMessage('Abort - Global Class not found!');
        const index = self.vueState.globalClasses.indexOf(activeClass);
        self.vueState.globalClasses.splice(index,1);
        if(self.states.classManagerActiveClass === id) self.states.classManagerActiveClass = '';
        self.vueGlobalProp.$_showMessage('Global Class correctly deleted!');
        self.vueState.rerenderControls = Date.now();
    },
    cloneClass: function(){
        const self = this;
        const els = document.querySelector('#bricks-panel-element-classes')
        if (!els) return;

        const wrapper = els.querySelector('.brxc-clone-class-wrapper')
        if(wrapper) return wrapper.remove();

        const activeClass = els.querySelector('.active-class');

        const inputHTML = `<div class="brxc-clone-class-wrapper"><input type="text" id="brxc-clone-class-input" size="999" autocomplete="off" spellcheck="false" placeholder="Type your class name here" value="${self.vueState.activeClass.name}-new"><span class="bricks-svg-wrapper create" data-balloon="Clone class (SHIFT + ENTER)" data-balloon-pos="left"><!--?xml version="1.0" encoding="UTF-8"?--><svg version="1.1" viewBox="0 0 512 512" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" class="bricks-svg"><path d="M362.7,64h-256c-23.7,0 -42.7,19.2 -42.7,42.7v298.7c0,23.5 19,42.7 42.7,42.7h298.7c23.5,0 42.7,-19.2 42.7,-42.7v-256l-85.4,-85.4Zm-106.7,341.3c-35.4,0 -64,-28.6 -64,-64c0,-35.4 28.6,-64 64,-64c35.4,0 64,28.6 64,64c0,35.4 -28.6,64 -64,64Zm64,-213.3h-213.3v-85.3h213.3v85.3Z" fill="currentColor"></path></svg></span><span class="bricks-svg-wrapper cancel" data-balloon="Cancel" data-balloon-pos="left"><i class="fas fa-xmark"></i></span></span><div>`
        activeClass.insertAdjacentHTML('afterend', inputHTML);

        const newWrapper = els.querySelector('.brxc-clone-class-wrapper')
        const newInput = newWrapper.querySelector('#brxc-clone-class-input');
        if(!newInput) return;
        newInput.focus();
        newInput.setSelectionRange(newInput.value.length, newInput.value.length)

        self.autocomplete(newInput, self.globalClasses(), false);
        const saveBtn = document.querySelector('.brxc-clone-class-wrapper .bricks-svg-wrapper.create')
        const cancelBtn = document.querySelector('.brxc-clone-class-wrapper .bricks-svg-wrapper.cancel')

        function cloneClass(){
            // Create CSS Settings
            const newInputValue = self.helpers.formatForClasses(newInput.value);
            const oldSettings = self.vueState.activeClass.settings;
            const oldCat = (self.vueState.activeClass.hasOwnProperty('category')) ? self.vueState.activeClass.category : false;
            const newSettings = JSON.parse(JSON.stringify(oldSettings).replaceAll(self.vueState.activeClass.name,newInputValue));
            let isUnique = true;
            let idClass;

            const addClass = (id, message, newWrapper) =>{
                // Add class to the element
                if (typeof self.vueState.activeElement.settings !== "undefined" && self.vueState.activeElement.settings.hasOwnProperty('_cssGlobalClasses')) {
                    if (!self.vueState.activeElement.settings._cssGlobalClasses.includes(id)) self.vueState.activeElement.settings._cssGlobalClasses.push(id)
                } else {
                    self.vueState.activeElement.settings._cssGlobalClasses = [];
                    self.vueState.activeElement.settings._cssGlobalClasses.push(id);
                }


                newWrapper.remove();
                self.vueGlobalProp.$_showMessage(message);
            }

            // Check if class exists
            self.vueState.globalClasses.forEach(obj => {
                if (obj.name === newInputValue){
                    isUnique = false;
                    idClass = obj.id;
                } 
            })


            if(isUnique === false) {
                addClass(idClass, 'Aborted: the class already exists!', newWrapper)
                return;
            }

            // Generate unique ID
            idClass = self.vueGlobalProp.$_generateId()

            // Create the class object
            const newGlobalClass = {
                id: idClass,
                name: newInputValue,
                settings: newSettings,
            };
            if(oldCat) newGlobalClass.category = oldCat;

            self.vueState.globalClasses.push(newGlobalClass);
            addClass(idClass, 'Class Successfully Created!', newWrapper)
        }

        saveBtn.addEventListener("click", function() {
            if(newInput.value === ''){
                return self.vueGlobalProp.$_showMessage('Abort - No Class Name Given');
            }
            cloneClass()
        });

        cancelBtn.addEventListener("click", function() {
            newWrapper.remove();
        });

        newInput.addEventListener('keyup', function(event) {
            if (event.shiftKey && event.keyCode === 13) cloneClass();
        });
    },
    exportIDStylestoClass: function(type){
        const self = this;
        const els = document.querySelector('#bricks-panel-element-classes')
        if (!els) return;

        const wrapper = els.querySelector('.brxc-copy-id-to-class-wrapper')
        if(wrapper) return wrapper.remove();

        const activeClass = els.querySelector('.active-class');

        let inputHTML = `<div class="brxc-copy-id-to-class-wrapper"><input type="text" id="brxc-copy-id-to-class-input" size="999" autocomplete="off" spellcheck="false" placeholder="Type your class name here"><span class="bricks-svg-wrapper create" data-balloon="Create/Update (SHIFT + ENTER)" data-balloon-pos="left"><!--?xml version="1.0" encoding="UTF-8"?--><svg version="1.1" viewBox="0 0 512 512" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" class="bricks-svg"><path d="M362.7,64h-256c-23.7,0 -42.7,19.2 -42.7,42.7v298.7c0,23.5 19,42.7 42.7,42.7h298.7c23.5,0 42.7,-19.2 42.7,-42.7v-256l-85.4,-85.4Zm-106.7,341.3c-35.4,0 -64,-28.6 -64,-64c0,-35.4 28.6,-64 64,-64c35.4,0 64,28.6 64,64c0,35.4 -28.6,64 -64,64Zm64,-213.3h-213.3v-85.3h213.3v85.3Z" fill="currentColor"></path></svg></span><span class="bricks-svg-wrapper cancel" data-balloon="Cancel" data-balloon-pos="left"><i class="fas fa-xmark"></i></span></span>`;
        if(typeof self.vueState.globalClassesCategories !== "undefined") inputHTML +=`<input type="text" id="brxc-copy-id-to-class-input-cat" size="999" autocomplete="off" spellcheck="false" placeholder="Type the class category here (optional)">`;
        inputHTML += `</div>`;
        activeClass.insertAdjacentHTML('afterend', inputHTML);

        const newWrapper = els.querySelector('.brxc-copy-id-to-class-wrapper')
        const newInput = newWrapper.querySelector('#brxc-copy-id-to-class-input');
        const newCategory = newWrapper.querySelector('#brxc-copy-id-to-class-input-cat');
        if(!newInput) return;
        newInput.focus();

        self.autocomplete(newInput, Array.from(self.vueState.globalClasses).map(el => el && el.name), false);
        if(newCategory) self.autocomplete(newCategory, self.states.classManagerCategories, false);
        const saveBtn = document.querySelector('.brxc-copy-id-to-class-wrapper .bricks-svg-wrapper.create');
        const cancelBtn = document.querySelector('.brxc-copy-id-to-class-wrapper .bricks-svg-wrapper.cancel');

        function exportSettings(){
            // Create CSS Settings
            const settings = {};
            for (const [key, value] of Object.entries(self.vueState.activeElement.settings)){
                if( key.startsWith('_cssCustom')){
                    let id;
                    (typeof self.vueState.activeElement.settings !== "undefined" && self.vueState.activeElement.settings.hasOwnProperty('_cssId')) ? id = '#' + self.vueState.activeElement.settings._cssId : id = '#brxe-' + self.vueState.activeElement.id;
                    settings[key] = value.replaceAll(id, '.' + self.helpers.formatForClasses(newInput.value))
                } else if (self.helpers.isCSSControlKey(key)) {
                    // Object
                    if(typeof self.vueState.activeElement.settings[key] === "object"){
                        for (const [key1, value1] of Object.entries(self.vueState.activeElement.settings[key])){
                            if(!settings.hasOwnProperty(key)) settings[key] = {};
                            settings[key][key1] = JSON.parse(JSON.stringify(self.vueState.activeElement.settings[key][key1]));
                        }
                    // Sring
                    } else {
                        settings[key] = JSON.parse(JSON.stringify(value));
                    }
                }
            }
            let isLocked;
            let isUnique = true;
            let idClass;
            let category;
            if(newCategory && newCategory.value.length > 0) {
                const relatedCat = self.helpers.getClassCategoryIdByName(newCategory.value)
                if(relatedCat){
                    category = relatedCat;
                } else {
                    const catId = self.vueGlobalProp.$_generateId();
                    self.vueState.globalClassesCategories.push({
                        id: catId,
                        name: newCategory.value,
                    })
                    category = catId
                }
            } 

            const addClass = (id, message, newWrapper) =>{
                // Add class to the element
                if (typeof self.vueState.activeElement.settings !== "undefined" && self.vueState.activeElement.settings.hasOwnProperty('_cssGlobalClasses')) {
                    if (!self.vueState.activeElement.settings._cssGlobalClasses.includes(id)) self.vueState.activeElement.settings._cssGlobalClasses.push(id)
                } else {
                    self.vueState.activeElement.settings._cssGlobalClasses = [];
                    self.vueState.activeElement.settings._cssGlobalClasses.push(id);
                }

                // Remove styles on ID
                for (const [key, value] of Object.entries(self.vueState.activeElement.settings)){
                    if (self.helpers.isCSSControlKey(key)) delete self.vueState.activeElement.settings[key];
                }

                newWrapper.remove();
                self.vueGlobalProp.$_showMessage(message);
            }

            // Check if class exists
            const targetClass = Array.from(self.vueState.globalClasses).find(el => el && el.hasOwnProperty('name') && el.name === self.helpers.formatForClasses(newInput.value));
            if(targetClass){
                isUnique = false;
                idClass = targetClass.id;
                isLocked = self.vueGlobalProp.$_isLocked(targetClass.id);
                if (!isLocked) for (const [key, value] of Object.entries(settings)){
                    //object
                    if(typeof settings[key] === "object"){
                        if(!targetClass.settings.hasOwnProperty(key)) targetClass.settings[key] = {};
                        for (const [key1, value1] of Object.entries(settings[key])){
                            if(!settings.hasOwnProperty(key)) settings[key] = {};
                            targetClass.settings[key][key1] = JSON.parse(JSON.stringify(settings[key][key1]));
                        }
                    } else {
                        //string
                        targetClass.settings[key] = value;
                    }
                }
            }

            if(isLocked === true){
                newWrapper.remove();
                self.vueGlobalProp.$_showMessage('Abort: the class is locked');
                return;
            }

            if(isUnique === false) {
                addClass(idClass, 'Class Successfully Updated!', newWrapper)
                self.vueState.activeClass = JSON.parse(JSON.stringify(self.vueGlobalProp.$_getGlobalClass(idClass)));
                return;
            }

            // Generate unique ID
            idClass = self.vueGlobalProp.$_generateId()


            // Create the class object
            const newGlobalClass = {
                id: idClass,
                name: self.helpers.formatForClasses(newInput.value),
                settings: settings,
            };
            if(category) newGlobalClass.category = category;

            self.vueState.globalClasses.push(newGlobalClass);
            self.vueState.activeClass = self.vueGlobalProp.$_getGlobalClass(idClass);
            self.vueState.rerenderControls = Date.now();
            addClass(idClass, 'Class Successfully Created!', newWrapper);
            self.helpers.saveChanges('globalClasses');
        }

        newInput.addEventListener('keyup', function(event) {
            if (event.shiftKey && event.keyCode === 13) exportSettings();
        });

        saveBtn.addEventListener('click', function(event) {
            if(newInput.value === ''){
                return self.vueGlobalProp.$_showMessage('Abort - No Class Name Given');
            }
            exportSettings()
        }); 
        cancelBtn.addEventListener('click', function(event) {
            newWrapper.remove();
        }); 
    },
    importIDStylestoClass: function(){
        const self = this;
        
        const activeClass = Array.from(self.vueState.globalClasses).find(el => el && el.hasOwnProperty('id') && el.id === self.vueState.activeClass.id);

        // Create CSS Settings
        const settings = {};
        for (const [key, value] of Object.entries(self.vueState.activeElement.settings)){

            if( key.startsWith('_cssCustom') ){
                let id;
                (typeof self.vueState.activeElement.settings !== "undefined" && self.vueState.activeElement.settings.hasOwnProperty('_cssId')) ? id = '#' + self.vueState.activeElement.settings._cssId : id = '#brxe-' + self.vueState.activeElement.id;
                settings[key] = JSON.parse(JSON.stringify(value.replaceAll(id, '.' + activeClass.name)));
            } else if (self.helpers.isCSSControlKey(key)) {
                // Object
                if(typeof self.vueState.activeElement.settings[key] === "object"){
                    for (const [key1, value1] of Object.entries(self.vueState.activeElement.settings[key])){
                        if(!settings.hasOwnProperty(key)) settings[key] = {};
                        settings[key][key1] = JSON.parse(JSON.stringify(self.vueState.activeElement.settings[key][key1]));
                    }
                // Sring
                } else {
                    settings[key] = JSON.parse(JSON.stringify(value));
                }
            }

            
        }

        const addClass = (message) =>{

            // Import Styles from ID
            for (const [key, value] of Object.entries(settings)){


                //object
                if(typeof settings[key] === "object"){
                    for (const [key1, value1] of Object.entries(settings[key])){
                        if(!activeClass.settings.hasOwnProperty(key)) activeClass.settings[key] = {};
                        activeClass.settings[key][key1] = JSON.parse(JSON.stringify(settings[key][key1]));
                    }
                } else {
                    //string
                    activeClass.settings[key] = value;
                }
                delete self.vueState.activeElement.settings[key]
            }

            self.vueGlobalProp.$_showMessage(message);
        }

        addClass('Styles Successfully Imported to the Class!');
        self.vueState.activeClass = JSON.parse(JSON.stringify(activeClass));
        self.vueState.rerenderControls = Date.now();
        //self.helpers.saveChanges('globalClasses');



    },
    setVariableAutocomplete: function() {
        const self = this;
        setTimeout(() => {
            self.fields['CSSVariabe']['includedFields'].forEach(field => {
                let elements;
                if (typeof field === 'string') {
                    elements = Array.from(document.querySelectorAll(field));
                } else {
                    // Get elements with the selector
                    const filteredElements = Array.from(document.querySelectorAll(field.selector));
    
                    // Check if they have any of the specified child elements
                    elements = filteredElements.filter(el =>
                        el && field.hasChild.some(child => child && el.querySelector(child))
                    );
                }
    
                const wrappers = elements.filter(
                    item => item &&
                        !item.parentNode.closest(self.fields['CSSVariabe']['excludedFields']) &&
                        !item.classList.contains('autocomplete-active')
                );
                if (wrappers.length < 1) return;
                wrappers.forEach(wrapper => {
                    wrapper.classList.add('autocomplete-active');
                    const input = wrapper.querySelector("input[type='text']");
                    input.addEventListener('focus', () => {
                        self.populateCSSVariables();
                        self.autocomplete(input, self.cssVariables, "style");
                    });
                });
            });
        }, 100);
    },
    previousTab: '',
    setActiveStyleTabs: function(){
        const self = this;
        const currentPanelTab = self.vueState.activePanelTab;
        if (currentPanelTab !== "style" || self.previousTab === currentPanelTab || self.vueState.brxc.clickedOnLeftPanelShortcuts === true) return self.previousTab = currentPanelTab;
        
        self.vueState.activePanelGroup = '';
        self.previousTab = currentPanelTab;
    },
    setBorderAndBoxShadow: function(){
        const self = this;
        if(!self.helpers.isElementActive()) return;
        const x = document.querySelector('#bricks-builder-iframe').contentWindow;
        const els = x.document.querySelectorAll('.has-border-settings');
        if(els && els.length > 0) els.forEach(el => el.classList.remove('has-border-settings'))

        if(self.vueState.activePanelGroup !== "_border") return;

        // const selector = self.vueState.activeElement.settings.hasOwnProperty('_cssId') && self.vueState.activeElement.settings._cssId ? `#${self.vueState.activeElement.settings._cssId}` : self.vueGlobalProp.$_getElementId(); 
        // let activeEl = x.document.querySelector(selector) || x.document.querySelector(`[data-id="${self.vueState.activeElement.id}"]`);
        const activeEl = FRAMEBRXC.vueGlobalProp.$_getElementNode(self.vueState.activeElement);
        if(!activeEl) return;
        
        activeEl.classList.add('has-border-settings');
    },
    openAvancedCSSModal: function(){
        const self = this;
        const cms = document.querySelectorAll("#brxcCSSOverlay .CodeMirror");
        self.populateCSSVariables();
        cms.forEach(el =>{
            const cm = el.CodeMirror;
            if(el.parentElement.dataset.code === "page") {
                if(self.globalSettings.superPowerCSSEnableSass && self.vueState.pageSettings.hasOwnProperty('customSass')){
                    cm.setValue(self.vueState.pageSettings.customSass)
                } else if(self.vueState.pageSettings.hasOwnProperty('customCss') && self.vueState.pageSettings.customCss){
                    cm.setValue(self.vueState.pageSettings.customCss)
                } else {
                    cm.setValue('')
                }
            }
            cm.refresh();
        })
        
        self.openModal(false, "#brxcCSSOverlay");
    },
    initToolbar: function(){
        const self = this;
        const leftToolbar = document.querySelector('#bricks-toolbar ul.group-wrapper.left');
        const rightToolbar = document.querySelector('#bricks-toolbar ul.group-wrapper.right');
        const middleToolbar = document.querySelector('#bricks-toolbar ul.group-wrapper.breakpoints');
        let elements;
        let structure;
        let dimensions;
        if (leftToolbar){
            elements = leftToolbar.querySelector('.elements');
        }
        if (middleToolbar){
            dimensions = middleToolbar.querySelector('.preview-dimension.width');
        }

        if (rightToolbar){
            structure = rightToolbar.querySelector('.structure');
        }
        // Builder Tweaks - Global Features
        if (self.helpers.isBuilderTweaksTabActive('global-features') ){
            if (Object.values(self.globalSettings.topbarShortcuts).includes('grid-guides')) {
                self.addMenuItemtoToolbar('grid-guide', 'Grid Guides (ctrl+cmd+' + self.globalSettings.keyboardShortcuts.gridGuides + ')', 'bottom', 'ADMINBRXC.generateGridGuideCSS();ADMINBRXC.gridGuide(this);', '<i class="bricks-svg ti-layout-grid4-alt" style="opacity: .5;"></i>', leftToolbar,  elements);
                self.addMenuItemtoToolbar('grid-guide-options', 'Grid Guides options', 'bottom', 'ADMINBRXC.setGridGuideOptions(this)', '<svg version="1.1" viewBox="0 0 16 16" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" class="bricks-svg" style="rotate: 90deg;"><path d="M3,9.5l-6.55671e-08,-1.77636e-15c-0.828427,-3.62117e-08 -1.5,-0.671573 -1.5,-1.5c3.62117e-08,-0.828427 0.671573,-1.5 1.5,-1.5l-6.55671e-08,1.77636e-15c0.828427,-3.62117e-08 1.5,0.671573 1.5,1.5c3.62117e-08,0.828427 -0.671573,1.5 -1.5,1.5Zm5,0l-6.55671e-08,-1.77636e-15c-0.828427,-3.62117e-08 -1.5,-0.671573 -1.5,-1.5c3.62117e-08,-0.828427 0.671573,-1.5 1.5,-1.5l-6.55671e-08,1.77636e-15c0.828427,-3.62117e-08 1.5,0.671573 1.5,1.5c3.62117e-08,0.828427 -0.671573,1.5 -1.5,1.5Zm5,0l-6.55671e-08,-1.77636e-15c-0.828427,-3.62117e-08 -1.5,-0.671573 -1.5,-1.5c3.62117e-08,-0.828427 0.671573,-1.5 1.5,-1.5l-6.55671e-08,1.77636e-15c0.828427,-3.62117e-08 1.5,0.671573 1.5,1.5c3.62117e-08,0.828427 -0.671573,1.5 -1.5,1.5Z" fill="currentColor" fill-rule="evenodd"></path></svg>', leftToolbar,  elements);
            }
            Object.values(self.globalSettings.topbarShortcuts).includes('x-mode') ? self.addMenuItemtoToolbar('x-mode', 'X-Mode (ctrl+cmd+' + self.globalSettings.keyboardShortcuts.xMode + ')', 'bottom', 'ADMINBRXC.XCode(this)', '<i class="bricks-svg fas fa-border-top-left" style="opacity: .5;"></i>', leftToolbar, elements) : '';
            Object.values(self.globalSettings.topbarShortcuts).includes('contrast-checker') ? self.addMenuItemtoToolbar('constrast', 'Contrast Checker (ctrl+cmd+' + self.globalSettings.keyboardShortcuts.contrastChecker + ')', 'bottom', 'ADMINBRXC.contrast(this)', '<i class="bricks-svg ion-ios-contrast" style="opacity: .5;"></i>', leftToolbar, elements) : '';
            Object.values(self.globalSettings.topbarShortcuts).includes('darkmode') ? self.addMenuItemtoToolbar('darkmode', 'Darkmode (ctrl+cmd+' + self.globalSettings.keyboardShortcuts.darkmode + ')', 'bottom', 'ADMINBRXC.darkMode(this)', '<i class="bricks-svg fas fa-moon" style="opacity: .5;"></i>', leftToolbar, elements) : '';
            Object.values(self.globalSettings.topbarShortcuts).includes('class-manager') ? self.addMenuItemtoToolbar('class-manager', 'Class Manager (ctrl+cmd+' + self.globalSettings.keyboardShortcuts.classManager + ')', 'bottom', 'ADMINBRXC.openClassManager("global");', '<i class="bricks-svg ion-md-options" style="opacity: .5;"></i>', leftToolbar, elements) : '';
            Object.values(self.globalSettings.topbarShortcuts).includes('global-query') ? self.addMenuItemtoToolbar('query-manager', 'Query Manager (ctrl+cmd+' + self.globalSettings.keyboardShortcuts.darkmode + ')', 'bottom', 'ADMINBRXC.queryManagerInit();ADMINBRXC.openModal(false,"#brxcQueryManagerOverlay");', '<i class="bricks-svg fas fa-infinity" style="opacity: .5;"></i>', leftToolbar, elements) : '';
            Object.values(self.globalSettings.globalFeatures).includes('responsive-helper') ? self.addMenuItemtoToolbar('responsive-helper', 'Responsive Helper', 'bottom', 'ADMINBRXC.setResponsiveHelper(this)', '<svg version="1.1" viewBox="0 0 16 16" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" class="bricks-svg" style="rotate: 90deg;"><path d="M3,9.5l-6.55671e-08,-1.77636e-15c-0.828427,-3.62117e-08 -1.5,-0.671573 -1.5,-1.5c3.62117e-08,-0.828427 0.671573,-1.5 1.5,-1.5l-6.55671e-08,1.77636e-15c0.828427,-3.62117e-08 1.5,0.671573 1.5,1.5c3.62117e-08,0.828427 -0.671573,1.5 -1.5,1.5Zm5,0l-6.55671e-08,-1.77636e-15c-0.828427,-3.62117e-08 -1.5,-0.671573 -1.5,-1.5c3.62117e-08,-0.828427 0.671573,-1.5 1.5,-1.5l-6.55671e-08,1.77636e-15c0.828427,-3.62117e-08 1.5,0.671573 1.5,1.5c3.62117e-08,0.828427 -0.671573,1.5 -1.5,1.5Zm5,0l-6.55671e-08,-1.77636e-15c-0.828427,-3.62117e-08 -1.5,-0.671573 -1.5,-1.5c3.62117e-08,-0.828427 0.671573,-1.5 1.5,-1.5l-6.55671e-08,1.77636e-15c0.828427,-3.62117e-08 1.5,0.671573 1.5,1.5c3.62117e-08,0.828427 -0.671573,1.5 -1.5,1.5Z" fill="currentColor" fill-rule="evenodd"></path></svg>', middleToolbar,  dimensions) : '';
            Object.values(self.globalSettings.topbarShortcuts).includes('advanced-css') ? self.addMenuItemtoToolbar('custom-css', 'Advanced CSS (ctrl+cmd+' + self.globalSettings.keyboardShortcuts.cssStylesheets + ')', 'bottom', `ADMINBRXC.openAvancedCSSModal();`, '<i class="bricks-svg fas fa-code" style="opacity: .5;"></i>', leftToolbar, elements) : '';
            Object.values(self.globalSettings.topbarShortcuts).includes('openai') ? self.addMenuItemtoToolbar('openai', 'OpenAI Assistant (ctrl+cmd+' + self.globalSettings.keyboardShortcuts.openai + ')', 'bottom', 'ADMINBRXC.openModal(false, "#brxcGlobalOpenAIOverlay")', '<i class="bricks-svg fas fa-robot" style="opacity: .5;"></i>', rightToolbar, structure) : '';
            Object.values(self.globalSettings.topbarShortcuts).includes('variable-manager') ? self.addMenuItemtoToolbar('CSSVariableManager', 'CSS Variable Manager (ctrl+cmd+' + self.globalSettings.keyboardShortcuts.variableManager + ')', 'bottom', 'ADMINBRXC.openModal(false, "#brxcCSSVariableManagerOverlay");ADMINBRXC.setCSSVariableManager(true);', '<i class="bricks-svg fas fa-square-root-variable" style="opacity: .5;"></i>', rightToolbar, structure) : '';
            Object.values(self.globalSettings.topbarShortcuts).includes("color-manager") ? self.addMenuItemtoToolbar('colorManager', 'Color Manager (ctrl+cmd+' + self.globalSettings.keyboardShortcuts.colorManager + ')', 'bottom', 'ADMINBRXC.openModal(false, "#brxcColorManagerOverlay");ADMINBRXC.setColorManager();', '<i class="bricks-svg fas fa-palette" style="opacity: .5;"></i>', rightToolbar, structure) : '';
            Object.values(self.globalSettings.topbarShortcuts).includes("resources") ? self.addMenuItemtoToolbar('resources', 'Resources (ctrl+cmd+' + self.globalSettings.keyboardShortcuts.resources + ')', 'bottom', 'ADMINBRXC.openModal(false, "#brxcResourcesOverlay", false, false)', '<i class="bricks-svg fas fa-images" style="opacity: .5;"></i>', rightToolbar, structure) : '';
            Object.values(self.globalSettings.topbarShortcuts).includes("brickslabs") ? self.addMenuItemtoToolbar('openai', 'BricksLabs (ctrl+cmd+' + self.globalSettings.keyboardShortcuts.brickslabs + ')', 'bottom', 'ADMINBRXC.bricksLabsAPI(false, false, true);ADMINBRXC.openModal(false, "#brxcBricksLabsOverlay")', '<i class="bricks-svg fas fa-flask" style="opacity: .5;"></i>', rightToolbar, structure) : '';
        }



        // Main Menu
        Object.values(self.globalSettings.topbarShortcuts).includes('main-menu') ? self.addMenuItemtoToolbar('main-at-menu', 'AT Main Menu', 'bottom', 'event.stopPropagation();ADMINBRXC.openMainMenu(this, true);', '<i style="opacity:.5""><span class="brxc-AT-menu-icon">AT</span></i>', leftToolbar, elements) : '';
    },
    buildMainMenu: function(){
        const self = this;
        const menuIcon = document.querySelector('li.main-at-menu');
        if(!menuIcon) return;
        menuIcon.classList.add('active')
        const menuIconPos = menuIcon.getBoundingClientRect();
        const shortcut = self.vueState.isMac ? 'CTRL + CMD' : 'CTRL + SHIFT';

        let menu = document.createElement('div');
        menu.id = 'brxc-main-at-menu';
        menu.classList.add('show');
        menu.style.left = `${menuIconPos.left}px`;
        let content = "";
        content += `<ul>
                        <li onclick="ADMINBRXC.closeMainMenu();ADMINBRXC.generateGridGuideCSS();ADMINBRXC.gridGuide();">
                            <span class="bricks-svg-wrapper"><i class="bricks-svg ti-layout-grid4-alt" style="opacity: .5;"></i></span>
                            <span class="label">Grid Guides</span>
                            <div class="settings" data-balloon="Settings" data-balloon-pos="right" onclick="event.stopPropagation();ADMINBRXC.closeMainMenu();ADMINBRXC.setGridGuideOptions(this);"><i class="fas fa-gear"></i></div>
                            <div class="action">
                                <span class="shortcut">${shortcut} + ${self.globalSettings.keyboardShortcuts.gridGuides}</span>
                                <div class="toggle" onclick="event.stopPropagation();ADMINBRXC.generateGridGuideCSS();ADMINBRXC.gridGuide();ADMINBRXC.openMainMenu(false, false);"><i class="fas fa-toggle-${self.gridGuideActive === true? 'on' : 'off'}"></i></div>
                            </div>
                        </li>
                        <li onclick="ADMINBRXC.closeMainMenu();ADMINBRXC.XCode();">
                            <span class="bricks-svg-wrapper"><i class="bricks-svg fas fa-border-top-left" style="opacity: .5;"></i></span>
                            <span class="label">X-mode</span>
                            <div class="action">
                                <span class="shortcut">${shortcut} + ${self.globalSettings.keyboardShortcuts.xMode}</span>
                                <div class="toggle" onclick="event.stopPropagation();ADMINBRXC.XCode();ADMINBRXC.openMainMenu(false, false);"><i class="fas fa-toggle-${self.xCodeActive === true? 'on' : 'off'}"></i></div>
                            </div>
                        </li>
                        <li onclick="ADMINBRXC.closeMainMenu();ADMINBRXC.contrast();">
                            <span class="bricks-svg-wrapper"><i class="bricks-svg ion-ios-contrast" style="opacity: .5;"></i></span>
                            <span class="label">Contrast Checker</span>
                            <div class="action">
                                <span class="shortcut">${shortcut} + ${self.globalSettings.keyboardShortcuts.contrastChecker}</span>
                                <div class="toggle" onclick="event.stopPropagation();ADMINBRXC.contrast();ADMINBRXC.openMainMenu(false, false);"><i class="fas fa-toggle-${self.contrastActive === true? 'on' : 'off'}"></i></div>
                            </div>
                        </li>
                        <li onclick="ADMINBRXC.closeMainMenu();ADMINBRXC.darkMode();">
                            <span class="bricks-svg-wrapper"><i class="bricks-svg fas fa-moon" style="opacity: .5;"></i></span>
                            <span class="label">Darkmode</span>
                            <div class="action">
                                <span class="shortcut">${shortcut} + ${self.globalSettings.keyboardShortcuts.darkmode}</span>
                                <div class="toggle" onclick="event.stopPropagation();ADMINBRXC.darkMode();ADMINBRXC.openMainMenu(false, false);"><i class="fas fa-toggle-${self.darkmodeActive === true? 'on' : 'off'}"></i></div>
                            </div>
                        </li>
                        <li onclick="ADMINBRXC.closeMainMenu();${self.strictEditorState !== true ? 'ADMINBRXC.strictEditorState = true;' : 'ADMINBRXC.strictEditorState = false;'}ADMINBRXC.vueState.rerenderControls = Date.now();">
                            <span class="bricks-svg-wrapper"><i class="bricks-svg fas fa-moon" style="opacity: .5;"></i></span>
                            <span class="label">Strict Editor Settings</span>
                            <div class="action">
                                <span class="save"><span class="bricks-svg-wrapper" data-balloon="Save Settings" data-balloon-pos="top" onclick="ADMINBRXC.saveFullAccessOptions()"><i class="fas fa-floppy-disk"></i></span></span>
                                <div class="toggle" onclick="event.stopPropagation();${self.strictEditorState !== true ? 'ADMINBRXC.strictEditorState = true;' : 'ADMINBRXC.strictEditorState = false;'}ADMINBRXC.setStrictEditorView();ADMINBRXC.openMainMenu();"><i class="fas fa-toggle-${self.strictEditorState === true? 'on' : 'off'}"></i></div>
                            </div>
                        </li>
                        <li class="sep"></li>
                        <li onclick="ADMINBRXC.closeMainMenu();ADMINBRXC.openClassManager('global');">
                            <span class="bricks-svg-wrapper"><i class="bricks-svg ion-md-options" style="opacity: .5;"></i></span>
                            <span class="label">Global Class Manager</span>
                            <div class="action">
                                <span class="shortcut">${shortcut} + ${self.globalSettings.keyboardShortcuts.classManager}</span>
                            </div>
                        </li>
                        <li onclick="ADMINBRXC.closeMainMenu();ADMINBRXC.openModal(false, '#brxcColorManagerOverlay');ADMINBRXC.setColorManager();">
                            <span class="bricks-svg-wrapper"><i class="bricks-svg fas fa-palette" style="opacity: .5;"></i></span>
                            <span class="label">Global Color Manager</span>
                            <div class="action">
                                <span class="shortcut">${shortcut} + ${self.globalSettings.keyboardShortcuts.colorManager}</span>
                            </div>
                        </li>
                        <li onclick="ADMINBRXC.closeMainMenu();ADMINBRXC.queryManagerInit();ADMINBRXC.openModal(false,'#brxcQueryManagerOverlay');">
                            <span class="bricks-svg-wrapper"><i class="bricks-svg fas fa-infinity" style="opacity: .5;"></i></span>
                            <span class="label">Global Query Loop Manager</span>
                            <div class="action">
                                <span class="shortcut">${shortcut} + ${self.globalSettings.keyboardShortcuts.queryLoopManager}</span>
                            </div>
                        </li>
                        <li onclick="ADMINBRXC.closeMainMenu();ADMINBRXC.openModal(false, '#brxcCSSVariableManagerOverlay');ADMINBRXC.setCSSVariableManager(true);">
                            <span class="bricks-svg-wrapper"><i class="bricks-svg fas fa-square-root-variable" style="opacity: .5;"></i></span>
                            <span class="label">Variable Manager</span>
                            <div class="action">
                                <span class="shortcut">${shortcut} + ${self.globalSettings.keyboardShortcuts.variableManager}</span>
                            </div>
                        </li>
                        <li class="sep"></li>
                        <li onclick="ADMINBRXC.closeMainMenu();ADMINBRXC.openAvancedCSSModal();">
                            <span class="bricks-svg-wrapper"><i class="bricks-svg fas fa-code" style="opacity: .5;"></i></span>
                            <span class="label">Advanced CSS</span>
                            <div class="action">
                                <span class="shortcut">${shortcut} + ${self.globalSettings.keyboardShortcuts.cssStylesheets}</span>
                            </div>
                        </li>
                        <li onclick="ADMINBRXC.openFindReplaceModal(event,true, '#brxcFindReplaceModal');">
                        <span class="bricks-svg-wrapper"><!--?xml version="1.0" encoding="UTF-8"?--><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 96 960 960" class="bricks-svg" style="opacity: .5;"><path xmlns="http://www.w3.org/2000/svg" d="M138 484q18-110 103.838-182T440 230q75 0 133 30.5t98 82.5v-98h72v239H503v-71h100q-27-42-70.5-65T440 325q-72.187 0-130.093 43.5Q252 412 234 484h-96Zm674 492L615 780q-34 27-78 43.5T440.217 840Q367 840 308.5 813 250 786 209 734v93h-72V588h240v71H271q28.269 41.15 72.541 64.075Q387.812 746 440 746q72.102 0 127.444-44.853T642 588h96q-5 33-19 65.5T684 713l197 196-69 67Z"></path></svg></span>
                        <span class="label">Find & Replace (Global)</span>
                            <div class="action">
                                <span class="shortcut">${shortcut} + ${self.globalSettings.keyboardShortcuts.findAndReplace}</span>
                            </div>
                        </li>
                        <li onclick="ADMINBRXC.setStructureHelper();ADMINBRXC.openModal(false, '#brxcStructureHelper');">
                            <span class="bricks-svg-wrapper"><i class="bricks-svg fas fa-circle-question" style="opacity: .5;"></i></span>
                            <span class="label">Structure Helper</span>
                            <div class="action">
                                <span class="shortcut">${shortcut} + ${self.globalSettings.keyboardShortcuts.structureHelper}</span>
                            </div>
                        </li>
                        <li class="sep"></li>
                        <li onclick="ADMINBRXC.closeMainMenu();ADMINBRXC.openModal(false, '#brxcGlobalOpenAIOverlay')">
                            <span class="bricks-svg-wrapper"><i class="bricks-svg fas fa-robot" style="opacity: .5;"></i></span>
                            <span class="label">OpenAI Assistant</span>
                            <div class="action">
                                <span class="shortcut">${shortcut} + ${self.globalSettings.keyboardShortcuts.openai}</span>
                            </div>
                        </li>
                        <li class="sep"></li>
                        <li onclick="ADMINBRXC.closeMainMenu();ADMINBRXC.openModal(false, '#brxcResourcesOverlay', false, false)">
                            <span class="bricks-svg-wrapper"><i class="bricks-svg fas fa-images" style="opacity: .5;"></i></span>
                            <span class="label">Resources Panel</span>
                            <div class="action">
                                <span class="shortcut">${shortcut} + ${self.globalSettings.keyboardShortcuts.resources}</span>
                            </div>
                        </li>
                        <li onclick="ADMINBRXC.closeMainMenu();ADMINBRXC.bricksLabsAPI(false, false, true);ADMINBRXC.openModal(false, '#brxcBricksLabsOverlay')">
                            <span class="bricks-svg-wrapper"><i class="bricks-svg fas fa-flask" style="opacity: .5;"></i></span>
                            <span class="label">BricksLabs Center</span>
                            <div class="action">
                                <span class="shortcut">${shortcut} + ${self.globalSettings.keyboardShortcuts.brickslabs}</span>
                            </div>
                        </li>
                    </ul>`;

        menu.innerHTML = content;
        document.body.appendChild(menu);
    },
    openMainMenu: function(target, close = true){
        const self = this;
        const x = document.querySelector('#bricks-builder-iframe').contentWindow;
        const existingMenu = document.querySelector('#brxc-main-at-menu');
        if(existingMenu){
            existingMenu.remove();
            if(close === true){
                if(target) target.classList.remove('active');
                return;
            }
        }
        function openMenu() {
            window.addEventListener('click', menuClickListener);
            x.document.addEventListener('click', menuClickListener);
            self.buildMainMenu();
        }
        
        function closeMenu() {
            window.removeEventListener('click', menuClickListener);
            x.document.removeEventListener('click', menuClickListener);
            self.closeMainMenu();
        }
        
        function menuClickListener(event) {
            closeMenu();
        }
        openMenu();
    },
    closeMainMenu: function(){
        const existingMenu = document.querySelector('#brxc-main-at-menu');
        if(existingMenu) existingMenu.remove();
        const menuIcon = document.querySelector('li.main-at-menu');
        if(!menuIcon) return;
        menuIcon.classList.remove('active')
    },
    // CSS Variable Manager
    cssVariablesStates:{
        activeCategory: false,
        categories: [],
        renameCategory: false,
        addCategory: false,
        importVariables: false,
        search: '',
        showGlobal: true,
        generatedCSSTheme: false,
        generatedCSSGlobal: false,
        globalCategories: false,
    },
    generateBuilderCSS: function(){
        const self = this;
        const x = document.querySelector('#bricks-builder-iframe').contentWindow;
        var stylesheet1 = x.document.querySelector(':root');
        var stylesheet2 = document.querySelector(':root');

        let css = '';
        if(self.colorStates.generatedCSS) css += self.colorStates.generatedCSS;
        if(self.cssVariablesStates.generatedCSSGlobal) css += self.cssVariablesStates.generatedCSSGlobal;
        if(self.helpers.isCSSVariablesTabActive('theme-variables') && self.cssVariablesStates.generatedCSSTheme) css += self.cssVariablesStates.generatedCSSTheme;
        [stylesheet1,stylesheet2].forEach(root => {
            root.removeAttribute('style');
            root.style = css;
        }) 
    },
    generateVariableCSS: function(type) {
        const self = this;
        let vars;
        if(type === "theme"){
            if(!self.helpers.isCSSVariablesTabActive('theme-variables') || !self.helpers.themeHasVariables()) return;
            vars = self.vueState.themeStyleSettings.general._cssVariables;
        } else if(type === "global"){
            vars = self.globalSettings.defaultVariables;
        }
        if(!vars || !Array.isArray(vars) || vars.length < 1) return;
        let css = '';
        vars.forEach(variable => {
            if(!variable.hasOwnProperty('name') || !variable.hasOwnProperty('type')) return;
            const name = self.helpers.setPrefix(self.helpers.formatForClasses(variable.name), 'variables', false);

            if(variable.type === "static" && variable.hasOwnProperty('value')){
                css += `--${name}:${variable.value};`;
            } else if(variable.type === "clamp" && variable.hasOwnProperty('min') && variable.hasOwnProperty('max')){
                let rootFontSize;
                if (typeof self.vueState.themeStyleSettings === "object" && self.vueState.themeStyleSettings.hasOwnProperty("typography") && self.vueState.themeStyleSettings.typography.hasOwnProperty('typographyHtml')) {
                    const typographyHTML = self.vueState.themeStyleSettings.typography.typographyHtml;
                    if( typographyHTML ) {
                        rootFontSize = parseFloat(typographyHTML.replace('%','')) / 100;
                    } else{
                        rootFontSize = 0.625;
                    } 
                } else {
                    rootFontSize = 0.625;
                }

                let baseFont;
                if(type !== "theme"){
                    baseFont = self.globalSettings.generalCats.hasOwnProperty('baseFontSize') && self.globalSettings.generalCats.baseFontSize ? self.globalSettings.generalCats.baseFontSize : 10;
                } else {
                    baseFont = 16 * rootFontSize;
                }
                const min = parseFloat(variable.min);
                const max = parseFloat(variable.max);
                const minVW = self.globalSettings.generalCats.minViewportWidth ? parseFloat(self.globalSettings.generalCats.minViewportWidth) : 360;
                const maxVW = self.globalSettings.generalCats.maxViewportWidth ? parseFloat(self.globalSettings.generalCats.maxViewportWidth) : 1400;
                const clamp = self.helpers.clampBuilder(baseFont, minVW, maxVW, min, max);
                css += `--${name}:${clamp};`;
            }
        })

        type === "theme" ? self.cssVariablesStates.generatedCSSTheme = css : self.cssVariablesStates.generatedCSSGlobal = css;

    },
    setCSSVariableManager: function(generateCategories){
        const self = this;
        if(generateCategories) self.setCSSVariableManagerCategories();
        self.setCSSVariableManagerHeader();
        self.setCSSVariableManagerSearch();
        self.setCSSVariableManagerBody();
    },
    setCSSVariableManagerCategories: function(){
        const self = this;

        //global
        if(self.cssVariablesStates.globalCategories === false){
            const globalCategories = new Set(self.globalSettings.defaultVariables.map(item => item && item.hasOwnProperty('group') && item.group));
            self.cssVariablesStates.globalCategories = Array.from(globalCategories);
        }

        //All
        const arr = self.helpers.isCSSVariablesTabActive('theme-variables') && self.helpers.themeHasVariables() ? self.globalSettings.defaultVariables.concat(self.vueState.themeStyleSettings.general._cssVariables) : self.globalSettings.defaultVariables;
        const uniqueNamesSet = new Set(arr.map(item => item && item.hasOwnProperty('group') && item.group));
        self.cssVariablesStates.categories = Array.from(uniqueNamesSet);
        if(!self.cssVariablesStates.activeCategory) self.cssVariablesStates.activeCategory = self.cssVariablesStates.categories.sort((a, b) => a.localeCompare(b, undefined, {sensitivity: 'base'}))[0];
    },
    setCSSVariableManagerHeader: function(){
        const self = this;
        let content = '';
        content += `<div class="brxc-select">`;
        if(self.cssVariablesStates.renameCategory === false && self.cssVariablesStates.addCategory === false && self.cssVariablesStates.activeCategory){
            content += `<select name="brxc-cssVariablesOptions" id="cssVariablesOptions" class="brxc-cssVariablesOptions" value="${self.cssVariablesStates.activeCategory}" onChange="ADMINBRXC.cssVariablesStates.search = '';ADMINBRXC.cssVariablesStates.activeCategory = this.value;ADMINBRXC.setCSSVariableManager(false);">`;
            self.cssVariablesStates.categories.sort((a, b) => a.localeCompare(b, undefined, {sensitivity: 'base'})).forEach(cat => {
                content += `<option value="${cat}"${cat === self.cssVariablesStates.activeCategory ? ' selected="selected"' : ''}>${cat}</option>`;
            })
            content += `</select>`;
            if(self.helpers.isCSSVariablesTabActive('theme-variables')){
                content += '<div class="brxc-icon-container">'
                content += !self.cssVariablesStates.globalCategories.includes(self.cssVariablesStates.activeCategory) ? `<div class="brxc-icon" data-balloon="Rename Category" data-balloon-pos="bottom-right" onClick="ADMINBRXC.cssVariablesStates.renameCategory = true;ADMINBRXC.setCSSVariableManagerHeader()"><span class="bricks-svg-wrapper"><i class="fas fa-pen"></i></span></div>` : '';
                content += `<div class="brxc-icon" data-balloon="Add New Category" data-balloon-pos="bottom-right" onClick="ADMINBRXC.cssVariablesStates.addCategory = true;ADMINBRXC.setCSSVariableManagerHeader()"><span class="bricks-svg-wrapper"><i class="fas fa-plus"></i></span></div>`;
                content += `<div class="brxc-icon" data-balloon="Duplicate Category" data-balloon-pos="bottom-right" onClick="ADMINBRXC.duplicateVariableCategory();"><span class="bricks-svg-wrapper"><i class="fas fa-clone"></i></span></div>`;
                content += !self.cssVariablesStates.globalCategories.includes(self.cssVariablesStates.activeCategory) ? `<div class="brxc-icon" data-balloon="Delete Category" data-balloon-pos="bottom-right" onClick="ADMINBRXC.setDeleteVariable(this, 'ADMINBRXC.deleteVariableCategory()');"><span class="bricks-svg-wrapper"><i class="ti-trash"></i></span></div>` : '';
                content += `</div>`;
            }
        } else if(self.helpers.isCSSVariablesTabActive('theme-variables') && self.cssVariablesStates.renameCategory === true){
            content += `<input type="text" id="brxcRenameCategory" value="${self.cssVariablesStates.activeCategory}" />`;
        } else if(self.helpers.isCSSVariablesTabActive('theme-variables') && (self.cssVariablesStates.addCategory === true || !self.cssVariablesStates.activeCategory)){
            content += `<input type="text" id="brxcAddCategory" placeholder="Type the category's name here and hit ENTER." value="" />`;
        }
        content += `</div>`;

        const canvas = document.querySelector('#CSSVariableHeaderCanvas')
        if(canvas && content) canvas.innerHTML = content;

        // Add
        if (self.cssVariablesStates.addCategory === true || !self.cssVariablesStates.activeCategory) {
            self.cssVariablesStates.addCategory = false;
            const input = canvas.querySelector('#brxcAddCategory');
            if (!input) return;
            const end = input.value.length;
            input.setSelectionRange(end, end);
            input.focus();

            function addName(input) {
                if(!self.cssVariablesStates.categories) self.cssVariablesStates.categories = [];
                if(!self.cssVariablesStates.categories.includes(input.value)) self.cssVariablesStates.categories.push(input.value);
                self.cssVariablesStates.activeCategory = input.value;
                self.vueGlobalProp.$_showMessage('Category successfully added');
                self.setCSSVariableManager(false);
            }

            const onBlur = () => {
                input.removeEventListener("blur", onBlur);
                input.removeEventListener("keydown", onKeyDown);
                setTimeout(() => {
                    self.setCSSVariableManagerHeader();
                }, 10);
            };

            const onKeyDown = (event) => {
                if (event.key === "Enter") {
                    addName(input);
                    input.removeEventListener("blur", onBlur);
                    input.removeEventListener("keydown", onKeyDown);
                }
            };

            input.addEventListener("blur", onBlur);
            input.addEventListener("keydown", onKeyDown);
        }

        // Rename
        if (self.cssVariablesStates.renameCategory === true) {
            self.cssVariablesStates.renameCategory = false;
            const input = canvas.querySelector('#brxcRenameCategory');
            if (!input) return;
            const end = input.value.length;
            input.setSelectionRange(end, end);
            input.focus();

            function renameName(input) {
                const vars = self.helpers.isCSSVariablesTabActive('theme-variables') && self.helpers.themeHasVariables() ? Array.from(self.vueState.themeStyleSettings.general._cssVariables).filter(el => el && el.hasOwnProperty('group') && el.group === self.cssVariablesStates.activeCategory) : false;
                if(vars && Array.isArray(vars) && vars.length > 0) {
                    vars.forEach(variable => {
                        variable.group = input.value;
                    })
                } 
                    
                const index = self.cssVariablesStates.categories.indexOf(self.cssVariablesStates.activeCategory);
                self.cssVariablesStates.categories[index] = input.value;
                self.cssVariablesStates.activeCategory = input.value;
                self.vueGlobalProp.$_showMessage('Category successfully renamed');
                self.setCSSVariableManager(false);
            }

            const onBlur = () => {
                input.removeEventListener("blur", onBlur);
                input.removeEventListener("keydown", onKeyDown);
                setTimeout(() => {
                    self.setCSSVariableManagerHeader();
                }, 10);
            };

            const onKeyDown = (event) => {
                if (event.key === "Enter") {
                    renameName(input);
                    input.removeEventListener("blur", onBlur);
                    input.removeEventListener("keydown", onKeyDown);
                }
            };

            input.addEventListener("blur", onBlur);
            input.addEventListener("keydown", onKeyDown);
        }
    },
    duplicateVariableCategory: function(){
        const self = this;
        const arr = self.helpers.isCSSVariablesTabActive('theme-variables') && self.helpers.themeHasVariables() ? self.globalSettings.defaultVariables.concat(self.vueState.themeStyleSettings.general._cssVariables) : self.globalSettings.defaultVariables;
        const vars = Array.from(arr).filter(el => el && el.hasOwnProperty('group') && el.group === self.cssVariablesStates.activeCategory)
        if (!vars || !Array.isArray(vars) || vars.lentgh < 1) return;

        const groupName = `${self.cssVariablesStates.activeCategory} (Copy)`;
        vars.forEach((variable, index) =>{
            const type = variable.hasOwnProperty('type') && variable.type === "clamp" ? "clamp" : "static";
            const newVariable = {
                id: self.vueGlobalProp.$_generateId(),
                name: variable.name,
                group: groupName,
                type: type,
                order: index,
            }
            if(variable.hasOwnProperty('value') && variable.value) newVariable.value = variable.value;
            if(variable.hasOwnProperty('min') && variable.min) newVariable.min = variable.min;
            if(variable.hasOwnProperty('max') && variable.max) newVariable.max = variable.max;
            self.helpers.createThemeVariable();
            self.vueState.themeStyleSettings.general._cssVariables.push(newVariable);
        })
        self.cssVariablesStates.activeCategory = groupName;
        if(!self.cssVariablesStates.categories.includes(self.cssVariablesStates.activeCategory)) self.cssVariablesStates.categories.push(groupName);
        self.vueGlobalProp.$_showMessage('Category successfully duplicated');
        self.generateVariableCSS('theme');
        self.generateBuilderCSS();
        self.setCSSVariableManager(false);

    },
    setDeleteVariable: function(target,newFunction){
        const oldContent = target.innerHTML;
        const oldBalloon = target.dataset.balloon;
        const oldFunction = target.getAttribute('onclick');
        const newContent = '<span class="bricks-svg-wrapper"><i class="fas fa-check"></i></span>';
        const newBalloon = 'Confirm?';

        target.setAttribute("onClick", newFunction);
        target.setAttribute("data-balloon", newBalloon);
        target.innerHTML = newContent;
        setTimeout(() => {
            target.setAttribute("onClick", oldFunction);
            target.setAttribute("data-balloon", oldBalloon);
            target.innerHTML = oldContent;
        }, 2000)
    },
    setDeleteVariableSingle: function(target, id){
        const oldContent = target.innerHTML;
        const oldBalloon = target.dataset.balloon;
        const oldFunction = `ADMINBRXC.setDeleteVariableSingle(this, '${id}')`;
        const newContent = '<span class="bricks-svg-wrapper"><i class="fas fa-check"></i></span>';
        const newBalloon = 'Confirm?';
        const newFunction = `ADMINBRXC.deleteVariable('${id}')`;

        target.setAttribute("onClick", newFunction);
        target.setAttribute("data-balloon", newBalloon);
        target.innerHTML = newContent;
        setTimeout(() => {
            target.setAttribute("onClick", oldFunction);
            target.setAttribute("data-balloon", oldBalloon);
            target.innerHTML = oldContent;
        }, 2000)
    },
    deleteVariableCategory: function(){
        const self = this;
 
        const vars = self.helpers.isCSSVariablesTabActive('theme-variables') && self.helpers.themeHasVariables() ? Array.from(self.vueState.themeStyleSettings.general._cssVariables).filter(el => el && el.hasOwnProperty('group') && el.group === self.cssVariablesStates.activeCategory) : false;
        function removeCat(){
            const index = self.cssVariablesStates.categories.indexOf(self.cssVariablesStates.activeCategory);
            self.cssVariablesStates.categories.splice(index, 1);
            Array.isArray(self.cssVariablesStates.categories) && self.cssVariablesStates.categories.length > 0 ? self.cssVariablesStates.activeCategory = self.cssVariablesStates.categories.sort((a, b) => a.localeCompare(b, undefined, {sensitivity: 'base'}))[0] : self.cssVariablesStates.activeCategory = false;
            self.setCSSVariableManager(false);
        }

        if(vars && Array.isArray(vars) && vars.length > 0) {
            vars.forEach(variable => {
                const index = self.vueState.themeStyleSettings.general._cssVariables.indexOf(variable);
                self.vueState.themeStyleSettings.general._cssVariables.splice(index, 1);
            })
        }
        
        removeCat();
        self.vueGlobalProp.$_showMessage('Category successfully deleted');
        self.generateVariableCSS('theme');
        self.generateBuilderCSS();
    },
    setCSSVariableManagerSearch: function(){
        const self = this;
        const arr = self.helpers.isCSSVariablesTabActive('theme-variables') && self.helpers.themeHasVariables() ? self.globalSettings.defaultVariables.concat(self.vueState.themeStyleSettings.general._cssVariables) : self.globalSettings.defaultVariables;
        const vars = Array.from(arr).filter(el => el && el.hasOwnProperty('group') && el.group === self.cssVariablesStates.activeCategory)
        const canvas = document.querySelector('#CSSVariableSearchCanvas');
        if(!vars || !Array.isArray(vars) || vars.length < 2) return canvas.innerHTML = '';
        let content = `<div class="brxc-overlay__search-box">
                        <input type="search" class="class-filter" name="class-search" placeholder="Filter by variable name" data-type="title" value="${self.cssVariablesStates.search}" oninput="ADMINBRXC.cssVariablesStates.search = this.value;ADMINBRXC.setCSSVariableManagerBody();">
                        <div class="iso-search-icon">
                            <i class="bricks-svg ti-search"></i>
                        </div>
                        <div class="iso-reset" data-balloon="Reset Filter" data-balloon-pos="bottom-right" onclick="ADMINBRXC.cssVariablesStates.search = '';ADMINBRXC.setCSSVariableManager(false);">
                            <i class="bricks-svg ti-close"></i>
                        </div>
                      </div>`;
        canvas.innerHTML = content;
    },
    setCSSVariableManagerBody: function(){
        const self = this;
        const canvas = document.querySelector('#CSSVariableBodyCanvas')
        const arr = self.helpers.isCSSVariablesTabActive('theme-variables') && self.helpers.themeHasVariables() ? self.globalSettings.defaultVariables.concat(self.vueState.themeStyleSettings.general._cssVariables) : self.globalSettings.defaultVariables;
        const allVars = Array.from(arr).filter(el => el && el.hasOwnProperty('group') && el.group === self.cssVariablesStates.activeCategory)
        const tempVarsGlobal = Array.from(self.globalSettings.defaultVariables).filter(el => el && el.hasOwnProperty('group') && el.group === self.cssVariablesStates.activeCategory);
        const tempVarsGlobalArr = Object.values(tempVarsGlobal);
        let globalVars = tempVarsGlobalArr.sort((a, b) => a.order - b.order);

        //Search
        if(self.cssVariablesStates.search !== '') globalVars = Array.from(globalVars).filter(el => el && el.hasOwnProperty('name') && el.name.includes(self.cssVariablesStates.search));
        
        let content = '';

        // Global Vars
        if(globalVars && Array.isArray(globalVars) && globalVars.length > 0 && self.cssVariablesStates.activeCategory){
            content += `<div class="variable-heading${allVars && Array.isArray(allVars) && allVars.length > 1 ? ' sticky' : ''} global"><label class="has-tooltip"><span class="title${self.cssVariablesStates.showGlobal !== true ? ' inactive' : ''}">Global Variables</span><div data-balloon="The global variables apply on all your website. They can't be edited inside the builder, but can be overwritten by theme-specific variables." data-balloon-pos="bottom" data-balloon-length="large"><i class="fas fa-circle-question"></i></div></label>`
            content += `<div class="action">`;
            content += `<div class="brxc-icon" data-balloon="${self.cssVariablesStates.showGlobal === true ? 'Hide' : 'Show'} Global Variables" data-balloon-pos="left" onclick="ADMINBRXC.toggleGlobalVars()"><span class="bricks-svg-wrapper"><i class="fas fa-eye${self.cssVariablesStates.showGlobal !== true ? '-slash' : ''}"></i></span></div>`;
            content += '</div></div>';
            if(self.cssVariablesStates.showGlobal === true ){
                content += '<ul class="brxc-global-variable-list">';
            let ind = 0;
            globalVars.forEach(el => {
                content += `<li class="disable"><div class="variable-wrapper">`;
                content += `<div class="variable-inner-wrapper">`;
                content += `<button class="variable-type-switch ${el.hasOwnProperty('type') && el.type === "clamp" ? 'clamp' : 'static'}">${el.hasOwnProperty('type') ? el.type.slice(0, 2) : ''}`
                content += self.helpers.isVarActiveOnPage(`var(--${self.helpers.setPrefix(self.helpers.formatForClasses(el.name), 'variables', false)})`) ? `<div class="btn-color-check" data-balloon="active on the page" data-balloon-pos="right"><i class="fas fa-check"></i></i></div>` : '';
                content += `</button>`;
                content += `<input type="text" class="variable-name" value="${el && el.hasOwnProperty('name') ? el.name : ''}" readonly />`;
                if(el.hasOwnProperty('type') && el.type === "clamp"){
                    content += `<div class="input-container">`;
                    content += `<div class="input-wrapper"><input type="text" class="variable-min" value="${el && el.hasOwnProperty('min') ? el.min : ''}" readonly /><input type="text" class="variable-unit" value="px" readonly/></div>`;
                    content += `<div class="input-wrapper"><input type="text" class="variable-max" value="${el && el.hasOwnProperty('max') ? el.max : ''}" readonly /><input type="text" class="variable-unit" value="px" readonly/></div>`;
                    content += `</div>`;
                } else if(el.hasOwnProperty('type') && el.type === "static") {
                    content += `<input type="text" class="variable-value" value="${el && el.hasOwnProperty('value') ? el.value : ''}" readonly />`;
                }
                content += `</div>`;
                content += `</li>`;
                ind++;
            })
            content += '</ul>';
            }
        }

        if(!self.helpers.isCSSVariablesTabActive('theme-variables')) return canvas.innerHTML = content;


        // Theme Variables
        if(self.helpers.themeHasVariables() && self.cssVariablesStates.activeCategory){
            const tempVarsTheme = Array.from(self.vueState.themeStyleSettings.general._cssVariables).filter(el => el && el.hasOwnProperty('group') && el.group === self.cssVariablesStates.activeCategory);
            const tempVarsThemeArr = Object.values(tempVarsTheme);
            let themeVars = tempVarsThemeArr.sort((a, b) => a.order - b.order);

            //Search
            if(self.cssVariablesStates.search !== '') themeVars = Array.from(themeVars).filter(el => el && el.hasOwnProperty('name') && el.name.includes(self.cssVariablesStates.search));

            content += `<div class="variable-heading${allVars && Array.isArray(allVars) && allVars.length > 1 ? ' sticky' : ''} theme"><label class="has-tooltip"><span class="title">Theme Variables</span><div data-balloon="The theme variables only apply on posts/pages where the specific theme style is active. They can be edited inside the builder, and have higher specificity than global variables." data-balloon-pos="bottom" data-balloon-length="large"><i class="fas fa-circle-question"></i></div></label>`;
            content += `<div class="action">`;
            content += '</div></div>';
            
            // Theme Vars
            if(themeVars && Array.isArray(themeVars) && themeVars.length > 0){
                content += '<ul class="brxc-theme-variable-list">';
                let ind = 0;
                themeVars.forEach(el => {
                    content += `<li data-order="${ind}" data-id="${el.hasOwnProperty('id') ? el.id : ''}" class=""><div class="variable-wrapper">`;
                    content += themeVars.length > 1 ? `<div class="handle"><i class="ti-move"></i></div>` : '';
                    content += `<div class="variable-inner-wrapper">`;
                    content += `<button class="variable-type-switch ${el.hasOwnProperty('type') && el.type === "clamp" ? 'clamp' : 'static'}" onClick="ADMINBRXC.toggleTypeSwitch('${el && el.hasOwnProperty('id') ? el.id : false}')">${el.hasOwnProperty('type') ? el.type.slice(0, 2) : ''}`;
                    content += self.helpers.isVarActiveOnPage(`var(--${self.helpers.setPrefix(self.helpers.formatForClasses(el.name), 'variables', false)})`) ? `<div class="btn-color-check" data-balloon="active on the page" data-balloon-pos="right"><i class="fas fa-check"></i></i></div>` : '';
                    content += `</button>`;
                    content += `<input type="text" class="variable-name" data-original="${el && el.hasOwnProperty('name') ? el.name : ''}" value="${el && el.hasOwnProperty('name') ? el.name : ''}" onkeyup="ADMINBRXC.renameVariable(event)" onblur="this.value = this.dataset.original"/>`;
                    if(el.hasOwnProperty('type') && el.type === "clamp"){
                        content += `<div class="input-container">`;
                        content += `<div class="input-wrapper"><input type="number" class="variable-min" value="${el && el.hasOwnProperty('min') ? el.min : ''}" onchange="ADMINBRXC.setVariableValue(event,'min');" onkeyup="ADMINBRXC.setVariableValue(event,'min');" /><input type="text" class="variable-unit" value="px" readonly/></div>`;
                        content += `<div class="input-wrapper"><input type="number" class="variable-max" value="${el && el.hasOwnProperty('max') ? el.max : ''}" onchange="ADMINBRXC.setVariableValue(event,'max');" onkeyup="ADMINBRXC.setVariableValue(event,'max');" /><input type="text" class="variable-unit" value="px" readonly/></div>`;
                        content += `</div>`;
                    } else if(el.hasOwnProperty('type') && el.type === "static") {
                        content += `<input type="text" class="variable-value" value="${el && el.hasOwnProperty('value') ? el.value : ''}" onkeyup="ADMINBRXC.setVariableValue(event,'value');" />`;
                    }
                    content += `</div>`;
                    content += `<div class="right-actions">`;
                    content += `<div class="duplicate-variable" data-balloon="Duplicate Variable" data-balloon-pos="left" onClick="ADMINBRXC.duplicateVariable('${el.hasOwnProperty("id") ? el.id : false}');"><span class="bricks-svg-wrapper"><i class="fas fa-clone"></i></span></div>`;
                    content += `<div class="delete-variable" data-balloon="Delete Variable" data-balloon-pos="left" onClick="ADMINBRXC.setDeleteVariableSingle(this, '${el.hasOwnProperty("id") ? el.id : false}');"><span class="bricks-svg-wrapper"><i class="ti-trash"></i></span></div>`;
                    content += `</div></div>`;
                    content += `</li>`;
                    ind++;
                })
                    
                content += '</ul>';
            }
        } else if(self.cssVariablesStates.activeCategory){
            content += `<div class="variable-heading theme"><span class="title">Theme Variables</span>`;
            content += `<div class="action">`;
            content += '</div></div>';
        }
        
        // Add new variable
        if(self.cssVariablesStates.activeCategory){
            content += `<div class="brxc-add-color-wrapper">`;
            content += `<div class="brxc-import-css-colors${self.cssVariablesStates.importVariables === true ? ' active' : ''}" data-balloon="Import CSS variables" data-balloon-pos="bottom-left" onclick="ADMINBRXC.toggleImportVariables('${self.cssVariablesStates.importVariables === true ? 'true' : 'false'}');"><i class="fas fa-code"></i></div> `;
            content += self.cssVariablesStates.importVariables === true ? `<textarea id="addNewVariableCSS" rows="20" placeholder="Paste your CSS variables here"></textarea>` : `<input type="text" id="addNewVariable" placeholder="Add a new theme variable" onkeyup="ADMINBRXC.addVariable(event);" />`;
            content += `</div>`;
            if(self.cssVariablesStates.importVariables === true){
                content += `<a class="brxc-overlay__action-btn primary" style="margin-right:16px;margin-left:auto;" onclick="ADMINBRXC.importVariables();"><span>Import Variables</span></a>`;
            }
        }
        
        canvas.innerHTML = content;

        //Listeners
        const variableWrapper = canvas.querySelector('ul.brxc-theme-variable-list');
        if (!variableWrapper) return;

        const inputs = variableWrapper.querySelectorAll('input.variable-value');
        if(inputs && inputs.length > 0) {
            inputs.forEach(input => {
                // auto-complete
                if(Object.values(self.globalSettings.classFeatures).includes("autocomplete-variable")){
                    input.addEventListener('focus', () => {
                        self.autocomplete(input, self.cssVariables, "style");
        
                    });
                }
    
                //autoformat
                if(Object.values(self.globalSettings.classFeatures).includes("autoformat-field-values")){
                    input.addEventListener('blur', () => {
                        self.autoformat(input, "custom");
                        input.dispatchEvent(new Event('keyup'));
        
                    });
                }
            })
        }

        //Drag and drop
        const rows = variableWrapper.querySelectorAll('li .handle');
        if(!rows || rows.length < 2) return;
        function move(arr, from, to, on = 1) {
            return arr.splice(to, 0, ...arr.splice(from, on)), arr
        }
        new Sortable(variableWrapper, {
            multiDrag: true,
            selectedClass: "sortable-selected",
            animation: 150,
            handle: "li .handle",
            helper : 'clone',
            onEnd: function () {
                const vars = self.vueState.themeStyleSettings.general._cssVariables;  
                const items = Array.from(variableWrapper.children);
                items.forEach((item,index) => {
                    const target = Array.from(vars).find(el => el && el.hasOwnProperty('id') && el.id === item.dataset.id);
                    if(!target) return;
                    if(target.hasOwnProperty('order')) target.order = index;
                })
                self.vueGlobalProp.$_showMessage('Variables order successfully changed');
                self.setCSSVariableManager(false);
            },
        })
    },
    toggleGlobalVars: function(){
        const self = this;
        self.cssVariablesStates.showGlobal === true ? self.cssVariablesStates.showGlobal = false : self.cssVariablesStates.showGlobal = true;
        self.setCSSVariableManager(false);
    },
    deleteVariable: function(id){
        const self = this;
        if(!id || !self.helpers.isCSSVariablesTabActive('theme-variables') || !self.helpers.themeHasVariables()) return;
        const vars = self.vueState.themeStyleSettings.general._cssVariables;
        const variable = Array.from(vars).find(el => el && el.hasOwnProperty('id') && el.id === id);
        if (!variable) return;
        const index = vars.indexOf(variable);
        if (index === -1) return;
        vars.splice(index, 1);

        self.vueGlobalProp.$_showMessage('Variable successfully deleted');
        self.generateVariableCSS('theme');
        self.generateBuilderCSS();
        self.setCSSVariableManager(false);
    },
    addVariable(event){
        if(event.key !== "Enter") return;
        const self = this;
        self.helpers.createThemeVariable();
        const vars = self.vueState.themeStyleSettings.general._cssVariables;
        const newVariable = {
            id: self.vueGlobalProp.$_generateId(),
            group: self.cssVariablesStates.activeCategory,
            name: event.target.value,
            order: self.vueState.themeStyleSettings.general._cssVariables.length,
            type: 'static',
            value: '',
        }
        vars.push(newVariable);

        self.vueGlobalProp.$_showMessage('Variable successfully added');
        self.generateVariableCSS('theme');
        self.generateBuilderCSS();
        self.setCSSVariableManager(false);

    },
    duplicateVariable: function(id){
        const self = this;
        const vars = self.vueState.themeStyleSettings.general._cssVariables;
        const variable = Array.from(vars).find(el => el && el.hasOwnProperty('id') && el.id === id);
        if (!variable) return;

        const newVariable = {...variable};
        newVariable.id = self.vueGlobalProp.$_generateId();
        newVariable.name = `(Copy) ${variable.name}`;

        vars.push(newVariable);

        self.vueGlobalProp.$_showMessage('Variable successfully duplicated');
        self.generateVariableCSS('theme');
        self.generateBuilderCSS();
        self.setCSSVariableManager(false);
    },
    setaddVariableFromPicker: function(event, target, id){
        const self = this;
        const group = event.target.dataset.group;
        const parent = event.target.closest('.brxc-overlay__action-btn-wrapper');
        event.target.remove();
        let input = document.createElement('input');
        input.type = "text";
        input.setAttribute('class', 'add-new-variable-input');
        parent.appendChild(input);

        input = parent.querySelector('.add-new-variable-input');
        const end = input.value.length;
        input.setSelectionRange(end, end);
        input.focus();
        input.addEventListener('keyup', (e) => {
            self.addVariableFromPicker(e, group, target, id);
        })
    },
    addVariableFromPicker: function(event, group, target, id){
        if(event.key !== "Enter") return;
        const self = this;
        self.cssVariablesStates.activeCategory = group;
        target.value = `var(--${self.helpers.setPrefix(self.helpers.formatForClasses(event.target.value), 'variables', false)})`;
        const event2 = new Event('input', {
            bubbles: true,
            cancelable: true,
        });
        target.dispatchEvent(event2);
        self.openVariableCategory(group);
        self.addVariable(event);
        setTimeout(() => {
            const inputs = document.querySelectorAll('.brxc-theme-variable-list input[type="text"].variable-value');
            if(!inputs || inputs.length < 1) return;
            const input = inputs[inputs.length - 1];
            const end = input.value.length;
            input.setSelectionRange(end, end);
            input.focus();

        }, 5)
    },
    importVariables: function(){
        const self = this;
        const value = document.querySelector('#addNewVariableCSS').value;
        const cssVariablePattern = /(--[\w-]+):\s*([^;]+);/g;
        const parsedValue = value ? value.replaceAll('\n', '') : false;
        if (!parsedValue || parsedValue.length < 1) return;

        let importedVariables = 0;

        const matches = parsedValue.match(cssVariablePattern);
        if(!matches || !Array.isArray(matches) || matches.length < 1) return self.vueGlobalProp.$_showMessage(`No Matching Variables found`);

        self.helpers.createThemeVariable();
        const vars = self.vueState.themeStyleSettings.general._cssVariables;

        let newVariable;
        
        matches.forEach(match => {
            const matchResult = match.match(cssVariablePattern);
            if (!matchResult) return;
            const split = matchResult[0].split(':');
            const name = split[0].substr(2);
            const value = split[1].trimStart().replaceAll(';', '');
            const formattedName = self.helpers.formatForClasses(name);

            if (value.includes('clamp(')) {

                function remToPx(remValue, rootFontSize) {
                    const pxValue = remValue * rootFontSize;
                    return pxValue;
                }

                // Root
                let rootFontSize;
                if (typeof self.vueState.themeStyleSettings === "object" && self.vueState.themeStyleSettings.hasOwnProperty("typography") && self.vueState.themeStyleSettings.typography.hasOwnProperty('typographyHtml')) {
                    const typographyHTML = self.vueState.themeStyleSettings.typography.typographyHtml;
                    if( typographyHTML ) {
                        rootFontSize = 16 * parseFloat(typographyHTML.replace('%','')) / 100;
                    } else{
                        rootFontSize = 10;
                    } 
                } else {
                    rootFontSize = 10;
                }

                let hasRem = true;

                // Extracting min and max values from the clamp function
                const clampValues = value.match(/clamp\((.*?)\)/)[1].split(',');

                if(!clampValues[0].includes('rem')) hasRem = false;
                const min = remToPx(parseFloat(clampValues[0]), rootFontSize);

                if(!clampValues[2].includes('rem')) hasRem = false;
                const max = remToPx(parseFloat(clampValues[2]), rootFontSize);

                if(hasRem){
                    newVariable = {
                        id: self.vueGlobalProp.$_generateId(),
                        group: self.cssVariablesStates.activeCategory,
                        name: formattedName,
                        order: self.vueState.themeStyleSettings.general._cssVariables.length,
                        type: 'clamp',
                        value: '',
                        min: min,
                        max: max,
                    };
                } else {
                    newVariable = {
                        id: self.vueGlobalProp.$_generateId(),
                        group: self.cssVariablesStates.activeCategory,
                        name: formattedName,
                        order: self.vueState.themeStyleSettings.general._cssVariables.length,
                        type: 'static',
                        value: value,
                    }
                }

            } else {
                
                newVariable = {
                    id: self.vueGlobalProp.$_generateId(),
                    group: self.cssVariablesStates.activeCategory,
                    name: formattedName,
                    order: self.vueState.themeStyleSettings.general._cssVariables.length,
                    type: 'static',
                    value: value,
                }
            }

            vars.push(newVariable);

            importedVariables++;

        })

        // Message
        if(importedVariables === 0){
            self.vueGlobalProp.$_showMessage(`No Variables found`);
        } else {
            self.vueGlobalProp.$_showMessage(`${importedVariables} Variables have been successfully imported`);
        }

        self.generateVariableCSS('theme');
        self.generateBuilderCSS();
        self.cssVariablesStates.importVariables = false;
        self.setCSSVariableManager(false);

    },
    renameVariable(event){
        if(event.key !== "Enter") return;
        const self = this;
        if(!self.helpers.isCSSVariablesTabActive('theme-variables') || !self.helpers.themeHasVariables()) return;
        const vars = self.vueState.themeStyleSettings.general._cssVariables;
        const row = event.target.closest('li');
        const variable = Array.from(vars).find(el => el && el.hasOwnProperty('id') && row.dataset.id && row.dataset.id === el.id);
        if(!variable) return;
        const oldName = variable.name;
        variable.name = event.target.value;

        self.vueGlobalProp.$_showMessage('Variable successfully renamed');
        self.generateVariableCSS('theme');
        self.generateBuilderCSS();
        self.setCSSVariableManager(false);
    },
    setVariableValue: function(event, type){
        const self = this;
        if(!self.helpers.isCSSVariablesTabActive('theme-variables') || !self.helpers.themeHasVariables()) return;
        const vars = self.vueState.themeStyleSettings.general._cssVariables;
        const row = event.target.closest('li');
        const variable = Array.from(vars).find(el => el && el.hasOwnProperty('id') && row.dataset.id && row.dataset.id === el.id);
        if(!variable) return;
        variable[type] = event.target.value;
        if (self.debounceTimer) {
            clearTimeout(self.debounceTimer);
        }

        self.debounceTimer = setTimeout(() => {
            self.generateVariableCSS('theme');
            self.generateBuilderCSS();
        }, 300)
        
    },
    toggleTypeSwitch: function(id){
        const self = this;
        if(!id || !self.helpers.isCSSVariablesTabActive('theme-variables') || !self.helpers.themeHasVariables()) return;
        const vars = self.vueState.themeStyleSettings.general._cssVariables;
        const variable = Array.from(vars).find(el => el && el.hasOwnProperty('id') && el.id === id);
        if (!variable || !variable.hasOwnProperty('type')) return;
        variable.type = variable.type === 'static' ? 'clamp' : 'static';
        self.generateVariableCSS('theme');
        self.generateBuilderCSS();
        self.setCSSVariableManager(false);
    },
    toggleImportVariables: function(importCSS){
        const self = this;
        importCSS === 'true' ? self.cssVariablesStates.importVariables = false : self.cssVariablesStates.importVariables = true;
        self.setCSSVariableManagerBody();
    },
    // Color Manager
    colorStates:{
        activePalette: "",
        activeColor: false,
        colorManagerMode: "light",
        colorManagerSearch: "",
        colorManagerRenamePalette: false,
        colorManagerAddPalette: false,
        colorManagerShadePopup: false,
        colorManagerShadePopupId: false,
        colorManagerShadePopupLastId: false,
        colorManagerShadeNumber: 6,
        colorManagerShadeBaseName: false,
        colorManagerShadeCustom: false,
        colorManagerShadeLight: true,
        colorManagerShadeDark: true,
        colorManagerShadeTransparent: true,
        colorManagerShadeLightValid: true,
        colorManagerShadeDarkValid: true,
        colorManagerShadeTransparentValid: true,
        colorManagerShadeColors: ['#ffffff'],
        colorManagerShadeFinalColors: ['#ffffff'],
        colorManagerComplementaryPopup: false,
        colorManagerComplementaryPopupId: false,
        colorManagerComplementaryPopupLastId: false,
        colorManagerComplementaryBaseName: false,
        colorManagerComplementaryScheme: 'complementary',
        colorManagerComplementaryFinalColors: [],
        generatedCSS: false,
    },
    setColorManager: function(){
        const self = this;
        self.setColorManagerHeader();
        self.setColorManagerSearch();
        self.setColorManagerBody();
    },
    setFavoritePalette: function(){
        const self = this;
        const palettes = self.vueState.colorPalette;
        const activePalette = Array.from(palettes).find(el => el && el.hasOwnProperty('id') && el.id === self.colorStates.activePalette);
        const defaultPalette = Array.from(palettes).find(el => el && el.hasOwnProperty('default') && el.default === "true");
        if(activePalette && defaultPalette && activePalette === defaultPalette){
            delete defaultPalette.default;
            self.vueGlobalProp.$_showMessage('Color Palette successfully removed as default!');
        } else {
            if(defaultPalette) delete defaultPalette.default;
            activePalette.default = "true";
            self.vueGlobalProp.$_showMessage('Color Palette successfully set as default!');
        }
        self.setColorManagerHeader();

    },
    togglePaletteStatus: function(){
        const self = this;
        const palettes = self.vueState.colorPalette;
        const palette = Array.from(palettes).find(el => el && el.hasOwnProperty('id') && el.id == self.colorStates.activePalette)
        if(!palette) return;

        !palette.hasOwnProperty('status') || palette.status !== "disabled" ? palette.status = "disabled" : palette.status = "enabled";
        self.generateColorCSS();
        self.generateBuilderCSS();
        self.setColorManagerHeader();
    },
    setColorManagerHeader: function(){
        const self = this;
        let content = '';
        const palettes = self.vueState.colorPalette;
        if(palettes.length < 1) return;
        const palette = Array.from(palettes).find(el => el && el.hasOwnProperty('id') && el.id == self.colorStates.activePalette)
        content += `<div class="brxc-select">`;
        content += (self.colorStates.colorManagerMode === 'dark') ? `<div class="brxc-darkmode active" data-balloon="Switch to Lightmode" data-balloon-pos="right" onclick="ADMINBRXC.darkMode()"><i class="ion-ios-moon"></i></div>` : `<div class="brxc-darkmode" data-balloon="Switch to Darkmode" data-balloon-pos="right"onclick="ADMINBRXC.darkMode()"><i class="ion-ios-sunny"></i></div>`;
        if(self.colorStates.colorManagerRenamePalette === false && self.colorStates.colorManagerAddPalette === false){
            content += `<select name="brxc-colorPaletteOptions" id="colorPaletteOptions" class="brxc-colorPaletteOptions" value="${palette.name}" onChange="ADMINBRXC.colorStates.colorManagerSearch = '';ADMINBRXC.colorStates.activePalette = this.value;ADMINBRXC.setColorManagerSearch();ADMINBRXC.setColorManagerHeader();ADMINBRXC.setColorManagerBody();">`;
            palettes.forEach(pal => {
                content += `<option value="${pal.id}"${pal.id === self.colorStates.activePalette ? ' selected="selected"' : ''}>${pal.name}</option>`;
            })
            content += `</select>`;
            content += '<div class="brxc-icon-container">'
            content += `<div class="brxc-icon${palette.hasOwnProperty('default') && palette.default === "true" ? ' active' : ''}" data-balloon="Set as Default" data-balloon-pos="bottom-right" onClick="ADMINBRXC.setFavoritePalette();"><span class="bricks-svg-wrapper"><i class="fas fa-star"></i></span></div>`;
            content += `<div class="brxc-icon" data-balloon="Rename Palette" data-balloon-pos="bottom-right" onClick="ADMINBRXC.colorStates.colorManagerRenamePalette = true;ADMINBRXC.setColorManagerHeader()"><span class="bricks-svg-wrapper"><i class="fas fa-pen"></i></span></div>`;
            content += `<div class="brxc-icon" data-balloon="Add New Palette" data-balloon-pos="bottom-right" onClick="ADMINBRXC.colorStates.colorManagerAddPalette = true;ADMINBRXC.setColorManagerHeader()"><span class="bricks-svg-wrapper"><i class="fas fa-plus"></i></span></div>`;
            content += `<div class="brxc-icon" data-balloon="Duplicate Palette" data-balloon-pos="bottom-right" onClick="ADMINBRXC.duplicatePalette();"><span class="bricks-svg-wrapper"><i class="fas fa-clone"></i></span></div>`;
            content += `<div class="brxc-icon" data-balloon="Delete Palette" data-balloon-pos="bottom-right" onClick="ADMINBRXC.setDeleteVariable(this, 'ADMINBRXC.deletePalette();');"><span class="bricks-svg-wrapper"><i class="ti-trash"></i></span></div>`;
            content += `</div>`;
            content += `<div class="brxc-toggle-palette"><div class="" data-balloon="${!palette.hasOwnProperty('status') || palette.status !== "disabled" ? "Disable Palette" : "Enable Palette"}" data-balloon-pos="bottom-right" onclick="ADMINBRXC.togglePaletteStatus()">`;
            content += !palette.hasOwnProperty('status') || palette.status !== "disabled" ? `<i class="fas fa-toggle-on"></i>` : `<i class="fas fa-toggle-off"></i>`;
            content += `</div></div>`;
        } else if(self.colorStates.colorManagerRenamePalette === true){
            content += `<input type="text" id="brxcRenamePalette" value="${palette.name}" />`;
        } else if(self.colorStates.colorManagerAddPalette === true){
            content += `<input type="text" id="brxcAddPalette" placeholder="Type the color palette's name here and hit ENTER." value="" />`;
        }
        content += `</div>`;

        const canvas = document.querySelector('#colorHeaderCanvas')
        if(canvas && content) canvas.innerHTML = content;

        // Rename
        if (self.colorStates.colorManagerRenamePalette === true) {
            self.colorStates.colorManagerRenamePalette = false;
            const input = canvas.querySelector('#brxcRenamePalette');
            if (!input) return;
            const end = input.value.length;
            input.setSelectionRange(end, end);
            input.focus();

            function saveName(input) {
                const palette = Array.from(palettes).find(el => el && el.hasOwnProperty('id') && el.id == self.colorStates.activePalette);
                if (palette.name !== input.value) {
                    palette.name = input.value;
                    self.vueGlobalProp.$_showMessage('Color Palette correctly renamed!');
                }
                setTimeout(() => {
                    self.setColorManager();
                }, 10);
            }

            const onBlur = () => {
                saveName(input);
                input.removeEventListener("blur", onBlur);
                input.removeEventListener("keydown", onKeyDown);
                setTimeout(() => {
                    self.setColorManagerHeader();
                }, 10);
            };

            const onKeyDown = (event) => {
                if (event.key === "Enter") {
                    saveName(input);
                    input.removeEventListener("blur", onBlur);
                    input.removeEventListener("keydown", onKeyDown);
                }
            };

            input.addEventListener("blur", onBlur);
            input.addEventListener("keydown", onKeyDown);
        }


        // Add
        if (self.colorStates.colorManagerAddPalette === true) {
            self.colorStates.colorManagerAddPalette = false;
            const input = canvas.querySelector('#brxcAddPalette');
            if (!input) return;
            const end = input.value.length;
            input.setSelectionRange(end, end);
            input.focus();
            const newId = self.vueGlobalProp.$_generateId();

            function addName(input) {
                const newPalette = {
                    id: newId,
                    name: input.value,
                    colors: []
                };
                palettes.push(newPalette);
                self.colorStates.activePalette = newId;
                self.vueGlobalProp.$_showMessage('Color Palette successfully created!');
                self.setColorManager();
            }

            const onBlur = () => {
                input.removeEventListener("blur", onBlur);
                input.removeEventListener("keydown", onKeyDown);
                setTimeout(() => {
                    self.setColorManagerHeader();
                }, 10);
            };

            const onKeyDown = (event) => {
                if (event.key === "Enter") {
                    addName(input);
                    input.removeEventListener("blur", onBlur);
                    input.removeEventListener("keydown", onKeyDown);
                }
            };

            input.addEventListener("blur", onBlur);
            input.addEventListener("keydown", onKeyDown);
        }
    },
    duplicatePalette: function () {
        const self = this;
        const palettes = self.vueState.colorPalette;
        const activePalette = palettes.find(el => el && el.hasOwnProperty('id') && el.id === self.colorStates.activePalette);

        function reassignNewIds(arr) {
            const idMap = new Map();
        
            // Process parents first
            for (const parent of arr.filter(el => el && el.hasOwnProperty('shadeChildren') && el.shadeChildren && el.shadeChildren.length > 0)) {
                const newId = self.vueGlobalProp.$_generateId();
                idMap.set(parent.id, newId);
                parent.id = newId;
        
                for (const childId of parent.shadeChildren) {
                    const child = arr.find(el => el && el.id === childId);
                    if (child) {
                        child.shadeParent = newId;
                    }
                }
                parent.shadeChildren.length = 0;
            }
        
            // Process children
            for (const child of arr.filter(el => el && !el.hasOwnProperty('shadeChildren'))) {
                const newId = self.vueGlobalProp.$_generateId();
                idMap.set(child.id, newId);
                child.id = newId;
                if(child.hasOwnProperty('shadeParent')){
                    const parent = arr.find(el => el && el.id === child.shadeParent);
                    if (parent) {
                        parent.shadeChildren.push(newId);
                    }
                }
                
            }
            return arr;
        }
    
        if (activePalette) {
            const duplicate = {
                ...activePalette,
                id: self.vueGlobalProp.$_generateId(),
                name: activePalette.name + ' (Copy)',
            };
            duplicate.colors = reassignNewIds(JSON.parse(JSON.stringify(duplicate.colors)));
            if(duplicate.hasOwnProperty('default')) delete duplicate.default;
    
            palettes.push(duplicate);
            self.colorStates.activePalette = duplicate.id;
            self.vueGlobalProp.$_showMessage('Color Palette successfully duplicated!');
            self.setColorManager();
        }
        
    },
    deletePalette: function(){
        const self = this;
        const palettes = self.vueState.colorPalette;
        const activePalette = Array.from(palettes).find(el => el && el.hasOwnProperty('id') && el.id === self.colorStates.activePalette);
        
        palettes.splice(palettes.indexOf(activePalette), 1);
        self.colorStates.activePalette = (self.vueState.colorPalette[0]) ? self.vueState.colorPalette[0].id : '';

        self.vueGlobalProp.$_showMessage('Color Palette successfully deleted!');
        self.generateColorCSS();
        self.generateBuilderCSS();
        self.setColorManager();

    },
    setColorManagerSearch: function(){
        const self = this;
        const palettes = self.vueState.colorPalette;
        const activePalette = Array.from(palettes).find(el => el && el.hasOwnProperty('id') && el.id === self.colorStates.activePalette);
        const canvas = document.querySelector('#colorSearchCanvas');
        if(!activePalette || !activePalette.hasOwnProperty('colors') || !Array.isArray(activePalette.colors) || activePalette.colors.length < 2) return canvas.innerHTML = '';
        let content = `<div class="brxc-overlay__search-box">
                        <input type="search" class="class-filter" name="class-search" placeholder="Filter by color name" data-type="title" value="${self.colorStates.colorManagerSearch}" oninput="ADMINBRXC.colorStates.colorManagerSearch = this.value;ADMINBRXC.setColorManagerBody();">
                        <div class="iso-search-icon">
                            <i class="bricks-svg ti-search"></i>
                        </div>
                        <div class="iso-reset" data-balloon="Reset Filter" data-balloon-pos="bottom-right" onclick="ADMINBRXC.colorStates.colorManagerSearch = '';ADMINBRXC.setColorManagerSearch();ADMINBRXC.setColorManagerBody();">
                            <i class="bricks-svg ti-close"></i>
                        </div>
                      </div>`;
        canvas.innerHTML = content;
    },
    setColorManagerBody: function(){
        const self = this;
        self.resetStates();
        const mode = self.colorStates.colorManagerMode;
        const canvas = document.querySelector('#colorBodyCanvas');
        const palettes = self.vueState.colorPalette;
        const activePalette = Array.from(palettes).find(el => el && el.hasOwnProperty('id') && el.id === self.colorStates.activePalette);
        if(!activePalette) return;
        if(!activePalette.hasOwnProperty('colors') ) activePalette.colors = {};
        let colors = activePalette.colors;
        
        // Search
        colors = (self.colorStates.colorManagerSearch === '') ? colors : Array.from(colors).filter(el => el && el.name.includes(self.colorStates.colorManagerSearch));


        function checkRow(obj,hasRaw){
            if(!hasRaw){
                if(obj.hasOwnProperty('hsl')){
                    return obj.hsl;
                } else if(obj.hasOwnProperty('rgb')){
                    return obj.rgb;
                } else if (obj.hasOwnProperty('hex')){
                    return obj.hex;
                }
            } else {
                //const mode = self.colorStates.colorManagerMode;
                if(obj.hasOwnProperty('raw') && obj.hasOwnProperty('rawValue') && obj.rawValue.hasOwnProperty(mode)){
                    return obj.rawValue[mode];
                } else if (mode === "dark" && obj.hasOwnProperty('raw') && obj.hasOwnProperty('rawValue') && obj.rawValue.hasOwnProperty("light")){
                    return obj.rawValue.light
                } else if(obj.hasOwnProperty('raw')){
                    return obj.raw;
                } else {
                    return '#ff0000';
                }
            }
        }

        let content = '<ul class="brxc-color-list">';
        let ind = 0;
        for(const key of Object.keys(colors)){
            const hasRaw = colors[key].hasOwnProperty('raw');
            const hasRawValue = colors[key].hasOwnProperty('rawValue');
            const isShade = colors[key].hasOwnProperty('isShade') && colors[key].hasOwnProperty('shadeParent') && colors[key].shadeParent;

            // Hide if parent is not expanded
            const hasShadeParent = colors[key].hasOwnProperty('shadeParent');
            const parent = hasShadeParent ? Array.from(colors).find(el => el && el.hasOwnProperty('id') && el.id === colors[key].shadeParent) : false;
            if(parent && parent.hasOwnProperty('isExpanded') && parent.isExpanded !== true) continue;

            const isFramework = self.helpers.isFramework(colors[key].id);
            content += `<li data-order="${ind}" class="${(self.colorStates.colorManagerShadePopup === true && self.colorStates.colorManagerShadePopupId === colors[key].id) || (self.colorStates.colorManagerComplementaryPopup === true && self.colorStates.colorManagerComplementaryPopupId === colors[key].id) ? 'active' : ''}${mode === "light" && isFramework ? ' framework' : ''}${!hasRaw ? ' disable' : ''}"><div class="color-wrapper">`;
            content += `<div class="handle"><i class="ti-move"></i></div>`;
            content += `<div class="btn-color-wrapper"><button class="brxc-color-input${mode === "light" && isFramework ? '-framework' : ''} main-color" data-id="${colors[key].id}" data-initial-color="${checkRow(colors[key],hasRaw)}" data-balloon="${checkRow(colors[key],hasRaw)}" data-balloon-pos="top-left" style="background:${checkRow(colors[key],hasRaw)};"></button>`
            content += colors[key].hasOwnProperty('raw') && self.helpers.isVarActiveOnPage(colors[key].raw) ? `<div class="btn-color-check" data-balloon="active on the page" data-balloon-pos="right"><i class="fas fa-check"></i></i></div></div>` : '</div>';
            content += `<input type="text" class="color-name${hasRaw && !hasRawValue && isFramework && self.colorStates.colorManagerMode === "dark" ? ' inactive':''}" value="${colors[key].name}" />`;
            content += `<div class="actions">`;

            if(hasRaw && hasRawValue && !isFramework){
                content += `<div class="brxc-icon" data-balloon="Rename" data-balloon-pos="bottom-right" onClick="ADMINBRXC.renameColor(event,'${colors[key].id}','${colors[key].name}');"><span class="bricks-svg-wrapper"><i class="fas fa-pen"></i></span></div>`;
                if(self.colorStates.colorManagerMode === "light" && !isShade) content += `<div class="brxc-icon${self.colorStates.colorManagerComplementaryPopup === true && self.colorStates.colorManagerComplementaryPopupId === colors[key].id ? ' active' : ''}" data-balloon="Generate Complementary Colors" data-balloon-pos="bottom-right" onClick='ADMINBRXC.colorStates.activeColor = ${JSON.stringify(colors[key])};ADMINBRXC.setComplementaryWrapper("${self.colorStates.colorManagerComplementaryPopup}","${colors[key].id}");'><span class="bricks-svg-wrapper"><i class="fas fa-palette"></i></span></div>`;
                if(self.colorStates.colorManagerMode === "light" && !isShade) content += `<div class="brxc-icon${self.colorStates.colorManagerShadePopup === true && self.colorStates.colorManagerShadePopupId === colors[key].id ? ' active' : ''}" data-balloon="Generate Shades" data-balloon-pos="bottom-right" onClick='ADMINBRXC.colorStates.activeColor = ${JSON.stringify(colors[key])};ADMINBRXC.setShadesWrapper("${self.colorStates.colorManagerShadePopup}","${colors[key].id}");'><span class="bricks-svg-wrapper"><i class="fas fa-wand-magic-sparkles"></i></span></div>`;
                if(self.colorStates.colorManagerMode === "dark") content += `<div class="brxc-icon" data-balloon="Convert to Dark Color" data-balloon-pos="bottom-right" onClick="ADMINBRXC.convertDarkColor('${colors[key].id}');"><span class="bricks-svg-wrapper"><i class="fas fa-right-left"></i></span></div>`;
                content += `<div class="brxc-icon" data-balloon="Duplicate" data-balloon-pos="bottom-right" onClick="ADMINBRXC.duplicateColor('${colors[key].id}');"><span class="bricks-svg-wrapper"><i class="fas fa-clone"></i></span></div>
                            <div class="brxc-icon" data-balloon="Copy to Clipboard" data-balloon-pos="bottom-right" onClick="ADMINBRXC.copytoClipboardSimple('${colors[key].raw}','${colors[key].raw} successfully copied to clipboard');"><span class="bricks-svg-wrapper"><i class="fas fa-clipboard"></i></span></div>
                            <div class="brxc-icon" data-balloon="Delete" data-balloon-pos="bottom-right" onClick="ADMINBRXC.setDeleteColor('${colors[key].id}', this)"><span class="bricks-svg-wrapper"><i class="ti-trash"></i></span></div>`;
            } else if(hasRaw && hasRawValue && isFramework && self.colorStates.colorManagerMode === "dark"){
                content += `<div class="brxc-icon" data-balloon="Remove Dark Color" data-balloon-pos="bottom-right" onClick="ADMINBRXC.removeRawValue('${colors[key].id}', this)"><span class="bricks-svg-wrapper"><i class="ti-trash"></i></span></div>`;
            } else if(!hasRaw && !isFramework){
                content += `<div class="brxc-icon" data-balloon="Convert to a CSS variable" data-balloon-pos="left" onClick="ADMINBRXC.convertColor('${colors[key].id}');"><span class="bricks-svg-wrapper"><i class="fas fa-right-left"></i></span></div>`;
            } else if(hasRaw && isFramework){
                content += `<div class="brxc-icon" data-balloon="Copy to Clipboard" data-balloon-pos="bottom-right" onClick="ADMINBRXC.copytoClipboardSimple('${colors[key].raw}','${colors[key].raw} successfully copied to clipboard');"><span class="bricks-svg-wrapper"><i class="fas fa-clipboard"></i></span></div>`;
            }

            content += `</div>`;

            if(colors[key].hasOwnProperty('shadeChildren') && Array.isArray(colors[key].shadeChildren) && colors[key].shadeChildren.length > 0){
                content += `<div class="actions always-visible">`;
                content += `<div class="brxc-icon" data-balloon="${colors[key].hasOwnProperty('isExpanded') && colors[key].isExpanded === true ? 'Hide' : 'Show'} Shades" data-balloon-pos="bottom-right" onClick="ADMINBRXC.toggleExpandShades('${colors[key].id}');"><span class="bricks-svg-wrapper"><i class="fas fa-${colors[key].hasOwnProperty('isExpanded') && colors[key].isExpanded === true ? 'minus' : 'plus'}"></i></span></div>`;
                content += `</div>`;
            } else if(colors[key].hasOwnProperty('shadeParent') && colors[key].shadeParent){
                content += `<div class="actions always-visible">`;
                content += `<div class="brxc-icon links${!colors[key].hasOwnProperty('isShade') || colors[key].isShade !== true ? ' unlinked' : ''}" data-balloon="${colors[key].hasOwnProperty('isShade') && colors[key].isShade === true ? 'Unlink' : 'Link'} to parent color" data-balloon-pos="bottom-right" onClick="ADMINBRXC.toggleLinkShades('${colors[key].id}');"><span class="bricks-svg-wrapper"><i class="fas fa-${colors[key].hasOwnProperty('isShade') && colors[key].isShade === true ? 'link' : 'link-slash'}"></i></span></div>`;
                content += `</div>`;
            }

            content += `</div>`;
            // Shade popup
            if(self.colorStates.colorManagerShadePopup === true && self.colorStates.colorManagerShadePopupId === colors[key].id){
                content += self.setShadesForm(colors[key].id);
            }

            // Complementary popup
            if(self.colorStates.colorManagerComplementaryPopup === true && self.colorStates.colorManagerComplementaryPopupId === colors[key].id){
                content += self.setComplementaryForm(colors[key].id);
            }
            content += `</li>`;
            ind++;
        }

        content += '</ul>';
        if(!self.helpers.isFramework(activePalette.id)) {
            content += `<div class="brxc-add-color-wrapper">`;
            content += `<div class="brxc-import-css-colors${self.colorStates.colorManagerImportCSSVariables === true ? ' active' : ''}" data-balloon="Import CSS variables" data-balloon-pos="bottom-left" onclick="ADMINBRXC.toggleImportColorVariables('${self.colorStates.colorManagerImportCSSVariables === true ? 'true' : 'false'}');"><i class="fas fa-code"></i></div> `;
            content += self.colorStates.colorManagerImportCSSVariables === true ? `<textarea id="addNewColorCSS" rows="20" placeholder="Paste your CSS variables here"></textarea>` : `<input type="text" id="addNewColor" placeholder="Add a new color" onkeyup="ADMINBRXC.addNewColor(event);" />`;
            content += `</div>`;
            if(self.colorStates.colorManagerImportCSSVariables === true){
                content += `<a class="brxc-overlay__action-btn primary" style="margin-right:16px;margin-left:auto;" onclick="ADMINBRXC.importColorVariables();"><span>Import Colors</span></a>`;
            }
        }
        canvas.innerHTML = content;

        // Color Picker
        const btnMain = canvas.querySelectorAll('li .brxc-color-input.main-color');
        btnMain.forEach(el => {
            const mode = self.colorStates.colorManagerMode;
            let picker = new ColorPicker(el, el.dataset.initialColor);
    
      
            el.addEventListener('colorChange', self.debounce((event) => {
                const colorPickr = document.querySelector('#color_picker');
                const display = window.getComputedStyle(colorPickr).getPropertyValue("display");
                if(display && display === "none") self.setColorManagerBody();
                const color = event.detail.color.hsla;
                self.updateColor(color, event.target.dataset.id, mode);
            }, 100))
        })

        if(self.colorStates.colorManagerShadePopup === true) self.setScalePicker();

        //Drag and drop
        if(self.colorStates.colorManagerShadePopup !== true){
            const colorWrapper = canvas.querySelector('ul');
            function move(arr, from, to, on = 1) {
                return arr.splice(to, 0, ...arr.splice(from, on)), arr
            }
            new Sortable(colorWrapper, {
                multiDrag: true,
                selectedClass: "sortable-selected",
                animation: 150,
                handle: "li .handle",
                helper : 'clone',
                onEnd: function () {
                    const palette = Array.from(self.vueState.colorPalette).find(el => el && el.hasOwnProperty('id') && el.id === self.colorStates.activePalette);  
                    const items = Array.from(colorWrapper.children);
                    const reorderedColors = [];
                    const newOrder = items.map(item => parseInt(item.getAttribute('data-order')));
                    newOrder.forEach(el => {
                        reorderedColors.push(palette.colors[el])
                    })
                    palette.colors = reorderedColors;
                    self.vueGlobalProp.$_showMessage('Color order successfully changed');
                    self.setColorManager();
                    self.helpers.saveChanges('colorPalette');
                },
            })
        }

        // close when clicked outside
        const popup = document.querySelector('.bricks-control-popup');

        function closePopup() {
            document.removeEventListener('click', clickOutsideHandler);
        }

        function clickOutsideHandler(event) {
            if (!popup.contains(event.target)) {
                closePopup();
            }
        }
        function openPopup() {
            document.addEventListener('click', clickOutsideHandler);
        }
        if (popup) openPopup();

        // Reset values
        self.colorStates.colorManagerShadePopup = false;
        self.colorStates.colorManagerShadePopupId = false;
        self.colorStates.colorManagerComplementaryPopup = false;
        self.colorStates.colorManagerComplementaryPopupId = false;
        
    },
    toggleLinkShades: function(colorId){
        const self = this;
        const palettes = self.vueState.colorPalette;
        const palette = Array.from(palettes).find(el => el && el.hasOwnProperty('id') && el.id == self.colorStates.activePalette)
        const color = Array.from(palette.colors).find(el => el && el.hasOwnProperty('id') && el.id === colorId);
        if(!color.hasOwnProperty('isShade')) return;
        color.isShade === true ? color.isShade = false : color.isShade = true;
        self.setColorManagerBody();
    },
    toggleExpandShades: function(colorId){
        const self = this;
        const palettes = self.vueState.colorPalette;
        const palette = Array.from(palettes).find(el => el && el.hasOwnProperty('id') && el.id == self.colorStates.activePalette)
        const color = Array.from(palette.colors).find(el => el && el.hasOwnProperty('id') && el.id === colorId);
        if(!color.hasOwnProperty('isExpanded')) return;
        color.isExpanded === true ? color.isExpanded = false : color.isExpanded = true;
        self.setColorManagerBody();
    },
    toggleImportColorVariables: function(importCSS){
        const self = this;
        importCSS === 'true' ? self.colorStates.colorManagerImportCSSVariables = false : self.colorStates.colorManagerImportCSSVariables = true;
        self.setColorManagerBody();

    },
    importColorVariables: function(){
        const self = this;
        const value = document.querySelector('#addNewColorCSS').value;
        const cssVariablePattern = /(--[\w-]+):\s*([^;]+);/g;
        const parsedValue = value ? value.replaceAll('\n', '') : false;
        if (!parsedValue || parsedValue.length < 1) return;

        const palettes = self.vueState.colorPalette;
        const palette = Array.from(palettes).find(el => el && el.hasOwnProperty('id') && el.id == self.colorStates.activePalette)


        let incorrectColor = 0;
        let importedColors = 0;

        const matches = parsedValue.match(cssVariablePattern);
        if(!matches || !Array.isArray(matches) || matches.length < 1) return self.vueGlobalProp.$_showMessage(`No Matching Colors found`);

        matches.forEach(match => {
            const matchResult = match.match(cssVariablePattern);
            const split = matchResult[0].split(':');
            const name = split[0].substr(2);
            const value = split[1].trimStart().replaceAll(';', '');
            if (!chroma.valid(value)) return incorrectColor++;

            const formattedName = self.helpers.formatForClasses(name);
            const raw = `var(--${self.helpers.setPrefix(formattedName, 'colors', self.helpers.isFramework(false))}`;
            const id = self.vueGlobalProp.$_generateId();
            const lightness = chroma(value).get('hsl', 'l');
            const colorDark = lightness ? chroma(value).set('hsl.l', 1 - lightness[2]).css('hsla') : false;

            const newColor = {
                id: id,
                name: formattedName,
                raw: raw,
                rawValue: {
                    light: value,
                },
                isExpanded: true,
                shadeChildren: [],
                complementaryChildren: [],
            };

            colorDark ? (newColor.rawValue.dark = colorDark) : '';

            palette.colors.push(newColor);
            importedColors++;
        });

        
        // Message
        if(importedColors === 0 && incorrectColor > 0){
            self.vueGlobalProp.$_showMessage(`No Matching Colors found<br>${incorrectColor} variables have been skipped due to incorrect color format`);
        } else if(importedColors === 0){
            self.vueGlobalProp.$_showMessage(`No Matching Colors found`);
        } else if(importedColors > 0 && incorrectColor > 0){
            self.vueGlobalProp.$_showMessage(`${importedColors} Colors have been successfully imported<br>${incorrectColor} variables have been skipped due to incorrect color format`);
        } else {
            self.vueGlobalProp.$_showMessage(`${importedColors} Colors have been successfully imported`);
        }

        setTimeout(() => {
            self.setColorManagerSearch();
            self.setColorManagerBody();
            self.generateColorCSS();
            self.generateBuilderCSS();
        }, 10);
    },

    convertColor: function(colorId){
        const self = this;
        const palettes = self.vueState.colorPalette;
        const palette = Array.from(palettes).find(el => el && el.hasOwnProperty('id') && el.id == self.colorStates.activePalette)
        const obj = Array.from(palette.colors).find(el => el && el.hasOwnProperty('id') && el.id === colorId);
        
        let col = '';
        ['hex','rgb','hsl'].forEach(format => {
            if(obj.hasOwnProperty(format)){
                col = obj[format];
                delete obj[format];
            }
        })
        obj.name = self.helpers.formatForClasses(obj.name)
        obj.raw = `var(--${self.helpers.setPrefix(obj.name, 'colors', self.helpers.isFramework(obj.id))})`;
        obj.rawValue = {
            light: col
        }

        self.generateColorCSS();
        self.generateBuilderCSS();
        self.setColorManagerBody();


    },
    convertDarkColor: function(colorId){
        const self = this;
        const palettes = self.vueState.colorPalette;
        const palette = Array.from(palettes).find(el => el && el.hasOwnProperty('id') && el.id == self.colorStates.activePalette)
        const obj = Array.from(palette.colors).find(el => el && el.hasOwnProperty('id') && el.id === colorId);

        const lightColor = (obj.hasOwnProperty('rawValue') && obj.rawValue.hasOwnProperty('light')) ? chroma(obj.rawValue.light).get('hsl.l') : false;
        if (lightColor) obj.rawValue.dark = chroma(obj.rawValue.light).set('hsl.l', 1 - lightColor).css('hsla');;

        self.generateColorCSS();
        self.generateBuilderCSS();
        self.setColorManagerBody();
    },
    resetStates: function(){
        const self = this;
        //self.colorStates.colorManagerShadeNumber = 6,
        self.colorStates.colorManagerShadeBaseName = false;
        const mode = self.colorStates.colorManagerMode;
        if (self.colorStates.activeColor.hasOwnProperty('raw') && self.colorStates.activeColor.hasOwnProperty('rawValue') && self.colorStates.activeColor.rawValue.hasOwnProperty(mode)) self.colorStates.colorManagerShadeColors = [self.colorStates.activeColor.rawValue[mode]];
        self.colorStates.colorManagerShadeFinalColors = ['#ffffff'];
    },
    shadesSlider: function(event){
        const self = this;
        self.colorStates.colorManagerShadeNumber = parseInt(event.target.value);;
        self.setDynamicScaleCanvas();
    },
    addPreviousScaleColor: function(){
        const self = this;
        self.colorStates.colorManagerShadeColors.unshift(self.colorStates.colorManagerShadeColors[0]);
        const canvasScale = document.querySelector('#scaleCanvas');
        canvasScale.innerHTML = self.setColorScale();
        const canvasPreview = document.querySelector('#previewCanvas');
        canvasPreview.innerHTML = self.setColorPreview();
        self.setScalePicker();
    },
    addNextScaleColor: function(){
        const self = this;
        self.colorStates.colorManagerShadeColors.push(self.colorStates.colorManagerShadeColors[self.colorStates.colorManagerShadeColors.length - 1]);
        const canvasScale = document.querySelector('#scaleCanvas');
        canvasScale.innerHTML = self.setColorScale();
        const canvasPreview = document.querySelector('#previewCanvas');
        canvasPreview.innerHTML = self.setColorPreview();
        self.setScalePicker();
    },
    setScalePicker: function(){
        const self = this;
        const canvas = document.querySelector('#scaleCanvas');
        if(!canvas) return;
        const btnScales = canvas.querySelectorAll('.scale-color');
        if(!btnScales) return;

        // Picker
        btnScales.forEach(el => {
            let picker = new ColorPicker(el, el.dataset.initialColor);
            el.addEventListener('colorChange', self.debounce((event) => {
                const color = event.detail.color.hsla;
                self.colorStates.colorManagerShadeColors[el.dataset.index] = color;
                const canvasPreview = document.querySelector('#previewCanvas');
                canvasPreview.innerHTML = self.setColorPreview();
            }, 100))
        })

        //Drag and drop
        const scaleWrapper = canvas.querySelector('.scale-wrapper');
        function move(arr, from, to, on = 1) {
            return arr.splice(to, 0, ...arr.splice(from, on)), arr
        }
        new Sortable(scaleWrapper, {
            animation: 150,
            handle: ".scale-color",
            helper : 'clone',
            onEnd: function (evt) {
                if(evt.oldIndex !== evt.newIndex){
                    move(self.colorStates.colorManagerShadeColors, evt.oldIndex -1, evt.newIndex -1);
                    const canvasPreview = document.querySelector('#previewCanvas');
                    canvasPreview.innerHTML = self.setColorPreview();
                }
            },
        })
    },
    deleteScaleColor: function(btn){
        const self = this;
        const index = Array.from(document.querySelectorAll('.brxc-color-input.scale-color')).indexOf(btn)
        self.colorStates.colorManagerShadeColors.splice(index, 1);
        const canvasScale = document.querySelector('#scaleCanvas');
        canvasScale.innerHTML = self.setColorScale();
        const canvasPreview = document.querySelector('#previewCanvas');
        canvasPreview.innerHTML = self.setColorPreview();
        self.setScalePicker();
    },
    setColorScale: function(){
        const self = this;
        let content = '';
        content += `<div class="control-inner control-inline">`;
        content += `<label class="has-tooltip"><span>Color Scale</span><div data-balloon="Choose the colors that compose the color scale." data-balloon-pos="bottom-left" data-balloon-length="medium"><i class="fas fa-circle-question"></i></div></label>`;
        content += `<div class="scale-wrapper">`;
        content += `<div class="dotted-border" data-balloon="Add previous color" data-balloon-pos="top-left" onclick="ADMINBRXC.addPreviousScaleColor();"><i class="fas fa-plus"></i></div>`;
        index = 0;
        self.colorStates.colorManagerShadeColors.forEach(color => {
            content += `<button class="brxc-color-input scale-color" data-index="${index}" data-initial-color="${color}" style="background:${color};">`;
            if(self.colorStates.colorManagerShadeColors.length > 1) content += `<div class="delete-scale-color" data-balloon="Delete" data-balloon-pos="top" onclick="event.preventDefault();event.stopPropagation();ADMINBRXC.deleteScaleColor(this.parentElement);"><i class="fas fa-xmark"></i></div>`;
            content += `</button>`
            index++;
        })
        content += `<div class="dotted-border" data-balloon="Add next color" data-balloon-pos="top-right" onclick="ADMINBRXC.addNextScaleColor();"><i class="fas fa-plus"></i></div>`;
        content += `</div></div>`;
        return content;

    },
    changeColorScheme: function(){
        const self = this;
        const canvas = document.querySelector('#previewComplementaryCanvas');
        canvas.innerHTML = self.setComplementaryColorPreview();

    },
    setColorPreview: function(){
        const self = this;
        const mode = self.colorStates.colorManagerMode;
        
        let content = '';
        content += `<div class="control-inner control-inline">`;
        content += `<label class="has-tooltip"><span>Preview</span><div data-balloon="Here is the preview of the shades that will be created." data-balloon-pos="bottom-left" data-balloon-length="medium"><i class="fas fa-circle-question"></i></div></label>`;
        content += `<div class="color-btn-wrapper">`;
        if (self.colorStates.activeColor.hasOwnProperty('raw') && self.colorStates.activeColor.hasOwnProperty('rawValue') && self.colorStates.activeColor.rawValue.hasOwnProperty(mode)) self.colorStates.colorManagerShadeColors.unshift(self.colorStates.activeColor.rawValue[mode]);
        const colors = chroma.scale(self.colorStates.colorManagerShadeColors)
                            .colors(parseInt(self.colorStates.colorManagerShadeNumber) + 1);
        let ind = 0;
        colors.forEach(color => {
            colors[ind] = chroma(color).css('hsl');
            ind++;
        })
        colors.shift();
        self.colorStates.colorManagerShadeFinalColors = colors;
        self.colorStates.colorManagerShadeColors.shift();
        let index = 0;
        colors.forEach(color => {
            content += `<button class="scale-color" data-index="${index}" data-initial-color="${color}" data-balloon="${color}" data-balloon-pos="top" style="background:${color};"></button>`;
            index++;
        })
        content += `</div></div>`;
        return content;
    },
    setDynamicScaleCanvas: function(){
        const self = this;
        const canvas = document.querySelector('#dynamicScaleCanvas');
        if(!canvas) return;
        canvas.innerHTML = self.dynamicScaleCanvas(self.colorStates.activeColor.id);
        self.setScalePicker();
    },
    dynamicScaleCanvas: function(colorId){
        const self = this;
        const palettes = self.vueState.colorPalette;
        const palette = Array.from(palettes).find(el => el && el.hasOwnProperty('id') && el.id == self.colorStates.activePalette)
        const color = Array.from(palette.colors).find(el => el && el.hasOwnProperty('id') && el.id === colorId);
        let content = `<div class="brxc-overlay__panel-inline-btns-wrapper" style="margin-top:16px;">
                            <input type="radio" id="brxc-custom-shade-toggle-auto" name="brxc-custom-shade-toggle" class="brxc-input__checkbox" value="0" onclick="ADMINBRXC.colorStates.colorManagerShadeCustom = false;ADMINBRXC.colorStates.colorManagerShadePopup = true;ADMINBRXC.colorStates.colorManagerShadePopupId = '${colorId}';ADMINBRXC.setDynamicScaleCanvas();"${self.colorStates.colorManagerShadeCustom !== true ? ' checked=""' : ''}>
                            <label for="brxc-custom-shade-toggle-auto" class="brxc-overlay__panel-inline-btns">Auto-Shades</label>
                            <input type="radio" id="brxc-custom-shade-toggle-custom" name="brxc-custom-shade-toggle" class="brxc-input__checkbox" value="1" onclick="ADMINBRXC.colorStates.colorManagerShadeCustom = true;ADMINBRXC.colorStates.colorManagerShadePopup = true;ADMINBRXC.colorStates.colorManagerShadePopupId = '${colorId}';ADMINBRXC.setDynamicScaleCanvas();"${self.colorStates.colorManagerShadeCustom === true ? ' checked=""' : ''}>
                            <label for="brxc-custom-shade-toggle-custom" class="brxc-overlay__panel-inline-btns">Custom Scales</label>
                        </div>`;
        if(self.colorStates.colorManagerShadeCustom !== true){
            let showButton = false;
            const children = Array.from(palette.colors).filter(el => el && el.hasOwnProperty('shadeParent') && el.shadeParent === colorId);
            const lightChildren = children && children.length > 0 ? Array.from(children).filter(el => el && el.hasOwnProperty('shadeType') && el.shadeType === "Light") : false;
            const darkChildren = children && children.length > 0 ? Array.from(children).filter(el => el && el.hasOwnProperty('shadeType') && el.shadeType === "Dark") : false;
            const transparentChildren = children && children.length > 0 ? Array.from(children).filter(el => el && el.hasOwnProperty('shadeType') && el.shadeType === "Transparent") : false;
            
            // Light
            if(!lightChildren || lightChildren.length === 0){
                self.colorStates.colorManagerShadeLightValid = true;
                const lightEnabled = self.colorStates.colorManagerShadeLight;
                showButton = true;
                    content += `<div class="control-inner control-inline">
                                    <label class="has-tooltip"><span>Generate Light Shades<div data-balloon="Generate lighter versions of the current color. The script will generate the shades up to 95% of the color's lightness." data-balloon-pos="bottom" data-balloon-length="medium"><i class="fas fa-circle-question"></i></div></span></label>
                                    <div class="" onclick="ADMINBRXC.toggleAutoShade('Light')"><i class="fas fa-toggle-${lightEnabled ? 'on' : 'off'}"></i></div>
                                </div>`;
                if(lightEnabled){
                    content += self.setAutoShadePreview('Light');
                }
            } else {
                self.colorStates.colorManagerShadeLightValid = false;
                self.colorStates.colorManagerShadeLight = true;
                    content += `<div class="control-inner control-inline">
                                    <label class="has-tooltip"><span>Generate Light Shades</span><div data-balloon="Generate lighter versions of the current color. The script will generate the shades up to 95% of the color's lightness." data-balloon-pos="bottom" data-balloon-length="medium"><i class="fas fa-circle-question"></i></div></label>
                                    <div><i class="fas fa-toggle-off"></i></div>
                                </div>
                                <div><span class="existing-shades-message">Light shades have already been generated for this color. Remove the existing shades to generate new ones.</span></div>`;                
            }

            // Dark

            if(!darkChildren|| darkChildren.length === 0){
                self.colorStates.colorManagerShadeDarkValid = true;
                const darkEnabled = self.colorStates.colorManagerShadeDark;
                showButton = true;
                    content += `<div class="control-inner control-inline">
                                    <label class="has-tooltip"><span>Generate Dark Shades</span><div data-balloon="Generate darker versions of the current color. The script will generate the shades up to 5% of the color's lightness." data-balloon-pos="bottom" data-balloon-length="medium"><i class="fas fa-circle-question"></i></div></label>
                                    <div class="" onclick="ADMINBRXC.toggleAutoShade('Dark')"><i class="fas fa-toggle-${darkEnabled ? 'on' : 'off'}"></i></div>
                                </div>`;
                if(darkEnabled){
                    content += self.setAutoShadePreview('Dark');
                }
            } else {
                self.colorStates.colorManagerShadeDarkValid = false;
                self.colorStates.colorManagerShadeDark = true;
                    content += `<div class="control-inner control-inline">
                                    <label class="has-tooltip"><span>Generate Dark Shades</span><div data-balloon="Generate darker versions of the current color. The script will generate the shades up to 5% of the color's lightness." data-balloon-pos="bottom" data-balloon-length="medium"><i class="fas fa-circle-question"></i></div></label>
                                    <div><i class="fas fa-toggle-off"></i></div>
                                </div>
                                <div><span class="existing-shades-message">Dark shades have already been generated for this color. Remove the existing shades to generate new ones.</span></div>`;    
            }

            if(!transparentChildren || transparentChildren.length === 0){
                self.colorStates.colorManagerShadeTransparentValid = true;
                const transparentEnabled = self.colorStates.colorManagerShadeTransparent;
                showButton = true;
                    content += `<div class="control-inner control-inline">
                                    <label class="has-tooltip"><span>Generate Transparent Shades</span><div data-balloon="Generate transparent versions of the current color. The script will generate the shades up to 5% of the color's transparency." data-balloon-pos="bottom" data-balloon-length="medium"><i class="fas fa-circle-question"></i></div></label>
                                    <div class="" onclick="ADMINBRXC.toggleAutoShade('Transparent')"><i class="fas fa-toggle-${transparentEnabled ? 'on' : 'off'}"></i></div>
                                </div>`;
                if(transparentEnabled){
                    content += self.setAutoShadePreview('Transparent');
                }
            } else {
                self.colorStates.colorManagerShadeTransparentValid = false;
                self.colorStates.colorManagerShadeTransparent = true;
                    content += `<div class="control-inner control-inline">
                                    <label class="has-tooltip"><span>Generate Transparent Shades</span><div data-balloon="Generate transparent versions of the current color. The script will generate the shades up to 5% of the color's transparency." data-balloon-pos="bottom" data-balloon-length="medium"><i class="fas fa-circle-question"></i></div></label>
                                    <div><i class="fas fa-toggle-off"></i></div>
                                </div>
                                <div><span class="existing-shades-message">Transparent shades have already been generated for this color. Remove the existing shades to generate new ones.</span></div>`;
            }
            content += showButton ? `<a class="brxc-overlay__action-btn primary" style="margin-top:16px;" onclick="ADMINBRXC.generateShades('${color.id}');"><span>Generate Shades</span></a>` : '';
            
        } else {
            const children = Array.from(palette.colors).filter(el => el && el.hasOwnProperty('shadeParent') && el.shadeParent === colorId);
            const customChildren = children && children.length > 0 ? Array.from(children).filter(el => el && el.hasOwnProperty('shadeMode') && el.shadeMode === "custom") : false;

            if(!customChildren || customChildren.length === 0){
                    content += `<div class="control-inner control-inline">
                                <label class="has-tooltip"><span>Base Name</span><div data-balloon="For example, the base name of 'primary-l-1' is 'primary-l-'" data-balloon-pos="bottom-left" data-balloon-length="medium"><i class="fas fa-circle-question"></i></div></label>
                                <input id="nameInput" type="text" value="${color.name}-" oninput="ADMINBRXC.colorStates.colorManagerShadeBaseName = event.target.value;">
                            </div>`;
                    content += `<div id="scaleCanvas">${self.setColorScale()}</div>`;
                    content += `<div id="previewCanvas">${self.setColorPreview(color.id)}</div>`;
                    content += `<a class="brxc-overlay__action-btn primary" style="margin-top:16px;" onclick="ADMINBRXC.generateShades('${color.id}');"><span>Generate Scale</span></a>`;
            } else {
                    content += `<div><span class="existing-shades-message">A custom scale has already been generated for this color. Remove the existing scale to generate new ones.</span></div>`;
            }
        }
        return content;
    },
    setShadesForm: function(colorId){
        const self = this;
        const palettes = self.vueState.colorPalette;
        const palette = Array.from(palettes).find(el => el && el.hasOwnProperty('id') && el.id == self.colorStates.activePalette)
        const color = Array.from(palette.colors).find(el => el && el.hasOwnProperty('id') && el.id === colorId);

        let content = `<div class="shade-form">`;
        content += `<div class="brxc-shade-wrapper bricks-control-popup bottom">
                        <div class="control-inner control-inline">
                            <label for="numberShades" class="has-tooltip"><span>Num Shades</span><div data-balloon="The number of shades you want to create." data-balloon-pos="bottom-left" data-balloon-length="medium"><i class="fas fa-circle-question"></i></div></label>
                            <div class="brxc__range">
                                <input type="range" min="2" max="20" step="1" value="${self.colorStates.colorManagerShadeNumber}" name="numberShades" id="numberShades" class="brxc-input__range" oninput="ADMINBRXC.shadesSlider(event);document.querySelector('#numberShadesValue').value = parseInt(event.target.value);">
                                <input type="number" min="2" max="20" id="numberShadesValue" value="${self.colorStates.colorManagerShadeNumber}" oninput="ADMINBRXC.shadesSlider(event);document.querySelector('#numberShades').value = parseInt(event.target.value);">
                            </div>
                        </div>
                        <div id="dynamicScaleCanvas">${self.dynamicScaleCanvas(colorId)}</div>`;
        content += `</div></div>`;

        return content;

    },
    toggleAutoShade: function(mode){
        const self = this;
        if(mode === "Light"){
            self.colorStates.colorManagerShadeLight === true ? self.colorStates.colorManagerShadeLight = false : self.colorStates.colorManagerShadeLight = true;
        } else if(mode === "Dark"){
            self.colorStates.colorManagerShadeDark === true ? self.colorStates.colorManagerShadeDark = false : self.colorStates.colorManagerShadeDark = true;
        } else if(mode === "Transparent"){
            self.colorStates.colorManagerShadeTransparent === true ? self.colorStates.colorManagerShadeTransparent = false : self.colorStates.colorManagerShadeTransparent = true;
        }
        self.setDynamicScaleCanvas();
    },
    setAutoShadePreview: function(mode){
        const self = this;
        const activeColor = self.colorStates.activeColor.rawValue.light;
        let targetColor;
        if(mode === 'Light') targetColor = chroma(activeColor).set('hsl.l', 0.98).css('hsla');
        if(mode === 'Dark') targetColor = chroma(activeColor).set('hsl.l', 0.05).css('hsla');
        if(mode === 'Transparent') targetColor = chroma(activeColor).alpha(0.05).css('hsla');
        const colors = chroma.scale([activeColor, targetColor])
                        .correctLightness()
                        .colors(parseInt(self.colorStates.colorManagerShadeNumber) + 1);
        let ind = 0;
        colors.forEach(color => {
            colors[ind] = chroma(color).css('hsla');
            ind++;
        })
        colors.shift();
        let content = `<div class="control-inner control-inline">
                            <label class="has-tooltip"><span>Preview ${mode} Shades</span><div data-balloon="Here is the preview of the shades that will be created." data-balloon-pos="bottom-left" data-balloon-length="medium"><i class="fas fa-circle-question"></i></div></label>
                            <div class="color-btn-wrapper">`;
                            colors.forEach(el => {
                                content += `<button class="scale-color" data-index="0" data-initial-color="${el}" data-balloon="${el}" data-balloon-pos="top" style="background:${el};"></button>`;
                            })
        content += `</div></div>`;
        return content;
    },
    setComplementaryColorPreview: function(){
        const self = this;
        const mode = self.colorStates.colorManagerMode;
        const activeColor = (self.colorStates.activeColor.hasOwnProperty('raw') && self.colorStates.activeColor.hasOwnProperty('rawValue') && self.colorStates.activeColor.rawValue.hasOwnProperty(mode)) ? self.colorStates.activeColor.rawValue[mode] : false;
        if(!activeColor) return;
        const hue = parseInt(chroma(activeColor).get('hsl', 'h'))

        let content = '';
        content += `<div class="control-inner control-inline">`;
        content += `<label class="has-tooltip"><span>Preview</span><div data-balloon="Here is the preview of the complementary colors that will be created." data-balloon-pos="bottom-left" data-balloon-length="medium"><i class="fas fa-circle-question"></i></div></label>`;
        content += `<div class="color-btn-wrapper">`;
    
        self.colorStates.colorManagerComplementaryFinalColors = [];

        // Contrast
        if(self.colorStates.colorManagerComplementaryScheme === 'complementary'){
            self.colorStates.colorManagerComplementaryFinalColors.push(chroma(activeColor).set('hsl.h', hue + 180).css('hsla'));
        }

        // Split-Complementary
        if(self.colorStates.colorManagerComplementaryScheme === 'split-complementary'){
            self.colorStates.colorManagerComplementaryFinalColors.push(chroma(activeColor).set('hsl.h', hue + 150).css('hsla'));
            self.colorStates.colorManagerComplementaryFinalColors.push(chroma(activeColor).set('hsl.h', hue + 210).css('hsla'));
        }

        // Triade
        if(self.colorStates.colorManagerComplementaryScheme === 'triade'){
            self.colorStates.colorManagerComplementaryFinalColors.push(chroma(activeColor).set('hsl.h', hue + 120).css('hsla'));
            self.colorStates.colorManagerComplementaryFinalColors.push(chroma(activeColor).set('hsl.h', hue + 240).css('hsla'));
        }

        // Tetrade
        if(self.colorStates.colorManagerComplementaryScheme === 'tetrade'){
            self.colorStates.colorManagerComplementaryFinalColors.push(chroma(activeColor).set('hsl.h', hue + 90).css('hsla'));
            self.colorStates.colorManagerComplementaryFinalColors.push(chroma(activeColor).set('hsl.h', hue + 180).css('hsla'));
            self.colorStates.colorManagerComplementaryFinalColors.push(chroma(activeColor).set('hsl.h', hue + 270).css('hsla'));
        }

        // Split-Tetradic
        if(self.colorStates.colorManagerComplementaryScheme === 'split-tetradic'){
            self.colorStates.colorManagerComplementaryFinalColors.push(chroma(activeColor).set('hsl.h', hue + 60).css('hsla'));
            self.colorStates.colorManagerComplementaryFinalColors.push(chroma(activeColor).set('hsl.h', hue + 180).css('hsla'));
            self.colorStates.colorManagerComplementaryFinalColors.push(chroma(activeColor).set('hsl.h', hue + 240).css('hsla'));
        }

        // Quadratic
        if(self.colorStates.colorManagerComplementaryScheme === 'quadratic'){
            self.colorStates.colorManagerComplementaryFinalColors.push(chroma(activeColor).set('hsl.h', hue + 120).css('hsla'));
            self.colorStates.colorManagerComplementaryFinalColors.push(chroma(activeColor).set('hsl.h', hue + 240).css('hsla'));
            self.colorStates.colorManagerComplementaryFinalColors.push(chroma(activeColor).set('hsl.h', hue + 300).css('hsla'));
        }

        // Compound
        if(self.colorStates.colorManagerComplementaryScheme === 'compound'){
            self.colorStates.colorManagerComplementaryFinalColors.push(chroma(activeColor).set('hsl.h', hue + 60).css('hsla'));
            self.colorStates.colorManagerComplementaryFinalColors.push(chroma(activeColor).set('hsl.h', hue + 180).css('hsla'));
            self.colorStates.colorManagerComplementaryFinalColors.push(chroma(activeColor).set('hsl.h', hue + 300).css('hsla'));
        }

        // Analogous
        if(self.colorStates.colorManagerComplementaryScheme === 'analogous'){
            self.colorStates.colorManagerComplementaryFinalColors.push(chroma(activeColor).set('hsl.h', hue + 30).css('hsla'));
            self.colorStates.colorManagerComplementaryFinalColors.push(chroma(activeColor).set('hsl.h', hue + 60).css('hsla'));
            self.colorStates.colorManagerComplementaryFinalColors.push(chroma(activeColor).set('hsl.h', hue + 90).css('hsla'));
        }

        // Split-Analogous
        if(self.colorStates.colorManagerComplementaryScheme === 'split-analogous'){
            self.colorStates.colorManagerComplementaryFinalColors.push(chroma(activeColor).set('hsl.h', hue + 30).css('hsla'));
            self.colorStates.colorManagerComplementaryFinalColors.push(chroma(activeColor).set('hsl.h', hue + 60).css('hsla'));
            self.colorStates.colorManagerComplementaryFinalColors.push(chroma(activeColor).set('hsl.h', hue + 150).css('hsla'));
        }

        self.colorStates.colorManagerComplementaryFinalColors.forEach(color => {
            content += `<button class="scale-color" data-initial-color="${color}" data-balloon="${color}" data-balloon-pos="top" style="background:${color};"></button>`;
        })
        content += `</div></div>`;
        return content;
    },
    setComplementaryForm: function(colorId){
        const self = this;
        const palettes = self.vueState.colorPalette;
        const palette = Array.from(palettes).find(el => el && el.hasOwnProperty('id') && el.id == self.colorStates.activePalette)
        const color = Array.from(palette.colors).find(el => el && el.hasOwnProperty('id') && el.id === colorId);

        let content = `<div class="complementary-form">`;
        content += `<div class="brxc-shade-wrapper bricks-control-popup bottom">
                        <div class="control-inner control-inline">
                            <label class="has-tooltip"><span>Base Name</span><div data-balloon="For example, the base name of 'primary-l-1' is 'primary-l-'" data-balloon-pos="bottom-left" data-balloon-length="medium"><i class="fas fa-circle-question"></i></div></label>
                            <input id="nameInput" type="text" value="${color.name}-" oninput="ADMINBRXC.colorStates.colorManagerComplementaryBaseName = event.target.value;">
                        </div>
                        <div class="control-inner control-inline">
                            <label for="Scheme" class="has-tooltip"><span>Scheme</span><div data-balloon="The color scheme you want to create." data-balloon-pos="bottom-left" data-balloon-length="medium"><i class="fas fa-circle-question"></i></div></label>
                            <div class="brxc-select">
                                <select value="${self.colorStates.colorManagerComplementaryScheme}" name="Scheme" id="Scheme" onchange="ADMINBRXC.colorStates.colorManagerComplementaryScheme = this.value;ADMINBRXC.changeColorScheme('${colorId}');">
                                    <option value="complementary"${self.colorStates.colorManagerComplementaryScheme === "complementary" ? ' selected':''}>Complementary</option>
                                    <option value="split-complementary"${self.colorStates.colorManagerComplementaryScheme === "split-complementary" ? ' selected':''}>Split-Complementary</option>
                                    <option value="triade"${self.colorStates.colorManagerComplementaryScheme === "triade" ? ' selected':''}>Perfect Triad</option>
                                    <option value="tetrade"${self.colorStates.colorManagerComplementaryScheme === "tetrade" ? ' selected':''}>Tetrade</option>
                                    <option value="split-tetradic"${self.colorStates.colorManagerComplementaryScheme === "split-tetradic" ? ' selected':''}>Split-Tetradic</option>
                                    <option value="quadratic"${self.colorStates.colorManagerComplementaryScheme === "quadratic" ? ' selected':''}>Quadratic</option>
                                    <option value="compound"${self.colorStates.colorManagerComplementaryScheme === "compound" ? ' selected':''}>Compound</option>
                                    <option value="analogous"${self.colorStates.colorManagerComplementaryScheme === "analogous" ? ' selected':''}>Analogous</option>
                                    <option value="split-analogous"${self.colorStates.colorManagerComplementaryScheme === "split-analogous" ? ' selected':''}>Split-Analogous</option>
                                </select>
                            </div>
                        </div>`;
        content += `<div id="previewComplementaryCanvas">${self.setComplementaryColorPreview(color.id)}</div>`;
        content += `<a class="brxc-overlay__action-btn primary" style="margin-top:16px;" onclick="ADMINBRXC.generateComplementary('${color.id}');"><span>Generate Colors</span></a>`;
        content += `</div></div>`;

        return content;

    },
    generateShades: function(colorId){
        const self = this;
        if(self.colorStates.colorManagerShadeCustom === true){
            self.generateCustomShades(colorId);
        } else {
            self.generateAutoShades(colorId);
        }
    },
    generateCustomShades: function(colorId){
        const self = this;
        const palettes = self.vueState.colorPalette;
        const palette = Array.from(palettes).find(el => el && el.hasOwnProperty('id') && el.id == self.colorStates.activePalette)
        const color = Array.from(palette.colors).find(el => el && el.hasOwnProperty('id') && el.id === colorId);

        if(!color) return;

        let colorOrder = parseInt(palette.colors.indexOf(color));

        function move(arr, from, to, on = 1) {
            return arr.splice(to, 0, ...arr.splice(from, on)), arr
        }
        color.shadeArray = self.colorStates.colorManagerShadeColors;
        self.colorStates.colorManagerShadeFinalColors.forEach((el,index) => {
            function setSufix(name, number){
                const exist = Array.from(palette.colors).find(el => el && el.hasOwnProperty('name') && el.name === `${name}${number}`);
                if(!exist) return `${name}${number}`;
                number++;
                return setSufix(name, number);
            }
            const lightness = chroma(el).get('hsl', 'l');
            const elDark = chroma(el).set('hsl.l', 1 - lightness[2]).css('hsla');
            let name = (self.colorStates.colorManagerShadeBaseName) ? self.colorStates.colorManagerShadeBaseName : `${color.name}-`;
            name = setSufix(self.helpers.formatForClasses(name), 1);
            const id = self.vueGlobalProp.$_generateId();
            const raw = `var(--${self.helpers.setPrefix(name, 'colors', self.helpers.isFramework(color.id))})`;
            const newColor = {
                id: id,
                name: name,
                raw: raw,
                rawValue: {
                    light: el,
                    dark: elDark
                },
                isShade: true,
                shadeMode: 'custom',
                shadeParent: colorId,
                shadeOrder: index,
            }
            if(color.hasOwnProperty('shadeChildren') && Array.isArray(color.shadeChildren)) color.shadeChildren.push(id);

            palette.colors.push(newColor);
            move(palette.colors, palette.colors.length - 1, colorOrder + 1, 1);
            setTimeout(()=> {
                self.setColorManagerSearch();
                self.setColorManagerBody();
            },10)

            colorOrder++;

        })
        self.generateColorCSS();
        self.generateBuilderCSS();
    },
    generateAutoShades: function(colorId){
        const self = this;
        const palettes = self.vueState.colorPalette;
        const palette = Array.from(palettes).find(el => el && el.hasOwnProperty('id') && el.id == self.colorStates.activePalette)
        const color = Array.from(palette.colors).find(el => el && el.hasOwnProperty('id') && el.id === colorId);
        let colorOrder = parseInt(palette.colors.indexOf(color));

        function move(arr, from, to, on = 1) {
            return arr.splice(to, 0, ...arr.splice(from, on)), arr
        }

        const activeColor = self.colorStates.activeColor.rawValue.light;
        let targetColor;

        function createScale(mode){
            if(mode === 'Light') targetColor = chroma(activeColor).set('hsl.l', 0.98).css('hsla');
            if(mode === 'Dark') targetColor = chroma(activeColor).set('hsl.l', 0.05).css('hsla');
            if(mode === 'Transparent') targetColor = chroma(activeColor).alpha(0.05).css('hsla');
            const colors = chroma.scale([activeColor, targetColor])
                                .correctLightness()
                                .colors(parseInt(self.colorStates.colorManagerShadeNumber) + 1);
            let ind = 0;
            colors.forEach(color => {
                colors[ind] = chroma(color).css('hsla');
                ind++;
            })
            colors.shift();
            return colors;
        }
        
        const modes = [];
        if(self.colorStates.colorManagerShadeLight === true && self.colorStates.colorManagerShadeLightValid === true) modes.push('Light');
        if(self.colorStates.colorManagerShadeDark === true && self.colorStates.colorManagerShadeDarkValid === true) modes.push('Dark');
        if(self.colorStates.colorManagerShadeTransparent === true && self.colorStates.colorManagerShadeTransparentValid === true) modes.push('Transparent')

        modes.forEach(mode => {
            const colors = createScale(mode);
            const suffix = `-${mode[0].toLowerCase()}-`
            colors.forEach((el, index) => {

                function setSufix(name, number){
                    const exist = Array.from(palette.colors).find(el => el && el.hasOwnProperty('name') && el.name === `${name}${number}`);
                    if(!exist) return `${name}${number}`;
                    number++;
                    return setSufix(name, number);
                }
                const lightness = chroma(el).get('hsl', 'l');
                const elDark = chroma(el).set('hsl.l', 1 - lightness[2]).css('hsla');
                const name = setSufix(self.helpers.formatForClasses(`${color.name}${suffix}`), 1);
                const raw = `var(--${self.helpers.setPrefix(name, 'colors', self.helpers.isFramework(color.id))})`;
                const id = self.vueGlobalProp.$_generateId();
                const newColor = {
                    id: id,
                    name: name,
                    raw: raw,
                    rawValue: {
                        light: el,
                        dark: elDark
                    },
                    isShade: true,
                    shadeMode: 'auto',
                    shadeType: mode,
                    shadeParent: colorId,
                    shadeOrder: index,
                }

                if(color.hasOwnProperty('shadeChildren') && Array.isArray(color.shadeChildren)) color.shadeChildren.push(id);

                palette.colors.push(newColor);
                move(palette.colors, palette.colors.length - 1, colorOrder + 1, 1);
                colorOrder++;
    
            })
        })

        setTimeout(()=> {
            self.setColorManagerSearch();
            self.setColorManagerBody();
            self.generateColorCSS();
            self.generateBuilderCSS();
        },10)
    },
    generateComplementary: function(colorId){
        const self = this;
        const palettes = self.vueState.colorPalette;
        const palette = Array.from(palettes).find(el => el && el.hasOwnProperty('id') && el.id == self.colorStates.activePalette)
        const color = Array.from(palette.colors).find(el => el && el.hasOwnProperty('id') && el.id === colorId);
        let colorOrder = parseInt(palette.colors.indexOf(color));

        function move(arr, from, to, on = 1) {
            return arr.splice(to, 0, ...arr.splice(from, on)), arr
        }

        self.colorStates.colorManagerComplementaryFinalColors.forEach((el,index) => {
            function setSufix(name, number){
                const exist = Array.from(palette.colors).find(el => el && el.hasOwnProperty('name') && el.name === `${name}${number}`);
                if(!exist) return `${name}${number}`;
                number++;
                return setSufix(name, number);
            }
            const lightness = chroma(el).get('hsl', 'l');
            const elDark = chroma(el).set('hsl.l', 1 - lightness[2]).css('hsla');
            let name = (self.colorStates.colorManagerComplementaryBaseName) ? self.colorStates.colorManagerComplementaryBaseName : `${color.name}-`;
            name = setSufix(self.helpers.formatForClasses(name), 1);
            const raw = `var(--${self.helpers.setPrefix(name, 'colors', self.helpers.isFramework(color.id))})`;
            const id = self.vueGlobalProp.$_generateId();
            const newColor = {
                id: id,
                name: name,
                raw: raw,
                rawValue: {
                    light: el,
                    dark: elDark
                },
                isComplementary: true,
                complementaryParent: colorId,
                complementaryOrder: index,
                shadeChildren: [],
                isExpanded: true,
            }
            if(color.hasOwnProperty('complementaryChildren') && Array.isArray(color.complementaryChildren)) color.complementaryChildren.push(id);

            palette.colors.push(newColor);
            move(palette.colors, palette.colors.length - 1, colorOrder + 1, 1);
            setTimeout(()=> {
                self.setColorManagerSearch();
                self.setColorManagerBody();
            },10)

            colorOrder++;

        })
        self.generateColorCSS();
        self.generateBuilderCSS();
    },
    setShadesWrapper: function(popup, colorId){
        const self = this;
        if(popup === 'true' && self.colorStates.colorManagerShadePopupLastId === colorId) return self.setColorManagerBody();
        self.colorStates.colorManagerShadePopup = true;
        self.colorStates.colorManagerShadePopupId = colorId;
        self.colorStates.colorManagerShadePopupLastId = colorId;
        self.setColorManagerBody();


    },
    setComplementaryWrapper: function(popup, colorId){
        const self = this;
        if(popup === 'true' && self.colorStates.colorManagerComplementaryPopupLastId === colorId) return self.setColorManagerBody();
        self.colorStates.colorManagerComplementaryPopup = true;
        self.colorStates.colorManagerComplementaryPopupId = colorId;
        self.colorStates.colorManagerComplementaryPopupLastId = colorId;
        self.setColorManagerBody();


    },
    renameColor: function(event, colorId, initial){
        const self = this;
        const palettes = self.vueState.colorPalette;
        const input = event.target.parentElement.previousElementSibling;
        input.classList.add('editable');
        const end = input.value.length; 
        input.setSelectionRange(end, end);
        input.focus();

        function renameColor(color, oldName, newName){
            if(color.hasOwnProperty('name') && color.name.includes(oldName)){
                color.name = color.name.replaceAll(oldName, newName);
                color.raw = `var(--${self.helpers.setPrefix(self.helpers.formatForClasses(color.name), 'colors', false)})`;
                
            }
        }

        function saveName(input){
            if (input.value === initial || input.value === '') return self.setColorManagerBody();
            const palette = Array.from(palettes).find(el => el && el.hasOwnProperty('id') && el.id == self.colorStates.activePalette)
            const color = Array.from(palette.colors).find(el => el && el.hasOwnProperty('id') && el.id === colorId);
            const oldName = color.name;

            // Rename Shades
            if(color.hasOwnProperty('shadeChildren') && Array.isArray(color.shadeChildren) && color.shadeChildren.length > 0){
                color.shadeChildren.forEach(shade => {
                    const color = Array.from(palette.colors).find(el => el && el.hasOwnProperty('id') && el.id === shade);
                    if(!color) return;
                    renameColor(color, oldName, input.value);

                })
            }

            // Change current color
            color.name = input.value;
            color.raw = `var(--${self.helpers.setPrefix(self.helpers.formatForClasses(input.value), 'colors', false)})`;
            

            // Remove input
            input.classList.remove('editable');
            input.blur();

            // Regenerate CSS
            self.generateColorCSS();
            self.generateBuilderCSS();
            self.setColorManagerBody();
            self.vueGlobalProp.$_showMessage('Color(s) correctly renamed!');
        }

        input.addEventListener("blur", () =>{
            saveName(input);
        })
        input.addEventListener("keydown", (event) =>{
            if(event.key === "Enter"){
                saveName(input);
            }
        })
    },
    addNewColor: function(event){
        if(event.key !== "Enter") return;
        const self = this;
        const palettes = self.vueState.colorPalette;
        const palette = Array.from(palettes).find(el => el && el.hasOwnProperty('id') && el.id == self.colorStates.activePalette);
        const name = event.target.value;
        const id = self.vueGlobalProp.$_generateId();
        const raw = `var(--${self.helpers.setPrefix(self.helpers.formatForClasses(name), 'colors', false)})`;
        function createColor(){
            const newColor = {
                id: id,
                name: name,
                raw: raw,
                rawValue: {
                    light: "#ffffff",
                    dark: "#000000",
                },
                complementaryChildren: [],
                shadeChildren: [],
                isExpanded: true,
            }
            palette.colors.push(newColor);

            self.vueGlobalProp.$_showMessage(`Color ${name} correctly created!`);
            self.setColorManagerSearch();
            self.setColorManagerBody();
        }
        createColor();
        self.generateColorCSS();
        self.generateBuilderCSS();

    },
    setDeleteColor: function(colorId,target){
        const oldContent = target.innerHTML;
        const oldBalloon = target.dataset.balloon;
        const oldFunction = `ADMINBRXC.setDeleteColor('${colorId}',this)`;
        const newContent = '<span class="bricks-svg-wrapper"><i class="fas fa-check"></i></span>';
        const newBalloon = 'Confirm?';
        const newFunction = `ADMINBRXC.deleteColor('${colorId}')`;

        target.setAttribute("onClick", newFunction);
        target.setAttribute("data-balloon", newBalloon);
        target.innerHTML = newContent;
        setTimeout(() => {
            target.setAttribute("onClick", oldFunction);
            target.setAttribute("data-balloon", oldBalloon);
            target.innerHTML = oldContent;
        }, 2000)
    },
    deleteColor: function(colorId){
        const self = this;
        const palettes = self.vueState.colorPalette;
        const palette = Array.from(palettes).find(el => el && el.hasOwnProperty('id') && el.id == self.colorStates.activePalette)
        const color = Array.from(palette.colors).find(el => el && el.hasOwnProperty('id') && el.id === colorId);

        if(!color) return;

        // Remove Shade from parent
        if(color.hasOwnProperty('isShade') && color.isShade === true && color.hasOwnProperty('shadeParent')){
            const parent = Array.from(palette.colors).find(el => el && el.hasOwnProperty('id') && el.id === color.shadeParent);
            if(parent.hasOwnProperty('shadeChildren') && Array.isArray(parent.shadeChildren) && parent.shadeChildren.length > 0){
                const index = parseInt(parent.shadeChildren.indexOf(colorId));
                if(index === -1) return;
                parent.shadeChildren.splice(index, 1);
            }
        }

        function deleteColor(color){
            palette.colors.splice(parseInt(palette.colors.indexOf(color)),1);
        }
        
        // Delete Shades
        if(color.hasOwnProperty('shadeChildren') && Array.isArray(color.shadeChildren) && color.shadeChildren.length > 0){
            color.shadeChildren.forEach(shade => {
                const color = Array.from(palette.colors).find(el => el && el.hasOwnProperty('id') && el.id === shade);
                if(!color) return;
                deleteColor(color);
            })
        }

        // Delete color
        deleteColor(color);

        // Regenerate CSS
        self.generateColorCSS();
        self.generateBuilderCSS();
        setTimeout(()=> {
            self.setColorManagerSearch();
            self.setColorManagerBody();
        },10)

    },
    removeRawValue: function(colorId){
        const self = this;
        const palettes = self.vueState.colorPalette;
        const palette = Array.from(palettes).find(el => el && el.hasOwnProperty('id') && el.id == self.colorStates.activePalette)
        const color = Array.from(palette.colors).find(el => el && el.hasOwnProperty('id') && el.id === colorId);
        if (color.hasOwnProperty('rawValue')) delete color.rawValue;
        self.generateColorCSS();
        self.generateBuilderCSS();
        setTimeout(()=> {
            self.setColorManagerBody();
        },10)
    },
    duplicateColor: function(colorId){
        const self = this;
        const palettes = self.vueState.colorPalette;
        const palette = Array.from(palettes).find(el => el && el.hasOwnProperty('id') && el.id == self.colorStates.activePalette)
        const color = Array.from(palette.colors).find(el => el && el.hasOwnProperty('id') && el.id === colorId);
        const colorOrder = !color.hasOwnProperty('shadeChildren') || color.shadeChildren.length < 1 ? palette.colors.indexOf(color) : palette.colors.length;


        function move(arr, from, to, on = 1) {
            return arr.splice(to, 0, ...arr.splice(from, on)), arr
        }

        function duplicateColor(color, parentID){
            const parentColor = Array.from(palette.colors).find(el => el && el.hasOwnProperty('id') && el.id === parentID);
            if(!parentColor) return;

            const newColor = {...color};
            const id = self.vueGlobalProp.$_generateId();
            newColor.id = id;
            newColor.shadeParent = parentID;
            newColor.name = `(Copy) ${newColor.name}`;
            newColor.raw = `var(--${self.helpers.setPrefix(self.helpers.formatForClasses(newColor.name), 'colors', false)})`;
            newColor.rawValue = JSON.parse(JSON.stringify(color.rawValue));
            palette.colors.push(newColor);

            parentColor.shadeChildren.push(id);
            move(palette.colors, palette.colors.length - 1, parseInt(palette.colors.length), 1);
        }

        const name = `(Copy) ${color.name}`;
        const id = self.vueGlobalProp.$_generateId();
        const newColor = JSON.parse(JSON.stringify({...color}));
        newColor.id = id;
        newColor.name = name;
        newColor.raw = `var(--${self.helpers.setPrefix(self.helpers.formatForClasses(name), 'colors', false)})`;
        newColor.rawValue = JSON.parse(JSON.stringify(color.rawValue));
        newColor.shadeChildren = [];
        newColor.complementaryChildrenChildren = [];


        palette.colors.push(newColor);
        move(palette.colors, palette.colors.length - 1, parseInt(colorOrder + 1), 1);

        // Delete Shades
        if(color.hasOwnProperty('shadeChildren') && Array.isArray(color.shadeChildren) && color.shadeChildren.length > 0){
            color.shadeChildren.forEach(shade => {
                const color = Array.from(palette.colors).find(el => el && el.hasOwnProperty('id') && el.id === shade);
                if(!color) return;
                duplicateColor(color, id);
            })
        }
        setTimeout(()=> {
            self.setColorManagerSearch();
            self.setColorManagerBody();
        },10)

    },
    updateColor: function(color, colorId, mode = false){
        const self = this;
        !mode ? mode = self.colorStates.colorManagerMode : '';
        const palettes = self.vueState.colorPalette;

        let activeColor = false;
        const palette = Array.from(palettes).find(el => el && el.hasOwnProperty('id') && el.id == self.colorStates.activePalette);
        const maybeColor = Array.from(palette.colors).find(el => el && el.hasOwnProperty('id') && el.id === colorId);
        if (maybeColor) activeColor = maybeColor; 
        if (activeColor && !activeColor.hasOwnProperty('rawValue')) activeColor.rawValue = {};
        if (activeColor && activeColor.hasOwnProperty('raw') && activeColor.hasOwnProperty('rawValue')) activeColor.rawValue[mode] = color;

        // Shades
        if(mode === "light" && activeColor && activeColor.hasOwnProperty('shadeChildren') && Array.isArray(activeColor.shadeChildren) && activeColor.shadeChildren.length > 0){

            let targetColor;

            function createScale(mode, numShades, arr = false){
                if(mode === 'Light') targetColor = chroma(color).set('hsl.l', 0.98).css('hsla');
                if(mode === 'Dark') targetColor = chroma(color).set('hsl.l', 0.05).css('hsla');
                if(mode === 'Transparent') targetColor = chroma(color).alpha(0.05).css('hsla');
                if(mode === 'Custom') targetColor = [color, ...arr];
                const colors = mode === "Custom" ? chroma.scale(targetColor).colors(parseInt(numShades) + 1) : chroma.scale([color, targetColor]).colors(parseInt(numShades) + 1);
                let ind = 0;
                colors.forEach(color => {
                    colors[ind] = chroma(color).css('hsla');
                    ind++;
                })
                colors.shift();
                return colors;
            }

            function updateValue(colors,arr){
                if(colors && Array.isArray(colors) && colors.length > 0){
                    colors.forEach((el,index) => {
                        const color = arr.find(el => el && el.hasOwnProperty('isShade') && el.isShade && el.hasOwnProperty('shadeOrder') && parseInt(el.shadeOrder) === index);
                        if(!color) return;
                        const lightness = chroma(el).get('hsl', 'l');
                        const elDark = chroma(el).set('hsl.l', 1 - lightness[2]).css('hsla');
                        color.rawValue.light = el;
                        color.rawValue.dark = elDark;

                    })
                }

            }

            const children = Array.from(palette.colors).filter(el => el && el.hasOwnProperty('shadeParent') && el.shadeParent === colorId);
            const lightChildren = children && children.length > 0 ? Array.from(children).filter(el => el && el.hasOwnProperty('shadeType') && el.shadeType === "Light") : false;
            const darkChildren = children && children.length > 0 ? Array.from(children).filter(el => el && el.hasOwnProperty('shadeType') && el.shadeType === "Dark") : false;
            const transparentChildren = children && children.length > 0 ? Array.from(children).filter(el => el && el.hasOwnProperty('shadeType') && el.shadeType === "Transparent") : false;
            const customChildren = children && children.length > 0 ? Array.from(children).filter(el => el && el.hasOwnProperty('shadeMode') && el.shadeMode === "custom") : false;

            // Light
            if(lightChildren && lightChildren.length > 0){
                const newColors = createScale('Light', lightChildren.length);
                updateValue(newColors, lightChildren);
            }

            // Dark
            if(darkChildren && darkChildren.length > 0){
                const newColors = createScale('Dark', darkChildren.length);
                updateValue(newColors, darkChildren);
            }

            // Transparent
            if(transparentChildren && transparentChildren.length > 0){
                const newColors = createScale('Transparent', transparentChildren.length);
                updateValue(newColors, transparentChildren);
            }

            // Custom
            if(customChildren && customChildren.length > 0){
                const shadeArray = activeColor.hasOwnProperty('shadeArray') && activeColor.shadeArray.length > 0 ? activeColor.shadeArray : false;
                if(shadeArray && shadeArray.length > 0) {
                    const newColors = createScale('Custom', customChildren.length, shadeArray);
                    updateValue(newColors, customChildren);
                }
            }
        }
        self.helpers.saveChanges('colorPalette');
        self.generateColorCSS();
        self.generateBuilderCSS();
    },
    generateColorCSS: function() {
        const self = this;
        const mode = self.colorStates.colorManagerMode;
        const palettes = self.vueState.colorPalette;
        let css = '' ;

        if(!self.helpers.isGlobalColorsTabActive()) return css;

        palettes.forEach(palette => {
            if((palette.hasOwnProperty('status') && palette.status === "disabled" ) || !palette.hasOwnProperty('colors')) return;
            const vars = Array.from(palette.colors).filter(el => el && el.hasOwnProperty('raw') && el.hasOwnProperty('rawValue'));
            vars.forEach(el => {
                const name = self.helpers.setPrefix(self.helpers.formatForClasses(el.name), 'colors', self.helpers.isFramework(el.id));
                const hasLight = el.rawValue.hasOwnProperty('light');
                const hasDark = el.rawValue.hasOwnProperty('dark');
                if(mode === 'dark' && hasDark){
                    //css.push([name,el.rawValue.dark])
                    css += `--${name}:${el.rawValue.dark};`;
                } else if(hasLight) {
                    //css.push([name,el.rawValue.light])
                    css += `--${name}:${el.rawValue.light};`;
                }
            });
        });
        
        self.colorStates.generatedCSS = css;
    },
    
    
    // Class Manager
    
    removeDuplicateClass: function(){
        const self = this;
        const arr = Array.from(self.vueState.globalClasses).filter(el => el && el.new === true);
        if (arr.length < 1) return;
        arr.forEach(el => {
            delete el.new;
        })
    },
    bulkClassesReset: function(){
        const self = this;
        document.querySelector('[name="brxcClassManagercontain"]').value = '';
        document.querySelector('[name="brxcClassManagerexclude"]').value = '';
        self.states.classManagerBulkActionTargetContain = '';
        self.states.classManagerBulkActionTargetExclude = '';
        self.states.classManagerBulkActionTargetGroup = 'All';
        self.states.classManagerBulkActionLock = 'All';
        self.states.classManagerBulkActionHasStyles = 'All';
        self.states.classManagerBulkActionIsActive = 'All';
        self.states.classManagerBulkActionOld = '';
        self.states.classManagerBulkActionNew = '';
        self.states.classManagerBulkActionPrefix = '';
        self.states.classManagerBulkActionSuffix = '';
        self.states.classManagerBulkActionNewGroup = '';
        self.states.classManagerBulkAssignElements = true;
        self.states.classManagerBulkRemoveOldClass = false;
        self.states.classManagerBulkDeleteOldClass = false;
        self.setClassManagerBulk();
    },
    bulkDeleteClasses: function(){
        const self = this;

        const cls = document.querySelectorAll('#brxcClassBulkActionList ul li.bulk-action-Delete[data-id]:not([data-enable="false"]');
        if(cls.length < 1) return self.vueGlobalProp.$_showMessage('Abort: No Class found!');

        cls.forEach(cl => {
            const clId = cl.dataset.id;

            // Remove from elements
            if(self.states.classManagerBulkRemoveOldClass === true || self.states.classManagerBulkDeleteOldClass === true){

                let filteredEls;

                // All post
                if(self.states.classManagerType === "global"){
                    const templateType = self.helpers.getTemplateType();
                    filteredEls = Array.from(self.vueState[templateType]).filter(el => el && el.settings.hasOwnProperty('_cssGlobalClasses') && Array.isArray(el.settings._cssGlobalClasses) && el.settings._cssGlobalClasses.includes(clId));
                
                // Component
                } else {
                    const compElements = self.helpers.getComponentElements([],self.vueState.activeElement.id);
                    filteredEls = Array.from(compElements).filter(el => el && el.settings.hasOwnProperty('_cssGlobalClasses') && Array.isArray(el.settings._cssGlobalClasses) && el.settings._cssGlobalClasses.includes(clId));
                }
                
                if(filteredEls && filteredEls.length > 0){
                    filteredEls.forEach(element => {
                        const index = element.settings._cssGlobalClasses.indexOf(clId);
                        element.settings._cssGlobalClasses.splice(index, 1);
                    })
                }
            }

            // Delete Classes
            if(self.states.classManagerBulkDeleteOldClass === true){
                setTimeout(() => {
                    self.vueState.globalClasses.splice(parseInt(self.vueState.globalClasses.indexOf(self.vueGlobalProp.$_getGlobalClass(clId))),1);
                },5)
            }
        })
        
        setTimeout(() => {
            self.vueGlobalProp.$_showMessage('Classes successfully removed!');
            self.bulkClassesReset();
            self.setClassManagerBulkActionsList();
        },100)
    },
    bulkDuplicateClasses: function(){
        const self = this;
        const items = document.querySelectorAll('#brxcClassBulkActionList ul li.bulk-action-Duplicate[data-id]:not([data-enable="false"]');

        if(items.length < 1) return self.vueGlobalProp.$_showMessage('Abort: No Class found!');

        function move(arr, from, to, on = 1) {
            return arr.splice(to, 0, ...arr.splice(from, on)), arr
        }

        function replaceRootCustomCss(target, obj, oldName, newName){
            if(obj.settings.hasOwnProperty(target)) return obj.settings[target] = obj.settings[target].replaceAll(`.${oldName}`, `.${newName}`);

        }
        function loopCustomCss(obj, oldName, newName){
            let target = "_cssCustom";
            if(obj.settings.hasOwnProperty(target)) replaceRootCustomCss(target, obj, oldName, newName);
            const bps = self.vueState.breakpoints
            bps.forEach(bp => {
                target += `:${bp.key}`;
                if(obj.settings.hasOwnProperty(target)) replaceRootCustomCss(target, obj, oldName, newName);
            })
        }
        
        items.forEach(el => {
            setTimeout(() => {
                const oldId = el.dataset.id;
                const oldObj = self.vueGlobalProp.$_getGlobalClass(oldId);
                const obj = JSON.parse(JSON.stringify(oldObj));
                const objOrder = self.vueState.globalClasses.indexOf(self.vueGlobalProp.$_getGlobalClass(oldId));

                self.vueState.globalClasses.push(obj);
                const newId = self.vueGlobalProp.$_generateId();
                const oldName = obj.name;
                let newName = el.dataset.name !== "false" ? el.dataset.name : el.querySelector('input[type="text"]').value  && el.querySelector('input[type="text"]').value.length > 0 ? el.querySelector('input[type="text"]').value : oldName;
                const newClass = self.vueState.globalClasses[self.vueState.globalClasses.length - 1];
                newClass.id = newId;
                newName = self.helpers.checkClassName(newName.replaceAll(' ',''));
                newClass.name = newName;
                loopCustomCss(newClass, oldName, newName);
                move(self.vueState.globalClasses, self.vueState.globalClasses.length - 1, parseInt(objOrder + 1), 1);
                setTimeout(() => {
                    self.states.classManagerActiveClass = newId;
                }, 10);

                // Content
                let filteredEls;

                // All post
                if(self.states.classManagerType === "global"){
                    const templateType = self.helpers.getTemplateType();
                    filteredEls = Array.from(self.vueState[templateType]).filter(el => el && el.settings.hasOwnProperty('_cssGlobalClasses') && Array.isArray(el.settings._cssGlobalClasses) && el.settings._cssGlobalClasses.includes(oldId));
                
                // Component
                } else {
                    const compElements = self.helpers.getComponentElements([],self.vueState.activeElement.id);
                    filteredEls = Array.from(compElements).filter(el => el && el.settings.hasOwnProperty('_cssGlobalClasses') && Array.isArray(el.settings._cssGlobalClasses) && el.settings._cssGlobalClasses.includes(oldId));
                }

                if(filteredEls && filteredEls.length > 0){
                    filteredEls.forEach(element => {
                        // Assign to element
                        if(self.states.classManagerBulkAssignElements === true){
                            element.settings._cssGlobalClasses.push(newId);
                        }
                        // Remove old class
                        if(self.states.classManagerBulkRemoveOldClass === true){
                            const index = element.settings._cssGlobalClasses.indexOf(oldId);
                            element.settings._cssGlobalClasses.splice(index, 1);
                        }
                    })
                }

                // Delete Original class
                if(self.states.classManagerBulkDeleteOldClass === true){
                    const index = self.vueState.globalClasses.indexOf(oldObj);
                    self.vueState.globalClasses.splice(index, 1);
                }
                    
            },10)
        })
        setTimeout(() => {
            self.vueGlobalProp.$_showMessage('Classes successfully duplicated!');
            self.helpers.saveChanges('globalClasses');
            self.bulkClassesReset();
            self.setClassManagerBulkActionsList();
        },100)
    },
    bulkRenameClasses: function(){
        const self = this;
        const items = document.querySelectorAll('#brxcClassBulkActionList ul li[data-id]:not([data-enable="false"]');

        if(items.length < 1) return self.vueGlobalProp.$_showMessage('Abort: No Class found!');

        function replaceRootCustomCss(target, obj, oldName, newName){
            if(obj.settings.hasOwnProperty(target)) return obj.settings[target] = obj.settings[target].replaceAll(`.${oldName}`, `.${newName}`);

        }
        function loopCustomCss(obj, oldName, newName){
            let target = "_cssCustom";
            if(obj.settings.hasOwnProperty(target)) replaceRootCustomCss(target, obj, oldName, newName);
            const bps = self.vueState.breakpoints
            bps.forEach(bp => {
                target += `:${bp.key}`;
                if(obj.settings.hasOwnProperty(target)) replaceRootCustomCss(target, obj, oldName, newName);
            })
        }

        items.forEach(el => {
            const id = el.dataset.id;
            const obj = self.vueGlobalProp.$_getGlobalClass(id);
            const oldName = obj.name;
            const tempName = el.dataset.name !== "false" ? el.dataset.name : el.querySelector('input[type="text"]').value  && el.querySelector('input[type="text"]').value.length > 0 ? el.querySelector('input[type="text"]').value : oldName;
            const newName = self.helpers.checkClassName(tempName.replaceAll(' ',''));
            obj.name = newName;
            loopCustomCss(obj, oldName, newName);
        })
        setTimeout(() => {
            self.vueGlobalProp.$_showMessage('Classes successfully renamed!');
            self.bulkClassesReset();
            self.setClassManagerBulkActionsList();
        },100)
    },
    renameBulkedClass: function(event, bulkedName){
        const prev = event.target.parentElement.previousElementSibling;
        const parent = event.target.parentElement.parentElement;
        if(!event) return;
        prev.innerHTML = `.<input type="text" value="${bulkedName}">`;
        parent.setAttribute('data-name', false);
        const input = prev.querySelector('input');
        input.focus();
        input.select()

    },

    enableBulkedClass: function(event){
        const li = event.target.closest('li');
        if(event.target.classList.contains('enable')){
            li.setAttribute('data-enable', 'false')
            event.target.classList.remove('enable');
            event.target.classList.add('disable');
            event.target.setAttribute('data-balloon', 'Skipped');
            event.target.querySelector('i').setAttribute('class', 'fas fa-toggle-off');
        } else {
            li.setAttribute('data-enable', 'true');
            event.target.classList.add('enable');
            event.target.classList.remove('disable');
            event.target.setAttribute('data-balloon', 'Included');
            event.target.querySelector('i').setAttribute('class', 'fas fa-toggle-on');
        }
    },
    bulkGroupClasses: function(){
        const self = this;

        const cls = document.querySelectorAll('#brxcClassBulkActionList ul li.bulk-action-Group[data-id]:not([data-enable="false"])');
        if(cls.length < 1) return self.vueGlobalProp.$_showMessage('Abort: No Class found!');
        
        if(!self.states.classManagerCategories.includes(self.states.classManagerBulkActionNewGroup)) self.helpers.createClassCategory(self.states.classManagerBulkActionNewGroup)
        cls.forEach(el => {
            const clId = el.dataset.id;
            const obj = self.vueGlobalProp.$_getGlobalClass(clId);
            obj.category = self.helpers.getClassCategoryIdByName(self.states.classManagerBulkActionNewGroup);
        })
        setTimeout(() => {
            self.vueGlobalProp.$_showMessage(`Classes successfully assigned to ${self.states.classManagerBulkActionNewGroup}!`);
            self.bulkClassesReset();
            self.setClassManagerBulkActionsList();
        },100)
    },
    bulkExportClasses: function(){
        const self = this;

        const cls = document.querySelectorAll('#brxcClassBulkActionList ul li.bulk-action-Export[data-id]:not([data-enable="false"]');
        if(cls.length < 1) return self.vueGlobalProp.$_showMessage('Abort: No Class found!');

        const globalClasses = [];

        cls.forEach(cl => {
            const obj = self.vueGlobalProp.$_getGlobalClass(cl.dataset.id);
            globalClasses.push(obj);
        })
        
        self.vueGlobalProp.$_exportAsJsonFile(globalClasses, 'bricks-css-classes');
        
        setTimeout(() => {
            self.vueGlobalProp.$_showMessage(`Classes successfully exported!`);
            self.bulkClassesReset();
            self.setClassManagerBulkActionsList();
        },100)
    },
    bulkLockClasses: function(){
        const self = this;

        const cls = document.querySelectorAll('#brxcClassBulkActionList ul li.bulk-action-Lock[data-id]:not([data-enable="false"]');
        if(cls.length < 1) return self.vueGlobalProp.$_showMessage('Abort: No Class found!');

        const lockedClasses = Array.from(cls).map(el => el.dataset.id);
        self.vueState.globalClassesLocked = [...new Set(self.vueState.globalClassesLocked.concat(lockedClasses))];
        
        
        setTimeout(() => {
            self.vueGlobalProp.$_showMessage(`Classes successfully locked!`);
            self.bulkClassesReset();
            self.setClassManagerBulkActionsList();
        },100)
    },
    bulkUnlockClasses: function(){
        const self = this;

        const cls = document.querySelectorAll('#brxcClassBulkActionList ul li.bulk-action-Unlock[data-id]:not([data-enable="false"]');
        if(cls.length < 1) return self.vueGlobalProp.$_showMessage('Abort: No Class found!');

        const unlockedClasses = Array.from(cls).map(el => el.dataset.id);
        self.vueState.globalClassesLocked = Array.from(self.vueState.globalClassesLocked).filter(el => !unlockedClasses.includes(el));
        
        
        setTimeout(() => {
            self.vueGlobalProp.$_showMessage(`Classes successfully locked!`);
            self.bulkClassesReset();
            self.setClassManagerBulkActionsList();
        },100)
    },
    loadMoreClasses: function(num){
        const self = this;
        self.states.classManagerMaxClasses = num;
    },
    setClassManagerBulk: function(){
        const self = this;
        self.states.classManagerMaxClasses = 50;
        self.setClassManagerBulkActionsList();
        self.setClassManagerBulkActions();
    },
    setClassManagerBulkActionsList: function(){
        const canvas = document.querySelector('#brxcClassBulkActionList');
        const self = this;
        const template = self.helpers.getTemplateType();
        let cls;
        
        // Type
        if(self.states.classManagerType === "global") {
            cls = self.vueState.globalClasses;
         } else {
            let globalClasses = [];
            const tempClasses = self.helpers.getComponentClasses([],self.vueState.activeElement.id);
            
            if(tempClasses.length > 0){
                tempClasses.forEach(el => {
                    if(typeof self.vueGlobalProp.$_getGlobalClass(el) === "object") globalClasses.push(self.vueGlobalProp.$_getGlobalClass(el))
                })
                cls = globalClasses.concat(Array.from(self.vueState.globalClasses).filter(el => el && el.new === true))
            }
         }

         let content = '';

         if(Array.isArray(cls) && cls.length > 0 ) {
            // filters
            const contain = self.states.classManagerBulkActionTargetContain.replaceAll(' ', '').split(',');
            const exclude = self.states.classManagerBulkActionTargetExclude.replaceAll(' ', '').split(',');
            const checkContain = (e) => (contain.length === 1 && contain[0] === '') || contain.some(target => target !== '' && e.name.includes(target));
            const checkExclude = (e) => (exclude.length === 1 && exclude[0] === '') || exclude.every(target => target === '' || !e.name.includes(target));
            const checkGroup = (e) => self.states.classManagerBulkActionTargetGroup !== "All" ? e.category === self.states.classManagerBulkActionTargetGroup : true;
            const checkLock = (e) => self.states.classManagerBulkActionLock !== "All" ? (self.states.classManagerBulkActionLock === "locked" ? self.vueGlobalProp.$_isLocked(e.id) : !self.vueGlobalProp.$_isLocked(e.id)) : true;
            const checkStyle = (e) => self.states.classManagerBulkActionHasStyles !== "All" ? (self.states.classManagerBulkActionHasStyles === "has-styles" ? self.vueGlobalProp.$_generateCss('globalClass', e.id, ['block']) !== '' : self.vueGlobalProp.$_generateCss('globalClass', e.id, ['block']) === '') : true;
            const checkIsActive = (e) => self.states.classManagerBulkActionIsActive !== "All" ? (self.states.classManagerBulkActionIsActive === "is-active" ? typeof Array.from(self.vueState[template]).find(el2 => el2 && el2.settings._cssGlobalClasses && Array.isArray(el2.settings._cssGlobalClasses) && el2.settings._cssGlobalClasses.includes(e.id)) !== "undefined" : typeof Array.from(self.vueState[template]).find(el2 => el2 && el2.settings._cssGlobalClasses && Array.isArray(el2.settings._cssGlobalClasses) && el2.settings._cssGlobalClasses.includes(e.id)) === "undefined") : true;
            
            cls = cls.filter(el =>
                el 
                && checkContain(el)
                && checkExclude(el)
                && checkGroup(el)
                && checkLock(el)
                && checkStyle(el)
                && checkIsActive(el)
            );
    
            content += `<ul>`;
            if(cls.length > 0) {
                let index = 1;
                cls.slice(0, self.states.classManagerMaxClasses).forEach(el => {
                    const tempName = `<span class="brxc_changes">${self.states.classManagerBulkActionPrefix.replaceAll(' ','')}</span>` + (self.states.classManagerBulkActionOld === '' || self.states.classManagerBulkActionNew === "" ? el.name : el.name.replaceAll(self.states.classManagerBulkActionOld, `<span class="brxc_changes">${self.states.classManagerBulkActionNew.replaceAll(' ','')}</span>`)) + `<span class="brxc_changes">${self.states.classManagerBulkActionSuffix.replaceAll(' ','')}</span>`;
                    const newName = self.helpers.checkClassName(tempName, true);
                    const newNameWithoutTags = newName.replaceAll('<span class="brxc_changes">', '').replaceAll('</span>', '');
                    if(self.states.classManagerBulkActionType === "Duplicate") content += `<li class="active"><div class="span-wrapper"><span>.${el.name}</span></div></li>`;
                    const classicNames = ['Delete', 'Group', 'Export', 'Lock'];
                    content += `<li class="bulk-action-${self.states.classManagerBulkActionType}" data-id="${el.id}" data-name="${newNameWithoutTags}"><div class="span-wrapper"><span>.${classicNames.includes(self.states.classManagerBulkActionType) ? el.name : newName}</span></div>`;
                    content += `<div class="brxc-bulk-action-wrapper">`
                    if(self.states.classManagerBulkActionType === "Rename" || self.states.classManagerBulkActionType === "Duplicate"){
                        //const bulkedName = `${self.states.classManagerBulkActionPrefix.replaceAll(' ','')}` + (self.states.classManagerBulkActionOld === '' || self.states.classManagerBulkActionNew === "" ? el.name : el.name.replaceAll(self.states.classManagerBulkActionOld, self.states.classManagerBulkActionNew.replaceAll(' ',''))) + `${self.states.classManagerBulkActionSuffix.replaceAll(' ','')}`;
                        content += `<div class="brxc-icon" data-balloon="Rename" data-balloon-pos="left" onClick="ADMINBRXC.renameBulkedClass(event, '${newNameWithoutTags}');"><span class="bricks-svg-wrapper"><i class="fas fa-pen"></i></span></div>`;
                        
                    } 
                    content += `<div class="brxc-icon enable" data-balloon="Included" data-balloon-pos="left" onClick="ADMINBRXC.enableBulkedClass(event);"><span class="bricks-svg-wrapper"><i class="fas fa-toggle-on"></i></span></div>`;
                    content += `</div>`
                    content +=`</li>`;
                    if(index === self.states.classManagerMaxClasses && self.states.classManagerMaxClasses < cls.length) content += `<li onclick="ADMINBRXC.loadMoreClasses(${cls.length});ADMINBRXC.setClassManagerBulkActionsList();"><div class="span-wrapper"><span class="max-results">Load ${cls.length - 50} more classes....</span></div></li>`;
                    index++;
                })
            }
            content += '</ul>';
         }
         
        canvas.innerHTML = content;

    },
    setClassManagerBulkActions: function(){
        const self = this;
        const canvas = document.querySelector('#brxcClassBulkActionCanvas');
        let content = '';
        content +=`<fieldset>
                    <legend>Filters</legend>
                    <div><label class="has-tooltip"><span>Include String:</span><div data-balloon="Type a keyword to filter the classes that you want to target. For multiple keywords, separate each word by a comma." data-balloon-pos="bottom" data-balloon-length="medium"><i class="fas fa-circle-question"></i></div></label>
                    <div class="brxc__text"><input type="text" name="brxcClassManagercontain" id="brxcClassManagercontain" placeholder="Type here the keywords you want to include" onInput="ADMINBRXC.states.classManagerBulkActionTargetContain = this.value;ADMINBRXC.setClassManagerBulkActionsList();"></div></div>
                    <div><label class="has-tooltip"> <span>Exclude String</span><div data-balloon="Type keywords that will exclude the classes from the selection. For multiple keywords, separate each word by a comma." data-balloon-pos="bottom" data-balloon-length="medium"><i class="fas fa-circle-question"></i></div></label>
                    <div class="brxc__text"><input type="text" name="brxcClassManagerexclude" id="brxcClassManagerexclude" placeholder="Type here the keywords you want to exclude" onInput="ADMINBRXC.states.classManagerBulkActionTargetExclude = this.value;ADMINBRXC.setClassManagerBulkActionsList();"></div></div>`;
        content += `<div><label class="has-tooltip"><span>Group:</span><div data-balloon="Filter the selection by any Class Group." data-balloon-pos="bottom" data-balloon-length="medium"><i class="fas fa-circle-question"></i></div></label>`;
        content += `<div class="brxc-select"><select name="brxc-bulkActionsOptions" id="bulkActionsOptions" class="brxc-bulkActionsOptions" value="${self.states.classManagerBulkActionTargetGroup}" onChange="ADMINBRXC.states.classManagerBulkActionTargetGroup = this.value;ADMINBRXC.setClassManagerBulkActionsList();">`;
        content += `<option value="All">All</option>`;
        const sortedCats = Array.from(self.vueState.globalClassesCategories).filter(el => el && el.name).map(el => el && el.name).sort((a, b) => a.localeCompare(b, undefined, {sensitivity: 'base'}));
        sortedCats.forEach(el => {
            content += `<option value="${self.helpers.getClassCategoryIdByName(el)}">${el}</option>`;
        })
        content += `</select></div></div>`;
        content += `<div><label class="has-tooltip"><span>Locked/Unlocked:</span><div data-balloon="Filter the selection by their Lock status." data-balloon-pos="bottom" data-balloon-length="medium"><i class="fas fa-circle-question"></i></div></label>`;
        content += `<div class="brxc-select"><select name="brxc-bulkActionsOptionsLock" id="bulkActionsOptionsLock" class="brxc-bulkActionsOptions" value="${self.states.classManagerBulkActionLock}" onChange="ADMINBRXC.states.classManagerBulkActionLock = this.value;ADMINBRXC.setClassManagerBulkActionsList();"><option value="All">All</option><option value="locked">Locked</option><option value="unlocked">Unlocked</option></select></div></div>`;
        content += `<div><label class="has-tooltip"><span>Have Styles:</span><div data-balloon="Filter the selection of the classes that contain custom styles." data-balloon-pos="bottom" data-balloon-length="medium"><i class="fas fa-circle-question"></i></div></label>`;
        content += `<div class="brxc-select"><select name="brxc-bulkActionsOptionsHasStyles" id="bulkActionsOptionsHasStyles" class="brxc-bulkActionsOptions" value="${self.states.classManagerBulkActionHasStyles}" onChange="ADMINBRXC.states.classManagerBulkActionHasStyles = this.value;ADMINBRXC.setClassManagerBulkActionsList();"><option value="All">All</option><option value="has-styles">Have Styles</option><option value="has-no-styles">Have No Styles</option></select></div></div>`;
        content += `<div><label class="has-tooltip"><span>Active on Page:</span><div data-balloon="Filter the selection of the classes that are used on this page." data-balloon-pos="bottom" data-balloon-length="medium"><i class="fas fa-circle-question"></i></div></label>`;
        content += `<div class="brxc-select"><select name="brxc-bulkActionsOptionsIsActive" id="bulkActionsOptionsIsActive" class="brxc-bulkActionsOptions" value="${self.states.classManagerBulkActionIsActive}" onChange="ADMINBRXC.states.classManagerBulkActionIsActive = this.value;ADMINBRXC.setClassManagerBulkActionsList();"><option value="All">All</option><option value="is-active">Active on Page</option><option value="is-not-active">Inactive on Page</option></select></div></div>`;
        content += `</fieldset>`;
        if(self.states.classManagerBulkActionType === "Duplicate" || self.states.classManagerBulkActionType === "Rename"){
            content += `<fieldset><legend>Action</legend>`;
            content += `<div><label class="has-tooltip"><span>Find:</span><div data-balloon="Type here the string that you want to replace." data-balloon-pos="bottom" data-balloon-length="medium"><i class="fas fa-circle-question"></i></div></label>`;
            content += `<div class="brxc__text"><input type="text" name="brxcClassManagerOld" id="brxc-bulkActionsOld" placeholder="Type here the string you want to replace" value="${self.states.classManagerBulkActionOld}" onInput="ADMINBRXC.states.classManagerBulkActionOld = this.value;ADMINBRXC.setClassManagerBulkActionsList();"></div></div>`;
            content += `<div><label class="has-tooltip"><span>Replace with:</span><div data-balloon="Type here the new string that will replace the old one." data-balloon-pos="bottom" data-balloon-length="medium"><i class="fas fa-circle-question"></i></div></label>`;
            content += `<div class="brxc__text"><input type="text" name="brxcClassManagerNew" id="brxc-bulkActionsNew" placeholder="Type here the new string" value="${self.states.classManagerBulkActionNew}" onInput="ADMINBRXC.states.classManagerBulkActionNew = this.value;ADMINBRXC.setClassManagerBulkActionsList();"></div></div>`;
            content += `<div><label class="has-tooltip"><span>Add a prefix:</span><div data-balloon="Add a prefix to the renamed classes" data-balloon-pos="bottom" data-balloon-length="medium"><i class="fas fa-circle-question"></i></div></label>`;
            content += `<div class="brxc__text"><input type="text" name="brxcClassManagerNew" id="brxc-bulkActionsPrefix" placeholder="Type here the prefix" value="${self.states.classManagerBulkActionPrefix}" onInput="ADMINBRXC.states.classManagerBulkActionPrefix = this.value;ADMINBRXC.setClassManagerBulkActionsList();"></div></div>`;
            content += `<div><label class="has-tooltip"><span>Add a suffix:</span><div data-balloon="Add a suffix to the renamed classes" data-balloon-pos="bottom" data-balloon-length="medium"><i class="fas fa-circle-question"></i></div></label>`;
            content += `<div class="brxc__text"><input type="text" name="brxcClassManagerNew" id="brxc-bulkActionsSuffix" placeholder="Type here the suffix" value="${self.states.classManagerBulkActionSuffix}" onInput="ADMINBRXC.states.classManagerBulkActionSuffix = this.value;ADMINBRXC.setClassManagerBulkActionsList();"></div></div>`;
            if(self.states.classManagerBulkActionType === "Rename") content += `</fieldset>`;
        } 
        if(self.states.classManagerBulkActionType === "Duplicate"){
            content += `<div><label class="has-tooltip"><span>Assign duplicated classes to same elements:</span><div data-balloon="If yes, the duplicated classes will be added to the same elements where the original classes are assigned. This will apply on the current post only - not sitewide." data-balloon-pos="bottom" data-balloon-length="medium"><i class="fas fa-circle-question"></i></div></label>`;
            content += `<div class="brxc-overlay__panel-inline-btns-wrapper m-bottom-24">
                            <input type="radio" id="brxc-class-converter-assign-yes" name="brxc-class-converter-assign-elements" class="brxc-input__checkbox" value="0"${self.states.classManagerBulkAssignElements === false ? ' checked=""' : ''} onclick="ADMINBRXC.states.classManagerBulkAssignElements = false">
                            <label for="brxc-class-converter-assign-yes" class="brxc-overlay__panel-inline-btns">No</label>
                            <input type="radio" id="brxc-class-converter-assign-no" name="brxc-class-converter-assign-elements" class="brxc-input__checkbox" value="1"${self.states.classManagerBulkAssignElements === true ? ' checked=""' : ''} onclick="ADMINBRXC.states.classManagerBulkAssignElements = true">
                            <label for="brxc-class-converter-assign-no" class="brxc-overlay__panel-inline-btns">Yes</label>
                        </div></div>`;
            content += `<div><label class="has-tooltip"><span>Remove old classes from all the elements:</span><div data-balloon="If yes, the original classes will be removed from all the elements on this ${self.states.classManagerType === "global" ? 'post' : 'component'}. This will apply on the current post only - not sitewide." data-balloon-pos="bottom" data-balloon-length="medium"><i class="fas fa-circle-question"></i></div></label>`;
            content += `<div class="brxc-overlay__panel-inline-btns-wrapper m-bottom-24">
                            <input type="radio" id="brxc-class-converter-remove-yes" name="brxc-class-converter-remove-elements" class="brxc-input__checkbox" value="0"${self.states.classManagerBulkRemoveOldClass === false ? ' checked=""' : ''} onclick="ADMINBRXC.states.classManagerBulkRemoveOldClass = false">
                            <label for="brxc-class-converter-remove-yes" class="brxc-overlay__panel-inline-btns">No</label>
                            <input type="radio" id="brxc-class-converter-remove-no" name="brxc-class-converter-remove-elements" class="brxc-input__checkbox" value="1"${self.states.classManagerBulkRemoveOldClass === true ? ' checked=""' : ''} onclick="ADMINBRXC.states.classManagerBulkRemoveOldClass = true">
                            <label for="brxc-class-converter-remove-no" class="brxc-overlay__panel-inline-btns">Yes</label>
                        </div></div>`;
            content += `<div><label class="has-tooltip"><span>Delete old classes from the Global Classes list:</span><div data-balloon="If yes, the original classes will be deleted from the Global Classes list. This will apply sitewide and impact all your posts/pages." data-balloon-pos="bottom" data-balloon-length="medium"><i class="fas fa-circle-question"></i></div></label>`;
            content += `<div class="brxc-overlay__panel-inline-btns-wrapper m-bottom-24">
                            <input type="radio" id="brxc-class-converter-delete-yes" name="brxc-class-converter-delete-elements" class="brxc-input__checkbox" value="0"${self.states.classManagerBulkDeleteOldClass === false ? ' checked=""' : ''} onclick="ADMINBRXC.states.classManagerBulkDeleteOldClass = false">
                            <label for="brxc-class-converter-delete-yes" class="brxc-overlay__panel-inline-btns">No</label>
                            <input type="radio" id="brxc-class-converter-delete-no" name="brxc-class-converter-delete-elements" class="brxc-input__checkbox" value="1"${self.states.classManagerBulkDeleteOldClass === true ? ' checked=""' : ''} onclick="ADMINBRXC.states.classManagerBulkDeleteOldClass = true">
                            <label for="brxc-class-converter-delete-no" class="brxc-overlay__panel-inline-btns">Yes</label>
                        </div></div>`;
            content += `</fieldset>`;
        } else if(self.states.classManagerBulkActionType === "Group"){
            content += `<fieldset><legend>Action</legend>`;
            content += `<div><label class="has-tooltip"><span>Assign classes to the following group:</span><div data-balloon="Write here the group you want to assign the classes." data-balloon-pos="bottom" data-balloon-length="medium"><i class="fas fa-circle-question"></i></div></label>`;
            content += `<div class="brxc__text"><input type="text" name="brxcClassManagerNewGroup" id="brxc-bulkActionsNewGroup" placeholder="Type here the group you want to assign the classes" value="${self.states.classManagerBulkActionNewGroup}" onInput="ADMINBRXC.states.classManagerBulkActionNewGroup = this.value;ADMINBRXC.setClassManagerBulkActionsList();"></div></div>`;
            content += `</fieldset>`;
        } else if(self.states.classManagerBulkActionType === "Delete"){
            content += `<fieldset><legend>Action</legend>`;
            content += `<div><label class="has-tooltip"><span>Remove classes from all the elements:</span><div data-balloon="If yes, the targeted classes will be removed from all the elements on this ${self.states.classManagerType === "global" ? 'post' : 'component'}. This will apply on the current post only - not sitewide." data-balloon-pos="bottom" data-balloon-length="medium"><i class="fas fa-circle-question"></i></div></label>`;
            content += `<div class="brxc-overlay__panel-inline-btns-wrapper m-bottom-24">
                            <input type="radio" id="brxc-class-converter-remove-yes" name="brxc-class-converter-remove-elements" class="brxc-input__checkbox" value="0"${self.states.classManagerBulkRemoveOldClass === false ? ' checked=""' : ''} onclick="ADMINBRXC.states.classManagerBulkRemoveOldClass = false">
                            <label for="brxc-class-converter-remove-yes" class="brxc-overlay__panel-inline-btns">No</label>
                            <input type="radio" id="brxc-class-converter-remove-no" name="brxc-class-converter-remove-elements" class="brxc-input__checkbox" value="1"${self.states.classManagerBulkRemoveOldClass === true ? ' checked=""' : ''} onclick="ADMINBRXC.states.classManagerBulkRemoveOldClass = true">
                            <label for="brxc-class-converter-remove-no" class="brxc-overlay__panel-inline-btns">Yes</label>
                        </div></div>`;
            content += `<div><label class="has-tooltip"><span>Delete classes from the Global Classes list:</span><div data-balloon="If yes, the original classes will be deleted from the Global Classes list. This will apply sitewide and impact all your posts/pages." data-balloon-pos="bottom" data-balloon-length="medium"><i class="fas fa-circle-question"></i></div></label>`;
            content += `<div class="brxc-overlay__panel-inline-btns-wrapper m-bottom-24">
                            <input type="radio" id="brxc-class-converter-delete-yes" name="brxc-class-converter-delete-elements" class="brxc-input__checkbox" value="0"${self.states.classManagerBulkDeleteOldClass === false ? ' checked=""' : ''} onclick="ADMINBRXC.states.classManagerBulkDeleteOldClass = false">
                            <label for="brxc-class-converter-delete-yes" class="brxc-overlay__panel-inline-btns">No</label>
                            <input type="radio" id="brxc-class-converter-delete-no" name="brxc-class-converter-delete-elements" class="brxc-input__checkbox" value="1"${self.states.classManagerBulkDeleteOldClass === true ? ' checked=""' : ''} onclick="ADMINBRXC.states.classManagerBulkDeleteOldClass = true">
                            <label for="brxc-class-converter-delete-no" class="brxc-overlay__panel-inline-btns">Yes</label>
                        </div></div>`;
            content += `</fieldset>`;
        }
        content += `<div id="bulk${self.states.classManagerBulkActionType}ClassesCTA" class="brxc-overlay__action-btn-wrapper right sticky-bottom generate-content active"><div class="brxc-overlay__action-btn" onclick="ADMINBRXC.bulkClassesReset()"><span>Reset</span></div><div class="brxc-overlay__action-btn primary" onclick="ADMINBRXC.bulk${self.states.classManagerBulkActionType}Classes()"><span>${self.states.classManagerBulkActionType} Classes</span></div></div>`;

        canvas.innerHTML = content;

        const group = document.querySelector('#bulkActionsOptions');
        if (group) group.value = self.states.classManagerBulkActionTargetGroup;
        const lock = document.querySelector('#bulkActionsOptionsLock');
        if (lock) lock.value = self.states.classManagerBulkActionLock;
        const hasStyle = document.querySelector('#bulkActionsOptionsHasStyles');
        if (hasStyle) hasStyle.value = self.states.classManagerBulkActionHasStyles;
        const isActive = document.querySelector('#bulkActionsOptionsIsActive');
        if (isActive) isActive.value = self.states.classManagerBulkActionIsActive;

        const newGroup = document.querySelector('#brxc-bulkActionsNewGroup');
        if (newGroup){
            newGroup.addEventListener('keydown', () => {
                self.autocomplete(newGroup,self.vueState.globalClassesCategories.map(el => el && el.name),false);
            })
        } 
    },
    openClassManager: function(type) {
        const self = this;
        if(typeof self.vueState.globalClassesCategories === "undefined"){
            return alert('The class manager requires Bricks 1.9.5+ to be installed. Please upgrade your theme.')
        }
        ADMINBRXC.removeDuplicateClass();
        ADMINBRXC.states.classManagerType = type;
        ADMINBRXC.setClassManager();
        ADMINBRXC.setClassManagerBulk();
        ADMINBRXC.openModal(false, "#brxcClassManagerOverlay")
    },
    setClassManager: function(){
        const self = this;
        self.states.classManagerMaxClasses = 50;
        self.setCatList();
        self.setClassList();
        self.setClassContent();
    },
    setCatList: function(){
        const self = this;
        const listWrapper = document.querySelector('#brxcClassManagerOverlay #brxcCatListCanvas');
        if(!listWrapper || !Array.isArray(self.states.classManagerCategories)) return;
        let cats = '<ul>';
        let categoryFound;
        let count;

        function isActive (cat) {
            if(self.helpers.getClassCategoryIdByName(cat) === self.states.classManagerActiveCategory) return true;
            return false;
        }

        // All
        count = self.vueState.globalClasses.length;
        cats += `<li class="${self.states.classManagerActiveCategory === "All" ? 'active' : ''}"${self.states.classManagerActiveCategory === "All" ? ' data-active="true"' : ''} data-id="All" data-balloon="All" data-balloon-pos="right" onClick="ADMINBRXC.classManagerFilterCat(event)"><input type="text" value="All" readonly/><span class="count">${count}</span></li>`
        
        // Uncategorized
        count = Array.from(self.vueState.globalClasses).filter(el => el && (!el.category || self.helpers.getClassCategoryObjById(el.category) === false)).length;
        cats += `<li class="${self.states.classManagerActiveCategory === "Uncategorized" ? 'active' : ''}"${self.states.classManagerActiveCategory === "Uncategorized" ? ' data-active="true"' : ''} data-id="Uncategorized" data-balloon="Uncategorized" data-balloon-pos="right" onClick="ADMINBRXC.classManagerFilterCat(event)"><input type="text" value="Uncategorized" readonly/><span class="count">${count}</span></li>`

        // Categories
        const sortedCats = Array.from(self.vueState.globalClassesCategories).filter(el => el && el.name).map(el => el && el.name).sort((a, b) => a.localeCompare(b, undefined, {sensitivity: 'base'}));
        sortedCats.forEach(cat => {
            categoryFound = self.helpers.getClassCategoryObjByName(cat)
            count = Array.from(self.vueState.globalClasses).filter(el => el && el.hasOwnProperty('category') && categoryFound && categoryFound.id === el.category).length;
            cats += `<li class="${isActive(cat) ? 'active' : ''}"${isActive(cat) ? ' data-active="true"' : ''} data-id="${categoryFound.id}" data-balloon="${cat}" data-balloon-pos="right" ondragenter="this.classList.add('dragged')" ondragleave="this.classList.remove('dragged')" ondrop="event.preventDefault();ADMINBRXC.onDropCatList(this);" ondragover="event.preventDefault();" onClick="ADMINBRXC.classManagerFilterCat(event)"><input type="text" data-initial="${cat}" value="${cat}"${categoryFound.id !== self.states.classManagerActiveCategory ? ' readonly' : ''}/>${categoryFound.id === self.states.classManagerActiveCategory ? `<div class="deleteCat" onClick="event.stopPropagation();ADMINBRXC.deleteCategory('${self.states.classManagerActiveCategory}')" data-balloon="Delete category" data-balloon-pos="top-right"><span class="bricks-svg-wrapper"><i class="ti-trash"></i></span></div>` : `<span class="count">${count}</span>`}</li>`
            
        })

        cats += '</ul><input type="text" id="addNewCat" placeholder="+ New category" onkeyup="ADMINBRXC.addNewCategory(event);" />';
        if (self.helpers.isAIActive() && self.globalSettings.isAIApiKeyEmpty === "0" && self.states.classManagerCategories.length > 1) cats += `<a class="brxc-overlay__action-btn" style="margin-top: 12px;" onclick="ADMINBRXC.classCategoriesAI(this);"><span>Assign with AI</span></a>`;
        listWrapper.innerHTML = cats;

        // rename cat
        const input = listWrapper.querySelector('li.active input');
        if(input){
            input.addEventListener('keyup', (event) => {
                if(event.key !== "Enter") return;
                if(event.target.value === event.target.dataset.initial) return self.setCatList();
                if(self.states.classManagerCategories.includes(event.target.value)) return self.vueGlobalProp.$_showMessage(`ABORT: category "${event.target.value}" already exists`);
                const activeObj = self.helpers.getClassCategoryObjById(self.states.classManagerActiveCategory)
                activeObj.name = event.target.value;
                self.populateClassCategories();
                self.vueGlobalProp.$_showMessage(`Category correctly renamed to ${event.target.value}`)
                self.setCatList();
                self.setClassContent();
            })
        }
        
    },
    generateClassCategoriesAI: function (response){
        const self = this;
        const classes = JSON.parse(response).classes;
        const matchingClasses = classes.filter(el => el && el.hasOwnProperty('category') && el.category !== "noMatch" && self.helpers.getClassCategoryIdByName(el.category));
        if(matchingClasses.length > 0){
            matchingClasses.forEach(cls => {
                const obj = Array.from(self.vueState.globalClasses).find(el => el && el.hasOwnProperty('id') && cls.id === el.id);
                if (obj && (!obj.hasOwnProperty('category') || self.helpers.getClassCategoryObjById(obj.category) === false) ) {
                    obj.category = self.helpers.getClassCategoryIdByName(cls.category)
                } else {
                    console.log('Error')
                }
            })
        }
        self.populateClassCategories();
        self.setCatList();
        self.setClassList();
    },
    classCategoriesAI: function(target){
        const self = this;
        const obj = [];
        const defaultModel = self.globalSettings.defaultAIModel;
        self.vueState.globalClasses.forEach(cls => {
            if(!cls.hasOwnProperty('category') || self.helpers.getClassCategoryObjById(cls.category) === false){
                obj.push({
                    id: cls.id,
                    name: cls.name.replaceAll('__', ' ').replaceAll('_', ' ').replaceAll('--', ' ').replaceAll('-', ' '),
                })
            }
        })
        target.classList.add('disable');
        const categories = Array.from(self.vueState.globalClassesCategories).map(el => el && el.name)
        categories.shift();
        categories.push('Others');
        const json = {
            "model": defaultModel,
            "messages": [
              {
                "role":"user",
                "content": `Given the following object: ${JSON.stringify(obj)}. Assign each object to an existing category. Check the name provided in each object to determine if it can be related to a provided category. If no match is found, assign it to "noMatch".`,
              }
            ],
            "functions":[{
                "name":"generateClassCategoriesAI",
                "description":"Assign categories to objects.",
                "parameters":{
                   "type":"object",
                   "properties":{
                      "classes":{
                         "type":"array",
                         "items":{
                            "type":"object",
                            "properties":{
                               "id":{
                                  "type":"string",
                                  "description":"The object's ID"
                               },
                               "category":{
                                  "type":"string",
                                  "description":"The object's category",
                                  "enum": categories
                               }
                            }
                         }
                      }
                   },
                   "required":[
                      "classes"
                   ]
                }
             }],
            "function_call": "auto",
            "temperature": 0
          }

        jQuery.ajax({
            type: 'POST',
            url: openai_ajax_req.ajax_url,
            data: {
                action: 'openai_ajax_function',
                nonce: openai_ajax_req.nonce,
            },
            success: function(response) {
                const post = async () => {
                    const rawResponse = await fetch('https://api.openai.com/v1/chat/completions', {
                      method: 'POST',
                      headers: {
                          'Content-Type': 'application/json',
                          'Authorization' : 'Bearer '+ response,
                        },
                      body: JSON.stringify(json)
                    });
                    const content = await rawResponse.json();
                    console.log(content);
                    if(content.error){
                        self.insertErrorMessage('classManager', false, '#brxcClassManagerOverlay', content.error.message);
                        target.classList.remove('disable');
                    } else {
                        target.classList.remove('disable');
                        self.generateClassCategoriesAI(content.choices[0].message.function_call.arguments);
                    }
                };
                post();
            },
            error: function(response){
                console.log('Something went wrong with the OpenAI AJAX request: ' + response);
                target.classList.remove('disable');
            }
        });
    },
    onDropCatList: function(target){
        const self = this;
        const obj = self.vueGlobalProp.$_getGlobalClass(self.states.classManagerStartDrag);
        if(obj.hasOwnProperty('catetory') && obj.category === target.dataset.id) return self.vueGlobalProp.$_showMessage(`WARNING: Category ${target.dataset.id} already assigned to ${obj.name}!`);
        obj.category = target.dataset.id;
        self.vueGlobalProp.$_showMessage(`Category ${target.dataset.id} correctly assigned to ${obj.name}!`)
        if(self.states.classManagerActiveClass === self.states.classManagerStartDrag) self.setClassContent();
        self.setCatList();
        self.setClassList();
        self.setClassContent();
    },
    deleteCategory: function(catId){
        const self = this;
        const obj = self.helpers.getClassCategoryObjById(catId);
        self.vueState.globalClassesCategories.splice(self.vueState.globalClassesCategories.indexOf(obj), 1);
        self.states.classManagerActiveCategory = "All";

        const cls = Array.from(self.vueState.globalClasses).filter(el => el && el.hasOwnProperty('category') && el.category === catId);
        let hasChanges = false
        cls.forEach(el => {
            hasChanges = true
            delete el.category;
        })
        if(hasChanges) self.helpers.saveChanges('globalClasses');

        self.populateClassCategories();
        self.setCatList();
        self.setClassList();
        self.setClassContent();
    },
    addNewCategory: function(event){
        const self = this;

        if(event.key !== "Enter") return;

        const values = event.target.value.split(' ');
        if(values.length < 1) return;

        let hasChanges = false;

        values.forEach(name => {
            if(Array.from(self.vueState.globalClassesCategories).map(obj => obj && obj.name).includes(name)) {
                return self.vueGlobalProp.$_showMessage('ABORT: category already exists');
            } else {
                hasChanges = true;
                self.helpers.createClassCategory(name);
                self.helpers.saveChanges('globalClasses');

            }
        })
        if(hasChanges === true) {
            //self.states.classManagerCategories.sort();
            self.states.classManagerActiveCategory = self.helpers.getClassCategoryIdByName(values[values.length - 1]);
            self.setCatList();
            self.setClassList();
        };  
    },
    classManagerFilterCat: function(event){
        const self = this;
        target = (event.target.dataset.id) ? event.target : event.target.parentElement;
        if(target.dataset.active === 'true') return;
        self.states.classManagerActiveCategory = target.dataset.id;
        self.setCatList();
        self.setClassList();
    },
    setClassList: function(){
        const self = this;
        const listWrapper = document.querySelector('#brxcClassManagerOverlay #brxcClassListCanvas');
        const template = self.helpers.getTemplateType();
        let count = 0;
        let classes = '<ul>';
        let globalClasses;
        const fullList = self.states.classManagerSearch === '' && self.states.classManagerType ===  "global" && self.states.classManagerFilterLocked === false && self.states.classManagerFilterActive === false && self.states.classManagerFilterStyle === false;

        // Type
        if(self.states.classManagerType === "global") {
            globalClasses = self.vueState.globalClasses;
         } else {
            globalClasses = [];
            const tempClasses = self.helpers.getComponentClasses([],self.vueState.activeElement.id);

            if(tempClasses.length > 0){
                tempClasses.forEach(el => {
                    if(typeof self.vueGlobalProp.$_getGlobalClass(el) === "object") globalClasses.push(self.vueGlobalProp.$_getGlobalClass(el))
                })
                globalClasses = globalClasses.concat(Array.from(self.vueState.globalClasses).filter(el => el && el.new === true))
            }
         }
         // Uncategorized
         if(self.states.classManagerActiveCategory === "Uncategorized"){
            globalClasses = Array.from(globalClasses).filter(el => el && (!el.category || self.helpers.getClassCategoryObjById(el.category) === false));

        // Cat
         } else if(self.states.classManagerActiveCategory !== "All"){
            globalClasses = Array.from(globalClasses).filter(el => el && el.hasOwnProperty('category') && el.category === self.states.classManagerActiveCategory);
         }

         // Search
        globalClasses = (self.states.classManagerSearch === '') ? globalClasses : Array.from(globalClasses).filter(el => el.name.includes(self.states.classManagerSearch));

        // Filter By Style
        if (self.states.classManagerFilterStyle === "has-styles") {
            globalClasses = Array.from(globalClasses).filter(el1 => el1 && self.vueGlobalProp.$_generateCss('globalClass',el1.id,['block']) !== '');
        } else if (self.states.classManagerFilterStyle === "has-no-styles"){
            globalClasses = Array.from(globalClasses).filter(el1 => el1 && self.vueGlobalProp.$_generateCss('globalClass',el1.id,['block']) === '');
        }

        // Filter By Active
        if (self.states.classManagerFilterActive === 'is-active') {
            globalClasses = Array.from(globalClasses).filter(el1 => el1 && Array.from(self.vueState[template]).find(el => el && el.settings._cssGlobalClasses && Array.isArray(el.settings._cssGlobalClasses) && el.settings._cssGlobalClasses.includes(el1.id)));
        } else if (self.states.classManagerFilterActive === 'is-not-active') {
            globalClasses = Array.from(globalClasses).filter(el1 => {
                const matchingElements = Array.from(self.vueState[template]).filter(el => el &&
                  el.settings._cssGlobalClasses &&
                  Array.isArray(el.settings._cssGlobalClasses) &&
                  el.settings._cssGlobalClasses.includes(el1.id)
                );
                return matchingElements.length === 0;
            });
        }
        
        // Filter By Status
        if(self.states.classManagerFilterLocked === "locked"){
            globalClasses = Array.from(globalClasses).filter(el => el && el.hasOwnProperty('id') && self.vueGlobalProp.$_isLocked(el.id));
        } else if(self.states.classManagerFilterLocked === "unlocked"){
            globalClasses = Array.from(globalClasses).filter(el => el && el.hasOwnProperty('id') && !self.vueGlobalProp.$_isLocked(el.id));
        }

        index = 1;
        globalClasses.slice(0, self.states.classManagerMaxClasses).forEach(cls => {
            let active;
            (Array.from(self.vueState[template]).find(el => el && el.settings._cssGlobalClasses && Array.isArray(el.settings._cssGlobalClasses) && el.settings._cssGlobalClasses.includes(cls.id))) ? active = 'active' : active = '';
            classes += `<li data-order="${index - 1}" class="${active}${self.states.classManagerActiveClass === cls.id ? ' selected' : ''}" data-id="${cls.id}">
                            <div class="span-wrapper" onClick="ADMINBRXC.selectClass('${cls.id}', this);"${!fullList ? ` data-id="${cls.id}" draggable=true` : ''}>
                                <div class="handle"><i class="ti-move"></i></div>
                                <span>.${cls.name}</span>
                            </div>
                            <div class="actions">
                                ${self.vueGlobalProp.$_generateCss('globalClass',cls.id,['block']) !== '' ? `<div class="css3-icon" data-balloon="Has styles assigned" data-balloon-pos="bottom-right""><span class="bricks-svg-wrapper"><i class="fab fa-css3-alt"></i></span></div>` : ''}
                                ${self.vueGlobalProp.$_isLocked(cls.id) ? `<div class="lock-icon" data-balloon="Unlock class" data-balloon-pos="bottom-right" onclick="ADMINBRXC.changeLockStatus('${cls.id}', 'unlock');"><span class="bricks-svg-wrapper"><i class="fas fa-lock"></i></span></div>` : `<div class="unlock-icon" data-balloon="Lock class" data-balloon-pos="bottom-right" onclick="ADMINBRXC.changeLockStatus('${cls.id}', 'lock');"><span class="bricks-svg-wrapper"><i class="fas fa-unlock"></i></span></div>`}
                                <div class="clone-icon" data-balloon="Duplicate class" data-balloon-pos="bottom-right" onClick="ADMINBRXC.duplicateClass('${cls.id}');"><span class="bricks-svg-wrapper"><i class="fas fa-clone"></i></span></div>
                                <div class="clone-icon" data-balloon="Copy to Clipboard" data-balloon-pos="bottom-right" onClick="ADMINBRXC.copytoClipboardSimple('${cls.name}','${cls.name} successfully copied to clipboard');"><span class="bricks-svg-wrapper"><i class="fas fa-clipboard"></i></span></div>
                                <div class="trash-icon" data-balloon="Delete class" data-balloon-pos="bottom-right" onClick="ADMINBRXC.deleteClass('${cls.id}');"><span class="bricks-svg-wrapper"><i class="ti-trash"></i></span></div>
                            </div>
                        </li>`;
            if(index === self.states.classManagerMaxClasses && self.states.classManagerMaxClasses < globalClasses.length) classes += `<li class="ignore-drag" onclick="ADMINBRXC.loadMoreClasses(${globalClasses.length});ADMINBRXC.setClassList();"><div class="span-wrapper"><span class="max-results">Load ${globalClasses.length - 50} more classes....</span></div></li>`;
            index++;
        })
        classes += '</ul>';
        classes += `<div class="brxc-class-manager__footer"><input type="text" id="addNewClass" placeholder="Add a new class" onkeyup="ADMINBRXC.addNewClass(event);" /></div>`;
        listWrapper.innerHTML = classes;

        //Drag and drop
        if(fullList){
            const classWrapper = listWrapper.querySelector('ul');
            function move(arr, from, to, on = 1) {
                return arr.splice(to, 0, ...arr.splice(from, on)), arr
            }
            new Sortable(classWrapper, {
                multiDrag: true,
                selectedClass: "sortable-selected", // Class name for selected item
                animation: 150,
                handle: "li .handle",
                filter: ".ignore-drag",
                helper : 'clone',
                onStart: function (evt) {
                    self.states.classManagerStartDrag = evt.item.dataset.id;
                },
                onEnd: function (evt) {
                    const items = Array.from(classWrapper.children).filter(child => child && !child.classList.contains('ignore-drag'));
                    const reorderedClasses = [];
                    const newOrder = items.map(item => parseInt(item.getAttribute('data-order')));
                    newOrder.forEach(el => {
                        reorderedClasses.push(self.vueState.globalClasses[el])
                    })
                    reorderedClasses.forEach((el, ind) => {
                        self.vueState.globalClasses[ind] = JSON.parse(JSON.stringify(el));
                    })
                    self.setClassList();
                    self.setClassContent();
                    self.helpers.saveChanges('globalClasses');
                    setTimeout(() => evt.item.querySelector('.span-wrapper').click(), 0);
                },
            })
        } else {
            const items = listWrapper.querySelectorAll('ul li .span-wrapper');
            items.forEach(el => {
                el.addEventListener('mousedown', (e) => {
                    self.states.classManagerStartDrag = el.dataset.id;
                })
            })
        }

    },
    setClassContent: function(del = false){
        const self = this;
        const classId = self.states.classManagerActiveClass;
        const obj = self.vueGlobalProp.$_getGlobalClass(classId);
        const contenttWrapper = document.querySelector('#brxcClassManagerOverlay #brxcClassContentCanvas');

        // function createTarget(){
        //     let target = '_cssCustom';
        //     const bpSettings = Array.from(self.vueState.breakpoints).find(el => el.key === self.vueState.breakpointActive);
        //     if(bpSettings.key !== "desktop"){
        //         target += `:${bpSettings.key}`;
        //     }
        //     return target;
        // }

        const target = self.helpers.createTarget('_cssCustom');
        const targetSass = self.helpers.createTarget('_cssCustomSass');

        if (classId === '' || del) return contenttWrapper.innerHTML = '<label class="brxc-input__label"><span>Select a class in the left menu.</span></label>';
        // Header
        let header = `<div class="brxc-class-manager__content-header">`
        header += `<div style="width: 100%;"><label class="brxc-input__label has-tooltip"><span>Name</span><span class="brxc__light">(ID: ${obj.id})</span><div data-balloon="To rename the current class, just type the new name inside the input and press ENTER" data-balloon-pos="bottom-left" data-balloon-length="medium"><i class="fas fa-circle-question"></i></div></label><input id="nameInput"type="text" value="${obj.name}"/></div>`;
        header += `<div style="width: 75%;position: relative;"><label class="brxc-input__label has-tooltip"><span>Category</span><div data-balloon="To assign the class to specific category, just type the new name inside the input and press ENTER" data-balloon-pos="bottom" data-balloon-length="medium"><i class="fas fa-circle-question"></i></div></label><input id="catInput"type="text" value="${obj.hasOwnProperty('category') && self.helpers.getClassCategoryNameById(obj.category) !== false ? self.helpers.getClassCategoryNameById(obj.category) : ''}"/></div>`;
        header += `<div style="position:relative;"><label class="brxc-input__label has-tooltip"><span>Order</span><div data-balloon="Changing this value will impact the order of the current class inside the Class Dropdown." data-balloon-pos="bottom-right" data-balloon-length="medium"><i class="fas fa-circle-question"></i></div></label>`;
        header += `<input type="text" id="orderInput" value="${self.vueState.globalClasses.indexOf(obj) + 1}"/>`;
        header += `<span class="units">/ ${self.vueState.globalClasses.length}</span></div>`;
        header += `</div>`;

        // Status
        let status = `<div class="wrapper"><div class="left-wrapper"><div class="brxc-class-manager__content-status"><label class="brxc-input__label has-tooltip"><span>Status</span><div data-balloon="Click on the following buttons to lock/unlock the current class" data-balloon-pos="bottom-left" data-balloon-length="medium"><i class="fas fa-circle-question"></i></div></label><div class="brxc-overlay__action-btn-wrapper">`
        status += `<div class="brxc-overlay__action-btn${self.vueGlobalProp.$_isLocked(classId) ? ' primary' : ''}" onClick="ADMINBRXC.changeLockStatus('${classId}','lock');">Locked</div>`;
        status += `<div class="brxc-overlay__action-btn${!self.vueGlobalProp.$_isLocked(classId) ? ' primary' : ''}" onClick="ADMINBRXC.changeLockStatus('${classId}','unlock');">Unlocked</div>`;
        status += `</div></div>`;

        // Descriptiom
        let description = `<div class="brxc-class-manager__content-description"><label class="brxc-input__label has-tooltip"><span>Description</span><div data-balloon="Type a description of the class. This field is only for management purposes and has no effect on frontend" data-balloon-pos="bottom-left" data-balloon-length="medium"><i class="fas fa-circle-question"></i></div></label>`;
        description += `<textarea style="margin:0" placeholder="Give your class a description here" oninput="ADMINBRXC.updateClassDescription('${classId}', event.currentTarget.value);">${obj.hasOwnProperty('description') ? obj.description : ''}</textarea>`;
        description += `</div>`
        // Class used on the following elements
        let used = '';
        const template = self.helpers.getTemplateType();
        const activeElements = Array.from(self.vueState[template]).filter(el => el && el.settings.hasOwnProperty('_cssGlobalClasses') && Array.isArray(el.settings._cssGlobalClasses) && el.settings._cssGlobalClasses.includes(classId));
        if(activeElements.length > 0){
            used += `<div class="brxc-class-manager__content-used"><label class="brxc-input__label has-tooltip"><span>Class used <strong>${activeElements.length} time(s)</strong> on the following elements</span><div data-balloon="The following elements have the current class assigned. Clicking on a button will close the Class Manager and open the selected element inside the builder." data-balloon-pos="bottom" data-balloon-length="large"><i class="fas fa-circle-question"></i></div></label>`;
            used += `<ul class="brxc-overlay__action-btn-wrapper">`; 
            activeElements.forEach(el => {
                //used += `<div class="brxc-overlay__action-btn" data-balloon="Open" data-balloon-pos="top" onClick="ADMINBRXC.openElement('${el.id}');ADMINBRXC.closeModal(event, event.target, '#brxcClassManagerOverlay');">${el.label ? self.helpers.escapeHtmlSpecialChars(el.label) : el.name}</div>`; 
                used += `<li class="" data-balloon="Open" data-balloon-pos="top" onClick="ADMINBRXC.openElement('${el.id}');ADMINBRXC.closeModal(event, event.target, '#brxcClassManagerOverlay');">
                            <div class="icon"><i class="${bricksData.elements[el.name].icon}"></i></div>
                            <span>${el.label ? self.helpers.escapeHtmlSpecialChars(el.label) : bricksData.elements[el.name].label}</span>
                        </li>`
            })
            used += `</ul></div></div>`; 
        } else {
            used += `<div><label class="brxc-input__label"><span>Used on this page</span></label><p class="no-result" data-control="info">This class isn't set on any element inside this page</p></div></div>`;
        }

        // Generated CSS
        let css = `<div class="brxc-class-manager__content-css"><div class="label-wrapper"><label class="brxc-input__label has-tooltip"><span>Custom CSS</span>${self.globalSettings.superPowerCSSEnableSass ? '<span class="highlight">SASS</span>' : ''}<div data-balloon="The following CSS will be applied to the current class and can be modified inside the Style tab -> Custom CSS control. Click the breakpoint icons to wrap your CSS code inside your desired media-query" data-balloon-pos="bottom-left" data-balloon-length="large"><i class="fas fa-circle-question"></i></div></label>`;
        css += `<ul class="action-wrapper">`;
        if(!self.vueGlobalProp.$_isLocked(obj.id)){
            css += `<li class="brxc-group-icon${self.states.classManagerisAIopen ? ` active` : ""}" data-balloon="Generate CSS with AI" data-balloon-pos="bottom" onclick="ADMINBRXC.activateCSSAI();"><span class="bricks-svg-wrapper"><i class="bricks-svg fas fa-robot" style="width:100%;"></i></span></li>`;
            css += `<li class="brxc-group-icon" data-balloon="Insert %root% {}" data-balloon-pos="bottom" onclick="ADMINBRXC.addRootTag(event, '.brxc-class-manager__content-css');"><span class="bricks-svg-wrapper"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 48 48" class="brxc__svg-path"><path d="M28.5 40v-3h6q1.05 0 1.775-.725Q37 35.55 37 34.5v-5q0-1.85 1.125-3.3 1.125-1.45 2.875-2v-.4q-1.75-.5-2.875-1.975T37 18.5v-5q0-1.05-.725-1.775Q35.55 11 34.5 11h-6V8h6q2.3 0 3.9 1.6t1.6 3.9v5q0 1.05.725 1.775Q41.45 21 42.5 21H44v6h-1.5q-1.05 0-1.775.725Q40 28.45 40 29.5v5q0 2.3-1.6 3.9T34.5 40Zm-15 0q-2.3 0-3.9-1.6T8 34.5v-5q0-1.05-.725-1.775Q6.55 27 5.5 27H4v-6h1.5q1.05 0 1.775-.725Q8 19.55 8 18.5v-5q0-2.3 1.6-3.9T13.5 8h6v3h-6q-1.05 0-1.775.725Q11 12.45 11 13.5v5q0 1.85-1.125 3.325T7 23.8v.4q1.75.55 2.875 2T11 29.5v5q0 1.05.725 1.775Q12.45 37 13.5 37h6v3Z"></path></svg></span></li>`;
        }
        
        css += `</ul><ul class="breakpoint-wrapper">`;
        self.vueState.breakpoints.forEach(bp =>{
            let svg = '<span class="bricks-svg-wrapper"><svg version="1.1" viewBox="0 0 30 30" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" class="bricks-svg"><path d="M27.744,2.5h-25.488c-0.968,0 -1.756,0.788 -1.756,1.755v17.489c0,0.968 0.788,1.755 1.756,1.755h12.244v3h-5.5c-0.276,0 -0.5,0.224 -0.5,0.5c0,0.276 0.224,0.5 0.5,0.5h12c0.276,0 0.5,-0.224 0.5,-0.5c0,-0.276 -0.224,-0.5 -0.5,-0.5h-5.5v-3h12.244c0.968,0 1.756,-0.788 1.756,-1.755v-17.489c0,-0.967 -0.788,-1.755 -1.756,-1.755Zm-1.244,18h-23v-15h23v15Z" fill="currentColor"></path></svg></span>';
            if( bp.icon === "laptop") {
                svg = '<span class="bricks-svg-wrapper"><svg version="1.1" viewBox="0 0 512 512" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" class="bricks-svg"><path d="M80.14,400c-17.7503,0 -32.14,-14.3897 -32.14,-32.14v-239.72c0,-17.7503 14.3897,-32.14 32.14,-32.14h351.72c17.7503,0 32.14,14.3897 32.14,32.14v239.72c0,17.7503 -14.3897,32.14 -32.14,32.14Z" stroke-width="32" stroke="currentColor" fill="none" stroke-linejoin="round"></path><path fill="currentColor" stroke="currentColor" stroke-linecap="round" stroke-width="32" d="M16,416h480"></path></svg></span>';
            }
            if( bp.icon === "tablet-landscape") {
                svg = '<span class="bricks-svg-wrapper"><svg version="1.1" viewBox="0 0 512 512" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" class="bricks-svg"><g transform="matrix(1,0,0,1,0,512)"><path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="32" d="M128,496c-26.5094,0 -48,-21.4906 -48,-48v-384c0,-26.5094 21.4906,-48 48,-48h256c26.5094,0 48,21.4906 48,48v384c0,26.5094 -21.4906,48 -48,48Z" transform="matrix(6.12323e-17,-1,1,6.12323e-17,0,0)"></path></g></svg></span>';
            }
            if( bp.icon === "tablet-portrait") {
                svg = '<span class="bricks-svg-wrapper"><svg version="1.1" viewBox="0 0 512 512" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" class="bricks-svg"><path d="M128,496c-26.5094,0 -48,-21.4906 -48,-48v-384c0,-26.5094 21.4906,-48 48,-48h256c26.5094,0 48,21.4906 48,48v384c0,26.5094 -21.4906,48 -48,48Z" stroke-linecap="round" stroke-width="32" stroke="currentColor" fill="none" stroke-linejoin="round"></path></svg></span>';
            }
            if( bp.icon === "phone-landscape") {
                svg = '<span class="bricks-svg-wrapper"><svg version="1.1" viewBox="0 0 512 512" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" class="bricks-svg"><g transform="matrix(1,0,0,1,0,512)"><path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="32" d="M176,496c-26.5094,0 -48,-21.4906 -48,-48v-384c0,-26.5094 21.4906,-48 48,-48h160c26.5094,0 48,21.4906 48,48v384c0,26.5094 -21.4906,48 -48,48Z" transform="matrix(6.12323e-17,-1,1,6.12323e-17,0,0)"></path></g><path d="M16,336v-24l9.23706e-14,1.20797e-06c-6.67141e-07,-4.41828 3.58172,-8 8,-8v0h-6.99382e-07c8.83656,3.86258e-07 16,-7.16344 16,-16v-64v0c0,-8.83656 -7.16344,-16 -16,-16v0h-3.49691e-07c-4.41828,-1.93129e-07 -8,-3.58172 -8,-8c0,0 0,-2.84217e-14 0,-2.84217e-14v-24" stroke-linecap="round" stroke-width="32" stroke="currentColor" fill="none" stroke-linejoin="round"></path></svg></span>';
            }
            if( bp.icon === "phone-portrait") {
                svg = '<span class="bricks-svg-wrapper"><svg version="1.1" viewBox="0 0 512 512" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" class="bricks-svg"><g stroke-linecap="round" stroke-width="32" stroke="currentColor" fill="none" stroke-linejoin="round"><path d="M176,496c-26.5094,0 -48,-21.4906 -48,-48v-384c0,-26.5094 21.4906,-48 48,-48h160c26.5094,0 48,21.4906 48,48v384c0,26.5094 -21.4906,48 -48,48Z"></path><path d="M176,16h24l-3.49691e-07,7.10543e-15c4.41828,-1.93129e-07 8,3.58172 8,8v0l1.7053e-13,2.41593e-06c1.33428e-06,8.83656 7.16345,16 16,16h64l-6.99382e-07,-1.42109e-14c8.83656,3.86258e-07 16,-7.16344 16,-16v0l1.13687e-13,1.20797e-06c-6.67141e-07,-4.41828 3.58172,-8 8,-8h24"></path></g></svg></span>';
            }
            let selector = `_cssCustom`;
            if(bp.key !== 'desktop'){
                selector += `:${bp.key}`;
            }
            css += `<li class="brxc-group-icon${self.vueState.breakpointActive === bp.key ? ' active' : ''}${obj.settings.hasOwnProperty(selector) && obj.settings[selector] !== '' ? ' has-styles' : ''}" data-balloon="${bp.label}" data-balloon-pos="bottom-right" onclick="ADMINBRXC.vueState.breakpointActive = '${bp.key}';ADMINBRXC.setClassContent();">${svg}</li>`;
        })
        css += '</ul></div>';
        if(self.states.classManagerisAIopen && !self.vueGlobalProp.$_isLocked(obj.id)) css += `<div id="submitCSSPromptWrapper"><input type="text" id="submitCSSPrompt" placeholder="Submit your prompt here and hit ENTER" onkeydown="ADMINBRXC.callAPIforClassManagerCSS(event)" /></div>`;
        let cssTarget = self.globalSettings.superPowerCSSEnableSass && obj.settings.hasOwnProperty('_cssCustomSass') ? targetSass : target;
        const textareaContent = obj.settings.hasOwnProperty(cssTarget) ? obj.settings[cssTarget] : '';
        css += `<div class="brxc-codemirror__wrapper"><textarea data-type="class-manager-custom-css">${self.vueGlobalProp.$_replaceCustomCssRoot('.' + obj.name,'%root%', textareaContent)}</textarea>`;
        css += `<div class="brxc-overlay__action-btn" style="margin-left: auto" onclick="ADMINBRXC.copytoClipboard(this, this.previousElementSibling.CodeMirror.getValue(), 'Copied!', 'Copy to Clipboard')"><span>Copy to Clipboard</span></div></div>`;
        css += `<label class="brxc-input__label has-tooltip"><span>Generated CSS</span><div data-balloon="The following CSS is the generated code by Bricks on the frontend, thus it's read-only" data-balloon-pos="bottom" data-balloon-length="medium"><i class="fas fa-circle-question"></i></div></label>`; 
        css += self.setStyleCSS("globalClass", obj, ['block']);
        css += '</div></div>'
        contenttWrapper.innerHTML = header + status + description + used + css;

        // Custom CSS

        function mountCM(classId, isLocked){
            const options = self.codeMirrorOptions(document.querySelector('textarea[data-type="class-manager-custom-css"]'));
            options.styleActiveLine = true;
            options.autoCloseBrackets = true;
            options.matchBrackets = true;
            options.selfContain = true;
            options.autofocus = true;
            options.search = { bottom: false };

            const MyCM = CodeMirror.fromTextArea(document.querySelector('textarea[data-type="class-manager-custom-css"]'), self.codeMirrorOptions(options))
            setTimeout(() => {
                MyCM.focus();
                MyCM.setCursor(MyCM.lineCount(), 0);
                if (isLocked) {
                    MyCM.getWrapperElement().classList.add("disable");
                    MyCM.setOption('readOnly',  true);
                }
            }, 1)
            MyCM.getWrapperElement().setAttribute("data-type", "at");
            MyCM.setOption('gutters', []);
            MyCM.on("keydown", function (cm, event) {
                if (!cm.state.completionActive &&
                    ((event.key >= '0' && event.key <= '9') ||    // Digits 0-9
                        (event.key >= 'a' && event.key <= 'z') ||    // Letters a-z
                        event.key === '(' || event.key === '!' ||    // Opening parenthesis (
                        event.key === '-') &&                        // Dash
                    !event.metaKey && !event.altKey && event.key !== '{' && event.key !== '}' &&
                    !event.ctrlKey) {
                    CodeMirror.commands.autocomplete(cm, null, { completeSingle: false });
                }

                if(event.metaKey && event.shiftKey && event.key === "7" ){
                    cm.toggleComment();
                }

                if (event.key === 'Tab') {
                    self.helpers.replaceRWithRoot(myCodeMirror, event)
                }
            })

            MyCM.on("keyup", function (cm) {
                const obj = self.vueGlobalProp.$_getGlobalClass(classId);
                if (!obj) return;

                const selector = `.${obj.name}`;
                const newValue = self.vueGlobalProp.$_replaceCustomCssRoot('%root%', selector, cm.getValue());

                if(Object.getPrototypeOf(obj.settings).length === 0) obj.settings = {};

                if (newValue === "") {
                    delete obj.settings[target];
                    if(self.globalSettings.superPowerCSSEnableSass) delete obj.settings[targetSass];
                } else {
                    if(self.globalSettings.superPowerCSSEnableSass){
                        const dataOptions = { indent_size: 2, space_in_empty_paren: false }
                        Sass.compile( newValue, function(result) {
                        if (result.status === 0) {
                            obj.settings[target] = css_beautify(result.text, dataOptions);
                            obj.settings[targetSass] = newValue;
                        }
                    });
                    } else {
                        obj.settings[target] = newValue;
                    }
                }

                // Generated CSS
                const generatedCSS = contenttWrapper.querySelector('[data-type="generated-css"]');
                const dataOptions = { indent_size: 2, space_in_empty_paren: false }
                setTimeout(() => {generatedCSS.CodeMirror.setValue(css_beautify(self.vueGlobalProp.$_generateCss('globalClass', classId, ['block']).replaceAll('.brxe-block', ''), dataOptions))}, 5);
                
                // Save Global Classes
                self.helpers.saveChanges('globalClasses');
            });
        }

        mountCM(classId, self.vueGlobalProp.$_isLocked(classId))

        // Generated CSS
        const textarea= contenttWrapper.querySelector('textarea.brxc-style-overview-css');
        if(textarea) {
            const dataOptions = { indent_size: 2, space_in_empty_paren: false }
            const dataObj = textarea.textContent.replaceAll('.brxe-block', '');
            const options = self.codeMirrorOptions(textarea);
            options.autofocus = false;
            const MyCM = CodeMirror.fromTextArea(textarea, self.codeMirrorOptions(options));
            MyCM.getWrapperElement().setAttribute('data-type', 'generated-css');
            MyCM.setValue(css_beautify(dataObj, dataOptions));
            MyCM.setOption('readOnly',  true);
            MyCM.setOption('gutters', []);
        };

        // Name event
        const nameInput = contenttWrapper.querySelector('#nameInput');
        if(nameInput){
            nameInput.addEventListener('keyup', function(e){
                if (e.key === 'Enter'){

                    function replaceRootCustomCss(target, obj, oldName, newName){
                        if(obj.settings.hasOwnProperty(target)) return obj.settings[target] = obj.settings[target].replaceAll(`.${oldName}`, `.${newName}`);
            
                    }
                    function loopCustomCss(obj, oldName, newName){
                        let target = "_cssCustom";
                        if(obj.settings.hasOwnProperty(target)) replaceRootCustomCss(target, obj, oldName, newName);
                        const bps = self.vueState.breakpoints
                        bps.forEach(bp => {
                            target += `:${bp.key}`;
                            if(obj.settings.hasOwnProperty(target)) replaceRootCustomCss(target, obj, oldName, newName);
                        })
                    }

                    const obj = self.vueGlobalProp.$_getGlobalClass(self.states.classManagerActiveClass);
                    const oldName = obj.name;
                    if(nameInput.value.length < 1) return self.vueGlobalProp.$_showMessage('Insert at least 1 character');
                    if(!self.helpers.isValidCSSClassName(nameInput.value)) return self.vueGlobalProp.$_showMessage('Invalid Character in the class name');
                    if(oldName === nameInput.value) return;
                    if(Array.from(self.vueState.globalClasses).find(el => el && el.hasOwnProperty('name') && el.name === nameInput.value)) return self.vueGlobalProp.$_showMessage('Class Name already exists!');
                    obj.name = nameInput.value;
                    loopCustomCss(obj, oldName, nameInput.value);
                    self.setClassList();
                    self.setClassContent();
                    self.vueGlobalProp.$_showMessage('Class successfully renamed!');
                    self.helpers.saveChanges('globalClasses');
                }
            })
        }

        // Cat event
        const catInput = contenttWrapper.querySelector('#catInput');
        if(catInput){
            catInput.addEventListener('keyup', function(e){
                if (e.key === 'Enter'){
                    const obj = self.vueGlobalProp.$_getGlobalClass(self.states.classManagerActiveClass);
                    const oldCat = obj.category;
                    const oldCatObj = self.helpers.getClassCategoryNameById(oldCat);
                    if(catInput.value.length < 1) {
                        delete obj.category;
                        return self.vueGlobalProp.$_showMessage('Category successfully removed!')
                    }
                    if(oldCat && oldCatObj.name === catInput.value) return;
                    let newCatId;
                    if(!Array.from(self.vueState.globalClassesCategories).map(el => el && el.name).includes(catInput.value)) {
                        newCatId = self.vueGlobalProp.$_generateId()
                        self.vueState.globalClassesCategories.push({
                            id: newCatId,
                            name: catInput.value,
                        })
                        obj.category = newCatId;
                        self.states.classManagerActiveCategory = newCatId;
                    } else {
                        newCatId = self.helpers.getClassCategoryIdByName(catInput.value);
                        obj.category = newCatId;
                    }
                    self.states.classManagerActiveCategory = newCatId;
                    self.populateClassCategories();
                    self.setCatList();
                    self.setClassList();
                    self.setClassContent();
                    self.vueGlobalProp.$_showMessage(`Class successfully assigned to the category ${catInput.value}!`);
                    self.helpers.saveChanges('globalClasses');
                }
            })
            catInput.addEventListener('keydown', () =>{
                self.autocomplete(catInput,Array.from(self.vueState.globalClassesCategories).map(el => el && el.name),false)
            })
        }

        // Order event
        const orderInput = contenttWrapper.querySelector('#orderInput');
        if(orderInput){
            orderInput.addEventListener('keyup', function(e){
                if (e.key === 'Enter'){
                    self.changeClassOrder(self.states.classManagerActiveClass,parseInt(orderInput.value - 1) );
                    self.helpers.saveChanges('globalClasses');
                }
            })
        }
    },
    updateClassDescription(classId, value){
        const self = this;
        const cls = Array.from(self.vueState.globalClasses).find(el => el && el.hasOwnProperty('id') && el.id === classId);
        cls.description = value;
    },
    applyCSSAIgenerated: function(generatedCSS){
        const self = this;
        const target = self.helpers.createTarget('_cssCustom');
        const css = JSON.parse(generatedCSS).css;
        self.vueGlobalProp.$_getGlobalClass(self.states.classManagerActiveClass).settings[target] = css_beautify(css, { indent_size: 2, space_in_empty_paren: false });
        setTimeout(self.setClassContent(), 5);
    },
    callAPIforClassManagerCSS: function(event,target){
        const self = this;
        if(event.key !== "Enter") return;
        const input = (event.target.value.length > 0) ? `${event.target.value}` : '';
        if (input === '') return;
        const defaultModel = self.globalSettings.defaultAIModel;
        const wrapper = document.querySelector('#submitCSSPromptWrapper');
        var z = document.createElement('span'); // is a node
        z.setAttribute('class', 'brxc-overlay__action-btn primary disable');
        wrapper.appendChild(z);
        const activeClassName = self.vueGlobalProp.$_getGlobalClass(self.states.classManagerActiveClass).name
        const cm = document.querySelector('textarea[data-type="class-manager-custom-css"] + .CodeMirror').CodeMirror;
        const existingCSS = self.vueGlobalProp.$_replaceCustomCssRoot('%root%', `.${activeClassName }`,cm.getValue());

        let message = `Add CSS code targeting the class .${activeClassName}. The CSS code should do this:${input}.`
        if(existingCSS !== '') message += `The existing CSS code is the following: ${existingCSS}. Please merge your code with the existing one in a unique declaration (if possible).`;
    
        //target.classList.add('disable');
        const json = {
            "model": defaultModel,
            "messages": [
              {
                "role": "user",
                "content": `${message}`
              }
            ],
            "functions":[{
                "name":"applyCSSAIgenerated",
                "description":"Generate CSS code based on the instructions provided.",
                "parameters":{
                   "type":"object",
                   "properties":{
                        "css":{
                            "type":"string",
                            "description":"The CSS code"
                        }
                   }
                }
             }],
            "function_call": "auto" 
          }

        jQuery.ajax({
            type: 'POST',
            url: openai_ajax_req.ajax_url,
            data: {
                action: 'openai_ajax_function',
                nonce: openai_ajax_req.nonce,
            },
            success: function(response) {
                const post = async () => {
                    const rawResponse = await fetch('https://api.openai.com/v1/chat/completions', {
                      method: 'POST',
                      headers: {
                          'Content-Type': 'application/json',
                          'Authorization' : 'Bearer '+ response,
                        },
                      body: JSON.stringify(json)
                    });
                    const content = await rawResponse.json();
                    console.log(content);
                    const disable = document.querySelector('#submitCSSPromptWrapper .brxc-overlay__action-btn.primary.disable');
                    disable.remove();
                    if(content.error){
                        self.insertErrorMessage('classManager', false, '#brxcClassManagerOverlay', content.error.message);
                    } else {
                        self.applyCSSAIgenerated(content.choices[0].message.function_call.arguments);
                    }
                };
                post();
            },
            error: function(response){
                console.log('Something went wrong with the OpenAI AJAX request: ' + response);
                target.classList.remove('disable');
            }
        });


    },
    activateCSSAI: function(){
        const self = this;
        self.states.classManagerisAIopen ? self.states.classManagerisAIopen = false : self.states.classManagerisAIopen = true;
        self.setClassContent();
    },
    saveClassManager: function(btn){
        const self = this;
        self.vueGlobalProp.$_savePost();
        btn.classList.add('disable');
        setTimeout(() => {
            btn.classList.remove('disable');
        }, 2000)
    },
    duplicateClass: function(classId){
        const self = this;
        const originalObj = self.vueGlobalProp.$_getGlobalClass(classId);
        const obj = JSON.parse(JSON.stringify(originalObj));
        const objOrder = self.vueState.globalClasses.indexOf(originalObj);


        function move(arr, from, to, on = 1) {
            return arr.splice(to, 0, ...arr.splice(from, on)), arr
        }
        function checkName(classname){
            if(Array.from(self.vueState.globalClasses).find(el => el && el.hasOwnProperty('name') && el.name === `${classname}-new`)){
                return checkName(`${classname}-new`);
            } else {
                return `${classname}-new`;
            }
        }

        self.vueState.globalClasses.push(obj);
        const newId = self.vueGlobalProp.$_generateId();
        const oldName = obj.name;
        const newClass = self.vueState.globalClasses[self.vueState.globalClasses.length - 1];
        newClass.id = newId;
        newClass.name = checkName(newClass.name);
        newClass.settings = JSON.parse(JSON.stringify(newClass.settings).replaceAll(oldName, newClass.name));
        newClass.new = true;
        move(self.vueState.globalClasses, self.vueState.globalClasses.length - 1, parseInt(objOrder + 1), 1);
        setTimeout(() => {
            self.helpers.saveChanges('globalClasses');
            self.states.classManagerActiveClass = newId;
            self.setClassList();
            self.setClassContent();
            self.setCatList();
        }, 10);
        

    },
    addNewClass: function(event){
        const self = this;

        if(event.key !== "Enter") return;
        const values = event.target.value.split(' ');
        if(values.length < 1) return;

        values.forEach(el => {
            if(!self.helpers.isValidCSSClassName(el)) return self.vueGlobalProp.$_showMessage('Invalid Character in the class name');
            const exist = Array.from(self.vueState.globalClasses).find(el2 => el2 && el2.hasOwnProperty('name') && el2.name === el);
            if(typeof exist === "object") {
                self.states.classManagerActiveClass = exist.id;
                if(self.states.classManagerActiveCategory && self.states.classManagerActiveCategory !== "All" && self.states.classManagerActiveCategory !== "Uncategorized") exist.category = self.states.classManagerActiveCategory;
                
                self.vueGlobalProp.$_showMessage('Class already exists');
            } else {
                const id = self.vueGlobalProp.$_generateId();
                const obj = {
                    id: id,
                    name: el,
                    settings: {},
                    new: true,
                };
                if(self.states.classManagerActiveCategory && self.states.classManagerActiveCategory !== "All" && self.states.classManagerActiveCategory !== "Uncategorized") obj.category = self.states.classManagerActiveCategory;
                
                self.vueState.globalClasses.push(obj);
                self.states.classManagerActiveClass = id;
                self.vueGlobalProp.$_showMessage('Class successfully created');
            }
        })
        setTimeout(() => {
            self.setClassContent();
            self.setClassList();
            self.setCatList();
        },10)  
    },
    deleteClass: function(classId){
        const self = this;
        self.states.classManagerActiveClass = '';
        const contentType = self.helpers.getTemplateType();
        const filtered = Array.from(self.vueState[contentType]).filter(el => el && el.settings.hasOwnProperty('_cssGlobalClasses') && el.settings._cssGlobalClasses.includes(classId));
        if(filtered.length > 0){
            filtered.forEach(el => {
                const index = el.settings._cssGlobalClasses.indexOf(classId);
                el.settings._cssGlobalClasses.splice(index, 1);
            })
        }
        self.vueState.globalClasses.splice(parseInt(self.vueState.globalClasses.indexOf(self.vueGlobalProp.$_getGlobalClass(classId))),1);
        if(self.states.classManagerActiveClass === classId) self.states.classManagerActiveClass = '';
        setTimeout(()=> {
            self.setClassList();
            self.setClassContent(true);
            self.setCatList();
        },10)

    },
    selectClass: function(classId, target){
        const self = this;
        self.states.classManagerActiveClass = classId;
        const lists = document.querySelectorAll('#brxcClassListCanvas li');
        lists.forEach(list => {
            list.classList.remove('selected');
        })
        const selected = document.querySelector(`#brxcClassListCanvas li[data-id=${classId}]`);
        if(selected) selected.classList.add('selected');
        self.setClassContent()
    },
    changeClassOrder: function(classId, newOrder){
        const self = this;
        function move(arr, from, to, on = 1) {
            return arr.splice(to, 0, ...arr.splice(from, on)), arr
        }
        const oldOrder = self.vueState.globalClasses.indexOf(self.vueGlobalProp.$_getGlobalClass(classId));
        if(oldOrder === newOrder){
            return;
        } else{
            move(self.vueState.globalClasses, oldOrder, newOrder, 1);
            self.vueGlobalProp.$_showMessage('Class order successfullt changed');
        }
        self.helpers.saveChanges('globalClasses');
        self.setClassList();

    },
    changeLockStatus: function(classId, status){
        const self = this;
        if (status === "lock" && !self.vueState.globalClassesLocked.includes(classId)){
            self.vueState.globalClassesLocked.push(classId);
            self.vueGlobalProp.$_showMessage('Class successfully locked');
        } else if(status === "unlock" && self.vueState.globalClassesLocked.includes(classId)){
            const index = self.vueState.globalClassesLocked.indexOf(classId);
            self.vueState.globalClassesLocked.splice(index,1);
            self.vueGlobalProp.$_showMessage('Class successfully unlocked');
        }
        self.helpers.saveChanges('globalClassesLocked');
        self.setClassContent();
        self.setClassList();

    },
    openElement: function(id){
        const self = this;
        const obj = self.vueGlobalProp.$_getElementObject(id);
        self.vueState.activePanel = "element";
        self.vueState.activeElement = obj;
        self.vueState.activeId = obj.id;
        // const x = document.querySelector('#bricks-builder-iframe').contentWindow;
        // const el = x.document.querySelector(`[data-id="${id}"]`)
        const el = FRAMEBRXC.vueGlobalProp.$_getElementNode(self.vueState.activeElement);
        setTimeout(()=>{
            el.scrollIntoView({ behavior: "smooth"});
        },10)
        
    },
    filterClassesByStyle: function(btn){
        const self = this;
        if (self.states.classManagerFilterStyle === false){
            self.states.classManagerFilterStyle = "has-no-styles";
            btn.classList.add("locked");
        } else if (self.states.classManagerFilterStyle === "has-no-styles"){
            self.states.classManagerFilterStyle = "has-styles";
            btn.classList.remove("locked")
            btn.classList.add("unlocked");
        } else {
            self.states.classManagerFilterStyle = false;
            btn.classList.remove("unlocked")
        }
        self.setClassList();
    },
    filterClassesByActive: function(btn){
        const self = this;
        if (self.states.classManagerFilterActive === false){
            self.states.classManagerFilterActive = "is-not-active";
            btn.classList.add("locked");
        } else if (self.states.classManagerFilterActive === "is-not-active"){
            self.states.classManagerFilterActive = "is-active";
            btn.classList.remove("locked")
            btn.classList.add("unlocked");
        } else {
            self.states.classManagerFilterActive = false;
            btn.classList.remove("unlocked")
        }
        self.setClassList();
    },
    filterClassesByStatus: function(btn){
        const self = this;
        if (self.states.classManagerFilterLocked === false){
            self.states.classManagerFilterLocked = "locked";
            btn.classList.add("locked");
        } else if (self.states.classManagerFilterLocked === "locked"){
            self.states.classManagerFilterLocked = "unlocked";
            btn.classList.remove("locked")
            btn.classList.add("unlocked");
        } else {
            self.states.classManagerFilterLocked = false;
            btn.classList.remove("unlocked")
        }
        self.setClassList();
    },
    resetFilter: function(btn){
        const self = this;
        btn.previousElementSibling.previousElementSibling.value = '';
        self.states.classManagerSearch = '';
        self.states.classManagerFilterLocked = false;
        self.states.classManagerFilterActive = false;
        self.states.classManagerFilterStyle = false;
        self.setClassList();
        const container = btn.parentElement;
        const buttons = container.querySelectorAll('.iso-reset');
        buttons.forEach(el => {
            el.classList.remove('locked');
            el.classList.remove('unlocked');
        })
    },
    setColumnNumber: function(num){
        let wrapper = document.querySelector('#bricks-panel-elements #bricks-panel-elements-categories');
        if(!wrapper) return;
        wrapper.setAttribute('data-col', num);
    },
    collapseElementsState : 'collapse',
    collapseElements: function(){
        const self = this;
        const panel = document.querySelector('#bricks-panel-elements');
        if(!panel) return;

        const cats = panel.querySelectorAll('#bricks-panel-elements-categories li.category');
        if(!cats || cats.lentgh < 1) return;
        
        if(self.collapseElementsState === "collapse"){
            cats.forEach(cat => {
                const title = cat.querySelector('.category-title ');
                if(!title) return;
                if(title.classList.contains('expand')){
                    const svg = cat.querySelector('.wrap + span.bricks-svg-wrapper')
                    if(!svg) return;
                    svg.click();
                }
            })
            self.collapseElementsState = "expand";
        } else {
            cats.forEach(cat => {
                const title = cat.querySelector('.category-title ');
                if(!title) return;
                if(!title.classList.contains('expand')){
                    const svg = cat.querySelector('.wrap + span.bricks-svg-wrapper')
                    if(!svg) return;
                    svg.click();
                }
            })
            self.collapseElementsState = "collapse";
        }
    },
    setElementsColumns: function(){
        const self = this;
        if (self.vueState.activePanel !== 'elements') return;
        const header = document.querySelector('#bricks-panel-inner #bricks-panel-elements #bricks-panel-header')
        const oldMenu = document.querySelector('#bricks-panel-view');
        if(oldMenu) {
            oldMenu.remove();
        };
        const wrapper = document.createElement("UL");
        wrapper.setAttribute("id", "bricks-panel-view");
        header.after(wrapper);
        self.addIconToFields('li','brxc-header-icon brxc-header-icon__hover', false, '1-col', 'bottom-right', 'ADMINBRXC.setColumnNumber(1)', true, '<span class="bricks-svg-wrapper"><i class="ti-layout-column3-alt"></i></span>', wrapper, 'child');
        self.addIconToFields('li','brxc-header-icon brxc-header-icon__hover', false, '2-col', 'bottom-right', 'ADMINBRXC.setColumnNumber(2)', true, '<span class="bricks-svg-wrapper"><i class="ti-layout-column2-alt"></i></span>', wrapper, 'child');
        self.addIconToFields('li','brxc-header-icon brxc-header-icon__hover', false, '3-col', 'bottom-right', 'ADMINBRXC.setColumnNumber(3)', true, '<span class="bricks-svg-wrapper"><i class="ti-layout-column3-alt"></i></span>', wrapper, 'child');
        self.addIconToFields('li','brxc-header-icon brxc-header-icon__hover', false, '4-col', 'bottom-right', 'ADMINBRXC.setColumnNumber(4)', true, '<span class="bricks-svg-wrapper"><i class="ti-layout-column4-alt"></i></span>', wrapper, 'child');
        
        const expandSVG = '<span class="bricks-svg-wrapper"><svg version="1.1" viewBox="0 0 16 16" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" class="bricks-svg"><g fill="currentColor" fill-rule="evenodd"><path d="M2,8l5.32907e-15,7.54979e-08c-4.16963e-08,-0.276142 0.223858,-0.5 0.5,-0.5h11l-2.18557e-08,8.88178e-16c0.276142,-1.20706e-08 0.5,0.223858 0.5,0.5c1.20706e-08,0.276142 -0.223858,0.5 -0.5,0.5h-11l-2.78181e-08,-3.55271e-15c-0.276142,-4.49893e-08 -0.5,-0.223858 -0.5,-0.5Zm6,-1.5l-2.18557e-08,-8.88178e-16c0.276142,1.20706e-08 0.5,-0.223858 0.5,-0.5v-4.5v0c0,-0.276142 -0.223858,-0.5 -0.5,-0.5c-0.276142,0 -0.5,0.223858 -0.5,0.5v4.5l5.32907e-15,7.54979e-08c4.16963e-08,0.276142 0.223858,0.5 0.5,0.5Z"></path><path d="M10.354,3.854l2.23014e-08,-2.2245e-08c0.195509,-0.195015 0.195909,-0.511597 0.000893739,-0.707106c-0.000297551,-0.000298304 -0.000595479,-0.000596232 -0.000893784,-0.000893784l-2,-2l4.41373e-09,4.4249e-09c-0.195015,-0.195509 -0.511597,-0.195909 -0.707106,-0.000893793c-0.000298304,0.000297551 -0.000596232,0.000595479 -0.000893784,0.000893784l-2,2l-2.1107e-09,2.1107e-09c-0.195509,0.195509 -0.195509,0.512491 4.22141e-09,0.708c0.195509,0.195509 0.512491,0.195509 0.708,-4.22141e-09l1.646,-1.647l1.646,1.647l-3.52833e-08,-3.53726e-08c0.195015,0.195509 0.511597,0.195909 0.707106,0.000893854c0.000298304,-0.000297551 0.000596233,-0.000595479 0.000893784,-0.000893784Zm-2.354,5.646h-2.18557e-08c0.276142,-1.20706e-08 0.5,0.223858 0.5,0.5v4.5v0c0,0.276142 -0.223858,0.5 -0.5,0.5c-0.276142,0 -0.5,-0.223858 -0.5,-0.5v-4.5l5.32907e-15,7.54979e-08c-4.16963e-08,-0.276142 0.223858,-0.5 0.5,-0.5Z"></path><path d="M10.354,12.146l2.23014e-08,2.2245e-08c0.195509,0.195015 0.195909,0.511597 0.000893739,0.707106c-0.000297551,0.000298304 -0.000595479,0.000596232 -0.000893784,0.000893784l-2,2l4.41373e-09,-4.4249e-09c-0.195015,0.195509 -0.511597,0.195909 -0.707106,0.000893793c-0.000298304,-0.000297551 -0.000596232,-0.000595479 -0.000893784,-0.000893784l-2,-2l-2.1107e-09,-2.1107e-09c-0.195509,-0.195509 -0.195509,-0.512491 4.22141e-09,-0.708c0.195509,-0.195509 0.512491,-0.195509 0.708,4.22141e-09l1.646,1.647l1.646,-1.647l-3.52833e-08,3.53726e-08c0.195015,-0.195509 0.511597,-0.195909 0.707106,-0.000893854c0.000298304,0.000297551 0.000596233,0.000595479 0.000893784,0.000893784Z"></path></g></svg></span>';
        const collapseSVG = '<span class="bricks-svg-wrapper"><svg version="1.1" viewBox="0 0 16 16" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" class="bricks-svg"><g fill="currentColor" fill-rule="evenodd"><path d="M2,8l5.32907e-15,7.54979e-08c-4.16963e-08,-0.276142 0.223858,-0.5 0.5,-0.5h11l-2.18557e-08,8.88178e-16c0.276142,-1.20706e-08 0.5,0.223858 0.5,0.5c1.20706e-08,0.276142 -0.223858,0.5 -0.5,0.5h-11l-2.78181e-08,-3.55271e-15c-0.276142,-4.49893e-08 -0.5,-0.223858 -0.5,-0.5Zm6,-7h-2.18557e-08c0.276142,-1.20706e-08 0.5,0.223858 0.5,0.5v4.5v0c0,0.276142 -0.223858,0.5 -0.5,0.5c-0.276142,0 -0.5,-0.223858 -0.5,-0.5v-4.5l5.32907e-15,7.54979e-08c-4.16963e-08,-0.276142 0.223858,-0.5 0.5,-0.5Z"></path><path d="M10.354,3.646l2.23014e-08,2.2245e-08c0.195509,0.195015 0.195909,0.511597 0.000893739,0.707106c-0.000297551,0.000298304 -0.000595479,0.000596232 -0.000893784,0.000893784l-2,2l4.41373e-09,-4.4249e-09c-0.195015,0.195509 -0.511597,0.195909 -0.707106,0.000893793c-0.000298304,-0.000297551 -0.000596232,-0.000595479 -0.000893784,-0.000893784l-2,-2l-2.1107e-09,-2.1107e-09c-0.195509,-0.195509 -0.195509,-0.512491 4.22141e-09,-0.708c0.195509,-0.195509 0.512491,-0.195509 0.708,4.22141e-09l1.646,1.647l1.646,-1.647l-3.52833e-08,3.53726e-08c0.195015,-0.195509 0.511597,-0.195909 0.707106,-0.000893854c0.000298304,0.000297551 0.000596233,0.000595479 0.000893784,0.000893784Zm-2.354,11.354h-2.18557e-08c0.276142,1.20706e-08 0.5,-0.223858 0.5,-0.5v-4.5v0c0,-0.276142 -0.223858,-0.5 -0.5,-0.5c-0.276142,0 -0.5,0.223858 -0.5,0.5v4.5l5.32907e-15,7.54979e-08c4.16963e-08,0.276142 0.223858,0.5 0.5,0.5Z"></path><path d="M10.354,12.354l2.23014e-08,-2.2245e-08c0.195509,-0.195015 0.195909,-0.511597 0.000893739,-0.707106c-0.000297551,-0.000298304 -0.000595479,-0.000596232 -0.000893784,-0.000893784l-2,-2l4.41373e-09,4.4249e-09c-0.195015,-0.195509 -0.511597,-0.195909 -0.707106,-0.000893793c-0.000298304,0.000297551 -0.000596232,0.000595479 -0.000893784,0.000893784l-2,2l-2.1107e-09,2.1107e-09c-0.195509,0.195509 -0.195509,0.512491 4.22141e-09,0.708c0.195509,0.195509 0.512491,0.195509 0.708,-4.22141e-09l1.646,-1.647l1.646,1.647l-3.52833e-08,-3.53726e-08c0.195015,0.195509 0.511597,0.195909 0.707106,0.000893854c0.000298304,-0.000297551 0.000596233,-0.000595479 0.000893784,-0.000893784Z"></path></g></svg></span>';
        const finalSVG = self.collapseElementsState === "collapse" ? collapseSVG : expandSVG;
        const balloon = self.collapseElementsState === "collapse" ? "Collapse All" : "Expand All";
        self.addIconToFields('li','brxc-header-icon brxc-header-icon__hover', false, balloon, 'bottom-right', 'ADMINBRXC.collapseElements()', true, finalSVG, wrapper, 'child');
    },
    highlightClasses: function(){
        const self = this;
        const x = document.querySelector('#bricks-builder-iframe').contentWindow;
        const structureItems = document.querySelectorAll('#bricks-structure .bricks-structure-list .bricks-draggable-item');
        if (!self.helpers.isClassActive()) {
            const activeEls = x.document.querySelectorAll('.brxc-active-class');
            if(activeEls.length < 1) return;
            activeEls.forEach(el => el.classList.remove('brxc-active-class'))
            // Structure Panel
            if(structureItems.length < 1) return;
            structureItems.forEach(el => {
                const structureItem = el.querySelector(':scope > .structure-item')
                structureItem.classList.remove('brxc-active-class')
            })
        } else {
            const els = x.document.querySelectorAll('.brxc-active-class');
            const activeEls = x.document.querySelectorAll('.' + self.vueState.activeClass.name);
            if(els.length > 0) els.forEach(el => el.classList.remove('brxc-active-class'))
            if(activeEls.length < 1) return;
            activeEls.forEach(el => el.classList.add('brxc-active-class'));
            // Structure Panel
            if(structureItems.length < 1) return;
            const activeClassID = self.vueState.activeClass.name;
            structureItems.forEach(el => {
                const structureItem = el.querySelector(':scope > .structure-item')
                structureItem.classList.remove('brxc-active-class')
                elID = el.dataset.id;
                if(self.vueGlobalProp.$_getElementGlobalClassNames(self.vueGlobalProp.$_getElementObject(elID).settings).includes(activeClassID)){
                    structureItem.classList.add('brxc-active-class');
                }
            })
        }
    },
    panelSwitch: function(el){
        const self = this;
        if (el.dataset.panelGroup) self.vueState.activePanelGroup = el.dataset.panelGroup;
        if (el.dataset.panel) self.vueState.activePanelTab = el.dataset.panel;
    },
    hideInactivePanels: function(){
        const self = this;
        if(!self.helpers.isElementActive()) return;
        const controlGroups = document.querySelector('.bricks-panel-controls ul.control-groups');
        if(!controlGroups) return;
        function setVisibility(){
            controlGroups.classList.remove('hidden-accordion-panels')
            const activeGroup = Array.from(controlGroups.querySelectorAll('.control-group')).filter(el => el && el.classList.contains('open'));
            if (activeGroup.length > 0 && self.vueState.activePanelGroup !== "" && self.vueState.activePanelTab === "style") controlGroups.classList.add('hidden-accordion-panels');
        }
        setVisibility();
        setTimeout(() => {
            const activeGroup = Array.from(controlGroups.querySelectorAll('.control-group')).filter(el => el && el.classList.contains('open'));
            if(activeGroup.length === 0){
                controlGroups.classList.remove('hidden-accordion-panels')
            }
        }, 0);
    },
    panelShortcuts: function(){
        const self = this;

        const panelElement = document.querySelector('#bricks-panel-element');
    
        if( !panelElement || !self.helpers.isElementActive()) return;
   
        panelElement.setAttribute("data-active", "true");

        let wrapper = panelElement.querySelector('.brxce-panel-shortcut__wrapper');
        if (wrapper) wrapper.remove();

        const panelHeader = panelElement.querySelector('#bricks-panel-header')
        if (!panelHeader) return;

        let activeTabs = [];

        function calculateActiveTabs(){

            if(typeof self.vueState.activeElement === 'undefined') return;
            const name = self.vueState.activeElement.name;
            const settings = self.helpers.isClassActive() ? self.vueState.activeClass.settings : self.vueState.activeElement.settings;
            const activeBp = self.vueState.breakpointActive;
            const activePseudo = self.vueState.pseudoClassActive;

            let suffix = "";
            if(activeBp !== "desktop") suffix += `:${activeBp}`;
            if(activePseudo !== "") suffix += activePseudo;

            for(const key of Object.keys(settings)){
                const setting = key.split(':')[0];
                if(key === "_cssClasses" || key === "_cssId" || key === "_attributes" || key === `${setting}${suffix}`){
                    if(bricksData.elements[name].controls[setting] && bricksData.elements[name].controls[setting].hasOwnProperty('group')) activeTabs.push(bricksData.elements[name].controls[setting].group);
                } 
            }
            return activeTabs = [...new Set(activeTabs)];
        }

        calculateActiveTabs();

        var keyboard = 0;
        wrapper = `<div class="brxce-panel-shortcut__wrapper"><div class="brxce-panel-shortcut__container">`;
        if (Object.values(self.globalSettings.shortcutsTabs).includes('content')) {
            wrapper += `<li ${self.vueState.activePanelTab === "content" ? 'class="active"' : ''}data-panel="content" data-balloon="Content" data-order="${keyboard}" data-balloon-pos="right" onClick="ADMINBRXC.panelSwitch(this)"><span class="bricks-svg-wrapper"><i class="fas fa-pen"></i></span><span class="keyboard-shortcut">${keyboard}</span></li>`;
        }
        if(Object.values(self.globalSettings.classFeatures).includes("disable-id-styles") && self.vueState.brxc.showLock === true) {
            wrapper += `</div></div>`;
            panelHeader.insertAdjacentHTML('afterend', wrapper);
            const activePanel = panelElement.querySelector('[data-panel="content"]')
            activePanel?.classList.add('active')
            return;
        }

        if(!bricksData.elements[self.vueState.activeElement.name]) return; 
        const controlGroups = bricksData.elements[self.vueState.activeElement.name].controlGroups;
        
        function createIcon(activeTab, balloon, icon ){
            keyboard++;
            return `<li class="${activeTabs.includes(activeTab) ? 'has-settings' : ''}${self.vueState.activePanelTab === "style" && self.vueState.activePanelGroup === activeTab ? ' active' : ''}" data-panel="style" data-panel-group="${activeTab}"${keyboard < 10 ? ` data-order="${keyboard}"` : ''} data-balloon="${balloon}" data-balloon-pos="right" onClick="${self.vueState.activePanelGroup === activeTab ? `ADMINBRXC.vueState.activePanelGroup = ''` : 'ADMINBRXC.panelSwitch(this)'}" onmouseenter="ADMINBRXC.vueState.brxc.clickedOnLeftPanelShortcuts = true" onmouseleave="ADMINBRXC.vueState.brxc.clickedOnLeftPanelShortcuts = false"><span class="bricks-svg-wrapper"><i class="${icon}"></i></span>${keyboard < 10 ? `<span class="keyboard-shortcut">${keyboard}</span>` : '' }</li>`;
        }

        function createIconConfig(tabKey, balloon, icon) {
            return {
                tabKey,
                balloon,
                icon
            };
        }

        const shortcutConfigs = [
            createIconConfig('_layout', 'Layout', 'fas fa-layer-group'),
            createIconConfig('_typography', 'Typography', 'fas fa-font'),
            createIconConfig('_background', 'Background', 'fas fa-image'),
            createIconConfig('_border', 'Border', 'fas fa-border-all'),
            createIconConfig('_gradient', 'Gradient / Overlay', 'fas fa-brush'),
            createIconConfig('_shapes', 'Shape Dividers', 'fas fa-shapes'),
            createIconConfig('_transform', 'Transform', 'fas fa-wand-magic-sparkles'),
            createIconConfig('_filter', 'Filters / Transitions', 'fas fa-filter'),
            createIconConfig('_css', 'CSS', 'fab fa-css3-alt'),
            createIconConfig('_classes', 'Classes / ID', 'fas fa-id-card'),
            createIconConfig('_attributes', 'Attributes', 'fas fa-database'),
        ];

        shortcutConfigs.forEach(config => {
            const { tabKey, balloon, icon } = config;

            if (Object.values(self.globalSettings.shortcutsTabs).includes(tabKey.replaceAll('_','')) && typeof controlGroups !== "undefined" && controlGroups.hasOwnProperty(tabKey)) {
                wrapper += createIcon(tabKey, balloon, icon);
            }
        });

        wrapper += `</div></div>`;
        panelHeader.insertAdjacentHTML('afterend', wrapper);  
    },

    structureElementHasStyle: function(){
        const self = this;

        const structure = document.querySelector('#bricks-structure');
        const els = structure.querySelectorAll('#bricks-structure .panel-content .bricks-draggable-item.element')
        if (els.length < 1) return;

        const hasStyle = (obj) => {
            for (const key in obj) {
                if (self.helpers.isCSSControlKey(key)) {
                  return true;
                }
            }
            return false;
        }
        const hasClass = (obj) => {
            let returnValue = false;

            if(obj.hasOwnProperty('_cssClasses') && obj._cssClasses.length > 0){
                returnValue = true;
            } else if(obj.hasOwnProperty('_cssGlobalClasses') && Array.isArray(obj._cssGlobalClasses) && obj._cssGlobalClasses.length > 0){
                obj._cssGlobalClasses.forEach(cls => {
                    settings = self.vueGlobalProp.$_getGlobalClass(cls);
                    if(settings) returnValue = true;
                })
            }
            return returnValue;
            

        }
        els.forEach(el => {
            el.removeAttribute('data-has-styles');
            el.removeAttribute('data-has-classes');
            if(hasStyle(self.vueGlobalProp.$_getElementObject(el.dataset.id).settings)){
                el.setAttribute('data-has-styles', 'true');
            }
            if(hasClass(self.vueGlobalProp.$_getElementObject(el.dataset.id).settings)){
                el.setAttribute('data-has-classes', 'true');
            }
        })
    },
    mediaQueriesHasStyle: function(){

        const self = this;

        // Const
        const breakpointWrapper = document.querySelector('#bricks-toolbar ul.group-wrapper.breakpoints');
        const breakpoints = breakpointWrapper.querySelectorAll('li[data-key]');
        if (breakpoints.length < 1) return;
        
        if(!self.helpers.isElementActive()) {
            breakpoints.forEach(bp => {
                bp.removeAttribute('data-styles');
            })
            return;
        }

        if(self.vueState.brxc.breakpointActive) {
            self.vueState.breakpointActive = self.vueState.brxc.breakpointActive;
        }


        const activePseudo = self.vueState.pseudoClassActive;
        const activeClass = self.vueState.activeClass;
        const activeElement = self.vueState.activeElement;
        const activeBp = self.vueState.breakpointActive;
        
        function mountIndicators(){
            breakpoints.forEach(bp => { bp.removeAttribute('data-styles') });
            if(typeof self.vueState.activeElement === 'undefined') return;
            const settings = (self.helpers.isClassActive()) ? self.vueState.activeClass.settings : self.vueState.activeElement.settings;
            const activePseudo = self.vueState.pseudoClassActive;
    
            // Render

            breakpoints.forEach(bp => {
                let hasStyles = false;
                let suffix = "";
                if(bp.dataset.key !== "desktop") suffix += `:${bp.dataset.key}`;
                if(activePseudo !== "") suffix += activePseudo;

                for(const key of Object.keys(settings)){
                    const setting = key.split(':')[0];
                    if(self.helpers.isCSSControlKey(setting) && key === `${setting}${suffix}`){
                        hasStyles = true;
                    } 
                }

                if(hasStyles){
                    bp.setAttribute('data-styles', "true")
                }
            })
        }

        mountIndicators();

        // Recalculate indicators on changes
        setTimeout(() => {
            if(activePseudo !== self.vueState.pseudoClassActive ||
               activeClass !== self.vueState.activeClass ||
               activeElement !== self.vueState.activeElement ||
               activeBp !== self.vueState.breakpointActive) {
                   mountIndicators();
            }
        }, 300);
    },
    setColorsforStructureIndicators: function (){
        const self = this;
        const color = self.globalSettings.structurePanelTagIndicatorColors;
        if(color){
            const structurePanel = document.querySelector('#bricks-structure');
            structurePanel.setAttribute('data-indicators-color', color);
        }

    },
  
    groupClassIndicator() {
        const self = this;
        if (!self.helpers.isElementActive()) return;

        const panel = document.querySelector("#bricks-panel-element");
        const elements = panel.querySelectorAll("[data-control-group]");
        if (!elements || elements.length < 1) return;
        
        // Remove Existing classes from the title
        elements.forEach(el => {
            const controlGroupTitle = el.querySelector('.control-group-title');
            controlGroupTitle.classList.remove('has-class-styles');
            controlGroupTitle.classList.remove('has-id-styles');
          });

        let settingKeys;
        
        // ID
        if(!self.helpers.isClassActive()){
            const classIds = self.vueState.activeElement.settings?.['_cssGlobalClasses'] || false;
            if (!classIds) return;
        
            settingKeys = classIds.flatMap(cls => {
                const obj = self.vueGlobalProp.$_getGlobalClass(cls);
                if(!obj) return;
                const clsSettings = obj.settings;
                const keys = Object.keys(clsSettings);
                return keys.filter(
                    key => self.helpers.keyMatchBreakpoint(key, self.vueState.breakpointActive) 
                    && self.helpers.keyMatchPseudo(key, self.vueState.pseudoClassActive));
            });

        // Class
        } else {
            settingKeys = Object.keys(self.vueState.activeElement.settings).filter(
                    key => self.helpers.keyMatchBreakpoint(key, self.vueState.breakpointActive) 
                    && self.helpers.keyMatchPseudo(key, self.vueState.pseudoClassActive));
        }
    
        settingKeys = [...new Set(settingKeys.map(key => key && key.split(':')[0]))];
        let categories = settingKeys.flatMap(key => bricksData.elements[self.vueState.activeElement.name].controls[key]?.group || []);
    
        categories = [...new Set(categories)];
        if (!categories || categories.length < 1) return;
        
        // Add class to title
        const customClass = !self.helpers.isClassActive() ? 'has-class-styles' : 'has-id-styles';
        categories.forEach(cat => {
            const panelTitle = panel.querySelector(`[data-control-group="${cat}"] .control-group-title`);
            panelTitle.classList.add(customClass);
        })
    },
    classIndicator() {
        const self = this;
        if(!self.helpers.isElementActive()) return;
    
        const panel = document.querySelector("#bricks-panel-element");
        const els = panel?.querySelectorAll("[data-controlkey^='_']");
    
        if (!els || !els.length) return;
    
        // Remove existing attributes
        els.forEach((el) => {
            el.removeAttribute("data-has-class-style");
            el.removeAttribute("data-has-id-style");
        });

        const activeElementSettings = self.vueState.activeElement.settings;
        if(!activeElementSettings.hasOwnProperty('_cssGlobalClasses') || activeElementSettings._cssGlobalClasses.length < 1) return;

        function buildKey(el) {
            let key = el.dataset.controlkey;
            if (self.vueState.breakpointActive !== "desktop") {
                key += `:${self.vueState.breakpointActive}`;
            }
            if (self.vueState.pseudoClassActive !== "") {
                key += self.vueState.pseudoClassActive;
            }
            return key;
        }
    
        const isClassActive = self.helpers.isClassActive();
        let finalKeys = isClassActive
            ? Object.keys(activeElementSettings).filter(el => el && el.startsWith("_") && activeElementSettings[el] !== "")
            : self.helpers.getClassKeysFromGlobalSettings(activeElementSettings._cssGlobalClasses);
    
        const attr = isClassActive ? 'hasIdStyle' : 'hasClassStyle';
        els.forEach((el) => {
            if (finalKeys.includes(buildKey(el))) {
                el.dataset[attr] = "true";
            }
        });
        
        if(isClassActive){
            const globalClasses = activeElementSettings._cssGlobalClasses.slice();
            globalClasses.splice(globalClasses.indexOf(self.vueState.activeClass.id),1);
            if(globalClasses.length < 1) return;

            finalKeys = self.helpers.getClassKeysFromGlobalSettings(globalClasses);
    
            els.forEach((el) => {
                const key = buildKey(el);
                if (finalKeys.includes(key)) {
                    el.dataset['hasClassStyle'] = "true";
                }
            });
        }
    },

    breakpointIndicator: function(){
        const self = this;
        if(!self.helpers.isElementActive()) return;

        if(self.vueState.brxc.breakpointActive) {
            self.vueState.breakpointActive = self.vueState.brxc.breakpointActive;
        }

        // Const
        const panel = document.querySelector("#bricks-panel-element");
        const groups = panel.querySelectorAll('.control-group');
        if (groups.length < 1) return;
        const activePseudo = self.vueState.pseudoClassActive;
        const activeClass = self.vueState.activeClass;
        const activeElement = self.vueState.activeElement;
        const activeBp = self.vueState.breakpointActive;

        
        function mountIcons(){
            if(typeof self.vueState.activeElement === 'undefined') return;
            const name = self.vueState.activeElement.name;
            const settings = (self.helpers.isClassActive()) ? self.vueState.activeClass.settings : self.vueState.activeElement.settings;
            const activePseudo = self.vueState.pseudoClassActive;
    
            // Render
            groups.forEach((group,index) => {
                const groupName = group.dataset.controlGroup;
                self.vueState.breakpoints.forEach(bp => {
                    const icon = group.querySelector(`.brxc-group-icon[data-device="${bp.key}"]`);
                    if(icon) icon.remove();

                    let hasStyles = false;
                    let suffix = "";
                    if(bp.key !== "desktop") suffix += `:${bp.key}`;
                    if(activePseudo !== "") suffix += activePseudo;

                    for(const key of Object.keys(settings)){
                        const setting = key.split(':')[0];
                        if(key === `${setting}${suffix}`){
                            if(bricksData.elements[name].controls[setting] && bricksData.elements[name].controls[setting].hasOwnProperty('group') && bricksData.elements[name].controls[setting].group === groupName) {
                                hasStyles = true;
                            }
                        } 
                    }
    
                    if(hasStyles){
                    //if(self.vueState.brxc.groupBreakPointsValues[index].includes(bp.key)){
                        let svg = '<span class="bricks-svg-wrapper"><svg version="1.1" viewBox="0 0 30 30" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" class="bricks-svg"><path d="M27.744,2.5h-25.488c-0.968,0 -1.756,0.788 -1.756,1.755v17.489c0,0.968 0.788,1.755 1.756,1.755h12.244v3h-5.5c-0.276,0 -0.5,0.224 -0.5,0.5c0,0.276 0.224,0.5 0.5,0.5h12c0.276,0 0.5,-0.224 0.5,-0.5c0,-0.276 -0.224,-0.5 -0.5,-0.5h-5.5v-3h12.244c0.968,0 1.756,-0.788 1.756,-1.755v-17.489c0,-0.967 -0.788,-1.755 -1.756,-1.755Zm-1.244,18h-23v-15h23v15Z" fill="currentColor"></path></svg></span>';
                        if( bp.icon === "laptop") {
                            svg = '<span class="bricks-svg-wrapper"><svg version="1.1" viewBox="0 0 512 512" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" class="bricks-svg"><path d="M80.14,400c-17.7503,0 -32.14,-14.3897 -32.14,-32.14v-239.72c0,-17.7503 14.3897,-32.14 32.14,-32.14h351.72c17.7503,0 32.14,14.3897 32.14,32.14v239.72c0,17.7503 -14.3897,32.14 -32.14,32.14Z" stroke-width="32" stroke="currentColor" fill="none" stroke-linejoin="round"></path><path fill="currentColor" stroke="currentColor" stroke-linecap="round" stroke-width="32" d="M16,416h480"></path></svg></span>';
                        }
                        if( bp.icon === "tablet-landscape") {
                            svg = '<span class="bricks-svg-wrapper"><svg version="1.1" viewBox="0 0 512 512" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" class="bricks-svg"><g transform="matrix(1,0,0,1,0,512)"><path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="32" d="M128,496c-26.5094,0 -48,-21.4906 -48,-48v-384c0,-26.5094 21.4906,-48 48,-48h256c26.5094,0 48,21.4906 48,48v384c0,26.5094 -21.4906,48 -48,48Z" transform="matrix(6.12323e-17,-1,1,6.12323e-17,0,0)"></path></g></svg></span>';
                        }
                        if( bp.icon === "tablet-portrait") {
                            svg = '<span class="bricks-svg-wrapper"><svg version="1.1" viewBox="0 0 512 512" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" class="bricks-svg"><path d="M128,496c-26.5094,0 -48,-21.4906 -48,-48v-384c0,-26.5094 21.4906,-48 48,-48h256c26.5094,0 48,21.4906 48,48v384c0,26.5094 -21.4906,48 -48,48Z" stroke-linecap="round" stroke-width="32" stroke="currentColor" fill="none" stroke-linejoin="round"></path></svg></span>';
                        }
                        if( bp.icon === "phone-landscape") {
                            svg = '<span class="bricks-svg-wrapper"><svg version="1.1" viewBox="0 0 512 512" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" class="bricks-svg"><g transform="matrix(1,0,0,1,0,512)"><path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="32" d="M176,496c-26.5094,0 -48,-21.4906 -48,-48v-384c0,-26.5094 21.4906,-48 48,-48h160c26.5094,0 48,21.4906 48,48v384c0,26.5094 -21.4906,48 -48,48Z" transform="matrix(6.12323e-17,-1,1,6.12323e-17,0,0)"></path></g><path d="M16,336v-24l9.23706e-14,1.20797e-06c-6.67141e-07,-4.41828 3.58172,-8 8,-8v0h-6.99382e-07c8.83656,3.86258e-07 16,-7.16344 16,-16v-64v0c0,-8.83656 -7.16344,-16 -16,-16v0h-3.49691e-07c-4.41828,-1.93129e-07 -8,-3.58172 -8,-8c0,0 0,-2.84217e-14 0,-2.84217e-14v-24" stroke-linecap="round" stroke-width="32" stroke="currentColor" fill="none" stroke-linejoin="round"></path></svg></span>';
                        }
                        if( bp.icon === "phone-portrait") {
                            svg = '<span class="bricks-svg-wrapper"><svg version="1.1" viewBox="0 0 512 512" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" class="bricks-svg"><g stroke-linecap="round" stroke-width="32" stroke="currentColor" fill="none" stroke-linejoin="round"><path d="M176,496c-26.5094,0 -48,-21.4906 -48,-48v-384c0,-26.5094 21.4906,-48 48,-48h160c26.5094,0 48,21.4906 48,48v384c0,26.5094 -21.4906,48 -48,48Z"></path><path d="M176,16h24l-3.49691e-07,7.10543e-15c4.41828,-1.93129e-07 8,3.58172 8,8v0l1.7053e-13,2.41593e-06c1.33428e-06,8.83656 7.16345,16 16,16h64l-6.99382e-07,-1.42109e-14c8.83656,3.86258e-07 16,-7.16344 16,-16v0l1.13687e-13,1.20797e-06c-6.67141e-07,-4.41828 3.58172,-8 8,-8h24"></path></g></svg></span>';
                        }
                        let newClass = 'brxc-group-icon';
                        if(self.vueState.breakpointActive === bp.key) newClass = 'brxc-group-icon active';
                        self.addIconToFields('li', newClass, [['data-device', bp.key]] , bp.label, 'top', false, true, svg, group.querySelector('.control-group-title'), 'child');
                    }
                })
     
            })
            
    
            const groupIcons = panel.querySelectorAll('.brxc-group-icon');
            if(groupIcons.length < 1 ) return;
            groupIcons.forEach(el => {
                el.addEventListener('click', (e) => {
                    e.preventDefault();
                    const parentGroup = e.target.closest('li.control-group');
                    if(parentGroup.classList.contains('open')) e.stopPropagation();
                    el.remove();
                })

                el.addEventListener('mouseenter', (e) => {
                    self.vueState.brxc.breakpointActive = el.dataset.device;
                })

                el.addEventListener('mouseleave', (e) => {
                    self.vueState.brxc.breakpointActive = false;
                })
            })
        }
        
        mountIcons();

        // Recalculate indicators on changes
        setTimeout(() => {
            if(activePseudo !== self.vueState.pseudoClassActive ||
               activeClass !== self.vueState.activeClass ||
               activeElement !== self.vueState.activeElement ||
               activeBp !== self.vueState.breakpointActive) {
                   mountIcons();
            }
        }, 150)

    },
    // Deprecated in 1.2.4.1

    // setBreakpontIndicatorStatus: function(value){
    //     const self = this;
    //     if(!self.helpers.isElementActive()) return;

    //     // Const
    //     const panel = document.querySelector("#bricks-panel-element");
    //     if(!panel) return;
    //     const groupIcons = panel.querySelectorAll('.brxc-group-icon');
    //     if (groupIcons.length < 1) return;
    //     groupIcons.forEach(el => {
    //         el.classList.remove('active');
    //         if(value && el.dataset.device && value === el.dataset.device) el.classList.add('active');
    //     })
    // },
    lockedClassIndicator: function(){
        const self = this;
        if(!self.helpers.isElementActive()) return;
        const classes = document.querySelectorAll('#bricks-panel-element #bricks-panel-element-classes .element-classes li');
        if (classes.length < 1) return;
        classes.forEach(el => {
            el.removeAttribute("data-locked");
            const name = el.querySelector('.name')
            const id = name.dataset.classId;
            if (self.vueGlobalProp.$_isLocked(id)) el.setAttribute("data-locked", "true");
        })
    },
    lastElementFocus : '',
    focusOnFirstClass: function(){
        const self = this;
        setTimeout( () => {
            if(!self.helpers.isElementActive() || !self.vueState.activeElement || !self.vueState.activeElement.hasOwnProperty('id') || self.lastElementFocus === self.vueState.activeElement.id) {
                if (self.helpers.isClassActive() === false) return self.vueState.activeClass = undefined;
                 
                return;
            } 
            else if (self.vueState.activePanel === "element"){
                self.lastElementFocus = self.vueState.activeElement.id;
                if(self.vueState.activeElement.hasOwnProperty('settings') && self.vueState.activeElement.settings.hasOwnProperty('_cssGlobalClasses')){
                    const firstUnlocked = Array.from(self.vueState.activeElement.settings._cssGlobalClasses).find(el => el && self.vueGlobalProp.$_isLocked(el) === false)
                    self.vueState.activeClass = undefined;
                    if(firstUnlocked && self.vueGlobalProp.$_getGlobalClass(firstUnlocked)) {
                        self.vueState.activeClass = JSON.parse(JSON.stringify(self.vueGlobalProp.$_getGlobalClass(firstUnlocked)));
                        self.vueState.brxc.showLock = false;
                        self.rerenderControls = Date.now();
                        Object.values(self.globalSettings.classFeatures).includes("highlight-classes") ? self.highlightClasses() : '';
                    }
                }
            }
        },0)
    },
    setTagInStructurePanel: function(id,tag){
        const self = this;
        self.vueState.brxc.tagDropdownActive = false;
        const obj = self.vueGlobalProp.$_getElementObject(id);
        if(typeof obj !== "undefined" && !obj.hasOwnProperty('settings')) obj.settings = {};
        obj.settings.tag = tag;
        self.showTagInStructurePanel()
    },
    
    showTagInStructurePanel: function(){
        const self = this;
        const structurePanel = document.querySelector('#bricks-structure');
        if(!structurePanel) return;
        const els = structurePanel.querySelectorAll('#bricks-structure main .bricks-draggable-item');
        if (els.length < 1) return;
        if(self.vueState.brxc.tagsView === 'none') {
            els.forEach(el => {
                const wrapper = el.querySelector('.brxc-tag-btn-wrapper');
                if (wrapper) wrapper.remove();
            })
            structurePanel.removeAttribute('data-tag-color');
            return;
        }

        function createBtn(sibling, tag, options, obj){
            const wrapper = document.createElement('div');;
            wrapper.setAttribute("class", "brxc-tag-btn-wrapper");
            const btn = document.createElement('button')
            btn.setAttribute('class', 'brxc-tag-btn')
            if (options === false) {
                btn.classList.add('red');
            } else if (typeof options !== "object") {
                btn.classList.add('orange');
            }
            if(self.vueState.brxc.tagsView === 'developer') {
                btn.setAttribute('onClick', 'ADMINBRXC.toggleTagDropdown(event)');
                btn.setAttribute('onmouseenter', `ADMINBRXC.vueState.brxc.tagDropdownActive = true`)
                btn.setAttribute('onmouseleave', `ADMINBRXC.vueState.brxc.tagDropdownActive = false`)
            }
            btn.textContent = tag
            wrapper.appendChild(btn);

            if(self.vueState.brxc.tagsView === 'developer') {
                ul = document.createElement("ul");
                ul.setAttribute('class', 'dropdown')
                if (options !== false && typeof options === "object") {
                    options = Object.entries(options);
                    for(i = 0; i<options.length; i++){
                        const li = document.createElement('li');
                        li.setAttribute('class', 'hover');
                        li.setAttribute('data-id', obj);
                        li.setAttribute('onClick', `ADMINBRXC.setTagInStructurePanel(this.dataset.id, '${options[i][0]}')`)
                        li.textContent = options[i][1];
                        ul.appendChild(li)
                    }
                }
                wrapper.appendChild(ul);
            }
            sibling.after(wrapper);
        }

        els.forEach(el => {
            const oldBtn = el.querySelector('.brxc-tag-btn-wrapper');
            if(oldBtn) oldBtn.remove();
            const obj = self.vueGlobalProp.$_getElementObject(el.dataset.id);
            const tag = self.helpers.getElementTag(obj);
            if(!tag) return;
            
            const title = el.querySelector('.title .icon')
            let options;
            (typeof bricksData.elements[obj.name].controls !== "undefined" && bricksData.elements[obj.name].controls.hasOwnProperty('tag')) ? options = bricksData.elements[obj.name].controls.tag.options : options = false;
            createBtn(title, tag, options, el.dataset.id);
        })

        if(self.vueState.brxc.tagsView === 'developer'){
            structurePanel.setAttribute('data-tag-color', 'true');
            self.vueState.brxc.tagdropDownVisible = true;
        }

        if(self.vueState.activeElement && self.vueState.brxc.tagDropdownActive){
            const currentID = self.vueState.activeElement.id;
            const btnWrapper = Array.from(els).filter(el => el && el.dataset.id === currentID);
            const dropdown = btnWrapper[0].querySelector('ul.dropdown');
            if(dropdown) {
                 dropdown.classList.add('active');
                 const el = dropdown.closest('.element');
                 if(el) el.classList.add("tag-dropdown--active")
            }
            
            self.vueState.brxc.tagDropdownActive = false;
        }
        
    },
    showTagInStructurePanelCustomTags: function(){
        const self = this;
        if(!self.helpers.isElementActive()) return;
        const input = document.querySelector('input#customTag');
        if(!input || input.dataset.listening === "true") return;
        input.setAttribute('data-listening', "true");
        input.addEventListener('keyup', () => {
            self.showTagInStructurePanel();
        })

    },
    toggleTagDropdown: function(event){
        const self = this;
        const dropdown = event.target.nextElementSibling;
        const el = event.target.closest('.element');
        if(dropdown.classList.contains('active')){
            dropdown.classList.remove('active');
            if(el) el.classList.remove("tag-dropdown--active")
        } else {
            dropdown.classList.add('active');
            if(el) el.classList.add("tag-dropdown--active")
        }
    },
    highlightNestableElements: function(){
        const self = this;
        const structurePanel = document.querySelector('#bricks-structure');
        if(!structurePanel) return;
        const els = structurePanel.querySelectorAll('#bricks-structure main .bricks-draggable-item');
        if (els.length < 1) return;
        els.forEach(el => {
            el.removeAttribute('data-nestable');
            if (self.nestableElements.includes(self.vueGlobalProp.$_getElementObject(el.dataset.id).name)) el.setAttribute('data-nestable', 'true');
        })
        

    },
    highlightParentElements: function(){
        const self = this;
        const structurePanel = document.querySelector('#bricks-structure');
        if(!structurePanel || typeof self.vueState.activeElement == "undefined") return;
        const els = structurePanel.querySelectorAll('#bricks-structure main .bricks-draggable-item');
        if (els.length < 1) return;
        const parents = []
        function populateParent(child){
            if (typeof self.vueGlobalProp.$_getElementObject(child) == "undefined" || self.vueGlobalProp.$_getElementObject(child).parent === 0) return;
            parents.push(self.vueGlobalProp.$_getElementObject(child).parent);
            populateParent(self.vueGlobalProp.$_getElementObject(child).parent);
        }
        populateParent(self.vueState.activeElement.id);
        els.forEach(el => {
            el.removeAttribute("data-parent");
            if(parents.includes(el.dataset.id)) el.setAttribute("data-parent", true);
        })
    },
    expandAllChildren: function(event){
        const parent = event.target.closest('[data-id]');
        if(!parent) return;
        const toggles = parent.querySelectorAll('.bricks-svg-wrapper.toggle')
        if(toggles.length < 1) return;
        toggles.forEach(toggle => {
            const parent = toggle.closest('[data-id]');
            if (!parent) return;
            const target = parent.querySelector('.bricks-structure-list')
            if (!target) return;
            const status = window.getComputedStyle(target).getPropertyValue("display");
            if(status && status === 'none') toggle.click();
        })
        const toggle = parent.querySelector('.structure-item')
        if(toggle) toggle.click();

    },
    setExpandAllChildren: function(target){
        const structure = document.querySelector('#bricks-structure');
        if(!structure) return;
        const items = structure.querySelectorAll('.structure-item');
        if(items.length < 1) return;
        items.forEach(item => {
            let action = item.querySelector('ul.actions');
            if(!action){
                item.querySelector(".title").insertAdjacentHTML("afterEnd",`<ul class="actions"></ul>`);
                action = item.querySelector('ul.actions');
            }
            const existing = action.querySelector('.action.expand');
            if (existing) existing.remove();
            const parent = action.closest('[data-id]');
            const toggles = parent.querySelectorAll('.bricks-svg-wrapper.toggle')
            if(toggles.length < 1) return;
            const a = document.createElement('li');
            a.setAttribute('class', 'action expand');
            a.setAttribute('title', "Expand");
            a.setAttribute('onclick', 'ADMINBRXC.expandAllChildren(event)');
            a.innerHTML = `<span class="bricks-svg-wrapper"><!--?xml version="1.0" encoding="UTF-8"?--><svg version="1.1" viewBox="0 0 16 16" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" class="bricks-svg"><g fill="currentColor" fill-rule="evenodd"><path d="M2,8l5.32907e-15,7.54979e-08c-4.16963e-08,-0.276142 0.223858,-0.5 0.5,-0.5h11l-2.18557e-08,8.88178e-16c0.276142,-1.20706e-08 0.5,0.223858 0.5,0.5c1.20706e-08,0.276142 -0.223858,0.5 -0.5,0.5h-11l-2.78181e-08,-3.55271e-15c-0.276142,-4.49893e-08 -0.5,-0.223858 -0.5,-0.5Zm6,-1.5l-2.18557e-08,-8.88178e-16c0.276142,1.20706e-08 0.5,-0.223858 0.5,-0.5v-4.5v0c0,-0.276142 -0.223858,-0.5 -0.5,-0.5c-0.276142,0 -0.5,0.223858 -0.5,0.5v4.5l5.32907e-15,7.54979e-08c4.16963e-08,0.276142 0.223858,0.5 0.5,0.5Z"></path><path d="M10.354,3.854l2.23014e-08,-2.2245e-08c0.195509,-0.195015 0.195909,-0.511597 0.000893739,-0.707106c-0.000297551,-0.000298304 -0.000595479,-0.000596232 -0.000893784,-0.000893784l-2,-2l4.41373e-09,4.4249e-09c-0.195015,-0.195509 -0.511597,-0.195909 -0.707106,-0.000893793c-0.000298304,0.000297551 -0.000596232,0.000595479 -0.000893784,0.000893784l-2,2l-2.1107e-09,2.1107e-09c-0.195509,0.195509 -0.195509,0.512491 4.22141e-09,0.708c0.195509,0.195509 0.512491,0.195509 0.708,-4.22141e-09l1.646,-1.647l1.646,1.647l-3.52833e-08,-3.53726e-08c0.195015,0.195509 0.511597,0.195909 0.707106,0.000893854c0.000298304,-0.000297551 0.000596233,-0.000595479 0.000893784,-0.000893784Zm-2.354,5.646h-2.18557e-08c0.276142,-1.20706e-08 0.5,0.223858 0.5,0.5v4.5v0c0,0.276142 -0.223858,0.5 -0.5,0.5c-0.276142,0 -0.5,-0.223858 -0.5,-0.5v-4.5l5.32907e-15,7.54979e-08c-4.16963e-08,-0.276142 0.223858,-0.5 0.5,-0.5Z"></path><path d="M10.354,12.146l2.23014e-08,2.2245e-08c0.195509,0.195015 0.195909,0.511597 0.000893739,0.707106c-0.000297551,0.000298304 -0.000595479,0.000596232 -0.000893784,0.000893784l-2,2l4.41373e-09,-4.4249e-09c-0.195015,0.195509 -0.511597,0.195909 -0.707106,0.000893793c-0.000298304,-0.000297551 -0.000596232,-0.000595479 -0.000893784,-0.000893784l-2,-2l-2.1107e-09,-2.1107e-09c-0.195509,-0.195509 -0.195509,-0.512491 4.22141e-09,-0.708c0.195509,-0.195509 0.512491,-0.195509 0.708,4.22141e-09l1.646,1.647l1.646,-1.647l-3.52833e-08,3.53726e-08c0.195015,-0.195509 0.511597,-0.195909 0.707106,-0.000893854c0.000298304,0.000297551 0.000596233,0.000595479 0.000893784,0.000893784Z"></path></g></svg></span>`;
            action.prepend(a);
        })
    },
    // dragAndDropClasses: function(){
    //     const self = this;
    //     if(!self.helpers.isElementActive()) return;
    //     const classWrapper = document.querySelector('#bricks-panel-element-classes > ul.element-classes');
    //     if(!classWrapper) return;
    //     const li = classWrapper.querySelectorAll('li');
    //     if(li.length < 2 || !self.vueState.activeElement.settings.hasOwnProperty('_cssGlobalClasses') || !Array.isArray(self.vueState.activeElement.settings._cssGlobalClasses) || self.vueState.activeElement.settings._cssGlobalClasses.length < 2) return;
    //     function move(arr, from, to, on = 1) {
    //         return arr.splice(to, 0, ...arr.splice(from, on)), arr
    //     }
    //     const sortable = new Sortable(classWrapper, {
    //         animation: 150,
    //         handle: "li",
    //         onEnd: function (evt) {
    //             if(evt.oldIndex !== evt.newIndex){
    //                 move(self.vueState.activeElement.settings._cssGlobalClasses, evt.oldIndex, evt.newIndex);
    //                 self.helpers.saveChanges('globalClasses');
    //             }
    //         },
    //      })

    // },
    replaceColorsPalette: function(){
        const self = this;
        if(!self.helpers.isElementActive()) return;
        const grid = document.querySelector('#bricks-panel-element ul.color-palette.grid');
        if(!grid) return;
        const btns = grid.querySelectorAll('li.color .color-button');
        btns.forEach(btn => {
            const balloon = btn.dataset.balloon;
            if(!balloon.startsWith('var(')) return;
            btn.style.backgroundColor = balloon;
        })

    },
    previousTheme: false,
    checkForThemeChange: function(){
        const self = this;
        if(self.previousTheme === false) self.previousTheme = self.vueState.themeStyleActive;
        if(self.previousTheme !== self.vueState.themeStyleActive) {
            self.previousTheme = self.vueState.themeStyleActive;
            self.generateVariableCSS('theme');
            self.generateBuilderCSS();
        }
    },

    addGridUIIcon: function(){
        const self = this;
        if(!self.helpers.isElementActive() || self.vueState.activePanelTab !== "content" || self.vueState.showInteractions === true || self.vueState.showConditions === true) return;

        setTimeout(() => {

            const wrapper = document.querySelector('[data-controlkey="_display"]')
            if (!wrapper) return;

            if(!self.vueGlobalProp.$_elementHasCssGrid()){
                wrapper.classList.remove('grid-icon-active');
                const icon = wrapper.querySelector('.brxc-gridui-icon');
                if(icon) icon.remove(); 
                return;
            }
             
            const icon = wrapper.querySelector('.brxc-gridui-icon');
            const target = self.helpers.createTargetWithPseudo('gridBuilderSettings');
            const settings = self.helpers.isClassActive() ? self.vueState.activeClass.settings : self.vueState.activeElement.settings;
            if (icon) {
                settings.hasOwnProperty(target) ? icon.classList.add('active') : icon.classList.remove('active');
                return;
            }

            const className = settings.hasOwnProperty(target) ? 'brxc-gridui-icon active' : 'brxc-gridui-icon';
        
            wrapper.classList.add('grid-icon-active');
            self.addIconToFields(
                'div',
                className,
                false,
                'Grid Builder',
                'top-right',
                'ADMINBRXC.gridBuilderInit();ADMINBRXC.openModal(false, "#brxcGridUIOverlay")',
                false,
                "<i class='ion-ios-grid'></i>",
                wrapper.querySelector("[data-control='select']"),
                'after'
            );
            

        }, 150);
    },
    gridUIStates: {
        activeChild: null,
        grid: null,
        elements: null,
        gridReset: null,
        elementsReset: null,
        els: [],
        draggingEl: null,
        draggingElSize: null,
        globalCols: 3,
        globalRows: 3,
        globalGap: '20px',
    },
        // States
    
    gridBuilderBentoGrid: function(){
        const self = this;
        const elements = self.gridUIStates.elements;
        self.gridUIStates.grid.autoFlow = true;
        elements.forEach(el => {
            el.xSpan = 1;
            el.xSpanValue = 1;
            el.ySpan = 1;
            el.ySpanValue = 1;
        });

        const cols = self.gridUIStates.grid.col.length;
        const rows = self.gridUIStates.grid.row.length;
        
        function getFreeSlots(cols, rows){
            let usedSlots = 0;
            elements.forEach(el => {
                usedSlots += el.xSpanValue * el.ySpanValue;
            })
            return (cols * rows) - usedSlots;
        }
        function removeSlot(){
            let span;
            span = Math.floor(Math.random() * 2) === 1 ?  "xSpanValue" : "ySpanValue";
            const filteredEls = elements.filter(el => el && el[span] > 1);
            if(!filteredEls) return;
            let ind = Math.floor(Math.random() * filteredEls.length);
            const obj = filteredEls[ind];
            obj[span]--;
        }
        function addNewSlot(){
            let span;
            span = Math.floor(Math.random() * 2) === 1 ?  "x" : "y";
            const index = Math.floor(Math.random() * (elements.length - 1));
            elements[index][`${span}SpanValue`]++;
        }
        function populateSlots(){
            if(getFreeSlots(cols, rows) === 0) return;
            if(getFreeSlots(cols, rows) < 0) {
                removeSlot();
                populateSlots();
                return;
            }
            addNewSlot();
            populateSlots();
        }
        populateSlots()

         // Reload Grid
         self.gridBuilderSaveSettings();
         self.gridBuilderInit();
    },

    gridBuilderSetHeight: function(){
        const height = parseInt(document.defaultView.getComputedStyle(document.querySelector('.gridUI__grid-maxi-container')).height, 10)
        document.querySelector('.gridUI__main-container').style.setProperty("--max-height", `${height}px`);
    },
    gridBuilderSetNotification: function(){
        const self = this;
        const wrapper = document.querySelector('#gridUI-notification');
        const mainContainer = document.querySelector('.gridUI__main-container');
        let text = '';
        if(self.gridUIStates.children === "[]"){
            mainContainer.classList.add('empty');
            text = `<div class="danger" data-control="info"><u>No Children detected!</u> Make sure to add children elements to your parent container.</div>`;
            wrapper.innerHTML = text;
            return;
        }
        mainContainer.classList.remove('empty');
        if(!self.gridUIStates.isClass && !self.gridUIStates.hasQuery) return wrapper.innerHTML = '';
        if(self.gridUIStates.hasQuery) text = `<div data-control="info"><u>Query Loop detected!</u> The Grid settings will be saved as Custom CSS.</div>`;
        if(self.gridUIStates.isClass) text = `<div data-control="info"><u>Class detected!</u> The Grid settings will be saved as Custom CSS.</div>`;
        wrapper.innerHTML = text;
    },
    gridBuilderSetBreakpoints: function(){
        const self = this;
        const wrapper = document.querySelector('#gridUI-bp-wrapper');
        let css = '';
        self.vueState.breakpoints.forEach(bp =>{
            let svg = '<span class="bricks-svg-wrapper"><svg version="1.1" viewBox="0 0 30 30" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" class="bricks-svg"><path d="M27.744,2.5h-25.488c-0.968,0 -1.756,0.788 -1.756,1.755v17.489c0,0.968 0.788,1.755 1.756,1.755h12.244v3h-5.5c-0.276,0 -0.5,0.224 -0.5,0.5c0,0.276 0.224,0.5 0.5,0.5h12c0.276,0 0.5,-0.224 0.5,-0.5c0,-0.276 -0.224,-0.5 -0.5,-0.5h-5.5v-3h12.244c0.968,0 1.756,-0.788 1.756,-1.755v-17.489c0,-0.967 -0.788,-1.755 -1.756,-1.755Zm-1.244,18h-23v-15h23v15Z" fill="currentColor"></path></svg></span>';
            if( bp.icon === "laptop") {
                svg = '<span class="bricks-svg-wrapper"><svg version="1.1" viewBox="0 0 512 512" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" class="bricks-svg"><path d="M80.14,400c-17.7503,0 -32.14,-14.3897 -32.14,-32.14v-239.72c0,-17.7503 14.3897,-32.14 32.14,-32.14h351.72c17.7503,0 32.14,14.3897 32.14,32.14v239.72c0,17.7503 -14.3897,32.14 -32.14,32.14Z" stroke-width="32" stroke="currentColor" fill="none" stroke-linejoin="round"></path><path fill="currentColor" stroke="currentColor" stroke-linecap="round" stroke-width="32" d="M16,416h480"></path></svg></span>';
            }
            if( bp.icon === "tablet-landscape") {
                svg = '<span class="bricks-svg-wrapper"><svg version="1.1" viewBox="0 0 512 512" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" class="bricks-svg"><g transform="matrix(1,0,0,1,0,512)"><path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="32" d="M128,496c-26.5094,0 -48,-21.4906 -48,-48v-384c0,-26.5094 21.4906,-48 48,-48h256c26.5094,0 48,21.4906 48,48v384c0,26.5094 -21.4906,48 -48,48Z" transform="matrix(6.12323e-17,-1,1,6.12323e-17,0,0)"></path></g></svg></span>';
            }
            if( bp.icon === "tablet-portrait") {
                svg = '<span class="bricks-svg-wrapper"><svg version="1.1" viewBox="0 0 512 512" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" class="bricks-svg"><path d="M128,496c-26.5094,0 -48,-21.4906 -48,-48v-384c0,-26.5094 21.4906,-48 48,-48h256c26.5094,0 48,21.4906 48,48v384c0,26.5094 -21.4906,48 -48,48Z" stroke-linecap="round" stroke-width="32" stroke="currentColor" fill="none" stroke-linejoin="round"></path></svg></span>';
            }
            if( bp.icon === "phone-landscape") {
                svg = '<span class="bricks-svg-wrapper"><svg version="1.1" viewBox="0 0 512 512" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" class="bricks-svg"><g transform="matrix(1,0,0,1,0,512)"><path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="32" d="M176,496c-26.5094,0 -48,-21.4906 -48,-48v-384c0,-26.5094 21.4906,-48 48,-48h160c26.5094,0 48,21.4906 48,48v384c0,26.5094 -21.4906,48 -48,48Z" transform="matrix(6.12323e-17,-1,1,6.12323e-17,0,0)"></path></g><path d="M16,336v-24l9.23706e-14,1.20797e-06c-6.67141e-07,-4.41828 3.58172,-8 8,-8v0h-6.99382e-07c8.83656,3.86258e-07 16,-7.16344 16,-16v-64v0c0,-8.83656 -7.16344,-16 -16,-16v0h-3.49691e-07c-4.41828,-1.93129e-07 -8,-3.58172 -8,-8c0,0 0,-2.84217e-14 0,-2.84217e-14v-24" stroke-linecap="round" stroke-width="32" stroke="currentColor" fill="none" stroke-linejoin="round"></path></svg></span>';
            }
            if( bp.icon === "phone-portrait") {
                svg = '<span class="bricks-svg-wrapper"><svg version="1.1" viewBox="0 0 512 512" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" class="bricks-svg"><g stroke-linecap="round" stroke-width="32" stroke="currentColor" fill="none" stroke-linejoin="round"><path d="M176,496c-26.5094,0 -48,-21.4906 -48,-48v-384c0,-26.5094 21.4906,-48 48,-48h160c26.5094,0 48,21.4906 48,48v384c0,26.5094 -21.4906,48 -48,48Z"></path><path d="M176,16h24l-3.49691e-07,7.10543e-15c4.41828,-1.93129e-07 8,3.58172 8,8v0l1.7053e-13,2.41593e-06c1.33428e-06,8.83656 7.16345,16 16,16h64l-6.99382e-07,-1.42109e-14c8.83656,3.86258e-07 16,-7.16344 16,-16v0l1.13687e-13,1.20797e-06c-6.67141e-07,-4.41828 3.58172,-8 8,-8h24"></path></g></svg></span>';
            }
            let selector = `gridBuilderSettings`;
            if(bp.key !== 'desktop'){
                selector += `:${bp.key}`;
            }

            const settings = self.gridUIStates.isClass ? self.vueState.activeClass.settings : self.vueState.activeElement.settings;
            let hasStyle = settings.hasOwnProperty(selector) ? true : false;

            //css += `<li class="brxc-group-icon${self.vueState.breakpointActive === bp.key ? ' active' : ''}${self.vueGlobalProp.$_getGlobalClass(classId).settings.hasOwnProperty(selector) && self.vueGlobalProp.$_getGlobalClass(classId).settings[selector] !== '' ? ' has-styles' : ''}" data-balloon="${bp.label}" data-balloon-pos="bottom-right" onclick="ADMINBRXC.vueState.breakpointActive = '${bp.key}';ADMINBRXC.gridBuilderInit();">${svg}</li>`;
            css += `<li class="brxc-group-icon${self.vueState.breakpointActive === bp.key ? ' active' : ''}${hasStyle ? ' has-styles' : ''}" data-balloon="${bp.label}" data-balloon-pos="bottom-right" onclick="ADMINBRXC.vueState.breakpointActive = '${bp.key}';setTimeout(() => ADMINBRXC.gridBuilderInit(), 5);">${svg}</li>`;
        })
        wrapper.innerHTML = css;
    },
    gridBuilderRemoveSetting: function(){
        const self = this;
        const parent = self.gridUIStates.isClass ? self.vueState.activeClass : self.vueState.activeElement;
        const target = self.helpers.createTargetWithPseudo('gridBuilderSettings');
        delete parent.settings[target];
        self.vueState.rerenderControls = Date.now()
        self.gridBuilderInit();
    },

    gridBuilderResizableWidth: function(){
        const wrapper = document.querySelector('.gridUI__main-container');
        const draggable = document.querySelector('.gridUI__grid-width.handle-right')
    

        let startX, startWidth;

        // Width
        const initDragWidth = (e) => {
            startX = e.clientX;
            startWidth = parseInt(document.defaultView.getComputedStyle(wrapper).width, 10);
            document.documentElement.addEventListener('mousemove', doDragWidth, false);
            document.documentElement.addEventListener('mouseup', stopDragWidth, false);
        }

        const doDragWidth = (e) => {
            wrapper.style.maxWidth = (startWidth + e.clientX - startX) + 'px';
        }

        const stopDragWidth = (e) => {
            document.documentElement.removeEventListener('mousemove', doDragWidth, false);    
            document.documentElement.removeEventListener('mouseup', stopDragWidth, false);
        }

        draggable.addEventListener('mousedown', initDragWidth, false);
    },

    gridBuilderResizableHeight: function(){
        const wrapper = document.querySelector('.gridUI__main-container');
        const draggable = document.querySelector('.gridUI__grid-width.handle-bottom')
    

        let startY, startHeight;

        // Width
        const initDragHeight = (e) => {
            startY = e.clientY;
            startHeight = parseInt(document.defaultView.getComputedStyle(wrapper).height, 10);
            document.documentElement.addEventListener('mousemove', doDragHeight, false);
            document.documentElement.addEventListener('mouseup', stopDragHeight, false);
        }

        const doDragHeight = (e) => {
            wrapper.style.setProperty('--max-height',`${startHeight + e.clientY - startY}px`);
        }

        const stopDragHeight = (e) => {
            document.documentElement.removeEventListener('mousemove', doDragHeight, false);    
            document.documentElement.removeEventListener('mouseup', stopDragHeight, false);
        }

        draggable.addEventListener('mousedown', initDragHeight, false);
    },

    gridBuilderSetGridElements: function(){
        const self = this;
        const container = document.querySelector('.gridUI__grid-container');
        container.innerHTML = '';
        let i = 0;
        for (const key of Object.keys(self.gridUIStates.elements)) {
            const element = document.createElement('div');
            element.classList.add('gridUI__grid-element');
            element.setAttribute('data-id', self.gridUIStates.elements[key].id);
            element.style.setProperty('--hue', self.gridUIStates.elements[key].color);
            element.setAttribute('draggable', 'true');
            element.setAttribute('onclick', `ADMINBRXC.gridBuilderSetChild('${self.gridUIStates.elements[key].id}');`)
            element.setAttribute('ondragstart', 'this.preventDefault;event.stopPropagation();ADMINBRXC.gridBuilderDragStartElement(this)');
            element.setAttribute('ondrag', 'this.preventDefault;event.stopPropagation();ADMINBRXC.gridBuilderDragElement(this)');
            element.setAttribute('ondragend', 'ADMINBRXC.gridBuilderDragEnd(this)');
            if(self.gridUIStates.activeChild !== null && self.gridUIStates.activeChild !== self.gridUIStates.elements[key].id) element.classList.add('inactive');
            if(self.gridUIStates.activeChild !== null && self.gridUIStates.activeChild === self.gridUIStates.elements[key].id) element.classList.add('active');
            let content = '';
            content += `${self.gridUIStates.elements[key].label}<div class="gridUI__grid-handle-container${(self.gridUIStates.elements[key].hasOwnProperty('yEnd') && self.gridUIStates.elements[key].yEnd > (self.gridUIStates.grid.col.length + 1)) || (self.gridUIStates.elements[key].hasOwnProperty('xEnd') && self.gridUIStates.elements[key].xEnd > (self.gridUIStates.grid.row.length + 1)) ? ' error' : ''}">`
            content += `<div class="action-top">`;
            if(self.gridUIStates.activeChild !== null && self.gridUIStates.activeChild === self.gridUIStates.elements[key].id) content +=`<div class="gridUI__grid-handle clear" data-balloon="Clear View" data-balloon-pos="bottom" onClick="event.stopPropagation();ADMINBRXC.gridBuilderRemoveActiveChild();"><span class="bricks-svg-wrapper"><i class="fas fa-xmark"></i></span></div>`;
            if(self.gridUIStates.elements[key].hasOwnProperty('xStart') 
                || self.gridUIStates.elements[key].hasOwnProperty('xEnd') 
                || self.gridUIStates.elements[key].hasOwnProperty('xStart') 
                || self.gridUIStates.elements[key].hasOwnProperty('xEnd') 
                || self.gridUIStates.elements[key].hasOwnProperty('yStart') 
                || self.gridUIStates.elements[key].hasOwnProperty('yEnd') 
                || (self.gridUIStates.elements[key].hasOwnProperty('xSpan') && self.gridUIStates.elements[key].xSpan === 1 && self.gridUIStates.elements[key].hasOwnProperty('xSpanValue'))
                || (self.gridUIStates.elements[key].hasOwnProperty('ySpan') && self.gridUIStates.elements[key].ySpan === 1 && self.gridUIStates.elements[key].hasOwnProperty('ySpanValue'))
              ) {
                content += `<div class="gridUI__grid-handle delete" data-balloon="Remove Styles" data-balloon-pos="bottom" onClick="event.stopPropagation();ADMINBRXC.gridBuilderDeleteElementSettings(this.parentElement.parentElement.parentElement.dataset.id)"><span class="bricks-svg-wrapper"><i class="fas fa-undo"></i></span></div>`;
            }
            content +=`<div class="gridUI__grid-handle dom">${i + 1}</div>`;
            content +=`</div>`
            content +=`<div class="gridUI__grid-handle resize handle-down-right" data-x-dir="ltr" data-y-dir="ttb"><span class="bricks-svg-wrapper"><i class="fas fa-chevron-up"></i></span></div>`;
            content +=`<div class="gridUI__grid-handle resize handle-down-left" data-x-dir="rtl" data-y-dir="ttb"><span class="bricks-svg-wrapper"><i class="fas fa-chevron-up"></i></span></div>`;
            content +=`<div class="gridUI__grid-handle resize handle-up-right" data-x-dir="ltr" data-y-dir="btt"><span class="bricks-svg-wrapper"><i class="fas fa-chevron-up"></i></span></div>`;
            content +=`<div class="gridUI__grid-handle resize handle-up-left" data-x-dir="rtl" data-y-dir="btt"><span class="bricks-svg-wrapper"><i class="fas fa-chevron-up"></i></span></div>`;
            content +=`</div>`;
            element.innerHTML = content
            container.appendChild(element);
            i++;
        }
    },
    gridBuilderSetChild: function(id){
        const self = this;
        self.gridUIStates.activeChild = id;
        self.gridBuilderSetChildInfo(id);
        self.gridBuilderInitPreview();
    },
    gridBuilderAddCell: function(){
        const self = this;
        self.gridUIStates.elements.push({
            id: `${self.gridUIStates.elements.length + 1}`,
            label: `nth-child(${self.gridUIStates.elements.length + 1})`,
            color: Math.floor(Math.random() * 360),
        });
        self.gridBuilderSaveSettings();
        self.gridBuilderSetGridElements();
    },
    gridBuilderRemoveCell: function(){
        const self = this;
        self.gridUIStates.elements.pop();
        self.gridUIStates.activeChild = null;
        self.gridBuilderSaveSettings();
        self.gridBuilderSetGridElements();
        self.gridBuilderSetChildInfo(false);
    },
    gridBuilderSetParentInfo: function(){
        const self = this;
        const wrapper = document.querySelector('#gridUI__parent-settings');
        let content = `<span class="gridUI__title">Parent Settings</span>
                    <div class="gridUI__input-inline-container">
                        <div class="gridUI__input-wrapper">
                            <label for="cols">Columns:</label>
                            <input id="cols" class="gridUI__grid-inputs event" type="number" value="${self.gridUIStates.grid.col.length}" min="1" max="12" autocomplete="off">
                        </div>
                        <div class="gridUI__input-wrapper">
                            <label for="rows">Rows:</label>
                            <input id="rows" class="gridUI__grid-inputs event" type="number" value="${self.gridUIStates.grid.row.length}" min="1" max="12" autocomplete="off">
                        </div>
                    </div>
                    <div class="gridUI__input-wrapper">
                        <label for="cols">Gap:</label>
                        <input id="gap" class="gridUI__grid-inputs" type="text" value="${self.gridUIStates.grid.gap}" autocomplete="off">
                    </div>
                    <div class="gridUI__input-wrapper auto-flow">
                        <label for="auto-flow" class="has-tooltip"><span>Fill empty cells</span><div data-balloon="If this option is checked, the grid-auto-flow will be set to DENSE and fill the empty cells inside the grid." data-balloon-pos="bottom" data-balloon-length="medium"><i class="fas fa-circle-question"></i></div></label>
                        ${self.gridUIStates.grid.autoFlow === true ? '<i class="fas fa-toggle-on"></i>' : '<i class="fas fa-toggle-off"></i>'}
                    </div>
                    <div class="gridUI__input-wrapper minmax">
                        <label for="minmax" class="has-tooltip"><span>Use minmax()</span><div data-balloon="If this option is checked, all the cols/rows values will be wrapped inside a minmax() function." data-balloon-pos="bottom" data-balloon-length="medium"><i class="fas fa-circle-question"></i></div></label>
                        ${self.gridUIStates.grid.minmax === true ? '<i class="fas fa-toggle-on"></i>' : '<i class="fas fa-toggle-off"></i>'}
                    </div>`;
        if(self.gridUIStates.isClass === true || self.gridUIStates.hasQuery){
            content += `<div class="gridUI__input-wrapper repeat">
                            <label for="repeat" class="has-tooltip"><span>Repeat Grid</span><div data-balloon="If this option is checked, the childen CSS declarations will include a repetitive pattern (an+b)." data-balloon-pos="bottom" data-balloon-length="medium"><i class="fas fa-circle-question"></i></div></label>
                            ${self.gridUIStates.grid.repeat === true ? '<i class="fas fa-toggle-on"></i>' : '<i class="fas fa-toggle-off"></i>'}
                        </div>
                        <div class="gridUI__input-wrapper replace-css">
                            <label for="minmax" class="has-tooltip"><span>Replace CSS automatically</span><div data-balloon="If this option is checked, the script will remove any CSS declarations generated previously by the Grid Builder before adding the new ones." data-balloon-pos="bottom" data-balloon-length="medium"><i class="fas fa-circle-question"></i></div></label>
                            ${self.gridUIStates.grid.replaceCSS === true ? '<i class="fas fa-toggle-on"></i>' : '<i class="fas fa-toggle-off"></i>'}
                        </div>
                        <div class="gridUI__input-inline-container add-cells">
                            <a class="brxc-overlay__action-btn secondary" onclick="ADMINBRXC.gridBuilderRemoveCell();"><span>Remove Cell</span></a>
                            <a class="brxc-overlay__action-btn secondary" onclick="ADMINBRXC.gridBuilderAddCell();"><span>Add Cell</span></a>
                        </div>`;
        }
        wrapper.innerHTML = content;

        // Cols / rows
        const inputs = document.querySelectorAll('.gridUI__grid-inputs.event');
        inputs.forEach(input => {
            input.addEventListener('change', (e) => {
                if(typeof parseInt(e.target.value) !== "number") {
                    input.parentElement.classList.add('error');
                    return;
                }
                input.parentElement.classList.remove('error');
                self.gridBuilderSaveSettings();
                self.gridBuilderListenInputs();
                self.gridBuilderInitPreview();
                self.gridBuilderInitChild();
            })
            input.addEventListener('input', (e) => {
                if(typeof parseInt(e.target.value) !== "number") {
                    input.parentElement.classList.add('error');
                    return;
                }
                input.parentElement.classList.remove('error');
                self.gridBuilderSaveSettings();
                self.gridBuilderListenInputs();
                self.gridBuilderInitPreview();
                self.gridBuilderInitChild();
            })
        })

        // Gap
        const gapControl = document.querySelector('.gridUI__grid-inputs#gap');
        gapControl.addEventListener('input', (e) => {
            if(!CSS.supports("gap", e.target.value)) {
                gapControl.parentElement.classList.add('error');
                return;
            }
            gapControl.parentElement.classList.remove('error');
            self.gridBuilderSaveSettings();
            self.gridBuilderListenInputs();
            self.gridBuilderInitPreview();
            self.gridBuilderInitChild();
        })
        gapControl.addEventListener('focus', () =>{
            self.autocomplete(gapControl, self.cssVariables, "style", true);
        })

        // auto-flow
        const autoflowInput = document.querySelector('.gridUI__input-wrapper.auto-flow i[class*="fa-toggle"]');
        autoflowInput.addEventListener('click', () => {
            if(autoflowInput.classList.contains('fa-toggle-off')){
                self.gridUIStates.grid.autoFlow = true;
            } else {
                self.gridUIStates.grid.autoFlow = false;
            }
            self.gridBuilderSetGridCSS();
            self.gridBuilderSaveSettings();
            self.gridBuilderSetParentInfo();
        })

        // Use minmax()
        const minmaxInput = document.querySelector('.gridUI__input-wrapper.minmax i[class*="fa-toggle"]');
        minmaxInput.addEventListener('click', () => {
            if(minmaxInput.classList.contains('fa-toggle-off')){
                self.gridUIStates.grid.minmax = true;
            } else {
                self.gridUIStates.grid.minmax = false;
            }
            self.gridBuilderSaveSettings();
            self.gridBuilderSetParentInfo();
        })
        // Use repeat
        const repeatInput = document.querySelector('.gridUI__input-wrapper.repeat i[class*="fa-toggle"]');
        if(repeatInput){
            repeatInput.addEventListener('click', () => {
                if(repeatInput.classList.contains('fa-toggle-off')){
                    self.gridUIStates.grid.repeat = true;
                } else {
                    self.gridUIStates.grid.repeat = false;
                }
                self.gridBuilderSaveSettings();
                self.gridBuilderSetParentInfo();
            })
        }

        // replace CSS
        const replaceCSSInput = document.querySelector('.gridUI__input-wrapper.replace-css i[class*="fa-toggle"]');
        if(replaceCSSInput){
            replaceCSSInput.addEventListener('click', () => {
                if(replaceCSSInput.classList.contains('fa-toggle-off')){
                    self.gridUIStates.grid.replaceCSS = true;
                } else {
                    self.gridUIStates.grid.replaceCSS = false;
                }
                self.gridBuilderSaveSettings();
                self.gridBuilderSetParentInfo();
            })
        }
    },
    gridBuilderSetChildInfo: function(id){
        const self = this;
        const wrapper = document.querySelector('#gridUI__child-settings');
        if(id === false){
            wrapper.innerHTML = '';
            return;
        }
        const gridObj = Object.values(self.gridUIStates.elements).find(el => el && el.id === id);
        if(!gridObj) return;

        const events = ['change', 'input']
        let posXstart, posXend, posYstart, posYend, xSpan, xSpanValue, ySpan, ySpanValue, zIndex, color;
        gridObj.hasOwnProperty('xStart') ? posXstart = gridObj.xStart : posXstart = '';
        gridObj.hasOwnProperty('xEnd') ? posXend = gridObj.xEnd : posXend = '';
        gridObj.hasOwnProperty('yStart') ? posYstart = gridObj.yStart : posYstart = '';
        gridObj.hasOwnProperty('yEnd') ? posYend = gridObj.yEnd : posYend = '';
        gridObj.hasOwnProperty('xSpan') ? xSpan = gridObj.xSpan : false;
        gridObj.hasOwnProperty('xSpanValue') ? xSpanValue = gridObj.xSpanValue : xSpanValue = '';
        gridObj.hasOwnProperty('ySpan') ? ySpan = gridObj.ySpan : false;
        gridObj.hasOwnProperty('ySpanValue') ? ySpanValue = gridObj.ySpanValue : ySpanValue = '';
        gridObj.hasOwnProperty('zIndex') ? zIndex = gridObj.zIndex : zIndex = '';
        gridObj.hasOwnProperty('color') ? color = gridObj.color : color = '';
        let content = `<span class="gridUI__title">Child Settings <div class="gridUI__id-selector">${self.gridUIStates.isClass || self.gridUIStates.hasQuery ? `nth-child(${id})` : `#${id}`}<div class="icon-wrapper"data-balloon="Clear" data-balloon-pos="top" onclick="ADMINBRXC.gridBuilderRemoveActiveChild();"><i class="fas fa-close"></i></div></div></span>`;
        content += `<div class="gridUI__input-inline-container">
                        <div class="gridUI__input-wrapper">
                            <label for="label">Label:</label>
                            <input id="label" class="gridUI__grid-inputs label" type="text" value="${gridObj.label}" data-type="label"${self.gridUIStates.isClass || self.gridUIStates.hasQuery ? ' readonly' : ''} autocomplete="off">
                        </div>
                    </div>`;
        content += `<div class="gridUI__input-inline-container">`
        if(ySpan !== 1){
            content += `<div class="gridUI__input-wrapper">
                            <label for="grid-col-start">Column-Start:</label>
                            <input id="grid-col-start" class="gridUI__grid-inputs pos" type="number" min="1" max="12" value="${posYstart}" data-type="yStart" autocomplete="off">
                        </div>
                        <div class="gridUI__input-wrapper${posYend > (self.gridUIStates.grid.col.length + 1) ? ' error' : ''}">
                            <label for="grid-col-end">Column-End:</label>
                            <input id="grid-col-end" class="gridUI__grid-inputs pos" type="number" min="1" max="13" value="${posYend}" data-type="yEnd" autocomplete="off">
                        </div>`;
        } else {
            content += `<div class="gridUI__input-wrapper">
                            <label for="grid-col-span">Column-Span:</label>
                            <input id="grid-col-span" class="gridUI__grid-inputs pos" type="number" min="1" max="12" value="${ySpanValue}" data-type="ySpanValue" autocomplete="off">
                        </div>`
        }
            content += `<div class="gridUI__span-toggle"><div${ySpan === 1 ? ' class="active"' : ''} data-type="ySpan" data-balloon="${ySpan ? 'Disable' : 'Enable'} span" data-balloon-pos="top-right"><i class="fas fa-table-cells-large"></i></div></div>
                    </div>`;
        content += `<div class="gridUI__input-inline-container">`;
        if(xSpan !== 1){
            content += `<div class="gridUI__input-wrapper">
                            <label for="grid-row-start">Row-Start:</label>
                            <input id="grid-row-start" class="gridUI__grid-inputs pos" type="number" min="1" max="12" value="${posXstart}" data-type="xStart" autocomplete="off">
                        </div>
                        <div class="gridUI__input-wrapper${posXend > (self.gridUIStates.grid.row.length + 1) ? ' error' : ''}">
                            <label for="grid-row-end">Row-End:</label>
                            <input id="grid-row-end" class="gridUI__grid-inputs pos" type="number" min="1" max="13" value="${posXend}" data-type="xEnd" autocomplete="off">
                        </div>`
        } else {
            content += `<div class="gridUI__input-wrapper">
                            <label for="grid-row-span">Row-Span:</label>
                            <input id="grid-row-span" class="gridUI__grid-inputs pos" type="number" min="1" max="12" value="${xSpanValue}" data-type="xSpanValue" autocomplete="off">
                        </div>`
        }
                        
            content += `<div class="gridUI__span-toggle"><div${xSpan === 1 ? ' class="active"' : ''} data-type="xSpan" data-balloon="${xSpan ? 'Disable' : 'Enable'} span" data-balloon-pos="top-right"><i class="fas fa-table-cells-large"></i></div></div>
                    </div>`;
        content += `<div class="gridUI__input-inline-container">
                        <div class="gridUI__input-wrapper">
                            <label for="zIndex">z-index:</label>
                            <input id="zIndex" class="gridUI__grid-inputs z-index" type="number" min="-1" max="99999" value="${zIndex}" data-type="zIndex" autocomplete="off">
                        </div>
                        <div class="gridUI__input-wrapper">
                            <label for="color">Hue Color:</label>
                            <input id="color" class="gridUI__grid-inputs color" type="number" min="0" max="360" value="${color}" data-type="color" autocomplete="off">
                        </div>
                    </div>`;
        content += `<div class="gridUI__input-inline-container bottom m-top-16"><a class="brxc-overlay__action-btn secondary" onclick="ADMINBRXC.gridBuilderDeleteElementSettings(ADMINBRXC.gridUIStates.activeChild)"><span>Reset Styles</span></a>`;
        if(!self.gridUIStates.isClass && !self.gridUIStates.hasQuery) content += `<a class="brxc-overlay__action-btn secondary" onclick="ADMINBRXC.openElement('${id}');ADMINBRXC.closeModal(event, event.target, '#brxcGridUIOverlay')"><span>View Element</span></a>`;
        content += `</div>`;
        wrapper.innerHTML = content;
        const inputs = wrapper.querySelectorAll('.gridUI__grid-inputs.pos');
        if(!inputs || inputs.length < 1) return;
        inputs.forEach(input => {
            const events = ['change', 'input'];
            events.forEach(event => {
                input.addEventListener(event, (e) => {
                    const type = input.dataset.type.startsWith('x') ? 'row' : 'col';
                    if(typeof parseInt(e.target.value) !== "number" || e.target.value > (self.gridUIStates.grid[type].length + 1)) {
                        input.parentElement.classList.add('error');
                        return;
                    }
                    input.parentElement.classList.remove('error');
                    self.gridBuilderChangeGrid(id, input.dataset.type, parseInt(e.target.value))
                })
            })
        })

        // span toggle
        const spanToggles = document.querySelectorAll('.gridUI__span-toggle div');
        spanToggles.forEach(toggle => {
            toggle.addEventListener('click', () => {
                let value;
                toggle.classList.contains('active') ? value = 0 : value = 1;
                self.gridBuilderChangeGrid(id, toggle.dataset.type, value, true)
            })
        })

        // label
        const labelInput = document.querySelector('.gridUI__grid-inputs.label');
        if(!labelInput) return;
        labelInput.addEventListener('input', (e) => {
            if(e.target.value === "") {
                labelInput.parentElement.classList.add('error');
                return;
            }
            labelInput.parentElement.classList.remove('error');
            const gridObj = Object.values(self.gridUIStates.elements).find(el => el && el.id === id);
            if(!gridObj) return;
            gridObj.label = e.target.value;
            self.gridBuilderInitPreview();
            self.gridBuilderSaveSettings();
        })
    

        // zIndex
        const zIndexInput = document.querySelector('.gridUI__grid-inputs.z-index');
        if(!zIndexInput) return;
        events.forEach(event => {
            zIndexInput.addEventListener(event, (e) => {
                if(typeof parseInt(e.target.value) !== "number") {
                    zIndexInput.parentElement.classList.add('error');
                    return;
                }
                zIndexInput.parentElement.classList.remove('error');
                const gridObj = Object.values(self.gridUIStates.elements).find(el => el && el.id === id);
                if(!gridObj) return;
                gridObj.zIndex = parseInt(e.target.value);
                self.gridBuilderSaveSettings();
            })
        })

        // Color
        const colorInput = document.querySelector('.gridUI__grid-inputs.color');
        if(!colorInput) return;
        events.forEach(event => {
            colorInput.addEventListener(event, (e) => {
                if(typeof parseInt(e.target.value) !== "number") {
                    colorInput.parentElement.classList.add('error');
                    return;
                }
                colorInput.parentElement.classList.remove('error');
                const gridObj = Object.values(self.gridUIStates.elements).find(el => el && el.id === id);
                if(!gridObj) return;
                gridObj.color = parseInt(e.target.value);
                self.gridBuilderInitPreview();
                self.gridBuilderSaveSettings();
            })
        })
    },
    gridBuilderChangeGrid: function(id, type, value, reloadChild = false){
        const self = this;
        if(typeof value !== "number") return;
        const gridObj = Object.values(self.gridUIStates.elements).find(el => el && el.id === id);
        if(!gridObj) return;
        gridObj[type] = value;

         // Add Cols
         if(type === 'yEnd' && value > (self.gridUIStates.grid.col.length + 1)){
            const newCols = value - self.gridUIStates.grid.col.length + 1;
            for(let i = 0; i < newCols; i++){
                self.gridUIStates.grid.col.push('1fr');
            }
        }

        // Add Rows
        if(type === 'xEnd' && value > (self.gridUIStates.grid.row.length + 1)){
            const newRows = value - self.gridUIStates.grid.row.length + 1;
            for(let i = 0; i < newRows; i++){
                self.gridUIStates.grid.row.push('1fr');
            }
        }

        self.gridBuilderInitPreview();
        self.gridBuilderInitParent();
        if (reloadChild) self.gridBuilderInitChild();

    },
    gridBuilderRemoveActiveChild: function(){
        const self = this;
        self.gridUIStates.activeChild = null;
        self.gridBuilderSetChildInfo(false);
        self.gridBuilderInitPreview();
    },
    gridBuilderDeleteElementSettings: function(id){
        const self = this;
        const obj = Object.values(self.gridUIStates.elements).find(el => el && el.id === id);
        delete obj.xStart;
        delete obj.xEnd;
        delete obj.yStart;
        delete obj.yEnd;
        delete obj.xSpan;
        delete obj.xSpanValue;
        delete obj.ySpan;
        delete obj.ySpanValue;
        self.gridBuilderSaveSettings();
        self.gridBuilderInitPreview();
        self.gridBuilderInitParent();
        self.gridBuilderInitChild();
    },
    gridBuilderDragStartElement: function(el){
        const self = this;
        self.gridUIStates.draggingEl = el;
        //el.classList.add('moving');
        //intersect
        self.gridUIStates.els = [];
        const resizedRect = el.getBoundingClientRect();
        const guides = document.querySelectorAll('.gridUI__grid-guide');
        guides.forEach((guide) => {
            const guideRect = guide.getBoundingClientRect();

            // Check for intersection
            if (
                resizedRect.right > guideRect.left &&
                resizedRect.left < guideRect.right &&
                resizedRect.bottom > guideRect.top &&
                resizedRect.top < guideRect.bottom
            ) {
                // Intersection detected, you can handle it here
                if(!self.gridUIStates.els.includes(guide)) self.gridUIStates.els.push(guide);
            } else {
                self.gridUIStates.els = self.gridUIStates.els.filter(item => item !== guide);
            }
        });

        const sizeX = self.gridBuilderFindExtremeValue(self.gridUIStates.els, 'xEnd', 'max') - self.gridBuilderFindExtremeValue(self.gridUIStates.els, 'xStart', 'min');
        const sizeY = self.gridBuilderFindExtremeValue(self.gridUIStates.els, 'yEnd', 'max') - self.gridBuilderFindExtremeValue(self.gridUIStates.els, 'yStart', 'min');
        self.gridUIStates.draggingElSize = [sizeX, sizeY];
    },

    gridBuilderDragElement: function(el){
        //el.stopPropagation();
        const container = document.querySelector('.gridUI__grid-container-guide');
        container.style.zIndex = 2;
        const activeEl = document.querySelector('.gridUI__grid-element.active');
        if(!activeEl) return;
        activeEl.classList.add('inactive');
        activeEl.classList.remove('active');
        
    },

    gridBuilderDragEnd: function(){
        const self = this;
        const container = document.querySelector('.gridUI__grid-container-guide');
        container.style.zIndex = 0;
        self.gridBuilderSaveSettings();
    },

    gridBuilderDropElement: function(e){
        const self = this;
        const xEnd = parseInt(e.dataset.xEnd);
        const yEnd = parseInt(e.dataset.yEnd);
        const xStartTemp = xEnd - parseInt(self.gridUIStates.draggingElSize[0]);
        const yStartTemp = yEnd - parseInt(self.gridUIStates.draggingElSize[1]);
        const xStart = (xStartTemp > 0) ? xStartTemp : 1;
        const yStart = (yStartTemp > 0) ? yStartTemp : 1;
        const obj = Object.values(self.gridUIStates.elements).find(el => el && el.id === self.gridUIStates.draggingEl.dataset.id);
        if(obj.hasOwnProperty('xSpan')) delete obj.xSpan;
        if(obj.hasOwnProperty('xSpanValue')) delete obj.xSpanValue;
        if(obj.hasOwnProperty('ySpan')) delete obj.ySpan;
        if(obj.hasOwnProperty('ySpanValue')) delete obj.ySpanValue;
        obj.xStart = xStart;
        obj.xEnd = xEnd;
        obj.yStart = yStart;
        obj.yEnd = yEnd;

        // Add Cols
        if(yEnd > (self.gridUIStates.grid.col.length + 1)){
            const newCols = yEnd - self.gridUIStates.grid.col.length + 1;
            for(let i = 0; i < newCols; i++){
                self.gridUIStates.grid.col.push('1fr');
            }
        }

        // Add Rows
        if(xEnd > (self.gridUIStates.grid.row.length + 1)){
            const newRows = xEnd - self.gridUIStates.grid.row.length + 1;
            for(let i = 0; i < newRows; i++){
                self.gridUIStates.grid.row.push('1fr');
            }
        }
        self.gridBuilderSaveSettings();
        self.gridBuilderInitPreview();
        self.gridBuilderInitParent();
        self.gridBuilderInitChild();
    },

    gridBuilderBuildCSS: function(){
        const self = this;
        const styleSheet = document.querySelector('#gridUI__grid-elements');
        content = '';
        for(const key of Object.keys(self.gridUIStates.elements)){
            let hasStyle = false;
            let xStyles = false;
            let yStyles = false;

            // x
            if(self.gridUIStates.elements[key].hasOwnProperty('xSpan') && self.gridUIStates.elements[key].xSpan === 1 && self.gridUIStates.elements[key].hasOwnProperty('xSpanValue')){
                hasStyle = true;
                xStyles = `grid-row: span ${self.gridUIStates.elements[key].xSpanValue};`
            } else if(self.gridUIStates.elements[key].hasOwnProperty('xStart') && self.gridUIStates.elements[key].hasOwnProperty('xEnd')){
                hasStyle = true;
                xStyles = `grid-row: ${self.gridUIStates.elements[key].xStart} / ${self.gridUIStates.elements[key].xEnd};`
            }

            // y
            if(self.gridUIStates.elements[key].hasOwnProperty('ySpan') && self.gridUIStates.elements[key].ySpan === 1 && self.gridUIStates.elements[key].hasOwnProperty('ySpanValue')){
                hasStyle = true;
                yStyles = `grid-column: span ${self.gridUIStates.elements[key].ySpanValue};`
            } else if(self.gridUIStates.elements[key].hasOwnProperty('yStart') && self.gridUIStates.elements[key].hasOwnProperty('yEnd')){
                hasStyle = true;
                yStyles = `grid-column: ${self.gridUIStates.elements[key].yStart} / ${self.gridUIStates.elements[key].yEnd};`
            }

            // Styles
            if(hasStyle){
                content += `.gridUI__grid-element[data-id="${self.gridUIStates.elements[key].id}"]{`;
                if(xStyles) content += xStyles;
                if(yStyles) content += yStyles;
                content += '}';
            }

        }
        styleSheet.innerHTML = content;
    },

    gridBuilderSetGridGuides: function(){
        const self = this;
        const container = document.querySelector('.gridUI__grid-container-guide');
        const max = Array.from(self.gridUIStates.grid.col).length * Array.from(self.gridUIStates.grid.row).length;

        // Clear existing content
        container.innerHTML = '';

        // Create and append elements with valid dimensions
        for (let i = 0; i < max; i++) {
            const guide = document.createElement('div');
            guide.classList.add('gridUI__grid-guide');
            guide.setAttribute('data-id', i);
            guide.setAttribute('draggable', 'true');
            guide.setAttribute('ondragenter' , "this.classList.add('active')" );
            guide.setAttribute('ondragleave', "this.classList.remove('active')" );
            guide.setAttribute('ondragover', "event.preventDefault()" )
            guide.setAttribute('ondrop', 'ADMINBRXC.gridBuilderDropElement(this)');
            container.appendChild(guide);
        }

    },

    gridBuilderCalculateGridPosition: function() {
        const gridContainer = document.querySelector('.gridUI__grid-container');
        const gridGuides = document.querySelectorAll('.gridUI__grid-guide');
        const colCount = parseInt(window.getComputedStyle(gridContainer).gridTemplateColumns.split(' ').length);

        let row = 0;
        let col = 0;

        gridGuides.forEach(function(guide) {
            guide.setAttribute('data-x-start', row + 1);
            guide.setAttribute('data-x-end', row + 2);
            guide.setAttribute('data-y-start', col + 1);
            guide.setAttribute('data-y-end', col + 2);

            col++;

            if (col >= colCount) {
            col = 0;
            row++;
            }
        });
    },

    gridBuilderSetHandles: function(){
        const self = this;
        const handles = document.querySelectorAll('.gridUI__grid-handle-container');
        handles.forEach(handle => {
            self.gridBuilderMakeResizableDiv(handle);
        })
    },

    gridBuilderFindExtremeValue: function(elements, attribute, type) {
        if (elements.length === 0) {
            return undefined; // Return undefined if there are no elements
        }

        // Use the reduce function to find the extreme value
        const initialValue = parseInt(elements[0].dataset[attribute], 10);
        const extremeValue = Array.from(elements).reduce((extreme, element) => {
            const attributeValue = parseInt(element.dataset[attribute], 10); // Assuming the attribute is stored in the 'data-' attribute

            if (!isNaN(attributeValue)) {
            return type === 'min' ? Math.min(extreme, attributeValue) : Math.max(extreme, attributeValue);
            } else {
            return extreme;
            }
        }, initialValue);

        return extremeValue;
    },

    gridBuilderCalculateNewPosition: function(id, els){
        const self = this;
        const xStart = self.gridBuilderFindExtremeValue(self.gridUIStates.els, 'xStart', 'min')
        const xEnd = self.gridBuilderFindExtremeValue(self.gridUIStates.els, 'xEnd', 'max')
        const yStart = self.gridBuilderFindExtremeValue(self.gridUIStates.els, 'yStart', 'min')
        const yEnd = self.gridBuilderFindExtremeValue(self.gridUIStates.els, 'yEnd', 'max');
        const obj = Object.values(self.gridUIStates.elements).find(el => el && el.id === id);
        
        delete obj.xSpan;
        delete obj.xSpanValue;
        delete obj.ySpan;
        delete obj.ySpanValue;
        
        obj.xStart = xStart;
        obj.xEnd = xEnd;
        obj.yStart = yStart;
        obj.yEnd = yEnd;

    },

    gridBuilderMakeResizableDiv: function(div) {
        const self = this;
        const handles = div.querySelectorAll('.gridUI__grid-handle.resize');
        let isResizing = false;
        let startX, startY;

        handles.forEach(handle => {
            const xDirection = handle.dataset.xDir;
            const yDirection = handle.dataset.yDir;

            handle.addEventListener("mousedown", (e) => {
                e.preventDefault();
                e.stopPropagation();
                handle.parentElement.style.zIndex = 2;
                handle.parentElement.parentElement.classList.add('moving');
                isResizing = true;
                startX = e.clientX;
                startY = e.clientY;
                document.addEventListener("mousemove", handleMouseMove);
                document.addEventListener("mouseup", handleMouseUp);
                const activeEl = document.querySelector('.gridUI__grid-element.active');
                if(!activeEl) return;
                activeEl.classList.add('inactive');
                activeEl.classList.remove('active');
            });
        
            function handleMouseUp(){
                isResizing = false;
                document.removeEventListener("mousemove", handleMouseMove);
                document.removeEventListener("mouseup", handleMouseUp);
                self.gridBuilderCalculateNewPosition(handle.parentElement.parentElement.dataset.id, self.gridUIStates.els);
                self.gridBuilderSaveSettings();
                self.gridBuilderInitPreview();
                self.gridBuilderInitParent();
                self.gridBuilderInitChild();
            }
            function handleMouseMove(e) {
                if (isResizing) {
                    e.stopPropagation();
                    self.gridUIStates.els = [];
                    const deltaX = xDirection === "ltr" ? e.clientX - startX : -e.clientX + startX;
                    const deltaY = yDirection === "ttb" ? e.clientY - startY : -e.clientY + startY ;

                    // Calculate the new width and height based on the initial position
                    const newWidth = div.getBoundingClientRect().width + deltaX;
                    const newHeight = div.getBoundingClientRect().height + deltaY;

                    // Ensure resizing within the boundaries of the container
                    div.style.width = `${newWidth}px`;
                    div.style.height = `${newHeight}px`;
                    div.style.left = xDirection === "ltr" ? '0' : `auto`;
                    div.style.top = yDirection === "ttb" ? '0' : `auto`;

                    // Update the start position for the next movement
                    startX = e.clientX;
                    startY = e.clientY;

                    //intersect
                    const resizedRect = div.getBoundingClientRect();
                    const guides = document.querySelectorAll('.gridUI__grid-guide');
                    guides.forEach((guide) => {
                        const guideRect = guide.getBoundingClientRect();

                        // Check for intersection
                        if (
                            resizedRect.right >= guideRect.left &&
                            resizedRect.left <= guideRect.right &&
                            resizedRect.bottom >= guideRect.top &&
                            resizedRect.top <= guideRect.bottom
                        ) {
                            // Intersection detected, you can handle it here
                            guide.classList.add('active');
                            if(!self.gridUIStates.els.includes(guide)) self.gridUIStates.els.push(guide);
                        } else {
                            guide.classList.remove('active');
                            self.gridUIStates.els = self.gridUIStates.els.filter(item => item !== guide);
                        }
                    });
                }
            }
        })
    },

    gridBuilderSetHeaders: function(){
        const self = this;
        const headerTop = document.querySelector('.gridUI__grid-header.top');
        const headerLeft = document.querySelector('.gridUI__grid-header.left');
        let content = '';

        let i = 0;
        for(const value of Array.from(self.gridUIStates.grid.col)){
            content += `<div class="input-wrapper" data-balloon="Invalid CSS value" data-balloon-pos="top"><input type="text" value="${value}" data-type="col" data-index="${i}"></div>`;
            i++;
        }
        headerTop.innerHTML = content;

        content = '';
        i = 0;
        for(const value of Array.from(self.gridUIStates.grid.row)){
            content += `<div class="input-wrapper" data-balloon="Invalid CSS value" data-balloon-pos="top"><input type="text" value="${value}" data-type="row" data-index="${i}"></div>`
            i++;
        }
        headerLeft.innerHTML = content;
        const headerInputs = document.querySelectorAll('.gridUI__grid-header input');
        headerInputs.forEach(input => {
            input.addEventListener('input', (e) => {
                if(!CSS.supports("grid-template-columns", input.value)) {
                    input.parentElement.classList.add('error');
                    return;
                }
                input.parentElement.classList.remove('error');
                const type = input.dataset.type;
                const index = input.dataset.index;
                self.gridUIStates.grid[type][index] = input.value; 
                self.gridBuilderSetGridCSS();
                self.gridBuilderSaveSettings();
            })
        })
    },

    // gridBuilderReinit: function(checkRows = true){
    //     const self = this;
    //     self.gridBuilderSetGridCSS();
    //     self.gridBuilderSetGridElements();
    //     //calculateGridCols(checkRows, globalCols, globalCols);
    //     self.gridBuilderSetGridGuides();
    //     self.gridBuilderSetHeaders();
    //     self.gridBuilderSetParentInfo();
    //     self.gridBuilderCalculateGridPosition();
    //     self.gridBuilderBuildCSS();
    //     self.gridBuilderSetHandles(); 
    // },
    gridBuilderInitPreview: function(){
        const self = this;
        self.gridBuilderSetGridCSS();
        self.gridBuilderSetGridElements();
        self.gridBuilderSetGridGuides();
        self.gridBuilderSetHeaders();
        self.gridBuilderCalculateGridPosition();
        self.gridBuilderBuildCSS();
        self.gridBuilderSetHandles();
    },
    gridBuilderInitParent: function(){
        const self = this;
        self.gridBuilderSetParentInfo();
    },
    gridBuilderInitChild: function(){
        const self = this;
        if(self.gridUIStates.activeChild === null) return self.gridBuilderSetChildInfo(false);
        self.gridBuilderSetChildInfo(self.gridUIStates.activeChild);
    },

    gridBuilderCalculateGridCols: function(checkRows = true, rows, cols){
        const self = this;
        const container = document.querySelector('.gridUI__grid-container');
        const tempRows = window.getComputedStyle(container).getPropertyValue("grid-template-rows").split(' ').length;
        if(checkRows && parseInt(globalRows) < parseInt(tempRows)) {
            self.gridUIStates.globalRows = parseInt(tempRows);
            document.querySelector('#rows').value = self.gridUIStates.globalRows;
        }
        const main = document.querySelector('.gridUI__main-container');

        // main.style.setProperty('--col', globalCols);
        // main.style.setProperty('--row', globalRows);
        // main.style.setProperty('--gap', globalGap);

    },
    gridBuilderLoadDefaultGrid: function(){
        const self = this;
        self.gridUIStates.grid = {}
            self.gridUIStates.grid.col = []
            self.gridUIStates.grid.row = []
            // Cols
            const defaultCols = {
                '991': 3,
                '767': 2,
                '478': 1,
            };
            const orderedKeys = ['991', '767', '478'];

            const currentVw = parseInt(self.vueState.previewWidth);
            let finalCol = false;
            for(const key of orderedKeys){
                if(currentVw <= parseInt(key)) finalCol = defaultCols[key];
            }
            if(finalCol === false) finalCol = 4;
            for(let i = 0; i < finalCol; i++){
                self.gridUIStates.grid.col[i] = '1fr';
            }

            // Rows
            let finalRows;
            const numberItems = Object.keys(JSON.parse(self.gridUIStates.children)).length;
            numberItems === 0 ? finalRows = 1 : finalRows = Math.ceil(numberItems / finalCol);
            for(let i = 0; i < finalRows; i++){
                self.gridUIStates.grid.row[i] = '1fr';
            }

            // Gap
            self.gridUIStates.grid.gap = '20px';
    },
    gridBuilderLoadGrid: function(){
        const self = this;

        const parent = self.gridUIStates.isClass ? self.vueState.activeClass : self.vueState.activeElement;
        const target = self.helpers.createTargetWithPseudo('gridBuilderSettings');
        const higherBp = self.gridUIStates.isClass ? self.helpers.checkHigherBreakpoint('gridBuilderSettings', 'class') : self.helpers.checkHigherBreakpoint('gridBuilderSettings', 'element');
        if(parent.settings.hasOwnProperty(target)){
            self.gridUIStates.grid = JSON.parse(JSON.stringify(parent.settings[target].grid));
        } else if(higherBp){
            self.gridUIStates.grid = JSON.parse(JSON.stringify(parent.settings[higherBp].grid));
        } else {
            self.gridBuilderLoadDefaultGrid();
        }
        
    },

    gridBuilderSetGridCSS: function(){
        const self = this;
        const main = document.querySelector('.gridUI__main-container');
        main.style.setProperty('--globalCol', Array.from(self.gridUIStates.grid.col).map(value => value).join(' '));
        main.style.setProperty('--globalRow', Array.from(self.gridUIStates.grid.row).map(value => value).join(' '));
        main.style.setProperty('--globalGap', self.gridUIStates.grid.gap);
        let autoFlow;
        self.gridUIStates.grid.autoFlow === true ? autoFlow = 'dense' : autoFlow = 'initial';
        main.style.setProperty('--globalAutoFlow', autoFlow);
    },

    gridBuilderLoadElements: function(initialize = false){
        const self = this;

        let tempEls = [];
        const activeEl = self.gridUIStates.isClass === true ? self.vueState.activeClass : self.vueState.activeElement;
        const children = JSON.parse(self.gridUIStates.children);
        const target = self.helpers.createTargetWithPseudo('gridBuilderSettings');
        const higherBp = self.gridUIStates.isClass === true ? self.helpers.checkHigherBreakpoint('gridBuilderSettings', 'class') : self.helpers.checkHigherBreakpoint('gridBuilderSettings', 'element');
        let gridSettings = false;
        if(activeEl.settings.hasOwnProperty(target)) {
            gridSettings = activeEl.settings[target];
        } else if(higherBp){
            gridSettings = activeEl.settings[higherBp];
        } 

        // Element
        if(self.gridUIStates.isClass === false && self.gridUIStates.hasQuery === false){
            for(let i = 0; i<children.length; i++){
                const obj = self.vueGlobalProp.$_getElementObject(children[i]);
                tempEls[i] = {};
                tempEls[i].id = children[i];
                const label = obj.hasOwnProperty('label') ? obj.label : bricksData.elements[obj.name].label;
                tempEls[i].label = label;
                if(gridSettings && !initialize){
                    const gridObj = Object.values(gridSettings.elements).find(el => el && el.id === children[i])
                    if(gridObj){
                        // Position
                        if(gridObj.hasOwnProperty('xStart')) tempEls[i].xStart = gridObj.xStart;
                        if(gridObj.hasOwnProperty('xEnd')) tempEls[i].xEnd = gridObj.xEnd;
                        if(gridObj.hasOwnProperty('xSpan')) tempEls[i].xSpan = gridObj.xSpan;
                        if(gridObj.hasOwnProperty('xSpanValue')) tempEls[i].xSpanValue = gridObj.xSpanValue;
                        if(gridObj.hasOwnProperty('yStart')) tempEls[i].yStart = gridObj.yStart; 
                        if(gridObj.hasOwnProperty('yEnd')) tempEls[i].yEnd = gridObj.yEnd;
                        if(gridObj.hasOwnProperty('ySpan')) tempEls[i].ySpan = gridObj.ySpan;
                        if(gridObj.hasOwnProperty('ySpanValue')) tempEls[i].ySpanValue = gridObj.ySpanValue;


                        // zIndex
                        if(gridObj.hasOwnProperty('zIndex')) tempEls[i].zIndex = gridObj.zIndex;

                        // Color
                        if(gridObj.hasOwnProperty('color')) tempEls[i].color = gridObj.color; 
                    }
                }
            } 

        // Class
        } else {
            let childrenLength = Object.keys(children).length;
            // Existing settings
            if(gridSettings){
                tempEls = JSON.parse(JSON.stringify(gridSettings.elements));
                // if(gridSettings.elements.length > childrenLength){
                //     const minus = gridSettings.elements.length - childrenLength;
                //     for(let i = 0; i<minus; i++){
                //         tempEls.pop();
                //     }
                // }
                if (tempEls.length > childrenLength) childrenLength = tempEls.length;
                for(let i = 0; i<childrenLength; i++){
                    if(!tempEls[i]) tempEls[i] = {};
                    tempEls[i].id = `${i + 1}`;
                    tempEls[i].label = `nth-child(${i + 1})`;
                }
            
            // Generate new settings
            } else {
                for(let i = 0; i<childrenLength; i++){
                    tempEls[i] = {};
                    tempEls[i].id = `${i + 1}`;
                    tempEls[i].label = `nth-child(${i + 1})`;
                }
            }
        }

        self.gridUIStates.elements = tempEls;
        
        for(const key of Object.keys(self.gridUIStates.elements)){
            const color = Math.floor(Math.random() * 360)
            if(!self.gridUIStates.elements[key].hasOwnProperty('color')) self.gridUIStates.elements[key].color = color;
        }
    },

    gridBuilderAddColumn: function(){
        const self = this;
        self.gridUIStates.grid.col[Array.from(self.gridUIStates.grid.col).length] = '1fr';
        self.gridUIStates.grid.colWidth = Array.from(self.gridUIStates.grid.col).length;
        self.gridBuilderSaveSettings();
    },

    gridBuilderRemoveColumn: function(){
        const self = this;
        self.gridUIStates.grid.col.pop();
        self.gridUIStates.grid.colWidth = Array.from(self.gridUIStates.grid.col).length;
        self.gridBuilderSaveSettings();
    },

    gridBuilderAddRow: function(){
        const self = this;
        self.gridUIStates.grid.row[Array.from(self.gridUIStates.grid.row).length] = '1fr';
        self.gridUIStates.grid.rowWidth = Array.from(self.gridUIStates.grid.row).length;
        self.gridBuilderSaveSettings();
    },

    gridBuilderRemoveRow: function(){
        const self = this;
        self.gridUIStates.grid.row.pop();
        self.gridUIStates.grid.rowWidth = Array.from(self.gridUIStates.grid.row).length;
        self.gridBuilderSaveSettings();
    },

    gridBuilderListenInputs: function(){
        const self = this;
        let inputs = document.querySelectorAll('.gridUI__grid-inputs');

        self.gridUIStates.globalCols = parseInt(inputs[0].value);
        self.gridUIStates.globalRows = parseInt(inputs[1].value);
        self.gridUIStates.grid.gap = inputs[2].value;

        self.gridUIStates.grid.row = [];
        self.gridUIStates.grid.col = [];

        const headerTop = document.querySelectorAll('.gridUI__grid-header.top input');
        const headerLeft = document.querySelectorAll('.gridUI__grid-header.left input');

        for(let i = 0; i < headerTop.length; i++){
            self.gridUIStates.grid.col[i] = headerTop[i].value;
        }
        for(let i = 0; i < headerLeft.length; i++){
            self.gridUIStates.grid.row[i] = headerLeft[i].value;
        }

        // Col
        if(self.gridUIStates.grid.col.length < self.gridUIStates.globalCols) {
            const max = self.gridUIStates.globalCols - self.gridUIStates.grid.col.length;
            for(let i = 0; i<max; i++){
                self.gridBuilderAddColumn()
            }
        } else if(self.gridUIStates.grid.col.length > self.gridUIStates.globalCols){
            const max = self.gridUIStates.grid.col.length - self.gridUIStates.globalCols;
            for(let i = 0; i<max; i++){
                self.gridBuilderRemoveColumn();
            }
        }

        // Row
        if(self.gridUIStates.grid.row.length < self.gridUIStates.globalRows) {
            const max = self.gridUIStates.globalRows - self.gridUIStates.grid.row.length;
            for(let i = 0; i<max; i++){
                self.gridBuilderAddRow()
            }
        } else if(self.gridUIStates.grid.row.length > self.gridUIStates.globalRows){
            const max = self.gridUIStates.grid.row.length - self.gridUIStates.globalRows;
            for(let i = 0; i<max; i++){
                self.gridBuilderRemoveRow()
            }
        }

        self.gridBuilderSaveSettings();
    },
    gridBuilderIsQueryLoop: function(){
        const self = this;
        const children = self.vueState.activeElement.children;
        let hasQuery = false;
        if(children && children.length > 0) {
            children.forEach(child => {
                if(self.helpers.isElementQueryLoop(child)) hasQuery = true
            })
        }
        hasQuery ? self.gridUIStates.hasQuery = true : self.gridUIStates.hasQuery = false;
    },
    gridBuilderSetChildren: function(){
        const self = this;
        self.gridUIStates.children = self.gridUIStates.isClass || self.gridUIStates.hasQuery ? JSON.stringify(FRAMEBRXC.vueGlobalProp.$_getElementNode(self.vueState.activeElement).children) : JSON.stringify(self.vueState.activeElement.children);
    },
  
    gridBuilderIsClass: function(){
        const self = this;
        self.helpers.isClassActive() ? self.gridUIStates.isClass = true : self.gridUIStates.isClass = false;
    },

    gridBuilderInit: function(){
        const self = this;
        self.gridUIStates.activeChild = null;
        self.gridBuilderSetHeight();
        self.gridBuilderIsQueryLoop();
        self.gridBuilderIsClass();
        self.gridBuilderSetBreakpoints();
        self.gridBuilderSetChildren();
        self.gridBuilderSetNotification();
        self.gridBuilderLoadGrid();
        self.gridBuilderSetGridCSS();
        self.gridBuilderLoadElements();
        self.gridBuilderResizableWidth()
        self.gridBuilderResizableHeight()
        self.gridBuilderInitPreview();
        self.gridBuilderInitParent();
        self.gridBuilderInitChild();
    },
    gridBuilderSaveSettings: function(){
        const self = this;
        const parent = self.gridUIStates.isClass === true ? self.vueState.activeClass : self.vueState.activeElement;
        const target = self.helpers.createTargetWithPseudo('gridBuilderSettings');

        parent.settings[target] = {};
        parent.settings[target].grid = self.gridUIStates.grid;
        parent.settings[target].elements = self.gridUIStates.elements;
        self.vueState.rerenderControls = Date.now();
    },
    gridBuilderRemovePreviousCSS: function(css){
        const pattern = /\/\*\* GRID BUILDER[\s\S]*?End of Grid Builder CSS \*\*\//g;
        return css.replaceAll(pattern, '');
    },
    gridBuilderApply: function(){
        const self = this;
        const parent = self.gridUIStates.isClass === true ? self.vueState.activeClass : self.vueState.activeElement;
        

        // parent
        const targetGap = self.helpers.createTargetWithPseudo('_gridGap');
        parent.settings[targetGap] = self.gridUIStates.grid.gap;


        // ID
        if(self.gridUIStates.isClass === false && self.gridUIStates.hasQuery === false){

            // parent
            const targetCol = self.helpers.createTargetWithPseudo('_gridTemplateColumns');
            const targetRow = self.helpers.createTargetWithPseudo('_gridTemplateRows');
            const targetAutoFlow = self.helpers.createTargetWithPseudo('_gridAutoFlow');
            parent.settings[targetCol] = Array.from(self.gridUIStates.grid.col).map(value => self.gridUIStates.grid.hasOwnProperty('minmax') &&  self.gridUIStates.grid.minmax === true ? `minmax(0,${value})` : value).join(' ');
            parent.settings[targetRow] = Array.from(self.gridUIStates.grid.row).map(value => self.gridUIStates.grid.hasOwnProperty('minmax') &&  self.gridUIStates.grid.minmax === true ? `minmax(0,${value})` : value).join(' ');
            parent.settings[targetAutoFlow] = self.gridUIStates.grid.autoFlow === true ? 'dense' : '';

            //children
            const children = JSON.parse(self.gridUIStates.children);
            if(!Array.isArray(children) || children.length < 1) return;
            children.forEach(child => {
                const gridElement = Object.values(self.gridUIStates.elements).find(el => el && el.id === child);
                if(!gridElement) return;
                const obj = self.vueGlobalProp.$_getElementObject(child);
                if(!obj.hasOwnProperty('settings')) obj.settings = {};

                // x
                const targetRowSpan = self.helpers.createTargetWithPseudo('_gridItemRowSpan');
                if(gridElement.hasOwnProperty('xSpan') && gridElement.xSpan === 1 && gridElement.hasOwnProperty('xSpanValue')) {
                    obj.settings[targetRowSpan] = `span ${gridElement.xSpanValue}`;
                } else {
                    gridElement.hasOwnProperty('xStart') && gridElement.hasOwnProperty('xEnd') ? obj.settings[targetRowSpan] = `${gridElement.xStart} / ${gridElement.xEnd}` : obj.settings[targetRowSpan] = 'unset';
                }

                // 
                const targetColSpan = self.helpers.createTargetWithPseudo('_gridItemColumnSpan');
                if(gridElement.hasOwnProperty('ySpan') && gridElement.ySpan === 1 && gridElement.hasOwnProperty('ySpanValue')) {
                    obj.settings[targetColSpan] = `span ${gridElement.ySpanValue}`;
                } else {
                    gridElement.hasOwnProperty('yStart') && gridElement.hasOwnProperty('yEnd') ? obj.settings[targetColSpan] = `${gridElement.yStart} / ${gridElement.yEnd}` : obj.settings[targetColSpan] = 'unset';
                }
                const targetZIndex =  self.helpers.createTargetWithPseudo('_zIndex');
                if (gridElement.hasOwnProperty('zIndex')) obj.settings[targetZIndex] = gridElement.zIndex;
                if (gridElement.label !== obj.label) obj.label = gridElement.label
            })

        // Class
        }  else {
            const elements = self.gridUIStates.elements;
            const selector = self.gridUIStates.isClass ? `.${parent.name}` : `#${self.vueGlobalProp.$_getElementId()}`;
            let cssChild = '';
            let cssParent = '';
            let hasParentStyle = false;

            // Parent CSS
            if(self.gridUIStates.grid.col){
                hasParentStyle = true;
                cssParent += `grid-template-columns: ${Array.from(self.gridUIStates.grid.col).map(value => self.gridUIStates.grid.hasOwnProperty('minmax') &&  self.gridUIStates.grid.minmax === true ? `minmax(0,${value})` : value).join(' ')};`;
            }
            if(self.gridUIStates.grid.row){
                hasParentStyle = true;
                cssParent += `grid-template-rows: ${Array.from(self.gridUIStates.grid.row).map(value => self.gridUIStates.grid.hasOwnProperty('minmax') &&  self.gridUIStates.grid.minmax === true ? `minmax(0,${value})` : value).join(' ')};`;
            }

            if(self.gridUIStates.grid.autoFlow === true){
                hasParentStyle = true;
                cssParent += `grid-auto-flow: dense;`;
            } else {
                hasParentStyle = true;
                cssParent += `grid-auto-flow: unset;`;
            }

            // Children CSS
            for(const key of Object.keys(elements)){
                const element = elements[key];
                let hasStyle = false;
                let xCSS = '';
                let yCSS = '';
                let zIndex = '';

                // x
                if(element.hasOwnProperty('xSpan') && element.xSpan === 1 && element.hasOwnProperty('xSpanValue')) {
                    hasStyle = true;
                    xCSS = `grid-row: span ${element.xSpanValue};`;
                } else if(element.hasOwnProperty('xStart') && element.hasOwnProperty('xEnd')){
                    hasStyle = true;
                    xCSS = `grid-row: ${element.xStart} / ${element.xEnd};`
                }

                // y
                if(element.hasOwnProperty('ySpan') && element.ySpan === 1 && element.hasOwnProperty('ySpanValue')) {
                    hasStyle = true;
                    yCSS = `grid-column: span ${element.ySpanValue};`;
                } else if(element.hasOwnProperty('yStart') && element.hasOwnProperty('yEnd')){
                    hasStyle = true;
                    yCSS = `grid-column: ${element.yStart} / ${element.yEnd};`
                }

                // z-index
                if(element.hasOwnProperty('zIndex')){
                    hasStyle = true;
                    zIndex = `z-index: ${element.zIndex};`
                }
                if(hasStyle){
                    const label = self.gridUIStates.grid.repeat === true ? `nth-child(${self.gridUIStates.elements.length}n+${element.id})` : `nth-child(${element.id})`
                    cssChild += `${selector} > *:where(:${label}){${xCSS}${yCSS}${zIndex}}\n\n`;
                }
            }
            if(!hasParentStyle && cssChild === '') return self.vueGlobalProp.$_showMessage(`Abort: no styles to apply on ${activebp.label}`);;

            let css = `/** GRID BUILDER (autogenerated on ${new Date(Date.now()).toLocaleDateString()}) **/\n\n`;
            
            if(hasParentStyle){
                css += `${selector}{${cssParent}}\n\n`;
            }
            if(cssChild !== ''){
                css += `${selector}>*{grid-row:unset;grid-column:unset;}\n\n${cssChild}`;
            }

            css += `/** End of Grid Builder CSS **/`;


            const target = self.helpers.createTarget('_cssCustom');
            parent.settings.hasOwnProperty(target) && self.gridUIStates.grid.replaceCSS === true ? parent.settings[target] = self.gridBuilderRemovePreviousCSS(parent.settings[target]) : '';
            css = css_beautify(css, { indent_size: 2, space_in_empty_paren: false });
            if(!parent.settings.hasOwnProperty(target) || parent.settings[target] === ''){
                parent.settings[target] = css;
            } else {
                parent.settings[target] = `${self.helpers.removeTrailingNewlines(parent.settings[target])}\n\n${css}`;
            }
        }

        const activebp = self.vueState.breakpoints.find(el => el && el.key === self.vueState.breakpointActive);
        self.vueGlobalProp.$_showMessage(`Grid correctly applied on ${activebp.label}`);
    },
    // Box Shadow Generator
    setBoxShadowGenerator: function(){
        const self = this;
        setTimeout(()=> {
            const controls = document.querySelectorAll('[type="box-shadow"]');
            if(!controls || controls.length < 1) return;

            const settings = self.helpers.isClassActive() ? self.vueState.activeClass : self.vueState.activeElement.settings;
            
            controls.forEach(control => {
                // Copy
                const icon = control.querySelector('.brxc-box-shadow-generator');
                if (icon) icon.remove();
                const controlkey = control.getAttribute('controlkey');
                const target = self.helpers.createTargetWithPseudo(`${controlkey.replaceAll('_', '')}Generator`);
                const cls = settings.hasOwnProperty(target) ?  'brxc-box-shadow-generator bricks-control-preview active': 'brxc-box-shadow-generator bricks-control-preview';

                self.addIconToFields(
                    'div',
                    cls,
                    false,
                    'Box-Shadow Generator',
                    'top-right',
                    `ADMINBRXC.bsInit("${controlkey}");ADMINBRXC.openModal(false,"#brxcBoxShadowUIOverlay");`,
                    false,
                    '<span class="bricks-svg-wrapper"><i class="fas fa-layer-group"></i></span>',
                    control,
                    'child'
                );
                
            })
        }, 100);
    },
    bsSettings: undefined,
    bsTemp: {
        width: 400,
        height: 400,
        borderRadius: 10,
        layerAmount: 5,
        verticalDistance: 32,
        horizontalDistance: 0,
        blur: 24,
        spread: 0,
        shadowRgb: [3, 7, 18],
        //shadowStyle: "soft",
        boxColor: '#ffffff',
        boxBgColor: '#fafafa',
        opacity: 0.08,
        inset: '0',
    },
    bsStates: {
        selector: false,
        activeLayer: null,
        activeWindow: 'generator',
    },
    // Default
    bsRenderBoxShadows: function(obj) {
        const self = this;
        const boxShadows = [];

        const getX = (i) => {
            const startX = 0;
            const endX = obj.horizontalDistance;
            return startX + self.helpers.easeInQuad((i + 1) / obj.layerAmount) * (endX - startX);
        };

        const getY = (i) => {
            const startY = 0;
            const endY = obj.verticalDistance;
            return startY + self.helpers.easeInQuad((i + 1) / obj.layerAmount) * (endY - startY);
        };

        const getBlur = (i) => {
            const startBlur = 0;
            const endBlur = obj.blur;
            return (
            startBlur +
            self.helpers.easeInQuad((i + 1) / obj.layerAmount) * (endBlur - startBlur)
            );
        };

        // let getAlpha = (i) => obj.opacity;
        // if (obj.shadowStyle === "sharp") {
        //     getAlpha = (i) => {
        //     const increment = obj.opacity / obj.layerAmount;
        //     return obj.opacity - i * increment;
        //     };
        // } else if (obj.shadowStyle === "soft") {
        //     getAlpha = (i) => {
        //     const increment = obj.opacity / obj.layerAmount;
        //     return (i + 1) * increment;
        //     };
        // }

        const getAlpha = (i) => {
            const increment = obj.opacity / obj.layerAmount;
            return (i + 1) * increment;
        };


        for (let i = 0; i < obj.layerAmount; i++) {
            const x = getX(i).toFixed(0);
            const y = getY(i).toFixed(0);
            const blur = getBlur(i).toFixed(0);
            const spread = obj.spread;
            const rgb = obj.shadowRgb;
            const alpha = getAlpha(i).toFixed(2);
            const inset = obj.inset;

            boxShadows.push({ x, y, blur, spread, rgb, alpha, inset });
        }

        return boxShadows;
    },

    bsRenderCssShadows: function() {
        const self = this;
        const box = document.querySelector('#boxShadowUI__box');
        const boxShadows = typeof self.bsSettings === "undefined" ? self.bsRenderBoxShadows(self.bsTemp) : self.bsSettings.layers;
        const cssShadows = boxShadows.map(
            ({ x, y, blur, spread, rgb, alpha, inset }) =>
            `${inset === '1' ? 'inset ' : ''}${x}px ${y}px ${blur}px ${spread}px rgba(${Array.isArray(rgb) ? rgb.join(',') : rgb}, ${alpha})`
        );
        box.style.boxShadow = cssShadows.join(",\n  ");

    },
    bsRenderCssBox: function() {
        const self = this;
        const main = document.querySelector('#boxShadowUI__main');
        const box = main.querySelector('#boxShadowUI__box');
        const obj = typeof self.bsSettings === "undefined" ? self.bsTemp : self.bsSettings;

        box.style.width = `${obj.width}px`;
        box.style.height = `${obj.height}px`;
        box.style.borderRadius = `${obj.borderRadius}px`;
        box.style.backgroundColor = obj.boxColor;
        main.style.backgroundColor = obj.boxBgColor;
    },
    bsSetBoxInputs: function(){
        const self = this;
        const obj = typeof self.bsSettings === "undefined" ? self.bsTemp : self.bsSettings;
        const box = document.querySelector('#boxShadowUI__global #boxSettings');
        const arr = [
            {
                id: 'brxcBsWidth',
                title: 'Width',
                min: '0',
                max: '500',
                step: '1',
                property: 'width',
                value: obj.width,

            },
            {
                id: 'brxcBsHeight',
                title: 'Height',
                min: '0',
                max: '500',
                step: '1',
                property: 'height',
                value: obj.height,

            },
            {
                id: 'brxcBsWidthBorderRadius',
                title: 'Border-Radius',
                min: '0',
                max: '500',
                step: '1',
                property: 'borderRadius',
                value: obj.borderRadius,

            },
        ];
        let content = '';
        content += `<div class="brxc__title">Box</div>`;
        arr.forEach(el => {
            content += `
            <div class="brxc__field">
                <label for="${el.id}" class="brxc__label">${el.title}</label>
                <div class="brxc__range">
                    <input id="${el.id}" type="range" min="${el.min}" max="${el.max}" step="${el.step}" value="${el.value}" class="brxc-input__range" 
                        onchange="
                            ADMINBRXC.bsChangeBoxInput('${el.property}', parseInt(this.value));
                            document.querySelector('#${el.id}Value').value = this.value;
                            ADMINBRXC.bsRenderCssBox();
                        " 
                        oninput="
                            ADMINBRXC.bsChangeBoxInput('${el.property}', parseInt(this.value));
                            document.querySelector('#${el.id}Value').value = this.value;
                            ADMINBRXC.bsRenderCssBox();
                        "
                    />
                    <input id="${el.id}Value" type="number" min="${el.min}" max="${el.max}" step="${el.step}" value="${el.value}"
                        onchange="
                            ADMINBRXC.bsChangeBoxInput('${el.property}', parseInt(this.value));
                            document.querySelector('#${el.id}').value = this.value;
                            ADMINBRXC.bsRenderCssBox();
                        " 
                        oninput="
                            ADMINBRXC.bsChangeBoxInput('${el.property}', parseInt(this.value));
                            document.querySelector('#${el.id}').value = this.value;
                            ADMINBRXC.bsRenderCssBox();
                        "
                    />
                </div>
            </div>`;
        })
        content += `
        <div class="brxc__field">
            <label for="boxColor" class="brxc__label">Box Color</label>
            <div class="brxc__simple-color">
                <div id="boxColor" class="brxc-input__simple-color" data-initial="${obj.boxColor}" data-property="boxColor" style="background-color:${obj.boxColor}"></div>
                <input id="$boxColorValue" type="text" value="${obj.boxColor}"
                    oninput="
                        ADMINBRXC.bsChangeBoxInput('boxColor', this.value);
                        document.querySelector('#boxColor').style.backgroundColor = this.value;
                        ADMINBRXC.bsRenderCssBox();
                    "
                />
            </div>
        </div>
        <div class="brxc__field">
            <label for="boxBgColor" class="brxc__label">Background Color</label>
            <div class="brxc__simple-color">
                <div id="boxBgColor" class="brxc-input__simple-color" data-initial="${obj.boxBgColor}" data-property="boxBgColor" style="background-color:${obj.boxBgColor}"></div>
                <input id="$boxBgColorValue" type="text" value="${obj.boxBgColor}"
                    oninput="
                        ADMINBRXC.bsChangeBoxInput('boxBgColor', this.value);
                        document.querySelector('#boxBgColor').style.backgroundColor = this.value;
                        ADMINBRXC.bsRenderCssBox();
                    "
                />
            </div>
        </div>`;
        box.innerHTML = content;
        const simpleColors = document.querySelectorAll('.brxc-input__simple-color');
        simpleColors.forEach(el => {
            // Color Picker
            let picker = new ColorPicker(el, el.dataset.initialColor);
    
            el.addEventListener('colorChange', (event) => {
                const property = el.dataset.property;
                const obj = typeof self.bsSettings === "undefined" ? self.bsTemp : self.bsSettings;
                const color = event.detail.color.rgb;
                el.nextElementSibling.value = color.replace('rgba', 'rgb');
                obj[property] = color;
                self.bsRenderCssBox();
            })
        })
    },
    bsChangeBoxInput: function(prop, value){
        const self = this;
        const obj = typeof self.bsSettings === "undefined" ? self.bsTemp : self.bsSettings;
        obj[prop] = value;
        self.bsRenderCssBox();
    },
    bsSetTempInputs: function(){
        const self = this;
        const box = document.querySelector('#boxShadowUI__global #boxShadowSettings');
        const child = document.querySelector('#boxShadowUI__global #boxShadowUI__child');
        child.innerHTML = '';
        let content = '';
        const arr = [
            {
                id: 'brxcBsLayers',
                title: 'Number of Layers',
                min: '1',
                max: '10',
                step: '1',
                value: '5',
                property: 'layerAmount',

            },
            {
                id: 'brxcBsVerticalDistance',
                title: 'Vertical Distance',
                min: '-500',
                max: '500',
                step: '1',
                value: '32',
                property: 'verticalDistance',

            },
            {
                id: 'brxcBsHorizontalDistance',
                title: 'Horizontal Distance',
                min: '-500',
                max: '500',
                step: '1',
                value: '0',
                property: 'horizontalDistance',

            },
            {
                id: 'brxcBsOpacity',
                title: 'Opacity',
                min: '0.01',
                max: '1',
                step: '0.01',
                value: '0.08',
                property: 'opacity',

            },
            {
                id: 'brxcBsBlur',
                title: 'Blur',
                min: '0',
                max: '100',
                step: '1',
                value: '24',
                property: 'blur',

            },
            {
                id: 'brxcBsSpread',
                title: 'Spread',
                min: '0',
                max: '100',
                step: '1',
                value: '0',
                property: 'spread',

            },
        ];
        content += `<div class="brxc__title">Box-shadow</div>`;
        arr.forEach(el => {
            content += `
            <div class="brxc__field">
                <label for="${el.id}" class="brxc__label">${el.title}</label>
                <div class="brxc__range">
                    <input id="${el.id}" type="range" min="${el.min}" max="${el.max}" step="${el.step}" value="${el.value}" class="brxc-input__range"
                        onchange="
                            ADMINBRXC.bsTemp['${el.property}'] = this.value;
                            document.querySelector('#${el.id}Value').value = this.value;
                            ADMINBRXC.bsRenderCssShadows();ADMINBRXC.bsSaveSettings();;
                        " 
                        oninput="
                            ADMINBRXC.bsTemp['${el.property}'] = this.value;
                            document.querySelector('#${el.id}Value').value = this.value;
                            ADMINBRXC.bsRenderCssShadows();ADMINBRXC.bsSaveSettings();;
                        "
                    />
                    <input id="${el.id}Value" type="number" min="${el.min}" max="${el.max}" step="${el.step}" value="${el.value}"
                        onchange="
                            ADMINBRXC.bsTemp['${el.property}'] = this.value;
                            document.querySelector('#${el.id}').value = this.value;
                            ADMINBRXC.bsRenderCssShadows();ADMINBRXC.bsSaveSettings();;
                        " 
                        oninput="
                            ADMINBRXC.bsTemp['${el.property}'] = this.value;
                            document.querySelector('#${el.id}').value = this.value;
                            ADMINBRXC.bsRenderCssShadows();ADMINBRXC.bsSaveSettings();;
                        "
                    />
                </div>
            </div>`;
        })
        content += `<div class="brxc__field">
            <label for="shadowRgb" class="brxc__label">Shadow Color</label>
            <div class="brxc__simple-color">
                <div id="shadowRgb" class="brxc-input__simple-color" data-initial="rgb(3,7,18)" data-property="shadowRgb" style="background-color:rgb(3,7,18)"></div>
                <input id="$shadowRgbValue" type="text" value="rgb(3,7,18)"
                    oninput="
                        ADMINBRXC.bsTemp['shadowRgb'] = ADMINBRXC.helpers.rgbStringToArray(this.value);
                        document.querySelector('#shadowRgb').style.backgroundColor = this.value;
                        ADMINBRXC.bsRenderCssBox();
                    "
                />
            </div>
        </div>
        <div class="brxc__field">
            <label for="shadowInset" class="brxc__label">Inset</label>
            <div id="shadowInset" class="brxc__toggle-icon" onClick="ADMINBRXC.bsTemp.inset = '${self.bsTemp.inset === '1' ? '0' : '1'}';ADMINBRXC.bsSetTempInputs();ADMINBRXC.bsRenderCssShadows();ADMINBRXC.bsSaveSettings();;"><i class="fas fa-toggle-${self.bsTemp.inset === '1' ? 'on' : 'off'}"></i></div>
        </div>`;
        content += `<a class="brxc-overlay__action-btn primary m-top-24" style="width:100%;justify-content:center;" onClick="ADMINBRXC.bsGenerateLayers();">Generate Layers</button>`;
        box.innerHTML = content;
        const simpleColors = document.querySelectorAll('.brxc-input__simple-color');
        simpleColors.forEach(el => {
            // Color Picker
            let picker = new ColorPicker(el, el.dataset.initialColor);
    
            el.addEventListener('colorChange', (event) => {
                const property = el.dataset.property;
                const color = event.detail.color.rgb;
                el.nextElementSibling.value = color.replace('rgba', 'rgb');
                self.bsTemp[property] = self.helpers.rgbStringToArray(color);
                self.bsRenderCssShadows();
                self.bsSaveSettings();

            })
        })
    },
    bsSetInputs: function(){
        const self = this;
        const box = document.querySelector('#boxShadowUI__global #boxShadowSettings');
        let content = '<div class="brxc__title">Layers</div><div class="brxc-layer-btn-wrapper">';
        self.bsSettings.layers.forEach((layer,index) => {
            content += `<div class="brxc-layer-btn${index === self.bsStates.activeLayer ? ' active': ''}" data-order="${index}" onClick="ADMINBRXC.bsSetActiveLayer(this.dataset.order)"><div class="icon"><i class="fas fa-layer-group"></i></div></<span>Layer ${index + 1}</span></div>`
        })
        content += `<div class="brxc-layer-btn" onClick="ADMINBRXC.bsAddNewLayer();"><div class="icon"><i class="fas fa-plus"></i></div></<span>Add</span></div>`;
        content += '</div>'
        box.innerHTML = content;
    },
    bsSetActiveLayer: function(order){
        const self = this;
        self.bsStates.activeLayer = parseInt(order);
        self.bsSetBoxInputs();
        self.bsSetInputs();
        self.bsLoadLayer();
    },
    bsLoadLayer: function(){
        const self = this;
        const box = document.querySelector('#boxShadowUI__child');
        const layer = self.bsSettings.layers[self.bsStates.activeLayer];
        const layerColor = `rgb(${Array.isArray(layer.rgb) ? layer.rgb.join(',') : layer.rgb})`;
        const arr = [
            {
                id: 'brxcBsVerticalDistanceChild',
                title: 'Vertical Distance',
                min: '-500',
                max: '500',
                step: '1',
                property: 'y',

            },
            {
                id: 'brxcBsHorizontalDistanceChild',
                title: 'Horizontal Distance',
                min: '-500',
                max: '500',
                step: '1',
                property: 'x',

            },
            {
                id: 'brxcBsOpacityChild',
                title: 'Opacity',
                min: '0.01',
                max: '1',
                step: '0.01',
                property: 'alpha',

            },
            {
                id: 'brxcBsBlurChild',
                title: 'Blur',
                min: '0',
                max: '100',
                step: '1',
                property: 'blur',

            },
            {
                id: 'brxcBsSpreadChild',
                title: 'Spread',
                min: '0',
                max: '100',
                step: '1',
                property: 'spread',

            },
        ];
        let content = `
        <div class="brxc__title-wrapper">
            <div class="brxc__title">Layer ${self.bsStates.activeLayer + 1}</div>
            <div class="trash-icon" data-balloon="Delete Layer" data-balloon-pos="right" onclick="ADMINBRXC.setDeleteVariable(this,'ADMINBRXC.bsDeleteLayer()');">
                <span class="bricks-svg-wrapper">
                    <i class="ti-trash"></i>
                </span>
            </div>
        </div>`;
        arr.forEach(el => {
            content += `
            <div class="brxc__field">
                <label for="${el.id}" class="brxc__label">${el.title}</label>
                <div class="brxc__range">
                    <input id="${el.id}" type="range" min="${el.min}" max="${el.max}" step="${el.step}" value="${layer[el.property]}" class="brxc-input__range" 
                        onchange="
                            ADMINBRXC.bsSettings.layers[${self.bsStates.activeLayer}]['${el.property}'] = this.value;
                            document.querySelector('#${el.id}Value').value = this.value;
                            ADMINBRXC.bsRenderCssShadows();ADMINBRXC.bsSaveSettings();;
                        " 
                        oninput="
                            ADMINBRXC.bsSettings.layers[${self.bsStates.activeLayer}]['${el.property}'] = this.value;
                            document.querySelector('#${el.id}Value').value = this.value;
                            ADMINBRXC.bsRenderCssShadows();ADMINBRXC.bsSaveSettings();;
                        "
                    />
                    <input id="${el.id}Value" type="number" min="${el.min}" max="${el.max}" step="${el.step}" value="${layer[el.property]}"
                        onchange="
                            ADMINBRXC.bsSettings.layers[${self.bsStates.activeLayer}]['${el.property}'] = this.value;
                            document.querySelector('#${el.id}').value = this.value;
                            ADMINBRXC.bsRenderCssShadows();ADMINBRXC.bsSaveSettings();;
                        " 
                        oninput="
                            ADMINBRXC.bsSettings.layers[${self.bsStates.activeLayer}]['${el.property}'] = this.value;
                            document.querySelector('#${el.id}').value = this.value;
                            ADMINBRXC.bsRenderCssShadows();ADMINBRXC.bsSaveSettings();;
                        "
                    />
                </div>
            </div>`;
        })
        content += `<div class="brxc__field">
            <label for="shadowRgbChild" class="brxc__label">Shadow Color</label>
            <div class="brxc__simple-color">
                <div id="shadowRgbChild" class="brxc-input__simple-color" data-initial="${layerColor}" data-property="rgb" style="background-color:${layerColor}"></div>
                <input id="$shadowRgbChildValue" type="text" value="${layerColor}"
                    oninput="
                        ADMINBRXC.bsSettings.layers[ADMINBRXC.bsStates.activeLayer][this.previousElementSibling.dataset.property] = ADMINBRXC.helpers.rgbStringToArray(this.value);
                        document.querySelector('#shadowRgbChild').style.backgroundColor = this.value;
                        ADMINBRXC.bsRenderCssShadows();
                    "
                />
            </div>
        </div>
        <div class="brxc__field">
            <label for="shadowInsetChild" class="brxc__label">Inset</label>
            <div id="shadowInsetChild" class="brxc__toggle-icon" onClick="ADMINBRXC.bsSettings.layers[${self.bsStates.activeLayer}].inset = '${layer.inset === '1' ? '0' : '1'}';ADMINBRXC.bsLoadLayer();ADMINBRXC.bsRenderCssShadows();ADMINBRXC.bsSaveSettings();;"><i class="fas fa-toggle-${layer.inset === '1' ? 'on' : 'off'}"></i></div>
        </div>`;
        box.innerHTML = content;
        const simpleColors = document.querySelectorAll('.brxc-input__simple-color');
        simpleColors.forEach(el => {
            // Color Picker
            let picker = new ColorPicker(el, el.dataset.initialColor);
    
            el.addEventListener('colorChange', (event) => {
                const property = el.dataset.property;
                const color = event.detail.color.rgb;
                el.nextElementSibling.value = color.replace('rgba', 'rgb');
                self.bsSettings.layers[self.bsStates.activeLayer][property] = self.helpers.rgbStringToArray(color);
                self.bsRenderCssShadows();
                self.bsSaveSettings();

            })
        })

    },
    bsLoadDefault: function(){
        const self = this;
        self.bsRenderCssBox();
        self.bsRenderCssShadows();
        self.bsSetBoxInputs();
        self.bsSetTempInputs();
    },
    bsGenerateLayers: function(presetsArr = false){
        const self = this;
        const layers = self.bsRenderBoxShadows(self.bsTemp);
        self.bsSettings = {
            boxColor: self.bsTemp.boxColor,
            boxBgColor: self.bsTemp.boxBgColor,
            width: self.bsTemp.width,
            height: self.bsTemp.height,
            borderRadius: self.bsTemp.borderRadius,
            layers: layers,
        };
        if(Array.isArray(presetsArr)) self.bsSettings.layers = presetsArr;
        self.bsSaveSettings();
        self.bsStates.activeLayer = 0;
        self.bsSetActiveLayer(0);

        self.bsInit();
    },
    //
    bsLoad: function(){
        const self = this;
        self.bsRenderCssBox();
        self.bsRenderCssShadows();
        self.bsSetBoxInputs();
        self.bsSetInputs();
    },
    bsSaveSettings: function(){
        const self = this;
        const target = self.helpers.createTargetWithPseudo(`${self.bsStates.selector.replaceAll('_','')}Generator`);
        let settings;
        if(self.helpers.isClassActive()){
            const clsId = self.vueState.activeClass.id;
            const cls = Array.from(self.vueState.globalClasses).find(el => el && el.id === clsId);
            if(!cls) return self.vueGlobalProp.$_showMessage(`Abort! Class not found.`);
            settings = cls.settings;
        } else {
            settings = self.vueState.activeElement.settings;
        }
        settings[target] = self.bsSettings;
    },
    bsRemoveSettings: function(){
        const self = this;
        const target = self.helpers.createTargetWithPseudo(`${self.bsStates.selector.replaceAll('_','')}Generator`);
        let settings;
        if(self.helpers.isClassActive()){
            const clsId = self.vueState.activeClass.id;
            const cls = Array.from(self.vueState.globalClasses).find(el => el && el.id === clsId);
            if(!cls) return self.vueGlobalProp.$_showMessage(`Abort! Class not found.`);
            settings = cls.settings;
        } else {
            settings = self.vueState.activeElement.settings;
        }
        delete settings[target];
        self.vueState.rerenderControls = Date.now();
        self.vueGlobalProp.$_showMessage('Box-shadow settings correctly removed!');

    },
    // parseExample: function(){
    //     function parseShadowArray(shadowArrayString) {
    //         // first, parse the entire string as a JSON array
    //         const shadowStringArray = JSON.parse(shadowArrayString);
    //         // result array will contain arrays of objects
    //         const result = [];
    
    //         for (let i = 0; i < shadowStringArray.length; i++) {
    //             // parse each string separately and push into the result
    //             result.push(parseShadowString(shadowStringArray[i]));
    //         }
    
    //         return result;
    //     }
    //     function parseShadowString(shadowString) {
    //         // Regular expression to match the shadow string pattern
    //         const regex = /rgba\((\d+,\s*\d+,\s*\d+,\s*[\d.]+)\)\s*(-?\d+)px\s*(-?\d+)px\s*(-?\d+)px\s*(-?\d+)px/g
        
    //         // Array to store the parsed shadow objects
    //         const shadows = [];
        
    //         // Use matchAll to get all matches
    //         const matches = shadowString.matchAll(regex);
        
    //         // Iterate over matches and extract values
    //         for (const match of matches) {
    //             const [, rgb, x, y, blur, spread] = match;
        
    //             // Convert RGB string to array
    //             const rgbArray = rgb.split(',').map(Number);
        
    //             // Create shadow object
    //             const shadowObj = {
    //                 rgb: rgbArray.slice(0, -1).join(','),
    //                 alpha: parseFloat(rgb.split(',')[3]),
    //                 x: parseInt(x),
    //                 y: parseInt(y),
    //                 blur: parseInt(blur),
    //                 spread: parseInt(spread),
    //             };
        
    //             // Add to shadows array
    //             shadows.push(shadowObj);
    //         }
        
    //         return shadows;
    //     }
        
    //     // Example usage with the provided string
    //     const inputString = '["rgba(0, 0, 0, 0.45) 0px -25px 20px -20px","rgba(0, 0, 0, 0.45) 25px 0px 20px -20px","rgba(0, 0, 0, 0.45) 0px 25px 20px -20px","rgba(0, 0, 0, 0.45) -25px 0px 20px -20px","rgba(0, 0, 0, 0.45) 0px -25px 20px -20px, rgba(0, 0, 0, 0.45) 25px 0px 20px -20px","rgba(0, 0, 0, 0.45) 0px -25px 20px -20px, rgba(0, 0, 0, 0.45) 0px 25px 20px -20px","rgba(0, 0, 0, 0.45) 0px -25px 20px -20px, rgba(0, 0, 0, 0.45) -25px 0px 20px -20px","rgba(0, 0, 0, 0.45) 0px 25px 20px -20px, rgba(0, 0, 0, 0.45) 25px 0px 20px -20px","rgba(0, 0, 0, 0.45) 0px 25px 20px -20px, rgba(0, 0, 0, 0.45) -25px 0px 20px -20px","rgba(0, 0, 0, 0.45) 25px 0px 20px -20px, rgba(0, 0, 0, 0.45) -25px 0px 20px -20px","rgba(0, 0, 0, 0.45) 0px -25px 20px -20px, rgba(0, 0, 0, 0.45) 0px 25px 20px -20px, rgba(0, 0, 0, 0.45) 25px 0px 20px -20px","rgba(0, 0, 0, 0.45) 0px -25px 20px -20px, rgba(0, 0, 0, 0.45) 0px 25px 20px -20px, rgba(0, 0, 0, 0.45) -25px 0px 20px -20px","rgba(0, 0, 0, 0.45) 0px -25px 20px -20px, rgba(0, 0, 0, 0.45) 25px 0px 20px -20px, rgba(0, 0, 0, 0.45) 0px 25px 20px -20px, rgba(0, 0, 0, 0.45) -25px 0px 20px -20px","rgba(0, 0, 0, 0.12) 0px 1px 3px 0px, rgba(0, 0, 0, 0.24) 0px 1px 2px 0px","rgba(0, 0, 0, 0.16) 0px 3px 6px 0px, rgba(0, 0, 0, 0.23) 0px 3px 6px 0px","rgba(0, 0, 0, 0.19) 0px 10px 20px 0px, rgba(0, 0, 0, 0.23) 0px 6px 6px 0px","rgba(0, 0, 0, 0.25) 0px 14px 28px 0px, rgba(0, 0, 0, 0.22) 0px 10px 10px 0px","rgba(0, 0, 0, 0.3) 0px 19px 38px 0px, rgba(0, 0, 0, 0.22) 0px 15px 12px 0px","rgba(0, 0, 0, 0.4) 0px 29px 52px 0px, rgba(0, 0, 0, 0.2) 0px 25px 16px 0px","rgba(0, 0, 0, 0.5) 0px 45px 65px 0px, rgba(0, 0, 0, 0.16) 0px 35px 22px 0px","rgba(0, 0, 0, 0.6) 0px 60px 80px 0px, rgba(0, 0, 0, 0.14) 0px 45px 26px 0px","rgba(0, 0, 0, 0.12) 0px 1px 1px 0px, rgba(0, 0, 0, 0.12) 0px 2px 2px 0px","rgba(0, 0, 0, 0.12) 0px 1px 1px 0px, rgba(0, 0, 0, 0.12) 0px 2px 2px 0px, rgba(0, 0, 0, 0.12) 0px 4px 4px 0px, rgba(0, 0, 0, 0.12) 0px 8px 8px 0px, rgba(0, 0, 0, 0.12) 0px 16px 16px 0px","rgba(0, 0, 0, 0.15) 0px 1px 1px 0px, rgba(0, 0, 0, 0.15) 0px 2px 2px 0px, rgba(0, 0, 0, 0.15) 0px 4px 4px 0px, rgba(0, 0, 0, 0.15) 0px 8px 8px 0px","rgba(0, 0, 0, 0.11) 0px 1px 1px 0px, rgba(0, 0, 0, 0.11) 0px 2px 2px 0px, rgba(0, 0, 0, 0.11) 0px 4px 4px 0px, rgba(0, 0, 0, 0.11) 0px 8px 8px 0px, rgba(0, 0, 0, 0.11) 0px 16px 16px 0px, rgba(0, 0, 0, 0.11) 0px 32px 32px 0px","rgba(0, 0, 0, 0.08) 0px 1px 1px 0px, rgba(0, 0, 0, 0.12) 0px 2px 2px 0px, rgba(0, 0, 0, 0.16) 0px 4px 4px 0px, rgba(0, 0, 0, 0.2) 0px 8px 8px 0px","rgba(0, 0, 0, 0.07) 0px 1px 2px 0px, rgba(0, 0, 0, 0.07) 0px 2px 4px 0px, rgba(0, 0, 0, 0.07) 0px 4px 8px 0px, rgba(0, 0, 0, 0.07) 0px 8px 16px 0px, rgba(0, 0, 0, 0.07) 0px 16px 32px 0px, rgba(0, 0, 0, 0.07) 0px 32px 64px 0px","rgba(0, 0, 0, 0.11) 0px 1px 1px 0px, rgba(0, 0, 0, 0.11) 0px 2px 2px 0px, rgba(0, 0, 0, 0.11) 0px 4px 4px 0px, rgba(0, 0, 0, 0.11) 0px 6px 8px 0px, rgba(0, 0, 0, 0.11) 0px 8px 16px 0px","rgba(0, 0, 0, 0.09) 0px 2px 1px 0px, rgba(0, 0, 0, 0.09) 0px 4px 2px 0px, rgba(0, 0, 0, 0.09) 0px 8px 4px 0px, rgba(0, 0, 0, 0.09) 0px 16px 8px 0px, rgba(0, 0, 0, 0.09) 0px 32px 16px 0px","rgba(0, 0, 0, 0.05) 0px 1px 2px 0px","rgba(0, 0, 0, 0.1) 0px 1px 3px 0px, rgba(0, 0, 0, 0.1) 0px 1px 2px -1px","rgba(0, 0, 0, 0.1) 0px 10px 15px -3px, rgba(0, 0, 0, 0.1) 0px 4px 6px -4px","rgba(0, 0, 0, 0.1) 0px 20px 25px -5px, rgba(0, 0, 0, 0.1) 0px 8px 10px -6px","rgba(0, 0, 0, 0.25) 0px 25px 50px -12px","rgba(0, 0, 0, 0.05) 0px 2px 4px 0px inset","rgba(0, 0, 0, 0.13) 0px 2px 4px 0px, rgba(0, 0, 0, 0.11) 0px 1px 1px 0px","rgba(0, 0, 0, 0.13) 0px 3px 7px 0px, rgba(0, 0, 0, 0.11) 0px 1px 2px 0px","rgba(0, 0, 0, 0.13) 0px 7px 15px 0px, rgba(0, 0, 0, 0.11) 0px 1px 4px 0px","rgba(0, 0, 0, 0.22) 0px 26px 58px 0px, rgba(0, 0, 0, 0.18) 0px 5px 14px 0px","rgba(0, 0, 0, 0.075) 0px 2px 4px 0px","rgba(0, 0, 0, 0.15) 0px 8px 16px 0px","rgba(0, 0, 0, 0.176) 0px 16px 48px 0px","rgba(27, 31, 36, 0.04) 0px 1px 0px 0px","rgba(140, 149, 159, 0.15) 0px 3px 6px 0px","rgba(140, 149, 159, 0.2) 0px 8px 24px 0px","rgba(140, 149, 159, 0.3) 0px 12px 28px 0px","rgba(0, 0, 0, 0.45) 0px 20px 10px -20px inset","rgba(0, 0, 0, 0.45) -20px 0px 10px -20px inset","rgba(0, 0, 0, 0.45) 0px -20px 10px -20px inset","rgba(0, 0, 0, 0.45) 20px 0px 10px -20px inset","rgba(0, 0, 0, 0.45) 0px 20px 10px -20px inset, rgba(0, 0, 0, 0.45) -20px 0px 10px -20px inset","rgba(0, 0, 0, 0.45) 0px 20px 10px -20px inset, rgba(0, 0, 0, 0.45) 0px -20px 10px -20px inset","rgba(0, 0, 0, 0.45) 0px 20px 10px -20px inset, rgba(0, 0, 0, 0.45) 20px 0px 10px -20px inset","rgba(0, 0, 0, 0.45) 0px -20px 10px -20px inset, rgba(0, 0, 0, 0.45) -20px 0px 10px -20px inset","rgba(0, 0, 0, 0.45) 0px -20px 10px -20px inset, rgba(0, 0, 0, 0.45) 20px 0px 10px -20px inset","rgba(0, 0, 0, 0.45) -20px 0px 10px -20px inset, rgba(0, 0, 0, 0.45) 20px 0px 10px -20px inset","rgba(0, 0, 0, 0.45) 0px 20px 10px -20px inset, rgba(0, 0, 0, 0.45) 0px -20px 10px -20px inset, rgba(0, 0, 0, 0.45) -20px 0px 10px -20px inset","rgba(0, 0, 0, 0.45) 0px 20px 10px -20px inset, rgba(0, 0, 0, 0.45) 0px -20px 10px -20px inset, rgba(0, 0, 0, 0.45) 20px 0px 10px -20px inset","rgba(0, 0, 0, 0.45) 0px 0px 10px 0px inset","rgba(70, 70, 70, 0.12) -12px -8px 40px 0px inset","rgba(0, 0, 0, 0.17) 0px -23px 25px 0px inset, rgba(0, 0, 0, 0.15) 0px -36px 30px 0px inset, rgba(0, 0, 0, 0.1) 0px -79px 40px 0px inset, rgba(0, 0, 0, 0.06) 0px 2px 1px 0px, rgba(0, 0, 0, 0.09) 0px 4px 2px 0px, rgba(0, 0, 0, 0.09) 0px 8px 4px 0px, rgba(0, 0, 0, 0.09) 0px 16px 8px 0px","rgba(0, 0, 0, 0.25) 0px 0px 35px 5px inset, rgba(255, 255, 255, 0.9) 0px 2px 1px 1px inset, rgba(0, 0, 0, 0.25) 0px -2px 1px 0px inset","rgba(255, 255, 255, 0.2) -15px -15px 15px 0px, rgba(0, 0, 0, 0.1) 15px 15px 15px 0px, rgba(255, 255, 255, 0.2) -5px -5px 5px 0px inset, rgba(0, 0, 0, 0.1) 5px 5px 5px 0px inset","rgba(50, 50, 93, 0.25) 0px 50px 100px -20px, rgba(0, 0, 0, 0.3) 0px 30px 60px -30px, rgba(10, 37, 64, 0.35) 0px -2px 6px 0px inset","rgba(255, 255, 255, 0.1) 2px 2px 10px 0px inset, rgba(0, 0, 0, 0.2) -5px -8px 8px 0px inset","rgba(150, 170, 180, 0.5) 0px 7px 30px -10px","rgba(0, 0, 0, 0.15) 2px 2px 2px 0px","rgba(0, 0, 0, 0.2) 0px 2px 4px 0px","rgba(0, 0, 0, 0.2) 0px 20px 50px -10px","rgba(0, 0, 0, 0.15) 0px 80px 50px -30px","rgba(0, 0, 0, 0.15) 0px 25px 80px 0px","rgba(0, 0, 0, 0.5) 0px 25px 80px 0px","rgba(0, 0, 0, 0.2) 0px 15px 20px 0px","rgba(0, 0, 0, 0.2) 3px 3px 8px 0px inset","rgba(0, 0, 0, 0.05) 0px 0px 0px 5px","rgba(0, 0, 0, 1) 8px 8px 0px 0px","rgba(33, 33, 33, 1) -10px 10px 0px 0px, rgba(33, 33, 33, 0.7) -20px 20px 0px 0px, rgba(33, 33, 33, 0.4) -30px 30px 0px 0px, rgba(33, 33, 33, 0.1) -40px 40px 0px 0px","rgba(0, 0, 0, 0.45) 0px 0px 40px 0px","rgba(0, 0, 0, 0.25) 0px 1px 1px 0px, rgba(0, 0, 0, 0.25) 0px 2px 8px 0px, rgba(255, 255, 255, 0.1) 0px 0px 0px 1px inset","rgba(221, 221, 221, 1) 0px 10px 1px 0px, rgba(204, 204, 204, 1) 0px 10px 20px 0px","rgba(0, 0, 0, 0.4) 0px 2px 4px 0px, rgba(0, 0, 0, 0.3) 0px 7px 13px -3px, rgba(0, 0, 0, 0.2) 0px -3px 0px 0px inset","rgba(9, 30, 66, 0.25) 0px 1px 1px 0px, rgba(9, 30, 66, 0.13) 0px 0px 1px 1px","rgba(0, 0, 0, 0.05) 0px 0px 0px 1px, rgba(209, 213, 219, 1) 0px 0px 0px 1px inset","rgba(0, 0, 0, 0.16) 0px 1px 4px 0px, rgba(51, 51, 51, 1) 0px 0px 0px 3px","rgba(0, 0, 0, 0.02) 0px 1px 3px 0px, rgba(27, 31, 35, 0.15) 0px 0px 0px 1px","rgba(9, 30, 66, 0.25) 0px 4px 8px -2px, rgba(9, 30, 66, 0.08) 0px 0px 0px 1px","rgba(255, 255, 255, 0.1) 0px 1px 1px 0px inset, rgba(50, 50, 93, 0.25) 0px 50px 100px -20px, rgba(0, 0, 0, 0.3) 0px 30px 60px -30px","rgba(0, 0, 0, 0.22) 0px 1px 0px 0px, rgba(0, 0, 0, 0.22) 1px 0px 0px 0px, rgba(0, 0, 0, 0.22) 1px 2px 0px 0px, rgba(0, 0, 0, 0.22) 2px 1px 0px 0px, rgba(0, 0, 0, 0.22) 2px 3px 0px 0px, rgba(0, 0, 0, 0.22) 3px 2px 0px 0px, rgba(0, 0, 0, 0.22) 3px 4px 0px 0px, rgba(0, 0, 0, 0.22) 4px 3px 0px 0px, rgba(0, 0, 0, 0.22) 4px 5px 0px 0px, rgba(0, 0, 0, 0.22) 5px 4px 0px 0px, rgba(0, 0, 0, 0.22) 5px 6px 0px 0px, rgba(0, 0, 0, 0.22) 6px 5px 0px 0px, rgba(0, 0, 0, 0.22) 6px 7px 0px 0px, rgba(0, 0, 0, 0.22) 7px 6px 0px 0px, rgba(0, 0, 0, 0.22) 7px 8px 0px 0px, rgba(0, 0, 0, 0.22) 8px 7px 0px 0px","rgba(0, 0, 0, 0.24) 0px 3px 8px 0px","rgba(13, 38, 76, 0.19) 0px 9px 20px 0px","rgba(0, 0, 0, 0.2) 0px 12px 28px 0px, rgba(0, 0, 0, 0.1) 0px 2px 4px 0px, rgba(255, 255, 255, 0.05) 0px 0px 0px 1px inset","rgba(0, 0, 0, 0.04) 0px 3px 5px 0px","rgba(148, 0, 211, 1) 0px 0px 0px 3px, rgba(75, 0, 130, 1) 0px 0px 0px 6px, rgba(0, 0, 255, 1) 0px 0px 0px 9px, rgba(0, 255, 0, 1) 0px 0px 0px 12px, rgba(255, 255, 0, 1) 0px 0px 0px 15px, rgba(255, 127, 0, 1) 0px 0px 0px 18px, rgba(255, 0, 0, 1) 0px 0px 0px 21px","rgba(148, 0, 211, 1) 0px 0px 0px 2px, rgba(255, 255, 255, 1) 15px -15px 0px -2px, rgba(75, 0, 130, 1) 15px -15px 0px 0px, rgba(255, 255, 255, 1) 30px -30px 0px -2px, rgba(0, 0, 255, 1) 30px -30px 0px 0px, rgba(255, 255, 255, 1) 45px -45px 0px -2px, rgba(0, 255, 0, 1) 45px -45px 0px 0px, rgba(255, 255, 255, 1) 60px -60px 0px -2px, rgba(255, 255, 0, 1) 60px -60px 0px 0px, rgba(255, 255, 255, 1) 75px -75px 0px -2px, rgba(255, 127, 0, 1) 75px -75px 0px 0px, rgba(255, 255, 255, 1) 90px -90px 0px -2px, rgba(255, 0, 0, 1) 90px -90px 0px 0px","rgba(65, 117, 5, 1) 0px 5px 0px 0px, rgba(65, 117, 5, 0.6) 0px 10px 0px 0px, rgba(65, 117, 5, 0.4) 0px 15px 0px 0px, rgba(65, 117, 5, 0.2) 0px 20px 0px 0px, rgba(65, 117, 5, 0.1) 0px 25px 0px 0px","rgba(65, 117, 5, 1) 5px 5px 0px 0px, rgba(65, 117, 5, 0.6) 10px 10px 0px 0px, rgba(65, 117, 5, 0.4) 15px 15px 0px 0px, rgba(65, 117, 5, 0.2) 20px 20px 0px 0px, rgba(65, 117, 5, 0.1) 25px 25px 0px 0px","rgba(65, 117, 5,1) -5px 5px 0px 0px, rgba(65, 117, 5, 0.6) -10px 10px 0px 0px, rgba(65, 117, 5, 0.4) -15px 15px 0px 0px, rgba(65, 117, 5, 0.2) -20px 20px 0px 0px, rgba(65, 117, 5, 0.1) -25px 25px 0px 0px","rgba(218, 102, 123, 1) 0px 0px 0px 2px, rgba(218, 102, 123, 1) 8px 8px 0px 0px","rgba(255, 149, 5, 0.1) 0px 9px 30px 0px","rgba(255, 149, 5, 0.3) 0px 9px 30px 0px"]';
    //     const outputJson = parseShadowArray(inputString);
    //     console.log(JSON.stringify(outputJson));
    // },

    // removeInset: function(){
    //     const inputString = '["rgba(0, 0, 0, 0.45) 0px -25px 20px -20px","rgba(0, 0, 0, 0.45) 25px 0px 20px -20px","rgba(0, 0, 0, 0.45) 0px 25px 20px -20px","rgba(0, 0, 0, 0.45) -25px 0px 20px -20px","rgba(0, 0, 0, 0.45) 0px -25px 20px -20px, rgba(0, 0, 0, 0.45) 25px 0px 20px -20px","rgba(0, 0, 0, 0.45) 0px -25px 20px -20px, rgba(0, 0, 0, 0.45) 0px 25px 20px -20px","rgba(0, 0, 0, 0.45) 0px -25px 20px -20px, rgba(0, 0, 0, 0.45) -25px 0px 20px -20px","rgba(0, 0, 0, 0.45) 0px 25px 20px -20px, rgba(0, 0, 0, 0.45) 25px 0px 20px -20px","rgba(0, 0, 0, 0.45) 0px 25px 20px -20px, rgba(0, 0, 0, 0.45) -25px 0px 20px -20px","rgba(0, 0, 0, 0.45) 25px 0px 20px -20px, rgba(0, 0, 0, 0.45) -25px 0px 20px -20px","rgba(0, 0, 0, 0.45) 0px -25px 20px -20px, rgba(0, 0, 0, 0.45) 0px 25px 20px -20px, rgba(0, 0, 0, 0.45) 25px 0px 20px -20px","rgba(0, 0, 0, 0.45) 0px -25px 20px -20px, rgba(0, 0, 0, 0.45) 0px 25px 20px -20px, rgba(0, 0, 0, 0.45) -25px 0px 20px -20px","rgba(0, 0, 0, 0.45) 0px -25px 20px -20px, rgba(0, 0, 0, 0.45) 25px 0px 20px -20px, rgba(0, 0, 0, 0.45) 0px 25px 20px -20px, rgba(0, 0, 0, 0.45) -25px 0px 20px -20px","rgba(0, 0, 0, 0.12) 0px 1px 3px 0px, rgba(0, 0, 0, 0.24) 0px 1px 2px 0px","rgba(0, 0, 0, 0.16) 0px 3px 6px 0px, rgba(0, 0, 0, 0.23) 0px 3px 6px 0px","rgba(0, 0, 0, 0.19) 0px 10px 20px 0px, rgba(0, 0, 0, 0.23) 0px 6px 6px 0px","rgba(0, 0, 0, 0.25) 0px 14px 28px 0px, rgba(0, 0, 0, 0.22) 0px 10px 10px 0px","rgba(0, 0, 0, 0.3) 0px 19px 38px 0px, rgba(0, 0, 0, 0.22) 0px 15px 12px 0px","rgba(0, 0, 0, 0.4) 0px 29px 52px 0px, rgba(0, 0, 0, 0.2) 0px 25px 16px 0px","rgba(0, 0, 0, 0.5) 0px 45px 65px 0px, rgba(0, 0, 0, 0.16) 0px 35px 22px 0px","rgba(0, 0, 0, 0.6) 0px 60px 80px 0px, rgba(0, 0, 0, 0.14) 0px 45px 26px 0px","rgba(0, 0, 0, 0.12) 0px 1px 1px 0px, rgba(0, 0, 0, 0.12) 0px 2px 2px 0px","rgba(0, 0, 0, 0.12) 0px 1px 1px 0px, rgba(0, 0, 0, 0.12) 0px 2px 2px 0px, rgba(0, 0, 0, 0.12) 0px 4px 4px 0px, rgba(0, 0, 0, 0.12) 0px 8px 8px 0px, rgba(0, 0, 0, 0.12) 0px 16px 16px 0px","rgba(0, 0, 0, 0.15) 0px 1px 1px 0px, rgba(0, 0, 0, 0.15) 0px 2px 2px 0px, rgba(0, 0, 0, 0.15) 0px 4px 4px 0px, rgba(0, 0, 0, 0.15) 0px 8px 8px 0px","rgba(0, 0, 0, 0.11) 0px 1px 1px 0px, rgba(0, 0, 0, 0.11) 0px 2px 2px 0px, rgba(0, 0, 0, 0.11) 0px 4px 4px 0px, rgba(0, 0, 0, 0.11) 0px 8px 8px 0px, rgba(0, 0, 0, 0.11) 0px 16px 16px 0px, rgba(0, 0, 0, 0.11) 0px 32px 32px 0px","rgba(0, 0, 0, 0.08) 0px 1px 1px 0px, rgba(0, 0, 0, 0.12) 0px 2px 2px 0px, rgba(0, 0, 0, 0.16) 0px 4px 4px 0px, rgba(0, 0, 0, 0.2) 0px 8px 8px 0px","rgba(0, 0, 0, 0.07) 0px 1px 2px 0px, rgba(0, 0, 0, 0.07) 0px 2px 4px 0px, rgba(0, 0, 0, 0.07) 0px 4px 8px 0px, rgba(0, 0, 0, 0.07) 0px 8px 16px 0px, rgba(0, 0, 0, 0.07) 0px 16px 32px 0px, rgba(0, 0, 0, 0.07) 0px 32px 64px 0px","rgba(0, 0, 0, 0.11) 0px 1px 1px 0px, rgba(0, 0, 0, 0.11) 0px 2px 2px 0px, rgba(0, 0, 0, 0.11) 0px 4px 4px 0px, rgba(0, 0, 0, 0.11) 0px 6px 8px 0px, rgba(0, 0, 0, 0.11) 0px 8px 16px 0px","rgba(0, 0, 0, 0.09) 0px 2px 1px 0px, rgba(0, 0, 0, 0.09) 0px 4px 2px 0px, rgba(0, 0, 0, 0.09) 0px 8px 4px 0px, rgba(0, 0, 0, 0.09) 0px 16px 8px 0px, rgba(0, 0, 0, 0.09) 0px 32px 16px 0px","rgba(0, 0, 0, 0.05) 0px 1px 2px 0px","rgba(0, 0, 0, 0.1) 0px 1px 3px 0px, rgba(0, 0, 0, 0.1) 0px 1px 2px -1px","rgba(0, 0, 0, 0.1) 0px 10px 15px -3px, rgba(0, 0, 0, 0.1) 0px 4px 6px -4px","rgba(0, 0, 0, 0.1) 0px 20px 25px -5px, rgba(0, 0, 0, 0.1) 0px 8px 10px -6px","rgba(0, 0, 0, 0.25) 0px 25px 50px -12px","rgba(0, 0, 0, 0.05) 0px 2px 4px 0px inset","rgba(0, 0, 0, 0.13) 0px 2px 4px 0px, rgba(0, 0, 0, 0.11) 0px 1px 1px 0px","rgba(0, 0, 0, 0.13) 0px 3px 7px 0px, rgba(0, 0, 0, 0.11) 0px 1px 2px 0px","rgba(0, 0, 0, 0.13) 0px 7px 15px 0px, rgba(0, 0, 0, 0.11) 0px 1px 4px 0px","rgba(0, 0, 0, 0.22) 0px 26px 58px 0px, rgba(0, 0, 0, 0.18) 0px 5px 14px 0px","rgba(0, 0, 0, 0.075) 0px 2px 4px 0px","rgba(0, 0, 0, 0.15) 0px 8px 16px 0px","rgba(0, 0, 0, 0.176) 0px 16px 48px 0px","rgba(27, 31, 36, 0.04) 0px 1px 0px 0px","rgba(140, 149, 159, 0.15) 0px 3px 6px 0px","rgba(140, 149, 159, 0.2) 0px 8px 24px 0px","rgba(140, 149, 159, 0.3) 0px 12px 28px 0px","rgba(0, 0, 0, 0.45) 0px 20px 10px -20px inset","rgba(0, 0, 0, 0.45) -20px 0px 10px -20px inset","rgba(0, 0, 0, 0.45) 0px -20px 10px -20px inset","rgba(0, 0, 0, 0.45) 20px 0px 10px -20px inset","rgba(0, 0, 0, 0.45) 0px 20px 10px -20px inset, rgba(0, 0, 0, 0.45) -20px 0px 10px -20px inset","rgba(0, 0, 0, 0.45) 0px 20px 10px -20px inset, rgba(0, 0, 0, 0.45) 0px -20px 10px -20px inset","rgba(0, 0, 0, 0.45) 0px 20px 10px -20px inset, rgba(0, 0, 0, 0.45) 20px 0px 10px -20px inset","rgba(0, 0, 0, 0.45) 0px -20px 10px -20px inset, rgba(0, 0, 0, 0.45) -20px 0px 10px -20px inset","rgba(0, 0, 0, 0.45) 0px -20px 10px -20px inset, rgba(0, 0, 0, 0.45) 20px 0px 10px -20px inset","rgba(0, 0, 0, 0.45) -20px 0px 10px -20px inset, rgba(0, 0, 0, 0.45) 20px 0px 10px -20px inset","rgba(0, 0, 0, 0.45) 0px 20px 10px -20px inset, rgba(0, 0, 0, 0.45) 0px -20px 10px -20px inset, rgba(0, 0, 0, 0.45) -20px 0px 10px -20px inset","rgba(0, 0, 0, 0.45) 0px 20px 10px -20px inset, rgba(0, 0, 0, 0.45) 0px -20px 10px -20px inset, rgba(0, 0, 0, 0.45) 20px 0px 10px -20px inset","rgba(0, 0, 0, 0.45) 0px 0px 10px 0px inset","rgba(70, 70, 70, 0.12) -12px -8px 40px 0px inset","rgba(0, 0, 0, 0.17) 0px -23px 25px 0px inset, rgba(0, 0, 0, 0.15) 0px -36px 30px 0px inset, rgba(0, 0, 0, 0.1) 0px -79px 40px 0px inset, rgba(0, 0, 0, 0.06) 0px 2px 1px 0px, rgba(0, 0, 0, 0.09) 0px 4px 2px 0px, rgba(0, 0, 0, 0.09) 0px 8px 4px 0px, rgba(0, 0, 0, 0.09) 0px 16px 8px 0px","rgba(0, 0, 0, 0.25) 0px 0px 35px 5px inset, rgba(255, 255, 255, 0.9) 0px 2px 1px 1px inset, rgba(0, 0, 0, 0.25) 0px -2px 1px 0px inset","rgba(255, 255, 255, 0.2) -15px -15px 15px 0px, rgba(0, 0, 0, 0.1) 15px 15px 15px 0px, rgba(255, 255, 255, 0.2) -5px -5px 5px 0px inset, rgba(0, 0, 0, 0.1) 5px 5px 5px 0px inset","rgba(50, 50, 93, 0.25) 0px 50px 100px -20px, rgba(0, 0, 0, 0.3) 0px 30px 60px -30px, rgba(10, 37, 64, 0.35) 0px -2px 6px 0px inset","rgba(255, 255, 255, 0.1) 2px 2px 10px 0px inset, rgba(0, 0, 0, 0.2) -5px -8px 8px 0px inset","rgba(150, 170, 180, 0.5) 0px 7px 30px -10px","rgba(0, 0, 0, 0.15) 2px 2px 2px 0px","rgba(0, 0, 0, 0.2) 0px 2px 4px 0px","rgba(0, 0, 0, 0.2) 0px 20px 50px -10px","rgba(0, 0, 0, 0.15) 0px 80px 50px -30px","rgba(0, 0, 0, 0.15) 0px 25px 80px 0px","rgba(0, 0, 0, 0.5) 0px 25px 80px 0px","rgba(0, 0, 0, 0.2) 0px 15px 20px 0px","rgba(0, 0, 0, 0.2) 3px 3px 8px 0px inset","rgba(0, 0, 0, 0.05) 0px 0px 0px 5px","rgba(0, 0, 0, 1) 8px 8px 0px 0px","rgba(33, 33, 33, 1) -10px 10px 0px 0px, rgba(33, 33, 33, 0.7) -20px 20px 0px 0px, rgba(33, 33, 33, 0.4) -30px 30px 0px 0px, rgba(33, 33, 33, 0.1) -40px 40px 0px 0px","rgba(0, 0, 0, 0.45) 0px 0px 40px 0px","rgba(0, 0, 0, 0.25) 0px 1px 1px 0px, rgba(0, 0, 0, 0.25) 0px 2px 8px 0px, rgba(255, 255, 255, 0.1) 0px 0px 0px 1px inset","rgba(221, 221, 221, 1) 0px 10px 1px 0px, rgba(204, 204, 204, 1) 0px 10px 20px 0px","rgba(0, 0, 0, 0.4) 0px 2px 4px 0px, rgba(0, 0, 0, 0.3) 0px 7px 13px -3px, rgba(0, 0, 0, 0.2) 0px -3px 0px 0px inset","rgba(9, 30, 66, 0.25) 0px 1px 1px 0px, rgba(9, 30, 66, 0.13) 0px 0px 1px 1px","rgba(0, 0, 0, 0.05) 0px 0px 0px 1px, rgba(209, 213, 219, 1) 0px 0px 0px 1px inset","rgba(0, 0, 0, 0.16) 0px 1px 4px 0px, rgba(51, 51, 51, 1) 0px 0px 0px 3px","rgba(0, 0, 0, 0.02) 0px 1px 3px 0px, rgba(27, 31, 35, 0.15) 0px 0px 0px 1px","rgba(9, 30, 66, 0.25) 0px 4px 8px -2px, rgba(9, 30, 66, 0.08) 0px 0px 0px 1px","rgba(255, 255, 255, 0.1) 0px 1px 1px 0px inset, rgba(50, 50, 93, 0.25) 0px 50px 100px -20px, rgba(0, 0, 0, 0.3) 0px 30px 60px -30px","rgba(0, 0, 0, 0.22) 0px 1px 0px 0px, rgba(0, 0, 0, 0.22) 1px 0px 0px 0px, rgba(0, 0, 0, 0.22) 1px 2px 0px 0px, rgba(0, 0, 0, 0.22) 2px 1px 0px 0px, rgba(0, 0, 0, 0.22) 2px 3px 0px 0px, rgba(0, 0, 0, 0.22) 3px 2px 0px 0px, rgba(0, 0, 0, 0.22) 3px 4px 0px 0px, rgba(0, 0, 0, 0.22) 4px 3px 0px 0px, rgba(0, 0, 0, 0.22) 4px 5px 0px 0px, rgba(0, 0, 0, 0.22) 5px 4px 0px 0px, rgba(0, 0, 0, 0.22) 5px 6px 0px 0px, rgba(0, 0, 0, 0.22) 6px 5px 0px 0px, rgba(0, 0, 0, 0.22) 6px 7px 0px 0px, rgba(0, 0, 0, 0.22) 7px 6px 0px 0px, rgba(0, 0, 0, 0.22) 7px 8px 0px 0px, rgba(0, 0, 0, 0.22) 8px 7px 0px 0px","rgba(0, 0, 0, 0.24) 0px 3px 8px 0px","rgba(13, 38, 76, 0.19) 0px 9px 20px 0px","rgba(0, 0, 0, 0.2) 0px 12px 28px 0px, rgba(0, 0, 0, 0.1) 0px 2px 4px 0px, rgba(255, 255, 255, 0.05) 0px 0px 0px 1px inset","rgba(0, 0, 0, 0.04) 0px 3px 5px 0px","rgba(148, 0, 211, 1) 0px 0px 0px 3px, rgba(75, 0, 130, 1) 0px 0px 0px 6px, rgba(0, 0, 255, 1) 0px 0px 0px 9px, rgba(0, 255, 0, 1) 0px 0px 0px 12px, rgba(255, 255, 0, 1) 0px 0px 0px 15px, rgba(255, 127, 0, 1) 0px 0px 0px 18px, rgba(255, 0, 0, 1) 0px 0px 0px 21px","rgba(148, 0, 211, 1) 0px 0px 0px 2px, rgba(255, 255, 255, 1) 15px -15px 0px -2px, rgba(75, 0, 130, 1) 15px -15px 0px 0px, rgba(255, 255, 255, 1) 30px -30px 0px -2px, rgba(0, 0, 255, 1) 30px -30px 0px 0px, rgba(255, 255, 255, 1) 45px -45px 0px -2px, rgba(0, 255, 0, 1) 45px -45px 0px 0px, rgba(255, 255, 255, 1) 60px -60px 0px -2px, rgba(255, 255, 0, 1) 60px -60px 0px 0px, rgba(255, 255, 255, 1) 75px -75px 0px -2px, rgba(255, 127, 0, 1) 75px -75px 0px 0px, rgba(255, 255, 255, 1) 90px -90px 0px -2px, rgba(255, 0, 0, 1) 90px -90px 0px 0px","rgba(65, 117, 5, 1) 0px 5px 0px 0px, rgba(65, 117, 5, 0.6) 0px 10px 0px 0px, rgba(65, 117, 5, 0.4) 0px 15px 0px 0px, rgba(65, 117, 5, 0.2) 0px 20px 0px 0px, rgba(65, 117, 5, 0.1) 0px 25px 0px 0px","rgba(65, 117, 5, 1) 5px 5px 0px 0px, rgba(65, 117, 5, 0.6) 10px 10px 0px 0px, rgba(65, 117, 5, 0.4) 15px 15px 0px 0px, rgba(65, 117, 5, 0.2) 20px 20px 0px 0px, rgba(65, 117, 5, 0.1) 25px 25px 0px 0px","rgba(65, 117, 5,1) -5px 5px 0px 0px, rgba(65, 117, 5, 0.6) -10px 10px 0px 0px, rgba(65, 117, 5, 0.4) -15px 15px 0px 0px, rgba(65, 117, 5, 0.2) -20px 20px 0px 0px, rgba(65, 117, 5, 0.1) -25px 25px 0px 0px","rgba(218, 102, 123, 1) 0px 0px 0px 2px, rgba(218, 102, 123, 1) 8px 8px 0px 0px","rgba(255, 149, 5, 0.1) 0px 9px 30px 0px","rgba(255, 149, 5, 0.3) 0px 9px 30px 0px"]';
    //     const inputObj = '[[{"rgb":"0,0,0","alpha":0.45,"x":0,"y":-25,"blur":20,"spread":-20}],[{"rgb":"0,0,0","alpha":0.45,"x":25,"y":0,"blur":20,"spread":-20}],[{"rgb":"0,0,0","alpha":0.45,"x":0,"y":25,"blur":20,"spread":-20}],[{"rgb":"0,0,0","alpha":0.45,"x":-25,"y":0,"blur":20,"spread":-20}],[{"rgb":"0,0,0","alpha":0.45,"x":0,"y":-25,"blur":20,"spread":-20},{"rgb":"0,0,0","alpha":0.45,"x":25,"y":0,"blur":20,"spread":-20}],[{"rgb":"0,0,0","alpha":0.45,"x":0,"y":-25,"blur":20,"spread":-20},{"rgb":"0,0,0","alpha":0.45,"x":0,"y":25,"blur":20,"spread":-20}],[{"rgb":"0,0,0","alpha":0.45,"x":0,"y":-25,"blur":20,"spread":-20},{"rgb":"0,0,0","alpha":0.45,"x":-25,"y":0,"blur":20,"spread":-20}],[{"rgb":"0,0,0","alpha":0.45,"x":0,"y":25,"blur":20,"spread":-20},{"rgb":"0,0,0","alpha":0.45,"x":25,"y":0,"blur":20,"spread":-20}],[{"rgb":"0,0,0","alpha":0.45,"x":0,"y":25,"blur":20,"spread":-20},{"rgb":"0,0,0","alpha":0.45,"x":-25,"y":0,"blur":20,"spread":-20}],[{"rgb":"0,0,0","alpha":0.45,"x":25,"y":0,"blur":20,"spread":-20},{"rgb":"0,0,0","alpha":0.45,"x":-25,"y":0,"blur":20,"spread":-20}],[{"rgb":"0,0,0","alpha":0.45,"x":0,"y":-25,"blur":20,"spread":-20},{"rgb":"0,0,0","alpha":0.45,"x":0,"y":25,"blur":20,"spread":-20},{"rgb":"0,0,0","alpha":0.45,"x":25,"y":0,"blur":20,"spread":-20}],[{"rgb":"0,0,0","alpha":0.45,"x":0,"y":-25,"blur":20,"spread":-20},{"rgb":"0,0,0","alpha":0.45,"x":0,"y":25,"blur":20,"spread":-20},{"rgb":"0,0,0","alpha":0.45,"x":-25,"y":0,"blur":20,"spread":-20}],[{"rgb":"0,0,0","alpha":0.45,"x":0,"y":-25,"blur":20,"spread":-20},{"rgb":"0,0,0","alpha":0.45,"x":25,"y":0,"blur":20,"spread":-20},{"rgb":"0,0,0","alpha":0.45,"x":0,"y":25,"blur":20,"spread":-20},{"rgb":"0,0,0","alpha":0.45,"x":-25,"y":0,"blur":20,"spread":-20}],[{"rgb":"0,0,0","alpha":0.12,"x":0,"y":1,"blur":3,"spread":0},{"rgb":"0,0,0","alpha":0.24,"x":0,"y":1,"blur":2,"spread":0}],[{"rgb":"0,0,0","alpha":0.16,"x":0,"y":3,"blur":6,"spread":0},{"rgb":"0,0,0","alpha":0.23,"x":0,"y":3,"blur":6,"spread":0}],[{"rgb":"0,0,0","alpha":0.19,"x":0,"y":10,"blur":20,"spread":0},{"rgb":"0,0,0","alpha":0.23,"x":0,"y":6,"blur":6,"spread":0}],[{"rgb":"0,0,0","alpha":0.25,"x":0,"y":14,"blur":28,"spread":0},{"rgb":"0,0,0","alpha":0.22,"x":0,"y":10,"blur":10,"spread":0}],[{"rgb":"0,0,0","alpha":0.3,"x":0,"y":19,"blur":38,"spread":0},{"rgb":"0,0,0","alpha":0.22,"x":0,"y":15,"blur":12,"spread":0}],[{"rgb":"0,0,0","alpha":0.4,"x":0,"y":29,"blur":52,"spread":0},{"rgb":"0,0,0","alpha":0.2,"x":0,"y":25,"blur":16,"spread":0}],[{"rgb":"0,0,0","alpha":0.5,"x":0,"y":45,"blur":65,"spread":0},{"rgb":"0,0,0","alpha":0.16,"x":0,"y":35,"blur":22,"spread":0}],[{"rgb":"0,0,0","alpha":0.6,"x":0,"y":60,"blur":80,"spread":0},{"rgb":"0,0,0","alpha":0.14,"x":0,"y":45,"blur":26,"spread":0}],[{"rgb":"0,0,0","alpha":0.12,"x":0,"y":1,"blur":1,"spread":0},{"rgb":"0,0,0","alpha":0.12,"x":0,"y":2,"blur":2,"spread":0}],[{"rgb":"0,0,0","alpha":0.12,"x":0,"y":1,"blur":1,"spread":0},{"rgb":"0,0,0","alpha":0.12,"x":0,"y":2,"blur":2,"spread":0},{"rgb":"0,0,0","alpha":0.12,"x":0,"y":4,"blur":4,"spread":0},{"rgb":"0,0,0","alpha":0.12,"x":0,"y":8,"blur":8,"spread":0},{"rgb":"0,0,0","alpha":0.12,"x":0,"y":16,"blur":16,"spread":0}],[{"rgb":"0,0,0","alpha":0.15,"x":0,"y":1,"blur":1,"spread":0},{"rgb":"0,0,0","alpha":0.15,"x":0,"y":2,"blur":2,"spread":0},{"rgb":"0,0,0","alpha":0.15,"x":0,"y":4,"blur":4,"spread":0},{"rgb":"0,0,0","alpha":0.15,"x":0,"y":8,"blur":8,"spread":0}],[{"rgb":"0,0,0","alpha":0.11,"x":0,"y":1,"blur":1,"spread":0},{"rgb":"0,0,0","alpha":0.11,"x":0,"y":2,"blur":2,"spread":0},{"rgb":"0,0,0","alpha":0.11,"x":0,"y":4,"blur":4,"spread":0},{"rgb":"0,0,0","alpha":0.11,"x":0,"y":8,"blur":8,"spread":0},{"rgb":"0,0,0","alpha":0.11,"x":0,"y":16,"blur":16,"spread":0},{"rgb":"0,0,0","alpha":0.11,"x":0,"y":32,"blur":32,"spread":0}],[{"rgb":"0,0,0","alpha":0.08,"x":0,"y":1,"blur":1,"spread":0},{"rgb":"0,0,0","alpha":0.12,"x":0,"y":2,"blur":2,"spread":0},{"rgb":"0,0,0","alpha":0.16,"x":0,"y":4,"blur":4,"spread":0},{"rgb":"0,0,0","alpha":0.2,"x":0,"y":8,"blur":8,"spread":0}],[{"rgb":"0,0,0","alpha":0.07,"x":0,"y":1,"blur":2,"spread":0},{"rgb":"0,0,0","alpha":0.07,"x":0,"y":2,"blur":4,"spread":0},{"rgb":"0,0,0","alpha":0.07,"x":0,"y":4,"blur":8,"spread":0},{"rgb":"0,0,0","alpha":0.07,"x":0,"y":8,"blur":16,"spread":0},{"rgb":"0,0,0","alpha":0.07,"x":0,"y":16,"blur":32,"spread":0},{"rgb":"0,0,0","alpha":0.07,"x":0,"y":32,"blur":64,"spread":0}],[{"rgb":"0,0,0","alpha":0.11,"x":0,"y":1,"blur":1,"spread":0},{"rgb":"0,0,0","alpha":0.11,"x":0,"y":2,"blur":2,"spread":0},{"rgb":"0,0,0","alpha":0.11,"x":0,"y":4,"blur":4,"spread":0},{"rgb":"0,0,0","alpha":0.11,"x":0,"y":6,"blur":8,"spread":0},{"rgb":"0,0,0","alpha":0.11,"x":0,"y":8,"blur":16,"spread":0}],[{"rgb":"0,0,0","alpha":0.09,"x":0,"y":2,"blur":1,"spread":0},{"rgb":"0,0,0","alpha":0.09,"x":0,"y":4,"blur":2,"spread":0},{"rgb":"0,0,0","alpha":0.09,"x":0,"y":8,"blur":4,"spread":0},{"rgb":"0,0,0","alpha":0.09,"x":0,"y":16,"blur":8,"spread":0},{"rgb":"0,0,0","alpha":0.09,"x":0,"y":32,"blur":16,"spread":0}],[{"rgb":"0,0,0","alpha":0.05,"x":0,"y":1,"blur":2,"spread":0}],[{"rgb":"0,0,0","alpha":0.1,"x":0,"y":1,"blur":3,"spread":0},{"rgb":"0,0,0","alpha":0.1,"x":0,"y":1,"blur":2,"spread":-1}],[{"rgb":"0,0,0","alpha":0.1,"x":0,"y":10,"blur":15,"spread":-3},{"rgb":"0,0,0","alpha":0.1,"x":0,"y":4,"blur":6,"spread":-4}],[{"rgb":"0,0,0","alpha":0.1,"x":0,"y":20,"blur":25,"spread":-5},{"rgb":"0,0,0","alpha":0.1,"x":0,"y":8,"blur":10,"spread":-6}],[{"rgb":"0,0,0","alpha":0.25,"x":0,"y":25,"blur":50,"spread":-12}],[{"rgb":"0,0,0","alpha":0.05,"x":0,"y":2,"blur":4,"spread":0}],[{"rgb":"0,0,0","alpha":0.13,"x":0,"y":2,"blur":4,"spread":0},{"rgb":"0,0,0","alpha":0.11,"x":0,"y":1,"blur":1,"spread":0}],[{"rgb":"0,0,0","alpha":0.13,"x":0,"y":3,"blur":7,"spread":0},{"rgb":"0,0,0","alpha":0.11,"x":0,"y":1,"blur":2,"spread":0}],[{"rgb":"0,0,0","alpha":0.13,"x":0,"y":7,"blur":15,"spread":0},{"rgb":"0,0,0","alpha":0.11,"x":0,"y":1,"blur":4,"spread":0}],[{"rgb":"0,0,0","alpha":0.22,"x":0,"y":26,"blur":58,"spread":0},{"rgb":"0,0,0","alpha":0.18,"x":0,"y":5,"blur":14,"spread":0}],[{"rgb":"0,0,0","alpha":0.075,"x":0,"y":2,"blur":4,"spread":0}],[{"rgb":"0,0,0","alpha":0.15,"x":0,"y":8,"blur":16,"spread":0}],[{"rgb":"0,0,0","alpha":0.176,"x":0,"y":16,"blur":48,"spread":0}],[{"rgb":"27,31,36","alpha":0.04,"x":0,"y":1,"blur":0,"spread":0}],[{"rgb":"140,149,159","alpha":0.15,"x":0,"y":3,"blur":6,"spread":0}],[{"rgb":"140,149,159","alpha":0.2,"x":0,"y":8,"blur":24,"spread":0}],[{"rgb":"140,149,159","alpha":0.3,"x":0,"y":12,"blur":28,"spread":0}],[{"rgb":"0,0,0","alpha":0.45,"x":0,"y":20,"blur":10,"spread":-20}],[{"rgb":"0,0,0","alpha":0.45,"x":-20,"y":0,"blur":10,"spread":-20}],[{"rgb":"0,0,0","alpha":0.45,"x":0,"y":-20,"blur":10,"spread":-20}],[{"rgb":"0,0,0","alpha":0.45,"x":20,"y":0,"blur":10,"spread":-20}],[{"rgb":"0,0,0","alpha":0.45,"x":0,"y":20,"blur":10,"spread":-20},{"rgb":"0,0,0","alpha":0.45,"x":-20,"y":0,"blur":10,"spread":-20}],[{"rgb":"0,0,0","alpha":0.45,"x":0,"y":20,"blur":10,"spread":-20},{"rgb":"0,0,0","alpha":0.45,"x":0,"y":-20,"blur":10,"spread":-20}],[{"rgb":"0,0,0","alpha":0.45,"x":0,"y":20,"blur":10,"spread":-20},{"rgb":"0,0,0","alpha":0.45,"x":20,"y":0,"blur":10,"spread":-20}],[{"rgb":"0,0,0","alpha":0.45,"x":0,"y":-20,"blur":10,"spread":-20},{"rgb":"0,0,0","alpha":0.45,"x":-20,"y":0,"blur":10,"spread":-20}],[{"rgb":"0,0,0","alpha":0.45,"x":0,"y":-20,"blur":10,"spread":-20},{"rgb":"0,0,0","alpha":0.45,"x":20,"y":0,"blur":10,"spread":-20}],[{"rgb":"0,0,0","alpha":0.45,"x":-20,"y":0,"blur":10,"spread":-20},{"rgb":"0,0,0","alpha":0.45,"x":20,"y":0,"blur":10,"spread":-20}],[{"rgb":"0,0,0","alpha":0.45,"x":0,"y":20,"blur":10,"spread":-20},{"rgb":"0,0,0","alpha":0.45,"x":0,"y":-20,"blur":10,"spread":-20},{"rgb":"0,0,0","alpha":0.45,"x":-20,"y":0,"blur":10,"spread":-20}],[{"rgb":"0,0,0","alpha":0.45,"x":0,"y":20,"blur":10,"spread":-20},{"rgb":"0,0,0","alpha":0.45,"x":0,"y":-20,"blur":10,"spread":-20},{"rgb":"0,0,0","alpha":0.45,"x":20,"y":0,"blur":10,"spread":-20}],[{"rgb":"0,0,0","alpha":0.45,"x":0,"y":0,"blur":10,"spread":0}],[{"rgb":"70,70,70","alpha":0.12,"x":-12,"y":-8,"blur":40,"spread":0}],[{"rgb":"0,0,0","alpha":0.17,"x":0,"y":-23,"blur":25,"spread":0},{"rgb":"0,0,0","alpha":0.15,"x":0,"y":-36,"blur":30,"spread":0},{"rgb":"0,0,0","alpha":0.1,"x":0,"y":-79,"blur":40,"spread":0},{"rgb":"0,0,0","alpha":0.06,"x":0,"y":2,"blur":1,"spread":0},{"rgb":"0,0,0","alpha":0.09,"x":0,"y":4,"blur":2,"spread":0},{"rgb":"0,0,0","alpha":0.09,"x":0,"y":8,"blur":4,"spread":0},{"rgb":"0,0,0","alpha":0.09,"x":0,"y":16,"blur":8,"spread":0}],[{"rgb":"0,0,0","alpha":0.25,"x":0,"y":0,"blur":35,"spread":5},{"rgb":"255,255,255","alpha":0.9,"x":0,"y":2,"blur":1,"spread":1},{"rgb":"0,0,0","alpha":0.25,"x":0,"y":-2,"blur":1,"spread":0}],[{"rgb":"255,255,255","alpha":0.2,"x":-15,"y":-15,"blur":15,"spread":0},{"rgb":"0,0,0","alpha":0.1,"x":15,"y":15,"blur":15,"spread":0},{"rgb":"255,255,255","alpha":0.2,"x":-5,"y":-5,"blur":5,"spread":0},{"rgb":"0,0,0","alpha":0.1,"x":5,"y":5,"blur":5,"spread":0}],[{"rgb":"50,50,93","alpha":0.25,"x":0,"y":50,"blur":100,"spread":-20},{"rgb":"0,0,0","alpha":0.3,"x":0,"y":30,"blur":60,"spread":-30},{"rgb":"10,37,64","alpha":0.35,"x":0,"y":-2,"blur":6,"spread":0}],[{"rgb":"255,255,255","alpha":0.1,"x":2,"y":2,"blur":10,"spread":0},{"rgb":"0,0,0","alpha":0.2,"x":-5,"y":-8,"blur":8,"spread":0}],[{"rgb":"150,170,180","alpha":0.5,"x":0,"y":7,"blur":30,"spread":-10}],[{"rgb":"0,0,0","alpha":0.15,"x":2,"y":2,"blur":2,"spread":0}],[{"rgb":"0,0,0","alpha":0.2,"x":0,"y":2,"blur":4,"spread":0}],[{"rgb":"0,0,0","alpha":0.2,"x":0,"y":20,"blur":50,"spread":-10}],[{"rgb":"0,0,0","alpha":0.15,"x":0,"y":80,"blur":50,"spread":-30}],[{"rgb":"0,0,0","alpha":0.15,"x":0,"y":25,"blur":80,"spread":0}],[{"rgb":"0,0,0","alpha":0.5,"x":0,"y":25,"blur":80,"spread":0}],[{"rgb":"0,0,0","alpha":0.2,"x":0,"y":15,"blur":20,"spread":0}],[{"rgb":"0,0,0","alpha":0.2,"x":3,"y":3,"blur":8,"spread":0}],[{"rgb":"0,0,0","alpha":0.05,"x":0,"y":0,"blur":0,"spread":5}],[{"rgb":"0,0,0","alpha":1,"x":8,"y":8,"blur":0,"spread":0}],[{"rgb":"33,33,33","alpha":1,"x":-10,"y":10,"blur":0,"spread":0},{"rgb":"33,33,33","alpha":0.7,"x":-20,"y":20,"blur":0,"spread":0},{"rgb":"33,33,33","alpha":0.4,"x":-30,"y":30,"blur":0,"spread":0},{"rgb":"33,33,33","alpha":0.1,"x":-40,"y":40,"blur":0,"spread":0}],[{"rgb":"0,0,0","alpha":0.45,"x":0,"y":0,"blur":40,"spread":0}],[{"rgb":"0,0,0","alpha":0.25,"x":0,"y":1,"blur":1,"spread":0},{"rgb":"0,0,0","alpha":0.25,"x":0,"y":2,"blur":8,"spread":0},{"rgb":"255,255,255","alpha":0.1,"x":0,"y":0,"blur":0,"spread":1}],[{"rgb":"221,221,221","alpha":1,"x":0,"y":10,"blur":1,"spread":0},{"rgb":"204,204,204","alpha":1,"x":0,"y":10,"blur":20,"spread":0}],[{"rgb":"0,0,0","alpha":0.4,"x":0,"y":2,"blur":4,"spread":0},{"rgb":"0,0,0","alpha":0.3,"x":0,"y":7,"blur":13,"spread":-3},{"rgb":"0,0,0","alpha":0.2,"x":0,"y":-3,"blur":0,"spread":0}],[{"rgb":"9,30,66","alpha":0.25,"x":0,"y":1,"blur":1,"spread":0},{"rgb":"9,30,66","alpha":0.13,"x":0,"y":0,"blur":1,"spread":1}],[{"rgb":"0,0,0","alpha":0.05,"x":0,"y":0,"blur":0,"spread":1},{"rgb":"209,213,219","alpha":1,"x":0,"y":0,"blur":0,"spread":1}],[{"rgb":"0,0,0","alpha":0.16,"x":0,"y":1,"blur":4,"spread":0},{"rgb":"51,51,51","alpha":1,"x":0,"y":0,"blur":0,"spread":3}],[{"rgb":"0,0,0","alpha":0.02,"x":0,"y":1,"blur":3,"spread":0},{"rgb":"27,31,35","alpha":0.15,"x":0,"y":0,"blur":0,"spread":1}],[{"rgb":"9,30,66","alpha":0.25,"x":0,"y":4,"blur":8,"spread":-2},{"rgb":"9,30,66","alpha":0.08,"x":0,"y":0,"blur":0,"spread":1}],[{"rgb":"255,255,255","alpha":0.1,"x":0,"y":1,"blur":1,"spread":0},{"rgb":"50,50,93","alpha":0.25,"x":0,"y":50,"blur":100,"spread":-20},{"rgb":"0,0,0","alpha":0.3,"x":0,"y":30,"blur":60,"spread":-30}],[{"rgb":"0,0,0","alpha":0.22,"x":0,"y":1,"blur":0,"spread":0},{"rgb":"0,0,0","alpha":0.22,"x":1,"y":0,"blur":0,"spread":0},{"rgb":"0,0,0","alpha":0.22,"x":1,"y":2,"blur":0,"spread":0},{"rgb":"0,0,0","alpha":0.22,"x":2,"y":1,"blur":0,"spread":0},{"rgb":"0,0,0","alpha":0.22,"x":2,"y":3,"blur":0,"spread":0},{"rgb":"0,0,0","alpha":0.22,"x":3,"y":2,"blur":0,"spread":0},{"rgb":"0,0,0","alpha":0.22,"x":3,"y":4,"blur":0,"spread":0},{"rgb":"0,0,0","alpha":0.22,"x":4,"y":3,"blur":0,"spread":0},{"rgb":"0,0,0","alpha":0.22,"x":4,"y":5,"blur":0,"spread":0},{"rgb":"0,0,0","alpha":0.22,"x":5,"y":4,"blur":0,"spread":0},{"rgb":"0,0,0","alpha":0.22,"x":5,"y":6,"blur":0,"spread":0},{"rgb":"0,0,0","alpha":0.22,"x":6,"y":5,"blur":0,"spread":0},{"rgb":"0,0,0","alpha":0.22,"x":6,"y":7,"blur":0,"spread":0},{"rgb":"0,0,0","alpha":0.22,"x":7,"y":6,"blur":0,"spread":0},{"rgb":"0,0,0","alpha":0.22,"x":7,"y":8,"blur":0,"spread":0},{"rgb":"0,0,0","alpha":0.22,"x":8,"y":7,"blur":0,"spread":0}],[{"rgb":"0,0,0","alpha":0.24,"x":0,"y":3,"blur":8,"spread":0}],[{"rgb":"13,38,76","alpha":0.19,"x":0,"y":9,"blur":20,"spread":0}],[{"rgb":"0,0,0","alpha":0.2,"x":0,"y":12,"blur":28,"spread":0},{"rgb":"0,0,0","alpha":0.1,"x":0,"y":2,"blur":4,"spread":0},{"rgb":"255,255,255","alpha":0.05,"x":0,"y":0,"blur":0,"spread":1}],[{"rgb":"0,0,0","alpha":0.04,"x":0,"y":3,"blur":5,"spread":0}],[{"rgb":"148,0,211","alpha":1,"x":0,"y":0,"blur":0,"spread":3},{"rgb":"75,0,130","alpha":1,"x":0,"y":0,"blur":0,"spread":6},{"rgb":"0,0,255","alpha":1,"x":0,"y":0,"blur":0,"spread":9},{"rgb":"0,255,0","alpha":1,"x":0,"y":0,"blur":0,"spread":12},{"rgb":"255,255,0","alpha":1,"x":0,"y":0,"blur":0,"spread":15},{"rgb":"255,127,0","alpha":1,"x":0,"y":0,"blur":0,"spread":18},{"rgb":"255,0,0","alpha":1,"x":0,"y":0,"blur":0,"spread":21}],[{"rgb":"148,0,211","alpha":1,"x":0,"y":0,"blur":0,"spread":2},{"rgb":"255,255,255","alpha":1,"x":15,"y":-15,"blur":0,"spread":-2},{"rgb":"75,0,130","alpha":1,"x":15,"y":-15,"blur":0,"spread":0},{"rgb":"255,255,255","alpha":1,"x":30,"y":-30,"blur":0,"spread":-2},{"rgb":"0,0,255","alpha":1,"x":30,"y":-30,"blur":0,"spread":0},{"rgb":"255,255,255","alpha":1,"x":45,"y":-45,"blur":0,"spread":-2},{"rgb":"0,255,0","alpha":1,"x":45,"y":-45,"blur":0,"spread":0},{"rgb":"255,255,255","alpha":1,"x":60,"y":-60,"blur":0,"spread":-2},{"rgb":"255,255,0","alpha":1,"x":60,"y":-60,"blur":0,"spread":0},{"rgb":"255,255,255","alpha":1,"x":75,"y":-75,"blur":0,"spread":-2},{"rgb":"255,127,0","alpha":1,"x":75,"y":-75,"blur":0,"spread":0},{"rgb":"255,255,255","alpha":1,"x":90,"y":-90,"blur":0,"spread":-2},{"rgb":"255,0,0","alpha":1,"x":90,"y":-90,"blur":0,"spread":0}],[{"rgb":"65,117,5","alpha":1,"x":0,"y":5,"blur":0,"spread":0},{"rgb":"65,117,5","alpha":0.6,"x":0,"y":10,"blur":0,"spread":0},{"rgb":"65,117,5","alpha":0.4,"x":0,"y":15,"blur":0,"spread":0},{"rgb":"65,117,5","alpha":0.2,"x":0,"y":20,"blur":0,"spread":0},{"rgb":"65,117,5","alpha":0.1,"x":0,"y":25,"blur":0,"spread":0}],[{"rgb":"65,117,5","alpha":1,"x":5,"y":5,"blur":0,"spread":0},{"rgb":"65,117,5","alpha":0.6,"x":10,"y":10,"blur":0,"spread":0},{"rgb":"65,117,5","alpha":0.4,"x":15,"y":15,"blur":0,"spread":0},{"rgb":"65,117,5","alpha":0.2,"x":20,"y":20,"blur":0,"spread":0},{"rgb":"65,117,5","alpha":0.1,"x":25,"y":25,"blur":0,"spread":0}],[{"rgb":"65,117,5","alpha":1,"x":-5,"y":5,"blur":0,"spread":0},{"rgb":"65,117,5","alpha":0.6,"x":-10,"y":10,"blur":0,"spread":0},{"rgb":"65,117,5","alpha":0.4,"x":-15,"y":15,"blur":0,"spread":0},{"rgb":"65,117,5","alpha":0.2,"x":-20,"y":20,"blur":0,"spread":0},{"rgb":"65,117,5","alpha":0.1,"x":-25,"y":25,"blur":0,"spread":0}],[{"rgb":"218,102,123","alpha":1,"x":0,"y":0,"blur":0,"spread":2},{"rgb":"218,102,123","alpha":1,"x":8,"y":8,"blur":0,"spread":0}],[{"rgb":"255,149,5","alpha":0.1,"x":0,"y":9,"blur":30,"spread":0}],[{"rgb":"255,149,5","alpha":0.3,"x":0,"y":9,"blur":30,"spread":0}]]';

    //    // Parse the input string as JSON array
    //     const jsonArray = JSON.parse(inputString);
    //     const jsonArray2 = JSON.parse(inputObj);

    //     // Create new arrays to store filtered elements
    //     const filteredArray = [];
    //     const filteredArray2 = [];

    //     for (let i = 0; i < jsonArray.length; i++) {
    //         if (!jsonArray[i].includes("inset")) {
    //             filteredArray.push(jsonArray[i]);
    //             filteredArray2.push(jsonArray2[i]);
    //         }
    //     }

    //     // Convert the filtered arrays back to JSON strings
    //     const resultString = JSON.stringify(filteredArray);
    //     const resultString2 = JSON.stringify(filteredArray2);

    //     console.log(resultString);
    //     console.log(resultString2);
    // },




    bsApplyPresets(targetNode){
        const self = this;
        const boxShadow = targetNode.dataset.value;
        const target = self.helpers.createTargetWithPseudo(self.bsStates.selector);
        let settings;
        if(self.helpers.isClassActive()){
            const clsId = self.vueState.activeClass.id;
            const cls = Array.from(self.vueState.globalClasses).find(el => el && el.id === clsId);
            if(!cls) return self.vueGlobalProp.$_showMessage(`Abort! Class not found.`);
            settings = cls.settings;
        } else {
            settings = self.vueState.activeElement.settings;
        }
        settings[target] = {color:{raw: boxShadow}};

        self.vueState.rerenderControls = Date.now();
        self.vueGlobalProp.$_showMessage('Box-shadow correctly applied!');

    },
    bsApply: function(){
        const self = this;
        if(typeof self.bsSettings === "undefined") return self.vueGlobalProp.$_showMessage('Abort: create the layers first.');
        const target = self.helpers.createTargetWithPseudo(self.bsStates.selector);
        let settings;
        if(self.helpers.isClassActive()){
            const clsId = self.vueState.activeClass.id;
            const cls = Array.from(self.vueState.globalClasses).find(el => el && el.id === clsId);
            if(!cls) return self.vueGlobalProp.$_showMessage(`Abort! Class not found.`);
            settings = cls.settings;
        } else {
            settings = self.vueState.activeElement.settings;
        }

        const cssShadows = self.bsSettings.layers.map(
            ({ x, y, blur, spread, rgb, alpha, inset }) =>
            `${inset === '1' ? 'inset ' : ''}${x}px ${y}px ${blur}px ${spread}px rgba(${Array.isArray(rgb) ? rgb.join(',') : rgb}, ${alpha})`
        );
        const styles = cssShadows.join(",\n  ");
        settings[target] = {color:{raw: styles}};

        self.vueState.rerenderControls = Date.now();
        self.vueGlobalProp.$_showMessage('Box-shadow correctly applied!');
    },
    bsLoadBoxValues: function(){
         const self = this;
         const node = FRAMEBRXC.vueGlobalProp.$_getElementNode(self.vueState.activeElement);
         function getStyle(el, prop){
            return window.getComputedStyle(el).getPropertyValue(prop);
         }

         function getInheritedBackgroundColor(el) {
            var defaultStyle = getDefaultBackground()
            var backgroundColor = window.getComputedStyle(el).backgroundColor
            if (backgroundColor != defaultStyle) return backgroundColor
            if (!el.parentElement) return defaultStyle
            return getInheritedBackgroundColor(el.parentElement)
        }
        function getDefaultBackground() {
            var div = document.createElement("div")
            document.head.appendChild(div)
            var bg = window.getComputedStyle(div).backgroundColor
            document.head.removeChild(div)
            return bg
        }
        const width = node.getBoundingClientRect().width > 0 ? node.getBoundingClientRect().width : 400;
        const height = node.getBoundingClientRect().height > 0 ? node.getBoundingClientRect().height : 400;
        const ratio = width > height ? height / width : width / height;
        if(width > height){
            self.bsTemp.width = 400;
            self.bsTemp.height = Math.floor(self.bsTemp.width * ratio)
        } else {
            self.bsTemp.height = 400;
            self.bsTemp.width = Math.floor(self.bsTemp.height * ratio);
        }
        self.bsTemp.borderRadius = parseInt(getStyle(node, 'border-radius').replace('px',''));
        self.bsTemp.boxColor = getStyle(node, 'background-color');
        self.bsTemp.boxBgColor = getInheritedBackgroundColor(node.parentElement);
    },
    bsAddNewLayer: function(){
        const self = this;
        const length = self.bsSettings.layers.length;
        self.bsSettings.layers.push(JSON.parse(JSON.stringify(self.bsSettings.layers[length - 1])));
        self.bsStates.activeLayer = length;
        self.bsRenderCssShadows();
        self.bsSaveSettings();
        self.bsLoadLayer();
        self.bsSetInputs();
    },
    bsSetDeleteLayer: function(){
        const self = this;
        self.bsSettings.layers.splice(self.bsStates.activeLayer, 1);
        self.bsStates.activeLayer = self.bsSettings.layers.length - 1;
        self.bsRenderCssShadows();
        self.bsSaveSettings();
        self.bsLoadLayer();
        self.bsSetInputs();
    },
    bsDeleteLayer: function(){
        const self = this;
        self.bsSettings.layers.splice(self.bsStates.activeLayer, 1);
        self.bsStates.activeLayer = self.bsSettings.layers.length - 1;
        self.bsRenderCssShadows();
        self.bsSaveSettings();
        self.bsLoadLayer();
        self.bsSetInputs();
    },
    bsImportLayersFromPresets: function(target){
        const self = this;
        self.bsGenerateLayers(JSON.parse(target.dataset.obj));
        document.querySelector('#box-shadow-ui-generator').click();
    },
    bsInit: function(selector = false){
        const self = this;
        if(!self.helpers.isElementActive()) return;

        if(selector) self.bsStates.selector = selector
        // Get the target Key
        const target = self.helpers.createTargetWithPseudo(`${self.bsStates.selector.replaceAll('_', '')}Generator`);
        let settings;

        if(self.helpers.isClassActive()){
            const clsId = self.vueState.activeClass.id;
            const cls = Array.from(self.vueState.globalClasses).find(el => el && el.id === clsId);
            if(!cls) return self.vueGlobalProp.$_showMessage(`Abort! Class not found.`);
            settings = cls.settings;
        } else {
            settings = self.vueState.activeElement.settings;
        }

        // Conditional Load
        if(typeof settings[target] === "undefined"){
            self.bsSettings = undefined;
            self.bsLoadBoxValues();
            self.bsLoadDefault();
        } else {
            self.bsStates.activeLayer = 0;
            self.bsSettings = settings[target];
            self.bsLoad();
        }
    },
    stateInteractions: null,
    stateConditions: null,
    copyInteractions: function(key){
        const self = this;
        let settings;
        if(self.helpers.isClassActive() && key === "_interactions") {
            const clsId = self.vueState.activeClass.id;
            const cls = Array.from(self.vueState.globalClasses).find(el => el && el.id === clsId);
            if(!cls) return self.vueGlobalProp.$_showMessage(`Abort! Class not found.`);
            settings = cls.settings[key]
        } else {
            settings = self.vueState.activeElement.settings[key];
        } 
        if(key === "_interactions"){
            self.stateInteractions = JSON.stringify(settings);
        } else {
            self.stateConditions = JSON.stringify(settings);
        }
        const message = key === "_interactions" ? "Interactions" : "Conditions";
        self.vueGlobalProp.$_showMessage(`${message} successfully copied!`);
        self.vueState.rerenderControls = Date.now();
    },
    pasteInteractions: function(key){
        const self = this;
        const arr = key === "_interactions" ? JSON.parse(self.stateInteractions) : JSON.parse(self.stateConditions);

        // Interaction && Class
        if(self.helpers.isClassActive() && key === "_interactions"){
            const clsId = self.vueState.activeClass.id;
            const cls = Array.from(self.vueState.globalClasses).find(el => el && el.id === clsId);
            if(!cls) return self.vueGlobalProp.$_showMessage(`Abort! Class not found.`);

            if(!cls.settings.hasOwnProperty(key)) cls.settings[key] = [];
            arr.forEach(obj => {
                obj.id = self.vueGlobalProp.$_generateId();
                cls.settings[key].push(obj);
            })
        // Element
        } else {
            if(!self.vueState.activeElement.settings.hasOwnProperty(key)) self.vueState.activeElement.settings[key] = [];
            arr.forEach(obj => {
                if(key === "_conditions"){
                    obj.forEach(newObj => {
                        newObj.id = self.vueGlobalProp.$_generateId();
                    })
                } else if(key === "_interactions"){
                    obj.id = self.vueGlobalProp.$_generateId();
                }
                self.vueState.activeElement.settings[key].push(obj);
            })
        } 

        const message = key === "_interactions" ? "Interactions" : "Conditions";
        self.vueState.rerenderControls = Date.now();
        self.vueGlobalProp.$_showMessage(`${message} successfully pasted!`);
    },
    setCopyConditions: function(){
        const self = this;
        if(!self.helpers.isElementActive() || self.vueState.showConditions !== true ) return;
        
        let copyIcon = document.querySelector('.brxc-copy-conditions');
        if (copyIcon) copyIcon.remove();
        let pasteIcon = document.querySelector('.brxc-paste-conditions');
        if (pasteIcon) pasteIcon.remove();

        const actions = document.querySelector('#bricks-panel div[data-control="conditions"] .title-wrapper .actions');
        if(!actions) return;

        const settings = self.vueState.activeElement.settings;
    

        // Copy
        copyIcon = actions.querySelector('.brxc-copy-conditions');
        if (!copyIcon && settings && settings.hasOwnProperty('_conditions')) {
            self.addIconToFields(
                'div',
                'brxc-copy-conditions',
                false,
                'Copy Conditions',
                'top-right',
                'ADMINBRXC.copyInteractions("_conditions");',
                false,
                '<span class="bricks-svg-wrapper"><i class="fas fa-clipboard"></i></span>',
                actions,
                'child'
            );
        }

        // Paste
        pasteIcon = actions.querySelector('.brxc-paste-conditions');
        if (!pasteIcon && self.stateConditions !== null) {
            self.addIconToFields(
                'div',
                'brxc-paste-conditions',
                false,
                'Import Conditions',
                'top-right',
                'ADMINBRXC.pasteInteractions("_conditions");',
                false,
                '<span class="bricks-svg-wrapper"><i class="fas fa-file-import"></i></span>',
                actions,
                'child'
            );
        }
    },
    setCopyInteractions: function(){
        const self = this;
        
        if(!self.helpers.isElementActive() || self.vueState.showInteractions !== true ) return;
        
        let copyIcon = document.querySelector('.brxc-copy-interactions');
        if (copyIcon) copyIcon.remove();
        let pasteIcon = document.querySelector('.brxc-paste-interactions');
        if (pasteIcon) pasteIcon.remove();

        
        const actions = document.querySelector('#bricks-panel div[data-control="interactions"] .title-wrapper .actions');
        if(!actions) return;

        let settings;
        if(self.helpers.isClassActive()) {
            const clsId = self.vueState.activeClass.id;
            const cls = Array.from(self.vueState.globalClasses).find(el => el && el.id === clsId);
            if(!cls) return settings = false
            settings = cls.settings;
        } else {
            settings = self.vueState.activeElement.settings;
        }

        // Copy
        copyIcon = actions.querySelector('.brxc-copy-interactions');
        if (!copyIcon && settings && settings.hasOwnProperty('_interactions')) {
            self.addIconToFields(
                'div',
                'brxc-copy-interactions',
                false,
                'Copy Interactions',
                'top-right',
                'ADMINBRXC.copyInteractions("_interactions");',
                false,
                '<span class="bricks-svg-wrapper"><i class="fas fa-clipboard"></i></span>',
                actions,
                'child'
            );
        }

        // Paste
        pasteIcon = actions.querySelector('.brxc-paste-interactions');
        if (!pasteIcon && self.stateInteractions !== null) {
            self.addIconToFields(
                'div',
                'brxc-paste-interactions',
                false,
                'Import Interactions',
                'top-right',
                'ADMINBRXC.pasteInteractions("_interactions");',
                false,
                '<span class="bricks-svg-wrapper"><i class="fas fa-file-import"></i></span>',
                actions,
                'child'
            );
        }
    },
    basicTextStates:{
        tag: 'span',
        class: "false",
        classTxt: "",
        style: "false",
        styleTxt: "",
        url: "false",
        urlTxt: "",
    },
    setbasicTextOptions: function(){
        const self = this;
        if(!self.helpers.isElementActive() || !['text-basic','heading'].includes(self.vueState.activeElement.name) || self.vueState.activePanelTab !== "content") return;
        
        setTimeout(() => {
            const textarea = document.querySelector('#bricks-panel .controls [data-control=textarea]');
            if(!textarea) return;

            if(textarea.parentElement.querySelector('#brxc-text-basic-options')) return;
            const wrapper  = document.createElement("DIV");
            wrapper.id = "brxc-text-basic-options";
            textarea.parentElement.insertBefore(wrapper, textarea);
            self.basicTextOptions(wrapper);

        }, 50)
    },
    basicTextOptions: function(wrapper){
        const self = this;
        let content = "";
        const options = ['span','strong','a','mark','abbr','custom'];
        content += `
        <select value name="html-tag-wrapper" id="brxc-html-tag-wrapper" onchange="ADMINBRXC.basicTextStates.tag = this.value;ADMINBRXC.basicTextOptions(this.parentElement)">`
        options.forEach(option => {
            content += `<option value="${option}"${self.basicTextStates.tag === option ? ' selected' : ''}>${option}</option>`;
        })
        content += `</select>`;
        if(self.basicTextStates.tag === "custom"){
            content += `<input type="text" onblur="ADMINBRXC.basicTextStates.tag = this.value">`
        }
        // Url
        if(self.basicTextStates.tag === "a"){
            content += `<div class="${self.basicTextStates.url === "true" ? 'active' : ''}" data-balloon="${self.basicTextStates.url === "true" ? 'Remove' : 'Add'} URL tag" data-balloon-pos="top" onclick='ADMINBRXC.basicTextStates.url = "${self.basicTextStates.url === "true" ? "false" : "true"}";ADMINBRXC.basicTextOptions(this.parentElement)'>
                <span class="bricks-svg-wrapper">
                    <i class="fas fa-link"></i>
                </span>
            </div>`
        }

        content += `<div class="${self.basicTextStates.class === "true" ? 'active' : ''}" data-balloon="${self.basicTextStates.class === "true" ? 'Remove' : 'Add'} Class tag" data-balloon-pos="top" onclick='ADMINBRXC.basicTextStates.class = "${self.basicTextStates.class === "true" ? "false" : "true"}";ADMINBRXC.basicTextOptions(this.parentElement)'>
            <span class="bricks-svg-wrapper">
                <i class="fab fa-css3-alt"></i>
            </span>
        </div>
        <div class="${self.basicTextStates.style === "true" ? 'active' : ''}" data-balloon="${self.basicTextStates.style === "true" ? 'Remove' : 'Add'} Style tag" data-balloon-pos="top" onclick='ADMINBRXC.basicTextStates.style = "${self.basicTextStates.style === "true" ? "false" : "true"}";ADMINBRXC.basicTextOptions(this.parentElement)'>
            <span class="bricks-svg-wrapper">
                <i class="fas fa-broom"></i>
            </span>
        </div>
        <a class="" onclick="ADMINBRXC.unwrapSelectedContent(this.parentElement.parentElement.querySelector('textarea'))">Unwrap</a>
        <a class="" onclick="ADMINBRXC.wrapSelectedContent(this.parentElement.parentElement.querySelector('textarea'))">Wrap</a>
        `;
        if(Object.values(self.basicTextStates).some(value => value === "true")){
            content += `<div id="brxc-text-basic-options-extra">`
            if(self.basicTextStates.tag === "a" && self.basicTextStates.url === "true"){
                content += `<div class="brxc-field-wrapper">
                    <div class="icon-wrapper">
                        <span class="bricks-svg-wrapper">
                            <i class="fas fa-link"></i>
                        </span>
                    </div>
                    <input type="text" oninput="ADMINBRXC.basicTextStates.urlTxt = this.value" value="${self.basicTextStates.urlTxt}">
                </div>`
            }
            if(self.basicTextStates.class === "true"){
                content += `<div class="brxc-field-wrapper">
                    <div class="icon-wrapper">
                        <span class="bricks-svg-wrapper">
                            <i class="fab fa-css3-alt"></i>
                        </span>
                    </div>
                    <input type="text" id="brxcBasicTextClass" oninput="ADMINBRXC.basicTextStates.classTxt = this.value" value="${self.basicTextStates.classTxt}">
                </div>`
            }
            if(self.basicTextStates.style === "true"){
                content += `<div class="brxc-field-wrapper">
                    <div class="icon-wrapper">
                        <span class="bricks-svg-wrapper">
                            <i class="fas fa-broom"></i>
                        </span>
                    </div>
                    <input type="text" oninput="ADMINBRXC.basicTextStates.styleTxt = this.value" value="${self.basicTextStates.styleTxt}">
                </div>`
            }


            content += `</div>`;
        }
        wrapper.innerHTML = content;
        const classInput = wrapper.querySelector('#brxcBasicTextClass');
        if(!classInput) return;

        classInput.addEventListener('input', () => {
            self.autocomplete(classInput, self.globalClasses(), false);
        })


    },
    wrapSelectedContent: function(textarea){
        const self = this;
        const start = textarea.selectionStart;
        const end = textarea.selectionEnd;
        const selectedText = textarea.value.substring(start, end).trim();
        if(selectedText === '') return self.vueGlobalProp.$_showMessage('Abort: select the content to wrap first.')

        const beforeText = textarea.value.substring(0, start);
        const afterText = textarea.value.substring(end);
        const newText = `${beforeText}<${self.basicTextStates.tag}${self.basicTextStates.tag === "abbr" ? ` title=""` : ''}${self.basicTextStates.url === "true" ? ` href="${self.basicTextStates.urlTxt}" target="_blank"` : ''}${self.basicTextStates.class === "true" ? ` class="${self.basicTextStates.classTxt}"` : ''}${self.basicTextStates.style === "true" ? ` style="${self.basicTextStates.styleTxt}"` : ''}>${selectedText}</${self.basicTextStates.tag}>${afterText}`
        textarea.value = newText;
        const evt = new Event('input');
        textarea.dispatchEvent(evt);
    },
    unwrapSelectedContent: function(textarea){
        const self = this;
        const start = textarea.selectionStart;
        const end = textarea.selectionEnd;
        const selectedText = textarea.value.substring(start, end).trim();
        if(selectedText === '') return self.vueGlobalProp.$_showMessage('Abort: select the content to wrap first.')

        const beforeText = textarea.value.substring(0, start);
        const afterText = textarea.value.substring(end);
        const newText = `${beforeText}${selectedText.replaceAll(/<[^>]*>/g, '')}${afterText}`
        textarea.value = newText;
        const evt = new Event('input');
        textarea.dispatchEvent(evt);
    },
    queryManagerStates: {
        active: null,
        activeCategory: 'All',
        search: '',
    },
    queryListState: {
        show: false,
        search: '',
    },
    setQueryList: function(){
        const self = this;
        if(!self.helpers.isElementActive()) return;

        const x = document.querySelector('#bricks-builder-iframe').contentWindow;
        function openPopup() {
            window.addEventListener('click', windowClickListener);
            x.document.addEventListener('click', windowClickListener);
        }
        
        function closePopup() {
            self.queryListState.show = false;
            window.removeEventListener('click', windowClickListener);
            x.document.removeEventListener('click', windowClickListener);
            self.setQueryList();

        }
        
        function windowClickListener(event) {
            const popup = document.querySelector('.brxc-global-query-loops');
            if (popup && !popup.contains(event.target)) {
                closePopup();
            }
        }

        setTimeout(()=> {
            const control = document.querySelector('[data-controlkey="query"] [controlkey="query"]');
            if(!control) return;

            const icon = control.querySelector('.brxc-global-query-loops');
            if (icon) icon.remove();

            function isActive(){
                if(self.vueState.activeElement.settings.hasOwnProperty('query') 
                    && self.vueState.activeElement.settings.query.hasOwnProperty('objectType')
                    && typeof Array.from(self.globalSettings.generalCats.queryManager).find(el => el && el.id === self.vueState.activeElement.settings.query.objectType) !== "undefined") return true;
                return false;
            }

            let content = self.queryListContent();
            const classes = isActive() ? 'brxc-global-query-loops active' : 'brxc-global-query-loops';

            self.addIconToFields(
                'div',
                classes,
                false,
                'Global Query Loops',
                'top-right',
                '',
                false,
                content,
                control,
                'child'
            );

            openPopup();
                

        }, 5);
    },
    queryListContent: function(){
        const self = this;
        let content = '<div class="icon" onclick="ADMINBRXC.queryListState.show = true;ADMINBRXC.setQueryList();"><span class="bricks-svg-wrapper"><i class="fas fa-globe"></i></span></div>';
            if(self.queryListState.show === true){
                content += `<div class="bricks-control-popup bottom">
                                <div class="input-wrapper">
                                    <input type="text" autocomplete="off" spellcheck="false" placeholder="Search for a query loop ..." oninput="ADMINBRXC.queryListState.search = this.value;ADMINBRXC.updateQueryListLi();">
                                 </div>
                                 <div class="css-classes">
                                    <h6 class="title"><span>Global Query Loops</span></h6>
                                    <ul id="brxcQueryListLiCanvas">`;
                content += self.queryListLi();
                content +=         `</ul>
                                </div>
                            </div>`;
            }
        return content;
    },
    queryListLi: function(){
        const self = this;
        let content = '';
        function isActive(id){
            if(self.vueState.activeElement.settings.hasOwnProperty('query') 
                && self.vueState.activeElement.settings.query.hasOwnProperty('objectType')
                && self.vueState.activeElement.settings.query.objectType === id) return true;
            return false;
        }
        self.globalSettings.generalCats.queryManager.forEach(el => {
            content += `<li data-id="${el.id}" ${isActive(el.id) ? 'class="active" ': ''}onclick="ADMINBRXC.selectQueryList(this.dataset.id)"><span class="name">${el.title}</span></li>`
        })

        return content;
    },
    updateQueryListLi: function(){
        const self = this;
        const items = document.querySelectorAll('#brxcQueryListLiCanvas li');
        items.forEach(el => {
            self.queryListState.search === "" || el.textContent.includes(self.queryListState.search) ? el.removeAttribute('style') : el.style.display = "none";
        })
    },
    selectQueryList: function(id){
        const self = this;
        self.queryListState.show = false;
        self.vueState.activeElement.settings['query'] = {objectType: id};
        self.vueState.rerenderControls = Date.now();
    },
    setGenerateGlobalQuery: function(){
        const self = this;
        if(!self.helpers.isElementActive() || !self.vueState.activeElement.settings.hasOwnProperty('query')) return;


        setTimeout(()=> {
            const popup = document.querySelector('[data-controlkey="query"] [controlkey="query"] .bricks-control-popup');
            if(!popup) return;

            const btn = popup.querySelector('.brxc-generate-global-query');
            if (btn) btn.remove();

            if(!self.vueState.activeElement.settings.query.hasOwnProperty('objectType')
                || !( typeof self.vueState.activeElement.settings.query.objectType === "undefined"
                || self.vueState.activeElement.settings.query.objectType === "post"
                || self.vueState.activeElement.settings.query.objectType === "term"
                || self.vueState.activeElement.settings.query.objectType === "user"
            )) return;

            content = `<div class="control control-separator">
                            <div class="control-inner">
                                <label for="infinite_scroll_separator" data-balloon-break="">
                                    <span>Global Query Loop</span>
                                </label>
                                <div data-control="separator" type="separator"></div>
                            </div>
                        </div>
                        <a class="brxc-overlay__action-btn primary" style="width:100%;text-align:center;justify-content:center;margin-top:16px;" onclick="ADMINBRXC.generateGlobalQuery();">Generate Global Query Loop</a>`

            self.addIconToFields(
                'div',
                'brxc-generate-global-query',
                false,
                '',
                '',
                '',
                false,
                content,
                popup,
                'child'
            );
                

        }, 5);
    },
    generateGlobalQuery: function(){
        const self = this;
        const id = self.vueGlobalProp.$_generateId();
        self.getQueryVar(self.vueState.activeElement.settings, self.vueState.activeElement.id)
        .then(args => {
            // Check if args is populated before pushing the object
            if (args && args.trim() !== '') {
                const title = 'New Query Loop'
                self.globalSettings.generalCats.queryManager.push({
                    id: id,
                    title: title,
                    description: '',
                    category: '',
                    args: self.helpers.convertToPhpArrowFunction(args),
                });
                self.queryManagerStates.active = id;
                bricksData.controlOptions.queryTypes[id] = title;
                self.vueState.activeElement.settings['query'] = {objectType: id};
                self.vueState.rerenderControls = Date.now();
                self.queryManagerInit()
                self.openModal(false, "#brxcQueryManagerOverlay");
            } else {
                // Handle the case where args is not populated
                console.log('Args is not populated. Object not pushed.');
            }

        })
        .catch(error => {
            console.error('Error fetching args:', error);

            // Handle the error if needed
        });
    },
    queryManagerInit(){
        const self = this;
        if(self.queryManagerStates.active === null){
            if(self.globalSettings.generalCats.queryManager[0]) self.queryManagerStates.active = self.globalSettings.generalCats.queryManager[0].id;
        }
        self.queryManagerCat();
        self.queryManagerList();
        self.queryManagerPanel();
    },
    queryManagerCat: function(){
        const self = this;
        const listWrapper = document.querySelector('#brxcQueryCatListCanvas');
        if(!listWrapper || !Array.isArray(self.globalSettings.generalCats.queryManagerCats)) return;
        let cats = '<ul>';
        let categoryFound;
        let count;

        function isActive (cat) {
            if(self.helpers.getQueryCategoryIdByName(cat) === self.queryManagerStates.activeCategory) return true;
            return false;
        }

        // All
        count = self.globalSettings.generalCats.queryManager.length;
        cats += `<li class="${self.queryManagerStates.activeCategory === "All" ? 'active' : ''}"${self.queryManagerStates.activeCategory === "All" ? ' data-active="true"' : ''} data-id="All" data-balloon="All" data-balloon-pos="right" onClick="ADMINBRXC.queryManagerFilterCat(event)"><input type="text" value="All" readonly/><span class="count">${count}</span></li>`
        
        // Uncategorized
        count = Array.from(self.globalSettings.generalCats.queryManager).filter(el => el && (!el.category || el.category === "")).length;
        cats += `<li class="${self.queryManagerStates.activeCategory === "Uncategorized" ? 'active' : ''}"${self.queryManagerStates.activeCategory === "Uncategorized" ? ' data-active="true"' : ''} data-id="Uncategorized" data-balloon="Uncategorized" data-balloon-pos="right" onClick="ADMINBRXC.queryManagerFilterCat(event)"><input type="text" value="Uncategorized" readonly/><span class="count">${count}</span></li>`

        // Categories
        const sortedCats = Array.from(self.globalSettings.generalCats.queryManagerCats).filter(el => el && el.name).map(el => el && el.name).sort((a, b) => a.localeCompare(b, undefined, {sensitivity: 'base'}));
        sortedCats.forEach(cat => {
            categoryFound = self.helpers.getQueryCategoryObjByName(cat)
            count = Array.from(self.globalSettings.generalCats.queryManager).filter(el => el && el.hasOwnProperty('category') && categoryFound && categoryFound.id === el.category).length;
            cats += `<li class="${isActive(cat) ? 'active' : ''}"${isActive(cat) ? ' data-active="true"' : ''} data-id="${categoryFound.id}" data-balloon="${cat}" data-balloon-pos="right" ondragenter="this.classList.add('dragged')" ondragleave="this.classList.remove('dragged')" ondrop="event.preventDefault();ADMINBRXC.onDropCatList(this);" ondragover="event.preventDefault();" onClick="ADMINBRXC.queryManagerFilterCat(event)"><input type="text" data-initial="${cat}" value="${cat}"${categoryFound.id !== self.queryManagerStates.activeCategory ? ' readonly' : ''}/>${categoryFound.id === self.queryManagerStates.activeCategory ? `<div class="deleteCat" onClick="event.stopPropagation();ADMINBRXC.deleteQueryCategory('${self.queryManagerStates.activeCategory}')" data-balloon="Delete category" data-balloon-pos="top-right"><span class="bricks-svg-wrapper"><i class="ti-trash"></i></span></div>` : `<span class="count">${count}</span>`}</li>`
            
        })

        cats += '</ul><input type="text" id="addNewQueryCat" placeholder="+ New category" onkeyup="ADMINBRXC.addNewQueryCategory(event);" />';
        
        listWrapper.innerHTML = cats;

        // rename cat
        const input = listWrapper.querySelector('li.active input');
        if(input){
            input.addEventListener('keyup', (event) => {
                if(event.key !== "Enter") return;
                if(event.target.value === event.target.dataset.initial) return self.queryManagerCat();
                if(self.globalSettings.generalCats.queryManagerCats.includes(event.target.value)) return self.vueGlobalProp.$_showMessage(`ABORT: category "${event.target.value}" already exists`);
                const activeObj = self.helpers.getQueryCategoryObjById(self.queryManagerStates.activeCategory)
                activeObj.name = event.target.value;
                self.vueGlobalProp.$_showMessage(`Category correctly renamed to ${event.target.value}`)
                self.queryManagerCat();
                self.queryManagerPanel();
            })
        }
        
    },
    queryManagerFilterCat: function(event){
        const self = this;
        target = (event.target.dataset.id) ? event.target : event.target.parentElement;
        if(target.dataset.active === 'true') return;
        self.queryManagerStates.activeCategory = target.dataset.id;
        self.queryManagerCat();
        self.queryManagerList();
    },
    addNewQueryCategory: function(event){
        const self = this;

        if(event.key !== "Enter") return;

        const values = event.target.value.split(' ');
        if(values.length < 1) return;

        let hasChanges = false;
        let newId;

        values.forEach(name => {
            if(Array.from(self.globalSettings.generalCats.queryManagerCats).map(obj => obj && obj.name).includes(name)) {
                return self.vueGlobalProp.$_showMessage('ABORT: category already exists');
            } else {
                hasChanges = true;
                newId = self.vueGlobalProp.$_generateId();
                self.globalSettings.generalCats.queryManagerCats.push({
                    id: newId,
                    name: name,
                })

            }
        })
        if(hasChanges === true) {
            self.queryManagerStates.activeCategory = newId;
            self.queryManagerCat();
        };  
    },
    deleteQueryCategory: function(id){
        const self = this;
        const obj = self.helpers.getQueryCategoryObjById(id);
        if(!obj) return self.vueGlobalProp.$_showMessage('Abort: error finding the category');
        const catName = obj.name;
        const order = self.globalSettings.generalCats.queryManagerCats.indexOf(obj);
        self.globalSettings.generalCats.queryManagerCats.splice(order, 1);
        const loops = Array.from(self.globalSettings.generalCats.queryManager).filter(el => el && el.category === id);
        if(loops.length > 0){
            loops.forEach(el => {
                el.category = '';
            })
        }
        self.queryManagerStates.activeCategory = "All";
        self.vueGlobalProp.$_showMessage(`Category "${catName}" has been successfully deleted!`);
        self.queryManagerCat();
        self.queryManagerList();
        self.queryManagerPanel();

    },
    queryManagerList: function(){
        const self = this;
        const list = document.querySelector('#queryManagerUI__list');
        let arr = self.globalSettings.generalCats.queryManager;

        // Search
        if(self.queryManagerStates.search !== ''){
            arr = Array.from(arr).filter(el => el && el.title.includes(self.queryManagerStates.search))
        }

        // Uncategorized
        if(self.queryManagerStates.activeCategory === 'Uncategorized') {
            arr = Array.from(arr).filter(el => el && !el.category || el.category === '');
        // Category
        } else if(self.queryManagerStates.activeCategory !== 'All') {
            arr = Array.from(arr).filter(el => el && el.category === self.queryManagerStates.activeCategory);
        }

        // Content
        let content = '';
        arr.forEach(obj => {
            content += `<li class="${self.queryManagerStates.active === obj.id ? ' active' : ''}" data-id="${obj.id}" >
                            <span>${obj.title}</span>
                            <div class="actions">
                                <div class="duplicate" data-id="${obj.id}" data-balloon="Duplicate" data-balloon-pos="bottom-right" onclick="event.stopPropagation();ADMINBRXC.duplicateQueryLoop(this.dataset.id)"><i class="fas fas fa-clone"></i></div>
                                <div class="delete" data-id="${obj.id}" data-balloon="Delete" data-balloon-pos="bottom-right" onclick="event.stopPropagation();ADMINBRXC.setDeleteVariable(this, 'ADMINBRXC.deleteQueryLoop(this.dataset.id);')"><i class="ti-trash"></i></div>
                            </div> 
                        </li>`
        });
        //content += `<div class="brxc-class-manager__footer"><input type="text" id="addNewQueryLoop" placeholder="Add a new Query Loop" onkeyup="ADMINBRXC.addNewQueryLoop(event);"></div>`
        list.innerHTML = content;
        const li = list.querySelectorAll('li');
        if(li.length > 0){
            li.forEach(el => {
                el.addEventListener('click', () => {
                    self.queryManagerStates.active = el.dataset.id;
                    self.queryManagerInit();
                })
            })
        }
    },
    queryManagerPanel: function(){
        const self = this;
        const panel = document.querySelector('#queryManagerUI__panel');

        const activeObj = self.globalSettings.generalCats.queryManager.find(el => el.id ===self.queryManagerStates.active);
        if (!activeObj) return;
        let content = '';
        content += `<div class="brxc-query-manager__title-wrapper">
                        <div>
                            <label for="brxcQueryTitle" class="brxc-input__label has-tooltip"><span>Name</span><div data-balloon="To rename the current Query, just type the new name inside this input" data-balloon-pos="bottom-left" data-balloon-length="medium"><i class="fas fa-circle-question"></i></div></label>
                            <input type="text" id="brxcQueryTitle" placeholder="" value="${activeObj.title}" />
                        </div>
                        <div>
                            <label for="brxcQueryCategory" class="brxc-input__label has-tooltip"><span>Category</span><div data-balloon="To assign the query to a category, just type the new category name inside the input and press ENTER" data-balloon-pos="bottom-left" data-balloon-length="medium"><i class="fas fa-circle-question"></i></div></label>
                            <input type="text" id="brxcQueryCategory" placeholder="" value="${self.helpers.getQueryCategoryNameById(activeObj.category) ? self.helpers.getQueryCategoryNameById(activeObj.category) : ''}" />
                        </div>
                    </div>`;
        content += `<div>
                        <label class="brxc-input__label has-tooltip">
                            <span>Description</span>
                            <div data-balloon="Add here any text that will help you to quickly describe what this Query does" data-balloon-pos="bottom" data-balloon-length="medium"><i class="fas fa-circle-question"></i></div>
                        </label>
                        <textarea class="description">${activeObj.description}</textarea>
                    </div>`;
        content += `<div class="codemirror-wrapper">
                        <label class="brxc-input__label has-tooltip">
                            <span>Query vars</span>
                            <div data-balloon="Add here the query vars of the Query (in a correct Array). " data-balloon-pos="bottom" data-balloon-length="medium"><i class="fas fa-circle-question"></i></div>
                        </label>
                        <textarea class="codemirror">${activeObj.args}</textarea>
                    </div>`;
        panel.innerHTML = content;

        const title = panel.querySelector('#brxcQueryTitle');
        if (title){
            title.addEventListener('input', () => {
                activeObj.title = title.value;
                bricksData.controlOptions.queryTypes[activeObj.id] = title.value;
                self.queryManagerList();
            })
        }
        const category = panel.querySelector('#brxcQueryCategory');
        if (category){
            category.addEventListener('keydown', (e) => {
                self.autocomplete(category, self.globalSettings.generalCats.queryManagerCats.map(el => el && el.name), false);
                if(e.key !== "Enter") return;
                const maybeCat = Array.from(self.globalSettings.generalCats.queryManagerCats).find(el => el && el.name === category.value);
                if(maybeCat){
                    activeObj.category = maybeCat.id;
                    self.queryManagerStates.activeCategory = maybeCat.id;
                } else {
                    const newId = self.vueGlobalProp.$_generateId();
                    self.globalSettings.generalCats.queryManagerCats.push({
                        id: newId,
                        name: category.value,
                    })
                    activeObj.category = newId;
                    self.queryManagerStates.activeCategory = newId;
                    self.vueGlobalProp.$_showMessage(`New Category "${category.value}" has been created!`)
                }

                self.queryManagerCat();
                self.queryManagerList();
            })
        }
        const textarea = panel.querySelector('textarea.codemirror');
        if (textarea){
            const options = self.codeMirrorOptions(textarea);
            options.mode = "javascript";
            options.styleActiveLine = true;
            options.autoCloseBrackets = true;
            options.matchBrackets = true;
            options.selfContain = true;
            options.autofocus = true;
            options.search = { bottom: false };
            const MyCM = CodeMirror.fromTextArea(textarea, options);
            MyCM.on("change", function (cm) {
                activeObj.args = cm.getValue();
            });
        }
        const description = panel.querySelector('textarea.description');
        if (description){
            description.addEventListener('change', () => {
                activeObj.description = description.value;
            })
        }
    },
    resetQueryFilter: function(btn){
        const self = this;
        btn.previousElementSibling.previousElementSibling.value = '';
        self.queryManagerStates.search = '';
        self.queryManagerList();
    },
    addNewQueryLoop: function(event){
        const title = event.target.value;
        if(title === "" || event.key !== "Enter") return;
        const self = this;
        const id = self.vueGlobalProp.$_generateId()
        self.globalSettings.generalCats.queryManager.push({
            id: id,
            title: title,
            description: '',
            args: '',
            category: '',
        })
        bricksData.controlOptions.queryTypes[id] = title;
        self.queryManagerStates.active = id;
        event.target.value = '';
        self.queryManagerInit();
        self.vueGlobalProp.$_showMessage(`Query Loop "${title}" has been correctly created!`);
    },
    duplicateQueryLoop: function(id){
        const self = this;
        const activeObj = self.globalSettings.generalCats.queryManager.find(el => el.id === id);
        const newId = self.vueGlobalProp.$_generateId()
        self.globalSettings.generalCats.queryManager.push({
            ...activeObj, 
            id: newId, 
            title: `${activeObj.title} (Copy)`,
        })
        bricksData.controlOptions.queryTypes[newId] = `${activeObj.title} (Copy)`;
        self.queryManagerStates.active = id;
        self.queryManagerInit();
        self.vueGlobalProp.$_showMessage(`Query Loop "${`${activeObj.title} (Copy)`}" has been correctly duplicated!`);
    },
    deleteQueryLoop: function(id){
        const self = this;
        const activeObj = self.globalSettings.generalCats.queryManager.find(el => el.id === id);
        if(self.queryManagerStates.active === activeObj.id) self.queryManagerStates.active = null;
        self.globalSettings.generalCats.queryManager.splice(self.globalSettings.generalCats.queryManager.indexOf(activeObj), 1);
        delete bricksData.controlOptions.queryTypes[activeObj.id];
        self.queryManagerInit();
        self.vueGlobalProp.$_showMessage(`Query Loop "${`${activeObj.title}`}" has been correctly deleted!`);
    },
    getQueryVar: function (settings, element_id) {
        const self = this;
    
        // Return a Promise that resolves with the response data or rejects with an error
        return new Promise((resolve, reject) => {
            jQuery.ajax({
                url: openai_ajax_req.ajax_url,
                data: {
                    action: 'get_var_query_ajax_function',
                    settings: settings,
                    element_id: element_id,
                    nonce: openai_ajax_req.nonce
                },
                method: "POST",
                success: function (response) {
                    // Resolve the Promise with the response data
                    resolve(JSON.stringify(response.data));
                },
                error: function (data) {
                    // Reject the Promise with an error
                    reject('Something went wrong.');
                }
            });
        });
    },
    saveQueryManager: function(){
        const self = this;
        const obj = self.globalSettings.generalCats.queryManager;
        const obj2 = self.globalSettings.generalCats.queryManagerCats;
        jQuery.ajax({
            url: openai_ajax_req.ajax_url,
            data: {
                action: 'save_query_manager_ajax_function',
                query_manager: obj,
                query_manager_cats: obj2, 
                nonce: openai_ajax_req.nonce
            },
            method: "POST",
            success: function(data) {
                self.vueGlobalProp.$_showMessage('Query Loops settings saved successfully!')
            },
            error: function(data) {
                self.vueGlobalProp.$_showMessage('Something went wrong - Grid options not saved.')
            }
        });
    },
    saveTemplateStates: {
        img: null,
        title: null,
        bundle: null,
        tags: null,
    },
    getTemplateContent: function(id){
        const self = this;
        const templateType = self.helpers.getTemplateType();
        const allItems = self.vueState[templateType];
        const activeItem = Array.from(allItems).find(el => el && el.id === id)
        if(!activeItem) return false;

        let arr = [];
        function findChildren(id, isFirst){
            let obj = JSON.parse(JSON.stringify(self.vueGlobalProp.$_getElementObject(id)));
            if(isFirst) {
                obj = self.vueGlobalProp.$_clone(obj);
                obj.parent = 0;
            }
            arr.push(obj);
            if(obj.hasOwnProperty('children') && Array.isArray(obj.children) && obj.children.length > 0){
                obj.children.forEach(child => {
                    findChildren(child, false);
                })
            }
        }
        findChildren(id, true);
        return arr;
    },
    runIframeObserver: function(){
        const self = this;
        if(!self.helpers.isElementActive()) return;

        const iBody = document.querySelector('#bricks-builder-iframe').contentDocument.querySelector('.brx-body');
        if (!iBody) return;

        let mounted = iBody.querySelector('#bricks-preview-element-actions');
        if(mounted){
            self.setSavingTemplate(mounted);
        } else {
            const observer = new MutationObserver(function(mutations) {
                if(self.vueState.brxcRunningObserveriFrame === true) return;
                self.vueState.brxcRunningObserveriFrame = true;
                mounted = iBody.querySelector('#bricks-preview-element-actions');
                if(mounted) {
                    self.setSavingTemplate(mounted);
                    observer.disconnect();
                }
                
                setTimeout(() => self.vueState.brxcRunningObserveriFrame = false, 100)
            });
    
            observer.observe(iBody, { subtree: true, childList: true });
        }
    },
    setSavingTemplate: function(wrapper){
        const existing = document.querySelector('#bricks-builder-iframe').contentDocument.querySelector('#brxcSaveTemplate');
        if(existing) return;

        const a = document.createElement('li');
        a.id = `brxcSaveTemplate`;
        a.classList.add('action');
        a.setAttribute('onclick', 'window.parent.ADMINBRXC.openSaveTemplate();');
        a.innerHTML = ` <span class="bricks-svg-wrapper save-template">
                            <i class="fas fa-floppy-disk"></i>
                        </span>`
        wrapper.appendChild(a);

    },
    
    openSaveTemplate: function(){
        const self = this;
        const prom = new Promise((resolve, reject) => {
            const canvas = document.querySelector('#brxcSaveTemplateCanvas');
            self.saveTemplateStates.img = null;
            self.saveTemplateStates.title = null;
            self.saveTemplateStates.bundle = null;
            self.saveTemplateStates.tags = null;
            const existing = document.querySelector('#brxcExistingTemplate');
            if(existing) existing.remove();
            const a = document.createElement('div');
            a.id = 'brxcExistingTemplate';

            let content = "";
            content += `<div class="col-left">
                            <div>
                                <label class="has-tooltip"><span>Title (mandatory)</span><div data-balloon="Type here the template name that will be used on the backend Bricks -> Templates." data-balloon-pos="bottom" data-balloon-length="medium"><i class="fas fa-circle-question"></i></div></label>
                                <div class="brxc__text"><input type="text" name="brxcSaveTemplateTitle" id="brxcSaveTemplateTitle" placeholder="Type here the template title"></div>
                            </div>
                            <div>
                                <label class="has-tooltip"><span>Bundle (optional)</span><div data-balloon="Add the template to a Bundle." data-balloon-pos="bottom" data-balloon-length="medium"><i class="fas fa-circle-question"></i></div></label>
                                <div class="brxc__text"><input type="text" name="brxcSaveTemplateBundle" id="brxcSaveTemplateBundle"></div>
                            </div>
                            <div>
                                <label class="has-tooltip"><span>Tags (optional)</span><div data-balloon="Add a tag to the Template." data-balloon-pos="bottom" data-balloon-length="medium"><i class="fas fa-circle-question"></i></div></label>
                                <div class="brxc__text"><input type="text" name="brxcSaveTemplateTags" id="brxcSaveTemplateTags"></div>
                            </div>
                            <div>
                                <label class="has-tooltip"><span>Thumbnail</span><div data-balloon="The generated image will be automatically set as featured image to your Template post." data-balloon-pos="bottom" data-balloon-length="medium"><i class="fas fa-circle-question"></i></div></label>
                                <div id="brxcSaveTemplateImage">
                                    <div id="brxcSaveTemplateImageTemp"><div class="bricks-logo-animated"><div class="cube top-left"></div><div class="cube top-right"></div><div class="cube bottom-left"></div><div class="cube bottom-right"></div></div></div>
                                </div>
                            </div>
                        </div>
                        <div class="col-right">
                            <label class="has-tooltip"><span>Saved Structure</span><div data-balloon="Here is a preview of the elements that will be saved inside your templates." data-balloon-pos="bottom" data-balloon-length="medium"><i class="fas fa-circle-question"></i></div></label>
                            ${self.saveTemplatePreview()}
                        </div>
            `;
            a.innerHTML = content;
            canvas.appendChild(a);
            self.openModal(false,"#brxcSaveTemplateOverlay");
            
            const titleInput = document.querySelector('#brxcSaveTemplateTitle');
            titleInput.addEventListener('input', () => {
                self.saveTemplateStates.title = titleInput.value;
            })
            const bundleInput = document.querySelector('#brxcSaveTemplateBundle');
            bundleInput.addEventListener('input', () => {
                self.autocomplete(bundleInput, Object.values(bricksData.template.bundles), false);
                self.saveTemplateStates.bundle = bundleInput.value;
            })
            const tagsInput = document.querySelector('#brxcSaveTemplateTags');
            tagsInput.addEventListener('input', () => {
                self.autocomplete(tagsInput, Object.values(bricksData.template.tags), false);
                self.saveTemplateStates.tags = tagsInput.value;
            })
            resolve();

        });
        prom.then(() => {
            setTimeout(() => {
                //generate image
                const imgWrapper = document.querySelector('#brxcSaveTemplateImage');
                if(!imgWrapper) return;

                const activeEl = FRAMEBRXC.vueGlobalProp.$_getElementNode(self.vueState.activeElement)
                const ratio = 800 / activeEl.getBoundingClientRect().width
                html2canvas(activeEl, {
                    allowTaint : true,
                    logging: true,
                    profile: true,
                    useCORS: true,
                    scale: ratio
                }).then(function(canvas) {
                    const tempImg = document.querySelector('#brxcSaveTemplateImageTemp');
                    if(tempImg) tempImg.remove();
                    imgWrapper.appendChild(canvas);
                    self.saveTemplateStates.img = JSON.stringify(canvas.toDataURL('image/png'));
                })
            }, 100);
        })

    },
    saveTemplatePreview: function(){
        const self = this

        // active element
        const el = self.vueState.activeElement;
        if (!el) return;

        function addElement(level, obj){
            return `<li style="--margin:${level}"><div class="icon"><i class="${bricksData.elements[obj.name].icon}"></i></div><span>${obj.hasOwnProperty('label') ? obj.label : bricksData.elements[obj.name].label}</span></li>`;
        }
        let dynamic = '';
        function checkchildren( element, level){
            if (!element.hasOwnProperty('children') || !Array.isArray(element.children) || element.children.length < 1) return;
            level++;
            element.children.forEach(id => {
                const settings = self.vueGlobalProp.$_getElementObject(id);
                dynamic += addElement(level, settings);
                checkchildren(settings, level);
            })
        }

        let content = '<ul>';
        content += addElement(0, self.vueGlobalProp.$_getElementObject(el.id));
        checkchildren(el, 0);
        content += dynamic;
        content += '</ul>';

        return content

    },
    saveTemplate: function(){
        const self = this;
        const dataTemplate = {};
        dataTemplate["title"] = self.saveTemplateStates.title;
        if(!dataTemplate["title"] || dataTemplate["title"] === "") return self.vueGlobalProp.$_showMessage('Abort: Set a title (mandatory)!');
        if(self.saveTemplateStates.bundle !== null && self.saveTemplateStates.bundle !== "") dataTemplate["bundle"] = self.saveTemplateStates.bundle
        if(self.saveTemplateStates.tags !== null && self.saveTemplateStates.tags !== "")dataTemplate["tags"] = self.saveTemplateStates.tags
        dataTemplate["type"] = "section";
        dataTemplate["templateType"] = self.helpers.getTemplateType();
        dataTemplate["elements"] = self.getTemplateContent(self.vueState.activeElement.id);
        dataTemplate["img"] = JSON.parse(self.saveTemplateStates.img);

        if(!dataTemplate["elements"]) return self.vueGlobalProp.$_showMessage('Abort: no content found!');
        
        jQuery.ajax({
            url: openai_ajax_req.ajax_url,
            data: {
                action: 'save_section_template_ajax_function',
                data_template: JSON.stringify(dataTemplate),
                nonce: openai_ajax_req.nonce
            },
            method: "POST",
            success: function(data) {
                self.vueGlobalProp.$_showMessage('Template created successfully!')
            },
            error: function(data) {
                self.vueGlobalProp.$_showMessage('Something went wrong - Template not saved.')
            }
        });
        
    },
    setClassShortcuts: function(){
        const self = this;

        if(!self.helpers.isElementActive()) return;

        setTimeout(() => {
            // Const
            const activeClasses = document.querySelector('#bricks-panel-element-classes .active-class');
            const x = document.querySelector('#bricks-builder-iframe').contentWindow;
            if(!activeClasses) return;

            const copyToClipboardIcon = activeClasses.querySelector('.copy-class-icon'); // Copy to clipboard icon
            const cloneClassIcon = activeClasses.querySelector('.clone-class-icon'); // Clone Class Icon
            const importSylesicon = activeClasses.querySelector('.copy-class-to-id-icon'); // Import Styles from ID
            const exportStylesIcon = activeClasses.querySelector('.copy-id-to-class-icon'); // Export Styles to the ID
            const classContextualMenuIcon = activeClasses.querySelector('.class-contextual-menu-icon'); // Class Contextual Menu 
            const countClassesIcon = activeClasses.querySelector('#brxcNumClasses'); // Count Classes
            const plainClassesIcon = activeClasses.querySelector('.plain-classes-icon'); // Plain Classes

            // Remove Icon
            if(countClassesIcon) countClassesIcon.remove();
            if(copyToClipboardIcon) copyToClipboardIcon.remove();
            if(cloneClassIcon) cloneClassIcon.remove();
            if(exportStylesIcon) exportStylesIcon.remove();
            if(importSylesicon) importSylesicon.remove();
            if(classContextualMenuIcon) classContextualMenuIcon.remove();
            if(plainClassesIcon) plainClassesIcon.remove();



            // Icons that are always added - START
            // Plain Classes
            if(Object.values(self.globalSettings.elementShortcutIcons).includes("plain-classes")){
                self.addIconToFields('div','plain-classes-icon', false, 'Plain Classes', 'top-right', 'ADMINBRXC.openPlainClassesModal(event,document.querySelectorAll("#bricks-panel-element-classes ul.element-classes li span.name"), "#brxcPlainClassesOverlay", document.querySelector("#brxcPlainClassesOverlay .CodeMirror").CodeMirror )', false,  "<span class='symbol counter'>P</span>", activeClasses, 'child');
            }

            // Icons only available on Element ID
            if(!self.helpers.isClassActive()){

                // Export Styles to ID
                if(Object.values(self.globalSettings.elementShortcutIcons).includes("export-styles-to-class")){
                    self.addIconToFields('div','copy-id-to-class-icon', false, 'Export the styles to a class', 'top-right', 'ADMINBRXC.exportIDStylestoClass()', false,  "<span class='symbol counter'><i class='fas fa-file-export' title='fas fa-file-export'></i></span>", activeClasses, 'child');
                    const newExportStylesIcon = activeClasses.querySelector('.copy-id-to-class-icon');
                    newExportStylesIcon.addEventListener('click', (e) => e.stopPropagation());
                }
            }

            // Icons only available on classes
            if(self.helpers.isClassActive()){

                // Count Classes
                const classes = x.document.querySelectorAll('.' + self.vueState.activeClass.name);
                if(Object.values(self.globalSettings.classFeatures).includes("count-classes") && classes.length > 0){
                    const symbolIcon = activeClasses.querySelector('.active-class .symbol.counter');
                    const numClassesHTML = `<span id="brxcNumClasses" class="symbol counter" data-balloon="Used class on page" data-balloon-pos="top-right">${classes.length}</span>`;
                    symbolIcon.insertAdjacentHTML('afterend', numClassesHTML);

                    const newCountClassesIcon = activeClasses.querySelector('#brxcNumClasses');

                    let i = 0;
                    newCountClassesIcon.addEventListener('click', (e) => {
                        e.stopPropagation();
                        classes[i].scrollIntoView({ behavior: "smooth"});
                        (i === classes.length - 1) ? i = 0 : i++;
                    })
                }

                // Copy Class to clipboard
                if(Object.values(self.globalSettings.elementShortcutIcons).includes("copy-class-to-clipboard")) {
                    self.addIconToFields('div','copy-class-icon', false, 'Copy Class to Clipboard', 'top-right', `ADMINBRXC.copytoClipboardSimple('${self.vueState.activeClass.name}','"${self.vueState.activeClass.name}" successfully copied to clipboard')`, false,  '<span class="symbol counter"><i class="fas fa-clipboard"></i></span', activeClasses, 'child');
                    const newCopyToClipboardIcon = activeClasses.querySelector('.copy-class-icon');
                    newCopyToClipboardIcon.addEventListener('click', (e) => e.stopPropagation());
                }

                // Import Styles from ID
                if(Object.values(self.globalSettings.elementShortcutIcons).includes("export-styles-to-class") && !self.vueGlobalProp.$_isLocked(self.vueState.activeClass.id)){
                    self.addIconToFields('div','copy-class-to-id-icon', false, 'Import styles from the ID element', 'top-right', '', false,  "<span class='symbol counter'><i class='fas fa-file-import' title='fas fa-file-import'></i></span>", activeClasses, 'child');
                    const newimportSylesicon = activeClasses.querySelector('.copy-class-to-id-icon');
                    newimportSylesicon.addEventListener('click', (e) => {
                        e.stopPropagation();
                        self.vueState.brxcShowImportInput = true;
                        newimportSylesicon.remove();
                    })

                    if (self.vueState.brxcShowImportInput === true){
                        const newimportSylesiconHTML = `<span class='symbol counter'><i class='fas fa-file-import' title='fas fa-file-import'></i></span>`;
                        newimportSylesicon.innerHTML = `<span class='symbol counter'><i class='fas fa-check' title='fas fa-check'></i></span>`;
                        newimportSylesicon.setAttribute("onClick", "ADMINBRXC.importIDStylestoClass();ADMINBRXC.vueState.brxcShowImportInput = false");
                        newimportSylesicon.setAttribute("data-balloon", "Confirm?");
                        setTimeout(() => {
                            newimportSylesicon.innerHTML = newimportSylesiconHTML;
                            self.vueState.brxcShowImportInput = false
                        }, 2000)
                    }
                }

                // Clone Class
                if(Object.values(self.globalSettings.elementShortcutIcons).includes("clone-class")){
                    self.addIconToFields('div','clone-class-icon', false, 'Clone class', 'top-right', 'ADMINBRXC.cloneClass()', false,  '<span class="symbol counter"><i class="fa-solid fa-clone"></i></span', activeClasses, 'child');
                    const newCloneClassIcon = activeClasses.querySelector('.clone-class-icon');
                    newCloneClassIcon.addEventListener('click', (e) => e.stopPropagation());
                }
            }
            
            // Icons that are always added - END
            // Class Contextual Menu
            if(Object.values(self.globalSettings.elementShortcutIcons).includes("class-contextual-menu")){
                self.addIconToFields('div','class-contextual-menu-icon', false, 'Class Contextual Menu', 'top-right', 'event.stopPropagation();ADMINBRXC.openClassContextualMenu()', false,  '<span class="bricks-svg-wrapper"><svg version="1.1" viewBox="0 0 16 16" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" class="bricks-svg" style="rotate: 90deg;"><path d="M3,9.5l-6.55671e-08,-1.77636e-15c-0.828427,-3.62117e-08 -1.5,-0.671573 -1.5,-1.5c3.62117e-08,-0.828427 0.671573,-1.5 1.5,-1.5l-6.55671e-08,1.77636e-15c0.828427,-3.62117e-08 1.5,0.671573 1.5,1.5c3.62117e-08,0.828427 -0.671573,1.5 -1.5,1.5Zm5,0l-6.55671e-08,-1.77636e-15c-0.828427,-3.62117e-08 -1.5,-0.671573 -1.5,-1.5c3.62117e-08,-0.828427 0.671573,-1.5 1.5,-1.5l-6.55671e-08,1.77636e-15c0.828427,-3.62117e-08 1.5,0.671573 1.5,1.5c3.62117e-08,0.828427 -0.671573,1.5 -1.5,1.5Zm5,0l-6.55671e-08,-1.77636e-15c-0.828427,-3.62117e-08 -1.5,-0.671573 -1.5,-1.5c3.62117e-08,-0.828427 0.671573,-1.5 1.5,-1.5l-6.55671e-08,1.77636e-15c0.828427,-3.62117e-08 1.5,0.671573 1.5,1.5c3.62117e-08,0.828427 -0.671573,1.5 -1.5,1.5Z" fill="currentColor" fill-rule="evenodd"></path></svg></span>', activeClasses, 'child');
            }
            
        
        }, 0);


    },
    scopedVariablesCSS: function(){
        const self = this;
        const x = document.querySelector('#bricks-builder-iframe').contentWindow;
        let css = '';
        let xStylesheet = x.document.querySelector('#brxcScopedVariables');
        if(!xStylesheet){
            const el = document.createElement('style');
            el.id = 'brxcScopedVariables';
            const xHead = x.document.head;
            xHead.appendChild(el);
        }
        xStylesheet = x.document.querySelector('#brxcScopedVariables');

        function addCSS(arr){
            let css = '';
            arr.forEach(el => {
                if(el.hasOwnProperty('title') && el.hasOwnProperty('cssVarValue')){
                    css += `${el.title}:${el.cssVarValue};`;
                }
            })
            return css;
        }
        setTimeout(() => {
            // Classes
            const globalCls = self.vueState.globalClasses.filter(el => el && el.hasOwnProperty('name') && el.hasOwnProperty('settings') && el.settings.hasOwnProperty('_scopedVariables'));
            if(globalCls.length > 0){
                globalCls.forEach(cls => {
                    css += `.${cls.name}{`;
                    const arr = cls.settings._scopedVariables;
                    css += addCSS(arr);
                    css += `}`;
                })
            }

            // id
            const contentType = self.helpers.getTemplateType();
            let content = Array.from(self.vueState[contentType]);
            const els = content.filter(el => el && el.hasOwnProperty('settings') && el.settings.hasOwnProperty('_scopedVariables'));
            if(els.length > 0){
                els.forEach(el => {
                    const selector = el.hasOwnProperty('_cssId') ? `#${el._cssId}` : `#brxe-${el.id}`;
                    css += `${selector}{`;
                    const arr = el.settings._scopedVariables;
                    css += addCSS(arr);
                    css += `}`;
                })
            }

            xStylesheet.innerHTML = css;
        }, 150)
    },
    scopedVariablesListeners: function(){
        const self = this;
        if(!self.helpers.isElementActive() || self.vueState.activePanelGroup !== "_css") return;

        const panelInner = document.querySelector('[data-controlkey="_scopedVariables"]');
        if (!panelInner) return;

        function handleInputChange(event) {
            event.target.setAttribute("data-listening", "true");
            self.scopedVariablesCSS();
        }

        const observer = new MutationObserver(function() {
                if(self.vueState.scopedVariablesObserver === true) return;
                self.vueState.scopedVariablesObserver = true;
                self.scopedVariablesCSS();
                setTimeout(() => {
                    const inputFields = panelInner.querySelectorAll('input:not([data-listening="true"])');
                    inputFields.forEach(input => {
                        input.addEventListener('input', handleInputChange);
                    });
                }, 150)
            
            setTimeout(() => self.vueState.scopedVariablesObserver = false, 300)
        });

        observer.observe(panelInner, { 
            subtree: true, 
            childList: true,
            attributes: true,
        });
    },

    runStateFunctions: function(){
        const self = this;

        // First to run
        self.helpers.isBuilderTweaksTabActive('classes-and-styles') && Object.values(self.globalSettings.classFeatures).includes("focus-on-first-class") ? self.focusOnFirstClass() : '';
        
        setTimeout(() => {
            // Global Variables
            if(self.helpers.isCSSVariablesTabActive('theme-variables')){
                self.checkForThemeChange();
            }

            // Global Colors
            if (Object.values(ADMINBRXC.globalSettings.themeSettingsTabs).includes("global-colors") ){
                self.replaceColorsPalette();
            }
            
            // Builder Tweaks
            if (self.helpers.isBuilderTweaksTabActive() ){
                //Structure Panel
                if (Object.values(self.globalSettings.structurePanelIcons).includes("tags")) {
                    self.showTagInStructurePanel();
                    self.showTagInStructurePanelCustomTags();

                }
                Object.values(self.globalSettings.structurePanelGeneralTweaks).includes("styles-and-classes-indicators") ? self.structureElementHasStyle() : '';
                Object.values(self.globalSettings.structurePanelGeneralTweaks).includes("highlight-nestable-elements") ? self.highlightNestableElements() : '';
                Object.values(self.globalSettings.structurePanelGeneralTweaks).includes("highlight-parent-elements") ? self.highlightParentElements() : ''
                Object.values(self.globalSettings.structurePanelGeneralTweaks).includes("expand-all-children") ?  self.setExpandAllChildren(): '';
                Object.values(self.globalSettings.structurePanelGeneralTweaks).includes("multiselect") ? self.applyMultipleSettings() : '';

                // Classes
                Object.values(self.globalSettings.classFeatures).includes("locked-class-indicator") ? self.lockedClassIndicator() : '';
                Object.values(self.globalSettings.classFeatures).includes("variable-picker") ? self.addDynamicVariableIcon() : '';
                Object.values(self.globalSettings.classFeatures).includes("autoformat-field-values") ? self.autoformatControlValues() : '';
                Object.values(self.globalSettings.classFeatures).includes("color-preview") ? self.setDynamicColorOnHover() : '';
                Object.values(self.globalSettings.classFeatures).includes("class-preview") ? self.setDynamicClassOnHover() : '';
                Object.values(self.globalSettings.classFeatures).includes("disable-id-styles") ? self.forceClassStlyes() : '';
                Object.values(self.globalSettings.classFeatures).includes("highlight-classes") ? self.highlightClasses() : '';
                Object.values(self.globalSettings.classFeatures).includes("autocomplete-variable") ? self.setVariableAutocomplete() : '';
                if (Object.values(self.globalSettings.classFeatures).includes("media-query-indicator")) {
                    self.setBreakpointsAttributes();
                    self.mediaQueriesHasStyle();
                }
                if (Object.values(self.globalSettings.classFeatures).includes("class-indicator")) {
                    self.groupClassIndicator();
                    self.classIndicator()
                }
                Object.values(self.globalSettings.classFeatures).includes("breakpoint-indicator") ? self.breakpointIndicator() : '';
                Object.values(self.globalSettings.classFeatures).includes("scoped-variables") ? self.scopedVariablesListeners() : '';

                // Elements
                self.setTextShortcutsWrapper();
                Object.values(self.globalSettings.elementFeatures).includes("close-accordion-tabs") ? self.setActiveStyleTabs() : '';
                Object.values(self.globalSettings.elementFeatures).includes("disable-borders-boxshadows") ? self.setBorderAndBoxShadow(): '';
                Object.values(self.globalSettings.elementFeatures).includes("resize-elements-icons") ? self.setElementsColumns() : '';
                Object.values(self.globalSettings.elementFeatures).includes("lorem-ipsum") ? self.addDynamicLoremIcon() : '';
                Object.values(self.globalSettings.elementFeatures).includes("expand-spacing") ? self.addSpacingIcon() : '';
                Object.values(self.globalSettings.elementFeatures).includes("hide-inactive-accordion-panel") ? self.hideInactivePanels() : '';
                Object.values(self.globalSettings.elementFeatures).includes("superpower-custom-css") ? self.setSuperPowerCSS() : '';
                Object.values(self.globalSettings.elementFeatures).includes("grid-builder") ? self.addGridUIIcon() : '';
                if(Object.values(self.globalSettings.elementFeatures).includes("copy-interactions-conditions")) {
                    self.setCopyInteractions();
                    self.setCopyConditions();
                } 
                Object.values(self.globalSettings.elementFeatures).includes("box-shadow-generator") ? self.setBoxShadowGenerator() : '';
                Object.values(self.globalSettings.elementFeatures).includes("text-wrapper") ? self.setbasicTextOptions() : '';
            

                // Icon Shortcuts
                self.setClassShortcuts();
                self.addPanelHeaderIcons();
                Object.values(self.globalSettings.elementShortcutIcons).includes("tabs-shortcuts") && self.globalSettings.shortcutsTabs.length > 0 ? self.panelShortcuts() : '';
                Object.values(self.globalSettings.elementShortcutIcons).includes("pseudo-shortcut") && self.globalSettings.shortcutsIcons.length > 0 ? self.headerIconsState() : '';

                // Templates
                Object.values(self.globalSettings.templateFeatures).includes("quick-save") ? self.runIframeObserver() : '';
            }

            // AI
            (self.helpers.isAIActive() && self.globalSettings.isAIApiKeyEmpty === "0") ? self.addDynamicAIIcon() : '';

            // Strict Editor
            self.setStrictEditorView();
            
            // Global features
            self.setGenerateGlobalQuery();
            self.setQueryList();
        }, 0)
        

    },
    runObserver: function() {
        const self = this;
        const panelInner = document.querySelector('#bricks-panel-inner');
        if (!panelInner) return;

        const observer = new MutationObserver(function(mutations) {
                if(self.vueState.brxcRunningObserver === true) return;
                self.vueState.brxcRunningObserver = true;
                
                self.runStateFunctions();
            
            setTimeout(() => self.vueState.brxcRunningObserver = false, 300)
        });

        observer.observe(panelInner, { 
            subtree: true, 
            childList: true,
        });
    },
    initObservers: function(){
        const self = this;
        // Main Observer
        self.runObserver();
    },
    setKeyboardShortcuts: function(){
        const self = this;
        const x = document.querySelector('#bricks-builder-iframe').contentWindow;
        function runShortcuts(e){
            const shortcut = self.vueState.isMac ? e.metaKey && e.ctrlKey : e.ctrlKey && e.shiftKey;
            if(shortcut){
                switch(e.key.toLowerCase()){
                    case self.globalSettings.keyboardShortcuts.gridGuides.toLowerCase():
                        e.preventDefault();
                        self.gridGuide(document.querySelector('#bricks-toolbar li.grid-guide'));
                        break;
                    case self.globalSettings.keyboardShortcuts.xMode.toLowerCase():
                        e.preventDefault();
                        self.XCode(document.querySelector('#bricks-toolbar li.x-mode'))
                        break;
                    case self.globalSettings.keyboardShortcuts.contrastChecker.toLowerCase():
                        e.preventDefault();
                        self.contrast(document.querySelector('#bricks-toolbar li.constrast'))
                        break;
                    case self.globalSettings.keyboardShortcuts.darkmode.toLowerCase():
                        e.preventDefault();
                        self.darkMode(document.querySelector('#bricks-toolbar li.darkmode'))
                        break;
                    case self.globalSettings.keyboardShortcuts.cssStylesheets.toLowerCase():
                        e.preventDefault();
                        self.openModal(false, "#brxcCSSOverlay")
                        break;
                    case self.globalSettings.keyboardShortcuts.resources.toLowerCase():
                        e.preventDefault();
                        self.openModal(false, "#brxcResourcesOverlay", false, false);
                        break;
                    case self.globalSettings.keyboardShortcuts.openai.toLowerCase():
                        e.preventDefault();
                        self.openModal(false, "#brxcGlobalOpenAIOverlay")
                        break;
                    case self.globalSettings.keyboardShortcuts.brickslabs.toLowerCase():
                        e.preventDefault();
                        self.bricksLabsAPI(false, false, true);
                        self.openModal(false, "#brxcBricksLabsOverlay");
                        break;
                    case self.globalSettings.keyboardShortcuts.plainClasses.toLowerCase():
                        e.preventDefault();
                        self.helpers.isElementActive() ? ADMINBRXC.openPlainClassesModal(e,document.querySelectorAll('#bricks-panel-element-classes ul.element-classes li span.name'), '#brxcPlainClassesOverlay', document.querySelector('#brxcPlainClassesOverlay .CodeMirror').CodeMirror ) : self.vueGlobalProp.$_showMessage('Abort: no element selected!');
                        break;
                    case self.globalSettings.keyboardShortcuts.findAndReplace.toLowerCase():
                        e.preventDefault();
                        self.helpers.isElementActive() ? self.openFindReplaceModal(e,false, '#brxcFindReplaceModal') : self.openFindReplaceModal(e,true, '#brxcFindReplaceModal');
                        break;
                    case self.globalSettings.keyboardShortcuts.colorManager.toLowerCase():
                        e.preventDefault();
                        self.setColorManager();
                        self.openModal(false, "#brxcColorManagerOverlay");
                        break;
                    case self.globalSettings.keyboardShortcuts.classManager.toLowerCase():
                        e.preventDefault();
                        self.setClassManager();
                        self.setClassManagerBulkActions();
                        self.helpers.isElementActive() && self.helpers.isClassActive ? self.openClassInManager(self.vueState.activeClass.id) : self.openModal(false, "#brxcClassManagerOverlay");
                        break;
                    case self.globalSettings.keyboardShortcuts.variableManager.toLowerCase():
                        e.preventDefault();
                        self.openModal(false, "#brxcCSSVariableManagerOverlay");
                        self.setCSSVariableManager(true);
                        break;
                    case self.globalSettings.keyboardShortcuts.queryLoopManager.toLowerCase():
                        e.preventDefault();
                        self.queryManagerInit();
                        self.openModal(false,'#brxcQueryManagerOverlay');
                        break;
                    case self.globalSettings.keyboardShortcuts.structureHelper.toLowerCase():
                        e.preventDefault();
                        self.setStructureHelper();
                        self.openModal(false, "#brxcStructureHelper");
                        break;
                }
            }
        }
        document.addEventListener('keydown', function(e) {
            runShortcuts(e)
        });
        x.document.addEventListener('keydown', function(e) {
            runShortcuts(e)
        });
    },
    setDefaultPseudoClasses: function(){
        const self = this;
        const pseudoList = self.vueState.pseudoClasses;
        const defaultPseudo = [':before',':after',':hover', ':active', ':focus'];
        let hasNewPseudo = false;
        defaultPseudo.forEach(pseudo => {
            if (Object.values(pseudoList).indexOf(pseudo) > -1) return;
            hasNewPseudo = true;
            self.vueState.pseudoClasses.push(pseudo);
        })
        if (hasNewPseudo) self.helpers.saveChanges('pseudoClasses');
    },
    findAndReplace: function(searchValue, replaceValue, property, element, position, inclGlobalClasses){
        const self = this;
        property = property.options[property.selectedIndex].value;
        element = element.options[element.selectedIndex].value;
        const contentType = self.helpers.getTemplateType();
        let content = self.vueState[contentType];
        let numChanges = 0;
        

        function replaceHexWithColor(obj, color) {
            let hexFound = false;
        
            if (Array.isArray(obj)) {
                for (let i = 0; i < obj.length; i++) {
                    const result = replaceHexWithColor(obj[i], color);
                    if (result.found) {
                        obj[i] = result.newValue;
                        hexFound = true;
                    }
                }
            } else if (typeof obj === "object" && obj !== null) {
                for (const key of Object.keys(obj)) {
                    const result = replaceHexWithColor(obj[key], color);
                    if (result.found) {
                        obj[key] = result.newValue;
                        hexFound = true;
                    }
                }
        
                if (obj.hasOwnProperty("hex") && obj.hex === searchValue) {
                    obj = color;
                    hexFound = true;
                    numChanges++;
                }
            }
        
            return { found: hexFound, newValue: obj };
        }

        function replaceColor(replaceColor){
            const palettes = self.vueState.colorPalette;
            let matchingColor = false;
            palettes.forEach(palette => {
                palette.colors.forEach( color => {
                    for (const [key, value] of Object.entries(color)) {
                        if (color[key] === replaceColor)  {
                            matchingColor = color;
                        }
                    }
                })
            })
            return matchingColor;
        }
        function replaceStyle(id, isGlobalClass = false){
            const color = replaceColor(replaceValue)
            const obj = isGlobalClass ? self.vueGlobalProp.$_getGlobalClass(id) : self.vueGlobalProp.$_getElementObject(id);

            for (const [key, value] of Object.entries(obj.settings)) {
                if(!self.helpers.isCSSControlKey(key)) continue ;

                if(property === "all" || key === property) {
                    // colors
                    if(color){
                        const checkColor = replaceHexWithColor(obj.settings, color);
                    } else {
                        // other
                        const oldValue = obj.settings[key];
                        obj.settings[key] = JSON.parse(JSON.stringify(value).replaceAll(searchValue, replaceValue));

                        if (JSON.stringify(oldValue) != JSON.stringify(obj.settings[key])) numChanges++;
                    }

                }
            }
   
        }

        function setStyle(obj, id) {
            // Category check
            if(element === "all" || obj.name === element){
                replaceStyle(id);
                if(inclGlobalClasses === "yes" && obj.settings.hasOwnProperty('_cssGlobalClasses')){
                    obj.settings._cssGlobalClasses.forEach(clsId => {
                        replaceStyle(clsId, true);
                    })
                }
            }
            if(Object.keys(obj.children).length > 0){
                Object.keys(obj.children).forEach(function (key){
                    const newObj = self.vueGlobalProp.$_getElementObject(obj.children[key]);
                    setStyle(newObj, obj.children[key]);
                });
            }
        }
        if(position === "page"){
            content.forEach(child => {
                if(element === "all" || child.name === category){
                    replaceStyle(child.id);
                    if(inclGlobalClasses === "yes" && child.settings.hasOwnProperty('_cssGlobalClasses')){
                        child.settings._cssGlobalClasses.forEach(clsId => {
                            replaceStyle(clsId, true);
                        })
                    }
                }
            })
        } else {
            // active element
            const el = self.vueState.activeElement;
            const parentID = el.parent;
            if(!parentID || typeof content == "undefined") return;

            function checkParent(elemID){
                let obj;
                if(elemID !== false) obj = self.vueGlobalProp.$_getElementObject(elemID);
                
                // sibling
                
                if(position === "siblings"){
                    obj.children.forEach(child => {
                        const obj = self.vueGlobalProp.$_getElementObject(child);
                        if(element === "all" || obj.name === element){
                            replaceStyle(child);
                            if(inclGlobalClasses === "yes" && obj.settings.hasOwnProperty('_cssGlobalClasses')){
                                obj.settings._cssGlobalClasses.forEach(clsId => {
                                    replaceStyle(clsId, true);
                                })
                            }
                        }
                    })
                
                // children

                } else if(position === "children"){
                    obj = self.vueGlobalProp.$_activeElement._value;
                    if (typeof obj === "undefined" || !obj.hasOwnProperty('children') || obj.children.length < 1) return;
                    obj.children.forEach(child => {
                        const obj = self.vueGlobalProp.$_getElementObject(child)
                        setStyle(obj, child)
                    })

                // custom postion
                } else {
                    if (obj.name === position){
                        obj.children.forEach(child => {
                            const obj = self.vueGlobalProp.$_getElementObject(child)
                            setStyle(obj, child)
                        })
                    } else {
                        if(obj.parent) checkParent(obj.parent);
                    }
                }
            }

            checkParent(parentID);
        }
        
        if(numChanges > 0 ){
            self.vueState.rerenderControls = Date.now();
            self.vueGlobalProp.$_showMessage(`${numChanges} styles correctly replaced!`);
        } else {
            self.vueGlobalProp.$_showMessage(`No corresponding style has been found.`);
        }
    },
    expandClass: function(type, property, category, position, erase){
        const self = this;
        const contentType = self.helpers.getTemplateType();
        let content = self.vueState[contentType];
        category = category.options[category.selectedIndex].value;
        property = property.options[property.selectedIndex].value;

        // active element
        const el = self.vueState.activeElement;
        if (!el) return;
        const classes = el.settings._cssGlobalClasses;
        const cssClasses =  (el.settings._cssClasses) ? el.settings._cssClasses.split(' ') : false;
        if (type === "Classes" && !classes && !cssClasses) return self.vueGlobalProp.$_showMessage('No Class found on the element');
        let styles = [];
        for (const [key, value] of Object.entries(el.settings)) {
            if (self.helpers.isCSSControlKey(key)) styles.push({[key]: value});
        }
        if (type === "Styles" && styles.length < 1) return self.vueGlobalProp.$_showMessage('No Style found on the element');
        let parentID = el.parent;
        if(!parentID || typeof content == "undefined") parentID = false;

        function replaceClass(id){
            for(let i = 0; i < content.length; i++){
                for (const [key, value] of Object.entries(content[i])) {
                    if (key === 'id' && value === id) {
                        if(Object.getPrototypeOf(content[i].settings).length === 0) content[i].settings = {};

                        // classes
                        if (type === "Classes") {
                            if (typeof content[i].settings !== "undefined" && !content[i].settings.hasOwnProperty('_cssGlobalClasses') || erase === "true") content[i].settings._cssGlobalClasses = [];
                            if (typeof content[i].settings !== "undefined" && !content[i].settings.hasOwnProperty('_cssClasses') || erase === "true") content[i].settings._cssClasses = "";
                            if(classes && classes.length > 0){
                                classes.forEach(el => {
                                    if (!content[i].settings._cssGlobalClasses.includes(el)) content[i].settings._cssGlobalClasses.push(el);
                                });
                            }

                            if(cssClasses && cssClasses.length > 0){
                                cssClasses.forEach(el => {
                                    if (!content[i].settings._cssClasses.includes(el)) content[i].settings._cssClasses = `${content[i].settings._cssClasses} ${el}`;
                                });
                            }
                        }

                        // styles
                        if (type === "Styles") {
                            styles.forEach(style => {
                                for (const [key, value] of Object.entries(style)) {
                                    if(property === "all" || key === property) content[i].settings[key] = JSON.parse(JSON.stringify(value));
                                }
                            })
                        }
                    }
                }
            }
        }
        function setClass(obj, id) {
            // Category check
            if(category === "all" || obj.name === category){
                replaceClass(id);
            }
            if(Object.keys(obj.children).length > 0){
                Object.keys(obj.children).forEach(function (key){
                    const newObj = self.vueGlobalProp.$_getElementObject(obj.children[key]);
                    setClass(newObj, obj.children[key]);
                });
            }
        }

        function checkParent(elemID){
            let obj;
            if(elemID !== false) obj = self.vueGlobalProp.$_getElementObject(elemID);
            
            // sibling
            
            if(position === "siblings"){
                if (obj === false) return;
                obj.children.forEach(child => {
                    const obj2 = self.vueGlobalProp.$_getElementObject(child)
                    if(category === "all" || obj2.name === category){
                        replaceClass(child);
                    }
                })

            // children

            } else if(position === "children"){
                obj = self.vueGlobalProp.$_activeElement._value;
                if (typeof obj === "undefined" || !obj.hasOwnProperty('children') || obj.children.length < 1) return;
                obj.children.forEach(child => {
                    const obj = self.vueGlobalProp.$_getElementObject(child)
                    setClass(obj, child)
                })

            // page

            } else if(position === "page"){
                content.forEach(child => {
                    if(category === "all" || child.name === category){
                        replaceClass(child.id);
                    }
                })
            
            // custom container

            } else {
                if (typeof obj === "undefined" || !obj.hasOwnProperty('children') || obj.children.length < 1) return;
                if (obj.name === position){
                    obj.children.forEach(child => {
                        const obj = self.vueGlobalProp.$_getElementObject(child)
                        setClass(obj, child)
                    })
                } else {
                    if(obj.parent) checkParent(obj.parent);
                }
            }
        }
        checkParent(parentID);
        self.vueGlobalProp.$_showMessage(type + ' correctly extended!');
    },
    classConverterStates:{
        data: [],
        delimiter: '__',
        copyStyles: true,
        deleteStyles: false,
    },
    popopulateClassConverterStates: function(){
        const self = this;
        self.classConverterStates.active = "all";
        self.classConverterStates.category = "";
        self.classConverterStates.data = [];
        const elements = [];

        function populateElements(id, level){
            const obj = JSON.parse(JSON.stringify(self.vueGlobalProp.$_getElementObject(id)));
            obj.level = level;
            elements.push(obj);

            if (!obj.hasOwnProperty('children') || !Array.isArray(obj.children) || obj.children.length < 1) return;
            level++;
            obj.children.forEach(newId => {
                populateElements(newId, level);
            })
        }

        function checkchildren(element, arr, compId, isParent){
            const active = self.classConverterStates.elements.find(el => el && el.id === element.id);
            active.componentId = compId;
            if(isParent) active.componentParent = true;
            if (!element.hasOwnProperty('children') || !Array.isArray(element.children) || element.children.length < 1) return;
            element.children.forEach(id => {
                const obj = self.vueGlobalProp.$_getElementObject(id);
                if(obj.settings.hasOwnProperty('classConverterComponent') && obj.settings.classConverterComponent === true) return;
                checkchildren(obj, arr, compId, false);
            })
        }

        // root loop
        populateElements(self.vueState.activeElement.id, 0);
        self.classConverterStates.elements = elements;
        const compId = self.vueGlobalProp.$_generateId();
        let rootObj = {
            id: compId,
            basename: self.vueState.activeElement.hasOwnProperty('label') ? self.helpers.formatForClasses(self.vueState.activeElement.label) : self.vueState.activeElement.name,
            label: self.vueState.activeElement.hasOwnProperty('label') ? self.vueState.activeElement.label : self.vueState.activeElement.name,
        };
        checkchildren(self.vueState.activeElement, rootObj.content, compId, true);
        self.classConverterStates.data.push(rootObj);

        //component loop
        const components = elements.filter(el => el && el.settings.hasOwnProperty('classConverterComponent') && el.settings.classConverterComponent === true);
        components.forEach(comp => {
            const compId = self.vueGlobalProp.$_generateId();
            let newObj = {
                id: compId,
                basename: comp.hasOwnProperty('label') ? self.helpers.formatForClasses(comp.label) : comp.name,
                label: comp.hasOwnProperty('label') ? comp.label : comp.name,
            };
            checkchildren(comp, newObj.content, compId, true);
            self.classConverterStates.data.push(newObj);
        })
        if(self.classConverterStates.data.length === 1) self.classConverterStates.active = self.classConverterStates.data[0].id;
    },
    renderClassConverter: function(){
        const self = this;
        const canvas = document.querySelector('#brxcClassConvertCanvas');
        const activeComponent = self.classConverterStates.data.find(comp => comp && comp.id === self.classConverterStates.active);
        const delimiter = activeComponent && activeComponent.hasOwnProperty('delimiter') ? activeComponent.delimiter : self.classConverterStates.delimiter;
        const basename = activeComponent ? activeComponent.basename : '';
        const category = activeComponent && activeComponent.hasOwnProperty('category') ? activeComponent.category : self.classConverterStates.category;
        const copyStyles = activeComponent && activeComponent.hasOwnProperty('copyStyles') ? activeComponent.copyStyles : self.classConverterStates.copyStyles;
        const deleteStyles = activeComponent && activeComponent.hasOwnProperty('deleteStyles') ? activeComponent.deleteStyles : self.classConverterStates.deleteStyles;
        let content = '';
        if(self.classConverterStates.data.length > 1){
            content += `<div class="m-top-16">
                            <label for="ClassDelimiter" class="has-tooltip">
                                <span>Components</span>
                                <div data-balloon="Select a component to apply specific settings to it." data-balloon-pos="bottom-right" data-balloon-length="medium"><i class="fas fa-circle-question"></i></div>
                            </label>
                            <div class="brxc-overlay__action-btn-wrapper">`;
            content += `<div class="brxc-overlay__action-btn${self.classConverterStates.active === "all" ? ` primary`: ''}" data-id="all" onclick="ADMINBRXC.classConverterStates.active = 'all';ADMINBRXC.renderClassConverter();">Default</div>`
            self.classConverterStates.data.forEach(el => {
                content += `<div class="brxc-overlay__action-btn${el.id === self.classConverterStates.active ? ` primary`: ''}" data-id="${el.id}" onclick="ADMINBRXC.classConverterStates.active = '${el.id}';ADMINBRXC.renderClassConverter();">${el.label}</div>`
            })
            content += `</div></div>`;
        }
        content += `<div class="input-wrapper">`
        // Basename
        content += `<div style="flex-basis: 75%;"${self.classConverterStates.data.length > 1 && self.classConverterStates.active === "all" ? 'class="disable"' : ''}>
                        <label for="ClassPrefix" class="has-tooltip">
                            <span>Basename</span>
                            <div data-balloon="Set the basename of the class. Example for BEM: 'feature' is the basename of 'feature__heading'." data-balloon-pos="bottom-left" data-balloon-length="medium"><i class="fas fa-circle-question"></i></div>
                        </label>
                        <input type="text" id="ClassPrefix" class="brxc-input-text m-bottom-24" value="${basename}" placeholder="Type your class prefix here." oninput="ADMINBRXC.classConverterUpdateComponent('basename', this.value);"></input>
                    </div>`
        content += `<div style="flex-basis: 25%;">
                        <label for="ClassDelimiter" class="has-tooltip">
                            <span>Delimiter</span>
                            <div data-balloon="Set the delimiter of the class. Example for BEM: '__' is the delimiter of 'feature__heading'." data-balloon-pos="bottom-right" data-balloon-length="medium"><i class="fas fa-circle-question"></i></div>
                        </label>
                        <input type="text" id="ClassDelimiter" class="brxc-input-text m-bottom-24" value="${delimiter}" placeholder="Type your delimiter prefix here." value="__" oninput="ADMINBRXC.classConverterUpdateComponent('delimiter', this.value)"></input>
                        </div>
                    </div>
                    <label for="classConverterPreviewCanvas">
                        <span>Preview</span>
                    </label>
                    <ul>
                    <div id="brxcClassConverterPreviewCanvas">`;
        // Preview 
        content += self.setClassConverterPreview();           
        content += `</div></ul>`;
        // Group
        content += `<label for="brxcClassConverterClassCategory" class="has-tooltip">
                        <span>Class Category <span class="brxc__light">(Optional)</span></span>
                        <div data-balloon="Set the Category of the class. The category will be added to the Class Manager." data-balloon-pos="top" data-balloon-length="medium">
                            <i class="fas fa-circle-question"></i>
                        </div>
                    </label>
                    <div id="classConverterGrpWrapper">
                        <input type="text" id="brxcClassConverterClassCategory" class="brxc-input-text m-bottom-24" value="${category}" placeholder="Type the category of the class here." oninput="ADMINBRXC.classConverterUpdateComponent('category', this.value);ADMINBRXC.autocomplete(this,Array.from(ADMINBRXC.vueState.globalClassesCategories).map(el => el && el.name),false)"></input>
                    </div>
                `;
        content += `<label class="has-tooltip">
                        <span>Copy the ID styles to the class(es)?</span>
                        <div data-balloon="Choose if the styles set on the ID level should be transfered to the generated class." data-balloon-pos="top-right" data-balloon-length="medium"><i class="fas fa-circle-question"></i></div>
                    </label>
                    <div class="brxc-overlay__panel-inline-btns-wrapper m-bottom-24">
                        <input type="radio" id="clsConverter-no" name="clsConverter-copy-styles" class="brxc-input__checkbox" onclick="ADMINBRXC.classConverterUpdateComponent('copyStyles', false);"${copyStyles === false ? " checked" : ""}>
                        <label for="clsConverter-no" class="brxc-overlay__panel-inline-btns">No</label>
                        <input type="radio" id="clsConverter-yes" name="clsConverter-copy-styles" class="brxc-input__checkbox" onclick="ADMINBRXC.classConverterUpdateComponent('copyStyles', true);"${copyStyles === true ? " checked" : ""}>
                        <label for="clsConverter-yes" class="brxc-overlay__panel-inline-btns">Yes</label>
                        <input type="radio" id="clsConverter-skip" name="clsConverter-copy-styles" class="brxc-input__checkbox" onclick="ADMINBRXC.classConverterUpdateComponent('copyStyles', 'skip');"${copyStyles === "skip" ? " checked" : ""}>
                        <label for="clsConverter-skip" class="brxc-overlay__panel-inline-btns">Yes, unless the class already exists</label>
                    </div>
                    <label class="has-tooltip">
                        <span>Erase the ID styles?</span>
                        <div data-balloon="Choose if the styles set on the ID level should be erased after being transfered to the class." data-balloon-pos="top" data-balloon-length="medium"><i class="fas fa-circle-question"></i></div>
                    </label>
                    <div class="brxc-overlay__panel-inline-btns-wrapper m-bottom-24">
                        <input type="radio" id="clsConverter-noo" name="clsConverter-erase-styles" class="brxc-input__checkbox" onclick="ADMINBRXC.classConverterUpdateComponent('deleteStyles', false);"${deleteStyles === false ? " checked" : ""}>
                        <label for="clsConverter-noo" class="brxc-overlay__panel-inline-btns">No</label>
                        <input type="radio" id="clsConverter-yess" name="clsConverter-erase-styles" class="brxc-input__checkbox" onclick="ADMINBRXC.classConverterUpdateComponent('deleteStyles', true);"${deleteStyles === true ? " checked" : ""}>
                        <label for="clsConverter-yess" class="brxc-overlay__panel-inline-btns">Yes</label>
                    </div>`
        canvas.innerHTML = content;
    },
    setClassConverter:function(){
        const self = this;
        self.popopulateClassConverterStates();
        self.renderClassConverter();
    },
    setClassConverterPreview: function(){
        const self = this;
        let content = '';
        self.classConverterStates.elements.forEach(el =>{
            const activeComponent = self.classConverterStates.data.find(comp => comp && comp.id === el.componentId);
            const delimiter = activeComponent && activeComponent.hasOwnProperty('delimiter') ? activeComponent.delimiter : self.classConverterStates.delimiter;
            const basename = activeComponent.basename;
            const prefix = el.hasOwnProperty('componentParent') && el.componentParent === true ? basename : `${basename}${delimiter}`;
            const value = el.hasOwnProperty('componentParent') && el.componentParent === true ? '' : el.hasOwnProperty('label') ? self.helpers.formatForClasses(el.label) : el.name;
            content += `<li style="--margin:${el.level}"${self.classConverterStates.active === "all" || el.componentId === self.classConverterStates.active ? ' class="active"' : ''}>
                            <div class="icon" data-balloon="${bricksData.elements[el.name].label}" data-balloon-pos="top-left">
                                <i class="${bricksData.elements[el.name].icon}"></i>
                            </div>
                            <span>.${prefix}</span>`
            content += !el.hasOwnProperty('componentParent') || el.componentParent !== true ? `<input type="text" data-id="${el.id}" value="${value}" oninput="ADMINBRXC.classConverterUpdateElement(this.dataset.id, 'label', this.value)">` : '';
             content += el.hasOwnProperty('skip') && el.skip === true ? `<button data-balloon="click to include" data-id="${el.id}" data-balloon-pos="left" onClick="ADMINBRXC.classConverterUpdateElement(this.dataset.id, 'skip', false)">
                                                                                <i class="fas fa-toggle-off"></i>
                                                                            </button>
                                                                        </li>` : 
                                                                        `<button data-balloon="click to skip" data-id="${el.id}" data-balloon-pos="left" onClick="ADMINBRXC.classConverterUpdateElement(this.dataset.id, 'skip', true)">
                                                                                <i class="fas fa-toggle-on"></i>
                                                                            </button>
                                                                        </li>`;
        })
        return content;

    },
    classConverterRenderPreview: function(){
        const self = this;
        const canvas = document.querySelector('#brxcClassConverterPreviewCanvas');
        content = self.setClassConverterPreview();
        canvas.innerHTML = content;
    },
    classConverterUpdateComponent: function(prop, value){
        const self = this;
        const activeComponent = self.classConverterStates.data.find(el => el && el.id === self.classConverterStates.active);
        if(!activeComponent) {
            self.classConverterStates[prop] = value;
        } else {
            activeComponent[prop] = value;
        }
        self.classConverterRenderPreview();
    },
    classConverterUpdateElement: function(id, prop, value){
        const self = this;
        const activeElement = self.classConverterStates.elements.find(el => el && el.id === id);
        if(!activeElement) return console.log('active not found');
        activeElement[prop] = value;
        if(prop === "skip") self.classConverterRenderPreview();
    },
    classConverter: function(){
        const self = this;

        function checkGlobalClass(classname, element, category, copyStyles, deleteStyles){
            let newClassID;
            let foundMatch = false;
            const obj = Array.from(self.vueState.globalClasses).find(el => el && el.name === classname);
            if(obj){
                foundMatch = true;
                newClassID = obj.id;
            }

            if(foundMatch === true && (copyStyles === "skip" || self.vueGlobalProp.$_isLocked(newClassID))) {
                return;
            }
            if(!foundMatch) {
                if(!category || category.length < 1) category = false;
                newClassID = self.vueGlobalProp.$_generateId();
                self.generateGlobalClass('', classname, category, newClassID);
                classCreated++;
            }

            // Export styles
            if(copyStyles === true || copyStyles === "skip"){
                const styles = [];
                for (const [key, value] of Object.entries(element.settings)) {
                    if( key === '_cssCustom'){
                        let id;
                        (typeof element.settings !== "undefined" && element.settings.hasOwnProperty('_cssId')) ? id = '#' + element.settings._cssId : id = '#brxe-' + element.id;
                        styles.push({[key]: value.replaceAll(id, '.' + classname)});
                    } else if (self.helpers.isCSSControlKey(key)) {
                        styles.push({[key]: value});
                        if (deleteStyles === true) {
                            delete element.settings[key];
                        }
                    }
                }
                const arr = Array.from(self.vueState.globalClasses).filter(el => el && el.id === newClassID);
                if(arr.length > 0){
                    arr.forEach(el => {
                        if(styles.lengh < 1) return;
                        if(!el.hasOwnProperty('settings')) el.settings = {};
                        styles.forEach((style) => {
                            for (const [key, value] of Object.entries(style)) {
                                el.settings[key] = JSON.parse(JSON.stringify(value));
                            }
                        })
                    })

                }
            }


            if (typeof element !== "undefined" && !element.hasOwnProperty('settings') || Object.getPrototypeOf(element.settings).length === 0) element.settings = {};
            if (typeof element.settings !== "undefined" && !element.settings.hasOwnProperty('_cssGlobalClasses')) element.settings._cssGlobalClasses = []
            if (typeof element.settings._cssGlobalClasses !== "undefined" && !element.settings._cssGlobalClasses.includes(newClassID)) element.settings._cssGlobalClasses.push(newClassID);

        }

        let classCreated = 0;

        const els = self.classConverterStates.elements.filter(el => el && (!el.hasOwnProperty('skip') || el.skip !== true));
        if(els.length < 1) return console.log('no elements found');
        els.forEach(el => {
            const activeComponent = self.classConverterStates.data.find(comp => comp && comp.id === el.componentId);
            const delimiter = activeComponent && activeComponent.hasOwnProperty('delimiter') ? activeComponent.delimiter : self.classConverterStates.delimiter;
            const category = activeComponent && activeComponent.hasOwnProperty('category') ? activeComponent.category : self.classConverterStates.category;
            const copyStyles = activeComponent && activeComponent.hasOwnProperty('copyStyles') ? activeComponent.copyStyles : self.classConverterStates.copyStyles;
            const deleteStyles = activeComponent && activeComponent.hasOwnProperty('deleteStyles') ? activeComponent.deleteStyles : self.classConverterStates.deleteStyles;
            const clsName = el.hasOwnProperty('componentParent') && el.componentParent === true ? self.helpers.formatForClasses(activeComponent.basename) : self.helpers.formatForClasses(`${activeComponent.basename}${delimiter}${el.hasOwnProperty('label') ? el.label : el.name}`);
            const settings = self.vueGlobalProp.$_getElementObject(el.id);
            checkGlobalClass(clsName, settings, category, copyStyles, deleteStyles);

        })

        self.vueState.rerenderControls = Date.now();
        self.vueGlobalProp.$_showMessage(`${classCreated} Classes successfully created`);
    },
    hideElement: function(){
        const self = this;
        const activeEl = self.vueGlobalProp.$_activeElement._value;
        if(!activeEl.hasOwnProperty('settings')) activeEl.settings = {};
        activeEl.settings._display = 'none';

    },
    showElement: function(){
        const self = this;
        const activeEl = self.vueGlobalProp.$_activeElement._value;
        if(activeEl.hasOwnProperty('settings') && activeEl.settings.hasOwnProperty('_display')) delete activeEl.settings._display;
    },
    moveElement: function(position){
        const self = this;

        function move(arr, from, to, on = 1) {
            return arr.splice(to, 0, ...arr.splice(from, on)), arr
        }
        const activeEl = self.vueState.activeElement;
        if(!activeEl) return;

        let parentEl = activeEl.parent;

        const contentType = self.helpers.getTemplateType();
        let content = self.vueState[contentType];

        // Element is on root
        if(parentEl === 0){
            const indexEl = content.indexOf(activeEl);

            if (position === 'top'){

                function findpreviousEl(index){
                    if(!content[index - 1]) return;
                    if(content[index - 1].parent === 0){
                        return index - 1;
                    } else {
                        return findpreviousEl(index - 1);
                    }
                }
                const previousElIndex = findpreviousEl(indexEl);
                if(previousElIndex) content = move(content, indexEl, previousElIndex - 1, 1);

            } else if (position === "left"){
                return;

            } else if (position === "right"){
                function checkRootSiblings(index, direction){
                    let tempIndex;
                    if(direction === "backward" && index > 0 && content[index - 1]){
                        tempIndex = index - 1;
                    } else if (content[index + 1]) {
                        tempIndex = index + 1;
                        direction = "forward";
                    } else {
                        return;
                    }

                    const obj = content[tempIndex];

                    if(obj.parent !== 0 || obj.id === activeEl.id) return checkRootSiblings(tempIndex, direction);

                    const name = obj.name;
                    const isNestable = bricksData.elements[name].nestable;

                    if(!isNestable) return checkRootSiblings(tempIndex, direction);
                    
                    if(!Array.isArray(obj.children)) obj.children = [];
                    if (direction === "forward") {
                        obj.children.unshift(activeEl.id)
                    } else {
                        obj.children.push(activeEl.id)
                    }
                    activeEl.parent = obj.id;
                }
                checkRootSiblings(indexEl, "backward")
    
            } else if (position === "down"){
                function findNextEl(index){
                    if(!content[index + 1]) return;
                    if(content[index + 1].parent === 0){
                        return index + 1;
                    } else {
                        return findNextEl(index + 1);
                    }
                }
                const nextElIndex = findNextEl(indexEl);
                if(nextElIndex) content = move(content, indexEl, nextElIndex + 1, 1);
            }
            


        // Element is nested inside the structure
        } else {
            const currentEl = activeEl.id;
            let parentObj = self.vueGlobalProp.$_getElementObject(parentEl);
            let parentChildren = parentObj.children;

            if (position === 'top'){
                let currentIndex = parentChildren.indexOf(currentEl);
                const newChildren = move(parentChildren, currentIndex, currentIndex - 1, 1);
                parentChildren = newChildren;
    
            } else if (position === "left"){
                   
                const grandFatherId = parentObj.parent;
                const grandFatherObj = (grandFatherId !== 0) ? self.vueGlobalProp.$_getElementObject(grandFatherId) : false;
                const grandFatherChildren = (grandFatherObj) ? grandFatherObj.children : false;
    
                // parent is on root
                if(!grandFatherId){
                    self.vueState[contentType] = move(content, content.indexOf(activeEl), content.indexOf(parentObj) + 1, 1)
                    parentChildren.splice(parentChildren.indexOf(currentEl), 1);
                    self.vueState.activeElement.parent = 0;
                } else {
                    // has grandfather
                    grandFatherChildren.push(currentEl);
                    grandFatherObj.children = move(grandFatherChildren, grandFatherChildren.indexOf(currentEl), grandFatherChildren.indexOf(parentObj.id) + 1, 1);
                    parentChildren.splice(parentChildren.indexOf(currentEl), 1);
                    self.vueState.activeElement.parent = grandFatherId;
                }
                
            } else if (position === "right"){
                const currentIndex = parentChildren.indexOf(currentEl);
                
                function checkRootSiblings(index, direction){
                    let tempIndex;
                    if(direction === "backward" && index > 0 && parentChildren[index - 1]){
                        tempIndex = index - 1;
                    } else if (parentChildren[index + 1]) {
                        tempIndex = index + 1;
                        direction = "forward";
                    } else {
                        return;
                    }

                    const obj = self.vueGlobalProp.$_getElementObject(parentChildren[tempIndex]);
                    if(obj.id === currentEl) return checkRootSiblings(tempIndex, direction);

                    const name = obj.name;
                    const isNestable = bricksData.elements[name].nestable;

                    if(!isNestable) return checkRootSiblings(tempIndex, direction);
                    
                    if(!Array.isArray(obj.children)) obj.children = [];
                    parentChildren.splice(parentChildren.indexOf(currentEl), 1);
                    activeEl.parent = obj.id;
                    if (direction === "forward") {
                        obj.children.unshift(currentEl)
    
                    } else {
                        obj.children.push(currentEl)
                    }
                }
                checkRootSiblings(currentIndex, "backward");
    
            } else if (position === "down"){
                let currentIndex = parentChildren.indexOf(currentEl);
                const newChildren = move(parentChildren, currentIndex, currentIndex + 1, 1);
                parentChildren = newChildren;
    
            }

        }

        self.vueState.rerenderControls = Date.now();
        
    },
    styleOverviewStates: {
        copy: {
            type: null,
            id: null,
            styles: null,
            bpKey: null,
            pseudo: null,
        },
        pseudo: '',
    },
    styleOverviewCopy: function(bpKey, type, id){
        const self = this;
        let styles = [];
        const bp = Array.from(self.vueState.breakpoints).find(el => el && el.key === bpKey);

        const settings = type === 'id' ? self.vueGlobalProp.$_getElementObject(id).settings : self.vueGlobalProp.$_getGlobalClass(id).settings;

        for(const key of Object.keys(settings)){
            if(self.helpers.keyMatchBreakpoint(key, bpKey) && self.helpers.keyMatchPseudo(key,self.styleOverviewStates.pseudo) && self.helpers.isCSSControlKey(key.split(':')[0])) styles[key.split(':')[0]] = settings[key];

        }

        self.styleOverviewStates.copy.type = type;
        self.styleOverviewStates.copy.id = id;
        self.styleOverviewStates.copy.bpKey = bpKey;
        self.styleOverviewStates.copy.styles = styles;

        self.vueGlobalProp.$_showMessage(`Styles on ${bp.label} have been successfully copied!`)
        self.setStyleOverview(self.styleOverviewStates.pseudo === "" ? "no-pseudo" : self.styleOverviewStates.pseudo);
    },
    styleOverviewPaste: function(bpKey, type, id){
        const self = this;
        const bp = Array.from(self.vueState.breakpoints).find(el => el && el.key === bpKey);
        const settings = type === 'id' ? self.vueGlobalProp.$_getElementObject(id).settings : self.vueGlobalProp.$_getGlobalClass(id).settings;
        Object.keys(self.styleOverviewStates.copy.styles).forEach(key => {
            let finalKey = key;
            if(bpKey !== "desktop") finalKey += `:${bpKey}`
            if(self.styleOverviewStates.pseudo !== '') finalKey += `:${self.styleOverviewStates.pseudo}`;

            settings[finalKey] = self.styleOverviewStates.copy.styles[key];
        })

        self.vueGlobalProp.$_showMessage(`Styles on ${bp.label} have been successfully pasted!`)
        self.setStyleOverview(self.styleOverviewStates.pseudo === "" ? "no-pseudo" : self.styleOverviewStates.pseudo);
    },
    styleOverviewReset: function(bpKey, type, id){
        const self = this;
        const bp = Array.from(self.vueState.breakpoints).find(el => el && el.key === bpKey);

        const settings = type === 'id' ? self.vueGlobalProp.$_getElementObject(id).settings : self.vueGlobalProp.$_getGlobalClass(id).settings;

        Object.keys(settings).forEach(key => {
            if(self.helpers.keyMatchBreakpoint(key, bpKey) && self.helpers.keyMatchPseudo(key,self.styleOverviewStates.pseudo) && self.helpers.isCSSControlKey(key.split(':')[0])) delete settings[key];
        })

        self.vueGlobalProp.$_showMessage(`Styles on ${bp.label} have been successfully removed!`)
        self.setStyleOverview(self.styleOverviewStates.pseudo === "" ? "no-pseudo" : self.styleOverviewStates.pseudo);
    },
    setStyleOverviewBPMenu: function(target){
        const self = this;
        const canvas = target.nextElementSibling;
        const table = target.closest('table');
        const type = table.dataset.table;
        const id = table.id;
        if(target.classList.contains('active')){
            target.classList.remove('active');
            canvas.innerHTML = '';
            return;
        } else {
            target.classList.add('active')
        }
       
        const bpKey = target.dataset.key;
        let content = `<ul>`;
        content += `<li onclick="ADMINBRXC.styleOverviewCopy('${bpKey}','${type}','${id}');">Copy Styles</li>`;
        if(self.styleOverviewStates.copy.styles !== null && Object.keys(self.styleOverviewStates.copy.styles).length > 0 ) content += `<li onclick="ADMINBRXC.styleOverviewPaste('${bpKey}','${type}','${id}');">Paste Styles</li>`;
        content += `<li onclick="ADMINBRXC.styleOverviewReset('${bpKey}','${type}','${id}');">Reset Styles</li>`;
        content += `</ul>`;
        canvas.innerHTML = content;

    },
    setStylTable: function(type, classId, pseudo){
        const self = this;
        const breakpoints = self.vueState.breakpoints;
        let activeEl;
        (type === "id") ? activeEl = self.vueState.activeElement : activeEl = self.vueGlobalProp.$_getGlobalClass(classId);
        const activeSettings = activeEl.settings;
        const uniqueKeys = self.helpers.stylesByPseudo(activeSettings);
        const existingKeys = [];
        const excludedKeys = ['shadeChildren', 'shadeMode', 'shadeParent', 'shadeType', 'shadeOrder', 'title'];

        // Create Row
        function createRow(originalObj, obj, key, prefix, path = [], nested = false) {
            let hasStyle = false
            // Create the <tr>
            let row = `<tr class="isotope-selector">`;

            if(excludedKeys.includes(key.split(':')[0])) return;
            
            // If value is string, process the <td>
            if (typeof obj[key] === 'string' && !['id', 'name'].includes(key)) {

                // Prevent duplicated rows inside the table
                existingKeys.push(prefix);

                // Remove the breakpoints from the key
                key = key.split(':')[0];

                // Set the row to have styles
                noStyles = false;

                // Parse the CSS Selector
                let cssSelector;
                if (typeof bricksData.elements[self.vueState.activeElement.name].controls[key] !== "undefined" && Array.isArray(bricksData.elements[self.vueState.activeElement.name].controls[key].css) && bricksData.elements[self.vueState.activeElement.name].controls[key].css.length > 0) {
                    cssSelector = bricksData.elements[self.vueState.activeElement.name].controls[key].css[0].property
                } else {
                    switch(prefix){
                        case '_scopedVariables':
                            scopedPath = path.split('.');
                            cssSelector = originalObj[scopedPath[0]][scopedPath[1]].hasOwnProperty('title') ? `${originalObj[scopedPath[0]][scopedPath[1]]['title']} (scoped variable)`: 'Unset (scoped variable)';
                            break;
                        case '_margin':
                        case '_padding':
                            cssSelector = `${prefix.replace('_', '')}-${key}`;
                            break;
                        case '_typography':
                            if(key === "raw") {
                                cssSelector = "color";
                                break;
                            }
                            cssSelector = key;
                            break;
                        default: 
                        cssSelector = `${prefix.replace('_', '')} - ${key}`;
                    }
                }

                // Add the CSS Selector as first <td>
                const control = bricksData.elements[self.vueState.activeElement.name].controls[prefix.split(':')[0]];
                if(!control) return;
                row +=`<td class="brxc-style-overview__css-selectors" data-tab="${(control.hasOwnProperty('tab')) ? control.tab : ''}" data-group="${(control.hasOwnProperty('group')) ? control.group : ''}" data-pseudo="${pseudo}">${cssSelector}</td>`;
                
                // Loop inside each breakpoints
                breakpoints.forEach(bp => {
                    
                    // If the key is the result of a loop
                    if(nested){
                        let custompath = path.split('.');
                        (bp.hasOwnProperty('key') && bp.key === "desktop") ? custompath[0] = prefix.split(':')[0] : custompath[0] = `${prefix.split(':')[0]}:${bp.key}`;
                        (pseudo === "no-pseudo") ? '' : custompath[0] = `${custompath[0]}:${pseudo}`;
                        let target = originalObj;
                        for (let i = 0; i < custompath.length - 1; i++) {
                            if (typeof target[custompath[i]] !== "undefined") target = target[custompath[i]];
                        }
                        const finalPath = custompath.join('.');
                        let value;
                        if((target[custompath[custompath.length - 1]])){
                            value = (target[custompath[custompath.length - 1]]);
                            hasStyle = true;
                        } else {
                            value = '';
                        }
                        
                        row +=`<td><input type="text" placeholder="-" value="${(typeof value === "undefined" || !value.hasOwnProperty(key) || typeof value[key] === "undefined") ? '' : value[key]}" data-path='${finalPath}.${key}' oninput="ADMINBRXC.updateStyleOverviewValue(this.value,this.dataset.path,'${type}','${classId}')" /></td>`;
                    
                    // If the key is in the root of the object
                    } else {
                        let valuePath = (bp.hasOwnProperty('key') && bp.key === "desktop") ? key : `${key}:${bp.key}`;
                        (pseudo !== "no-pseudo") ? valuePath = `${valuePath}:${pseudo}` : '';
                        let value;
                        if(obj[valuePath]) {
                            value = obj[valuePath];
                            hasStyle = true;
                        } else {
                            value = '';
                        };

                        row +=`<td><input type="text" placeholder="-" value="${value}" data-path='${valuePath}' oninput="ADMINBRXC.updateStyleOverviewValue(this.value,this.dataset.path,'${type}','${classId}')" /></td>`;
                    }
                })

                // Add the final <td> to the row
                row += '<td class="brxc-trash-can-col"><div class="disabled-style-icon-table trash-can" data-balloon="Delete" data-balloon-pos="left" onclick="ADMINBRXC.deleteRowStyleOverview(this);"><span class="bricks-svg-wrapper"><i class="fas fa-trash-can"></i></span></div></td></tr>';
            
            // If value is an object, loop inside the object to find a string
            } else if (typeof obj[key] === 'object') {
                const newPath = (path === key) ? key : `${path}.${key}`;
                for(const childKey of Object.keys(obj[key])){
                    createRow(originalObj, obj[key], childKey, prefix, newPath, true); 
                }
            }

            // Add the row to the table
            if(hasStyle) table += row;
            return table
          }
          


        // Create the table
        const theadLabel = (type === "id") ? `<div class="brxc-style-overview__id-tag-wrapper"><span class="brxc-style-overview__id-tag" onclick="ADMINBRXC.vueState.activeClass = undefined;ADMINBRXC.vueState.pseudoClassActive = '';ADMINBRXC.vueState.pseudoClassPopup = false;ADMINBRXC.closeModal(event, event.target, '#brxcStyleOverviewOverlay');">#${(activeEl.settings.hasOwnProperty('_cssId')) ? activeEl.settings._cssId : 'brxe-' + activeEl.id}</span><div class="disabled-style-icon-table" data-balloon="Click to unlock styling on ID level" data-balloon-pos="bottom" onclick="ADMINBRXC.removeLockFromStyleOverview(this);"><span class="bricks-svg-wrapper"><i class="fas fa-lock"></i></span></div></div>` : `<span class="brxc-style-overview__class-tag locked-${self.vueGlobalProp.$_isLocked(activeEl.id)}" onclick="ADMINBRXC.vueState.activeClass = ADMINBRXC.vueGlobalProp.$_getGlobalClass('${activeEl.id}');ADMINBRXC.vueState.pseudoClassActive = '';ADMINBRXC.vueState.pseudoClassPopup = false;ADMINBRXC.closeModal(event, event.target, '#brxcStyleOverviewOverlay');">.${activeEl.name}</span>`;
        const tableClass = (type === "id") ? `<table id="${activeEl.id}" class="GeneratedTable isotope-container${(self.vueState.brxc.showLock || (Object.values(self.globalSettings.classFeatures).includes("disable-id-styles")) && typeof self.vueState.activeClass === "object" && Object.keys(self.vueState.activeClass).length > 0) ? ' brxc-lock-id-styles' : ''}" data-table="id">` : `<table id="${activeEl.id}" class="GeneratedTable isotope-container locked-${self.vueGlobalProp.$_isLocked(activeEl.id)}" data-table="class">`;
        let table = `${tableClass}
          <thead>
            <tr class="isotope-selector always-on">
              <th>${theadLabel}</th>`;
              breakpoints.forEach(bp=> {
                table +=`<th><div class="brxc-breakpoint-wrapper"><div class="brxc-breakpoint-inner"><div class="brxc-group-icon${(self.vueState.breakpointActive === bp.key) ? ' active' : ''}" data-balloon="${bp.label}" data-balloon-pos="bottom">${self.helpers.bpIcons(bp.icon)}</div><div class="brxc-breakpoint-settings" data-key="${bp.key}" onclick="ADMINBRXC.setStyleOverviewBPMenu(this)"><span class="bricks-svg-wrapper"><svg version="1.1" viewBox="0 0 16 16" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" class="bricks-svg" style="rotate: 90deg;"><path d="M3,9.5l-6.55671e-08,-1.77636e-15c-0.828427,-3.62117e-08 -1.5,-0.671573 -1.5,-1.5c3.62117e-08,-0.828427 0.671573,-1.5 1.5,-1.5l-6.55671e-08,1.77636e-15c0.828427,-3.62117e-08 1.5,0.671573 1.5,1.5c3.62117e-08,0.828427 -0.671573,1.5 -1.5,1.5Zm5,0l-6.55671e-08,-1.77636e-15c-0.828427,-3.62117e-08 -1.5,-0.671573 -1.5,-1.5c3.62117e-08,-0.828427 0.671573,-1.5 1.5,-1.5l-6.55671e-08,1.77636e-15c0.828427,-3.62117e-08 1.5,0.671573 1.5,1.5c3.62117e-08,0.828427 -0.671573,1.5 -1.5,1.5Zm5,0l-6.55671e-08,-1.77636e-15c-0.828427,-3.62117e-08 -1.5,-0.671573 -1.5,-1.5c3.62117e-08,-0.828427 0.671573,-1.5 1.5,-1.5l-6.55671e-08,1.77636e-15c0.828427,-3.62117e-08 1.5,0.671573 1.5,1.5c3.62117e-08,0.828427 -0.671573,1.5 -1.5,1.5Z" fill="currentColor" fill-rule="evenodd"></path></svg></span></div><div class="brxc-breakpoint-menu-canvas"></div></div></div></th>`;
              })
              table += `<th class="brxc-trash-can-col"></th>`
        table +=`</tr>
          </thead>
          <tbody>`;
          let noStyles = true;
          
          // Loop inside the values
          uniqueKeys[pseudo].forEach(key =>{

                // Prevent duplicated rows inside the table
                if(existingKeys.includes(key.split(':')[0])) return;

                let prefix = key.split(':')[0];
                // Process the row creation
                createRow(activeSettings, activeSettings, key, prefix, key, false)
          })

          // If there is no styles, print a default row
          if(noStyles) {
            table += `<tr class="isotope-selector"><td class="brxc-no-style-found">No Styles Found.</td>`;
            breakpoints.forEach(bp=> {
                table +=`<td></td>`;
            })
            table += `</tr>`;
        }

        // Add closing tags to the tabls
        table += `</tbody></table>`;

        // Return the table
        return table;
    },
    deleteRowStyleOverview: function(target){
        const tr = target.closest('tr');
        const inputs = tr.querySelectorAll('input');
        const table = target.closest('table');
        inputs.forEach(el =>{
            el.value = '';
            const evt = new Event('input');
            el.dispatchEvent(evt);
        })
        tr.remove();
        Isotope.data(table).arrange()
    },
    removeLockFromStyleOverview: function(target){
        const self = this;
        const panel = document.querySelector('#bricks-panel-element');
        if(!panel) return;
        const icon = panel.querySelector('.disabled-style-icon');
        self.vueState.brxc.showLock = false;
        (icon) ? icon.remove() : '';
        target.closest('table').classList.remove('brxc-lock-id-styles');
    },
    updateStyleOverviewValue: function(value,path, type, classId){
        const self = this;
        let activeEl;
        (type === 'id') ? activeEl = self.vueState.activeElement : activeEl = self.vueGlobalProp.$_getGlobalClass(classId);
        const activeSettings = activeEl.settings;

        if(path){
            path = path.split('.')

            let target = activeSettings;

            if(!value || value === "") {
                for (let i = 0; i < path.length - 1; i++) {
                    if(target.hasOwnProperty(path[i])) target = target[path[i]];
                }

                if (typeof target[path[path.length - 1]] !== "undefined") delete target[path[path.length - 1]];
                for(const key of Object.keys(target)){
                    if (typeof target[key] === "object" && Object.keys(target[key]).length === 0) delete target[key];
                }
            } else {
                for (let i = 0; i < path.length - 1; i++) {
                    if (!target[path[i]]) target[path[i]] = {};
                    target = target[path[i]];
                }
                target[path[path.length - 1]] = value;
            }
        }
    },
    setStyleOverview: function(pseudo){
        const self = this;
        self.styleOverviewStates.pseudo = pseudo === "no-pseudo" ? '' : pseudo;  
        const canvas = document.querySelector('#brxcStyleOverviewOverlay #brxcStyleOverviewCanvas');

        function hasStyle(){
            let hasPseudo = false;
            const activeElement = self.vueState.activeElement;
            for(const key of Object.keys(activeElement.settings)){
                const arr = key.split(':');
                if(arr[1] === undefined && self.helpers.isCSSControlKey(arr[0])) hasPseudo = true;
            }

            if(hasPseudo === true) return true;

            const cls = (activeElement.settings.hasOwnProperty('_cssGlobalClasses') && Array.isArray(activeElement.settings._cssGlobalClasses) && activeElement.settings._cssGlobalClasses.length > 0) ? activeElement.settings._cssGlobalClasses : false;
            if(cls){
                cls.forEach(el => {
                    const obj = self.vueGlobalProp.$_getGlobalClass(el);
                    for(const key of Object.keys(obj.settings)){
                        const arr = key.split(':');
                        if(arr[1] === undefined && self.helpers.isCSSControlKey(arr[0])) hasPseudo = true;
                    }
                })
            }

            if(hasPseudo === true) return true;

            return false;
        }
        function hasPseudoStyle(pseudo){
            let hasPseudo = false;
            const activeElement = self.vueState.activeElement;
            for(const key of Object.keys(activeElement.settings)){
                if(JSON.stringify(key).includes(pseudo)) hasPseudo = true;
            }
            if(hasPseudo === true) return true;

            const cls = (activeElement.settings.hasOwnProperty('_cssGlobalClasses') && Array.isArray(activeElement.settings._cssGlobalClasses) && activeElement.settings._cssGlobalClasses.length > 0) ? activeElement.settings._cssGlobalClasses : false;
            if(cls){
                cls.forEach(el => {
                    const obj = self.vueGlobalProp.$_getGlobalClass(el);
                    for(const key of Object.keys(obj.settings)){
                        if(JSON.stringify(key).includes(pseudo)) hasPseudo = true;
                    }
                })
            }

            if(hasPseudo === true) return true;

            return false;

        }

        let content = '';
        //pseudo
        content += `<div class="brxc-overlay__panel-switcher-wrapper style-overview">
                        <input type="radio" id="style-overview-no-pseudo" name="style-overview-switch" class="brxc-input__radio" onclick="ADMINBRXC.setStyleOverview('no-pseudo');"${(pseudo === 'no-pseudo') ? ' checked=""' : ''}>
                        <label for="style-overview-no-pseudo" class="brxc-input__label${hasStyle() ? ' has-style' : ''}">No Pseudo</label>`;
        self.vueState.pseudoClasses.forEach(el => {
            content += `<input type="radio" id="style-overview-${el.substr(1, el.length - 1)}" name="style-overview-switch" class="brxc-input__radio" onclick="ADMINBRXC.setStyleOverview('${el.replace(':','')}');"${(pseudo === el.replace(':','')) ? ' checked=""' : ''}>
                        <label for="style-overview-${el.substr(1, el.length - 1)}" class="brxc-input__label${hasPseudoStyle(el) ? ' has-style' : ''}"><span>${el}</span></label>`;
        })
        content += `</div>`;

        content += '<div class="isotope-wrapper--late" data-gutter="0" data-filter-layout="fitRows" style="--col:1">';
        //search
        content += '<div class="brxc-overlay__search-box"><div class="iso-search-icon"><i class="bricks-svg ti-search"></i></div><input type="search" class="iso-search" name="typography-search" placeholder="Type here to filter the CSS properties" data-type="textContent"><div class="iso-reset"><i class="bricks-svg ti-close"></i></div></div>';
        
        //classes
        let classes;
        (self.vueState.activeElement.settings.hasOwnProperty('_cssGlobalClasses') && self.vueState.activeElement.settings._cssGlobalClasses) ? classes = self.vueState.activeElement.settings._cssGlobalClasses : classes = false;
        content += '<div class="brxc-style-overview__class-wrapper">';
        if(classes && Array.isArray(classes) && classes.length > 0){
            classes.forEach(el => {
                const cls = self.vueGlobalProp.$_getGlobalClass(el);
                content += `<a class="brxc-style-overview__class-btn locked-${self.vueGlobalProp.$_isLocked(cls.id)}" onclick="document.getElementById('${cls.id}').scrollIntoView();">.${cls.name}</a>`;
            })
        }
        content += '</div>';

        // id table
        content += self.setStylTable("id", false, pseudo);

        //class tables
        if(classes && Array.isArray(classes) && classes.length > 0){
            classes.forEach(el => {
                const cls = self.vueGlobalProp.$_getGlobalClass(el);
                content += self.setStylTable("class", el, pseudo);
            })
        }
        content += '</div>';

        canvas.innerHTML = content;

        // isotope

        let filterRes = true;
        let filterSearch = true;
        let qsRegex
        let isotopeGutter;
        let isotopeLayoutHelper;
        const isotopeWrappers = document.querySelectorAll('#brxcStyleOverviewOverlay .isotope-wrapper--late')
        isotopeWrappers.forEach(wrapper => {
            const isotopeContainers = wrapper.querySelectorAll('.isotope-container');
            isotopeContainers.forEach(isotopeContainer => {
                const isotopeSelector = wrapper.querySelectorAll('.isotope-selector');
                const isoSearch = wrapper.querySelector('input[type="search"].iso-search');
                const isoSearchType = isoSearch.dataset.type;
                const isoSearchReset = wrapper.querySelector('.iso-reset');
                if (wrapper.dataset.gutter) {
                    isotopeGutter = parseInt(wrapper.dataset.gutter);
                    wrapper.style.setProperty('--gutter', isotopeGutter + 'px');
                    isotopeSelector.forEach(elm => elm.style.paddingBottom = isotopeGutter + 'px');
                } else {
                    isotopeGutter = 0;
                };

                if (wrapper.dataset.filterLayout) {
                    isotopeLayoutHelper = wrapper.dataset.filterLayout;
                } else {
                    isotopeLayoutHelper = 'fitRows';
                };
                

                // init Isotope
                const isotopeOptions = {
                    itemSelector: '.isotope-selector',
                    layoutMode: isotopeLayoutHelper,
                    transitionDuration: 0,
                    getSortData: {
                        name: (el) => {
                            const selector = el.querySelector('td');
                            if (selector) return selector.textContent;
                            //if(selector.textContent) return selector.textContent;
                        },
                     },
                    filter: function(itemElem1, itemElem2) {
                        const itemElem = itemElem1 || itemElem2;

                        return qsRegex ? itemElem.textContent.match(qsRegex) || itemElem.classList.contains('always-on') : true;
 
                    },
                };


                // Set the correct layout
                switch (isotopeLayoutHelper) {
                    case 'fitRows':
                    isotopeOptions.fitRows = {
                        gutter: isotopeGutter
                    };
                    break;
                    case 'masonry':
                    isotopeOptions.masonry = {
                        gutter: isotopeGutter
                    };
                    break;
                }

                // Search Filter
                const iso = new Isotope(isotopeContainer, isotopeOptions);
                
                if (isoSearch) {
                    isoSearch.addEventListener('keyup', self.debounce(() => {
                        qsRegex = new RegExp(isoSearch.value, 'gi');
                        isotopeContainer.style.display = "table";
                        iso.arrange({
                            sortBy: 'name',
                            sortAscending: true
                         });
                    }, 100));
                }
                if (isoSearchReset) {
                    isoSearchReset.onclick = () => {
                        isotopeContainer.style.display = "table"
                        isoSearch.value = '';
                        const clickEvent = new Event('keyup');
                        isoSearch.dispatchEvent(clickEvent);
                    }
                }

                // Hide if empty
                iso.on('arrangeComplete', (event) => {
                    let i = 1;
                    if (event.length > 0){
                        event.forEach(e =>{
                            e.element.classList.remove('even');
                            if(i % 2 == 0) e.element.classList.add('even');
                            i++;
                        })
                    }
                    
                    if (event.length === 1 ) {
                        isotopeContainer.style.display = "none";
                    } else {
                        isotopeContainer.style.display = "table";
                    }
                    
                })
                iso.arrange({
                    sortBy: 'name',
                    sortAscending: true
                 });

            })
            
        })

        //click 
        const selectors = document.querySelectorAll('.brxc-style-overview__css-selectors');
        selectors.forEach(el => {
            const table = el.closest('table');
            el.addEventListener('mouseenter', () => {
                self.vueState.brxc.clickedOnLeftPanelShortcuts = true;
            })
            el.addEventListener('mouseleave', () => {
                self.vueState.brxc.clickedOnLeftPanelShortcuts = false;
            })
            el.addEventListener('click', (event) => {
                const tab = el.dataset.tab;
                const group = el.dataset.group;
                const pseudo = el.dataset.pseudo;
                (table.dataset.table === "class") ? self.vueState.activeClass = self.vueGlobalProp.$_getGlobalClass(table.id) : self.vueState.activeClass = undefined;
                if (pseudo === 'no-pseudo') {
                    self.vueState.pseudoClassActive = '';
                    self.vueState.pseudoClassPopup = false;
                } else {
                    self.vueState.pseudoClassActive = `:${pseudo}`;
                    self.vueState.pseudoClassPopup = true;
                }
                self.vueState.activePanelGroup = group;
                self.vueState.activePanelTab = tab;
                self.closeModal(event, event.target, '#brxcStyleOverviewOverlay');

            })
        })

        //autocomplete
        const inputs = document.querySelectorAll('#brxcStyleOverviewOverlay td input')
        inputs.forEach(el => {
            el.addEventListener('focus', () => {
                self.autocomplete(el, self.cssVariables, "style", true);
            });
        })
    },
    setStyleOverviewCSS: function(){
        const self = this;
        const canvas = document.querySelector('#brxcStyleOverviewOverlay #brxcStyleOverviewCSSCanvas');
        let content = '';
        
        //classes
        let classes;
        let activeEl = self.vueState.activeElement;
        (activeEl.settings.hasOwnProperty('_cssGlobalClasses') && activeEl.settings._cssGlobalClasses) ? classes = activeEl.settings._cssGlobalClasses : classes = false;

        // id table
        content += `<div class="brxc-style-overview__id-tag-wrapper"><span class="brxc-style-overview__id-tag" data-balloon="Click to jump on the ID styles" data-balloon-pos="right" onclick="ADMINBRXC.vueState.activeClass = undefined;ADMINBRXC.vueState.pseudoClassActive = '';ADMINBRXC.vueState.pseudoClassPopup = false;ADMINBRXC.closeModal(event, event.target, '#brxcStyleOverviewOverlay');">#${(activeEl.settings.hasOwnProperty('_cssId')) ? activeEl.settings._cssId : 'brxe-' + activeEl.id}</span></div>`;
        content += self.setStyleCSS("element", activeEl, false);

        //class tables
        if(classes && Array.isArray(classes) && classes.length > 0){
            classes.forEach(el => {
                activeEl = self.vueGlobalProp.$_getGlobalClass(el);
                content += `<div class="brxc-style-overview__id-tag-wrapper"><span class="brxc-style-overview__class-tag locked-${self.vueGlobalProp.$_isLocked(activeEl.id)}" data-balloon="Click to jump on this Class styles" data-balloon-pos="right" onclick="ADMINBRXC.vueState.activeClass = ADMINBRXC.vueGlobalProp.$_getGlobalClass('${activeEl.id}');ADMINBRXC.vueState.pseudoClassActive = '';ADMINBRXC.vueState.pseudoClassPopup = false;ADMINBRXC.closeModal(event, event.target, '#brxcStyleOverviewOverlay');">.${activeEl.name}</span></div>`;
                content += self.setStyleCSS("globalClass", activeEl, [self.vueState.activeElement.name]);
            })
        }
        content += '</div>';

        canvas.innerHTML = content;
        const textAreas = document.querySelectorAll('textarea.brxc-style-overview-css');
        textAreas.forEach(textarea => {
            const dataOptions = { indent_size: 2, space_in_empty_paren: false }
            const dataObj = textarea.textContent;

            const options = self.codeMirrorOptions(textarea);
            const MyCM = CodeMirror.fromTextArea(textarea, self.codeMirrorOptions(options));
            MyCM.setValue(css_beautify(dataObj, dataOptions));
            MyCM.setOption('readOnly',  true);

        })
    },
    setStyleCSS: function(type, activeEl, name){
        const self = this;
        content = `<div class="brxc-codemirror__wrapper"><textarea class="brxc-style-overview-css">${self.vueGlobalProp.$_generateCss(type, activeEl, name)}</textarea>`;
        content += `<div class="brxc-overlay__action-btn" style="margin-left: auto" onclick="ADMINBRXC.copytoClipboard(this, this.previousElementSibling.CodeMirror.getValue(), 'Copied!', 'Copy to Clipboard')"><span>Copy to Clipboard</span></div></div>`;

        return content;
    },
    setContextualMenuItems: function(){
        const self = this;
        let contextualMenu = document.querySelector("#bricks-builder-context-menu").children[0].children[0];
        let icons = '';
        if(self.helpers.isBuilderTweaksTabActive('structure-panel')){
            (Object.values(self.globalSettings.structurePanelContextualMenu).includes('hide-element')) ? icons += `<li id="hideElement" onClick='ADMINBRXC.hideElement()'>Hide Element</li>`: '';
            (Object.values(self.globalSettings.structurePanelContextualMenu).includes('move-element')) ? icons += `<li id="moveElement"><span class="label">Move</span><div class="buttons"><span class="action" data-balloon="Indent Left" data-balloon-pos="top" onClick="ADMINBRXC.moveElement('left');setTimeout(() => {ADMINBRXC.vueState.showContextMenu = ADMINBRXC.vueState.activeElement.id, 1});"><i class="fas fa-arrow-left"></i></span><span class="action" data-balloon="Indent Right" data-balloon-pos="top" onClick="ADMINBRXC.moveElement('right');setTimeout(() => {ADMINBRXC.vueState.showContextMenu = ADMINBRXC.vueState.activeElement.id, 1});"><i class="fas fa-arrow-right"></i></span><span class="action" data-balloon="Move Up" data-balloon-pos="top" onClick="ADMINBRXC.moveElement('top');setTimeout(() => {ADMINBRXC.vueState.showContextMenu = ADMINBRXC.vueState.activeElement.id, 1});"><i class="fas fa-arrow-up"></i></span><span class="action" data-balloon="Move Down" data-balloon-pos="top-right" onClick="ADMINBRXC.moveElement('down');setTimeout(() => {ADMINBRXC.vueState.showContextMenu = ADMINBRXC.vueState.activeElement.id, 1});"><i class="fas fa-arrow-down"></i></span></div></li>`: '';
            (Object.values(self.globalSettings.structurePanelContextualMenu).includes('extend-classes-and-styles')) ? icons += `<li id="brxcExpandClasses" onClick='ADMINBRXC.openExtendClassModal(event,"#brxcExtendModal")'>Extend Classes & Styles</li>`: '';
            (Object.values(self.globalSettings.structurePanelContextualMenu).includes('find-and-replace-styles')) ? icons += `<li id="brxcFindandReplaceStyles" onClick='ADMINBRXC.openFindReplaceModal(event,false, "#brxcFindReplaceModal")'>Find & Replace Styles</li>`: '';
            (Object.values(self.globalSettings.structurePanelContextualMenu).includes('class-converter')) ? icons += `<li id="brxcBEMConverter" onClick='ADMINBRXC.setClassConverter();ADMINBRXC.openModal(false, "#brxcClassConverterOverlay")';'><span class="label">Class Converter</span></li>` : '';
            (Object.values(self.globalSettings.structurePanelContextualMenu).includes('style-overview')) ? icons += `<li id="brxcStyleOverview" onClick='ADMINBRXC.setStyleOverview("no-pseudo");ADMINBRXC.setStyleOverviewCSS();ADMINBRXC.openModal(false, "#brxcStyleOverviewOverlay", document.querySelector("#brxcStyleOverviewOverlay input[type=search]"));this.style.display = "none"; this.style.display = "flex";'>Style Overview</li>` : '';
            (Object.values(self.globalSettings.structurePanelContextualMenu).includes('component-class-manager')) ? icons += `<li id="brxcComponentClassManager" onClick='ADMINBRXC.openClassManager("component");'>Component Class Manager</li>` : '';
            icons += `<li class="sep"></li>`;
        }

        contextualMenu.insertAdjacentHTML("beforeBegin", icons);
    },
    toggleTagsState: function (){
        const self = this;
        if(self.vueState.brxc.tagsView === 'developer'){
            self.vueState.brxc.tagsView = 'none';
        } else if (self.vueState.brxc.tagsView === 'none'){
            self.vueState.brxc.tagsView = 'overview'
        }  else if (self.vueState.brxc.tagsView === 'overview'){
            self.vueState.brxc.tagsView = 'developer';
        }
        self.showTagInStructurePanel()
    },
    structureHelperStates:{
        expanded: true,
        showTag: false,
        showId: false,
        highlight: false,
        activeFilter: false,
        filterArr: [],
    },
    setStructureHelper: function(){
        const self = this;
        self.setStructureHelperList();
        if(self.structureHelperStates.activeFilter){
            const activeLi = document.querySelector(`#brxcStructureHelper .brxc-overlay__pannel-col--left li[data-id="${self.structureHelperStates.activeFilter}"]`);
            if(activeLi) activeLi.click();
        }
    },
    setStructureHelperList: function(){
        const self = this;
        const canvas = document.querySelector('#structurPanelList');
        if(!canvas) return;

        let content = `<div class="brxc-structure-panel-list__header">
                        <span>Structure</span>
                        <div class="actions">`;
        self.structureHelperStates.expanded !== true ? content += `<div class="bricks-svg-wrapper active" data-balloon="Expand" data-balloon-pos="bottom-right" onclick="ADMINBRXC.structureHelperStates.expanded = true;ADMINBRXC.setStructureHelperList()"><i class="fas fa-up-right-and-down-left-from-center"></i></div>` : content += `<div class="bricks-svg-wrapper" data-balloon="Collapse" data-balloon-pos="bottom-right" onclick="ADMINBRXC.structureHelperStates.expanded = false;ADMINBRXC.setStructureHelperList()"><i class="fa-solid fa-down-left-and-up-right-to-center"></i></i></i></div>`;
        content += `<div class="bricks-svg-wrapper${ADMINBRXC.structureHelperStates.showTag ? ' active' : ''}" data-balloon="${ADMINBRXC.structureHelperStates.showTag ? 'Hide HTML tags' : 'Show HTML tags'}" data-balloon-pos="bottom-right" onclick="ADMINBRXC.structureHelperStates.showTag = ${ADMINBRXC.structureHelperStates.showTag ? false : true};ADMINBRXC.setStructureHelperList()"><i class="fas fa-code"></i></div>`;
        content += `<div class="bricks-svg-wrapper${ADMINBRXC.structureHelperStates.showId ? ' active' : ''}" data-balloon="${ADMINBRXC.structureHelperStates.showId ? 'Hide Ids' : 'Show Ids'}" data-balloon-pos="bottom-right" onclick="ADMINBRXC.structureHelperStates.showId = ${ADMINBRXC.structureHelperStates.showId ? false : true};ADMINBRXC.setStructureHelperList()"><i class="fas fa-id-card"></i></div>`;
        content += `<div class="bricks-svg-wrapper${ADMINBRXC.structureHelperStates.highlight ? ' active' : ''}" data-balloon="${ADMINBRXC.structureHelperStates.highlight ? 'Disable Highlight' : 'Enable Highlight'}" data-balloon-pos="bottom-right" onclick="ADMINBRXC.structureHelperStates.highlight = ${ADMINBRXC.structureHelperStates.highlight ? false : true};ADMINBRXC.setStructureHelperList()"><i class="fas fa-eye${!ADMINBRXC.structureHelperStates.highlight ? '-slash' : ''}"></i></div>`;
        content += `</div></div>`; 
        content += self.structureHelperPreview();

        canvas.innerHTML = content;
        const li = canvas.querySelectorAll('li');
        if(!li || li.length < 1) return;
        li.forEach(el => {
            el.addEventListener('click', (e) => {
                const obj = self.vueGlobalProp.$_getElementObject(el.dataset.id);
                if(!obj) return;
                self.vueState.activePanel = "element";
                self.vueState.activePanelTab = "content";
                self.vueState.activeId = obj.id;
                self.vueState.activeElement = obj;
                self.closeModal(e, e.target, '#brxcStructureHelper');

            })
        })
    },
    structureHelperPreview: function(){
        const self = this;
        const contentType = self.helpers.getTemplateType();
        const content = Array.from(self.vueState[contentType]).filter(el => el && el.parent === 0);


        function addElement(element, level){
            const check = Array.from(self.structureHelperStates.filterArr).find(el => el && el.hasOwnProperty('id') && el.id === element.id);
            let content = '';
            content += `
            <li class="${check || self.structureHelperStates.highlight ? 'active' : ''}" data-id="${element.id}"style="--margin:${level}">
                <div class="icon"><i class="${bricksData.elements[element.name].icon}"></i></div>`;
                if(ADMINBRXC.structureHelperStates.showTag) {
                    const obj = self.vueGlobalProp.$_getElementObject(element.id);
                    const tag = self.helpers.getElementTag(obj);
                    content += `<span class="show-tag">${tag}</span>`;
                }
                content += `<span>${element.label ? element.label : bricksData.elements[element.name].label}</span>`;
                if(ADMINBRXC.structureHelperStates.showId) {
                    const elId = element.settings.hasOwnProperty('_cssId') ? element.settings._cssId : `brxe-${element.id}`;
                    content += `<span class="show-id">#${elId}
                                <div class="copy-id-icon" data-balloon="Copy ID to Clipboard" data-balloon-pos="top-right" onclick="event.stopPropagation();ADMINBRXC.copytoClipboardSimple('#${elId}','#${elId} successfully copied to clipboard')"><i class="fas fa-clipboard"></i></div>
                                </span>`;
                }
            content +=  `</li>`;
            return content;
        }

        function checkchildren(element, level){
            if (element.children.length < 1) return;
            level++;
            element.children.forEach(id => {
                const settings = self.vueGlobalProp.$_getElementObject(id);
                output += addElement(settings, level);
                checkchildren(settings, level);
            })
        }

        let output = self.structureHelperStates.expanded === true ? '<ul class="brxc-structure-list__wrapper expanded">' : `<ul class="brxc-structure-list__wrapper collapsed">`;
        content.forEach(el => {
            output += addElement(el, 0);
            checkchildren(el, 0);
        })
        output += '</ul>';

        return output;
    },
    shCheckProp: function(event, prop){
        const self = this;
        self.helpers.setActiveItem('#brxcStructureHelper .brxc-overlay__pannel-col--left li', event);
        const contentType = self.helpers.getTemplateType();
        const content = self.vueState[contentType];

        // Function
        self.structureHelperStates.filterArr = Array.from(content).filter(el => el && Object.keys(el.settings).some(function(k){ return ~k.indexOf(prop) }));
        self.setStructureHelperList();
        self.structureHelperStates.activeFilter = event.target.dataset.id;
    },
    shCheckPropArray: function(event, prop){
        const self = this;
        self.helpers.setActiveItem('#brxcStructureHelper .brxc-overlay__pannel-col--left li', event);
        const contentType = self.helpers.getTemplateType();

        // Classes
        const contentArray = self.vueState[contentType];
        const usedGlobalClasses = contentArray
        .flatMap(el => el && el.settings.hasOwnProperty('_cssGlobalClasses') ? el.settings._cssGlobalClasses : []);

        const corrispondingGlobalClasses = self.vueState.globalClasses
        .filter(el => usedGlobalClasses.includes(el.id) && Array.isArray(el.settings[prop]) && el.settings[prop].length > 0)
        .map(el => el.id);

        const corrispondingElements = contentArray
        .filter(el => el && el.settings.hasOwnProperty('_cssGlobalClasses') && corrispondingGlobalClasses.some(value => el.settings._cssGlobalClasses.includes(value)));

        // Function
        self.structureHelperStates.filterArr = contentArray
        .filter(el => (
            Array.isArray(corrispondingElements) && corrispondingElements.length > 0 && corrispondingElements.includes(el)) 
            || (el && el.settings.hasOwnProperty(prop) && Array.isArray(el.settings[prop]) && el.settings[prop].length > 0));

        self.setStructureHelperList();
        self.structureHelperStates.activeFilter = event.target.dataset.id;
    },
    shSearchValueInKey: function(event, prop, value){
        const self = this;
        self.helpers.setActiveItem('#brxcStructureHelper .brxc-overlay__pannel-col--left li', event);
        const contentType = self.helpers.getTemplateType();
   
        // Classes
        const contentArray = self.vueState[contentType];
        const usedGlobalClasses = contentArray
        .flatMap(el => el && el.settings.hasOwnProperty('_cssGlobalClasses') ? el.settings._cssGlobalClasses : []);

        const corrispondingGlobalClasses = self.vueState.globalClasses
        .filter(el => usedGlobalClasses.includes(el.id) && Array.isArray(el.settings[prop]) && el.settings[prop].length > 0 && JSON.stringify(el.settings[prop]).includes(value))
        .map(el => el.id);

        const corrispondingElements = contentArray
        .filter(el => el && el.settings.hasOwnProperty('_cssGlobalClasses') && corrispondingGlobalClasses.some(value => el.settings._cssGlobalClasses.includes(value)));

        // Function
        self.structureHelperStates.filterArr = contentArray
        .filter(el => (
            Array.isArray(corrispondingElements) && corrispondingElements.length > 0 && corrispondingElements.includes(el)) 
            || (el && el.settings.hasOwnProperty(prop) && Array.isArray(el.settings[prop]) && el.settings[prop].length > 0) && JSON.stringify(el.settings[prop]).includes(value));
        
        self.setStructureHelperList();
        self.structureHelperStates.activeFilter = event.target.dataset.id;
    },
    shSearchValueInKeyObj: function(event, prop, value){
        const self = this;
        self.helpers.setActiveItem('#brxcStructureHelper .brxc-overlay__pannel-col--left li', event);
        const contentType = self.helpers.getTemplateType();
        const content = self.vueState[contentType];

        // Function
        self.structureHelperStates.filterArr = Array.from(content).filter(el => el && el.settings.hasOwnProperty(prop) && JSON.stringify(el.settings[prop]).includes(value));
        self.setStructureHelperList();
        self.structureHelperStates.activeFilter = event.target.dataset.id;
    },
    shSearchValue: function(event, key, value){
        const self = this;
        self.helpers.setActiveItem('#brxcStructureHelper .brxc-overlay__pannel-col--left li', event);
        const contentType = self.helpers.getTemplateType();
        const content = self.vueState[contentType];

        // Function
        self.structureHelperStates.filterArr = Array.from(content).filter(el => el && el.settings.hasOwnProperty(key) && el.settings[key] === value);
        self.setStructureHelperList();
    },
    shMissingProp: function(event, prop, missing){
        const self = this;
        self.helpers.setActiveItem('#brxcStructureHelper .brxc-overlay__pannel-col--left li', event);
        const contentType = self.helpers.getTemplateType();
        const content = self.vueState[contentType];

        // Function
        self.structureHelperStates.filterArr = Array.from(content).filter(el => el && el.settings.hasOwnProperty(prop) && !el.settings[prop].hasOwnProperty(missing));
        self.setStructureHelperList();
        self.structureHelperStates.activeFilter = event.target.dataset.id;
    },
    shCheckAriaAttributes: function(event){
        const self = this;
        self.helpers.setActiveItem('#brxcStructureHelper .brxc-overlay__pannel-col--left li', event);
        const contentType = self.helpers.getTemplateType();
        const content = self.vueState[contentType];

        // Function
        function checkStyles(settings){
            if(settings.hasOwnProperty('_attributes') && Array.isArray(settings['_attributes']) && settings['_attributes'].length > 0) return false;
            let hasStyles = false
            settings['_attributes'].forEach(el => {
                if(el.name.startsWith('aria-')) hasStyles = true;
            })
            return hasStyles;
        }
        self.structureHelperStates.filterArr = Array.from(content).filter(el => el && checkStyles(el.settings));
        self.setStructureHelperList();
        self.structureHelperStates.activeFilter = event.target.dataset.id;
    },
    shHasIDStyles: function(event){
        const self = this;
        self.helpers.setActiveItem('#brxcStructureHelper .brxc-overlay__pannel-col--left li', event);
        const contentType = self.helpers.getTemplateType();
        const content = self.vueState[contentType];

        // Function
        function checkStyles(settings){
            let hasStyles = false;
            for(const key of Object.keys(settings)){
                if(self.helpers.isCSSControlKey(key)){
                    hasStyles = true;
                }
            }
            return hasStyles;
        }
        self.structureHelperStates.filterArr = Array.from(content).filter(el => el && checkStyles(el.settings));
        self.setStructureHelperList();
        self.structureHelperStates.activeFilter = event.target.dataset.id;
    },
    shHasPseudoStyles: function(event){
        const self = this;
        self.helpers.setActiveItem('#brxcStructureHelper .brxc-overlay__pannel-col--left li', event);
        const contentType = self.helpers.getTemplateType();
        const content = self.vueState[contentType];

        // Function
        const pseudos = self.vueState.pseudoClasses;
        function checkStyles(settings){
            let hasStyles = false;
            for(const key of Object.keys(settings)){
                const parsedKey = JSON.stringify(key)
                pseudos.forEach(pseudo => {
                    if(parsedKey.includes(pseudo)){
                        hasStyles = true;
                    }
                })
                
            }
            return hasStyles;
        }
        self.structureHelperStates.filterArr = Array.from(content).filter(el => el && checkStyles(el.settings));
        self.setStructureHelperList();
        self.structureHelperStates.activeFilter = event.target.dataset.id;
    },
    shHasBreakpointStyles: function(event){
        const self = this;
        self.helpers.setActiveItem('#brxcStructureHelper .brxc-overlay__pannel-col--left li', event);
        const contentType = self.helpers.getTemplateType();
        const content = self.vueState[contentType];

        // Function
        const bps = self.vueState.breakpoints;
        function checkStyles(settings){
            let hasStyles = false;
            for(const key of Object.keys(settings)){
                const parsedKey = JSON.stringify(key)
                bps.forEach(bp => {
                    if(parsedKey.includes(`:${bp.key}`)){
                        hasStyles = true;
                    }
                })
                
            }
            return hasStyles;
        }
        self.structureHelperStates.filterArr = Array.from(content).filter(el => el && checkStyles(el.settings));
        self.setStructureHelperList();
        self.structureHelperStates.activeFilter = event.target.dataset.id;
    },
    shHasStaticColors: function(event){
        const self = this;
        self.helpers.setActiveItem('#brxcStructureHelper .brxc-overlay__pannel-col--left li', event);
        const contentType = self.helpers.getTemplateType();
        const content = self.vueState[contentType];

        // Function
        const bps = self.vueState.breakpoints;
        function checkStyles(settings){
            let hasStyles = false;
            const parsedSettings = JSON.stringify(settings);
            ['"hex":"#', '"rgb":"rgb', '"hsl":"hsl'].forEach(el => {
                if(parsedSettings.includes(el)) hasStyles = true;
            })
            
            return hasStyles;
        }
        self.structureHelperStates.filterArr = Array.from(content).filter(el => el && checkStyles(el.settings));
        self.setStructureHelperList();
        self.structureHelperStates.activeFilter = event.target.dataset.id;
    },
    shConditionDateTime: function(event){
        const self = this;
        self.helpers.setActiveItem('#brxcStructureHelper .brxc-overlay__pannel-col--left li', event);
        const contentType = self.helpers.getTemplateType();
        const content = self.vueState[contentType];;

        // Function
        function checkStyles(settings){
            let hasStyles = false;
            const parsedSettings = JSON.stringify(settings);
            ['"key":"weekday"', '"key":"date"', '"key":"time"', '"key":"datetime"'].forEach(el => {
                if(parsedSettings.includes(el)) hasStyles = true;
            })
            
            return hasStyles;
        }
        
        
        self.structureHelperStates.filterArr = Array.from(content).filter(el => el && el.settings.hasOwnProperty('_conditions') && Array.isArray(el.settings['_conditions']) && el.settings['_conditions'].length > 0 && checkStyles(el.settings));
        self.setStructureHelperList();
        self.structureHelperStates.activeFilter = event.target.dataset.id;
    },
    shNonConsecutiveHeaders: function(event){
        const self = this;
        self.helpers.setActiveItem('#brxcStructureHelper .brxc-overlay__pannel-col--left li', event);
        const contentType = self.helpers.getTemplateType();
        
        const content = [];

        function checkChildren(id,arr){
            const obj = self.vueGlobalProp.$_getElementObject(id);
            if(obj.name === "heading") arr.push(obj);
            if(obj.hasOwnProperty('children') && Array.isArray(obj.children) && obj.children.length > 0){
                obj.children.forEach(childId => {
                    checkChildren(childId, arr);
                })
            } 
        }
        const tempContent = Array.from(self.vueState[contentType]).filter(el => el && el.hasOwnProperty('parent') && el.parent === 0);
        if (!tempContent || tempContent.length < 1) return;

        tempContent.forEach(el => {
            const obj = self.vueGlobalProp.$_getElementObject(el.id);
            checkChildren(obj.id, content);
        })
        
        let oldHeading = false;
        // Function
        const bps = self.vueState.breakpoints;
        function checkStyles(settings){
            let hasStyles = false;
            if(oldHeading === false){
                oldHeading = settings.tag ? parseInt(settings.tag.substr(1)) : parseInt(bricksData.elements.heading.tag.substr(1))
            } else {
                const newHeading = settings.tag ? parseInt(settings.tag.substr(1)) : parseInt(bricksData.elements.heading.tag.substr(1))
                if(newHeading - oldHeading > 1) hasStyles = true;
                oldHeading = newHeading;
            }

            return hasStyles;
        }
        self.structureHelperStates.filterArr = Array.from(content).filter(el => el && checkStyles(el.settings));
        self.setStructureHelperList();
        self.structureHelperStates.activeFilter = event.target.dataset.id;
    },
    setHeaderStructurePanel: function(){
        const self = this;
        let header = document.querySelector("#bricks-structure #bricks-panel-header ul.actions li");
        let icons = '';
        // if(header && Object.values(self.globalSettings.structurePanelIcons).includes('find-and-replace')){
        //     icons += `<li data-balloon="Find & replace" onClick='ADMINBRXC.openFindReplaceModal(event,true, "#brxcFindReplaceModal")' data-balloon-pos="bottom-right"><span class="bricks-svg-wrapper"><!--?xml version="1.0" encoding="UTF-8"?--><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 96 960 960" class="bricks-svg"><path xmlns="http://www.w3.org/2000/svg" d="M138 484q18-110 103.838-182T440 230q75 0 133 30.5t98 82.5v-98h72v239H503v-71h100q-27-42-70.5-65T440 325q-72.187 0-130.093 43.5Q252 412 234 484h-96Zm674 492L615 780q-34 27-78 43.5T440.217 840Q367 840 308.5 813 250 786 209 734v93h-72V588h240v71H271q28.269 41.15 72.541 64.075Q387.812 746 440 746q72.102 0 127.444-44.853T642 588h96q-5 33-19 65.5T684 713l197 196-69 67Z"/></svg></span></li>`;
        // }
        if(header && Object.values(self.globalSettings.structurePanelIcons).includes('tags')){
            icons += `<li data-balloon="Show Elements Tag" onClick='ADMINBRXC.toggleTagsState();' data-balloon-pos="bottom"><span class="bricks-svg-wrapper"><i class="fas fa-tag"></i></span></li>`;
        }
        if(header && Object.values(self.globalSettings.structurePanelIcons).includes('structure-helper')){
            icons += `<li data-balloon="Open Structure Helper${self.globalSettings.keyboardShortcuts.hasOwnProperty('structureHelper') ? ` (ctrl+cmd+${self.globalSettings.keyboardShortcuts.structureHelper})` : '' }" onClick='ADMINBRXC.setStructureHelper();ADMINBRXC.openModal(false, "#brxcStructureHelper");' data-balloon-pos="bottom"><span class="bricks-svg-wrapper"><i class="fas fa-circle-question"></i></span></li>`;
        }
        header.insertAdjacentHTML("beforeBegin", icons);
    },
    setControlsOptions: function(){
        const self = this;
        const allElements = [];
        const allControls = [];

        for (const [key, value] of Object.entries(bricksData.elements)) {
            const el1 = key;
            const el2 = value;
            allElements.push([el2.name,el2.label]);
            for (const [key, value] of Object.entries(bricksData.elements[el1].controls)) {
                if (typeof value !== "undefined" && value.hasOwnProperty('css')) self.CSScontrolKeys.push(key)
                if (key.startsWith('_') && value.hasOwnProperty('css')) {
                    if(key === "_flexDirection"){
                        allControls.push([key,"Flex direction"]);
                    } else if(key === "_innerContainerMargin"){
                        allControls.push([key,"Inner Container margin"]);
                    } else if(key === "_innerContainerPadding"){
                        allControls.push([key,"Inner Container padding"]);
                    } else if(key === "_rowGapColors"){
                        allControls.push([key,"Row gap (Colors)"]);
                    } else if(key === "_gridGap"){
                        allControls.push([key,"Grid gap"]);
                    } else if(typeof value !== "undefined" && value.hasOwnProperty('label')) {
                        allControls.push([key,value.label])
                    } else {
                        (value.type) ? allControls.push([key,value.type.charAt(0).toUpperCase() + value.type.slice(1)]) : '';
                    }
                }
            }
        }
        for (const [key, value] of Object.entries(bricksData.controls.themeStyles.controls)) {
            const el1 = key;
            for (const [key, value] of Object.entries(bricksData.controls.themeStyles.controls[el1])) {
                if (typeof value !== "undefined" && value.hasOwnProperty('css')) self.CSScontrolKeys.push(key)
            }
        }
        self.CSScontrolKeys = [... new Set(self.CSScontrolKeys)];

        const categoryWrappers = document.querySelectorAll('.brxc-categoryOptions');
        self.globalSettings.elements = allElements
            .filter((item, index, self) => index === self.findIndex((inner) => inner[0] === item[0] && inner[1] === item[1]))
            .sort((a, b) => (a[1] > b[1] ? 1 : a[1] < b[1] ? -1 : 0));
        (categoryWrappers.length > 0) ? categoryWrappers.forEach(wrapper => {
            self.globalSettings.elements.forEach(el => {
                wrapper.innerHTML += `<option value="${el[0]}">${el[1]}</option>` 
            })
        }) : '';

        const propertyWrappers = document.querySelectorAll('.brxc-propertyOptions');
        self.globalSettings.styleControls = allControls
            .filter((item, index, self) => index === self.findIndex((inner) => inner[0] === item[0] && inner[1] === item[1]))
            .sort((a, b) => (a[1] > b[1] ? 1 : a[1] < b[1] ? -1 : 0));
        (propertyWrappers.length > 0) ? propertyWrappers.forEach(wrapper => {
            self.globalSettings.styleControls.forEach(control => {
                wrapper.innerHTML += `<option value="${control[0]}">${control[1]}</option>` 
            })
        }) : '';


    },
    reorderClasses: function(){
       const self = this;
       if(self.vueState.globalClasses && typeof self.vueState.globalClasses === "object") self.vueState.globalClasses.sort((a, b) => { if (a.name < b.name) return -1; if (a.name > b.name) return 1; return 0; });
    },
    groupClassesByLockStatus: function(){
        const self = this;
        if(self.vueState.globalClasses && typeof self.vueState.globalClasses === "object"){
            const locked = []; 
            const unlocked = [];
            self.vueState.globalClasses.forEach(el => {
                self.vueGlobalProp.$_isLocked(el.id) ? locked.push(el) : unlocked.push(el);
            })
            self.vueState.globalClasses = JSON.parse(JSON.stringify(locked.concat(unlocked)));
        }
    },
    resizableStructurePanel: function(){
        const self = this;
        const panel = document.querySelector('#bricks-structure');
        const main = panel.querySelector('main.panel-content')
        const preview = document.querySelector('#bricks-preview');

        const resizeBox  = document.createElement("DIV");
        resizeBox.setAttribute("id", "brxcResizeBox");
        main.appendChild(resizeBox);
        const resizeBoxBottom  = document.createElement("DIV");
        resizeBoxBottom.setAttribute("id", "brxcResizeBoxBottom");
        panel.prepend(resizeBoxBottom);
    

        let startX, startWidth, startY, startMaxHeight;

        // Width
        const initDragWidth = (e) => {
            preview.style.pointerEvents = "none";
            panel.style.pointerEvents = "none";
            startX = e.clientX;
            startWidth = parseInt(document.defaultView.getComputedStyle(panel).width, 10);
            document.documentElement.addEventListener('mousemove', doDragWidth, false);
            document.documentElement.addEventListener('mouseup', stopDragWidth, false);
        }

        const doDragWidth = (e) => {
            panel.style.width = (startWidth + -e.clientX + startX) + 'px';
            let style = document.querySelector('#brxcstructurePanelMargin');
            if(!style){
                style = document.createElement("STYLE");
                style.setAttribute("id", "brxcstructurePanelMargin");
                document.head.appendChild(style);
            }
            self.globalSettings.structurePanelWidth = startWidth + -e.clientX + startX;
            style.innerHTML = `body #bricks-preview.show-structure {margin-right:calc(${self.globalSettings.structurePanelWidth}px - 7px);}`;
        }

        const stopDragWidth = (e) => {
            preview.style.pointerEvents = "auto";
            panel.style.pointerEvents = "auto";
            document.documentElement.removeEventListener('mousemove', doDragWidth, false);    
            document.documentElement.removeEventListener('mouseup', stopDragWidth, false);
        }

        resizeBox.addEventListener('mousedown', initDragWidth, false);

        // Max Height
        const initDragMaxHeight = (e) => {
            preview.style.pointerEvents = "none";
            panel.style.pointerEvents = "none";
            startY = e.clientY;
            startMaxHeight = parseInt(document.defaultView.getComputedStyle(panel).maxHeight, 10);
            document.documentElement.addEventListener('mousemove', doDragMaxHeight, false);
            document.documentElement.addEventListener('mouseup', stopDragMaxHeight, false);
        }
        
        const doDragMaxHeight = (e) => {
            const newMaxHeight = startMaxHeight + (e.clientY - startY);
            panel.style.setProperty('--max-height', `${newMaxHeight}px`);
        }
        
        const stopDragMaxHeight = () => {
            preview.style.pointerEvents = "auto";
            panel.style.pointerEvents = "auto";
            document.documentElement.removeEventListener('mousemove', doDragMaxHeight, false);
            document.documentElement.removeEventListener('mouseup', stopDragMaxHeight, false);
        }
        
        resizeBoxBottom.addEventListener('mousedown', initDragMaxHeight, false);


    },
    rightShortcutStates: {
        keyboard: false,
    },
    setRightShortcutCol: function(){
        const self = this;
        const structure = document.querySelector('#bricks-structure');
        structure.setAttribute('data-has-shortcuts-sidebar', 'true');
        const structurePanel = structure.querySelector('main.panel-content');
        const existingMenu = structure.querySelector('.brxce-panel-shortcut__wrapper');
        
        if(existingMenu){
            self.rightShortcutStates.keyboard = self.rightShortcutStates.keyboard ? false : true;
            existingMenu.remove();
        }

        const existingKey = [];
        
        function setKey(e){
            e = e.replace(/\s/g, '');
            for(let i = 0; i<e.length; i++){
                if(!existingKey.includes(e[i].toLowerCase())){
                    existingKey.push(e[i].toLowerCase());
                    return e[i].toUpperCase();
                }
            }

            return false;
        }
        let rightCol = `<div class="brxce-panel-shortcut__wrapper">
                            <div class="brxce-panel-shortcut__container">`;

        for (let i = 0; i < self.globalSettings.createElementsShortcuts.length; i++) { 
            for (let key in self.vueGlobalProp.bricks.elements) { 
                if (self.vueGlobalProp.bricks.elements[key].name === self.globalSettings.createElementsShortcuts[i]) { 
                    const el = self.vueGlobalProp.bricks.elements[key];
                    const keyboard = setKey(el.label);
                    if(!keyboard){
                        rightCol += `<li data-panel="${el.name}" data-balloon="${el.label}" data-balloon-pos="left" data-name="${el.name}" class="brxc-right-sidebar-shortcuts"><span class="bricks-svg-wrapper"><i class="${el.icon}"></i></li>`;
                    } else {
                        rightCol += `<li data-panel="${el.name}" data-balloon="${el.label}" data-balloon-pos="left" data-name="${el.name}" data-order="${keyboard}" class="brxc-right-sidebar-shortcuts"><span class="bricks-svg-wrapper"><i class="${el.icon}"></i></span><span class="keyboard-shortcut">${keyboard}</span></li>`;
                    }
                } 
            } 
        } 
        rightCol += `<li id="brxcKeyBoardShortcuts" class="${self.rightShortcutStates.keyboard ? 'active' : ''}" data-balloon="Keyboard Shortcuts ${self.rightShortcutStates.keyboard ? 'ON' : 'OFF'}" data-balloon-pos="left" onclick="ADMINBRXC.setRightShortcutCol()"><span class="bricks-svg-wrapper"><i class="fas fa-keyboard"></i></span></li></div></div>`;
        structurePanel.insertAdjacentHTML(
            'afterend',
            rightCol
        );
        const icons = structure.querySelectorAll(' li.brxc-right-sidebar-shortcuts');
        icons.forEach(icon => {
            icon.addEventListener('click', (e) => {
                const originalEl = self.vueState.activeId;
                const elName = icon.dataset.name;
                const id = self.vueGlobalProp.$_generateId();
                let parentId;

                // Check parent
                if(elName === "section" || typeof self.vueState.activeElement === 'undefined' || (self.vueState.activeElement.parent === 0 && !self.vueGlobalProp.$_isNestable())){
                    parentId = 0;
                } else if(self.vueGlobalProp.$_isNestable()){
                    parentId = self.vueState.activeId; 
                    self.vueGlobalProp.$_getElementObject(parentId).children.push(id)
                } else {
                    parentId = self.vueState.activeElement.parent;
                    self.vueGlobalProp.$_getElementObject(parentId).children.push(id)
                }

                const newElement = self.vueGlobalProp.$_createElement({name: elName, parent: parentId});
                newElement.id = id;
                let newContainer, containerId;

                if(elName === "section"){
                    containerId = self.vueGlobalProp.$_generateId();
                    newContainer = self.vueGlobalProp.$_createElement({name: "container"});
                    newContainer.id = containerId;
                    
                }

                const contentType = self.helpers.getTemplateType();
                self.vueState[contentType].push(newElement)
                if(elName === "section") {
                    self.vueState[contentType].push(newContainer);
                    newContainer.parent = id;
                    newElement.children.push(containerId);
                    setTimeout(() => {
                        self.vueState.activeElement = self.vueGlobalProp.$_getElementObject(containerId);
                        self.vueState.activeId = containerId
                    },1)
                }

                // Tag Manager
                if (self.helpers.isBuilderTweaksTabActive('structure-panel') && Object.values(self.globalSettings.structurePanelIcons).includes("tags")) {
                    setTimeout(() => self.showTagInStructurePanel(), 0);
                }

                // toggle structure list visibility
                setTimeout(()=>{
                    const targetId = (elName === "section") ? id : originalEl;
                    const activeElement = structure.querySelector(`.element[data-id="${targetId }"]`);
                    if(!activeElement) return;
                    const structureList = activeElement.querySelector(`.bricks-structure-list[data-parent-id="${targetId }"]`);
                    const toggle = activeElement.querySelector(`.structure-item > .toggle`);
                    if(!structureList || !toggle) return;
                    const display = window.getComputedStyle(structureList).getPropertyValue("display");
                    if(display && display === "none") toggle.click();
                },0)

                // Focus element on shift click
                if (elName != "section" && e.shiftKey) {
                    setTimeout(() => {
                        self.vueState.activeId = id;
                        self.vueState.activeElement = self.vueGlobalProp.$_getElementObject(id);
                    }, 1)
                }
            })
        })
    },
    setGlobalKeyboardsh: function(){
        const self = this;

        function runShortcuts(e, addShortcut = true) {
            const containers = document.querySelectorAll('.brxce-panel-shortcut__container');
        
            if (containers.length < 0) return;
        
            const item = Array.from(document.querySelectorAll('.brxce-panel-shortcut__container li[data-order]')).find(el => el.dataset.order.toLowerCase() === e.key.toLowerCase());
        
            const shortcut = e.shiftKey;
        
            // Check if any excluded keys are pressed
            const excludedKeys = [e.ctrlKey,e.metaKey,e.altKey];
        
            const shouldTriggerItem = !excludedKeys.includes(true);
        
            // View Shortcuts
            if (shortcut) {
                containers.forEach(container => container.classList.add('shortcuts-active'));
            } else {
                containers.forEach(container => container.classList.remove('shortcuts-active'));
            }
        
            if (!addShortcut) return;
        
            // Click shortcut
            if (item && shouldTriggerItem){
                e.preventDefault();
                e.stopPropagation();
                console.log(shortcut)
                if (shortcut) {
                    const event = new MouseEvent('click', {
                        bubbles: true,
                        cancelable: true,
                        shiftKey: true,
                    });
                    item.dispatchEvent(event);
    
                } else {
                    ADMINBRXC.vueState.brxc.clickedOnLeftPanelShortcuts = true;
                    setTimeout(() => {
                        item.click();
                        ADMINBRXC.vueState.brxc.clickedOnLeftPanelShortcuts = false;
                    }, 10);
                }
            }
        }
        function excludeFromBuilder(e){
            if ( self.rightShortcutStates.keyboard === false ||
                (e.target.tagName.toLowerCase() === 'input' && e.target.readOnly !== true) || 
                e.target.tagName.toLowerCase() === 'textarea') {
                return true;
            }
            return false;
        }
        function excludeFromPreview(e) {
            const tagName = e.target.tagName.toLowerCase();
            const isContentEditable = e.target.closest('[contenteditable="true"]');
            const activeKeyboard = self.rightShortcutStates.keyboard === false;
            const isInput = tagName === 'input';
            const isTextarea = tagName === 'textarea';
            const isSelect = tagName === 'select';
            const isButton = tagName === 'button';
            return activeKeyboard || isInput || isTextarea || isSelect || isButton || isContentEditable;
        }
        const x = document.querySelector('#bricks-builder-iframe').contentWindow;
        document.addEventListener('keyup', function(e) {
            const isExcluded = excludeFromBuilder(e);
            !isExcluded ? runShortcuts(e, false) : '';
        });
        x.document.addEventListener('keyup', function(e) {
            const isExcluded = excludeFromPreview(e);
            !isExcluded ? runShortcuts(e, false) : '';
        });
        document.addEventListener('keydown', function(e) {
            const isExcluded = excludeFromBuilder(e);
            !isExcluded ? runShortcuts(e) : '';
        });
        x.document.addEventListener('keydown', function(e) {
            const isExcluded = excludeFromPreview(e);
            !isExcluded ? runShortcuts(e) : '';
        });
    },
    multiSelectStates: {
        ids: [],
        previousId: null,
        settings: null,
        activeId: null,
        parent: null,
    },
    setMultiSelect: function(){
        const self = this;

        function addIdToArray(id){
            if(self.multiSelectStates.previousId !== null 
            && self.vueState.activeElement.parent !== 0 
            && self.vueGlobalProp.$_getElementObject(self.vueState.activeElement.parent).children.includes(self.multiSelectStates.previousId))
            {
                const children = self.vueGlobalProp.$_getElementObject(self.vueState.activeElement.parent).children;
                const order1 = children.indexOf(self.multiSelectStates.previousId);
                const order2 = children.indexOf(self.vueState.activeElement.id);
                for(let i = order1; i < order2 + 1; i++){
                    if(!self.multiSelectStates.ids.includes(children[i])) self.multiSelectStates.ids.push(children[i])
                }

            } else {
                self.multiSelectStates.ids.push(id);
            }
            self.multiSelectStates.previousId = self.vueState.activeElement.id;
        }

        function shiftClickHandler(target){
            const el = target.closest('#bricks-structure li.element');
            if(!el) return;

            const id = el.dataset.id;
            if(!self.multiSelectStates.ids.includes(id)) {
                addIdToArray(id)
            } else {
                self.multiSelectStates.ids.splice(self.multiSelectStates.ids.indexOf(id), 1)
            }

            const elements = Array.from(document.querySelectorAll('#bricks-structure li.element'))
            const elementsActive = elements.filter(el => self.multiSelectStates.ids.includes(el.dataset.id))
            elements.forEach(el => {
                el.classList.remove('multiselect');
                if(elementsActive.includes(el)) el.classList.add('multiselect');
            });

            self.vueState.rerenderControls = Date.now();
        }

        function clickHandler(){
            self.multiSelectStates.ids = [];
            const elements = document.querySelectorAll('#bricks-structure li.element.multiselect');
            elements.forEach(el => el.classList.remove('multiselect'));

        }

        document.addEventListener('click', function(event) {
            if(!event.target.closest('#bricks-structure li.element')) return;

            if (event.shiftKey) {
                // Shift + Click
                shiftClickHandler(event.target);
            } else {
                // Only Click
                clickHandler();
                self.multiSelectStates.settings = null;
            }
        });
    },
    applyMultipleSettings: function(){
        const self = this;
        setTimeout(() => {
            if(!self.helpers.isElementActive() || self.multiSelectStates.ids.length === 0) return;

            function setValueByPath(id, diff) {
                let settings = self.vueGlobalProp.$_getElementObject(id).settings;
                let xsettings = FRAMEBRXC.vueGlobalProp.$_getElementObject(id).settings;
                const exclusions = [
                    '_conditions',
                    '_interactions',
                    '_cssClasses',
                    '_cssId',
                    '_attributes'
                ]
                const pathArray = diff.path;
                const value = diff.val;
                const op = diff.op;

                // Exclude prop
                if(pathArray[0] && exclusions.includes(pathArray[0])){
                    return;
                }

                // 1 path value
                if (pathArray.length === 1) {
                    if(op === "delete"){
                        delete settings[pathArray[0]]
                        delete xsettings[pathArray[0]]
                    } else {
                        settings[pathArray[0]] = value;
                        xsettings[pathArray[0]] = value;
                    }
                    return
                }

                // Add nested values
                if (pathArray.length > 1) {
                    for (let i = 0; i < pathArray.length - 1; i++) {
                        const path = pathArray[i];
                        settings[path] = settings[path] || {};
                        xsettings[path] = xsettings[path] || {};

                        settings = settings[path];
                        xsettings = xsettings[path];
                    }

                    if(op === "delete"){
                        delete settings[pathArray[pathArray.length - 1]];
                        delete xsettings[pathArray[pathArray.length - 1]];
                    } else {
                        settings[pathArray[pathArray.length - 1]] = value;
                        xsettings[pathArray[pathArray.length - 1]] = value;
                    }
                }
            }

            if(self.multiSelectStates.activeId === null || self.multiSelectStates.activeId !== self.vueState.activeElement.id) {
                self.multiSelectStates.settings = null;
                self.multiSelectStates.activeId = self.vueState.activeElement.id;
            }

            const oldSettings = JSON.parse(JSON.stringify(self.vueState.activeElement.settings))

            if(self.multiSelectStates.settings === null) self.multiSelectStates.settings = oldSettings;

            const diffs = recursiveDiff.getDiff(self.multiSelectStates.settings, oldSettings);

            diffs.forEach(diff => {

                // Global Classes
                if(diff.path[0] === '_cssGlobalClasses'){
                    const oldClasses = self.multiSelectStates.settings._cssGlobalClasses || [];
                    const newClasses = self.vueState.activeElement.settings._cssGlobalClasses || [];

                    // Remove Classes
                    if(oldClasses.length > newClasses.length){
                        const removedClasses = oldClasses.filter(element => !newClasses.includes(element));
                        self.multiSelectStates.ids.forEach(id => {
                            if(id !== self.multiSelectStates.activeId){
                                let settings = self.vueGlobalProp.$_getElementObject(id).settings;
                                if(!settings.hasOwnProperty('_cssGlobalClasses')) settings._cssGlobalClasses = [];
                                settings._cssGlobalClasses = Array.from(settings._cssGlobalClasses).filter(el => el && !removedClasses.includes(el))
                            }
                        })
                    
                    // Add Classes
                    } else if(newClasses.length > oldClasses.length){
                        const addedClasses = newClasses.filter(element => !oldClasses.includes(element));
                        self.multiSelectStates.ids.forEach(id => {
                            if(id !== self.multiSelectStates.activeId){
                                let settings = self.vueGlobalProp.$_getElementObject(id).settings;
                                if(!settings.hasOwnProperty('_cssGlobalClasses')) settings._cssGlobalClasses = [];
                                settings._cssGlobalClasses = [...new Set(settings._cssGlobalClasses.concat(addedClasses))];
                            }
                        })
                    }

                // Styles
                } else {
                    self.multiSelectStates.ids.forEach(id => {
                        if(id === self.vueState.activeElement.id) return;
                        setValueByPath(id, diff); 
                    })          
                } 
            })

            //
            self.multiSelectStates.settings = oldSettings;
        }, 0)
    },
    setBricksLabs: function (content){
        if(!content || content.length < 1) return;

        const canvas = document.querySelector('#brxcBricksLabsOverlay #brxc-overlay__canvas');
        if(!canvas) return;

        let output = `<div class="brxc-article__container">`;
        content.forEach(article => {
            const rawDate = new Date(article.date);
            const date = rawDate.toLocaleDateString('en-us', { weekday:"short", year:"numeric", month:"short", day:"numeric"});
            output += `<div class="brxc-article__wrapper">
                <div class="brxc-article__col-left">
                <a href="${article.link}" target="_blank"><img src="${article.featured_image_src_square}" /></a>
                </div>
                <div class="brxc-article__col-right">
                    <a href="${article.link}" target="_blank"><h3>${article.title.rendered}</h3></a>
                    <p class="brxc-article__author-wrapper"><i class="brxc-article__author-icon fas fa-calendar-days"></i>${date}<span class="brxc-article__author">by <strong>${article.author_info.display_name}</strong></span></p>
                    <span class="brxc-article__excerpt">${article.excerpt.rendered}</span>
                    <a href="${article.link}" class="brxc-overlay__action-btn secondary brxc-article__readmore" target="_blank">Read more</a>
                </div>
            </div>`;
        })
        output += `</div>`;
        canvas.innerHTML = output;
    },
    bricksLabsAPI: function(target, query = false, openModal = false){
        const self = this;
        (target) ? target.classList.add('disable') : '';
        const wrapper = document.querySelector('#brxcBricksLabsOverlay');

        if(openModal === true && wrapper.dataset.loaded === "true") {
            return;
        }

        let url;
        (query) ? url = 'https://brickslabs.com/wp-json/wp/v2/posts?search=' + query.replace(/\s+/g, '+') : url = 'https://brickslabs.com/wp-json/wp/v2/posts';
        const post = async () => {
            const rawResponse = await fetch(url);
            const content = await rawResponse.json();
            if(content.error){
                console.log('error');
                (target) ? target.classList.remove('disable') : '';
            } else {
                self.setBricksLabs(content);
                wrapper.setAttribute('data-loaded', 'true');
                (target) ? target.classList.remove('disable') : '';
            }
        };

        post();
            
    },
    setBreakpointsAttributes: function(){
        const self = this;
        const icons = document.querySelectorAll('#bricks-toolbar .group-wrapper.breakpoints li.breakpoint');
        const breakpoints = self.vueState.breakpoints;
        breakpoints.forEach(({ label, key }) => {
            icons.forEach(icon => {
              const text = icon.dataset.balloon;
              if (text.includes(label)) {
                icon.dataset.key = key;
              }
            });
        });
    },
    alertMsg: function(autoremove = true, msg, delay){
        const wrapper = document.querySelector('#brxc-alert-message');
        if(!wrapper) return;

        let message = document.createElement('DIV');
        message.setAttribute("id", "brxcAlertMessageContent");
        message.innerHTML = msg;
        setTimeout(() => {
            wrapper.appendChild(message);
            wrapper.classList.add('active');
        }, 
        setTimeout(() => {
            if(autoremove){
                message = document.querySelector('#brxcAlertMessageContent');
                message.remove();
                wrapper.classList.remove('active');
            }
        }, delay))
    },
    setAlertMsg: function(){
        const msg = document.querySelector('#bricks-message');
        if(!msg) return;
        const html = `<div id="brxc-alert-message"></div>"`;
        msg.insertAdjacentHTML("afterend", html);
    },
    setStructurePanelKeyboardShortcuts: function(){
        const self = this;
        const element = document.getElementById('bricks-structure');
        if(!element) return;
        
        const arrowUpHandler = function(e) {
            if (e.shiftKey && e.key === "ArrowUp" && (e.metaKey && e.altKey) === false) {
                self.moveElement('top');
            }
        };
        
        const arrowRightHandler = function(e) {
            if (e.shiftKey && e.key === "ArrowRight" && (e.metaKey && e.altKey) === false) {
                self.moveElement('right');
            }
        };
        
        const arrowDownHandler = function(e) {
            if (e.shiftKey && e.key === "ArrowDown" && (e.metaKey && e.altKey) === false) {
                self.moveElement('down');
            }
        };
        
        const arrowLeftHandler = function(e) {
            if (e.shiftKey && e.key === "ArrowLeft" && (e.metaKey && e.altKey) === false) {
                self.moveElement('left');
            }
        };
        
        const addKeydownListeners = function() {
            document.addEventListener('keydown', arrowUpHandler);
            document.addEventListener('keydown', arrowRightHandler);
            document.addEventListener('keydown', arrowDownHandler);
            document.addEventListener('keydown', arrowLeftHandler);
        };
        
        const removeKeydownListeners = function() {
            document.removeEventListener('keydown', arrowUpHandler);
            document.removeEventListener('keydown', arrowRightHandler);
            document.removeEventListener('keydown', arrowDownHandler);
            document.removeEventListener('keydown', arrowLeftHandler);
        };
        
        element.addEventListener('mouseenter', addKeydownListeners);
        element.addEventListener('mouseleave', removeKeydownListeners);
    },
    initStates: function(){
        const self = this;
        self.vueState.brxcShowImportInput = false;
        self.vueState.brxcShowLock = true;
        self.vueState.brxc.tagsView = self.globalSettings.structurePanelTagDefaultView;
        if(Array.isArray(self.vueState.colorPalette) && self.vueState.colorPalette.length > 0){
            const defaultPalette = Array.from(self.vueState.colorPalette).find(el => el && el.hasOwnProperty('default') && el.default === "true");
            if(defaultPalette) {
                self.colorStates.activePalette = defaultPalette.id
            } else {
                self.colorStates.activePalette = self.vueState.colorPalette[0].id;
            }
        }

        // Set light mode as default
        const x = document.querySelector('#bricks-builder-iframe').contentWindow;
        document.documentElement.setAttribute('data-theme', 'light');
        x.document.documentElement.setAttribute('data-theme', 'light');

    },
    
    populateNestableElements: function(){
        const self = this;
        for(const [key, value] of Object.entries(bricksData.elements)){
            if(bricksData.elements[key].hasOwnProperty('nestableChildren') && bricksData.elements[key].nestableChildren !== null && key !== "section" ) self.nestableElements.push(key);
        }        
    },
    disableMoveElement: function(){
        const self = this;
        const contentType = self.helpers.getTemplateType();
        const content = self.vueState[contentType];
        const contextualMenu = document.querySelector('#bricks-builder-context-menu');
        const left = contextualMenu.querySelector('span[data-balloon="Indent Left"]');
        const right = contextualMenu.querySelector('span[data-balloon="Indent Right"]');
        const up = contextualMenu.querySelector('span[data-balloon="Move Up"]');
        const down = contextualMenu.querySelector('span[data-balloon="Move Down"]');

        // disable indent left
        left.classList.remove('disable');
        if(typeof self.vueState.activeElement !== "undefined" && self.vueState.activeElement.parent === 0) left.classList.add('disable');

        // disable indent right
        right.classList.remove('disable');
        if(typeof self.vueState.activeElement !== "undefined" ) {
            // element is on root
            if(self.vueState.activeElement.parent === 0){
                let hasContainer = false
                content.forEach(el => {
                    if(el.parent === 0 && el.id !== self.vueState.activeElement.id && bricksData.elements[el.name].nestable === true) hasContainer = true;
                })
                if(!hasContainer) right.classList.add('disable');
            // element is nested
            } else {
                const parent = self.vueState.activeElement.parent;
                const parentChildren = self.vueGlobalProp.$_getElementObject(parent).children;
                let hasNestable = false;
                parentChildren.forEach(el =>{
                    if (el === self.vueState.activeElement.id) return;
                    if (bricksData.elements[self.vueGlobalProp.$_getElementObject(el).name].nestable === true) hasNestable = true;
                })
                if (hasNestable === false) right.classList.add('disable');
            }
        }
        //disable move up & down
        up.classList.remove('disable');
        down.classList.remove('disable');
        if(typeof self.vueState.activeElement !== "undefined" ) {
            // element is on root
            if(self.vueState.activeElement.parent === 0){
                const activeEl = self.vueState.activeElement;
                let hasPrevious = false;
                let hasNext = false
                for(let i = content.indexOf(activeEl); i < content.length; i++){
                    if(content[i].parent === 0 && content[i].id !== activeEl.id) hasNext = true;
                }
                for(let i = content.indexOf(activeEl); i > -1; i--){
                    if(content[i].parent === 0 && content[i].id !== activeEl.id) hasPrevious = true;
                }
                if(!hasPrevious) up.classList.add('disable');
                if(!hasNext) down.classList.add('disable');

            // element is nested
            } else {
                const parent = self.vueState.activeElement.parent;
                const parentChildren = self.vueGlobalProp.$_getElementObject(parent).children;
                const currentIndex = parentChildren.indexOf(self.vueState.activeElement.id);
                if(!parentChildren[currentIndex - 1]) up.classList.add('disable');
                if(!parentChildren[currentIndex + 1]) down.classList.add('disable');
            }
        }

    },
    showHideElement: function(){
        const self = this;
        const hideElement = document.querySelector('#hideElement');
        const activeEl = self.vueState.activeElement;
        if (!hideElement || typeof activeEl === "undefined") return;
        if(activeEl.hasOwnProperty('settings') && activeEl.settings.hasOwnProperty('_display') && activeEl.settings._display === "none") {
            hideElement.textContent = "Show Element";
            hideElement.setAttribute("onclick", "ADMINBRXC.showElement()");
        } else {
            hideElement.textContent = "Hide Element";
            hideElement.setAttribute("onclick", "ADMINBRXC.hideElement()");
        }
    },
    setDeleteWrapper: function(){
        const self = this;
        const contextualMenu = document.querySelector("#bricks-builder-context-menu");
        const deleteIcon = contextualMenu.querySelector('li.delete');
        if (!deleteIcon) return; 
        const buttons = deleteIcon.querySelector('div.buttons');
        if (buttons) buttons.remove();
        if(typeof self.vueState.activeElement === "undefined" || !self.vueState.activeElement.hasOwnProperty('children') || !Array.isArray(self.vueState.activeElement.children) || self.vueState.activeElement.children.length < 1) return;
        let icon = `<div class="buttons"><span class="action" data-balloon="Move Children Up" data-balloon-pos="top-right" onClick="ADMINBRXC.deleteWrapper(event);"><i class="fas fa-trash-can-arrow-up"></i></span></div>`;
        deleteIcon.innerHTML += icon;
    },
    deleteWrapper: function(){
        const self = this;
        const activeEl = self.vueState.activeElement;
        if (typeof activeEl === "undefined" || !self.vueState.activeElement.hasOwnProperty('children') || !Array.isArray(activeEl.children) || activeEl.children.length < 1)  return;
        const parent = activeEl.parent;
        const children = activeEl.children;
        // Element is on root
        if(parent === 0){
            children.forEach(child => {
                self.vueGlobalProp.$_getElementObject(child).parent = 0;
            })
            activeEl.children = [];
        // Element is nested
        } else {
            let parentChildren = self.vueGlobalProp.$_getElementObject(parent).children;
            children.forEach(child => {
                self.vueGlobalProp.$_getElementObject(child).parent = parent;
                parentChildren.push(child);
            })
            activeEl.children = [];

        }
    },
    convertBasicToRichtoHeader: function(newName){
        const self = this;
        self.vueState.activeElement.name = newName;
        (newName === "text-basic") ? self.vueState.activeElement.settings.tag = "p" : self.vueState.activeElement.settings.tag = bricksData.elements[newName].tag;
    },
    setConvertBasictoRichtoHeader: function(){
        const self = this;
        const oldMenu = document.querySelector('#brxcConvertBasicToRich');
        if (oldMenu) oldMenu.remove();
        const name = self.vueState.activeElement.name;
        if (name === 'text' || name === 'text-basic' || name === 'heading'){
            let contextualMenu = document.querySelector("#bricks-builder-context-menu li.save");
            let icons = '';
            icons += `<li id="brxcConvertBasicToRich" class="convert sep"><span class="label">Convert </span>`;
            (name !== 'text-basic') ? icons += `<div class="buttons"><span data-balloon="Basic Text" data-balloon-pos="top" onclick="ADMINBRXC.convertBasicToRichtoHeader('text-basic')"><i class="ti-align-justify"></i></span>` : '';
            (name !== 'text') ? icons += `<div class="buttons"><span data-balloon="Rich Text" data-balloon-pos="top" onclick="ADMINBRXC.convertBasicToRichtoHeader('text')"><i class="ti-align-left"></i></span>` : '';
            (name !== 'heading') ? icons += `<div class="buttons"><span data-balloon="Heading" data-balloon-pos="top" onclick="ADMINBRXC.convertBasicToRichtoHeader('heading')"><i class="ti-text"></i></span>` : '';
            icons += `</div></li>`;
            contextualMenu.insertAdjacentHTML("beforeBegin", icons);
        }
        
    },
    importCSSfromElements: function(btn,cm,type,scope){
        const self = this;
        const existingCSS = cm.getValue();
        const dataOptions = { indent_size: 2, space_in_empty_paren: false };
        const contentType = self.helpers.getTemplateType();
        let content;
        if (type === "id"){
            
            content = self.vueState[contentType];
        } else if(scope === "global"){
            content = self.vueState.globalClasses;
        } else if(scope === "page"){
            let activeClasses = [];
            self.vueState[contentType].forEach(el => {
                if(el.settings.hasOwnProperty('_cssGlobalClasses') && Array.isArray(el.settings._cssGlobalClasses)) activeClasses = activeClasses.concat(el.settings._cssGlobalClasses);
            })
            content = Array.from(self.vueState.globalClasses).filter(el => el && el.hasOwnProperty('id') && activeClasses.includes(el.id));
        }
        let css = "";
        const mq = (self.vueGlobalProp.$_isMobileFirst._value) ? 'min' : 'max';
        self.vueState.breakpoints.forEach(bp => {
            if(bp.hasOwnProperty('base') && bp.base === true) {
                if(content.length > 0){
                    content.forEach(el => {
                        if(el.hasOwnProperty('settings') && el.settings.hasOwnProperty('_cssCustom')) {
                            css += el.settings._cssCustom;
                            delete el.settings._cssCustom;
                        }
                    })
                }
            } else{
                if(content.length > 0){
                    let hasStyle = false;
                    let cssTemp = '';
                    content.forEach(el => {
                        const property = `_cssCustom:${bp.key}`;
                        if(el.hasOwnProperty('settings') && el.settings.hasOwnProperty(property)) {
                            hasStyle = true;
                            cssTemp += el.settings[property];
                            delete el.settings[property];
                        }
                    })
                    if(hasStyle){
                        css += `@media (${mq}-width: ${bp.width}px){`;
                        css += cssTemp; 
                        css += '}'; 
                    }
                }
            }
        })
        
        css = css_beautify(css, dataOptions)
        
        cm.setValue(`${existingCSS}\n${css}`);
        const span = btn.parentElement.querySelector('span');
        setTimeout(() => {
            span.innerHTML = "CSS Imported Successfully!";
        }, setTimeout(() => {
            span.innerHTML = "Import CSS from Global Classes";
        }, 2000))

    },
    generateSelectors: function(btn,cm, incudeMQ){
        const self = this;
        if (self.vueState.activeElement === "" || typeof self.vueState.activeElement === "undefined") {
            const wrapper = document.querySelector('#brxcCSSOverlay .brxc-overlay__error-message-wrapper');
            let inner = `<div class="brxc-ai-response-wrapper remove-on-reset">`;
            inner += `<div name="error-css-msg" class="error-message" id="cssErrorMsg"><i class="bricks-svg ti-close" onClick="this.parentElement.parentElement.remove()"></i>Error: Select an element inside the Structure Panel</div></div>`;
            wrapper.innerHTML = inner;
            return;
        }

        const existingCSS = cm.getValue();
        const dataOptions = { indent_size: 2, space_in_empty_paren: false };
        const mq = (self.vueGlobalProp.$_isMobileFirst._value) ? 'min' : 'max';
        let existingSelector = [];
        let selector = false;
        function createSelector(obj,existingSelector){
            if (obj.settings.hasOwnProperty('_cssGlobalClasses') && Array.isArray(obj.settings._cssGlobalClasses) && obj.settings._cssGlobalClasses.length > 0) {
                const unlocked = [];
                const locked = [];
                obj.settings._cssGlobalClasses.forEach(el => {
                    (self.vueGlobalProp.$_isLocked(el)) ? locked.push(el) : unlocked.push(el);
                });
                const ids = (unlocked.length > 0) ? unlocked : locked;
                if (ids.length > 0) {
                    let classes = [] 
                    ids.forEach(id => {
                        classes.push(self.vueGlobalProp.$_getGlobalClass(id).name);
                    })
                    selector = `.${classes.join('.')}`;
                } else {
                    selector = false;
                }
            } else {
                selector = `#${self.vueGlobalProp.$_getElementId(obj)}`;
            } 
            if(selector === false || existingSelector.includes(selector)) return "";
            existingSelector.push(selector);
            return `${selector}{}`;
        }
        let css = "";
        function checkChildren(obj, first){
            if(first === true) existingSelector = [];
            css += createSelector(obj,existingSelector);
            if(obj.children.length < 1) return;
            obj.children.forEach(child =>{
                checkChildren(self.vueGlobalProp.$_getElementObject(child), false);
            })
        }
        self.vueState.breakpoints.forEach(bp => {
            if(bp.hasOwnProperty('base') && bp.base === true) {
                checkChildren(self.vueState.activeElement, true);
            } else if(incudeMQ === true){
                css += `@media (${mq}-width: ${bp.width}px){`;
                checkChildren(self.vueState.activeElement, true);
                css += '}'; 
            }
        })
        css = css_beautify(css, dataOptions)
        cm.setValue(`${existingCSS}\n${css}`);
        const span = btn.parentElement.querySelector('span');
        setTimeout(() => {
            span.innerHTML = "Selectors Generated Successfully!";
        }, setTimeout(() => {
            span.innerHTML = "Generate Selectors";
        }, 2000))
    },
    setRootClassComponentToggle: function(){
        const self = this;

        // Remove Buttons
        if(!self.helpers.isElementActive() || !bricksData.elements[self.vueState.activeElement.name].hasOwnProperty('nestable') || bricksData.elements[self.vueState.activeElement.name].nestable !== true) {
            const buttons = document.querySelector('#brxcBEMConverter .buttons');
            if (buttons) buttons.remove(); 
            return;
        }
        const li = document.querySelector('#brxcBEMConverter');
        if(!li) return;

        // Add Buttons
        const buttons = li.querySelector('#brxcBEMConverter .buttons');
        if (!buttons){
            const newButtons = document.createElement('DIV');
            newButtons.classList.add('buttons')
            newButtons.innerHTML = `<span class="action" data-balloon="Enable Root Element" data-balloon-pos="top" onclick="event.stopPropagation();ADMINBRXC.rootClassComponentToggle(true)"><i class="fas fas fa-toggle-off"></i></span>`;
            li.appendChild(newButtons);
        }

        const txt = document.querySelector('#brxcBEMConverter span.action');
        if(!txt) return;

        const icon = document.querySelector('#brxcBEMConverter span.action i');
        if(!icon) return;

        if(self.vueState.activeElement.settings.hasOwnProperty('classConverterComponent') && self.vueState.activeElement.settings.classConverterComponent === true){
            txt.dataset.balloon = "Disable Root Component";
            icon.classList.remove('fa-toggle-off')
            icon.classList.add('fa-toggle-on')
        } else {
            txt.dataset.balloon = "Enable Root Component";
            icon.classList.remove('fa-toggle-on')
            icon.classList.add('fa-toggle-off')
        }
    },
    rootClassComponentToggle: function(isStructurePanel = false){
        const self = this;
        if(!self.helpers.isElementActive()) return;

        if(self.vueState.activeElement.settings.hasOwnProperty('classConverterComponent') && self.vueState.activeElement.settings.classConverterComponent === true){
            delete self.vueState.activeElement.settings.classConverterComponent;
        } else {
            self.vueState.activeElement.settings.classConverterComponent = true;
        }
        self.vueState.activeElement.rerenderControls = Date.now();
        self.vueState.showContextMenu = false;
        if(isStructurePanel){
            setTimeout(() => {
                self.vueState.showContextMenu = self.vueState.activeElement.id;
            }, 1)
        } else {
            self.openClassContextualMenu();
        }
    },
    setQuickSaveMenuIcon: function(){
        const self = this;

        if(!self.helpers.isElementActive()) return;

        const li = document.querySelector('#bricks-builder-context-menu li.save.sep');
        if(!li) return;

        // Add Buttons
        const buttons = li.querySelector('.buttons');
        if(buttons){
            return;
        } else {
            const newButtons = document.createElement('DIV');
            newButtons.classList.add('buttons')
            newButtons.innerHTML = `<span class="action" data-balloon="Quick Save" data-balloon-pos="top" onclick="event.stopPropagation();ADMINBRXC.openSaveTemplate();ADMINBRXC.vueState.showContextMenu = false;"><i class="fas fa-bolt-lightning"></i></span>`;
            li.appendChild(newButtons);
        }
    },
    initContextualMenuObservers: function(){
        const self = this;
        const contextualMenu = document.querySelector('#bricks-builder-context-menu');

        const observer = new MutationObserver(function(mutation) {
            const contextualMenu = document.querySelector('#bricks-builder-context-menu');

            if(self.vueState.brxcRunningMenuObserver === true || !contextualMenu.classList.contains('show')) return;
            self.vueState.brxcRunningMenuObserver = true;

            if(self.helpers.isBuilderTweaksTabActive('structure-panel')){
                Object.values(self.globalSettings.structurePanelContextualMenu).includes('move-element') ? self.disableMoveElement() : '';
                Object.values(self.globalSettings.structurePanelContextualMenu).includes('hide-element') ? self.showHideElement() : '';
                Object.values(self.globalSettings.structurePanelContextualMenu).includes('delete-wrapper') ? self.setDeleteWrapper(): '';
                Object.values(self.globalSettings.structurePanelContextualMenu).includes('convert-text') ? self.setConvertBasictoRichtoHeader() : '';
                self.helpers.isBuilderTweaksTabActive('structure-panel') && Object.values(self.globalSettings.structurePanelContextualMenu).includes('class-converter') ? self.setRootClassComponentToggle() : '';
                self.helpers.isBuilderTweaksTabActive('templates') && Object.values(self.globalSettings.templateFeatures).includes("quick-save") ? self.setQuickSaveMenuIcon() : '';
            }

            setTimeout(() => self.vueState.brxcRunningMenuObserver = false, 100)
        });

        observer.observe(contextualMenu, { subtree: true, childList: true, attributes: true, attributeFilter: ['class'] });
    },
    setStructurePanelWidth: function(){
        const self = this;
        const panel = document.querySelector('#bricks-structure');
        const width = (self.globalSettings.hasOwnProperty('structurePanelWidth')) ? `${self.globalSettings.structurePanelWidth}px` : '300px';
        panel.style.width = width;
        let style = document.querySelector('#brxcstructurePanelMargin');
        if(!style){
            style = document.createElement("STYLE");
            style.setAttribute("id", "brxcstructurePanelMargin");
            document.head.appendChild(style);
        }
        style.innerHTML = `#bricks-preview.show-structure {margin-right: calc(${width} - 7px);}`;
    },
    saveGlobalCSS: function(prefix, global, overlay, target, customCSS){
        const self = this;
        target.classList.add('disable');
        jQuery.ajax({
            url: openai_ajax_req.ajax_url,
            data: {
                action: 'save_global_css_ajax_function',
                custom_css: customCSS, 
                nonce: openai_ajax_req.nonce
            },
            method: "POST",
            success: function(data) {
                target.classList.remove('disable');
                setTimeout(() => {
                    target.innerHTML = "<span>Saved Correctly!</span>";
                }, setTimeout(() => {
                    target.innerHTML = "<span>Save</span>";
                }, 2000))
            },
            error: function(data) {
                console.log("Error fetching data from wp_options table");
                target.classList.remove('disable');
                setTimeout(() => {
                    target.innerHTML = "<span>Error: CSS not Saved!</span>";
                }, setTimeout(() => {
                    target.innerHTML = "<span>Save</span>";
                }, 2000))

            }
        });
    },
    getSelectorsFromFile: function (file) {
        // Remove comments from the file
        file = file.replace(/\/\*[\s\S]*?\*\//g, '');
    
        // Remove media query declarations but keep the content
        file = file.replace(/@media[^{]*\{/gi, '');
    
        // Close remaining brackets from media queries
        file = file.replace(/\s*}\s*(?=})/g, '');
    
        // Pattern One: Match text within curly braces {}
        const patternOne = /\{([^}]*)\}/g;
    
        // Pattern Two: Match dot notation (e.g., .example-name) excluding comments
        const patternTwo = /\.([a-zA-Z0-9_-]+)\b/g;
    
        const stripped = file.replace(patternOne, '');
    
        const selectors = [...stripped.matchAll(patternTwo)].map((match) => match[1]);
    
        return Array.from(new Set(selectors));
    },
    parseGlobalCSS: function(target,file){
        const self = this;
        const allClasses = self.getSelectorsFromFile(file);
        if(allClasses.length < 1) return;
        let itemFound = 0;
        if(Array.isArray(allClasses) && allClasses.length >0){
            allClasses.forEach(el => {
                const found = Array.from(self.vueState.globalClasses).find(e => e && e.hasOwnProperty('name') &&  e.name === el);
                if(!found){
                    itemFound++;

                    // Generate ID
                    const id = self.vueGlobalProp.$_generateId();

                    // Generate new global class
                    self.generateGlobalClass('globalCSS',el, false, id);

                    // Lock the class
                    if(!self.vueState.globalClassesLocked.includes(`globalCSS${id}`)) self.vueState.globalClassesLocked.push(`globalCSS${id}`);
                }
            })
        }
        const message = () => {
            if(itemFound > 0) {
                return `<span>${itemFound} Classes Exported Successfully!</span>`;
            } else if(itemFound === 0){
                return `<span>Abort: no new class found!</span>`;
            } else {
                return '<span>Error: No Class has been exported</span>'
            }
        }
        self.vueGlobalProp.$_showMessage(message());
    },
    setDefaultElements: function(){
        const self = this;

        // Heading Textarea
        if (Object.values(self.globalSettings.defaultElementFeatures).includes('heading-textarea')) bricksData.elements.heading.controls.text.type = "textarea";

    },
    populateClassCategories: function(){
        const self = this;
        const finalCats = typeof self.vueState.globalClassesCategories !== "undefined" ? ['All', 'Uncategorized'].concat(Array.from(self.vueState.globalClassesCategories).filter(el => el && el.name).map(el => el && el.name).sort((a, b) => a.localeCompare(b, undefined, {sensitivity: 'base'}))) : false; 
        self.states.classManagerCategories = finalCats;
    },
    refreshColorPrefix: function(){
        const self = this;
        const palettes = self.vueState.colorPalette;
        if(!Array.isArray(palettes) || palettes.length < 1) return;
        let hasChanged = false;
        palettes.forEach(palette => {
            if(!palette.hasOwnProperty('colors') || !Array.isArray(palette.colors) || palette.colors.length < 1) return;
            palette.colors.forEach(color => {
                if (!color.hasOwnProperty('raw') || !color.hasOwnProperty('name') || !color.hasOwnProperty('rawValue') || !color.rawValue.hasOwnProperty('light')) return;
                const name = self.helpers.setPrefix(self.helpers.formatForClasses(color.name), 'colors', self.helpers.isFramework(color.id));
                if (!color.raw !== `var(--${name})`) {
                    color.raw = `var(--${name})`;
                    hasChanged = true;
                }
            })
        })
        if (hasChanged) self.helpers.saveChanges('colorPalette');
    },
    setColorVariablesOnLoad: function(){
        const self = this;
        self.generateColorCSS();
        self.refreshColorPrefix();
    },
    setResponsiveHelper: function(item){
        const self = this;
        const slider = document.querySelector('#brxcResponsiveBar')
        if(!slider) return;
        if(item.classList.contains('active')) {
            item.classList.remove('active');
            slider.classList.remove('active');
        } else {
            item.classList.add('active');
            slider.classList.add('active');
        } 
    },
    setResponsiveBar: function(){
        const self = this;
        document.body.classList.add('responsive-helper');
        const iframePreview = document.querySelector('#bricks-preview');
        const container = document.createElement('div');
        container.id = "brxcResponsiveBar";
        let content = `<div class="brxc-range-input-wrapper brxc__range"><div class="brxc-range-input-container"><input type="range" min="1" max="2000" class="brxc-input__range${self.vueGlobalProp.$_isMobileFirst._value ? ' reverse' : ''}" oninput="ADMINBRXC.responsiveBar(this);">`
        self.vueState.breakpoints.forEach((bp, index) => {
            content += index > 0 ? `<div class="bp-marker" style="${self.vueGlobalProp.$_isMobileFirst._value ? 'left' : 'right'}: calc((${bp.width - 1} - 0) / (2000 - 0) * 100%)"></div>` : '';
        })
        content += `<div class="ruler">`;
        const rulerArr = self.vueGlobalProp.$_isMobileFirst._value ? [0,200,400,600,800,1000,1200,1400,1600,1800,2000] : [1800,1600,1400,1200,1000,800,600,400,200,0];
        rulerArr.forEach( r => {
            content += `<div class="interval">${r}px</div>`
        }) 
        content += `</div>`;
        content += `</div></div>`;
        container.innerHTML = content;
        iframePreview.prepend(container);

        // listener
        const toolbarItems = document.querySelectorAll('#bricks-toolbar li');
        if (!toolbarItems || toolbarItems.length < 1) return;

        function isDesktop(bp){
            const isMobileFirst = self.vueGlobalProp.$_isMobileFirst._value;
            if(isMobileFirst){
                if(self.vueState.breakpoints.indexOf(bp) === self.vueState.breakpoints.length - 1) return true;
                return false;
                
            } else {
                if(self.vueState.breakpoints.indexOf(bp) === 0) return true;
                return false;
            }
        }

        function isMobile(bp){
            const isMobileFirst = self.vueGlobalProp.$_isMobileFirst._value;
            if(isMobileFirst){
                if(self.vueState.breakpoints.indexOf(bp) === 0) return true;
                return false;
                
            } else {
                if(self.vueState.breakpoints.indexOf(bp) === self.vueState.breakpoints.length - 1) return true;
                return false;
            }
        }
        
        toolbarItems.forEach(el => {
            const slider = document.querySelector('#brxcResponsiveBar input');
            if(!slider) return;
            el.addEventListener('click', () => {
                const isMobileFirst = self.vueGlobalProp.$_isMobileFirst._value;
                if(el.classList.contains('breakpoint')){
                    const bp = self.vueState.breakpoints.find(el => el && el.key === self.vueState.breakpointActive)
                    const bpNext = self.vueState.breakpoints[self.vueState.breakpoints.indexOf(bp) + 1];
                    if(el.dataset.click === 'true') {
                        toolbarItems.forEach(el => el.removeAttribute('data-click'))
                        let minValue;

                        // Calculate  minValue
                        if(isMobileFirst){
                            self.vueState.previewWrapperWidth > bp.width ? minValue = self.vueState.previewWrapperWidth : minValue = 1400
                        } else {
                            isMobile(bp) && bp.hasOwnProperty('widthBuilder') ? minValue = bp.widthBuilder : minValue = 320
                        }
                        
                        // Calculate previewWidth
                        if(bpNext) {
                            const nextValue = isMobileFirst ? bpNext.width - 1 : bpNext.width + 1;
                            self.vueState.previewWidth = nextValue;
                        } else {
                            self.vueState.previewWidth = minValue
                        }
                    } else {
                        toolbarItems.forEach(el => el.removeAttribute('data-click'))
                        el.setAttribute('data-click', 'true');
                        if((!isMobileFirst && isDesktop(bp) && bp.hasOwnProperty('widthBuilder')) || (isMobileFirst && isMobile(bp) && bp.hasOwnProperty('widthBuilder'))){
                            self.vueState.previewWidth = bp.widthBuilder;
                        } else if(!isMobileFirst && isDesktop(bp) && self.vueState.previewWrapperWidth > bp.width){
                            self.vueState.previewWidth = self.vueState.previewWrapperWidth;
                        } else {
                            self.vueState.previewWidth = bp.width;
                        }
                    }
                }

                slider.value = self.vueState.previewWidth;
            })

            const input = el.querySelector('input');
            if(!input) return;
            input.addEventListener('keyup', () => {
                setTimeout(() => {
                    slider.value = self.vueState.previewWidth;
                },1)
            })
        })

        const firstBp = document.querySelectorAll('#bricks-toolbar li.breakpoint')[0];
        firstBp.setAttribute('data-click', 'true');

    },
    responsiveBar: function(target){
        const self = this;
        self.vueState.previewWidth = target.value;

        if (self.debounceTimer) {
            clearTimeout(self.debounceTimer);
        }

        self.debounceTimer = setTimeout(() => {
            const original = self.vueState.breakpoints;
            const bps = original.slice();
            let device;
            bps.forEach(bp => {
                if(self.vueGlobalProp.$_isMobileFirst._value){
                    if (target.value >= bp.width) device = bp.key;
                } else {
                    if (target.value <= bp.width) device = bp.key;
                }
            })

            device ? self.vueState.breakpointActive = device : self.vueState.breakpointActive = self.vueState.breakpoints[0].key;
            setTimeout(() => self.vueState.previewWidth = target.value, 0);
        }, 100);
    },
    hideEmptyElementCategory: function(){
        const cats = document.querySelectorAll('#bricks-panel-elements-categories .category');
        if(!cats || cats.length < 1) return;
        cats.forEach(cat => {
            const els = cat.querySelectorAll('.sortable-wrapper > li');
            if(!els || els.length < 1) return;
            let isHidden = true;
            els.forEach(el => {
                const display = window.getComputedStyle( el ,null).getPropertyValue('display');
                if(display !== 'none') isHidden = false;
            })
            if(isHidden) cat.style.display = "none";
        })
    },
    structureOffsetX: null,
    structureOffsetY: null,
    draggableStructurePanel: function () {
        const self = this;
        const structure = document.querySelector('#bricks-structure');
        const preview = document.querySelector('#bricks-preview');
        const header = structure.querySelector('#bricks-panel-header');
    
        function move(e) {
            structure.style.setProperty('--right', `${e.clientX - self.structureOffsetX}px`);
            structure.style.setProperty('--width', `${self.globalSettings.structurePanelWidth}px`);
            structure.style.setProperty('--top', `${e.clientY - self.structureOffsetY}px`);
            //structure.style.right = `calc(100% - ${e.clientX - self.structureOffsetX}px - ${self.globalSettings.structurePanelWidth}px)`;
            //structure.style.top = `${e.clientY - self.structureOffsetY}px`;
        }
    
        let structureIsDraggable = false; // Track the draggable state
    
        function toggleDraggableState() {
            structureIsDraggable = !structureIsDraggable;
            structure.setAttribute('data-draggable', structureIsDraggable);
            preview.setAttribute('data-draggable', structureIsDraggable);
        }
    
        function setupDraggable() {
            header.addEventListener("mousedown", handleMouseDown);
            document.addEventListener("mouseup", handleMouseUp);
        }
    
        function resetDraggable() {
            // structure.removeAttribute('style');
            // structure.style.width = `${self.globalSettings.structurePanelWidth}px`;
            // const shortcuts = document.querySelector('#bricks-structure .brxce-panel-shortcut__wrapper');
            // shortcuts ? shortcuts.removeAttribute('style') : '';
            header.removeEventListener("mousedown", handleMouseDown);
            document.removeEventListener("mouseup", handleMouseUp);
        }
    
        function handleDoubleClick() {
            toggleDraggableState();
            structureIsDraggable ? setupDraggable() : resetDraggable();
        }
    
        function handleMouseDown(e) {
            preview.style.pointerEvents = "none";
            self.structureOffsetX = e.clientX - structure.offsetLeft;
            self.structureOffsetY = e.clientY - structure.offsetTop;
            document.addEventListener('mousemove', move);
        }
    
        function handleMouseUp() {
            preview.style.pointerEvents = "auto";
            document.removeEventListener("mousemove", move);
        }
    
        // Initial setup
        header.addEventListener('dblclick', handleDoubleClick);
    },
    templateAutoselect: function(input){
        if(input && input.checked === false) input.click();
    },
    initPreviewObservers: function() {
        const self = this;
        const contextualMenu = document.querySelector('#bricks-preview');
    
        const observer = new MutationObserver(function(mutations) {
            mutations.forEach(function(mutation) {
                if (mutation.addedNodes && mutation.addedNodes.length > 0) {
                    // Check if any added node has the class "test"
                    const hasTestClass = Array.from(mutation.addedNodes).some(node => node.id === "bricks-popup" && node.classList.contains('templates'));
    
                    if (hasTestClass && !self.vueState.brxcRunningObserverTemplate) {
                        self.vueState.brxcRunningObserverTemplate = true;
    
                        if (self.helpers.isBuilderTweaksTabActive('templates')) {
                            Object.values(self.globalSettings.templateFeatures).includes("import-images") ? self.templateAutoselect(contextualMenu.querySelector('input#importImages')) : '';
                            Object.values(self.globalSettings.templateFeatures).includes("replace-content") ? self.templateAutoselect(contextualMenu.querySelector('input#replaceContent')) : '';
                        }
    
                        setTimeout(() => self.vueState.brxcRunningObserverTemplate = false, 150);
                    }
                }
            });
        });
    
        observer.observe(contextualMenu, { subtree: true, childList: true });
    },
    init: function(){
        const self = this;
        self.vueState.brxc = [];
        // States
        self.initStates();

        // Observers
        self.initObservers();
        self.initContextualMenuObservers();
        self.initPreviewObservers()

        // Functions
        self.setColorVariablesOnLoad();
        self.generateVariableCSS('global');
        self.generateVariableCSS('theme');
        self.generateBuilderCSS();
        self.setIsotope('body');
        self.setCodeMirror();
        self.setControlsOptions();
        self.toggleRadioVisibility();
        self.setAlertMsg();
        self.setStructurePanelWidth();
        self.hideEmptyElementCategory();

        // AI
        (self.helpers.isAIActive()) ? self.initAcc('.accordion.v1', true) : '';

        // Classes & Styles
        (self.helpers.isClassesAndStylesTabActive('class-importer') ) ? self.importedClasses() : '';
        (self.helpers.isClassesAndStylesTabActive('grids') ) ? self.importedGrids() : '';


        // Builder Tweaks
        //// Topbar
        if(self.helpers.isBuilderTweaksTabActive('global-features')){
            self.initGridGuide();
            Object.values(self.globalSettings.globalFeatures).includes('responsive-helper') ? self.setResponsiveBar() : '';
            self.populateClassCategories();
        }

        //// Structure Panels
        if(self.helpers.isBuilderTweaksTabActive('structure-panel')){
            (self.globalSettings.structurePanelContextualMenu.length > 0) ? self.setContextualMenuItems() : '';
            (self.globalSettings.structurePanelIcons.length > 0) ? self.setHeaderStructurePanel() : '';
            Object.values(self.globalSettings.structurePanelGeneralTweaks).includes('resizable-structure-panel') ? self.resizableStructurePanel() : '';
            Object.values(self.globalSettings.structurePanelGeneralTweaks).includes('new-element-shortcuts') && self.globalSettings.createElementsShortcuts.length>0 ? self.setRightShortcutCol() : '';
            Object.values(self.globalSettings.structurePanelGeneralTweaks).includes('styles-and-classes-indicators') ? self.setColorsforStructureIndicators() : '';
            Object.values(self.globalSettings.structurePanelGeneralTweaks).includes("highlight-nestable-elements") ? self.populateNestableElements() : '';
            Object.values(self.globalSettings.structurePanelGeneralTweaks).includes('draggable-structure-panel') ? self.draggableStructurePanel() : '';
            Object.values(self.globalSettings.structurePanelGeneralTweaks).includes('multiselect') ? self.setMultiSelect() : '';
        } 

        //// Classes and Styles
        if(self.helpers.isBuilderTweaksTabActive('classes-and-styles')){
            Object.values(self.globalSettings.classFeatures).includes("disable-id-styles") ? document.body.setAttribute('data-disable-styles', "true") : '';
            Object.values(self.globalSettings.classFeatures).includes("reorder-classes") ? self.reorderClasses() : '';
            Object.values(self.globalSettings.classFeatures).includes("group-classes-by-lock-status") ? self.groupClassesByLockStatus() : '';
            Object.values(self.globalSettings.classFeatures).includes("locked-class-indicator") ? document.body.setAttribute('data-locked-classes', "true") : '';
            Object.values(self.globalSettings.classFeatures).includes("autocomplete-variable") ? self.populateCSSVariables() : '';
            Object.values(self.globalSettings.classFeatures).includes("scoped-variables") ? self.scopedVariablesCSS() : '';
        }

        //// Elements
        if(self.helpers.isBuilderTweaksTabActive('elements')){
            Object.values(self.globalSettings.elementFeatures).includes("pseudo-shortcut") ? self.setDefaultPseudoClasses() : '';
            if(Object.values(self.globalSettings.elementFeatures).includes("resize-elements-icons")) {
                self.setElementsColumns();
                self.setColumnNumber(self.globalSettings.defaultElementsCol);
            }
            if(Object.values(self.globalSettings.elementFeatures).includes("superpower-custom-css")) {
                document.body.setAttribute('data-superpower-css', 'true');
            }
            Object.values(self.globalSettings.defaultElementFeatures.length > 0) ? self.setDefaultElements() : '';
            // SASS INTEGRATION
            //(!self.globalSettings.enableSASSinSuperPowerCSS) ? self.cleanSassValues() : '';
        }

        //// Keyboard Shortcuts
        if(self.helpers.isBuilderTweaksTabActive('keyboard-shortcuts')){
            Object.values(self.globalSettings.keyboardShortcuts.options).includes("move-element") ?self.setStructurePanelKeyboardShortcuts() : '';
            Object.values(self.globalSettings.keyboardShortcuts.options).includes("open-at-modal") ? self.setKeyboardShortcuts() : '';
            self.setGlobalKeyboardsh();
        }

        //// Run state functions
       self.runStateFunctions();

    }
}
//ADMINBRXC.initPageCSS()
window.addEventListener('DOMContentLoaded', () => {
    ADMINBRXC.initToolbar();
})
window.addEventListener('load', () => {
    if (ADMINBRXC.helpers.isClassesAndStylesTabActive('grids') === false && typeof ADMINBRXC.vueState !== "undefined") {
        if(ADMINBRXC.vueState.hasOwnProperty('globalClasses') && ADMINBRXC.vueState.globalClasses && Array.isArray(ADMINBRXC.vueState.globalClasses) && ADMINBRXC.vueState.globalClasses.length > 0) ADMINBRXC.vueState.globalClasses = JSON.parse(JSON.stringify(ADMINBRXC.vueState.globalClasses.filter(item => item && item.hasOwnProperty('id') && !item.id.startsWith("brxc_grid"))));
        if(ADMINBRXC.vueState.hasOwnProperty('globalClassesLocked') && ADMINBRXC.vueState.globalClassesLocked && Array.isArray(ADMINBRXC.vueState.globalClassesLocked) && ADMINBRXC.vueState.globalClassesLocked.length > 0) ADMINBRXC.vueState.globalClassesLocked = JSON.parse(JSON.stringify(ADMINBRXC.vueState.globalClassesLocked.filter(item => item && typeof item === "string" && !item.startsWith("brxc_grid"))));
        ADMINBRXC.helpers.saveChanges('globalClasses');
        ADMINBRXC.helpers.saveChanges('globalClassesLocked');
    }
    if (ADMINBRXC.helpers.isClassesAndStylesTabActive('class-importer') === false && typeof ADMINBRXC.vueState !== "undefined") {
        if(ADMINBRXC.vueState.hasOwnProperty('globalClasses') && ADMINBRXC.vueState.globalClasses && Array.isArray(ADMINBRXC.vueState.globalClasses) && ADMINBRXC.vueState.globalClasses.length > 0) ADMINBRXC.vueState.globalClasses = JSON.parse(JSON.stringify(ADMINBRXC.vueState.globalClasses.filter(item => item && item.hasOwnProperty('id') && !item.id.startsWith("brxc_imported"))));
        if(ADMINBRXC.vueState.hasOwnProperty('globalClassesLocked') && ADMINBRXC.vueState.globalClassesLocked && Array.isArray(ADMINBRXC.vueState.globalClassesLocked) && ADMINBRXC.vueState.globalClassesLocked.length > 0) ADMINBRXC.vueState.globalClassesLocked = JSON.parse(JSON.stringify(ADMINBRXC.vueState.globalClassesLocked.filter(item => item && typeof item === "string" && !item.startsWith("brxc_imported"))));
        ADMINBRXC.helpers.saveChanges('globalClasses');
        ADMINBRXC.helpers.saveChanges('globalClassesLocked');
    } 

    // Lock imported classes and grid
    if (ADMINBRXC.vueState.globalClasses.length > 0){
        if(!Array.isArray(ADMINBRXC.vueState.globalClassesLocked)) ADMINBRXC.vueState.globalClassesLocked = [];
        const classToBeLocked = Array.from(ADMINBRXC.vueState.globalClasses)
            .filter(el => el && el.hasOwnProperty('id') && (el.id.startsWith("brxc_imported") || el.id.startsWith("brxc_grid")))
            .map(el => el.id);

        ADMINBRXC.vueState.globalClassesLocked = [...new Set(ADMINBRXC.vueState.globalClassesLocked.concat(classToBeLocked))];
        ADMINBRXC.helpers.saveChanges('globalClassesLocked');
    }

    // Sanitize classes

    if (ADMINBRXC.vueState.globalClasses.length > 0){

        // Remove inexisting classes in the element's post
        const templateType = ADMINBRXC.helpers.getTemplateType();
        const content = ADMINBRXC.vueState[templateType];
        if(Array.isArray(content) && content.length > 0){
            let hasChanges = false;
            const hasGlobalClass = Array.from(content).filter(el => el && el.settings.hasOwnProperty('_cssGlobalClasses') && Array.isArray(el.settings._cssGlobalClasses) && el.settings._cssGlobalClasses.length > 0 );
            if(hasGlobalClass.length > 0){
                hasGlobalClass.forEach(el => {
                    el.settings._cssGlobalClasses.forEach(cls => {
                        const exist = Array.from(ADMINBRXC.vueState.globalClasses).find(b => b && b.hasOwnProperty('id') &&  b.id === cls)
                        if(exist) return;

                        const index = el.settings._cssGlobalClasses.indexOf(cls);
                        el.settings._cssGlobalClasses.splice(index, 1);
                        hasChanges = true;
                    })
                })
                if(hasChanges) ADMINBRXC.helpers.saveChanges('globalClasses');;
            }
        }

        // add settings object
        const noSettings = Array.from(ADMINBRXC.vueState.globalClasses).filter(el => el && el.hasOwnProperty('id') && !el.hasOwnProperty('settings'));
        if(noSettings.length > 0){
            noSettings.forEach(el =>{
                el.settings = {};
            })
            ADMINBRXC.helpers.saveChanges('globalClasses');
        }


        // Fix Class Categories
        const classesWithCat = Array.from(ADMINBRXC.vueState.globalClasses).filter(el => el && el.hasOwnProperty('cat') && el.cat);
        if (classesWithCat.length > 0 && typeof ADMINBRXC.vueState.globalClassesCategories !== "undefined"){
            classesWithCat.forEach(el => {
                const categoryFound = ADMINBRXC.helpers.getClassCategoryObjByName(el.cat);
                if (categoryFound){
                    el.category = categoryFound.id;
                    delete el.cat
                } else {
                    const id = ADMINBRXC.vueGlobalProp.$_generateId();
                    ADMINBRXC.vueState.globalClassesCategories.push({
                        id: id,
                        name: el.cat,
                    })
                    el.category = id;
                    delete el.cat;
                }
            })
        }
        
    }

    

    
    // Init
    ADMINBRXC.init()
    document.querySelectorAll('.brxc-overlay__wrapper').forEach(el => el.removeAttribute('style'));
    (ADMINBRXC.helpers.isBuilderTweaksTabActive() && Object.values(ADMINBRXC.globalSettings.elementShortcutIcons).includes("tabs-shortcuts") && ADMINBRXC.globalSettings.shortcutsTabs.length > 0) ? document.body.classList.add('brxc-has-panel-shortcuts') : '';



    //FRAME
    FRAMEBRXC.content = document.querySelector('#bricks-builder-iframe').contentDocument;
    FRAMEBRXC.vue = document.querySelector('#bricks-builder-iframe').contentDocument.querySelector('.brx-body').__vue_app__;
    FRAMEBRXC.vueGlobalProp = document.querySelector('#bricks-builder-iframe').contentDocument.querySelector('.brx-body').__vue_app__.config.globalProperties;
    FRAMEBRXC.vueState = document.querySelector('#bricks-builder-iframe').contentDocument.querySelector('.brx-body').__vue_app__.config.globalProperties.$_state;
})
