<?php
namespace Advanced_Themer_Bricks;
if (!defined('ABSPATH')) { die();
}

/*--------------------------------------
Variables
--------------------------------------*/

// ID & Classes
$overlay_id = 'brxcBoxShadowUIOverlay';
$prefix = "box-shadow-ui";
$prefix_id = 'brxcGBoxShadowUI';
$prefix_class = 'brxc-box-shadow-ui';
// Heading
$modal_heading_title = 'Box-shadow Generator';
$examples_JSON = '["rgba(0, 0, 0, 0.45) 0px -25px 20px -20px","rgba(0, 0, 0, 0.45) 25px 0px 20px -20px","rgba(0, 0, 0, 0.45) 0px 25px 20px -20px","rgba(0, 0, 0, 0.45) -25px 0px 20px -20px","rgba(0, 0, 0, 0.45) 0px -25px 20px -20px, rgba(0, 0, 0, 0.45) 25px 0px 20px -20px","rgba(0, 0, 0, 0.45) 0px -25px 20px -20px, rgba(0, 0, 0, 0.45) 0px 25px 20px -20px","rgba(0, 0, 0, 0.45) 0px -25px 20px -20px, rgba(0, 0, 0, 0.45) -25px 0px 20px -20px","rgba(0, 0, 0, 0.45) 0px 25px 20px -20px, rgba(0, 0, 0, 0.45) 25px 0px 20px -20px","rgba(0, 0, 0, 0.45) 0px 25px 20px -20px, rgba(0, 0, 0, 0.45) -25px 0px 20px -20px","rgba(0, 0, 0, 0.45) 25px 0px 20px -20px, rgba(0, 0, 0, 0.45) -25px 0px 20px -20px","rgba(0, 0, 0, 0.45) 0px -25px 20px -20px, rgba(0, 0, 0, 0.45) 0px 25px 20px -20px, rgba(0, 0, 0, 0.45) 25px 0px 20px -20px","rgba(0, 0, 0, 0.45) 0px -25px 20px -20px, rgba(0, 0, 0, 0.45) 0px 25px 20px -20px, rgba(0, 0, 0, 0.45) -25px 0px 20px -20px","rgba(0, 0, 0, 0.45) 0px -25px 20px -20px, rgba(0, 0, 0, 0.45) 25px 0px 20px -20px, rgba(0, 0, 0, 0.45) 0px 25px 20px -20px, rgba(0, 0, 0, 0.45) -25px 0px 20px -20px","rgba(0, 0, 0, 0.12) 0px 1px 3px 0px, rgba(0, 0, 0, 0.24) 0px 1px 2px 0px","rgba(0, 0, 0, 0.16) 0px 3px 6px 0px, rgba(0, 0, 0, 0.23) 0px 3px 6px 0px","rgba(0, 0, 0, 0.19) 0px 10px 20px 0px, rgba(0, 0, 0, 0.23) 0px 6px 6px 0px","rgba(0, 0, 0, 0.25) 0px 14px 28px 0px, rgba(0, 0, 0, 0.22) 0px 10px 10px 0px","rgba(0, 0, 0, 0.3) 0px 19px 38px 0px, rgba(0, 0, 0, 0.22) 0px 15px 12px 0px","rgba(0, 0, 0, 0.4) 0px 29px 52px 0px, rgba(0, 0, 0, 0.2) 0px 25px 16px 0px","rgba(0, 0, 0, 0.5) 0px 45px 65px 0px, rgba(0, 0, 0, 0.16) 0px 35px 22px 0px","rgba(0, 0, 0, 0.6) 0px 60px 80px 0px, rgba(0, 0, 0, 0.14) 0px 45px 26px 0px","rgba(0, 0, 0, 0.12) 0px 1px 1px 0px, rgba(0, 0, 0, 0.12) 0px 2px 2px 0px","rgba(0, 0, 0, 0.12) 0px 1px 1px 0px, rgba(0, 0, 0, 0.12) 0px 2px 2px 0px, rgba(0, 0, 0, 0.12) 0px 4px 4px 0px, rgba(0, 0, 0, 0.12) 0px 8px 8px 0px, rgba(0, 0, 0, 0.12) 0px 16px 16px 0px","rgba(0, 0, 0, 0.15) 0px 1px 1px 0px, rgba(0, 0, 0, 0.15) 0px 2px 2px 0px, rgba(0, 0, 0, 0.15) 0px 4px 4px 0px, rgba(0, 0, 0, 0.15) 0px 8px 8px 0px","rgba(0, 0, 0, 0.11) 0px 1px 1px 0px, rgba(0, 0, 0, 0.11) 0px 2px 2px 0px, rgba(0, 0, 0, 0.11) 0px 4px 4px 0px, rgba(0, 0, 0, 0.11) 0px 8px 8px 0px, rgba(0, 0, 0, 0.11) 0px 16px 16px 0px, rgba(0, 0, 0, 0.11) 0px 32px 32px 0px","rgba(0, 0, 0, 0.08) 0px 1px 1px 0px, rgba(0, 0, 0, 0.12) 0px 2px 2px 0px, rgba(0, 0, 0, 0.16) 0px 4px 4px 0px, rgba(0, 0, 0, 0.2) 0px 8px 8px 0px","rgba(0, 0, 0, 0.07) 0px 1px 2px 0px, rgba(0, 0, 0, 0.07) 0px 2px 4px 0px, rgba(0, 0, 0, 0.07) 0px 4px 8px 0px, rgba(0, 0, 0, 0.07) 0px 8px 16px 0px, rgba(0, 0, 0, 0.07) 0px 16px 32px 0px, rgba(0, 0, 0, 0.07) 0px 32px 64px 0px","rgba(0, 0, 0, 0.11) 0px 1px 1px 0px, rgba(0, 0, 0, 0.11) 0px 2px 2px 0px, rgba(0, 0, 0, 0.11) 0px 4px 4px 0px, rgba(0, 0, 0, 0.11) 0px 6px 8px 0px, rgba(0, 0, 0, 0.11) 0px 8px 16px 0px","rgba(0, 0, 0, 0.09) 0px 2px 1px 0px, rgba(0, 0, 0, 0.09) 0px 4px 2px 0px, rgba(0, 0, 0, 0.09) 0px 8px 4px 0px, rgba(0, 0, 0, 0.09) 0px 16px 8px 0px, rgba(0, 0, 0, 0.09) 0px 32px 16px 0px","rgba(0, 0, 0, 0.05) 0px 1px 2px 0px","rgba(0, 0, 0, 0.1) 0px 1px 3px 0px, rgba(0, 0, 0, 0.1) 0px 1px 2px -1px","rgba(0, 0, 0, 0.1) 0px 10px 15px -3px, rgba(0, 0, 0, 0.1) 0px 4px 6px -4px","rgba(0, 0, 0, 0.1) 0px 20px 25px -5px, rgba(0, 0, 0, 0.1) 0px 8px 10px -6px","rgba(0, 0, 0, 0.25) 0px 25px 50px -12px","rgba(0, 0, 0, 0.13) 0px 2px 4px 0px, rgba(0, 0, 0, 0.11) 0px 1px 1px 0px","rgba(0, 0, 0, 0.13) 0px 3px 7px 0px, rgba(0, 0, 0, 0.11) 0px 1px 2px 0px","rgba(0, 0, 0, 0.13) 0px 7px 15px 0px, rgba(0, 0, 0, 0.11) 0px 1px 4px 0px","rgba(0, 0, 0, 0.22) 0px 26px 58px 0px, rgba(0, 0, 0, 0.18) 0px 5px 14px 0px","rgba(0, 0, 0, 0.075) 0px 2px 4px 0px","rgba(0, 0, 0, 0.15) 0px 8px 16px 0px","rgba(0, 0, 0, 0.176) 0px 16px 48px 0px","rgba(27, 31, 36, 0.04) 0px 1px 0px 0px","rgba(140, 149, 159, 0.15) 0px 3px 6px 0px","rgba(140, 149, 159, 0.2) 0px 8px 24px 0px","rgba(140, 149, 159, 0.3) 0px 12px 28px 0px","rgba(150, 170, 180, 0.5) 0px 7px 30px -10px","rgba(0, 0, 0, 0.15) 2px 2px 2px 0px","rgba(0, 0, 0, 0.2) 0px 2px 4px 0px","rgba(0, 0, 0, 0.2) 0px 20px 50px -10px","rgba(0, 0, 0, 0.15) 0px 80px 50px -30px","rgba(0, 0, 0, 0.15) 0px 25px 80px 0px","rgba(0, 0, 0, 0.5) 0px 25px 80px 0px","rgba(0, 0, 0, 0.2) 0px 15px 20px 0px","rgba(0, 0, 0, 0.05) 0px 0px 0px 5px","rgba(0, 0, 0, 1) 8px 8px 0px 0px","rgba(33, 33, 33, 1) -10px 10px 0px 0px, rgba(33, 33, 33, 0.7) -20px 20px 0px 0px, rgba(33, 33, 33, 0.4) -30px 30px 0px 0px, rgba(33, 33, 33, 0.1) -40px 40px 0px 0px","rgba(0, 0, 0, 0.45) 0px 0px 40px 0px","rgba(221, 221, 221, 1) 0px 10px 1px 0px, rgba(204, 204, 204, 1) 0px 10px 20px 0px","rgba(9, 30, 66, 0.25) 0px 1px 1px 0px, rgba(9, 30, 66, 0.13) 0px 0px 1px 1px","rgba(0, 0, 0, 0.16) 0px 1px 4px 0px, rgba(51, 51, 51, 1) 0px 0px 0px 3px","rgba(0, 0, 0, 0.02) 0px 1px 3px 0px, rgba(27, 31, 35, 0.15) 0px 0px 0px 1px","rgba(9, 30, 66, 0.25) 0px 4px 8px -2px, rgba(9, 30, 66, 0.08) 0px 0px 0px 1px","rgba(0, 0, 0, 0.22) 0px 1px 0px 0px, rgba(0, 0, 0, 0.22) 1px 0px 0px 0px, rgba(0, 0, 0, 0.22) 1px 2px 0px 0px, rgba(0, 0, 0, 0.22) 2px 1px 0px 0px, rgba(0, 0, 0, 0.22) 2px 3px 0px 0px, rgba(0, 0, 0, 0.22) 3px 2px 0px 0px, rgba(0, 0, 0, 0.22) 3px 4px 0px 0px, rgba(0, 0, 0, 0.22) 4px 3px 0px 0px, rgba(0, 0, 0, 0.22) 4px 5px 0px 0px, rgba(0, 0, 0, 0.22) 5px 4px 0px 0px, rgba(0, 0, 0, 0.22) 5px 6px 0px 0px, rgba(0, 0, 0, 0.22) 6px 5px 0px 0px, rgba(0, 0, 0, 0.22) 6px 7px 0px 0px, rgba(0, 0, 0, 0.22) 7px 6px 0px 0px, rgba(0, 0, 0, 0.22) 7px 8px 0px 0px, rgba(0, 0, 0, 0.22) 8px 7px 0px 0px","rgba(0, 0, 0, 0.24) 0px 3px 8px 0px","rgba(13, 38, 76, 0.19) 0px 9px 20px 0px","rgba(0, 0, 0, 0.04) 0px 3px 5px 0px","rgba(148, 0, 211, 1) 0px 0px 0px 3px, rgba(75, 0, 130, 1) 0px 0px 0px 6px, rgba(0, 0, 255, 1) 0px 0px 0px 9px, rgba(0, 255, 0, 1) 0px 0px 0px 12px, rgba(255, 255, 0, 1) 0px 0px 0px 15px, rgba(255, 127, 0, 1) 0px 0px 0px 18px, rgba(255, 0, 0, 1) 0px 0px 0px 21px","rgba(148, 0, 211, 1) 0px 0px 0px 2px, rgba(255, 255, 255, 1) 15px -15px 0px -2px, rgba(75, 0, 130, 1) 15px -15px 0px 0px, rgba(255, 255, 255, 1) 30px -30px 0px -2px, rgba(0, 0, 255, 1) 30px -30px 0px 0px, rgba(255, 255, 255, 1) 45px -45px 0px -2px, rgba(0, 255, 0, 1) 45px -45px 0px 0px, rgba(255, 255, 255, 1) 60px -60px 0px -2px, rgba(255, 255, 0, 1) 60px -60px 0px 0px, rgba(255, 255, 255, 1) 75px -75px 0px -2px, rgba(255, 127, 0, 1) 75px -75px 0px 0px, rgba(255, 255, 255, 1) 90px -90px 0px -2px, rgba(255, 0, 0, 1) 90px -90px 0px 0px","rgba(65, 117, 5, 1) 0px 5px 0px 0px, rgba(65, 117, 5, 0.6) 0px 10px 0px 0px, rgba(65, 117, 5, 0.4) 0px 15px 0px 0px, rgba(65, 117, 5, 0.2) 0px 20px 0px 0px, rgba(65, 117, 5, 0.1) 0px 25px 0px 0px","rgba(65, 117, 5, 1) 5px 5px 0px 0px, rgba(65, 117, 5, 0.6) 10px 10px 0px 0px, rgba(65, 117, 5, 0.4) 15px 15px 0px 0px, rgba(65, 117, 5, 0.2) 20px 20px 0px 0px, rgba(65, 117, 5, 0.1) 25px 25px 0px 0px","rgba(65, 117, 5,1) -5px 5px 0px 0px, rgba(65, 117, 5, 0.6) -10px 10px 0px 0px, rgba(65, 117, 5, 0.4) -15px 15px 0px 0px, rgba(65, 117, 5, 0.2) -20px 20px 0px 0px, rgba(65, 117, 5, 0.1) -25px 25px 0px 0px","rgba(218, 102, 123, 1) 0px 0px 0px 2px, rgba(218, 102, 123, 1) 8px 8px 0px 0px","rgba(255, 149, 5, 0.1) 0px 9px 30px 0px","rgba(255, 149, 5, 0.3) 0px 9px 30px 0px"]';
$JSON_2 = '[[{"rgb":"0,0,0","alpha":0.45,"x":0,"y":-25,"blur":20,"spread":-20}],[{"rgb":"0,0,0","alpha":0.45,"x":25,"y":0,"blur":20,"spread":-20}],[{"rgb":"0,0,0","alpha":0.45,"x":0,"y":25,"blur":20,"spread":-20}],[{"rgb":"0,0,0","alpha":0.45,"x":-25,"y":0,"blur":20,"spread":-20}],[{"rgb":"0,0,0","alpha":0.45,"x":0,"y":-25,"blur":20,"spread":-20},{"rgb":"0,0,0","alpha":0.45,"x":25,"y":0,"blur":20,"spread":-20}],[{"rgb":"0,0,0","alpha":0.45,"x":0,"y":-25,"blur":20,"spread":-20},{"rgb":"0,0,0","alpha":0.45,"x":0,"y":25,"blur":20,"spread":-20}],[{"rgb":"0,0,0","alpha":0.45,"x":0,"y":-25,"blur":20,"spread":-20},{"rgb":"0,0,0","alpha":0.45,"x":-25,"y":0,"blur":20,"spread":-20}],[{"rgb":"0,0,0","alpha":0.45,"x":0,"y":25,"blur":20,"spread":-20},{"rgb":"0,0,0","alpha":0.45,"x":25,"y":0,"blur":20,"spread":-20}],[{"rgb":"0,0,0","alpha":0.45,"x":0,"y":25,"blur":20,"spread":-20},{"rgb":"0,0,0","alpha":0.45,"x":-25,"y":0,"blur":20,"spread":-20}],[{"rgb":"0,0,0","alpha":0.45,"x":25,"y":0,"blur":20,"spread":-20},{"rgb":"0,0,0","alpha":0.45,"x":-25,"y":0,"blur":20,"spread":-20}],[{"rgb":"0,0,0","alpha":0.45,"x":0,"y":-25,"blur":20,"spread":-20},{"rgb":"0,0,0","alpha":0.45,"x":0,"y":25,"blur":20,"spread":-20},{"rgb":"0,0,0","alpha":0.45,"x":25,"y":0,"blur":20,"spread":-20}],[{"rgb":"0,0,0","alpha":0.45,"x":0,"y":-25,"blur":20,"spread":-20},{"rgb":"0,0,0","alpha":0.45,"x":0,"y":25,"blur":20,"spread":-20},{"rgb":"0,0,0","alpha":0.45,"x":-25,"y":0,"blur":20,"spread":-20}],[{"rgb":"0,0,0","alpha":0.45,"x":0,"y":-25,"blur":20,"spread":-20},{"rgb":"0,0,0","alpha":0.45,"x":25,"y":0,"blur":20,"spread":-20},{"rgb":"0,0,0","alpha":0.45,"x":0,"y":25,"blur":20,"spread":-20},{"rgb":"0,0,0","alpha":0.45,"x":-25,"y":0,"blur":20,"spread":-20}],[{"rgb":"0,0,0","alpha":0.12,"x":0,"y":1,"blur":3,"spread":0},{"rgb":"0,0,0","alpha":0.24,"x":0,"y":1,"blur":2,"spread":0}],[{"rgb":"0,0,0","alpha":0.16,"x":0,"y":3,"blur":6,"spread":0},{"rgb":"0,0,0","alpha":0.23,"x":0,"y":3,"blur":6,"spread":0}],[{"rgb":"0,0,0","alpha":0.19,"x":0,"y":10,"blur":20,"spread":0},{"rgb":"0,0,0","alpha":0.23,"x":0,"y":6,"blur":6,"spread":0}],[{"rgb":"0,0,0","alpha":0.25,"x":0,"y":14,"blur":28,"spread":0},{"rgb":"0,0,0","alpha":0.22,"x":0,"y":10,"blur":10,"spread":0}],[{"rgb":"0,0,0","alpha":0.3,"x":0,"y":19,"blur":38,"spread":0},{"rgb":"0,0,0","alpha":0.22,"x":0,"y":15,"blur":12,"spread":0}],[{"rgb":"0,0,0","alpha":0.4,"x":0,"y":29,"blur":52,"spread":0},{"rgb":"0,0,0","alpha":0.2,"x":0,"y":25,"blur":16,"spread":0}],[{"rgb":"0,0,0","alpha":0.5,"x":0,"y":45,"blur":65,"spread":0},{"rgb":"0,0,0","alpha":0.16,"x":0,"y":35,"blur":22,"spread":0}],[{"rgb":"0,0,0","alpha":0.6,"x":0,"y":60,"blur":80,"spread":0},{"rgb":"0,0,0","alpha":0.14,"x":0,"y":45,"blur":26,"spread":0}],[{"rgb":"0,0,0","alpha":0.12,"x":0,"y":1,"blur":1,"spread":0},{"rgb":"0,0,0","alpha":0.12,"x":0,"y":2,"blur":2,"spread":0}],[{"rgb":"0,0,0","alpha":0.12,"x":0,"y":1,"blur":1,"spread":0},{"rgb":"0,0,0","alpha":0.12,"x":0,"y":2,"blur":2,"spread":0},{"rgb":"0,0,0","alpha":0.12,"x":0,"y":4,"blur":4,"spread":0},{"rgb":"0,0,0","alpha":0.12,"x":0,"y":8,"blur":8,"spread":0},{"rgb":"0,0,0","alpha":0.12,"x":0,"y":16,"blur":16,"spread":0}],[{"rgb":"0,0,0","alpha":0.15,"x":0,"y":1,"blur":1,"spread":0},{"rgb":"0,0,0","alpha":0.15,"x":0,"y":2,"blur":2,"spread":0},{"rgb":"0,0,0","alpha":0.15,"x":0,"y":4,"blur":4,"spread":0},{"rgb":"0,0,0","alpha":0.15,"x":0,"y":8,"blur":8,"spread":0}],[{"rgb":"0,0,0","alpha":0.11,"x":0,"y":1,"blur":1,"spread":0},{"rgb":"0,0,0","alpha":0.11,"x":0,"y":2,"blur":2,"spread":0},{"rgb":"0,0,0","alpha":0.11,"x":0,"y":4,"blur":4,"spread":0},{"rgb":"0,0,0","alpha":0.11,"x":0,"y":8,"blur":8,"spread":0},{"rgb":"0,0,0","alpha":0.11,"x":0,"y":16,"blur":16,"spread":0},{"rgb":"0,0,0","alpha":0.11,"x":0,"y":32,"blur":32,"spread":0}],[{"rgb":"0,0,0","alpha":0.08,"x":0,"y":1,"blur":1,"spread":0},{"rgb":"0,0,0","alpha":0.12,"x":0,"y":2,"blur":2,"spread":0},{"rgb":"0,0,0","alpha":0.16,"x":0,"y":4,"blur":4,"spread":0},{"rgb":"0,0,0","alpha":0.2,"x":0,"y":8,"blur":8,"spread":0}],[{"rgb":"0,0,0","alpha":0.07,"x":0,"y":1,"blur":2,"spread":0},{"rgb":"0,0,0","alpha":0.07,"x":0,"y":2,"blur":4,"spread":0},{"rgb":"0,0,0","alpha":0.07,"x":0,"y":4,"blur":8,"spread":0},{"rgb":"0,0,0","alpha":0.07,"x":0,"y":8,"blur":16,"spread":0},{"rgb":"0,0,0","alpha":0.07,"x":0,"y":16,"blur":32,"spread":0},{"rgb":"0,0,0","alpha":0.07,"x":0,"y":32,"blur":64,"spread":0}],[{"rgb":"0,0,0","alpha":0.11,"x":0,"y":1,"blur":1,"spread":0},{"rgb":"0,0,0","alpha":0.11,"x":0,"y":2,"blur":2,"spread":0},{"rgb":"0,0,0","alpha":0.11,"x":0,"y":4,"blur":4,"spread":0},{"rgb":"0,0,0","alpha":0.11,"x":0,"y":6,"blur":8,"spread":0},{"rgb":"0,0,0","alpha":0.11,"x":0,"y":8,"blur":16,"spread":0}],[{"rgb":"0,0,0","alpha":0.09,"x":0,"y":2,"blur":1,"spread":0},{"rgb":"0,0,0","alpha":0.09,"x":0,"y":4,"blur":2,"spread":0},{"rgb":"0,0,0","alpha":0.09,"x":0,"y":8,"blur":4,"spread":0},{"rgb":"0,0,0","alpha":0.09,"x":0,"y":16,"blur":8,"spread":0},{"rgb":"0,0,0","alpha":0.09,"x":0,"y":32,"blur":16,"spread":0}],[{"rgb":"0,0,0","alpha":0.05,"x":0,"y":1,"blur":2,"spread":0}],[{"rgb":"0,0,0","alpha":0.1,"x":0,"y":1,"blur":3,"spread":0},{"rgb":"0,0,0","alpha":0.1,"x":0,"y":1,"blur":2,"spread":-1}],[{"rgb":"0,0,0","alpha":0.1,"x":0,"y":10,"blur":15,"spread":-3},{"rgb":"0,0,0","alpha":0.1,"x":0,"y":4,"blur":6,"spread":-4}],[{"rgb":"0,0,0","alpha":0.1,"x":0,"y":20,"blur":25,"spread":-5},{"rgb":"0,0,0","alpha":0.1,"x":0,"y":8,"blur":10,"spread":-6}],[{"rgb":"0,0,0","alpha":0.25,"x":0,"y":25,"blur":50,"spread":-12}],[{"rgb":"0,0,0","alpha":0.13,"x":0,"y":2,"blur":4,"spread":0},{"rgb":"0,0,0","alpha":0.11,"x":0,"y":1,"blur":1,"spread":0}],[{"rgb":"0,0,0","alpha":0.13,"x":0,"y":3,"blur":7,"spread":0},{"rgb":"0,0,0","alpha":0.11,"x":0,"y":1,"blur":2,"spread":0}],[{"rgb":"0,0,0","alpha":0.13,"x":0,"y":7,"blur":15,"spread":0},{"rgb":"0,0,0","alpha":0.11,"x":0,"y":1,"blur":4,"spread":0}],[{"rgb":"0,0,0","alpha":0.22,"x":0,"y":26,"blur":58,"spread":0},{"rgb":"0,0,0","alpha":0.18,"x":0,"y":5,"blur":14,"spread":0}],[{"rgb":"0,0,0","alpha":0.075,"x":0,"y":2,"blur":4,"spread":0}],[{"rgb":"0,0,0","alpha":0.15,"x":0,"y":8,"blur":16,"spread":0}],[{"rgb":"0,0,0","alpha":0.176,"x":0,"y":16,"blur":48,"spread":0}],[{"rgb":"27,31,36","alpha":0.04,"x":0,"y":1,"blur":0,"spread":0}],[{"rgb":"140,149,159","alpha":0.15,"x":0,"y":3,"blur":6,"spread":0}],[{"rgb":"140,149,159","alpha":0.2,"x":0,"y":8,"blur":24,"spread":0}],[{"rgb":"140,149,159","alpha":0.3,"x":0,"y":12,"blur":28,"spread":0}],[{"rgb":"150,170,180","alpha":0.5,"x":0,"y":7,"blur":30,"spread":-10}],[{"rgb":"0,0,0","alpha":0.15,"x":2,"y":2,"blur":2,"spread":0}],[{"rgb":"0,0,0","alpha":0.2,"x":0,"y":2,"blur":4,"spread":0}],[{"rgb":"0,0,0","alpha":0.2,"x":0,"y":20,"blur":50,"spread":-10}],[{"rgb":"0,0,0","alpha":0.15,"x":0,"y":80,"blur":50,"spread":-30}],[{"rgb":"0,0,0","alpha":0.15,"x":0,"y":25,"blur":80,"spread":0}],[{"rgb":"0,0,0","alpha":0.5,"x":0,"y":25,"blur":80,"spread":0}],[{"rgb":"0,0,0","alpha":0.2,"x":0,"y":15,"blur":20,"spread":0}],[{"rgb":"0,0,0","alpha":0.05,"x":0,"y":0,"blur":0,"spread":5}],[{"rgb":"0,0,0","alpha":1,"x":8,"y":8,"blur":0,"spread":0}],[{"rgb":"33,33,33","alpha":1,"x":-10,"y":10,"blur":0,"spread":0},{"rgb":"33,33,33","alpha":0.7,"x":-20,"y":20,"blur":0,"spread":0},{"rgb":"33,33,33","alpha":0.4,"x":-30,"y":30,"blur":0,"spread":0},{"rgb":"33,33,33","alpha":0.1,"x":-40,"y":40,"blur":0,"spread":0}],[{"rgb":"0,0,0","alpha":0.45,"x":0,"y":0,"blur":40,"spread":0}],[{"rgb":"221,221,221","alpha":1,"x":0,"y":10,"blur":1,"spread":0},{"rgb":"204,204,204","alpha":1,"x":0,"y":10,"blur":20,"spread":0}],[{"rgb":"9,30,66","alpha":0.25,"x":0,"y":1,"blur":1,"spread":0},{"rgb":"9,30,66","alpha":0.13,"x":0,"y":0,"blur":1,"spread":1}],[{"rgb":"0,0,0","alpha":0.16,"x":0,"y":1,"blur":4,"spread":0},{"rgb":"51,51,51","alpha":1,"x":0,"y":0,"blur":0,"spread":3}],[{"rgb":"0,0,0","alpha":0.02,"x":0,"y":1,"blur":3,"spread":0},{"rgb":"27,31,35","alpha":0.15,"x":0,"y":0,"blur":0,"spread":1}],[{"rgb":"9,30,66","alpha":0.25,"x":0,"y":4,"blur":8,"spread":-2},{"rgb":"9,30,66","alpha":0.08,"x":0,"y":0,"blur":0,"spread":1}],[{"rgb":"0,0,0","alpha":0.22,"x":0,"y":1,"blur":0,"spread":0},{"rgb":"0,0,0","alpha":0.22,"x":1,"y":0,"blur":0,"spread":0},{"rgb":"0,0,0","alpha":0.22,"x":1,"y":2,"blur":0,"spread":0},{"rgb":"0,0,0","alpha":0.22,"x":2,"y":1,"blur":0,"spread":0},{"rgb":"0,0,0","alpha":0.22,"x":2,"y":3,"blur":0,"spread":0},{"rgb":"0,0,0","alpha":0.22,"x":3,"y":2,"blur":0,"spread":0},{"rgb":"0,0,0","alpha":0.22,"x":3,"y":4,"blur":0,"spread":0},{"rgb":"0,0,0","alpha":0.22,"x":4,"y":3,"blur":0,"spread":0},{"rgb":"0,0,0","alpha":0.22,"x":4,"y":5,"blur":0,"spread":0},{"rgb":"0,0,0","alpha":0.22,"x":5,"y":4,"blur":0,"spread":0},{"rgb":"0,0,0","alpha":0.22,"x":5,"y":6,"blur":0,"spread":0},{"rgb":"0,0,0","alpha":0.22,"x":6,"y":5,"blur":0,"spread":0},{"rgb":"0,0,0","alpha":0.22,"x":6,"y":7,"blur":0,"spread":0},{"rgb":"0,0,0","alpha":0.22,"x":7,"y":6,"blur":0,"spread":0},{"rgb":"0,0,0","alpha":0.22,"x":7,"y":8,"blur":0,"spread":0},{"rgb":"0,0,0","alpha":0.22,"x":8,"y":7,"blur":0,"spread":0}],[{"rgb":"0,0,0","alpha":0.24,"x":0,"y":3,"blur":8,"spread":0}],[{"rgb":"13,38,76","alpha":0.19,"x":0,"y":9,"blur":20,"spread":0}],[{"rgb":"0,0,0","alpha":0.04,"x":0,"y":3,"blur":5,"spread":0}],[{"rgb":"148,0,211","alpha":1,"x":0,"y":0,"blur":0,"spread":3},{"rgb":"75,0,130","alpha":1,"x":0,"y":0,"blur":0,"spread":6},{"rgb":"0,0,255","alpha":1,"x":0,"y":0,"blur":0,"spread":9},{"rgb":"0,255,0","alpha":1,"x":0,"y":0,"blur":0,"spread":12},{"rgb":"255,255,0","alpha":1,"x":0,"y":0,"blur":0,"spread":15},{"rgb":"255,127,0","alpha":1,"x":0,"y":0,"blur":0,"spread":18},{"rgb":"255,0,0","alpha":1,"x":0,"y":0,"blur":0,"spread":21}],[{"rgb":"148,0,211","alpha":1,"x":0,"y":0,"blur":0,"spread":2},{"rgb":"255,255,255","alpha":1,"x":15,"y":-15,"blur":0,"spread":-2},{"rgb":"75,0,130","alpha":1,"x":15,"y":-15,"blur":0,"spread":0},{"rgb":"255,255,255","alpha":1,"x":30,"y":-30,"blur":0,"spread":-2},{"rgb":"0,0,255","alpha":1,"x":30,"y":-30,"blur":0,"spread":0},{"rgb":"255,255,255","alpha":1,"x":45,"y":-45,"blur":0,"spread":-2},{"rgb":"0,255,0","alpha":1,"x":45,"y":-45,"blur":0,"spread":0},{"rgb":"255,255,255","alpha":1,"x":60,"y":-60,"blur":0,"spread":-2},{"rgb":"255,255,0","alpha":1,"x":60,"y":-60,"blur":0,"spread":0},{"rgb":"255,255,255","alpha":1,"x":75,"y":-75,"blur":0,"spread":-2},{"rgb":"255,127,0","alpha":1,"x":75,"y":-75,"blur":0,"spread":0},{"rgb":"255,255,255","alpha":1,"x":90,"y":-90,"blur":0,"spread":-2},{"rgb":"255,0,0","alpha":1,"x":90,"y":-90,"blur":0,"spread":0}],[{"rgb":"65,117,5","alpha":1,"x":0,"y":5,"blur":0,"spread":0},{"rgb":"65,117,5","alpha":0.6,"x":0,"y":10,"blur":0,"spread":0},{"rgb":"65,117,5","alpha":0.4,"x":0,"y":15,"blur":0,"spread":0},{"rgb":"65,117,5","alpha":0.2,"x":0,"y":20,"blur":0,"spread":0},{"rgb":"65,117,5","alpha":0.1,"x":0,"y":25,"blur":0,"spread":0}],[{"rgb":"65,117,5","alpha":1,"x":5,"y":5,"blur":0,"spread":0},{"rgb":"65,117,5","alpha":0.6,"x":10,"y":10,"blur":0,"spread":0},{"rgb":"65,117,5","alpha":0.4,"x":15,"y":15,"blur":0,"spread":0},{"rgb":"65,117,5","alpha":0.2,"x":20,"y":20,"blur":0,"spread":0},{"rgb":"65,117,5","alpha":0.1,"x":25,"y":25,"blur":0,"spread":0}],[{"rgb":"65,117,5","alpha":1,"x":-5,"y":5,"blur":0,"spread":0},{"rgb":"65,117,5","alpha":0.6,"x":-10,"y":10,"blur":0,"spread":0},{"rgb":"65,117,5","alpha":0.4,"x":-15,"y":15,"blur":0,"spread":0},{"rgb":"65,117,5","alpha":0.2,"x":-20,"y":20,"blur":0,"spread":0},{"rgb":"65,117,5","alpha":0.1,"x":-25,"y":25,"blur":0,"spread":0}],[{"rgb":"218,102,123","alpha":1,"x":0,"y":0,"blur":0,"spread":2},{"rgb":"218,102,123","alpha":1,"x":8,"y":8,"blur":0,"spread":0}],[{"rgb":"255,149,5","alpha":0.1,"x":0,"y":9,"blur":30,"spread":0}],[{"rgb":"255,149,5","alpha":0.3,"x":0,"y":9,"blur":30,"spread":0}]]';
$examples = json_decode($examples_JSON);    
$objs = json_decode($JSON_2);

if (!AT__Helpers::is_builder_tweaks_category_activated()){
    $theme_settings = \get_admin_url() . 'admin.php?page=bricks-advanced-themer';
    $error_title = "Feature not enabled";
    $error_desc = "It seems like this feature hasn't been enabled inside the theme settings. Click on the botton below and make sure that the <strong class='accent'>Builder Tweaks</strong> settings are enabled inside <strong class='accent'>Global Settings > General > Customize the functions included in Advanced Themer</strong>.";
    include \BRICKS_ADVANCED_THEMER_PATH . '/inc/builderPanels/_default_error.php';
} else {
?>
<!-- Main -->
<div id="<?php echo esc_attr($overlay_id);?>" class="brxc-overlay__wrapper" style="opacity:0" data-input-target="" onclick="ADMINBRXC.closeModal(event, this, '#<?php echo esc_attr($overlay_id);?>');" >
    <!-- Main Inner -->
    <div class="brxc-overlay__inner brxc-large">
        <!-- Close Modal Button -->
        <div class="brxc-overlay__close-btn" onClick="ADMINBRXC.closeModal(event, event.target, '#<?php echo esc_attr($overlay_id);?>')">
            <i class="bricks-svg ti-close"></i>
        </div>
        <!-- Modal Wrapper -->
        <div class="brxc-overlay__inner-wrapper">
            <!-- Modal Header -->
            <div class="brxc-overlay__header">
                <!-- Modal Header Title-->
                <h3 class="brxc-overlay__header-title"><?php echo esc_attr($modal_heading_title);?></h3>
            </div>
            <!-- Modal Error Container for OpenAI -->
            <div class="brxc-overlay__error-message-wrapper"></div>
            <!-- Modal Container -->
            <div class="brxc-overlay__container">
                <!-- Modal Panel Switch -->
                <div class="brxc-overlay__panel-switcher-wrapper">
                    <!-- Label/Input Switchers -->
                    <input type="radio" id="<?php echo esc_attr($prefix);?>-generator" name="<?php echo esc_attr($prefix);?>-switch" class="brxc-input__radio" data-transform="0" onClick="ADMINBRXC.bsStates.activeWindow = 'generator';ADMINBRXC.movePanel(document.querySelector('#<?php echo esc_attr($overlay_id);?> .brxc-overlay__pannels-wrapper'),this.dataset.transform);" checked>
                    <label for="<?php echo esc_attr($prefix);?>-generator" class="brxc-input__label">Box-Shadow Generator</label>
                    <input type="radio" id="<?php echo esc_attr($prefix);?>-presets" name="<?php echo esc_attr($prefix);?>-switch" class="brxc-input__radio" data-transform="calc(-100% - 80px)" onClick="ADMINBRXC.bsStates.activeWindow = 'presets';ADMINBRXC.movePanel(document.querySelector('#<?php echo esc_attr($overlay_id);?> .brxc-overlay__pannels-wrapper'),this.dataset.transform);">
                    <label for="<?php echo esc_attr($prefix);?>-presets" class="brxc-input__label">Presets</label>
                    <!-- End of Label/Input Switchers -->
                </div>
                <!-- End of Panel Switch -->
                <!-- Modal Panels Wrapper -->
                <div class="brxc-overlay__pannels-wrapper">
                    <!-- Modal Panel -->
                    <div class="brxc-overlay__pannel brxc-overlay__pannel-1" style="padding: 0px;">
                        <!-- Panel Content -->
                        <div id="boxShadowUI__container">
                            <div id="boxShadowUI__main">
                                <div id="boxShadowUI__box"></div>
                            </div>
                            <div id="boxShadowUI__global">
                                <div id="boxSettings"></div>
                                <div id="boxShadowSettings"></div>
                                <div id="boxShadowUI__child"></div>
                            </div>
                        </div>
                        <!-- End of Panel Content -->
                    </div>
                    <!-- End of Modal Panel -->
                    <!-- Modal Panel -->
                    <div class="brxc-overlay__pannel brxc-overlay__pannel-2" style="padding: 0px;">
                        <!-- Panel Content -->
                        <div class="boxShadowdUI__main-container">
                            <?php
                            $index = 1;
                            foreach($examples as $example){
                                ?>
                                    <div class="brxc-box-item">
                                        <div class="brxc-box" style="box-shadow: <?php echo $example?>;"></div>
                                        <div class="brxc-box-btn-wrapper">
                                            <a class="" data-obj='<?php echo json_encode($objs[$index - 1]);?>' onclick="ADMINBRXC.bsImportLayersFromPresets(this)">Import Layers</a>
                                            <a class="" data-value='<?php echo $example;?>' onClick="ADMINBRXC.bsApplyPresets(this);ADMINBRXC.closeModal(event, this, '#<?php echo esc_attr($overlay_id);?>');">Quick Apply</a>
                                        </div>
                                    </div>
                                <?php
                                $index++;
                            }
0                        ?>
                        </div>
                        <!-- End of Panel Content -->
                    </div>
                    <!-- End of Modal Panel -->
                </div>
                <!-- End of Modal Panels Wrapper -->
            </div>
            <!-- End of Modal Container -->
            <!-- Modal Footer -->
            <div class="brxc-overlay__footer">
                <div class="brxc-overlay__footer-wrapper">
                    <a class="brxc-overlay__action-btn danger" onclick="ADMINBRXC.bsRemoveSettings();ADMINBRXC.closeModal(event, this, '#<?php echo esc_attr($overlay_id);?>');"><span>Remove Settings</span></a>
                    <a class="brxc-overlay__action-btn primary" style="margin-left: auto;" onClick="ADMINBRXC.bsApply();ADMINBRXC.closeModal(event, this, '#<?php echo esc_attr($overlay_id);?>');"><span>Apply Box-shadow</span></a>
                </div>
            </div>
        </div>
        <!-- End of Modal Wrapper -->
    </div>
    <!-- End of Main Inner -->
</div>
<!-- End of Main -->
<?php }