<?php

if (!defined('ABSPATH')) { die();
}

$prefix = $brxc_acf_fields['global_prefix'];
$typography = [];
$spacing = [];
$border = [];
$border_radius = [];
$box_shadow = [];
$width = [];
$misc = [];


if ( have_rows( 'field_6445ab9f3d498', 'bricks-advanced-themer' ) ) :
    while ( have_rows( 'field_6445ab9f3d498', 'bricks-advanced-themer' ) ) :

        the_row();

        // Typography

        if ( Advanced_Themer_Bricks\AT__Helpers::is_typography_tab_activated() && have_rows( 'field_63a6a58831bbe', 'bricks-advanced-themer' ) ) :

            while ( have_rows( 'field_63a6a58831bbe', 'bricks-advanced-themer' ) ) :
                the_row();

                $label = get_sub_field('brxc_typography_label', 'bricks-advanced-themer' );

                $min = get_sub_field('brxc_typography_min_value', 'bricks-advanced-themer' );

                $max = get_sub_field('brxc_typography_max_value', 'bricks-advanced-themer' );

                $item = [];

                $key = strtolower( preg_replace( '/\s+/', '-', esc_attr($label) ) );

                if ( isset($prefix) && $prefix ) {

                    $value = 'var(--' . esc_attr($prefix) . '-' . $key . ')'; 
                
                } else {

                    $value = 'var(--' . $key . ')'; 

                }

                $item['key'] = $key;
                $item['value'] = $value;
                $item['min'] = $min;
                $item['max'] = $max;
                $typography[] = $item;
                
            endwhile;
            
        endif;

        // Spacing

        if ( Advanced_Themer_Bricks\AT__Helpers::is_spacing_tab_activated() && have_rows( 'field_63a6a51731bbb', 'bricks-advanced-themer' ) ) :

            while ( have_rows( 'field_63a6a51731bbb', 'bricks-advanced-themer' ) ) :

                the_row();

                $label = get_sub_field('brxc_spacing_label', 'bricks-advanced-themer' );

                $min = get_sub_field('brxc_spacing_min_value', 'bricks-advanced-themer' );

                $max = get_sub_field('brxc_spacing_max_value', 'bricks-advanced-themer' );

                $item = [];

                $key = strtolower( preg_replace( '/\s+/', '-', esc_attr($label) ) );

                if ( isset($prefix) && $prefix ) {

                    $value = 'var(--' . esc_attr($prefix) . '-' . $key . ')'; 
                
                } else {

                    $value = 'var(--' . $key . ')'; 

                }

                $item['key'] = $key;
                $item['value'] = $value;
                $item['min'] = $min;
                $item['max'] = $max;
                $spacing[] = $item;
                
            endwhile;
            
        endif;

        // Border
        if ( Advanced_Themer_Bricks\AT__Helpers::is_border_tab_activated() && have_rows( 'field_63c8f17ytr545', 'bricks-advanced-themer' ) ) :

            while ( have_rows( 'field_63c8f17ytr545', 'bricks-advanced-themer' ) ) :
                the_row();

                $label = get_sub_field('brxc_border_simple_label', 'bricks-advanced-themer' );

                $static_value = get_sub_field('brxc_border_simple_value', 'bricks-advanced-themer' );

                $item = [];

                $key = strtolower( preg_replace( '/\s+/', '-', esc_attr($label) ) );

                if ( isset($prefix) && $prefix ) {

                    $value = 'var(--' . esc_attr($prefix) . '-' . $key . ')'; 
                
                } else {

                    $value = 'var(--' . $key . ')'; 

                }

                $item['key'] = $key;
                $item['min'] = $static_value;
                $item['value'] = $value;
                $border[] = $item;
                
            endwhile;
            
        endif;

        // Border Radius
        if ( Advanced_Themer_Bricks\AT__Helpers::is_border_radius_tab_activated() && have_rows( 'field_63c8f17f5e2ed', 'bricks-advanced-themer' ) ) :

            while ( have_rows( 'field_63c8f17f5e2ed', 'bricks-advanced-themer' ) ) :
                the_row();

                $label = get_sub_field('brxc_border_label', 'bricks-advanced-themer' );

                $min = get_sub_field('brxc_border_min_value', 'bricks-advanced-themer' );

                $max = get_sub_field('brxc_border_max_value', 'bricks-advanced-themer' );

                $item = [];

                $key = strtolower( preg_replace( '/\s+/', '-', esc_attr($label) ) );

                if ( isset($prefix) && $prefix ) {

                    $value = 'var(--' . esc_attr($prefix) . '-' . $key . ')'; 
                
                } else {

                    $value = 'var(--' . $key . ')'; 

                }

                $item['key'] = $key;
                $item['value'] = $value;
                $item['min'] = $min;
                $item['max'] = $max;
                $border_radius[] = $item;
                
            endwhile;
            
        endif;

        // Box-Shadow
        if ( Advanced_Themer_Bricks\AT__Helpers::is_box_shadow_tab_activated() && have_rows( 'field_63c8f17s4stt6', 'bricks-advanced-themer' ) ) :

            while ( have_rows( 'field_63c8f17s4stt6', 'bricks-advanced-themer' ) ) :
                the_row();

                $label = get_sub_field('brxc_box_shadow_label', 'bricks-advanced-themer' );

                $static_value = get_sub_field('brxc_box_shadow_value', 'bricks-advanced-themer' );

                $item = [];

                $key = strtolower( preg_replace( '/\s+/', '-', esc_attr($label) ) );

                if ( isset($prefix) && $prefix ) {

                    $value = 'var(--' . esc_attr($prefix) . '-' . $key . ')'; 
                
                } else {

                    $value = 'var(--' . $key . ')'; 

                }

                $item['key'] = $key;
                $item['min'] = $static_value;
                $item['value'] = $value;
                $box_shadow[] = $item;
                
            endwhile;
            
        endif;

        // Width
        if ( Advanced_Themer_Bricks\AT__Helpers::is_width_tab_activated() && have_rows( 'field_63c8f17ppo69i', 'bricks-advanced-themer' ) ) :

            while ( have_rows( 'field_63c8f17ppo69i', 'bricks-advanced-themer' ) ) :
                the_row();

                $label = get_sub_field('brxc_width_label', 'bricks-advanced-themer' );

                $min = get_sub_field('brxc_width_min_value', 'bricks-advanced-themer' );

                $max = get_sub_field('brxc_width_max_value', 'bricks-advanced-themer' );

                $item = [];

                $key = strtolower( preg_replace( '/\s+/', '-', esc_attr($label) ) );

                if ( isset($prefix) && $prefix ) {

                    $value = 'var(--' . esc_attr($prefix) . '-' . $key . ')'; 
                
                } else {

                    $value = 'var(--' . $key . ')'; 

                }

                $item['key'] = $key;
                $item['value'] = $value;
                $item['min'] = $min;
                $item['max'] = $max;
                $width[] = $item;
                
            endwhile;
            
        endif;

        // Misc

        if ( Advanced_Themer_Bricks\AT__Helpers::is_custom_variables_tab_activated() && have_rows( 'field_64066a105f7ec', 'bricks-advanced-themer' ) ) :

            $cat = []; 
            $index = 0;
            
            while ( have_rows( 'field_64066a105f7ec', 'bricks-advanced-themer' ) ) :
                
                the_row();
                
                $cat_label = get_sub_field('brxc_misc_category_label', 'bricks-advanced-themer' );

                $cat[$index]['label'] = $cat_label;

                if ( have_rows( 'field_63dd12891d1d9', 'bricks-advanced-themer' ) ) :

                    while ( have_rows( 'field_63dd12891d1d9', 'bricks-advanced-themer' ) ) :
                        the_row();

                        if( get_row_layout() == 'brxc_misc_fluid_variable' ){

                            $label = get_sub_field('brxc_misc_fluid_label', 'bricks-advanced-themer' );

                            $min = get_sub_field('brxc_misc_fluid_min_value', 'bricks-advanced-themer' );

                            $max = get_sub_field('brxc_misc_fluid_max_value', 'bricks-advanced-themer' );

                        } else {

                            $label = get_sub_field('brxc_misc_static_label', 'bricks-advanced-themer' );

                            $min = get_sub_field('brxc_misc_static_value', 'bricks-advanced-themer' );

                            $max = false;

                        }

                        $item = [];

                        $key = strtolower( preg_replace( '/\s+/', '-', esc_attr($label) ) );

                        if ( isset($prefix) && $prefix ) {

                            $value = 'var(--' . esc_attr($prefix) . '-' . $key . ')'; 
                        
                        } else {

                            $value = 'var(--' . $key . ')'; 

                        }

                        $item['key'] = $key;
                        $item['value'] = $value;
                        $item['min'] = $min;
                        $item['max'] = $max;
                        $cat[$index]['items'][] = $item;
                        
                    endwhile;
                    
                endif;

                $misc[] = $cat;

                $index++;

            endwhile;
                    
        endif;

    endwhile;
                    
endif;

ob_start();

// Global Features
include_once \BRICKS_ADVANCED_THEMER_PATH . '/inc/builderPanels/class-contextual-menu.php';
include_once \BRICKS_ADVANCED_THEMER_PATH . '/inc/builderPanels/class_manager.php';
include_once \BRICKS_ADVANCED_THEMER_PATH . '/inc/builderPanels/query_manager.php';
include_once \BRICKS_ADVANCED_THEMER_PATH . '/inc/builderPanels/css_variable_manager.php';
include_once \BRICKS_ADVANCED_THEMER_PATH . '/inc/builderPanels/advanced_css_new.php';
include_once \BRICKS_ADVANCED_THEMER_PATH . '/inc/builderPanels/color_manager.php';
include_once \BRICKS_ADVANCED_THEMER_PATH . '/inc/builderPanels/structure_helper.php';
include_once \BRICKS_ADVANCED_THEMER_PATH . '/inc/builderPanels/find_replace.php';
include_once \BRICKS_ADVANCED_THEMER_PATH . '/inc/builderPanels/openai_text_new.php';
include_once \BRICKS_ADVANCED_THEMER_PATH . '/inc/builderPanels/global_openai_text_new.php';

// // Elements
include_once \BRICKS_ADVANCED_THEMER_PATH . '/inc/builderPanels/save_template.php';
include_once \BRICKS_ADVANCED_THEMER_PATH . '/inc/builderPanels/extend.php';
include_once \BRICKS_ADVANCED_THEMER_PATH . '/inc/builderPanels/style_overview.php';
include_once \BRICKS_ADVANCED_THEMER_PATH . '/inc/builderPanels/class_converter.php';
include_once \BRICKS_ADVANCED_THEMER_PATH . '/inc/builderPanels/plain_classes_new.php';
include_once \BRICKS_ADVANCED_THEMER_PATH . '/inc/builderPanels/box_shadow_generator.php';
include_once \BRICKS_ADVANCED_THEMER_PATH . '/inc/builderPanels/grid_ui.php';
include_once \BRICKS_ADVANCED_THEMER_PATH . '/inc/builderPanels/css_variable_pickr_new.php';

// // Extras
include_once \BRICKS_ADVANCED_THEMER_PATH . '/inc/builderPanels/resources_new.php';
include_once \BRICKS_ADVANCED_THEMER_PATH . '/inc/builderPanels/brickslabs.php';


$output = ob_get_clean();
echo $output;
