<?php

namespace WPPayForm\App\Services;

/**
 * Countries
 *
 * Returns an array of countries and codes.
 *
 * @author      WooThemes
 * @category    i18n
 * @package     payform/i18n
 * @version     2.5.0
 */

if (!defined('ABSPATH')) {
    exit;
}

class CountryNames
{
    public static function getAll()
    {
        $country_names = array(
            'AF' => __('Afghanistan', 'wp-payment-form'),
            'AX' => __('Åland Islands', 'wp-payment-form'),
            'AL' => __('Albania', 'wp-payment-form'),
            'DZ' => __('Algeria', 'wp-payment-form'),
            'AS' => __('American Samoa', 'wp-payment-form'),
            'AD' => __('Andorra', 'wp-payment-form'),
            'AO' => __('Angola', 'wp-payment-form'),
            'AI' => __('Anguilla', 'wp-payment-form'),
            'AQ' => __('Antarctica', 'wp-payment-form'),
            'AG' => __('Antigua and Barbuda', 'wp-payment-form'),
            'AR' => __('Argentina', 'wp-payment-form'),
            'AM' => __('Armenia', 'wp-payment-form'),
            'AW' => __('Aruba', 'wp-payment-form'),
            'AU' => __('Australia', 'wp-payment-form'),
            'AT' => __('Austria', 'wp-payment-form'),
            'AZ' => __('Azerbaijan', 'wp-payment-form'),
            'BS' => __('Bahamas', 'wp-payment-form'),
            'BH' => __('Bahrain', 'wp-payment-form'),
            'BD' => __('Bangladesh', 'wp-payment-form'),
            'BB' => __('Barbados', 'wp-payment-form'),
            'BY' => __('Belarus', 'wp-payment-form'),
            'BE' => __('Belgium', 'wp-payment-form'),
            'PW' => __('Belau', 'wp-payment-form'),
            'BZ' => __('Belize', 'wp-payment-form'),
            'BJ' => __('Benin', 'wp-payment-form'),
            'BM' => __('Bermuda', 'wp-payment-form'),
            'BT' => __('Bhutan', 'wp-payment-form'),
            'BO' => __('Bolivia', 'wp-payment-form'),
            'BQ' => __('Bonaire, Saint Eustatius and Saba', 'wp-payment-form'),
            'BA' => __('Bosnia and Herzegovina', 'wp-payment-form'),
            'BW' => __('Botswana', 'wp-payment-form'),
            'BV' => __('Bouvet Island', 'wp-payment-form'),
            'BR' => __('Brazil', 'wp-payment-form'),
            'IO' => __('British Indian Ocean Territory', 'wp-payment-form'),
            'VG' => __('British Virgin Islands', 'wp-payment-form'),
            'BN' => __('Brunei', 'wp-payment-form'),
            'BG' => __('Bulgaria', 'wp-payment-form'),
            'BF' => __('Burkina Faso', 'wp-payment-form'),
            'BI' => __('Burundi', 'wp-payment-form'),
            'KH' => __('Cambodia', 'wp-payment-form'),
            'CM' => __('Cameroon', 'wp-payment-form'),
            'CA' => __('Canada', 'wp-payment-form'),
            'CV' => __('Cape Verde', 'wp-payment-form'),
            'KY' => __('Cayman Islands', 'wp-payment-form'),
            'CF' => __('Central African Republic', 'wp-payment-form'),
            'TD' => __('Chad', 'wp-payment-form'),
            'CL' => __('Chile', 'wp-payment-form'),
            'CN' => __('China', 'wp-payment-form'),
            'CX' => __('Christmas Island', 'wp-payment-form'),
            'CC' => __('Cocos (Keeling) Islands', 'wp-payment-form'),
            'CO' => __('Colombia', 'wp-payment-form'),
            'KM' => __('Comoros', 'wp-payment-form'),
            'CG' => __('Congo (Brazzaville)', 'wp-payment-form'),
            'CD' => __('Congo (Kinshasa)', 'wp-payment-form'),
            'CK' => __('Cook Islands', 'wp-payment-form'),
            'CR' => __('Costa Rica', 'wp-payment-form'),
            'HR' => __('Croatia', 'wp-payment-form'),
            'CU' => __('Cuba', 'wp-payment-form'),
            'CW' => __('Cura&ccedil;ao', 'wp-payment-form'),
            'CY' => __('Cyprus', 'wp-payment-form'),
            'CZ' => __('Czech Republic', 'wp-payment-form'),
            'DK' => __('Denmark', 'wp-payment-form'),
            'DJ' => __('Djibouti', 'wp-payment-form'),
            'DM' => __('Dominica', 'wp-payment-form'),
            'DO' => __('Dominican Republic', 'wp-payment-form'),
            'EC' => __('Ecuador', 'wp-payment-form'),
            'EG' => __('Egypt', 'wp-payment-form'),
            'SV' => __('El Salvador', 'wp-payment-form'),
            'GQ' => __('Equatorial Guinea', 'wp-payment-form'),
            'ER' => __('Eritrea', 'wp-payment-form'),
            'EE' => __('Estonia', 'wp-payment-form'),
            'ET' => __('Ethiopia', 'wp-payment-form'),
            'FK' => __('Falkland Islands', 'wp-payment-form'),
            'FO' => __('Faroe Islands', 'wp-payment-form'),
            'FJ' => __('Fiji', 'wp-payment-form'),
            'FI' => __('Finland', 'wp-payment-form'),
            'FR' => __('France', 'wp-payment-form'),
            'GF' => __('French Guiana', 'wp-payment-form'),
            'PF' => __('French Polynesia', 'wp-payment-form'),
            'TF' => __('French Southern Territories', 'wp-payment-form'),
            'GA' => __('Gabon', 'wp-payment-form'),
            'GM' => __('Gambia', 'wp-payment-form'),
            'GE' => __('Georgia', 'wp-payment-form'),
            'DE' => __('Germany', 'wp-payment-form'),
            'GH' => __('Ghana', 'wp-payment-form'),
            'GI' => __('Gibraltar', 'wp-payment-form'),
            'GR' => __('Greece', 'wp-payment-form'),
            'GL' => __('Greenland', 'wp-payment-form'),
            'GD' => __('Grenada', 'wp-payment-form'),
            'GP' => __('Guadeloupe', 'wp-payment-form'),
            'GU' => __('Guam', 'wp-payment-form'),
            'GT' => __('Guatemala', 'wp-payment-form'),
            'GG' => __('Guernsey', 'wp-payment-form'),
            'GN' => __('Guinea', 'wp-payment-form'),
            'GW' => __('Guinea-Bissau', 'wp-payment-form'),
            'GY' => __('Guyana', 'wp-payment-form'),
            'HT' => __('Haiti', 'wp-payment-form'),
            'HM' => __('Heard Island and McDonald Islands', 'wp-payment-form'),
            'HN' => __('Honduras', 'wp-payment-form'),
            'HK' => __('Hong Kong', 'wp-payment-form'),
            'HU' => __('Hungary', 'wp-payment-form'),
            'IS' => __('Iceland', 'wp-payment-form'),
            'IN' => __('India', 'wp-payment-form'),
            'ID' => __('Indonesia', 'wp-payment-form'),
            'IR' => __('Iran', 'wp-payment-form'),
            'IQ' => __('Iraq', 'wp-payment-form'),
            'IE' => __('Ireland', 'wp-payment-form'),
            'IM' => __('Isle of Man', 'wp-payment-form'),
            'IL' => __('Israel', 'wp-payment-form'),
            'IT' => __('Italy', 'wp-payment-form'),
            'CI' => __('Ivory Coast', 'wp-payment-form'),
            'JM' => __('Jamaica', 'wp-payment-form'),
            'JP' => __('Japan', 'wp-payment-form'),
            'JE' => __('Jersey', 'wp-payment-form'),
            'JO' => __('Jordan', 'wp-payment-form'),
            'KZ' => __('Kazakhstan', 'wp-payment-form'),
            'KE' => __('Kenya', 'wp-payment-form'),
            'KI' => __('Kiribati', 'wp-payment-form'),
            'KW' => __('Kuwait', 'wp-payment-form'),
            'KG' => __('Kyrgyzstan', 'wp-payment-form'),
            'LA' => __('Laos', 'wp-payment-form'),
            'LV' => __('Latvia', 'wp-payment-form'),
            'LB' => __('Lebanon', 'wp-payment-form'),
            'LS' => __('Lesotho', 'wp-payment-form'),
            'LR' => __('Liberia', 'wp-payment-form'),
            'LY' => __('Libya', 'wp-payment-form'),
            'LI' => __('Liechtenstein', 'wp-payment-form'),
            'LT' => __('Lithuania', 'wp-payment-form'),
            'LU' => __('Luxembourg', 'wp-payment-form'),
            'MO' => __('Macao S.A.R., China', 'wp-payment-form'),
            'MK' => __('Macedonia', 'wp-payment-form'),
            'MG' => __('Madagascar', 'wp-payment-form'),
            'MW' => __('Malawi', 'wp-payment-form'),
            'MY' => __('Malaysia', 'wp-payment-form'),
            'MV' => __('Maldives', 'wp-payment-form'),
            'ML' => __('Mali', 'wp-payment-form'),
            'MT' => __('Malta', 'wp-payment-form'),
            'MH' => __('Marshall Islands', 'wp-payment-form'),
            'MQ' => __('Martinique', 'wp-payment-form'),
            'MR' => __('Mauritania', 'wp-payment-form'),
            'MU' => __('Mauritius', 'wp-payment-form'),
            'YT' => __('Mayotte', 'wp-payment-form'),
            'MX' => __('Mexico', 'wp-payment-form'),
            'FM' => __('Micronesia', 'wp-payment-form'),
            'MD' => __('Moldova', 'wp-payment-form'),
            'MC' => __('Monaco', 'wp-payment-form'),
            'MN' => __('Mongolia', 'wp-payment-form'),
            'ME' => __('Montenegro', 'wp-payment-form'),
            'MS' => __('Montserrat', 'wp-payment-form'),
            'MA' => __('Morocco', 'wp-payment-form'),
            'MZ' => __('Mozambique', 'wp-payment-form'),
            'MM' => __('Myanmar', 'wp-payment-form'),
            'NA' => __('Namibia', 'wp-payment-form'),
            'NR' => __('Nauru', 'wp-payment-form'),
            'NP' => __('Nepal', 'wp-payment-form'),
            'NL' => __('Netherlands', 'wp-payment-form'),
            'NC' => __('New Caledonia', 'wp-payment-form'),
            'NZ' => __('New Zealand', 'wp-payment-form'),
            'NI' => __('Nicaragua', 'wp-payment-form'),
            'NE' => __('Niger', 'wp-payment-form'),
            'NG' => __('Nigeria', 'wp-payment-form'),
            'NU' => __('Niue', 'wp-payment-form'),
            'NF' => __('Norfolk Island', 'wp-payment-form'),
            'MP' => __('Northern Mariana Islands', 'wp-payment-form'),
            'KP' => __('North Korea', 'wp-payment-form'),
            'NO' => __('Norway', 'wp-payment-form'),
            'OM' => __('Oman', 'wp-payment-form'),
            'PK' => __('Pakistan', 'wp-payment-form'),
            'PS' => __('Palestinian Territory', 'wp-payment-form'),
            'PA' => __('Panama', 'wp-payment-form'),
            'PG' => __('Papua New Guinea', 'wp-payment-form'),
            'PY' => __('Paraguay', 'wp-payment-form'),
            'PE' => __('Peru', 'wp-payment-form'),
            'PH' => __('Philippines', 'wp-payment-form'),
            'PN' => __('Pitcairn', 'wp-payment-form'),
            'PL' => __('Poland', 'wp-payment-form'),
            'PT' => __('Portugal', 'wp-payment-form'),
            'PR' => __('Puerto Rico', 'wp-payment-form'),
            'QA' => __('Qatar', 'wp-payment-form'),
            'RE' => __('Reunion', 'wp-payment-form'),
            'RO' => __('Romania', 'wp-payment-form'),
            'RU' => __('Russia', 'wp-payment-form'),
            'RW' => __('Rwanda', 'wp-payment-form'),
            'BL' => __('Saint Barth&eacute;lemy', 'wp-payment-form'),
            'SH' => __('Saint Helena', 'wp-payment-form'),
            'KN' => __('Saint Kitts and Nevis', 'wp-payment-form'),
            'LC' => __('Saint Lucia', 'wp-payment-form'),
            'MF' => __('Saint Martin (French part)', 'wp-payment-form'),
            'SX' => __('Saint Martin (Dutch part)', 'wp-payment-form'),
            'PM' => __('Saint Pierre and Miquelon', 'wp-payment-form'),
            'VC' => __('Saint Vincent and the Grenadines', 'wp-payment-form'),
            'SM' => __('San Marino', 'wp-payment-form'),
            'ST' => __('S&atilde;o Tom&eacute; and Pr&iacute;ncipe', 'wp-payment-form'),
            'SA' => __('Saudi Arabia', 'wp-payment-form'),
            'SN' => __('Senegal', 'wp-payment-form'),
            'RS' => __('Serbia', 'wp-payment-form'),
            'SC' => __('Seychelles', 'wp-payment-form'),
            'SL' => __('Sierra Leone', 'wp-payment-form'),
            'SG' => __('Singapore', 'wp-payment-form'),
            'SK' => __('Slovakia', 'wp-payment-form'),
            'SI' => __('Slovenia', 'wp-payment-form'),
            'SB' => __('Solomon Islands', 'wp-payment-form'),
            'SO' => __('Somalia', 'wp-payment-form'),
            'ZA' => __('South Africa', 'wp-payment-form'),
            'GS' => __('South Georgia/Sandwich Islands', 'wp-payment-form'),
            'KR' => __('South Korea', 'wp-payment-form'),
            'SS' => __('South Sudan', 'wp-payment-form'),
            'ES' => __('Spain', 'wp-payment-form'),
            'LK' => __('Sri Lanka', 'wp-payment-form'),
            'SD' => __('Sudan', 'wp-payment-form'),
            'SR' => __('Suriname', 'wp-payment-form'),
            'SJ' => __('Svalbard and Jan Mayen', 'wp-payment-form'),
            'SZ' => __('Swaziland', 'wp-payment-form'),
            'SE' => __('Sweden', 'wp-payment-form'),
            'CH' => __('Switzerland', 'wp-payment-form'),
            'SY' => __('Syria', 'wp-payment-form'),
            'TW' => __('Taiwan', 'wp-payment-form'),
            'TJ' => __('Tajikistan', 'wp-payment-form'),
            'TZ' => __('Tanzania', 'wp-payment-form'),
            'TH' => __('Thailand', 'wp-payment-form'),
            'TL' => __('Timor-Leste', 'wp-payment-form'),
            'TG' => __('Togo', 'wp-payment-form'),
            'TK' => __('Tokelau', 'wp-payment-form'),
            'TO' => __('Tonga', 'wp-payment-form'),
            'TT' => __('Trinidad and Tobago', 'wp-payment-form'),
            'TN' => __('Tunisia', 'wp-payment-form'),
            'TR' => __('Turkey', 'wp-payment-form'),
            'TM' => __('Turkmenistan', 'wp-payment-form'),
            'TC' => __('Turks and Caicos Islands', 'wp-payment-form'),
            'TV' => __('Tuvalu', 'wp-payment-form'),
            'UG' => __('Uganda', 'wp-payment-form'),
            'UA' => __('Ukraine', 'wp-payment-form'),
            'AE' => __('United Arab Emirates', 'wp-payment-form'),
            'GB' => __('United Kingdom (UK)', 'wp-payment-form'),
            'US' => __('United States (US)', 'wp-payment-form'),
            'UM' => __('United States (US) Minor Outlying Islands', 'wp-payment-form'),
            'VI' => __('United States (US) Virgin Islands', 'wp-payment-form'),
            'UY' => __('Uruguay', 'wp-payment-form'),
            'UZ' => __('Uzbekistan', 'wp-payment-form'),
            'VU' => __('Vanuatu', 'wp-payment-form'),
            'VA' => __('Vatican', 'wp-payment-form'),
            'VE' => __('Venezuela', 'wp-payment-form'),
            'VN' => __('Vietnam', 'wp-payment-form'),
            'WF' => __('Wallis and Futuna', 'wp-payment-form'),
            'EH' => __('Western Sahara', 'wp-payment-form'),
            'WS' => __('Samoa', 'wp-payment-form'),
            'YE' => __('Yemen', 'wp-payment-form'),
            'ZM' => __('Zambia', 'wp-payment-form'),
            'ZW' => __('Zimbabwe', 'wp-payment-form'),
        );

        return apply_filters('payform_editor_countries', $country_names);
    }

    public static function languageCodes()
    {
        return $langCodes = array(
            'AF' => 'fa-AF',
            'AL' => 'sq-AL',
            'DZ' => 'ar-DZ',
            'AS' => 'sm-AS',
            'AD' => 'ca-AD',
            'AO' => 'pt-AO',
            'AR' => 'es-AR',
            'AM' => 'hy-AM',
            'AU' => 'en-AU',
            'AT' => 'de-AT',
            'AZ' => 'az-AZ',
            'BH' => 'ar-BH',
            'BD' => 'bn-BD',
            'BY' => 'be-BY',
            'BE' => 'nl-BE',
            'BZ' => 'en-BZ',
            'BJ' => 'fr-BJ',
            'BT' => 'dz-BT',
            'BO' => 'es-BO',
            'BA' => 'bs-BA',
            'BW' => 'en-BW',
            'BR' => 'pt-BR',
            'BN' => 'ms-BN',
            'BG' => 'bg-BG',
            'BF' => 'fr-BF',
            'BI' => 'fr-BI',
            'KH' => 'km-KH',
            'CM' => 'en-CM',
            'CA' => 'en-CA',
            'CV' => 'pt-CV',
            'CF' => 'fr-CF',
            'TD' => 'fr-TD',
            'CL' => 'es-CL',
            'CN' => 'zh-CN',
            'CO' => 'es-CO',
            'KM' => 'ar-KM',
            'CD' => 'fr-CD',
            'CG' => 'fr-CG',
            'CR' => 'es-CR',
            'CI' => 'fr-CI',
            'HR' => 'hr-HR',
            'CU' => 'es-CU',
            'CY' => 'el-CY',
            'CZ' => 'cs-CZ',
            'DK' => 'da-DK',
            'DJ' => 'fr-DJ',
            'DM' => 'en-DM',
            'DO' => 'es-DO',
            'EC' => 'es-EC',
            'EG' => 'ar-EG',
            'SV' => 'es-SV',
            'GQ' => 'es-GQ',
            'ER' => 'ti-ER',
            'EE' => 'et-EE',
            'ET' => 'am-ET',
            'FJ' => 'en-FJ',
            'FI' => 'fi-FI',
            'FR' => 'fr-FR',
            'GA' => 'fr-GA',
            'GM' => 'en-GM',
            'GE' => 'ka-GE',
            'DE' => 'de-DE',
            'GH' => 'en-GH',
            'GR' => 'el-GR',
            'GD' => 'en-GD',
            'GT' => 'es-GT',
            'GN' => 'fr-GN',
            'GW' => 'pt-GW',
            'GY' => 'en-GY',
            'HT' => 'fr-HT',
            'HN' => 'es-HN',
            'HU' => 'hu-HU',
            'IS' => 'is-IS',
            'IN' => 'hi-IN',
            'ID' => 'id-ID',
            'IR' => 'fa-IR',
            'IQ' => 'ar-IQ',
            'IE' => 'en-IE',
            'IL' => 'he-IL',
            'IT' => 'it-IT',
            'JM' => 'en-JM',
            'JP' => 'ja-JP',
            'JO' => 'ar-JO',
            'KZ' => 'kk-KZ',
            'KE' => 'sw-KE',
            'KI' => 'en-KI',
            'KR' => 'ko-KR',
            'KW' => 'ar-KW',
            'KG' => 'ky-KG',
            'LA' => 'lo-LA',
            'LV' => 'lv-LV',
            'LB' => 'ar-LB',
            'LS' => 'en-LS',
            'LR' => 'en-LR',
            'LY' => 'ar-LY',
            'LI' => 'de-LI',
            'LT' => 'lt-LT',
            'LU' => 'lb-LU',
            'MG' => 'mg-MG',
            'MW' => 'en-MW',
            'MY' => 'ms-MY',
            'MV' => 'dv-MV',
            'ML' => 'fr-ML',
            'MT' => 'mt-MT',
            'MH' => 'mh-MH',
            'MR' => 'ar-MR',
            'MU' => 'mfe-MU',
            'MX' => 'es-MX',
            'FM' => 'en-FM',
            'MD' => 'ro-MD',
            'MC' => 'fr-MC',
            'MN' => 'mn-MN',
            'ME' => 'sr-ME',
            'MA' => 'ar-MA',
            'MZ' => 'pt-MZ',
            'NA' => 'en-NA',
            'NR' => 'en-NR',
            'NP' => 'ne-NP',
            'NL' => 'nl-NL',
            'NZ' => 'en-NZ',
            'NI' => 'es-NI',
            'NG' => 'en-NG',
            'NO' => 'no-NO',
            'OM' => 'ar-OM',
            'PK' => 'ur-PK',
            'PW' => 'en-PW',
            'PA' => 'es-PA',
            'PG' => 'en-PG',
            'PY' => 'es-PY',
            'PE' => 'es-PE',
            'PH' => 'en-PH',
            'PL' => 'pl-PL',
            'PT' => 'pt-PT',
            'QA' => 'ar-QA',
            'RO' => 'ro-RO',
            'RU' => 'ru-RU',
            'RW' => 'rw-RW',
            'WS' => 'sm-WS',
            'SM' => 'it-SM',
            'SA' => 'ar-SA',
            'SN' => 'fr-SN',
            'RS' => 'sr-RS',
            'SC' => 'fr-SC',
            'SL' => 'en-SL',
            'SG' => 'en-SG', 
            'SK' => 'sk-SK',
            'SI' => 'sl-SI',
            'SB' => 'en-SB',
            'SO' => 'so-SO',
            'ZA' => 'en-ZA',
            'ES' => 'es-ES',
            'LK' => 'si-LK', 
            'SD' => 'ar-SD',
            'SR' => 'nl-SR',
            'SZ' => 'en-SZ', 
            'SE' => 'sv-SE',
            'CH' => 'de-CH', 
            'SY' => 'ar-SY',
            'TW' => 'zh-TW',
            'TJ' => 'tg-TJ',
            'TZ' => 'sw-TZ',
            'TH' => 'th-TH',
            'TL' => 'pt-TL',
            'TG' => 'fr-TG',
            'TO' => 'to-TO',
            'TT' => 'en-TT',
            'TN' => 'ar-TN',
            'TR' => 'tr-TR',
            'TM' => 'tk-TM',
            'TV' => 'en-TV',
            'UG' => 'en-UG',
            'UA' => 'uk-UA',
            'AE' => 'ar-AE',
            'GB' => 'en-GB',
            'US' => 'en-US',
            'UY' => 'es-UY',
            'UZ' => 'uz-UZ', 
            'VU' => 'bi-VU', 
            'VE' => 'es-VE',
            'VN' => 'vi-VN',
            'YE' => 'ar-YE',
            'ZM' => 'en-ZM',
            'ZW' => 'en-ZW',
        );
    }

    public static function getLanguageCodeByCountryCode($country)
    {
        $langCodes = self::languageCodes();
        return $langCodes[$country] ? $langCodes[$country] : '';
    
    }

    public static function getCountryCode($country_name)
    {
        $countries = self::getAll();
        $country_code = array_search($country_name, $countries);
        return $country_code ? $country_code : '';
    }

    public static function getCountryName($country_code)
    {
        $countries = self::getAll();
        return $countries[$country_code] ? $countries[$country_code] : '';
    }
}
