/**
 * Icon fonts bridge for Gutenberg controls
 * Makes the dedicated icon font arrays available as global variables
 * This matches exactly how ControlIcon.vue imports and uses them
 *
 * TODO: Look into a more dynamic way to do this, with less hardcoded values
 */

// Copy the icon font arrays to make them available globally
// This mirrors the imports in ControlIcon.vue:
// import FontawesomeBrands from '@/fonts/font-awesome-brands-class-names.js'
// import FontawesomeRegular from '@/fonts/font-awesome-regular-class-names.js'
// import FontawesomeSolid from '@/fonts/font-awesome-solid-class-names.js'
// import IoniconsClassNames from '@/fonts/ionicons-class-names.js'
// import ThemifyClassNames from '@/fonts/themify-class-names.js'

// FontAwesome Brands (matching font-awesome-brands-class-names.js)
window.FontAwesomeBrands = [
	'fa-42-group',
	'fa-500px',
	'fa-accessible-icon',
	'fa-accusoft',
	'fa-adn',
	'fa-adversal',
	'fa-affiliatetheme',
	'fa-airbnb',
	'fa-algolia',
	'fa-alipay',
	'fa-amazon-pay',
	'fa-amazon',
	'fa-amilia',
	'fa-android',
	'fa-angellist',
	'fa-angrycreative',
	'fa-angular',
	'fa-app-store-ios',
	'fa-app-store',
	'fa-apper',
	'fa-apple-pay',
	'fa-apple',
	'fa-artstation',
	'fa-asymmetrik',
	'fa-atlassian',
	'fa-audible',
	'fa-autoprefixer',
	'fa-avianex',
	'fa-aviato',
	'fa-aws',
	'fa-bandcamp',
	'fa-battle-net',
	'fa-behance-square',
	'fa-behance',
	'fa-bilibili',
	'fa-bimobject',
	'fa-bitbucket',
	'fa-bitcoin',
	'fa-bity',
	'fa-black-tie',
	'fa-blackberry',
	'fa-blogger-b',
	'fa-blogger',
	'fa-bluetooth-b',
	'fa-bluetooth',
	'fa-bootstrap',
	'fa-bots',
	'fa-btc',
	'fa-buffer',
	'fa-buromobelexperte',
	'fa-buy-n-large',
	'fa-buysellads',
	'fa-canadian-maple-leaf',
	'fa-cc-amazon-pay',
	'fa-cc-amex',
	'fa-cc-apple-pay',
	'fa-cc-diners-club',
	'fa-cc-discover',
	'fa-cc-jcb',
	'fa-cc-mastercard',
	'fa-cc-paypal',
	'fa-cc-stripe',
	'fa-cc-visa',
	'fa-centercode',
	'fa-centos',
	'fa-chrome',
	'fa-chromecast',
	'fa-cloudflare',
	'fa-cloudscale',
	'fa-cloudsmith',
	'fa-cloudversify',
	'fa-cmplid',
	'fa-codepen',
	'fa-codiepie',
	'fa-confluence',
	'fa-connectdevelop',
	'fa-contao',
	'fa-cotton-bureau',
	'fa-cpanel',
	'fa-creative-commons-by',
	'fa-creative-commons-nc-eu',
	'fa-creative-commons-nc-jp',
	'fa-creative-commons-nc',
	'fa-creative-commons-nd',
	'fa-creative-commons-pd-alt',
	'fa-creative-commons-pd',
	'fa-creative-commons-remix',
	'fa-creative-commons-sa',
	'fa-creative-commons-sampling-plus',
	'fa-creative-commons-sampling',
	'fa-creative-commons-share',
	'fa-creative-commons-zero',
	'fa-creative-commons',
	'fa-critical-role',
	'fa-css3-alt',
	'fa-css3',
	'fa-cuttlefish',
	'fa-d-and-d-beyond',
	'fa-d-and-d',
	'fa-dailymotion',
	'fa-dashcube',
	'fa-debian',
	'fa-deezer',
	'fa-delicious',
	'fa-deploydog',
	'fa-deskpro',
	'fa-dev',
	'fa-deviantart',
	'fa-dhl',
	'fa-diaspora',
	'fa-digg',
	'fa-digital-ocean',
	'fa-discord',
	'fa-discourse',
	'fa-dochub',
	'fa-docker',
	'fa-draft2digital',
	'fa-dribbble-square',
	'fa-dribbble',
	'fa-dropbox',
	'fa-drupal',
	'fa-dyalog',
	'fa-earlybirds',
	'fa-ebay',
	'fa-edge-legacy',
	'fa-edge',
	'fa-elementor',
	'fa-ello',
	'fa-ember',
	'fa-empire',
	'fa-envira',
	'fa-erlang',
	'fa-ethereum',
	'fa-etsy',
	'fa-evernote',
	'fa-expeditedssl',
	'fa-facebook-f',
	'fa-facebook-messenger',
	'fa-facebook-square',
	'fa-facebook',
	'fa-fantasy-flight-games',
	'fa-fedex',
	'fa-fedora',
	'fa-figma',
	'fa-firefox-browser',
	'fa-firefox',
	'fa-first-order-alt',
	'fa-first-order',
	'fa-firstdraft',
	'fa-flickr',
	'fa-flipboard',
	'fa-fly',
	'fa-font-awesome-alt',
	'fa-font-awesome-flag',
	'fa-font-awesome-logo-full',
	'fa-font-awesome',
	'fa-fonticons-fi',
	'fa-fonticons',
	'fa-fort-awesome-alt',
	'fa-fort-awesome',
	'fa-forumbee',
	'fa-foursquare',
	'fa-free-code-camp',
	'fa-freebsd',
	'fa-fulcrum',
	'fa-galactic-republic',
	'fa-galactic-senate',
	'fa-get-pocket',
	'fa-gg-circle',
	'fa-gg',
	'fa-git-alt',
	'fa-git-square',
	'fa-git',
	'fa-github-alt',
	'fa-github-square',
	'fa-github',
	'fa-gitkraken',
	'fa-gitlab-square',
	'fa-gitlab',
	'fa-gitter',
	'fa-glide-g',
	'fa-glide',
	'fa-gofore',
	'fa-golang',
	'fa-goodreads-g',
	'fa-goodreads',
	'fa-google-drive',
	'fa-google-pay',
	'fa-google-play',
	'fa-google-plus-g',
	'fa-google-plus-square',
	'fa-google-plus',
	'fa-google-wallet',
	'fa-google',
	'fa-gratipay',
	'fa-grav',
	'fa-gripfire',
	'fa-grunt',
	'fa-guilded',
	'fa-gulp',
	'fa-hacker-news-square',
	'fa-hacker-news',
	'fa-hackerrank',
	'fa-hashnode',
	'fa-hips',
	'fa-hire-a-helper',
	'fa-hive',
	'fa-hooli',
	'fa-hornbill',
	'fa-hotjar',
	'fa-houzz',
	'fa-html5',
	'fa-hubspot',
	'fa-ideal',
	'fa-imdb',
	'fa-innosoft',
	'fa-instagram-square',
	'fa-instagram',
	'fa-instalod',
	'fa-intercom',
	'fa-internet-explorer',
	'fa-invision',
	'fa-ioxhost',
	'fa-itch-io',
	'fa-itunes-note',
	'fa-itunes',
	'fa-java',
	'fa-jedi-order',
	'fa-jenkins',
	'fa-jira',
	'fa-joget',
	'fa-joomla',
	'fa-js-square',
	'fa-js',
	'fa-jsfiddle',
	'fa-kaggle',
	'fa-keybase',
	'fa-keycdn',
	'fa-kickstarter-k',
	'fa-kickstarter',
	'fa-korvue',
	'fa-laravel',
	'fa-lastfm-square',
	'fa-lastfm',
	'fa-leanpub',
	'fa-less',
	'fa-line',
	'fa-linkedin-in',
	'fa-linkedin',
	'fa-linode',
	'fa-linux',
	'fa-lyft',
	'fa-magento',
	'fa-mailchimp',
	'fa-mandalorian',
	'fa-markdown',
	'fa-mastodon',
	'fa-maxcdn',
	'fa-mdb',
	'fa-medapps',
	'fa-medium-m',
	'fa-medium',
	'fa-medrt',
	'fa-meetup',
	'fa-megaport',
	'fa-mendeley',
	'fa-meta',
	'fa-microblog',
	'fa-microsoft',
	'fa-mix',
	'fa-mixcloud',
	'fa-mixer',
	'fa-mizuni',
	'fa-modx',
	'fa-monero',
	'fa-napster',
	'fa-neos',
	'fa-nfc-directional',
	'fa-nfc-symbol',
	'fa-nimblr',
	'fa-node-js',
	'fa-node',
	'fa-npm',
	'fa-ns8',
	'fa-nutritionix',
	'fa-octopus-deploy',
	'fa-odnoklassniki-square',
	'fa-odnoklassniki',
	'fa-odysee',
	'fa-old-republic',
	'fa-opencart',
	'fa-openid',
	'fa-opera',
	'fa-optin-monster',
	'fa-orcid',
	'fa-osi',
	'fa-padlet',
	'fa-page4',
	'fa-pagelines',
	'fa-palfed',
	'fa-patreon',
	'fa-paypal',
	'fa-perbyte',
	'fa-periscope',
	'fa-phabricator',
	'fa-phoenix-framework',
	'fa-phoenix-squadron',
	'fa-php',
	'fa-pied-piper-alt',
	'fa-pied-piper-hat',
	'fa-pied-piper-pp',
	'fa-pied-piper-square',
	'fa-pied-piper',
	'fa-pinterest-p',
	'fa-pinterest-square',
	'fa-pinterest',
	'fa-pix',
	'fa-playstation',
	'fa-product-hunt',
	'fa-pushed',
	'fa-python',
	'fa-qq',
	'fa-quinscape',
	'fa-quora',
	'fa-r-project',
	'fa-raspberry-pi',
	'fa-ravelry',
	'fa-react',
	'fa-reacteurope',
	'fa-readme',
	'fa-rebel',
	'fa-red-river',
	'fa-reddit-alien',
	'fa-reddit-square',
	'fa-reddit',
	'fa-redhat',
	'fa-rendact',
	'fa-renren',
	'fa-replyd',
	'fa-researchgate',
	'fa-resolving',
	'fa-rev',
	'fa-rocketchat',
	'fa-rockrms',
	'fa-rust',
	'fa-safari',
	'fa-salesforce',
	'fa-sass',
	'fa-schlix',
	'fa-screenpal',
	'fa-scribd',
	'fa-searchengin',
	'fa-sellcast',
	'fa-sellsy',
	'fa-servicestack',
	'fa-shirtsinbulk',
	'fa-shopify',
	'fa-shopware',
	'fa-simplybuilt',
	'fa-sistrix',
	'fa-sith',
	'fa-sitrox',
	'fa-sketch',
	'fa-skyatlas',
	'fa-skype',
	'fa-slack-hash',
	'fa-slack',
	'fa-slideshare',
	'fa-snapchat-ghost',
	'fa-snapchat-square',
	'fa-snapchat',
	'fa-soundcloud',
	'fa-sourcetree',
	'fa-space-awesome',
	'fa-speakap',
	'fa-speaker-deck',
	'fa-spotify',
	'fa-square-behance',
	'fa-square-dribbble',
	'fa-square-facebook',
	'fa-square-font-awesome-stroke',
	'fa-square-font-awesome',
	'fa-square-git',
	'fa-square-github',
	'fa-square-gitlab',
	'fa-square-google-plus',
	'fa-square-hacker-news',
	'fa-square-instagram',
	'fa-square-js',
	'fa-square-lastfm',
	'fa-square-odnoklassniki',
	'fa-square-pied-piper',
	'fa-square-pinterest',
	'fa-square-reddit',
	'fa-square-snapchat',
	'fa-square-steam',
	'fa-square-threads',
	'fa-square-tumblr',
	'fa-square-twitter',
	'fa-square-viadeo',
	'fa-square-vimeo',
	'fa-square-whatsapp',
	'fa-square-x-twitter',
	'fa-square-xing',
	'fa-square-youtube',
	'fa-squarespace',
	'fa-stack-exchange',
	'fa-stack-overflow',
	'fa-stackpath',
	'fa-staylinked',
	'fa-steam-square',
	'fa-steam-symbol',
	'fa-steam',
	'fa-sticker-mule',
	'fa-strava',
	'fa-stripe-s',
	'fa-stripe',
	'fa-stubber',
	'fa-studiovinari',
	'fa-stumbleupon-circle',
	'fa-stumbleupon',
	'fa-superpowers',
	'fa-supple',
	'fa-suse',
	'fa-swift',
	'fa-symfony',
	'fa-teamspeak',
	'fa-telegram-plane',
	'fa-telegram',
	'fa-tencent-weibo',
	'fa-the-red-yeti',
	'fa-themeco',
	'fa-themeisle',
	'fa-think-peaks',
	'fa-threads',
	'fa-tiktok',
	'fa-trade-federation',
	'fa-trello',
	'fa-tumblr-square',
	'fa-tumblr',
	'fa-twitch',
	'fa-twitter-square',
	'fa-twitter',
	'fa-typo3',
	'fa-uber',
	'fa-ubuntu',
	'fa-uikit',
	'fa-umbraco',
	'fa-uncharted',
	'fa-uniregistry',
	'fa-unity',
	'fa-unsplash',
	'fa-untappd',
	'fa-ups',
	'fa-usb',
	'fa-usps',
	'fa-ussunnah',
	'fa-vaadin',
	'fa-viacoin',
	'fa-viadeo-square',
	'fa-viadeo',
	'fa-viber',
	'fa-vimeo-square',
	'fa-vimeo-v',
	'fa-vimeo',
	'fa-vine',
	'fa-vk',
	'fa-vnv',
	'fa-vuejs',
	'fa-watchman-monitoring',
	'fa-waze',
	'fa-weebly',
	'fa-weibo',
	'fa-weixin',
	'fa-whatsapp-square',
	'fa-whatsapp',
	'fa-whmcs',
	'fa-wikipedia-w',
	'fa-windows',
	'fa-wirsindhandwerk',
	'fa-wix',
	'fa-wizards-of-the-coast',
	'fa-wodu',
	'fa-wolf-pack-battalion',
	'fa-wordpress-simple',
	'fa-wordpress',
	'fa-wpbeginner',
	'fa-wpexplorer',
	'fa-wpforms',
	'fa-wpressr',
	'fa-wsh',
	'fa-x-twitter',
	'fa-xbox',
	'fa-xing-square',
	'fa-xing',
	'fa-y-combinator',
	'fa-yahoo',
	'fa-yammer',
	'fa-yandex-international',
	'fa-yandex',
	'fa-yarn',
	'fa-yelp',
	'fa-yoast',
	'fa-youtube-square',
	'fa-youtube',
	'fa-zhihu'
]

// FontAwesome Regular (matching font-awesome-regular-class-names.js)
window.FontAwesomeRegular = [
	'fa-address-book',
	'fa-address-card',
	'fa-bell-slash',
	'fa-bell',
	'fa-bookmark',
	'fa-building',
	'fa-calendar-check',
	'fa-calendar-days',
	'fa-calendar-minus',
	'fa-calendar-plus',
	'fa-calendar-xmark',
	'fa-calendar',
	'fa-chart-bar',
	'fa-chess-bishop',
	'fa-chess-king',
	'fa-chess-knight',
	'fa-chess-pawn',
	'fa-chess-queen',
	'fa-chess-rook',
	'fa-circle-check',
	'fa-circle-dot',
	'fa-circle-down',
	'fa-circle-left',
	'fa-circle-pause',
	'fa-circle-play',
	'fa-circle-question',
	'fa-circle-right',
	'fa-circle-stop',
	'fa-circle-up',
	'fa-circle-user',
	'fa-circle-xmark',
	'fa-circle',
	'fa-clipboard',
	'fa-clock',
	'fa-clone',
	'fa-closed-captioning',
	'fa-comment-dots',
	'fa-comment',
	'fa-comments',
	'fa-compass',
	'fa-copy',
	'fa-copyright',
	'fa-credit-card',
	'fa-envelope-open',
	'fa-envelope',
	'fa-eye-slash',
	'fa-eye',
	'fa-face-angry',
	'fa-face-dizzy',
	'fa-face-flushed',
	'fa-face-frown-open',
	'fa-face-frown',
	'fa-face-grimace',
	'fa-face-grin-beam-sweat',
	'fa-face-grin-beam',
	'fa-face-grin-hearts',
	'fa-face-grin-squint-tears',
	'fa-face-grin-squint',
	'fa-face-grin-stars',
	'fa-face-grin-tears',
	'fa-face-grin-tongue-squint',
	'fa-face-grin-tongue-wink',
	'fa-face-grin-tongue',
	'fa-face-grin-wide',
	'fa-face-grin-wink',
	'fa-face-grin',
	'fa-face-kiss-beam',
	'fa-face-kiss-wink-heart',
	'fa-face-kiss',
	'fa-face-laugh-beam',
	'fa-face-laugh-squint',
	'fa-face-laugh-wink',
	'fa-face-laugh',
	'fa-face-meh-blank',
	'fa-face-meh',
	'fa-face-rolling-eyes',
	'fa-face-sad-cry',
	'fa-face-sad-tear',
	'fa-face-smile-beam',
	'fa-face-smile-wink',
	'fa-face-smile',
	'fa-face-surprise',
	'fa-face-tired',
	'fa-file-audio',
	'fa-file-code',
	'fa-file-excel',
	'fa-file-image',
	'fa-file-lines',
	'fa-file-pdf',
	'fa-file-powerpoint',
	'fa-file-video',
	'fa-file-word',
	'fa-file-zipper',
	'fa-file',
	'fa-flag',
	'fa-floppy-disk',
	'fa-folder-closed',
	'fa-folder-open',
	'fa-folder',
	'fa-font-awesome',
	'fa-futbol',
	'fa-gem',
	'fa-hand-back-fist',
	'fa-hand-lizard',
	'fa-hand-peace',
	'fa-hand-point-down',
	'fa-hand-point-left',
	'fa-hand-point-right',
	'fa-hand-point-up',
	'fa-hand-pointer',
	'fa-hand-scissors',
	'fa-hand-spock',
	'fa-hand',
	'fa-handshake',
	'fa-hard-drive',
	'fa-heart',
	'fa-hospital',
	'fa-hourglass-half',
	'fa-hourglass',
	'fa-id-badge',
	'fa-id-card',
	'fa-image',
	'fa-images',
	'fa-keyboard',
	'fa-lemon',
	'fa-life-ring',
	'fa-lightbulb',
	'fa-map',
	'fa-message',
	'fa-money-bill-1',
	'fa-moon',
	'fa-newspaper',
	'fa-note-sticky',
	'fa-object-group',
	'fa-object-ungroup',
	'fa-paper-plane',
	'fa-paste',
	'fa-pen-to-square',
	'fa-rectangle-list',
	'fa-rectangle-xmark',
	'fa-registered',
	'fa-share-from-square',
	'fa-snowflake',
	'fa-square-caret-down',
	'fa-square-caret-left',
	'fa-square-caret-right',
	'fa-square-caret-up',
	'fa-square-check',
	'fa-square-full',
	'fa-square-minus',
	'fa-square-plus',
	'fa-square',
	'fa-star-half-stroke',
	'fa-star-half',
	'fa-star',
	'fa-sun',
	'fa-thumbs-down',
	'fa-thumbs-up',
	'fa-trash-can',
	'fa-user',
	'fa-window-maximize',
	'fa-window-minimize',
	'fa-window-restore'
]

// FontAwesome Solid (matching font-awesome-solid-class-names.js - truncated for brevity)
window.FontAwesomeSolid = [
	'fa-address-book',
	'fa-address-card',
	'fa-bell-slash',
	'fa-bell',
	'fa-bookmark',
	'fa-building',
	'fa-calendar-check',
	'fa-calendar-days',
	'fa-calendar-minus',
	'fa-calendar-plus',
	'fa-calendar-xmark',
	'fa-calendar',
	'fa-chart-bar',
	'fa-chess-bishop',
	'fa-chess-king',
	'fa-chess-knight',
	'fa-chess-pawn',
	'fa-chess-queen',
	'fa-chess-rook',
	'fa-circle-check',
	'fa-circle-dot',
	'fa-circle-down',
	'fa-circle-left',
	'fa-circle-pause',
	'fa-circle-play',
	'fa-circle-question',
	'fa-circle-right',
	'fa-circle-stop',
	'fa-circle-up',
	'fa-circle-user',
	'fa-circle-xmark',
	'fa-circle',
	'fa-clipboard',
	'fa-clock',
	'fa-clone',
	'fa-closed-captioning',
	'fa-comment-dots',
	'fa-comment',
	'fa-comments',
	'fa-compass',
	'fa-copy',
	'fa-copyright',
	'fa-credit-card',
	'fa-envelope-open',
	'fa-envelope',
	'fa-eye-slash',
	'fa-eye',
	'fa-face-angry',
	'fa-face-dizzy',
	'fa-face-flushed',
	'fa-face-frown-open',
	'fa-face-frown',
	'fa-face-grimace',
	'fa-face-grin-beam-sweat',
	'fa-face-grin-beam',
	'fa-face-grin-hearts',
	'fa-face-grin-squint-tears',
	'fa-face-grin-squint',
	'fa-face-grin-stars',
	'fa-face-grin-tears',
	'fa-face-grin-tongue-squint',
	'fa-face-grin-tongue-wink',
	'fa-face-grin-tongue',
	'fa-face-grin-wide',
	'fa-face-grin-wink',
	'fa-face-grin',
	'fa-face-kiss-beam',
	'fa-face-kiss-wink-heart',
	'fa-face-kiss',
	'fa-face-laugh-beam',
	'fa-face-laugh-squint',
	'fa-face-laugh-wink',
	'fa-face-laugh',
	'fa-face-meh-blank',
	'fa-face-meh',
	'fa-face-rolling-eyes',
	'fa-face-sad-cry',
	'fa-face-sad-tear',
	'fa-face-smile-beam',
	'fa-face-smile-wink',
	'fa-face-smile',
	'fa-face-surprise',
	'fa-face-tired',
	'fa-file-audio',
	'fa-file-code',
	'fa-file-excel',
	'fa-file-image',
	'fa-file-lines',
	'fa-file-pdf',
	'fa-file-powerpoint',
	'fa-file-video',
	'fa-file-word',
	'fa-file-zipper',
	'fa-file',
	'fa-flag',
	'fa-floppy-disk',
	'fa-folder-closed',
	'fa-folder-open',
	'fa-folder',
	'fa-font-awesome',
	'fa-futbol',
	'fa-gem',
	'fa-hand-back-fist',
	'fa-hand-lizard',
	'fa-hand-peace',
	'fa-hand-point-down',
	'fa-hand-point-left',
	'fa-hand-point-right',
	'fa-hand-point-up',
	'fa-hand-pointer',
	'fa-hand-scissors',
	'fa-hand-spock',
	'fa-hand',
	'fa-handshake',
	'fa-hard-drive',
	'fa-heart',
	'fa-hospital',
	'fa-hourglass-half',
	'fa-hourglass',
	'fa-id-badge',
	'fa-id-card',
	'fa-image',
	'fa-images',
	'fa-keyboard',
	'fa-lemon',
	'fa-life-ring',
	'fa-lightbulb',
	'fa-map',
	'fa-message',
	'fa-money-bill-1',
	'fa-moon',
	'fa-newspaper',
	'fa-note-sticky',
	'fa-object-group',
	'fa-object-ungroup',
	'fa-paper-plane',
	'fa-paste',
	'fa-pen-to-square',
	'fa-rectangle-list',
	'fa-rectangle-xmark',
	'fa-registered',
	'fa-share-from-square',
	'fa-snowflake',
	'fa-square-caret-down',
	'fa-square-caret-left',
	'fa-square-caret-right',
	'fa-square-caret-up',
	'fa-square-check',
	'fa-square-full',
	'fa-square-minus',
	'fa-square-plus',
	'fa-square',
	'fa-star-half-stroke',
	'fa-star-half',
	'fa-star',
	'fa-sun',
	'fa-thumbs-down',
	'fa-thumbs-up',
	'fa-trash-can',
	'fa-user',
	'fa-window-maximize',
	'fa-window-minimize',
	'fa-window-restore'
]

// Ionicons (matching ionicons-class-names.js)
window.IoniconsClassNames = [
	'ion-ios-add',
	'ion-ios-add-circle',
	'ion-ios-add-circle-outline',
	'ion-ios-airplane',
	'ion-ios-alarm',
	'ion-ios-albums',
	'ion-ios-alert',
	'ion-ios-american-football',
	'ion-ios-analytics',
	'ion-ios-aperture',
	'ion-ios-apps',
	'ion-ios-appstore',
	'ion-ios-archive',
	'ion-ios-arrow-back',
	'ion-ios-arrow-down',
	'ion-ios-arrow-dropdown',
	'ion-ios-arrow-dropdown-circle',
	'ion-ios-arrow-dropleft',
	'ion-ios-arrow-dropleft-circle',
	'ion-ios-arrow-dropright',
	'ion-ios-arrow-dropright-circle',
	'ion-ios-arrow-dropup',
	'ion-ios-arrow-dropup-circle',
	'ion-ios-arrow-forward',
	'ion-ios-arrow-round-back',
	'ion-ios-arrow-round-down',
	'ion-ios-arrow-round-forward',
	'ion-ios-arrow-round-up',
	'ion-ios-arrow-up',
	'ion-ios-at',
	'ion-ios-attach',
	'ion-ios-backspace',
	'ion-ios-barcode',
	'ion-ios-baseball',
	'ion-ios-basket',
	'ion-ios-basketball',
	'ion-ios-battery-charging',
	'ion-ios-battery-dead',
	'ion-ios-battery-full',
	'ion-ios-beaker',
	'ion-ios-bed',
	'ion-ios-beer',
	'ion-ios-bicycle',
	'ion-ios-bluetooth',
	'ion-ios-boat',
	'ion-ios-body',
	'ion-ios-bonfire',
	'ion-ios-book',
	'ion-ios-bookmark',
	'ion-ios-bookmarks',
	'ion-ios-bowtie',
	'ion-ios-briefcase',
	'ion-ios-browsers',
	'ion-ios-brush',
	'ion-ios-bug',
	'ion-ios-build',
	'ion-ios-bulb',
	'ion-ios-bus',
	'ion-ios-business',
	'ion-ios-cafe',
	'ion-ios-calculator',
	'ion-ios-calendar',
	'ion-ios-call',
	'ion-ios-camera',
	'ion-ios-car',
	'ion-ios-card',
	'ion-ios-cart',
	'ion-ios-cash',
	'ion-ios-cellular',
	'ion-ios-chatboxes',
	'ion-ios-chatbubbles',
	'ion-ios-checkbox',
	'ion-ios-checkbox-outline',
	'ion-ios-checkmark',
	'ion-ios-checkmark-circle',
	'ion-ios-checkmark-circle-outline',
	'ion-ios-clipboard',
	'ion-ios-clock',
	'ion-ios-close',
	'ion-ios-close-circle',
	'ion-ios-close-circle-outline',
	'ion-ios-cloud',
	'ion-ios-cloud-circle',
	'ion-ios-cloud-done',
	'ion-ios-cloud-download',
	'ion-ios-cloud-outline',
	'ion-ios-cloud-upload',
	'ion-ios-cloudy',
	'ion-ios-cloudy-night',
	'ion-ios-code',
	'ion-ios-code-download',
	'ion-ios-code-working',
	'ion-ios-cog',
	'ion-ios-color-fill',
	'ion-ios-color-filter',
	'ion-ios-color-palette',
	'ion-ios-color-wand',
	'ion-ios-compass',
	'ion-ios-construct',
	'ion-ios-contact',
	'ion-ios-contacts',
	'ion-ios-contract',
	'ion-ios-contrast',
	'ion-ios-copy',
	'ion-ios-create',
	'ion-ios-crop',
	'ion-ios-cube',
	'ion-ios-cut',
	'ion-ios-desktop',
	'ion-ios-disc',
	'ion-ios-document',
	'ion-ios-done-all',
	'ion-ios-download',
	'ion-ios-easel',
	'ion-ios-egg',
	'ion-ios-exit',
	'ion-ios-expand',
	'ion-ios-eye',
	'ion-ios-eye-off',
	'ion-ios-fastforward',
	'ion-ios-female',
	'ion-ios-filing',
	'ion-ios-film',
	'ion-ios-finger-print',
	'ion-ios-fitness',
	'ion-ios-flag',
	'ion-ios-flame',
	'ion-ios-flash',
	'ion-ios-flash-off',
	'ion-ios-flashlight',
	'ion-ios-flask',
	'ion-ios-flower',
	'ion-ios-folder',
	'ion-ios-folder-open',
	'ion-ios-football',
	'ion-ios-funnel',
	'ion-ios-gift',
	'ion-ios-git-branch',
	'ion-ios-git-commit',
	'ion-ios-git-compare',
	'ion-ios-git-merge',
	'ion-ios-git-network',
	'ion-ios-git-pull-request',
	'ion-ios-glasses',
	'ion-ios-globe',
	'ion-ios-grid',
	'ion-ios-hammer',
	'ion-ios-hand',
	'ion-ios-happy',
	'ion-ios-headset',
	'ion-ios-heart',
	'ion-ios-heart-dislike',
	'ion-ios-heart-empty',
	'ion-ios-heart-half',
	'ion-ios-help',
	'ion-ios-help-buoy',
	'ion-ios-help-circle',
	'ion-ios-help-circle-outline',
	'ion-ios-home',
	'ion-ios-hourglass',
	'ion-ios-ice-cream',
	'ion-ios-image',
	'ion-ios-images',
	'ion-ios-infinite',
	'ion-ios-information',
	'ion-ios-information-circle',
	'ion-ios-information-circle-outline',
	'ion-ios-jet',
	'ion-ios-journal',
	'ion-ios-key',
	'ion-ios-keypad',
	'ion-ios-laptop',
	'ion-ios-leaf',
	'ion-ios-link',
	'ion-ios-list',
	'ion-ios-list-box',
	'ion-ios-locate',
	'ion-ios-lock',
	'ion-ios-log-in',
	'ion-ios-log-out',
	'ion-ios-magnet',
	'ion-ios-mail',
	'ion-ios-mail-open',
	'ion-ios-mail-unread',
	'ion-ios-male',
	'ion-ios-man',
	'ion-ios-map',
	'ion-ios-medal',
	'ion-ios-medical',
	'ion-ios-medkit',
	'ion-ios-megaphone',
	'ion-ios-menu',
	'ion-ios-mic',
	'ion-ios-mic-off',
	'ion-ios-microphone',
	'ion-ios-moon',
	'ion-ios-more',
	'ion-ios-move',
	'ion-ios-musical-note',
	'ion-ios-musical-notes',
	'ion-ios-navigate',
	'ion-ios-notifications',
	'ion-ios-notifications-off',
	'ion-ios-notifications-outline',
	'ion-ios-nuclear',
	'ion-ios-nutrition',
	'ion-ios-open',
	'ion-ios-options',
	'ion-ios-outlet',
	'ion-ios-paper',
	'ion-ios-paper-plane',
	'ion-ios-partly-sunny',
	'ion-ios-pause',
	'ion-ios-paw',
	'ion-ios-people',
	'ion-ios-person',
	'ion-ios-person-add',
	'ion-ios-phone-landscape',
	'ion-ios-phone-portrait',
	'ion-ios-photos',
	'ion-ios-pie',
	'ion-ios-pin',
	'ion-ios-pint',
	'ion-ios-pizza',
	'ion-ios-planet',
	'ion-ios-play',
	'ion-ios-play-circle',
	'ion-ios-podium',
	'ion-ios-power',
	'ion-ios-pricetag',
	'ion-ios-pricetags',
	'ion-ios-print',
	'ion-ios-pulse',
	'ion-ios-qr-scanner',
	'ion-ios-quote',
	'ion-ios-radio',
	'ion-ios-radio-button-off',
	'ion-ios-radio-button-on',
	'ion-ios-rainy',
	'ion-ios-recording',
	'ion-ios-redo',
	'ion-ios-refresh',
	'ion-ios-refresh-circle',
	'ion-ios-remove',
	'ion-ios-remove-circle',
	'ion-ios-remove-circle-outline',
	'ion-ios-reorder',
	'ion-ios-repeat',
	'ion-ios-resize',
	'ion-ios-restaurant',
	'ion-ios-return-left',
	'ion-ios-return-right',
	'ion-ios-reverse-camera',
	'ion-ios-rewind',
	'ion-ios-ribbon',
	'ion-ios-rocket',
	'ion-ios-rose',
	'ion-ios-sad',
	'ion-ios-save',
	'ion-ios-school',
	'ion-ios-search',
	'ion-ios-send',
	'ion-ios-settings',
	'ion-ios-share',
	'ion-ios-share-alt',
	'ion-ios-shirt',
	'ion-ios-shuffle',
	'ion-ios-skip-backward',
	'ion-ios-skip-forward',
	'ion-ios-snow',
	'ion-ios-speedometer',
	'ion-ios-square',
	'ion-ios-square-outline',
	'ion-ios-star',
	'ion-ios-star-half',
	'ion-ios-star-outline',
	'ion-ios-stats',
	'ion-ios-stopwatch',
	'ion-ios-subway',
	'ion-ios-sunny',
	'ion-ios-swap',
	'ion-ios-switch',
	'ion-ios-sync',
	'ion-ios-tablet-landscape',
	'ion-ios-tablet-portrait',
	'ion-ios-tennisball',
	'ion-ios-text',
	'ion-ios-thermometer',
	'ion-ios-thumbs-down',
	'ion-ios-thumbs-up',
	'ion-ios-thunderstorm',
	'ion-ios-time',
	'ion-ios-timer',
	'ion-ios-today',
	'ion-ios-train',
	'ion-ios-transgender',
	'ion-ios-trash',
	'ion-ios-trending-down',
	'ion-ios-trending-up',
	'ion-ios-trophy',
	'ion-ios-tv',
	'ion-ios-umbrella',
	'ion-ios-undo',
	'ion-ios-unlock',
	'ion-ios-videocam',
	'ion-ios-volume-high',
	'ion-ios-volume-low',
	'ion-ios-volume-mute',
	'ion-ios-volume-off',
	'ion-ios-walk',
	'ion-ios-wallet',
	'ion-ios-warning',
	'ion-ios-watch',
	'ion-ios-water',
	'ion-ios-wifi',
	'ion-ios-wine',
	'ion-ios-woman',
	'ion-logo-android',
	'ion-logo-angular',
	'ion-logo-apple',
	'ion-logo-bitbucket',
	'ion-logo-bitcoin',
	'ion-logo-buffer',
	'ion-logo-chrome',
	'ion-logo-closed-captioning',
	'ion-logo-codepen',
	'ion-logo-css3',
	'ion-logo-designernews',
	'ion-logo-dribbble',
	'ion-logo-dropbox',
	'ion-logo-euro',
	'ion-logo-facebook',
	'ion-logo-flickr',
	'ion-logo-foursquare',
	'ion-logo-freebsd-devil',
	'ion-logo-game-controller-a',
	'ion-logo-game-controller-b',
	'ion-logo-github',
	'ion-logo-google',
	'ion-logo-googleplus',
	'ion-logo-hackernews',
	'ion-logo-html5',
	'ion-logo-instagram',
	'ion-logo-ionic',
	'ion-logo-ionitron',
	'ion-logo-javascript',
	'ion-logo-linkedin',
	'ion-logo-markdown',
	'ion-logo-model-s',
	'ion-logo-no-smoking',
	'ion-logo-nodejs',
	'ion-logo-npm',
	'ion-logo-octocat',
	'ion-logo-pinterest',
	'ion-logo-playstation',
	'ion-logo-polymer',
	'ion-logo-python',
	'ion-logo-reddit',
	'ion-logo-rss',
	'ion-logo-sass',
	'ion-logo-skype',
	'ion-logo-slack',
	'ion-logo-snapchat',
	'ion-logo-steam',
	'ion-logo-tumblr',
	'ion-logo-tux',
	'ion-logo-twitch',
	'ion-logo-twitter',
	'ion-logo-usd',
	'ion-logo-vimeo',
	'ion-logo-vk',
	'ion-logo-whatsapp',
	'ion-logo-windows',
	'ion-logo-wordpress',
	'ion-logo-xbox',
	'ion-logo-xing',
	'ion-logo-yahoo',
	'ion-logo-yen',
	'ion-logo-youtube',
	'ion-md-add',
	'ion-md-add-circle',
	'ion-md-add-circle-outline',
	'ion-md-airplane',
	'ion-md-alarm',
	'ion-md-albums',
	'ion-md-alert',
	'ion-md-american-football',
	'ion-md-analytics',
	'ion-md-aperture',
	'ion-md-apps',
	'ion-md-appstore',
	'ion-md-archive',
	'ion-md-arrow-back',
	'ion-md-arrow-down',
	'ion-md-arrow-dropdown',
	'ion-md-arrow-dropdown-circle',
	'ion-md-arrow-dropleft',
	'ion-md-arrow-dropleft-circle',
	'ion-md-arrow-dropright',
	'ion-md-arrow-dropright-circle',
	'ion-md-arrow-dropup',
	'ion-md-arrow-dropup-circle',
	'ion-md-arrow-forward',
	'ion-md-arrow-round-back',
	'ion-md-arrow-round-down',
	'ion-md-arrow-round-forward',
	'ion-md-arrow-round-up',
	'ion-md-arrow-up',
	'ion-md-at',
	'ion-md-attach',
	'ion-md-backspace',
	'ion-md-barcode',
	'ion-md-baseball',
	'ion-md-basket',
	'ion-md-basketball',
	'ion-md-battery-charging',
	'ion-md-battery-dead',
	'ion-md-battery-full',
	'ion-md-beaker',
	'ion-md-bed',
	'ion-md-beer',
	'ion-md-bicycle',
	'ion-md-bluetooth',
	'ion-md-boat',
	'ion-md-body',
	'ion-md-bonfire',
	'ion-md-book',
	'ion-md-bookmark',
	'ion-md-bookmarks',
	'ion-md-bowtie',
	'ion-md-briefcase',
	'ion-md-browsers',
	'ion-md-brush',
	'ion-md-bug',
	'ion-md-build',
	'ion-md-bulb',
	'ion-md-bus',
	'ion-md-business',
	'ion-md-cafe',
	'ion-md-calculator',
	'ion-md-calendar',
	'ion-md-call',
	'ion-md-camera',
	'ion-md-car',
	'ion-md-card',
	'ion-md-cart',
	'ion-md-cash',
	'ion-md-cellular',
	'ion-md-chatboxes',
	'ion-md-chatbubbles',
	'ion-md-checkbox',
	'ion-md-checkbox-outline',
	'ion-md-checkmark',
	'ion-md-checkmark-circle',
	'ion-md-checkmark-circle-outline',
	'ion-md-clipboard',
	'ion-md-clock',
	'ion-md-close',
	'ion-md-close-circle',
	'ion-md-close-circle-outline',
	'ion-md-cloud',
	'ion-md-cloud-circle',
	'ion-md-cloud-done',
	'ion-md-cloud-download',
	'ion-md-cloud-outline',
	'ion-md-cloud-upload',
	'ion-md-cloudy',
	'ion-md-cloudy-night',
	'ion-md-code',
	'ion-md-code-download',
	'ion-md-code-working',
	'ion-md-cog',
	'ion-md-color-fill',
	'ion-md-color-filter',
	'ion-md-color-palette',
	'ion-md-color-wand',
	'ion-md-compass',
	'ion-md-construct',
	'ion-md-contact',
	'ion-md-contacts',
	'ion-md-contract',
	'ion-md-contrast',
	'ion-md-copy',
	'ion-md-create',
	'ion-md-crop',
	'ion-md-cube',
	'ion-md-cut',
	'ion-md-desktop',
	'ion-md-disc',
	'ion-md-document',
	'ion-md-done-all',
	'ion-md-download',
	'ion-md-easel',
	'ion-md-egg',
	'ion-md-exit',
	'ion-md-expand',
	'ion-md-eye',
	'ion-md-eye-off',
	'ion-md-fastforward',
	'ion-md-female',
	'ion-md-filing',
	'ion-md-film',
	'ion-md-finger-print',
	'ion-md-fitness',
	'ion-md-flag',
	'ion-md-flame',
	'ion-md-flash',
	'ion-md-flash-off',
	'ion-md-flashlight',
	'ion-md-flask',
	'ion-md-flower',
	'ion-md-folder',
	'ion-md-folder-open',
	'ion-md-football',
	'ion-md-funnel',
	'ion-md-gift',
	'ion-md-git-branch',
	'ion-md-git-commit',
	'ion-md-git-compare',
	'ion-md-git-merge',
	'ion-md-git-network',
	'ion-md-git-pull-request',
	'ion-md-glasses',
	'ion-md-globe',
	'ion-md-grid',
	'ion-md-hammer',
	'ion-md-hand',
	'ion-md-happy',
	'ion-md-headset',
	'ion-md-heart',
	'ion-md-heart-dislike',
	'ion-md-heart-empty',
	'ion-md-heart-half',
	'ion-md-help',
	'ion-md-help-buoy',
	'ion-md-help-circle',
	'ion-md-help-circle-outline',
	'ion-md-home',
	'ion-md-hourglass',
	'ion-md-ice-cream',
	'ion-md-image',
	'ion-md-images',
	'ion-md-infinite',
	'ion-md-information',
	'ion-md-information-circle',
	'ion-md-information-circle-outline',
	'ion-md-jet',
	'ion-md-journal',
	'ion-md-key',
	'ion-md-keypad',
	'ion-md-laptop',
	'ion-md-leaf',
	'ion-md-link',
	'ion-md-list',
	'ion-md-list-box',
	'ion-md-locate',
	'ion-md-lock',
	'ion-md-log-in',
	'ion-md-log-out',
	'ion-md-magnet',
	'ion-md-mail',
	'ion-md-mail-open',
	'ion-md-mail-unread',
	'ion-md-male',
	'ion-md-man',
	'ion-md-map',
	'ion-md-medal',
	'ion-md-medical',
	'ion-md-medkit',
	'ion-md-megaphone',
	'ion-md-menu',
	'ion-md-mic',
	'ion-md-mic-off',
	'ion-md-microphone',
	'ion-md-moon',
	'ion-md-more',
	'ion-md-move',
	'ion-md-musical-note',
	'ion-md-musical-notes',
	'ion-md-navigate',
	'ion-md-notifications',
	'ion-md-notifications-off',
	'ion-md-notifications-outline',
	'ion-md-nuclear',
	'ion-md-nutrition',
	'ion-md-open',
	'ion-md-options',
	'ion-md-outlet',
	'ion-md-paper',
	'ion-md-paper-plane',
	'ion-md-partly-sunny',
	'ion-md-pause',
	'ion-md-paw',
	'ion-md-people',
	'ion-md-person',
	'ion-md-person-add',
	'ion-md-phone-landscape',
	'ion-md-phone-portrait',
	'ion-md-photos',
	'ion-md-pie',
	'ion-md-pin',
	'ion-md-pint',
	'ion-md-pizza',
	'ion-md-planet',
	'ion-md-play',
	'ion-md-play-circle',
	'ion-md-podium',
	'ion-md-power',
	'ion-md-pricetag',
	'ion-md-pricetags',
	'ion-md-print',
	'ion-md-pulse',
	'ion-md-qr-scanner',
	'ion-md-quote',
	'ion-md-radio',
	'ion-md-radio-button-off',
	'ion-md-radio-button-on',
	'ion-md-rainy',
	'ion-md-recording',
	'ion-md-redo',
	'ion-md-refresh',
	'ion-md-refresh-circle',
	'ion-md-remove',
	'ion-md-remove-circle',
	'ion-md-remove-circle-outline',
	'ion-md-reorder',
	'ion-md-repeat',
	'ion-md-resize',
	'ion-md-restaurant',
	'ion-md-return-left',
	'ion-md-return-right',
	'ion-md-reverse-camera',
	'ion-md-rewind',
	'ion-md-ribbon',
	'ion-md-rocket',
	'ion-md-rose',
	'ion-md-sad',
	'ion-md-save',
	'ion-md-school',
	'ion-md-search',
	'ion-md-send',
	'ion-md-settings',
	'ion-md-share',
	'ion-md-share-alt',
	'ion-md-shirt',
	'ion-md-shuffle',
	'ion-md-skip-backward',
	'ion-md-skip-forward',
	'ion-md-snow',
	'ion-md-speedometer',
	'ion-md-square',
	'ion-md-square-outline',
	'ion-md-star',
	'ion-md-star-half',
	'ion-md-star-outline',
	'ion-md-stats',
	'ion-md-stopwatch',
	'ion-md-subway',
	'ion-md-sunny',
	'ion-md-swap',
	'ion-md-switch',
	'ion-md-sync',
	'ion-md-tablet-landscape',
	'ion-md-tablet-portrait',
	'ion-md-tennisball',
	'ion-md-text',
	'ion-md-thermometer',
	'ion-md-thumbs-down',
	'ion-md-thumbs-up',
	'ion-md-thunderstorm',
	'ion-md-time',
	'ion-md-timer',
	'ion-md-today',
	'ion-md-train',
	'ion-md-transgender',
	'ion-md-trash',
	'ion-md-trending-down',
	'ion-md-trending-up',
	'ion-md-trophy',
	'ion-md-tv',
	'ion-md-umbrella',
	'ion-md-undo',
	'ion-md-unlock',
	'ion-md-videocam',
	'ion-md-volume-high',
	'ion-md-volume-low',
	'ion-md-volume-mute',
	'ion-md-volume-off',
	'ion-md-walk',
	'ion-md-wallet',
	'ion-md-warning',
	'ion-md-watch',
	'ion-md-water',
	'ion-md-wifi',
	'ion-md-wine',
	'ion-md-woman'
]

// Themify (matching themify-class-names.js)
window.ThemifyClassNames = [
	'ti-arrow-up',
	'ti-arrow-right',
	'ti-arrow-left',
	'ti-arrow-down',
	'ti-arrows-vertical',
	'ti-arrows-horizontal',
	'ti-angle-up',
	'ti-angle-right',
	'ti-angle-left',
	'ti-angle-down',
	'ti-angle-double-up',
	'ti-angle-double-right',
	'ti-angle-double-left',
	'ti-angle-double-down',
	'ti-move',
	'ti-fullscreen',
	'ti-arrow-top-right',
	'ti-arrow-top-left',
	'ti-arrow-circle-up',
	'ti-arrow-circle-right',
	'ti-arrow-circle-left',
	'ti-arrow-circle-down',
	'ti-arrows-corner',
	'ti-split-v',
	'ti-split-v-alt',
	'ti-split-h',
	'ti-hand-point-up',
	'ti-hand-point-right',
	'ti-hand-point-left',
	'ti-hand-point-down',
	'ti-back-right',
	'ti-back-left',
	'ti-exchange-vertical',
	'ti-wand',
	'ti-save',
	'ti-save-alt',
	'ti-direction',
	'ti-direction-alt',
	'ti-user',
	'ti-link',
	'ti-unlink',
	'ti-trash',
	'ti-target',
	'ti-tag',
	'ti-desktop',
	'ti-tablet',
	'ti-mobile',
	'ti-email',
	'ti-star',
	'ti-spray',
	'ti-signal',
	'ti-shopping-cart',
	'ti-shopping-cart-full',
	'ti-settings',
	'ti-search',
	'ti-zoom-in',
	'ti-zoom-out',
	'ti-cut',
	'ti-ruler',
	'ti-ruler-alt-2',
	'ti-ruler-pencil',
	'ti-ruler-alt',
	'ti-bookmark',
	'ti-bookmark-alt',
	'ti-reload',
	'ti-plus',
	'ti-minus',
	'ti-close',
	'ti-pin',
	'ti-pencil',
	'ti-pencil-alt',
	'ti-paint-roller',
	'ti-paint-bucket',
	'ti-na',
	'ti-medall',
	'ti-medall-alt',
	'ti-marker',
	'ti-marker-alt',
	'ti-lock',
	'ti-unlock',
	'ti-location-arrow',
	'ti-layout',
	'ti-layers',
	'ti-layers-alt',
	'ti-key',
	'ti-image',
	'ti-heart',
	'ti-heart-broken',
	'ti-hand-stop',
	'ti-hand-open',
	'ti-hand-drag',
	'ti-flag',
	'ti-flag-alt',
	'ti-flag-alt-2',
	'ti-eye',
	'ti-import',
	'ti-export',
	'ti-cup',
	'ti-crown',
	'ti-comments',
	'ti-comment',
	'ti-comment-alt',
	'ti-thought',
	'ti-clip',
	'ti-check',
	'ti-check-box',
	'ti-camera',
	'ti-announcement',
	'ti-brush',
	'ti-brush-alt',
	'ti-palette',
	'ti-briefcase',
	'ti-bolt',
	'ti-bolt-alt',
	'ti-blackboard',
	'ti-bag',
	'ti-world',
	'ti-wheelchair',
	'ti-car',
	'ti-truck',
	'ti-timer',
	'ti-ticket',
	'ti-thumb-up',
	'ti-thumb-down',
	'ti-stats-up',
	'ti-stats-down',
	'ti-shine',
	'ti-shift-right',
	'ti-shift-left',
	'ti-shift-right-alt',
	'ti-shift-left-alt',
	'ti-shield',
	'ti-notepad',
	'ti-server',
	'ti-pulse',
	'ti-printer',
	'ti-power-off',
	'ti-plug',
	'ti-pie-chart',
	'ti-panel',
	'ti-package',
	'ti-music',
	'ti-music-alt',
	'ti-mouse',
	'ti-mouse-alt',
	'ti-money',
	'ti-microphone',
	'ti-menu',
	'ti-menu-alt',
	'ti-map',
	'ti-map-alt',
	'ti-location-pin',
	'ti-light-bulb',
	'ti-info',
	'ti-infinite',
	'ti-id-badge',
	'ti-hummer',
	'ti-home',
	'ti-help',
	'ti-headphone',
	'ti-harddrives',
	'ti-harddrive',
	'ti-gift',
	'ti-game',
	'ti-filter',
	'ti-files',
	'ti-file',
	'ti-zip',
	'ti-folder',
	'ti-envelope',
	'ti-dashboard',
	'ti-cloud',
	'ti-cloud-up',
	'ti-cloud-down',
	'ti-clipboard',
	'ti-calendar',
	'ti-book',
	'ti-bell',
	'ti-basketball',
	'ti-bar-chart',
	'ti-bar-chart-alt',
	'ti-archive',
	'ti-anchor',
	'ti-alert',
	'ti-alarm-clock',
	'ti-agenda',
	'ti-write',
	'ti-wallet',
	'ti-video-clapper',
	'ti-video-camera',
	'ti-vector',
	'ti-support',
	'ti-stamp',
	'ti-slice',
	'ti-shortcode',
	'ti-receipt',
	'ti-pin2',
	'ti-pin-alt',
	'ti-pencil-alt2',
	'ti-eraser',
	'ti-more',
	'ti-more-alt',
	'ti-microphone-alt',
	'ti-magnet',
	'ti-line-double',
	'ti-line-dotted',
	'ti-line-dashed',
	'ti-ink-pen',
	'ti-info-alt',
	'ti-help-alt',
	'ti-headphone-alt',
	'ti-gallery',
	'ti-face-smile',
	'ti-face-sad',
	'ti-credit-card',
	'ti-comments-smiley',
	'ti-time',
	'ti-share',
	'ti-share-alt',
	'ti-rocket',
	'ti-new-window',
	'ti-rss',
	'ti-rss-alt',
	'ti-control-stop',
	'ti-control-shuffle',
	'ti-control-play',
	'ti-control-pause',
	'ti-control-forward',
	'ti-control-backward',
	'ti-volume',
	'ti-control-skip-forward',
	'ti-control-skip-backward',
	'ti-control-record',
	'ti-control-eject',
	'ti-paragraph',
	'ti-uppercase',
	'ti-underline',
	'ti-text',
	'ti-Italic',
	'ti-smallcap',
	'ti-list',
	'ti-list-ol',
	'ti-align-right',
	'ti-align-left',
	'ti-align-justify',
	'ti-align-center',
	'ti-quote-right',
	'ti-quote-left',
	'ti-layout-width-full',
	'ti-layout-width-default',
	'ti-layout-width-default-alt',
	'ti-layout-tab',
	'ti-layout-tab-window',
	'ti-layout-tab-v',
	'ti-layout-tab-min',
	'ti-layout-slider',
	'ti-layout-slider-alt',
	'ti-layout-sidebar-right',
	'ti-layout-sidebar-none',
	'ti-layout-sidebar-left',
	'ti-layout-placeholder',
	'ti-layout-menu',
	'ti-layout-menu-v',
	'ti-layout-menu-separated',
	'ti-layout-menu-full',
	'ti-layout-media-right',
	'ti-layout-media-right-alt',
	'ti-layout-media-overlay',
	'ti-layout-media-overlay-alt',
	'ti-layout-media-overlay-alt-2',
	'ti-layout-media-left',
	'ti-layout-media-left-alt',
	'ti-layout-media-center',
	'ti-layout-media-center-alt',
	'ti-layout-list-thumb',
	'ti-layout-list-thumb-alt',
	'ti-layout-list-post',
	'ti-layout-list-large-image',
	'ti-layout-line-solid',
	'ti-layout-grid4',
	'ti-layout-grid3',
	'ti-layout-grid2',
	'ti-layout-grid2-thumb',
	'ti-layout-cta-right',
	'ti-layout-cta-left',
	'ti-layout-cta-center',
	'ti-layout-cta-btn-right',
	'ti-layout-cta-btn-left',
	'ti-layout-column4',
	'ti-layout-column3',
	'ti-layout-column2',
	'ti-layout-accordion-separated',
	'ti-layout-accordion-merged',
	'ti-layout-accordion-list',
	'ti-widgetized',
	'ti-widget',
	'ti-widget-alt',
	'ti-view-list',
	'ti-view-list-alt',
	'ti-view-grid',
	'ti-upload',
	'ti-download',
	'ti-loop',
	'ti-layout-sidebar-2',
	'ti-layout-grid4-alt',
	'ti-layout-grid3-alt',
	'ti-layout-grid2-alt',
	'ti-layout-column4-alt',
	'ti-layout-column3-alt',
	'ti-layout-column2-alt',
	'ti-flickr',
	'ti-flickr-alt',
	'ti-instagram',
	'ti-google',
	'ti-github',
	'ti-facebook',
	'ti-dropbox',
	'ti-dropbox-alt',
	'ti-dribbble',
	'ti-apple',
	'ti-android',
	'ti-yahoo',
	'ti-trello',
	'ti-stack-overflow',
	'ti-soundcloud',
	'ti-sharethis',
	'ti-sharethis-alt',
	'ti-reddit',
	'ti-microsoft',
	'ti-microsoft-alt',
	'ti-linux',
	'ti-jsfiddle',
	'ti-joomla',
	'ti-html5',
	'ti-css3',
	'ti-drupal',
	'ti-wordpress',
	'ti-tumblr',
	'ti-tumblr-alt',
	'ti-skype',
	'ti-youtube',
	'ti-vimeo',
	'ti-vimeo-alt',
	'ti-twitter',
	'ti-twitter-alt',
	'ti-linkedin',
	'ti-pinterest',
	'ti-pinterest-alt',
	'ti-themify-logo',
	'ti-themify-favicon',
	'ti-themify-favicon-alt'
]
