<?php
namespace Advanced_Themer_Bricks;
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class AT__Admin{

    public static function add_plugin_links($links) {

        global $brxc_acf_fields;

        if( AT__Helpers::return_user_role_check() === true ) {
            // Setting Page
            $url_settings = esc_url( add_query_arg(
                'page',
                'bricks-advanced-themer',
                get_admin_url() . 'admin.php'
            ) );
            $settings_link = "<a href='$url_settings'>" . __( 'Theme Settings' ) . '</a>';
            array_push(
                $links,
                $settings_link
            );

            // License
            $url_license = esc_url( add_query_arg(
                'page',
                'at-license',
                get_admin_url() . 'admin.php'
            ) );
            $license_link = "<a href='$url_license'>" . __( 'License' ) . '</a>';
            array_push(
                $links,
                $license_link
            );
            
            // Support
            $support_link = "<a href='mailto:hello@advancedthemer.com'>" . __( 'Support' ) . '</a>';
            array_push(
                $links,
                $support_link
            );
        }

        return $links;

    }

    public static function add_admin_bar_menu( $admin_bar ) {

        global $brxc_acf_fields;

        if (!AT__Helpers::return_user_role_check() === true  ||  !isset($brxc_acf_fields['theme_settings_tabs']) || empty($brxc_acf_fields['theme_settings_tabs']) || !is_array($brxc_acf_fields['theme_settings_tabs']) || !in_array('admin-bar', $brxc_acf_fields['theme_settings_tabs']) ) {

            return;
        };

        $args = array (
                'id'        => 'brxc-advanced-themer-admin-bar',
                'title'     => 'Advanced Themer',
        );
    
        $admin_bar->add_node( $args );

        $args = array (
            'id'        => 'brxc-theme-settings-admin-bar',
            'title'     => 'Theme Settings',
            'href'      => \get_admin_url() . 'admin.php?page=bricks-advanced-themer',
            'parent'    => 'brxc-advanced-themer-admin-bar'
        );

        $admin_bar->add_node( $args );

        $args = array (
            'id'        => 'brxc-license-admin-bar',
            'title'     => 'Manage your License',
            'href'      => \get_admin_url() . 'admin.php?page=at-license',
            'parent'    => 'brxc-advanced-themer-admin-bar'
        );

        $admin_bar->add_node( $args );
        
    }

    public static function color_palette_cpt_init() {

        global $brxc_acf_fields;

        if ( !AT__Helpers::is_global_colors_category_activated() ) {

            return;

        }

        $args = [
            'label'  => esc_html__( 'Color Palettes', 'text-domain' ),
            'labels' => [
                'menu_name'          => esc_html__( 'Color Palettes', 'bricks-advanced-themer' ),
                'name_admin_bar'     => esc_html__( 'Color Palette', 'bricks-advanced-themer' ),
                'add_new'            => esc_html__( 'Add Color Palette', 'bricks-advanced-themer' ),
                'add_new_item'       => esc_html__( 'Add new Color Palette', 'bricks-advanced-themer' ),
                'new_item'           => esc_html__( 'New Color Palette', 'bricks-advanced-themer' ),
                'edit_item'          => esc_html__( 'Edit Color Palette', 'bricks-advanced-themer' ),
                'view_item'          => esc_html__( 'View Color Palette', 'bricks-advanced-themer' ),
                'update_item'        => esc_html__( 'View Color Palette', 'bricks-advanced-themer' ),
                'all_items'          => esc_html__( 'AT - Color Palettes', 'bricks-advanced-themer' ),
                'search_items'       => esc_html__( 'Search Color Palettes', 'bricks-advanced-themer' ),
                'parent_item_colon'  => esc_html__( 'Parent Color Palette', 'bricks-advanced-themer' ),
                'not_found'          => esc_html__( 'No Color Palettes found', 'bricks-advanced-themer' ),
                'not_found_in_trash' => esc_html__( 'No Color Palettes found in Trash', 'bricks-advanced-themer' ),
                'name'               => esc_html__( 'Color Palettes', 'bricks-advanced-themer' ),
                'singular_name'      => esc_html__( 'Color Palette', 'bricks-advanced-themer' ),
            ],
            'public'              => false,
            'exclude_from_search' => true,
            'publicly_queryable'  => false,
            'show_ui'             => true,
            'show_in_nav_menus'   => true,
            'show_in_admin_bar'   => false,
            'show_in_rest'        => false,
            'capability_type'     => 'post',
            'hierarchical'        => false,
            'has_archive'         => false,
            'query_var'           => false,
            'can_export'          => true,
            'rewrite_no_front'    => false,
            'menu_icon'           => 'dashicons-art',
            'show_in_menu'        => false,
            'supports'            => array( 'title', 'revisions'),
            'rewrite' => true
        ];

        if (!AT__Helpers::return_user_role_check() === true){

            unset($args['show_in_menu']);
            $args['show_in_nav_menus'] = false;
            $args['show_ui'] = false;

        }
    
        register_post_type( 'brxc_color_palette', $args );

    }
    public static function remove_theme_settings_from_bricks_menu( $menu_order ) {

        if (AT__Helpers::return_user_role_check() === false){

            remove_submenu_page('bricks', 'bricks-advanced-themer');

        }

    }

    public static function remove_templates_from_menu() {

        if (!class_exists('Bricks\Capabilities')) {
            return;
        }

        global $brxc_acf_fields;
        if(\Bricks\Capabilities::current_user_has_full_access() !== true && AT__Helpers::is_strict_editor_view_miscellaneous_tab_activated() && isset($brxc_acf_fields['strict_editor_view_tweaks']) && !empty($brxc_acf_fields['strict_editor_view_tweaks']) && in_array('remove-template-settings-links', $brxc_acf_fields['strict_editor_view_tweaks'])){
            remove_menu_page( 'bricks' );

        }
    }

    public static function remove_templates_from_toolbar() {

        if (!class_exists('Bricks\Capabilities')) {
            return;
        }

        global $brxc_acf_fields;
        global $wp_admin_bar;

        if(!\Bricks\Capabilities::current_user_has_full_access() === true && AT__Helpers::is_strict_editor_view_miscellaneous_tab_activated() && isset($brxc_acf_fields['strict_editor_view_tweaks']) && !empty($brxc_acf_fields['strict_editor_view_tweaks']) && in_array('remove-template-settings-links', $brxc_acf_fields['strict_editor_view_tweaks'])){

            $wp_admin_bar->remove_menu('edit_with_bricks_header');
            $wp_admin_bar->remove_menu('edit_with_bricks_footer');
            $wp_admin_bar->remove_menu('bricks_settings');
            $wp_admin_bar->remove_menu('bricks_templates');
            $wp_admin_bar->remove_menu('editor_mode');

        }

    }

    /* ADD THE CUSTOM COLUMN INSIDE THE Before/After image CPT */
    public static function manage_brxc_color_palette_posts_columns_callback($columns) {

        // Deprecated in 1.4
        global $brxc_acf_fields;

        if($brxc_acf_fields['color_cpt_deprecated']) return;
        //

        $new = array(
        "cb" => "<input type=\"checkbox\" />",
        );

        foreach( $columns as $key => $title ) {

            if ( $key=='title' ) {

                $new[$key] = $title;

            }

            if ( $key=='date' ) {

                $new['colors'] = 'Colors';

                $new['shades'] = 'Shades';

                $new['darkmode'] = 'Darkmode';

                $new['json'] = 'JSON';

                $new['prefix'] = 'Prefix';

                $new[$key] = $title;

            }

        }

        return $new;

    }

    
    /* POPULATE THE ACF VALUE INSIDE EACH COLUMN */
    public static function colors_custom_column( $column, $post_id ) {

        // Deprecated in 1.4
        global $brxc_acf_fields;

        if($brxc_acf_fields['color_cpt_deprecated']) return;
        //

        switch ( $column ) {

            case 'colors':

                echo '<style>.brxc-colors-wrapper{display:flex;flex-wrap:wrap;gap:.3rem;}.brxc-color-div{width:30px;height:30px;border-radius:50%;}</style>';

                echo '<div class="brxc-colors-wrapper">';

                if( have_rows( 'brxc_colors_repeater' ) ) :

                    while( have_rows( 'brxc_colors_repeater' ) ):

                        the_row();

                        $color = get_sub_field( 'brxc_color_hex' );

                        echo (isset($color) && $color) ? '<div class="brxc-color-div" style="background-color: ' . sanitize_hex_color( $color ) . ' "></div>' : '';

                    endwhile;

                endif;

                echo '</div>';

            break;

            case 'shades':

                $shades = get_field('brxc_enable_shapes');

                echo (isset($shades) && $shades) ? 'Enabled' : 'Disabled';

            break;

            case 'darkmode':

                $darkmode = get_field('brxc_enable_dark_mode');

                echo (isset($darkmode) && $darkmode) ? 'Enabled' : 'Disabled';

            break;

            case 'json':

                $json = get_field('brxc_import_from_json');

                echo (isset($json) && $json) ? 'Yes' : 'No';

            break;

            case 'prefix':

                $prefix = get_field('brxc_variable_prefix');

                echo ( isset($prefix) && $prefix ) ? '"' . $prefix . '"' : 'Disabled';

            break;

        }

    }

    // Register Scripts
    public static function register_scripts(){
        wp_register_script( 'sass', \BRICKS_ADVANCED_THEMER_URL . 'assets/js/sass.js', [], filemtime( \BRICKS_ADVANCED_THEMER_PATH . '/assets/js/sass.js' ) );
        wp_register_script( 'sass-worker', \BRICKS_ADVANCED_THEMER_URL . 'assets/js/sass.worker.js', ['sass'], filemtime( \BRICKS_ADVANCED_THEMER_PATH . '/assets/js/sass.worker.js' ) );
        wp_register_script( 'sass-sync', \BRICKS_ADVANCED_THEMER_URL . 'assets/js/sass.sync.js', ['sass'], filemtime( \BRICKS_ADVANCED_THEMER_PATH . '/assets/js/sass.sync.js' ) );
        
        // Styles
        wp_register_style( 'bricks-advanced-themer', \BRICKS_ADVANCED_THEMER_URL . 'assets/css/bricks-advanced-themer.css', [], filemtime( \BRICKS_ADVANCED_THEMER_PATH . '/assets/css/bricks-advanced-themer.css' ) );
        wp_register_style( 'bricks-advanced-themer-builder', \BRICKS_ADVANCED_THEMER_URL . 'assets/css/bricks-advanced-themer-builder.css', [], filemtime( \BRICKS_ADVANCED_THEMER_PATH . '/assets/css/bricks-advanced-themer-builder.css' ) );
        wp_register_style( 'bricks-advanced-themer-backend', \BRICKS_ADVANCED_THEMER_URL . 'assets/css/bricks-advanced-themer-backend.css', [], \BRICKS_ADVANCED_THEMER_VERSION );
        wp_enqueue_style( 'bricks-advanced-themer' );
        wp_register_style( 'alwan', \BRICKS_ADVANCED_THEMER_URL . 'assets/css/alwan.min.css', [], filemtime( \BRICKS_ADVANCED_THEMER_PATH . '/assets/css/alwan.min.css' ) );
        wp_register_style( 'brxc-darkmode-toggle', \BRICKS_ADVANCED_THEMER_URL . 'assets/css/darkmode-toggle.css', [], filemtime( \BRICKS_ADVANCED_THEMER_PATH . '/assets/css/darkmode-toggle.css' ) );
        wp_register_style( 'brxc-darkmode-btn', \BRICKS_ADVANCED_THEMER_URL . 'assets/css/darkmode-btn.css', [], filemtime( \BRICKS_ADVANCED_THEMER_PATH . '/assets/css/darkmode-btn.css' ) );
        wp_register_style( 'monokai', \BRICKS_ADVANCED_THEMER_URL . 'assets/css/monokai.min.css', [], filemtime( \BRICKS_ADVANCED_THEMER_PATH . '/assets/css/monokai.min.css' ) );
        wp_register_style( 'brxc-builder-new-codemirror', \BRICKS_ADVANCED_THEMER_URL . 'assets/js/codemirror/lib/codemirror.css', [], filemtime( \BRICKS_ADVANCED_THEMER_PATH . 'assets/js/codemirror/lib/codemirror.css' ) );
        wp_register_style( 'bricks-strict-editor-view', \BRICKS_ADVANCED_THEMER_URL . 'assets/css/bricks-strict-editor-view.css', [], filemtime( \BRICKS_ADVANCED_THEMER_PATH . '/assets/css/bricks-strict-editor-view.css' ) );
        wp_register_style( 'template-admin', \BRICKS_ADVANCED_THEMER_URL . 'assets/css/template-admin.css', [], filemtime( \BRICKS_ADVANCED_THEMER_PATH . '/assets/css/template-admin.css' ) );
        
        // Scripts
        wp_register_script( 'html2canvas', \BRICKS_ADVANCED_THEMER_URL . 'assets/js/html2canvas.min.js', [], filemtime( \BRICKS_ADVANCED_THEMER_PATH . '/assets/js/html2canvas.min.js' ) );
        wp_register_script( 'alwan', \BRICKS_ADVANCED_THEMER_URL . 'assets/js/alwan.min.js', [], filemtime( \BRICKS_ADVANCED_THEMER_PATH . '/assets/js/alwan.min.js' ) );
        wp_register_script( 'brxc-builder', \BRICKS_ADVANCED_THEMER_URL . 'assets/js/builder.js', ['sortable'], filemtime( \BRICKS_ADVANCED_THEMER_PATH . '/assets/js/builder.js' ) );
        wp_register_script( 'beautifer-css', \BRICKS_ADVANCED_THEMER_URL . 'assets/js/beautifer-css.js', [], filemtime( \BRICKS_ADVANCED_THEMER_PATH . '/assets/js/beautifer-css.js' ) );
        wp_register_script( 'brxc-builder-new-codemirror', \BRICKS_ADVANCED_THEMER_URL . 'assets/js/codemirror/lib/codemirror.js', [], filemtime( \BRICKS_ADVANCED_THEMER_PATH . 'assets/js/codemirror/lib/codemirror.js' ) );
        wp_register_script( 'brxc-darkmode-local-storage', \BRICKS_ADVANCED_THEMER_URL . 'assets/js/darkmode-local-storage.js', [], filemtime( \BRICKS_ADVANCED_THEMER_PATH . '/assets/js/darkmode-local-storage.js'), false  );
        wp_register_script( 'brxc-darkmode', \BRICKS_ADVANCED_THEMER_URL . 'assets/js/darkmode.js', [], filemtime( \BRICKS_ADVANCED_THEMER_PATH . '/assets/js/darkmode.js'), false  );
        wp_register_script( 'sortable', \BRICKS_ADVANCED_THEMER_URL . 'assets/js/Sortable.min.js', [], filemtime( \BRICKS_ADVANCED_THEMER_PATH . '/assets/js/Sortable.min.js' ) );
        wp_register_script( 'contrast', \BRICKS_ADVANCED_THEMER_URL . 'assets/js/contrast.js', [], filemtime( \BRICKS_ADVANCED_THEMER_PATH . '/assets/js/contrast.js' ) );
        wp_register_script( 'chroma', \BRICKS_ADVANCED_THEMER_URL . 'assets/js/chroma.min.js', [], filemtime( \BRICKS_ADVANCED_THEMER_PATH . '/assets/js/chroma.min.js' ) );
        wp_register_script( 'highlight', \BRICKS_ADVANCED_THEMER_URL . 'assets/js/highlight.min.js', [], filemtime( \BRICKS_ADVANCED_THEMER_PATH . '/assets/js/highlight.min.js' ) );
        wp_register_script( 'bricks-strict-editor-view', \BRICKS_ADVANCED_THEMER_URL . 'assets/js/bricks-strict-editor-view.js', [], filemtime( \BRICKS_ADVANCED_THEMER_PATH . '/assets/js/bricks-strict-editor-view.js' ) );
        wp_register_script( 'recursive-diff', \BRICKS_ADVANCED_THEMER_URL . 'assets/js/recursive-diff.min.js', [], filemtime( \BRICKS_ADVANCED_THEMER_PATH . '/assets/js/recursive-diff.min.js' ) );
        
    }

    public static function admin_enqueue_scripts($hook_suffix){

        global $brxc_acf_fields;

        wp_enqueue_style( 'bricks-advanced-themer-backend' );
        
    }

    public static function load_variables_on_backend() {

        $gutenberg_colors_frontend_css = AT__Frontend::generate_css_for_frontend();

        wp_add_inline_style( 'bricks-advanced-themer-backend', $gutenberg_colors_frontend_css );
    }
    public static function enqueue_builder_scripts() {

        if (!class_exists('Bricks\Capabilities') || !function_exists('bricks_is_builder') || !bricks_is_builder()) {
            
            return;
        }

        global $brxc_acf_fields;

        if( \Bricks\Capabilities::current_user_has_full_access() !== true){
            wp_enqueue_style( 'bricks-advanced-themer' );
        }

        if( \Bricks\Capabilities::current_user_has_full_access() !== true && AT__Helpers::is_strict_editor_view_category_activated()) {
            wp_enqueue_style( 'bricks-strict-editor-view' );

            $index = 0;
            $custom_css = '';

            // Strict Editor Builder Tweaks
            if(isset( $brxc_acf_fields['strict_editor_view_tweaks']) && is_array( $brxc_acf_fields['strict_editor_view_tweaks']) && !empty( $brxc_acf_fields['strict_editor_view_tweaks'])){
                
                // Hide
                if(in_array('hide-id-class',  $brxc_acf_fields['strict_editor_view_tweaks'])) {$custom_css .= '#bricks-panel #bricks-panel-inner #bricks-panel-element-classes,#bricks-panel-sticky,';}
                if(in_array('hide-dynamic-data',  $brxc_acf_fields['strict_editor_view_tweaks'])) {$custom_css .= '.dynamic-tag-picker-button,.show-dynamic-picker,';}
                if(in_array('hide-text-toolbar',  $brxc_acf_fields['strict_editor_view_tweaks'])) {$custom_css .= '#bricks-builder-contenteditable-toolbar,';}
                if(in_array('hide-structure-panel',  $brxc_acf_fields['strict_editor_view_tweaks'])) {$custom_css .= '#bricks-structure,#bricks-toolbar li.structure,';}

                $custom_css .= '.brxc-unexisting-class{display:none}';

                // Display
                $custom_css .= '.brxc-unexisting-class{display:block}';

                // Custom
                if(in_array('hide-structure-panel',  $brxc_acf_fields['strict_editor_view_tweaks'])) {
                    $custom_css .= '#bricks-preview.show-structure{margin-right: 0 !important;}';
                }

                // Custom CSS Tweak
                if(in_array('custom-css',  $brxc_acf_fields['strict_editor_view_tweaks']) && isset($brxc_acf_fields['strict_editor_view_custom_css']) && !empty($brxc_acf_fields['strict_editor_view_custom_css'])) {
                    $custom_css .= $brxc_acf_fields['strict_editor_view_custom_css'];
                }
            }

            // Elements
            if (AT__Helpers::is_strict_editor_view_elements_tab_activated() && isset($brxc_acf_fields['strict_editor_view_elements']) && !empty($brxc_acf_fields['strict_editor_view_elements']) && is_array($brxc_acf_fields['strict_editor_view_elements'])){

                foreach ( $brxc_acf_fields['strict_editor_view_elements'] as $element ){
                    if($index === 0){
                        $custom_css .= '.brx-draggable.bricks-draggable-handle .brxe-' . $element['value'];
                        $index++;
                    } else {
                        $custom_css .= ',.brx-draggable.bricks-draggable-handle .brxe-' . $element['value'];
                        $index++;
                    }
                }
                $custom_css .= '{pointer-events: auto;}[class*=brxe-].builder-active-element:not(';
                $index = 0;
                foreach ( $brxc_acf_fields['strict_editor_view_elements'] as $element ){
                    if($index === 0){
                        $custom_css .= '.brxe-' . $element['value'];
                        $index++;
                    } else {
                        $custom_css .= ',.brxe-' . $element['value'];
                        $index++;
                    }
    
                }
                $custom_css .= '){outline: 0 !important;outline-offset: 0 !important;}';

            }

            if(AT__Helpers::is_strict_editor_view_white_label_tab_activated() && isset($brxc_acf_fields['change_accent_color']) && !empty($brxc_acf_fields['change_accent_color']) ){
                $custom_css .= 'html body{--builder-color-accent:';
                $custom_css .= $brxc_acf_fields['change_accent_color'];
                $custom_css .= '}#bricks-toolbar .logo{background-color:';
                $custom_css .= $brxc_acf_fields['change_accent_color'];
                $custom_css .= '}';
            }
            if(AT__Helpers::is_strict_editor_view_toolbar_tab_activated() && isset($brxc_acf_fields['disable_toolbar_icons']) && !empty($brxc_acf_fields['disable_toolbar_icons']) && is_array($brxc_acf_fields['disable_toolbar_icons'])){
                $toolbar_items = [
                    ['logo','#bricks-toolbar li.logo'],
                    ['help','#bricks-toolbar li.docs'],
                    ['pages','#bricks-toolbar li.pages'],
                    ['revisions','#bricks-toolbar li.history'],
                    ['class-manager','#bricks-toolbar li.classes'],
                    ['settings','#bricks-toolbar li.settings'],
                    ['breakpoints','#bricks-toolbar li.breakpoint '],
                    ['dimensions','#bricks-toolbar li.preview-dimension'],
                    ['undo-redo','#bricks-toolbar li.undo, #bricks-toolbar li.redo'],
                    ['edit','#bricks-toolbar li:not([class])'],
                    ['preview','#bricks-toolbar li.preview']
                ];
                $temp_css = [];
                foreach ($toolbar_items as $item){

                    if(in_array($item[0], $brxc_acf_fields['disable_toolbar_icons'])){
                        $temp_css[] = $item[1];
                    }
                }

                $custom_css .= implode(",", $temp_css) . '{display: none !important;}';

            }
            if (AT__Helpers::is_strict_editor_view_miscellaneous_tab_activated() && isset($brxc_acf_fields['strict_editor_view_tweaks']) && !empty($brxc_acf_fields['strict_editor_view_tweaks']) && is_array($brxc_acf_fields['strict_editor_view_tweaks']) && in_array('reduce-left-panel-visibility',$brxc_acf_fields['strict_editor_view_tweaks'])){

                $custom_css .= '#bricks-panel{width:0!important;}';
                $custom_css .= '#bricks-panel.visible{width: 400px !important;}';
            }
            
            if (AT__Helpers::is_strict_editor_view_miscellaneous_tab_activated() && isset($brxc_acf_fields['strict_editor_view_tweaks']) && !empty($brxc_acf_fields['strict_editor_view_tweaks']) && is_array($brxc_acf_fields['strict_editor_view_tweaks']) && in_array('disable-header-footer-edit-button-on-hover',$brxc_acf_fields['strict_editor_view_tweaks'])){

                $custom_css .= 'body #brx-header.builder-active-element,body #brx-footer.builder-active-element{outline:0!important}body #brx-header .bricks-area-label,body #brx-footer .bricks-area-label{display:none!important;}';
            }
            
            wp_enqueue_script( 'bricks-strict-editor-view' );
            wp_add_inline_style('bricks-strict-editor-view', wp_strip_all_tags($custom_css), 'after');

            if(AT__Helpers::is_strict_editor_view_white_label_tab_activated() && $toolbar_img = $brxc_acf_fields['change_logo_img']){
                wp_add_inline_script('bricks-builder', 'window.addEventListener("DOMContentLoaded", () => {
                    const toolbarLogo = document.querySelector("#bricks-toolbar .logo img");
                    if(!toolbarLogo) return
                    toolbarLogo.src = "' . $toolbar_img['url'] . '";
                })', 'after');
            }


            return;
        }
        

        wp_enqueue_script( 'contrast' );
        //wp_enqueue_style( 'bricks-advanced-themer' );
        wp_enqueue_style( 'bricks-advanced-themer-builder' );

        $custom_css = '';

        if(AT__Helpers::is_builder_tweaks_category_activated() && isset($brxc_acf_fields['element_features']) && !empty($brxc_acf_fields['element_features']) && is_array($brxc_acf_fields['element_features']) && in_array('diable-pin-on-elements', $brxc_acf_fields['element_features'])){

            $custom_css .= 'body .bricks-panel #bricks-panel-elements .bricks-panel-actions-icon{display: none !important;}';
        }

        if(AT__Helpers::is_builder_tweaks_category_activated() && isset($brxc_acf_fields['element_features']) && !empty($brxc_acf_fields['element_features']) && is_array($brxc_acf_fields['element_features']) && in_array('increase-field-size', $brxc_acf_fields['element_features'])){

            $custom_css .= '.bricks-panel-controls .control-inline>[data-control=number],.bricks-panel-controls .control-inline>div{flex-basis: 50%!important;max-width:unset;width:unset;flex: unset;}small>div, .bricks-panel-controls .control-small>label{flex: unset!important;}';

        }
        if(AT__Helpers::is_builder_tweaks_category_activated() && isset($brxc_acf_fields['element_features']) && !empty($brxc_acf_fields['element_features']) && is_array($brxc_acf_fields['element_features']) && in_array('class-icons-reveal-on-hover', $brxc_acf_fields['element_features'])){

            $custom_css .= '.active-class>*:not(input){display:none!important;}.active-class:hover>*,.active-class:focus>*{display:flex!important;}';
        }
        
        if(AT__Helpers::is_builder_tweaks_category_activated() && isset($brxc_acf_fields['tab_icons_offset']) ){

            $custom_css .= '#bricks-panel .brxce-panel-shortcut__container{top:'. esc_attr($brxc_acf_fields['tab_icons_offset']) .'px;}';
        }
        wp_add_inline_style('bricks-advanced-themer-builder', $custom_css, 'after');

        if( !function_exists('bricks_is_builder_iframe') || bricks_is_builder_iframe() ) return;
        
        // SASS
        if((isset($brxc_acf_fields['superpowercss-enable-sass']) && $brxc_acf_fields['superpowercss-enable-sass']) || (isset($brxc_acf_fields['advanced_css_enable_sass']) && $brxc_acf_fields['advanced_css_enable_sass'])){
            wp_enqueue_script('sass');
            wp_enqueue_script('sass-worker');
            wp_enqueue_script('sass-sync');
        }
        wp_enqueue_script('recursive-diff');
        wp_enqueue_script('alwan');
        wp_enqueue_script('html2canvas');
        wp_enqueue_style('alwan');
        wp_enqueue_script( 'chroma' );
        wp_enqueue_script('brxc-builder');
        wp_enqueue_script('beautifer-css');
        wp_enqueue_script( 'brxc-builder-new-codemirror');
        wp_enqueue_script( 'brxc-builder-new-codemirror-mode-css', \BRICKS_ADVANCED_THEMER_URL . 'assets/js/codemirror/mode/css/css.js', [], filemtime( \BRICKS_ADVANCED_THEMER_PATH . 'assets/js/codemirror/mode/css/css.js' ) );
        wp_enqueue_script( 'brxc-builder-new-codemirror-mode-javascript', \BRICKS_ADVANCED_THEMER_URL . 'assets/js/codemirror/mode/javascript/javascript.js', [], filemtime( \BRICKS_ADVANCED_THEMER_PATH . 'assets/js/codemirror/mode/javascript/javascript.js' ) );
        //wp_enqueue_script( 'brxc-builder-new-codemirror-mode-sass', \BRICKS_ADVANCED_THEMER_URL . 'assets/js/codemirror/mode/sass/sass.js', [], filemtime( \BRICKS_ADVANCED_THEMER_PATH . 'assets/js/codemirror/mode/sass/sass.js' ) );
        wp_enqueue_script( 'brxc-builder-new-codemirror-addon-dialog', \BRICKS_ADVANCED_THEMER_URL . 'assets/js/codemirror/addon/dialog/dialog.js', [], filemtime( \BRICKS_ADVANCED_THEMER_PATH . 'assets/js/codemirror/addon/dialog/dialog.js' ) );
        wp_enqueue_style( 'brxc-builder-new-codemirror-addon-dialog', \BRICKS_ADVANCED_THEMER_URL . 'assets/js/codemirror/addon/dialog/dialog.css', [], filemtime( \BRICKS_ADVANCED_THEMER_PATH . 'assets/js/codemirror/addon/dialog/dialog.css' ) );
        wp_enqueue_script( 'brxc-builder-new-codemirror-addon-placeholder', \BRICKS_ADVANCED_THEMER_URL . 'assets/js/codemirror/addon/display/placeholder.js', [], filemtime( \BRICKS_ADVANCED_THEMER_PATH . 'assets/js/codemirror/addon/display/placeholder.js' ) );
        wp_enqueue_script( 'brxc-builder-new-codemirror-addon-closeBrackets', \BRICKS_ADVANCED_THEMER_URL . 'assets/js/codemirror/addon/edit/closebrackets.js', [], filemtime( \BRICKS_ADVANCED_THEMER_PATH . 'assets/js/codemirror/addon/edit/closebrackets.js' ) );
        wp_enqueue_script( 'brxc-builder-new-codemirror-addon-matchBrackets', \BRICKS_ADVANCED_THEMER_URL . 'assets/js/codemirror/addon/edit/matchbrackets.js', [], filemtime( \BRICKS_ADVANCED_THEMER_PATH . 'assets/js/codemirror/addon/edit/matchbrackets.js' ) );
        wp_enqueue_style( 'brxc-builder-new-codemirror-addon-hint', \BRICKS_ADVANCED_THEMER_URL . 'assets/js/codemirror/addon/hint/show-hint.css', [], filemtime( \BRICKS_ADVANCED_THEMER_PATH . 'assets/js/codemirror/addon/hint/show-hint.css' ) );
        wp_enqueue_script( 'brxc-builder-new-codemirror-addon-hint', \BRICKS_ADVANCED_THEMER_URL . 'assets/js/codemirror/addon/hint/show-hint.js', [], filemtime( \BRICKS_ADVANCED_THEMER_PATH . 'assets/js/codemirror/addon/hint/show-hint.js' ) );
        wp_enqueue_script( 'brxc-builder-new-codemirror-addon-css-hint', \BRICKS_ADVANCED_THEMER_URL . 'assets/js/codemirror/addon/hint/css-hint.js', [], filemtime( \BRICKS_ADVANCED_THEMER_PATH . 'assets/js/codemirror/addon/hint/css-hint.js' ) );
        wp_enqueue_script( 'brxc-builder-new-codemirror-addon-search', \BRICKS_ADVANCED_THEMER_URL . 'assets/js/codemirror/addon/search/search.js', [], filemtime( \BRICKS_ADVANCED_THEMER_PATH . 'assets/js/codemirror/addon/search/search.js' ) );
        wp_enqueue_script( 'brxc-builder-new-codemirror-addon-searchcursor', \BRICKS_ADVANCED_THEMER_URL . 'assets/js/codemirror/addon/search/searchcursor.js', [], filemtime( \BRICKS_ADVANCED_THEMER_PATH . 'assets/js/codemirror/addon/search/searchcursor.js' ) );
        wp_enqueue_script( 'brxc-builder-new-codemirror-addon-comment', \BRICKS_ADVANCED_THEMER_URL . 'assets/js/codemirror/addon/comment/comment.js', [], filemtime( \BRICKS_ADVANCED_THEMER_PATH . 'assets/js/codemirror/addon/comment/comment.js' ) );
        wp_localize_script( 'brxc-builder', 'openai_ajax_req', array( 'ajax_url' => admin_url( 'admin-ajax.php' ), 'nonce' => wp_create_nonce( 'openai_ajax_nonce' ) ) );
    }

    public static function uninstall_method() {
        $remove_data = get_option('bricks-advanced-themer__brxc_remove_data_uninstall');
    
        if (isset($remove_data) && $remove_data === 1) {
            global $wpdb;
    
            $all_post_ids = get_posts(array(
                'posts_per_page' => -1,
                'post_type'      => 'brxc_color_palette'
            ));
    
            if (isset($all_post_ids) && is_array($all_post_ids)) {
                foreach ($all_post_ids as $post) {
                    wp_delete_post($post->ID, true);
                }
            }
    
            // Delete postmeta data associated with 'brxc_color_palette'
            $result_postmeta = $wpdb->query("DELETE FROM $wpdb->postmeta WHERE post_id IN (SELECT ID FROM $wpdb->posts WHERE post_type = 'brxc_color_palette')");
    
            // Delete options from wp_options table with 'bricks-advanced-themer' in option_name
            $sql = "SELECT option_name FROM $wpdb->options  WHERE option_name LIKE '%bricks-advanced-themer%'";
            $result = $wpdb->get_results($sql, 'ARRAY_A');

            if($result && is_array($result)) {
                foreach($result as $row) {
                    delete_option($row['option_name']);
                }
            }
        }
    }

    // Templates

    public static function enqueue_custom_css_for_bricks_template() {

        global $brxc_acf_fields;

        if( !AT__Helpers::is_builder_tweaks_category_activated() || !isset($brxc_acf_fields['templates_features']) || empty($brxc_acf_fields['templates_features']) || !is_array($brxc_acf_fields['templates_features']) || !in_array('featured-image-in-admin', $brxc_acf_fields['templates_features']) ){
            return;
        }

        global $pagenow;
    
        if ($pagenow === 'edit.php' && isset($_GET['post_type']) && $_GET['post_type'] === 'bricks_template') {
            wp_enqueue_style('template-admin');
        }
    }


    public static function custom_add_image_column($columns) {

        global $brxc_acf_fields;

        if( !AT__Helpers::is_builder_tweaks_category_activated() || !isset($brxc_acf_fields['templates_features']) || empty($brxc_acf_fields['templates_features']) || !is_array($brxc_acf_fields['templates_features']) || !in_array('featured-image-in-admin', $brxc_acf_fields['templates_features']) ){
            return $columns;;
        }

        $new_columns = array();

        foreach ($columns as $key => $value) {
            $new_columns[$key] = $value;

            if ($key === 'title') {
                $new_columns['image'] = 'Featured Image';
            }
        }

        $columns = array_merge($new_columns, $columns);

    return $columns;
    }


    public static function custom_image_column_content($column, $post_id) {

        global $brxc_acf_fields;

        if( !AT__Helpers::is_builder_tweaks_category_activated() || !isset($brxc_acf_fields['templates_features']) || empty($brxc_acf_fields['templates_features']) || !is_array($brxc_acf_fields['templates_features']) || !in_array('featured-image-in-admin', $brxc_acf_fields['templates_features']) ){
            return;
        }

        if ($column === 'image') {

            $thumbnail = get_the_post_thumbnail_url($post_id);

            if ($thumbnail) {
                echo '<img src="' . esc_url($thumbnail) . '" alt="Featured Image" class="brxc-template-img" />';
            } else {
                echo '-';
            }
        }
    }

    public static function custom_image_column_sortable($columns) {

        global $brxc_acf_fields;

        if( !AT__Helpers::is_builder_tweaks_category_activated() || !isset($brxc_acf_fields['templates_features']) || empty($brxc_acf_fields['templates_features']) || !is_array($brxc_acf_fields['templates_features']) || !in_array('featured-image-in-admin', $brxc_acf_fields['templates_features']) ){
            return $columns;
        }

        $columns['image'] = 'image';

        return $columns;
    }

}
